<?php

function array_stripslashes(&$var) {
   if(is_string($var)) {
      $var = stripslashes($var);
   } else {
      if(is_array($var)) {
         foreach($var AS $key => $value) {
            array_stripslashes($var[$key]);
         }
      }
   }
}

function error($message = false) {
   global $ettvd, $tpl;
   if(!$message && empty($ettvd->lasterror)) {
      if(count($ettvd->buffer) > 1) {
         $tpl->assign('stack', implode("\n", $ettvd->buffer));
      }
      $lastline = array_pop($ettvd->buffer);
      $message = substr(strstr($lastline, ' - '), 3);
   }
   $tpl->assign('error', $message);
   $tpl->display('error.tpl');
   exit;
}

function fixetcolors($nick) {
   $nick = str_replace(' ','&nbsp;',$nick);
   $nick = '<span style="color:#777777">' . $nick;
   $search = array('^0', '^1', '^!', '^2', '^3', '^4', '^$', '^5', '^6', '^7', '^&',
                   '^8', '^9', '^q', '^Q', '^w', '^W', '^e', '^E', '^r', '^R', '^t',
                   '^T', '^y', '^Y', '^u', '^U', '^i', '^I', '^o', '^O', '^p', '^P',
                   '^a', '^A', '^s', '^S', '^d', '^D', '^f', '^F', '^g', '^G', '^h',
                   '^H', '^j', '^J', '^k', '^K', '^l', '^L', '^;', '^z', '^Z', '^x',
                   '^X', '^c', '^C', '^v', '^V', '^b', '^B', '^n', '^N', '^m', '^M',
                   '^,', '^.', '^/', '^?', '^-', '^_', '^=', '^\\', '^[', '^]', '^\'',
                   '^*', '^+', '^>');
   $replace = array('</span><span style="color:#000000">', '</span><span style="color:#f70400">', '</span><span style="color:#f70400">', '</span><span style="color:#02f702">', '</span><span style="color:#fdf900">', '</span><span style="color:#0006f8">', '</span><span style="color:#0006f8">', '</span><span style="color:#00f6f3">', '</span><span style="color:#f407f5">', '</span><span style="color:#f9f9f9">', '</span><span style="color:#f9f9f9">',
                    '</span><span style="color:#ff7b06">', '</span><span style="color:#7c7d81">', '</span><span style="color:#f70303">', '</span><span style="color:#f70303">', '</span><span style="color:#f4f6f1">', '</span><span style="color:#f4f6f1">', '</span><span style="color:#8100fd">', '</span><span style="color:#8100fd">', '</span><span style="color:#00f904">', '</span><span style="color:#00f904">', '</span><span style="color:#0005f4">',
                    '</span><span style="color:#0005f4">', '</span><span style="color:#7b7d7a">', '</span><span style="color:#7b7d7a">', '</span><span style="color:#00faf6">', '</span><span style="color:#00faf6">', '</span><span style="color:#fb0033">', '</span><span style="color:#fb0033">', '</span><span style="color:#eff174">', '</span><span style="color:#eff174">', '</span><span style="color:#060702">', '</span><span style="color:#060702">',
                    '</span><span style="color:#fd9534">', '</span><span style="color:#fd9534">', '</span><span style="color:#fbf904">', '</span><span style="color:#fbf904">', '</span><span style="color:#007dfe">', '</span><span style="color:#007dfe">', '</span><span style="color:#3795c8">', '</span><span style="color:#3795c8">', '</span><span style="color:#c2fcc9">', '</span><span style="color:#c2fcc9">', '</span><span style="color:#066432">',
                    '</span><span style="color:#066432">', '</span><span style="color:#ad1c17">', '</span><span style="color:#ad1c17">', '</span><span style="color:#9b3107">', '</span><span style="color:#9b3107">', '</span><span style="color:#cf9834">', '</span><span style="color:#cf9834">', '</span><span style="color:#c0bfc7">', '</span><span style="color:#bcbdc2">', '</span><span style="color:#bcbdc2">', '</span><span style="color:#f98000">',
                    '</span><span style="color:#f98000">', '</span><span style="color:#7b0484">', '</span><span style="color:#7b0484">', '</span><span style="color:#f900f9">', '</span><span style="color:#f900f9">', '</span><span style="color:#037d73">', '</span><span style="color:#037d73">', '</span><span style="color:#faf9c0">', '</span><span style="color:#faf9c0">', '</span><span style="color:#9b9935">', '</span><span style="color:#9b9935">',
                    '</span><span style="color:#cf9a3a">', '</span><span style="color:#f7f8b6">', '</span><span style="color:#fbfc7c">', '</span><span style="color:#770000">', '</span><span style="color:#fbfc7c">', '</span><span style="color:#000099">', '</span><span style="color:#7f7f00">', '</span><span style="color:#007f03">', '</span><span style="color:#b3c0bb">', '</span><span style="color:#7f7c0b">', '</span><span style="color:#c5f9c8">',
                    '</span><span style="color:#ae181a">', '</span><span style="color:#ae181a">', '</span><span style="color:#191959">');

   $nick = str_replace($search, $replace, $nick);

   return $nick . '</span>';
}

function format_demoarray($array) {
   global $datestyle;
   global $reversedemos;
   if($reversedemos) {
      usort($array, 'format_demoarray_id_desc');
   }
   $demos = array();
   foreach($array AS $demo) {
      $demo['time'] = date($datestyle, $demo['time']);
      $demos[] = $demo;
   }
   return $demos;
}

function format_demoarray_id_desc($a, $b) {
   if($a['id'] < $b['id']) return true;
   return false;
}

function microtime_float() {
   list($usec, $sec) = explode(' ', microtime());
   return ((float)$usec + (float)$sec);
}

function send($url) {
   Header('Location: '.$url);
   exit;
}

?>