package etstatistics;

import java.awt.Color;
import java.io.IOException;
import javax.swing.JPanel;
import static etstatistics.ETStatistics.*;

/**
 * JWeaponPanel.java
 *
 * Created on 14. February 2010
 * @author Anthales
 */
public class JWeaponPanel extends JPanel {

	/** Liste aller Waffennamen */
	private static final String PATH = "pics/";
	private static final String[][] WEAPON_IMAGES = {
		{"knife.jpg"},
		{"luger.jpg"},	{"colt.jpg"},
		{"mp40.jpg"},	{"thompson.jpg"},

		{"k43_silenced.jpg", "k43_and_gpg40_granatwerfer.jpg"},
		{"mg1_garand_silenced.jpg", "m1_garand_and_m7_grenade_launcher.jpg"},
		{"sten.jpg"},
		{"fg42.jpg"},

		{"axis_grenade.jpg", "allied_grenade.jpg"},
		{"k43_and_gpg40_granatwerfer.jpg", "m1_garand_and_m7_grenade_launcher.jpg"},
		{"land_mine.jpg"},
		{"satchel.jpg"},

		{"panzerfaust.jpg"},
		{"mortar.jpg"},
		{"mg42.jpg"},
		{"flamer.jpg"},

		{"smoke_grenade.jpg"}, //Airstrike
		{"binoculars.jpg"}, //Artillery

		{"dynamite.jpg"},
		{"revive.jpg"}, //Syringe
		{"smoke_grenade.jpg"}
	};

	static {
		for (int i = 0; i < WEAPON_IMAGES.length; i++)
			for (int j = 0; j < WEAPON_IMAGES[i].length; j++)
				WEAPON_IMAGES[i][j] = PATH + WEAPON_IMAGES[i][j];
	}

	private String[] getImagePath(String weaponName) {
		for (int i = 0; i < WEAPON_COUNT; i++)
			if (getWeapon(i).equalsIgnoreCase(weaponName))
				return WEAPON_IMAGES[i];
		return null;
	}

    public JWeaponPanel(WeaponStatistic ws) throws IOException {
        initComponents();
		jImage.init(getImagePath(ws.weaponName), Color.WHITE);
		jlAccuracy.setText("Accuracy: " + roundCurrency(ws.acc) + "%");
		jlHeadshotrate.setText("Headshotrate: " + roundCurrency(ws.headAcc) + "%");
		jlShots.setText("Shots: " + ws.shots);
		jlKills.setText("Kills: " + ws.kills);
		jlHits.setText("Hits: " + ws.hits);
		jlDeaths.setText("Deaths: " + ws.deaths);
		jlHeadshots.setText("Headshots: " + ws.headshots);
		jlName.setText(ws.weaponName);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jlAccuracy = new javax.swing.JLabel();
        jlHeadshotrate = new javax.swing.JLabel();
        jlShots = new javax.swing.JLabel();
        jlKills = new javax.swing.JLabel();
        jlHits = new javax.swing.JLabel();
        jlDeaths = new javax.swing.JLabel();
        jlHeadshots = new javax.swing.JLabel();
        jlName = new javax.swing.JLabel();
        jImage = new JVerticalImageList();

        jlAccuracy.setText("jlAccuracy");

        jlHeadshotrate.setText("jlHeadshotrate");

        jlShots.setText("jlShots");

        jlKills.setText("jlKills");

        jlHits.setText("jlHits");

        jlDeaths.setText("jlDeaths");

        jlHeadshots.setText("jlHeadshots");

        jlName.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jlName.setText("jlName");

        javax.swing.GroupLayout jImageLayout = new javax.swing.GroupLayout(jImage);
        jImage.setLayout(jImageLayout);
        jImageLayout.setHorizontalGroup(
            jImageLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 100, Short.MAX_VALUE)
        );
        jImageLayout.setVerticalGroup(
            jImageLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 100, Short.MAX_VALUE)
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(jlName, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jImage, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jlHeadshotrate, javax.swing.GroupLayout.DEFAULT_SIZE, 200, Short.MAX_VALUE)
                    .addComponent(jlAccuracy, javax.swing.GroupLayout.DEFAULT_SIZE, 200, Short.MAX_VALUE)
                    .addComponent(jlShots, javax.swing.GroupLayout.DEFAULT_SIZE, 200, Short.MAX_VALUE)
                    .addComponent(jlHits, javax.swing.GroupLayout.DEFAULT_SIZE, 200, Short.MAX_VALUE)
                    .addComponent(jlKills, javax.swing.GroupLayout.DEFAULT_SIZE, 200, Short.MAX_VALUE)
                    .addComponent(jlDeaths, javax.swing.GroupLayout.DEFAULT_SIZE, 200, Short.MAX_VALUE)
                    .addComponent(jlHeadshots, javax.swing.GroupLayout.DEFAULT_SIZE, 200, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jlAccuracy)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jlHeadshotrate)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jlShots)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jlHits, javax.swing.GroupLayout.PREFERRED_SIZE, 14, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jlKills, javax.swing.GroupLayout.PREFERRED_SIZE, 14, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jlDeaths, javax.swing.GroupLayout.PREFERRED_SIZE, 14, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jlHeadshots, javax.swing.GroupLayout.PREFERRED_SIZE, 14, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jImage, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jlName)))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private JVerticalImageList jImage;
    private javax.swing.JLabel jlAccuracy;
    private javax.swing.JLabel jlDeaths;
    private javax.swing.JLabel jlHeadshotrate;
    private javax.swing.JLabel jlHeadshots;
    private javax.swing.JLabel jlHits;
    private javax.swing.JLabel jlKills;
    private javax.swing.JLabel jlName;
    private javax.swing.JLabel jlShots;
    // End of variables declaration//GEN-END:variables
}
