package etstatistics;

/**
ET-Statistics
Copyright © 2009-10  Anthales

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

import external.WrapLayout;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import static etstatistics.ETStatistics.roundCurrency;

/**
 * ETStatisticsGUI.java
 *
 * Created on 14. February 2010
 * @author Anthales
 */
public class ETStatisticsGUI extends javax.swing.JFrame {

	private static final String ABOUT =
		"ET-Statistics RC2.2\n" +
		"Copyright © 2009-10  Anthales\n" +
		"http://anthales.de.vu";

	private ETStatistics etStat;
	private JPanel jpStat;

    public ETStatisticsGUI() {
        initComponents();

		setSize(805, 565);
		Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
		setLocation(
			(screen.width - getSize().width) / 2,
			(screen.height - getSize().height) / 2);

		jpStat = new JPanel();
		jpStat.setOpaque(false);
		jpStat.setLayout(new WrapLayout());

		jspWeaponstats.setViewportView(jpStat);
		jspWeaponstats.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
		jspWeaponstats.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);

		setContentPane(jTabbedPane);
		etStat = new ETStatistics();
    }

	public File saveDialog(String fileName) {
		JFileChooser fc = new JFileChooser();
		fc.setSelectedFile(new File(fileName));

		if (fc.showSaveDialog(this) == JFileChooser.APPROVE_OPTION) {
			if (fc.getSelectedFile().exists()) {
				if (JOptionPane.showConfirmDialog(null,
						"File already exists, should it be overwritten?") == 0) {
					return fc.getSelectedFile();
				}
			} else {
				return fc.getSelectedFile();
			}
		}

		return null;
	}

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jTabbedPane = new javax.swing.JTabbedPane();
        jspGeneralStats = new javax.swing.JScrollPane();
        jpGeneralStats = new javax.swing.JPanel();
        jlRounds = new javax.swing.JLabel();
        jlDmgGiven = new javax.swing.JLabel();
        jlDmgReceived = new javax.swing.JLabel();
        jlDmgQuote = new javax.swing.JLabel();
        jlTeamDmgQuote = new javax.swing.JLabel();
        jlTeamDmgReceived = new javax.swing.JLabel();
        jlTeamDmgGiven = new javax.swing.JLabel();
        jlDeath = new javax.swing.JLabel();
        jlKills = new javax.swing.JLabel();
        jlGibs = new javax.swing.JLabel();
        jlEffiency = new javax.swing.JLabel();
        jlTeamDmgQuote1 = new javax.swing.JLabel();
        jlRounds1 = new javax.swing.JLabel();
        jlKills1 = new javax.swing.JLabel();
        jlGibs1 = new javax.swing.JLabel();
        jlDmgQuote1 = new javax.swing.JLabel();
        jlEffiency1 = new javax.swing.JLabel();
        jlDmgReceived1 = new javax.swing.JLabel();
        jlDmgGiven1 = new javax.swing.JLabel();
        jlDeath1 = new javax.swing.JLabel();
        jlTeamDmgReceived1 = new javax.swing.JLabel();
        jlTeamDmgGiven1 = new javax.swing.JLabel();
        jspWeaponstats = new javax.swing.JScrollPane();
        jMenuBar = new javax.swing.JMenuBar();
        jmFile = new javax.swing.JMenu();
        jmiOpen = new javax.swing.JMenuItem();
        jmiSave = new javax.swing.JMenuItem();
        jmiQuit = new javax.swing.JMenuItem();
        jmHelp = new javax.swing.JMenu();
        jmiHelp = new javax.swing.JMenuItem();
        jmiAbout = new javax.swing.JMenuItem();

        FormListener formListener = new FormListener();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("ET-Statistics RC2.2 ©Anthales");

        jlRounds.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
        jlRounds.setText("...");

        jlDmgGiven.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
        jlDmgGiven.setText("...");

        jlDmgReceived.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
        jlDmgReceived.setText("...");

        jlDmgQuote.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
        jlDmgQuote.setText("...");

        jlTeamDmgQuote.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
        jlTeamDmgQuote.setText("...");

        jlTeamDmgReceived.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
        jlTeamDmgReceived.setText("...");

        jlTeamDmgGiven.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
        jlTeamDmgGiven.setText("...");

        jlDeath.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
        jlDeath.setText("...");

        jlKills.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
        jlKills.setText("...");

        jlGibs.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
        jlGibs.setText("...");

        jlEffiency.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
        jlEffiency.setText("...");

        jlTeamDmgQuote1.setText("Team damage quote:");

        jlRounds1.setText("Rounds:");

        jlKills1.setText("Kills:");

        jlGibs1.setText("Gibs:");

        jlDmgQuote1.setText("Damage quote:");

        jlEffiency1.setText("Effiency:");

        jlDmgReceived1.setText("Received damage:");

        jlDmgGiven1.setText("Given damage:");

        jlDeath1.setText("Deaths:");

        jlTeamDmgReceived1.setText("Received team damage:");

        jlTeamDmgGiven1.setText("Given team damage:");

        javax.swing.GroupLayout jpGeneralStatsLayout = new javax.swing.GroupLayout(jpGeneralStats);
        jpGeneralStats.setLayout(jpGeneralStatsLayout);
        jpGeneralStatsLayout.setHorizontalGroup(
            jpGeneralStatsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jpGeneralStatsLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jpGeneralStatsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jlTeamDmgQuote1, javax.swing.GroupLayout.PREFERRED_SIZE, 160, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jlTeamDmgReceived1, javax.swing.GroupLayout.PREFERRED_SIZE, 160, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jlTeamDmgGiven1, javax.swing.GroupLayout.PREFERRED_SIZE, 160, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jlDeath1, javax.swing.GroupLayout.PREFERRED_SIZE, 160, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jlKills1, javax.swing.GroupLayout.PREFERRED_SIZE, 160, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jlGibs1, javax.swing.GroupLayout.PREFERRED_SIZE, 160, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jlEffiency1, javax.swing.GroupLayout.PREFERRED_SIZE, 160, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jlDmgQuote1, javax.swing.GroupLayout.PREFERRED_SIZE, 160, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jlDmgReceived1, javax.swing.GroupLayout.PREFERRED_SIZE, 160, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jlDmgGiven1, javax.swing.GroupLayout.PREFERRED_SIZE, 160, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jlRounds1, javax.swing.GroupLayout.PREFERRED_SIZE, 160, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jpGeneralStatsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jlTeamDmgQuote, javax.swing.GroupLayout.PREFERRED_SIZE, 96, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jlTeamDmgReceived, javax.swing.GroupLayout.PREFERRED_SIZE, 96, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jlTeamDmgGiven, javax.swing.GroupLayout.PREFERRED_SIZE, 96, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jlDeath, javax.swing.GroupLayout.PREFERRED_SIZE, 96, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jlKills, javax.swing.GroupLayout.PREFERRED_SIZE, 96, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jlGibs, javax.swing.GroupLayout.PREFERRED_SIZE, 96, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jlEffiency, javax.swing.GroupLayout.PREFERRED_SIZE, 96, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jlDmgQuote, javax.swing.GroupLayout.PREFERRED_SIZE, 96, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jlDmgReceived, javax.swing.GroupLayout.PREFERRED_SIZE, 96, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jlDmgGiven, javax.swing.GroupLayout.PREFERRED_SIZE, 96, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jlRounds, javax.swing.GroupLayout.PREFERRED_SIZE, 96, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(219, Short.MAX_VALUE))
        );
        jpGeneralStatsLayout.setVerticalGroup(
            jpGeneralStatsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jpGeneralStatsLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jpGeneralStatsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(jpGeneralStatsLayout.createSequentialGroup()
                        .addComponent(jlRounds)
                        .addGap(18, 18, 18)
                        .addComponent(jlDmgGiven)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jlDmgReceived)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jlDmgQuote)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jlTeamDmgGiven)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jlTeamDmgReceived)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jlTeamDmgQuote)
                        .addGap(18, 18, 18)
                        .addComponent(jlGibs)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jlKills)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jlDeath)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jlEffiency))
                    .addGroup(jpGeneralStatsLayout.createSequentialGroup()
                        .addComponent(jlRounds1)
                        .addGap(18, 18, 18)
                        .addComponent(jlDmgGiven1)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jlDmgReceived1)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jlDmgQuote1)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jlTeamDmgGiven1)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jlTeamDmgReceived1)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jlTeamDmgQuote1)
                        .addGap(18, 18, 18)
                        .addComponent(jlGibs1)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jlKills1)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jlDeath1)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jlEffiency1)))
                .addContainerGap(90, Short.MAX_VALUE))
        );

        jspGeneralStats.setViewportView(jpGeneralStats);

        jTabbedPane.addTab("General", jspGeneralStats);
        jTabbedPane.addTab("Weapons", jspWeaponstats);

        jmFile.setText("File");

        jmiOpen.setText("Open stats folder");
        jmiOpen.addActionListener(formListener);
        jmFile.add(jmiOpen);

        jmiSave.setText("Save statistic");
        jmiSave.addActionListener(formListener);
        jmFile.add(jmiSave);

        jmiQuit.setText("Quit");
        jmiQuit.addActionListener(formListener);
        jmFile.add(jmiQuit);

        jMenuBar.add(jmFile);

        jmHelp.setText("Help");

        jmiHelp.setText("Usage");
        jmiHelp.addActionListener(formListener);
        jmHelp.add(jmiHelp);

        jmiAbout.setText("About");
        jmiAbout.addActionListener(formListener);
        jmHelp.add(jmiAbout);

        jMenuBar.add(jmHelp);

        setJMenuBar(jMenuBar);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jTabbedPane, javax.swing.GroupLayout.DEFAULT_SIZE, 500, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jTabbedPane, javax.swing.GroupLayout.DEFAULT_SIZE, 373, Short.MAX_VALUE)
        );

        pack();
    }

    // Code for dispatching events from components to event handlers.

    private class FormListener implements java.awt.event.ActionListener {
        FormListener() {}
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            if (evt.getSource() == jmiOpen) {
                ETStatisticsGUI.this.jmiOpenActionPerformed(evt);
            }
            else if (evt.getSource() == jmiSave) {
                ETStatisticsGUI.this.jmiSaveActionPerformed(evt);
            }
            else if (evt.getSource() == jmiQuit) {
                ETStatisticsGUI.this.jmiQuitActionPerformed(evt);
            }
            else if (evt.getSource() == jmiHelp) {
                ETStatisticsGUI.this.jmiHelpActionPerformed(evt);
            }
            else if (evt.getSource() == jmiAbout) {
                ETStatisticsGUI.this.jmiAboutActionPerformed(evt);
            }
        }
    }// </editor-fold>//GEN-END:initComponents

	private void jmiOpenActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jmiOpenActionPerformed
		JFileChooser fc = new JFileChooser();
		fc.setDialogTitle("Choose \"stats\" directory");
		fc.setCurrentDirectory(new File("./etpro/stats"));
		fc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);

		if (fc.showOpenDialog(this) == JFileChooser.APPROVE_OPTION) {
			try {
				File f = fc.getSelectedFile();

				File[] files = f.listFiles();
				if (files == null) {
					JOptionPane.showMessageDialog(null,
						"Couldn't find statistics in current directory.",
						"Wrong directory", JOptionPane.WARNING_MESSAGE);
					return;
				}

				//Iterate through found directories
				for (int i = 0; i < files.length; i++) {
					if (files[i].isDirectory()) {
						//Iterate trough files, contained in directory
						File subfiles[] = files[i].listFiles();
						for (int j = 0; j < subfiles.length; j++) {
							if (subfiles[j].isFile()) {
								try {
									etStat.add(subfiles[j]); //Try to parse the files
								} catch (StringIndexOutOfBoundsException e) {
									JOptionPane.showMessageDialog(null,
										"Couldn't parse file " + subfiles[j] + ": \n"
										+ e.getMessage().toString() + "\nWrong directory?",
										"Error while parsing", JOptionPane.ERROR_MESSAGE);
									return;
								}
							}
						}
					}
				}

				//Calculate unified statistic
				etStat.calculate();
				Statistic s = etStat.getFinalStat();

				jpStat.setIgnoreRepaint(true);
				jpStat.setVisible(false);

				jlRounds.setText(String.valueOf(s.rounds));
				jlDmgGiven.setText(String.valueOf(s.damageGiven));
				jlDmgReceived.setText(String.valueOf(s.damageReceived));
				jlDmgQuote.setText(roundCurrency((s.damageGiven * 100d) / s.damageReceived) + "%");
				jlTeamDmgGiven.setText(String.valueOf(s.teamDamageGiven));
				jlTeamDmgReceived.setText(String.valueOf(s.teamDamageReceived));
				jlTeamDmgQuote.setText(roundCurrency((s.teamDamageGiven * 100d) / s.teamDamageReceived) + "%");
				jlGibs.setText(String.valueOf(s.gibs));
				jlKills.setText(String.valueOf(s.kills));
				jlDeath.setText(String.valueOf(s.deaths));
				jlEffiency.setText(roundCurrency(s.eff * 100d) + "%");

				jpStat.removeAll();
				Iterator<WeaponStatistic> it = s.weaponStats.iterator();
				while (it.hasNext())
					jpStat.add(new JWeaponPanel(it.next()));

				jpStat.setIgnoreRepaint(false);
				jpStat.setVisible(true);
			} catch (IOException ex) {
				JOptionPane.showMessageDialog(this,
					ex.getMessage().toString(),
					"Error opening files", JOptionPane.ERROR_MESSAGE);
			}
		}
	}//GEN-LAST:event_jmiOpenActionPerformed

	private void jmiSaveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jmiSaveActionPerformed
		try {
			File f = saveDialog("statistics.txt");
			if (f != null)
				etStat.outputFinalStat(f);
		} catch (IOException ex) {
			JOptionPane.showMessageDialog(this,
				"statistics couldn't be saved: " + ex.getMessage(),
				"Couldn't save statistics", JOptionPane.ERROR_MESSAGE);
		}
	}//GEN-LAST:event_jmiSaveActionPerformed

	private void jmiQuitActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jmiQuitActionPerformed
		System.exit(0);
	}//GEN-LAST:event_jmiQuitActionPerformed

	private void jmiHelpActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jmiHelpActionPerformed
		JOptionPane.showMessageDialog(this,
			"You have to choose the \"stats\"-directory in your Enemy Territory dir.\n" +
				"The path will usually look like ..." +
				File.separator + "Enemy Territory" + File.separator +
				"etpro" + File.separator +"stats\n" +
				"ET-Statistics will then generate an unified statistic of all the " +
				"specific stastistics.\n",
			"Help", JOptionPane.INFORMATION_MESSAGE);
	}//GEN-LAST:event_jmiHelpActionPerformed

	private void jmiAboutActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jmiAboutActionPerformed
		JOptionPane.showMessageDialog(this, ABOUT, "About", JOptionPane.INFORMATION_MESSAGE);
	}//GEN-LAST:event_jmiAboutActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JMenuBar jMenuBar;
    private javax.swing.JTabbedPane jTabbedPane;
    private javax.swing.JLabel jlDeath;
    private javax.swing.JLabel jlDeath1;
    private javax.swing.JLabel jlDmgGiven;
    private javax.swing.JLabel jlDmgGiven1;
    private javax.swing.JLabel jlDmgQuote;
    private javax.swing.JLabel jlDmgQuote1;
    private javax.swing.JLabel jlDmgReceived;
    private javax.swing.JLabel jlDmgReceived1;
    private javax.swing.JLabel jlEffiency;
    private javax.swing.JLabel jlEffiency1;
    private javax.swing.JLabel jlGibs;
    private javax.swing.JLabel jlGibs1;
    private javax.swing.JLabel jlKills;
    private javax.swing.JLabel jlKills1;
    private javax.swing.JLabel jlRounds;
    private javax.swing.JLabel jlRounds1;
    private javax.swing.JLabel jlTeamDmgGiven;
    private javax.swing.JLabel jlTeamDmgGiven1;
    private javax.swing.JLabel jlTeamDmgQuote;
    private javax.swing.JLabel jlTeamDmgQuote1;
    private javax.swing.JLabel jlTeamDmgReceived;
    private javax.swing.JLabel jlTeamDmgReceived1;
    private javax.swing.JMenu jmFile;
    private javax.swing.JMenu jmHelp;
    private javax.swing.JMenuItem jmiAbout;
    private javax.swing.JMenuItem jmiHelp;
    private javax.swing.JMenuItem jmiOpen;
    private javax.swing.JMenuItem jmiQuit;
    private javax.swing.JMenuItem jmiSave;
    private javax.swing.JPanel jpGeneralStats;
    private javax.swing.JScrollPane jspGeneralStats;
    private javax.swing.JScrollPane jspWeaponstats;
    // End of variables declaration//GEN-END:variables

	public static void main(String args[]) throws IOException {
		if (args.length == 0) {
			java.awt.EventQueue.invokeLater(new Runnable() {
				public void run() {
					new ETStatisticsGUI().setVisible(true);
				}
			});
			return;
		}

		long start = System.currentTimeMillis();
		ETStatistics etStat = new ETStatistics();

		File dir = new File(args[0] + "/etpro/stats");
		File files[] = dir.listFiles();

		//Iterate through found directories
		for (int i = 0; i < files.length; i++) {
			if (files[i].isDirectory()) {
				//Iterate trough files, contained in directory
				File subfiles[] = files[i].listFiles();
				for (int j = 0; j < subfiles.length; j++)
					if (subfiles[j].isFile())
						etStat.add(subfiles[j]); //Try to parse the files
			}
		}

		etStat.calculate();
		//etStat.outputStats(new File("statistics.txt"));
		etStat.outputFinalStat(new File("statistic.txt"));

		System.out.println("done after " +
			(System.currentTimeMillis() - start) + " ms");
	}

}
