/*
 * Decompiled with CFR 0.152.
 */
package etstatistics;

import etstatistics.ETStatistics;
import etstatistics.JWeaponPanel;
import etstatistics.Statistic;
import etstatistics.WeaponStatistic;
import external.WrapLayout;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.swing.GroupLayout;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;

public class ETStatisticsGUI
extends JFrame {
    private static final String ABOUT = "ET-Statistics RC2.2\nCopyright \u00a9 2009-10  Anthales\nhttp://anthales.de.vu";
    private ETStatistics etStat;
    private JPanel jpStat;
    private JMenuBar jMenuBar;
    private JTabbedPane jTabbedPane;
    private JLabel jlDeath;
    private JLabel jlDeath1;
    private JLabel jlDmgGiven;
    private JLabel jlDmgGiven1;
    private JLabel jlDmgQuote;
    private JLabel jlDmgQuote1;
    private JLabel jlDmgReceived;
    private JLabel jlDmgReceived1;
    private JLabel jlEffiency;
    private JLabel jlEffiency1;
    private JLabel jlGibs;
    private JLabel jlGibs1;
    private JLabel jlKills;
    private JLabel jlKills1;
    private JLabel jlRounds;
    private JLabel jlRounds1;
    private JLabel jlTeamDmgGiven;
    private JLabel jlTeamDmgGiven1;
    private JLabel jlTeamDmgQuote;
    private JLabel jlTeamDmgQuote1;
    private JLabel jlTeamDmgReceived;
    private JLabel jlTeamDmgReceived1;
    private JMenu jmFile;
    private JMenu jmHelp;
    private JMenuItem jmiAbout;
    private JMenuItem jmiHelp;
    private JMenuItem jmiOpen;
    private JMenuItem jmiQuit;
    private JMenuItem jmiSave;
    private JPanel jpGeneralStats;
    private JScrollPane jspGeneralStats;
    private JScrollPane jspWeaponstats;

    public ETStatisticsGUI() {
        this.initComponents();
        this.setSize(805, 565);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screen.width - this.getSize().width) / 2, (screen.height - this.getSize().height) / 2);
        this.jpStat = new JPanel();
        this.jpStat.setOpaque(false);
        this.jpStat.setLayout(new WrapLayout());
        this.jspWeaponstats.setViewportView(this.jpStat);
        this.jspWeaponstats.setHorizontalScrollBarPolicy(31);
        this.jspWeaponstats.setVerticalScrollBarPolicy(20);
        this.setContentPane(this.jTabbedPane);
        this.etStat = new ETStatistics();
    }

    public File saveDialog(String fileName) {
        JFileChooser fc = new JFileChooser();
        fc.setSelectedFile(new File(fileName));
        if (fc.showSaveDialog(this) == 0) {
            if (fc.getSelectedFile().exists()) {
                if (JOptionPane.showConfirmDialog(null, "File already exists, should it be overwritten?") == 0) {
                    return fc.getSelectedFile();
                }
            } else {
                return fc.getSelectedFile();
            }
        }
        return null;
    }

    private void initComponents() {
        this.jTabbedPane = new JTabbedPane();
        this.jspGeneralStats = new JScrollPane();
        this.jpGeneralStats = new JPanel();
        this.jlRounds = new JLabel();
        this.jlDmgGiven = new JLabel();
        this.jlDmgReceived = new JLabel();
        this.jlDmgQuote = new JLabel();
        this.jlTeamDmgQuote = new JLabel();
        this.jlTeamDmgReceived = new JLabel();
        this.jlTeamDmgGiven = new JLabel();
        this.jlDeath = new JLabel();
        this.jlKills = new JLabel();
        this.jlGibs = new JLabel();
        this.jlEffiency = new JLabel();
        this.jlTeamDmgQuote1 = new JLabel();
        this.jlRounds1 = new JLabel();
        this.jlKills1 = new JLabel();
        this.jlGibs1 = new JLabel();
        this.jlDmgQuote1 = new JLabel();
        this.jlEffiency1 = new JLabel();
        this.jlDmgReceived1 = new JLabel();
        this.jlDmgGiven1 = new JLabel();
        this.jlDeath1 = new JLabel();
        this.jlTeamDmgReceived1 = new JLabel();
        this.jlTeamDmgGiven1 = new JLabel();
        this.jspWeaponstats = new JScrollPane();
        this.jMenuBar = new JMenuBar();
        this.jmFile = new JMenu();
        this.jmiOpen = new JMenuItem();
        this.jmiSave = new JMenuItem();
        this.jmiQuit = new JMenuItem();
        this.jmHelp = new JMenu();
        this.jmiHelp = new JMenuItem();
        this.jmiAbout = new JMenuItem();
        FormListener formListener = new FormListener();
        this.setDefaultCloseOperation(3);
        this.setTitle("ET-Statistics RC2.2 \u00a9Anthales");
        this.jlRounds.setHorizontalAlignment(11);
        this.jlRounds.setText("...");
        this.jlDmgGiven.setHorizontalAlignment(11);
        this.jlDmgGiven.setText("...");
        this.jlDmgReceived.setHorizontalAlignment(11);
        this.jlDmgReceived.setText("...");
        this.jlDmgQuote.setHorizontalAlignment(11);
        this.jlDmgQuote.setText("...");
        this.jlTeamDmgQuote.setHorizontalAlignment(11);
        this.jlTeamDmgQuote.setText("...");
        this.jlTeamDmgReceived.setHorizontalAlignment(11);
        this.jlTeamDmgReceived.setText("...");
        this.jlTeamDmgGiven.setHorizontalAlignment(11);
        this.jlTeamDmgGiven.setText("...");
        this.jlDeath.setHorizontalAlignment(11);
        this.jlDeath.setText("...");
        this.jlKills.setHorizontalAlignment(11);
        this.jlKills.setText("...");
        this.jlGibs.setHorizontalAlignment(11);
        this.jlGibs.setText("...");
        this.jlEffiency.setHorizontalAlignment(11);
        this.jlEffiency.setText("...");
        this.jlTeamDmgQuote1.setText("Team damage quote:");
        this.jlRounds1.setText("Rounds:");
        this.jlKills1.setText("Kills:");
        this.jlGibs1.setText("Gibs:");
        this.jlDmgQuote1.setText("Damage quote:");
        this.jlEffiency1.setText("Effiency:");
        this.jlDmgReceived1.setText("Received damage:");
        this.jlDmgGiven1.setText("Given damage:");
        this.jlDeath1.setText("Deaths:");
        this.jlTeamDmgReceived1.setText("Received team damage:");
        this.jlTeamDmgGiven1.setText("Given team damage:");
        GroupLayout jpGeneralStatsLayout = new GroupLayout(this.jpGeneralStats);
        this.jpGeneralStats.setLayout(jpGeneralStatsLayout);
        jpGeneralStatsLayout.setHorizontalGroup(jpGeneralStatsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jpGeneralStatsLayout.createSequentialGroup().addContainerGap().addGroup(jpGeneralStatsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jlTeamDmgQuote1, -2, 160, -2).addComponent(this.jlTeamDmgReceived1, -2, 160, -2).addComponent(this.jlTeamDmgGiven1, -2, 160, -2).addComponent(this.jlDeath1, -2, 160, -2).addComponent(this.jlKills1, -2, 160, -2).addComponent(this.jlGibs1, -2, 160, -2).addComponent(this.jlEffiency1, -2, 160, -2).addComponent(this.jlDmgQuote1, -2, 160, -2).addComponent(this.jlDmgReceived1, -2, 160, -2).addComponent(this.jlDmgGiven1, -2, 160, -2).addComponent(this.jlRounds1, -2, 160, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jpGeneralStatsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jlTeamDmgQuote, -2, 96, -2).addComponent(this.jlTeamDmgReceived, -2, 96, -2).addComponent(this.jlTeamDmgGiven, -2, 96, -2).addComponent(this.jlDeath, -2, 96, -2).addComponent(this.jlKills, -2, 96, -2).addComponent(this.jlGibs, -2, 96, -2).addComponent(this.jlEffiency, -2, 96, -2).addComponent(this.jlDmgQuote, -2, 96, -2).addComponent(this.jlDmgReceived, -2, 96, -2).addComponent(this.jlDmgGiven, -2, 96, -2).addComponent(this.jlRounds, -2, 96, -2)).addContainerGap(219, Short.MAX_VALUE)));
        jpGeneralStatsLayout.setVerticalGroup(jpGeneralStatsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jpGeneralStatsLayout.createSequentialGroup().addContainerGap().addGroup(jpGeneralStatsLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jpGeneralStatsLayout.createSequentialGroup().addComponent(this.jlRounds).addGap(18, 18, 18).addComponent(this.jlDmgGiven).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jlDmgReceived).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jlDmgQuote).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jlTeamDmgGiven).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jlTeamDmgReceived).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jlTeamDmgQuote).addGap(18, 18, 18).addComponent(this.jlGibs).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jlKills).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jlDeath).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jlEffiency)).addGroup(jpGeneralStatsLayout.createSequentialGroup().addComponent(this.jlRounds1).addGap(18, 18, 18).addComponent(this.jlDmgGiven1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jlDmgReceived1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jlDmgQuote1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jlTeamDmgGiven1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jlTeamDmgReceived1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jlTeamDmgQuote1).addGap(18, 18, 18).addComponent(this.jlGibs1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jlKills1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jlDeath1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jlEffiency1))).addContainerGap(90, Short.MAX_VALUE)));
        this.jspGeneralStats.setViewportView(this.jpGeneralStats);
        this.jTabbedPane.addTab("General", this.jspGeneralStats);
        this.jTabbedPane.addTab("Weapons", this.jspWeaponstats);
        this.jmFile.setText("File");
        this.jmiOpen.setText("Open stats folder");
        this.jmiOpen.addActionListener(formListener);
        this.jmFile.add(this.jmiOpen);
        this.jmiSave.setText("Save statistic");
        this.jmiSave.addActionListener(formListener);
        this.jmFile.add(this.jmiSave);
        this.jmiQuit.setText("Quit");
        this.jmiQuit.addActionListener(formListener);
        this.jmFile.add(this.jmiQuit);
        this.jMenuBar.add(this.jmFile);
        this.jmHelp.setText("Help");
        this.jmiHelp.setText("Usage");
        this.jmiHelp.addActionListener(formListener);
        this.jmHelp.add(this.jmiHelp);
        this.jmiAbout.setText("About");
        this.jmiAbout.addActionListener(formListener);
        this.jmHelp.add(this.jmiAbout);
        this.jMenuBar.add(this.jmHelp);
        this.setJMenuBar(this.jMenuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane, -1, 500, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane, -1, 373, Short.MAX_VALUE));
        this.pack();
    }

    private void jmiOpenActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle("Choose \"stats\" directory");
        fc.setCurrentDirectory(new File("./etpro/stats"));
        fc.setFileSelectionMode(1);
        if (fc.showOpenDialog(this) == 0) {
            try {
                File f = fc.getSelectedFile();
                File[] files = f.listFiles();
                if (files == null) {
                    JOptionPane.showMessageDialog(null, "Couldn't find statistics in current directory.", "Wrong directory", 2);
                    return;
                }
                for (int i = 0; i < files.length; ++i) {
                    if (!files[i].isDirectory()) continue;
                    File[] subfiles = files[i].listFiles();
                    for (int j = 0; j < subfiles.length; ++j) {
                        if (!subfiles[j].isFile()) continue;
                        try {
                            this.etStat.add(subfiles[j]);
                            continue;
                        }
                        catch (StringIndexOutOfBoundsException e) {
                            JOptionPane.showMessageDialog(null, "Couldn't parse file " + subfiles[j] + ": \n" + e.getMessage().toString() + "\nWrong directory?", "Error while parsing", 0);
                            return;
                        }
                    }
                }
                this.etStat.calculate();
                Statistic s = this.etStat.getFinalStat();
                this.jpStat.setIgnoreRepaint(true);
                this.jpStat.setVisible(false);
                this.jlRounds.setText(String.valueOf(s.rounds));
                this.jlDmgGiven.setText(String.valueOf(s.damageGiven));
                this.jlDmgReceived.setText(String.valueOf(s.damageReceived));
                this.jlDmgQuote.setText(ETStatistics.roundCurrency((double)s.damageGiven * 100.0 / (double)s.damageReceived) + "%");
                this.jlTeamDmgGiven.setText(String.valueOf(s.teamDamageGiven));
                this.jlTeamDmgReceived.setText(String.valueOf(s.teamDamageReceived));
                this.jlTeamDmgQuote.setText(ETStatistics.roundCurrency((double)s.teamDamageGiven * 100.0 / (double)s.teamDamageReceived) + "%");
                this.jlGibs.setText(String.valueOf(s.gibs));
                this.jlKills.setText(String.valueOf(s.kills));
                this.jlDeath.setText(String.valueOf(s.deaths));
                this.jlEffiency.setText(ETStatistics.roundCurrency(s.eff * 100.0) + "%");
                this.jpStat.removeAll();
                Iterator<WeaponStatistic> it = s.weaponStats.iterator();
                while (it.hasNext()) {
                    this.jpStat.add(new JWeaponPanel(it.next()));
                }
                this.jpStat.setIgnoreRepaint(false);
                this.jpStat.setVisible(true);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, ex.getMessage().toString(), "Error opening files", 0);
            }
        }
    }

    private void jmiSaveActionPerformed(ActionEvent evt) {
        try {
            File f = this.saveDialog("statistics.txt");
            if (f != null) {
                this.etStat.outputFinalStat(f);
            }
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "statistics couldn't be saved: " + ex.getMessage(), "Couldn't save statistics", 0);
        }
    }

    private void jmiQuitActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void jmiHelpActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, "You have to choose the \"stats\"-directory in your Enemy Territory dir.\nThe path will usually look like ..." + File.separator + "Enemy Territory" + File.separator + "etpro" + File.separator + "stats\n" + "ET-Statistics will then generate an unified statistic of all the " + "specific stastistics.\n", "Help", 1);
    }

    private void jmiAboutActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, ABOUT, "About", 1);
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    new ETStatisticsGUI().setVisible(true);
                }
            });
            return;
        }
        long start = System.currentTimeMillis();
        ETStatistics etStat = new ETStatistics();
        File dir = new File(args[0] + "/etpro/stats");
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isDirectory()) continue;
            File[] subfiles = files[i].listFiles();
            for (int j = 0; j < subfiles.length; ++j) {
                if (!subfiles[j].isFile()) continue;
                etStat.add(subfiles[j]);
            }
        }
        etStat.calculate();
        etStat.outputFinalStat(new File("statistic.txt"));
        System.out.println("done after " + (System.currentTimeMillis() - start) + " ms");
    }

    private class FormListener
    implements ActionListener {
        FormListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == ETStatisticsGUI.this.jmiOpen) {
                ETStatisticsGUI.this.jmiOpenActionPerformed(evt);
            } else if (evt.getSource() == ETStatisticsGUI.this.jmiSave) {
                ETStatisticsGUI.this.jmiSaveActionPerformed(evt);
            } else if (evt.getSource() == ETStatisticsGUI.this.jmiQuit) {
                ETStatisticsGUI.this.jmiQuitActionPerformed(evt);
            } else if (evt.getSource() == ETStatisticsGUI.this.jmiHelp) {
                ETStatisticsGUI.this.jmiHelpActionPerformed(evt);
            } else if (evt.getSource() == ETStatisticsGUI.this.jmiAbout) {
                ETStatisticsGUI.this.jmiAboutActionPerformed(evt);
            }
        }
    }
}

