--[[
	Clantag Protection #1
	=====================
	by Phishermans Phriend

	Further information:
	--------------------
	http://splashdamage.com/forums/showthread.php?p=363044


	-- FEATURES --

	This script provides the possibility to protect one or more clantags from being used by unpermitted persons.

	-- </FEATURES> --
--]]

-- CONFIG SECTION


	checkInterval	= 60000						-- The interval in milliseconds (1 sec = 1000 millisec) at which the script will check players for clantag violations


	clanTags	= {						-- List of clantags to protect, you can add as many as you want
		[1]	= "^1*AB*",					-- MAKE SURE TO REMOVE THE ENTIRE LINE IF YOU USE ONLY ONE CLANTAG!!
		[2]	= "^2=CD=",					-- Use the color codes for better looks in case of warnType,
	}								-- but leaving them out does not make a difference


	maxMarks	= 3						-- Determines the number of times a client needs to be marked before punishAction is executed
									-- NOTE: Set to 0 to instantly punish players


	warnType	= 1						-- warnType can have the following values:
									-- 1 = warnString is sent as console command, e.g.
									--      "!warn %s ^7remove proprietary clantag %s"
									--      In this case, first %s is replaced with the playername, second %s with the clantag
									-- 2 = warnString is sent to the client as center print message, e.g.
									--	"^dwarn: ^7remove clantag %s"
									--	In this case, %s is replaced with the clantag
									--      NOTE: The maximum length of center print messages is 56 characters


	warnString	= "!warn %s ^7remove proprietary clantag %s"	-- This action is performed according to warnType


	punishAction	= "!rename %s ETPlayer"				-- This console command is sent when maxMarks is reached
									-- NOTE: %s is replaced with the playername


	resetCounter	= false						-- Whether or not to reset the mark-counter when a player is punished
									-- NOTE: If you kick players as punishment, the counter will be reset on reconnect


	exclusionType	= 1						-- In order to exclude your clanmates from being punished, choose one of the two
									-- values below to handle player exclusion
									-- 1 = Players whose shrublevel is >= exclusionParam are excluded
									--     In this case, set exclusionParam to the lowest excluded shrublevel
									-- 2 = Use a player database to handle exclusions
									--     NOTE: Read the comment below for more info

		--[[ INFORMATION --

		If you use exclusionType = 2, a database will handle the excluded players
		If you choose to use the database system, you need to add EVERYBODY who wears your clantag!!
		BEFORE you start the lua script, create an empty file in "/fs_homepath/nq" and name it
		whatever you have set at exclusionParam.
		In order to add a player to the db, use the server-side console command "!ctp %player%"
		This allows you to create client shrubbot commands in order to allow admins to add players to the db
		A database entry will look like this:

		  %GUID% | %PLAYERNAME%

		If you want to remove a player from the db, open the file and delete his entry manually

		An example value for exclusionParam would be "ctp_excluded.dat"

		NOTE: ONLY VALID GUIDS CAN BE EXCLUDED, GUIDS LIKE "NO_GUID" or "unknown" WON'T WORK!!

		NOTE: This script will print possible error messages to the logfile with the prefix "ctp:"

		-- </INFORMATION ]]--


	exclusionParam	= 4						-- This variable customizes player exclusion handling according to exclusionType


-- END OF CONFIG SECTION

-------------------------------------------------------------
--DONT CHANGE ANYTHING BELOW UNLESS YOU KNOW WHAT YOURE DOING
-------------------------------------------------------------

marked = {}
excluded = {}

function et_InitGame(levelTime, randomSeed, restart)
	et.RegisterModname("Clantag Protection #1")

	for i=0,tonumber(et.trap_Cvar_Get("sv_maxclients"))-1 do
		if isOnline(i) then
			marked[i] = 0
		end
	end

	if exclusionType == 2 then
		local fd,len = et.trap_FS_FOpenFile(exclusionParam, et.FS_READ)

		if len >= 0 then
			for line in string.gfind(et.trap_FS_Read(fd, len), "(%x+)") do
				if string.len(line) == 32 and not excluded[line] then
					excluded[line] = true
				end
			end
		else
			et.G_LogPrint("ctp: Couldn't open exclusion database file " .. exclusionParam .. "\n")
		end

		et.trap_FS_FCloseFile(fd)
	end
end

function et_ClientConnect(clientNum, firstTime, isBot)
	marked[clientNum] = 0
end

function isOnline(id)
	if et.gentity_get( id, "pers.connected" ) > 0 then
		return true
	else
		return false
	end
end

function et_RunFrame(levelTime)
	if math.mod(levelTime,checkInterval) == 0 then
		local i = 0

		for i=0,tonumber(et.trap_Cvar_Get("sv_maxclients"))-1 do
			if isOnline(i) and not isExcluded(i) then
				local name = string.lower(et.Q_CleanStr(et.Info_ValueForKey(et.trap_GetUserinfo(i), "name" )))
				local a = 1
				local b = ""

				while clanTags[a] ~= nil do
					if not isOnline(i) then break end

					if string.find(name, string.lower(et.Q_CleanStr(clanTags[a]))) ~= nil then
						if marked[i] < maxMarks then
							b = b .. clanTags[a] .. " "
						else
							et.trap_SendConsoleCommand(et.EXEC_APPEND,string.format(punishAction,i) .. ";")

							if resetCounter then
								marked[i] = 0
							end

							b = ""
							break
						end
					end

					a = a + 1
				end

				if b ~= "" then

					marked[i] = marked[i] + 1

					if warnType == 1 then
						et.trap_SendConsoleCommand(et.EXEC_APPEND,string.format(warnString,i,b) .. "^7(" .. marked[i] .. "/" .. maxMarks .. ");")
					else
						et.trap_SendServerCommand(i, "cp \"" .. string.format(warnString,b) .. "^7(" .. marked[i] .. "/" .. maxMarks .. ")")
						et.trap_SendConsoleCommand(et.EXEC_APPEND,"playsound " .. i .. " sound/misc/referee.wav;")
					end
				end
			end
		end
	end
end

function isExcluded(id)
	if exclusionType == 1 then
		if et.G_shrubbot_level(id) >= exclusionParam then
			return true
		end
	else
		if excluded[et.Info_ValueForKey(et.trap_GetUserinfo(id),"cl_guid")] then
			return true
		end
	end

	return false
end
			
function et_ConsoleCommand()
	if string.lower(et.trap_Argv(0)) == "!ctp" and exclusionType == 2 then

		local id = et.ClientNumberFromString(et.trap_Argv(1))

		if id and id ~= -1 and et.trap_Argv(1) ~= "" then
			local guid = et.Info_ValueForKey(et.trap_GetUserinfo(id),"cl_guid")

			if not excluded[guid] then
				local fd,len = et.trap_FS_FOpenFile(exclusionParam, et.FS_APPEND)
				local data = guid .. " | " .. et.Info_ValueForKey(et.trap_GetUserinfo(id), "name") .. "\n"
				et.trap_FS_Write(data, string.len(data), fd)
				et.trap_FS_FCloseFile(fd)

				excluded[guid] = true
			end
		end

		return 1
	end
end

























