--[[
	Advanced Voting NQ #1
	=====================
	by Phishermans Phriend

	Further information:
	--------------------
	http://splashdamage.com/forums/showthread.php?p=361738


	-- FEATURES --

	This script provides an advanced voting system that allows
	players to vote on many settings the original voting system
	does not include. The server admin can allow/disallow any
	of these votes using the variables in the config section

	Clients can call the respective vote through
	ESC -> VOTE -> ADVANCED

	Referees will be able to directly change the settings
	through ESC -> VOTE -> ADVANCED

	Additionally, this script provides the following server commands:

	  "ref cointoss"                    = Coin Toss
	  "ref thirdpersonmode"             = Toggle Thirdperson Mode
	  "ref headshotmode"                = Toggle Headshot Mode
	  "ref flymode"                     = Toggle Low Gravity/Fly Mode
	  "ref glowmode"                    = Toggle Glow Mode
	  "ref speedmode"                   = Toggle Speed Mode
	  "ref maptimelimit [%integer%]"    = Increase timelimit by [x] minutes
	  "ref doublejump"                  = Toggle DoubleJump
	  "ref endmap"                      = End Map and go to intermission
	  "ref knifewar"                    = Toggle KnifeWar
	  "ref sniperwar"                   = Toggle SniperWar
	  "ref panzerwar"                   = Toggle PanzerWar
	  "ref riflewar"                    = Toggle RifleWar
	  "ref kickbots"                    = Kick all bots from server
	  "ref botcount [%integer%]"        = Set amount of bots on server to [x] percent of maxBots
	  "ref lockteam [r/b]"              = Lock team [x]
	  "ref unlockteam [r/b]"            = Unlock team [x]
	  "ref botwar [0/1/2]"              = Disable BotWar / Enable BotWar (Human Team Axis) / Enable BotWar (Human Team Allies)

	This allows you to create shrubbot commands for each setting

	-- </FEATURES> --


	===================================
	== !!! IMPORTANT INFORMATION !!! ==
	===================================

	The script will create the cvar "botwar" that will be used to (re)store the current botwar status.
	DO NOT TOUCH THIS CVAR! DO NOT ADD IT TO YOUR SERVER CONFIGURATION FILE, DO NOT CHANGE ITS VALUE!!

--]]

-- CONFIG SECTION

	--[[ INFORMATION --

	If you want to be able to customize the below settings individually ingame, you need to use cvars.
	This script supports the following method:

	If you want to dynamically set exampleVar ingame, change the corresponding line

	  exampleVar = 5

	to

	  exampleVar = "cvar.exampleVar"	( Make sure to not forget the quotation marks!! )

	Then "set exampleVar 5" through a config file or via rcon and you can dynamically change
	the setting of exampleVar through shrubbot commands, map-specific configuration files etc.

	This works for ALL the variables in the config section

	NOTE: Make sure to transform boolean variables to 1/0!! (Don't "set exampleVar [true/false]", but "set exampleVar [1/0]")

	NOTE: For boolean cvars, any value unequal to "0" will be considered true. This means that you don't have to add cvars for
	settings you want to allow (like for example "set vote_allow_botwar 1") but only for settings you want to disallow.

	-- </INFORMATION> ]]--
	

	maxBots = 20				-- The number specified here corresponds to the amount of bots that are added if
						-- somebody votes for a botcount of 100%.
						-- Do not choose a value close to sv_maxclients as this might result in a full
						-- server with only bots playing
						-- NOTE: If you don't use OmniBot, you can delete this variable


	roundUp = true				-- In case maxBots is set to 20 and somebody votes for a botcount of 25%, 5 bots would be added.
						-- Since the amount of bots online should be equal (not odd), we can either round
						-- it up to 6 or down to 4 bots. Set the behaviour of rounding here
						-- NOTE: If you don't use OmniBot, you can delete this variable


	botsPerHuman = 1			-- In case of botwar (bots vs humans), the amount of bots per human player can be specified.
						-- If you want to add more than one bot per player, change this parameter here
						-- NOTE: If you don't use OmniBot, you can delete this variable


	g_doubleJump = 1			-- NQ provides two options for g_doubleJump:
						-- Value 1: Normal DJ - Quickly tapping spacebar twice is needed in order to DJ
						-- Value 2: Jaymod DJ - Interval between spacebar tabs is irrelevant
						-- NOTE: Value 2 can be abused by players as it's possible to survive falls from any height
						-- Please set your preferred g_doubleJump setting here (will be used in order to "Enable DJ")
						-- NOTE: IF YOU WANT A CVAR TO HANDLE THIS VARIABLE, MAKE SURE NOT TO USE g_doubleJump !!!

	g_headshot = 1				-- NQ provides multiple options for g_headshot:
						-- Value 1: A headshot inflicts normal damage, bodyshots do no damage at all
						-- Value 2: A single headshot kills instantly, bodyshots do no damage at all
						-- Value 3: A single headshot kills instantly, bodyshots inflict normal damage
						-- Please set your preferred g_headshot setting here (will be used in order to "Enable Headshot Mode")
						-- NOTE: IF YOU WANT A CVAR TO HANDLE THIS VARIABLE, MAKE SURE NOT TO USE g_headshot !!!


	g_speed = 560				-- Please set your preferred g_speed setting here (will be used in order to "Enable Speed Mode")
						-- The default value is 320, so 560 would be 175%
						-- NOTE: IF YOU WANT A CVAR TO HANDLE THIS VARIABLE, MAKE SURE NOT TO USE g_speed !!!

	vote_allow_poll = true			-- Since it's essential for this script, the cvar vote_allow_poll is automatically set to 1 at the
						-- beginning of each round and thus has no longer an effect
						-- TO ENSURE SMOOTH FUNCTIONALITY, REMOVE THE CVAR vote_allow_poll FROM YOUR SERVER CONFIG FILE
						-- AND INSERT ITS VALUE HERE (1 = true ; 0 = false)!!!
						-- NOTE: IF YOU WANT A CVAR TO HANDLE THIS VARIABLE, MAKE SURE NOT TO USE vote_allow_poll !!!


		-- The following vstrs are called whenever a war starts/ends. Use them to toggle your custom fun settings for wars
		-- NOTE: This does only affect the weapon-wars, not BotWar
		-- NOTE: I recommend you to enable "Unlimited Charge" (jp_insanity bitflag 16) during wars as especially panzerwar sucks without it
		-- NOTE: It is recommended to disable g_classchange and g_dropammo during wars because of potential abuse

	onWarStart = "set g_classchange 0 ; set g_dropammo 0 ; set jp_insanity 16"
	onWarEnd   = "set g_classchange 1 ; set g_dropammo 3 ; set jp_insanity 0"


		-- Allow/disallow votes here. This will not influence referees.
		-- map-only: Setting will be discarded on map_restart/nextmap
		-- persistent: Setting will be kept on map_restart/nextmap

		-- NOTE: If you want a persistent setting to be map-only,
		-- add the corresponding command to "g_mapconfigs/default.cfg"
		-- (like for example "set g_speed 320" to disable speed mode 
		-- or "set nq_war 0" to disable any running war)

	vote_allow_cointoss		= true		-- Coin Toss:               one-time event
	vote_allow_thirdpersonmode	= true		-- Thirdperson Mode:        map-only
	vote_allow_headshotmode		= true		-- Headshot Mode:           persistent
	vote_allow_flymode		= true		-- Low Gravity/Fly Mode:    map-only
	vote_allow_glowmode		= true		-- Glow Mode:               map-only
	vote_allow_speedmode		= true		-- Speed Mode:              persistent
	vote_allow_maptimelimit		= true		-- Timelimit:               one-time event
	vote_allow_doublejump		= true		-- DoubleJump:              persistent
	vote_allow_endmap		= true		-- End Map:                 one-time event
	vote_allow_knifewar		= true		-- KnifeWar:                persistent
	vote_allow_sniperwar		= true		-- SniperWar:               persistent
	vote_allow_panzerwar		= true		-- PanzerWar:               persistent
	vote_allow_riflewar		= true		-- RifleWar:                persistent
	vote_allow_kickbots		= true		-- Kick Bots:               one-time event
	vote_allow_botcount		= true		-- Set Botcount:            one-time event
	vote_allow_lockteams		= true		-- (Un)Lock Teams:          one-time event
	vote_allow_botwar		= true		-- BotWar (Bots vs Humans): persistent

-- END OF CONFIG SECTION

-------------------------------------------------------------
--DONT CHANGE ANYTHING BELOW UNLESS YOU KNOW WHAT YOURE DOING
-------------------------------------------------------------


--[[
	===========================
	== DEVELOPER INFORMATION ==
	===========================

	The lua interpreter seems to have the following bug/peculiarity:
	Multiple et.trap_SendConsoleCommands inside a function are not
	executed one by one but are concatenated and then sent:
	For example, the following three lines

	  et.trap_SendConsoleCommand(et.EXEC_APPEND,"qsay test1")
	  et.trap_SendConsoleCommand(et.EXEC_APPEND,"qsay test2")
	  et.trap_SendConsoleCommand(et.EXEC_APPEND,"qsay test3")

	are not executed like this

	  "qsay test1 ; qsay test2 ; qsay test3"

	but like this:

	  "qsay test1qsay test2qsay test3"

	This can be easily fixed by adding a semicolon to the end of
	each et.trap_SendConsoleCommand, so it will look like this:

	  et.trap_SendConsoleCommand(et.EXEC_APPEND,"qsay test1;")
	  et.trap_SendConsoleCommand(et.EXEC_APPEND,"qsay test2;")
	  et.trap_SendConsoleCommand(et.EXEC_APPEND,"qsay test3;")

	When they're executed now, the semicolon seperates the
	commands and it will be executed as inteded, namely:

	  "qsay test1;qsay test2;qsay test3;"

	Just sth I wanted to share with you to spare you the pain of finding out yourself ;)
--]]

voteInProgress = false
thirdPersonMode = false
glowMode = false
wakeUp = false
player = {}

function et_InitGame(levelTime, randomSeed, restart)
	et.RegisterModname("AdvancedVoting NQ #1")

	local i = 0
	for i=0, tonumber(et.trap_Cvar_Get("sv_maxclients"))-1 do
		player[i] = {}
		player[i].voteCount = 0
		player[i].keepEyeOn = 0
	end

	if et.trap_Cvar_Get("omnibot_enable") == "1" and et.trap_Cvar_Get("botwar") == "" then
		et.trap_Cvar_Set("botwar","0")
		et.trap_SendConsoleCommand(et.EXEC_APPEND,"bot botwar -1;")
	end

	et.trap_SendConsoleCommand(et.EXEC_APPEND,"forcecvar cg_thirdperson 0 ; set vote_allow_poll 1;")
end

function et_ClientConnect( clientNum, firstTime, isBot )
	if firstTime == 1 then
		player[clientNum].voteCount = 0
	end
end

function et_ClientCommand( clientNum, command )
	local arg0 = string.lower(et.trap_Argv(0))
	local arg1 = string.lower(et.trap_Argv(1))
	local arg2 = string.lower(et.trap_Argv(2))

	if arg0 == "callvote" then

		if arg1 == "poll" and not voteInProgress and allowedToCallVote(clientNum) then

			local x,y = checkVote(clientNum,string.lower(et.ConcatArgs(2)))

			if not x then
				et.trap_SendServerCommand(clientNum, "cp \"" .. y )
				return 1
			end

			if y then
				et.trap_SendConsoleCommand(et.EXEC_APPEND, "qsay " .. y .. ";")
			end

		elseif (arg1 == "shuffleteamsxp" or arg1 == "shuffleteamsxp_norestart" or arg1 == "swapteams") and botWarAssistant() == 1 then
			et.trap_SendServerCommand(clientNum, "cp \"Not allowed during BotWar.")
			return 1
		end

		player[clientNum].keepEyeOn = et.trap_Milliseconds()
		wakeUp = true
		return 0

	elseif arg0 == "advancedvoting" then

		et.trap_SendServerCommand( clientNum, "print \"\n")
		et.trap_SendServerCommand( clientNum, "print \"^3>>> AdvancedVoting - Server Settings\n")
		et.trap_SendServerCommand( clientNum, "print \"\n")

		if arg1 == "maxbots" then
			et.trap_SendServerCommand( clientNum, "print \"Current ^8maxBots ^7setting:\n")
			et.trap_SendServerCommand( clientNum, "print \"^8------------------------\n")

			if botWarAssistant() ~= 2 then
				if getVar(maxBots,"int") ~= nil then
					et.trap_SendServerCommand( clientNum, "print \"  ^d25pct:  ^2" .. integerBotCount(25,true) .. " ^7Bots\n")
					et.trap_SendServerCommand( clientNum, "print \"  ^d50pct:  ^2" .. integerBotCount(50,true) .. " ^7Bots\n")
					et.trap_SendServerCommand( clientNum, "print \"  ^d75pct:  ^2" .. integerBotCount(75,true) .. " ^7Bots\n")
					et.trap_SendServerCommand( clientNum, "print \" ^d100pct:  ^2" .. integerBotCount(100,true) .. " ^7Bots\n")
				else
					et.trap_SendServerCommand( clientNum, "print \" ^2maxBots ^dis not set.\n")
				end
			else
				et.trap_SendServerCommand( clientNum, "print \" ^2OmniBot ^dis not loaded.\n")
			end
			et.trap_SendServerCommand( clientNum, "print \"\n")

		elseif arg1 == "votes" then
			et.trap_SendServerCommand( clientNum, "print \"Currently allowed votes:\n")
			et.trap_SendServerCommand( clientNum, "print \"^8------------------------\n")
			et.trap_SendServerCommand( clientNum, "print \" ^dCointoss:         " .. clientCmdAssistant(getVar(vote_allow_cointoss,"bool")) .. "\n")
			et.trap_SendServerCommand( clientNum, "print \" ^dThirdperson Mode: " .. clientCmdAssistant(getVar(vote_allow_thirdpersonmode,"bool")) .. "\n")
			et.trap_SendServerCommand( clientNum, "print \" ^dHeadshot Mode:    " .. clientCmdAssistant(getVar(vote_allow_headshotmode,"bool")) .. "\n")
			et.trap_SendServerCommand( clientNum, "print \" ^dFly Mode:         " .. clientCmdAssistant(getVar(vote_allow_flymode,"bool")) .. "\n")
			et.trap_SendServerCommand( clientNum, "print \" ^dGlow Mode:        " .. clientCmdAssistant(getVar(vote_allow_glowmode,"bool")) .. "\n")
			et.trap_SendServerCommand( clientNum, "print \" ^dSpeed Mode:       " .. clientCmdAssistant(getVar(vote_allow_speedmode,"bool")) .. "\n")
			et.trap_SendServerCommand( clientNum, "print \" ^dTimelimit:        " .. clientCmdAssistant(getVar(vote_allow_maptimelimit,"bool")) .. "\n")
			et.trap_SendServerCommand( clientNum, "print \" ^dDoubleJump:       " .. clientCmdAssistant(getVar(vote_allow_doublejump,"bool")) .. "\n")
			et.trap_SendServerCommand( clientNum, "print \" ^dEnd Map:          " .. clientCmdAssistant(getVar(vote_allow_endmap,"bool")) .. "\n")
			et.trap_SendServerCommand( clientNum, "print \" ^dKnifeWar:         " .. clientCmdAssistant(getVar(vote_allow_knifewar,"bool")) .. "\n")
			et.trap_SendServerCommand( clientNum, "print \" ^dSniperWar:        " .. clientCmdAssistant(getVar(vote_allow_sniperwar,"bool")) .. "\n")
			et.trap_SendServerCommand( clientNum, "print \" ^dPanzerWar:        " .. clientCmdAssistant(getVar(vote_allow_panzerwar,"bool")) .. "\n")
			et.trap_SendServerCommand( clientNum, "print \" ^dRifleWar:         " .. clientCmdAssistant(getVar(vote_allow_riflewar,"bool")) .. "\n")
			et.trap_SendServerCommand( clientNum, "print \" ^dKick Bots:        " .. clientCmdAssistant(getVar(vote_allow_kickbots,"bool")) .. "\n")
			et.trap_SendServerCommand( clientNum, "print \" ^dSet Botcount:     " .. clientCmdAssistant(getVar(vote_allow_botcount,"bool")) .. "\n")
			et.trap_SendServerCommand( clientNum, "print \" ^d(Un)Lock Teams:   " .. clientCmdAssistant(getVar(vote_allow_lockteams,"bool")) .. "\n")
			et.trap_SendServerCommand( clientNum, "print \" ^dBotWar:           " .. clientCmdAssistant(getVar(vote_allow_botwar,"bool")) .. "\n")

		elseif arg1 == "settings" then
			et.trap_SendServerCommand( clientNum, "print \"Currently enabled settings:\n")
			et.trap_SendServerCommand( clientNum, "print \"^8---------------------------\n")
			et.trap_SendServerCommand( clientNum, "print \" ^dThirdperson Mode: " .. settingEnabled("toggle thirdperson mode") .. "\n")
			et.trap_SendServerCommand( clientNum, "print \" ^dHeadshot Mode:    " .. settingEnabled("toggle headshot mode") .. "\n")
			et.trap_SendServerCommand( clientNum, "print \" ^dFly Mode:         " .. settingEnabled("toggle low gravity/fly mode") .. "\n")
			et.trap_SendServerCommand( clientNum, "print \" ^dGlow Mode:        " .. settingEnabled("toggle glow mode") .. "\n")
			et.trap_SendServerCommand( clientNum, "print \" ^dSpeed Mode:       " .. settingEnabled("toggle speed mode") .. "\n")
			et.trap_SendServerCommand( clientNum, "print \" ^dDoubleJump:       " .. settingEnabled("toggle doublejump") .. "\n")
			et.trap_SendServerCommand( clientNum, "print \" ^dKnifeWar:         " .. settingEnabled("toggle knifewar") .. "\n")
			et.trap_SendServerCommand( clientNum, "print \" ^dSniperWar:        " .. settingEnabled("toggle sniperwar") .. "\n")
			et.trap_SendServerCommand( clientNum, "print \" ^dPanzerWar:        " .. settingEnabled("toggle panzerwar") .. "\n")
			et.trap_SendServerCommand( clientNum, "print \" ^dRifleWar:         " .. settingEnabled("toggle riflewar") .. "\n")
			et.trap_SendServerCommand( clientNum, "print \" ^dBotWar:           " .. settingEnabled("botwar") .. "\n")
		else
			et.trap_SendServerCommand( clientNum, "print \"Available parameters:\n")
			et.trap_SendServerCommand( clientNum, "print \"^8---------------------\n")
			et.trap_SendServerCommand( clientNum, "print \" ^2maxbots     ^dto view current maxBots setting\n")
			et.trap_SendServerCommand( clientNum, "print \" ^2votes       ^dto view currently allowed votes\n")
			et.trap_SendServerCommand( clientNum, "print \" ^2settings    ^dto view currently enabled settings\n")
		end

		return 1

	elseif arg0 == "ref" and isRef(clientNum) then

		if (arg1 == "botwar" or arg1 == "botcount" or arg1 == "kickbots") and botWarAssistant() == 2 then
			et.trap_SendServerCommand(clientNum, "cp \"OmniBot not loaded.")
			return 1
		elseif (arg1 == "botwar" or arg1 == "botcount") and getVar(maxBots,"int") == nil then
			et.trap_SendServerCommand(clientNum, "cp \"maxBots not set.")
			return 1
		elseif arg1 == "botwar" and getVar(botsPerHuman,"int") == nil then
			et.trap_SendServerCommand(clientNum, "cp \"botsPerHuman not set.")
			return 1
		else
			return refCall(arg1,arg2)
		end
	end
end

function integerBotCount(percentage,print)
	local var = getVar(maxBots,"int") * math.floor(percentage) / 100

	if getVar(roundUp,"bool") then
		var = math.ceil(var)
	else
		var = math.floor(var)
	end

	if math.fmod(var,2) ~= 0 then
		if getVar(roundUp,"bool") then
			var = var + 1
		else
			var = var - 1
		end
	end

	if print and var < 10 then
		return " " .. var
	end

	return var
end

function isRef(id)
	if et.gentity_get( id, "sess.referee" ) == 1 then
		return true
	else
		return false
	end
end

function allowedToCallVote(id)

	if et.gentity_get( id, "sess.muted" ) == 1 then
		return false
	end

	if isRef(id) then
		return true
	end

	if et.gentity_get( id, "sess.sessionTeam" ) == 3 or et.G_shrubbot_permission( id, "?" ) == 1 then
		return false
	end

	local votelimit = math.floor(tonumber(et.trap_Cvar_Get("vote_limit")))

	if votelimit <= 0 then	-- seems like vote_limit = 0 means unlimited, not completely disallowed
		return true
	end

	if et.gentity_get( id, "pers.voteCount" ) < votelimit then
		return true
	end

	return false
end

function et_Print(text)

	if string.sub(text,1,12) == "Vote Failed:" or string.sub(text,1,12) == "Vote Passed:" then
		voteInProgress = false
	end

	if string.sub(text,1,19) == "Vote Passed: [poll]" then

		if string.lower(text) == "vote passed: [poll] coin toss\n" then
			execVote("cointoss", nil, false)

		elseif string.lower(text) == "vote passed: [poll] toggle thirdperson mode\n" then
			execVote("thirdpersonmode", nil, false)

		elseif string.lower(text) == "vote passed: [poll] toggle headshot mode\n" then
			execVote("headshotmode", nil, false)

		elseif string.lower(text) == "vote passed: [poll] toggle low gravity/fly mode\n" then
			execVote("flymode", nil, false)

		elseif string.lower(text) == "vote passed: [poll] toggle glow mode\n" then
			execVote("glowmode", nil, false)

		elseif string.lower(text) == "vote passed: [poll] toggle speed mode\n" then
			execVote("speedmode", nil, false)

		elseif string.lower(text) == "vote passed: [poll] timelimit +5min\n" then
			execVote("maptimelimit", 5, false)

		elseif string.lower(text) == "vote passed: [poll] timelimit +10min\n" then
			execVote("maptimelimit", 10, false)

		elseif string.lower(text) == "vote passed: [poll] toggle doublejump\n" then
			execVote("doublejump", nil, false)

		elseif string.lower(text) == "vote passed: [poll] end map\n" then
			execVote("endmap", nil, false)

		elseif string.lower(text) == "vote passed: [poll] toggle knifewar\n" then
			execVote("knifewar", nil, false)

		elseif string.lower(text) == "vote passed: [poll] toggle sniperwar\n" then
			execVote("sniperwar", nil, false)

		elseif string.lower(text) == "vote passed: [poll] toggle panzerwar\n" then
			execVote("panzerwar", nil, false)

		elseif string.lower(text) == "vote passed: [poll] toggle riflewar\n" then
			execVote("riflewar", nil, false)

		elseif string.lower(text) == "vote passed: [poll] kick bots\n" then
			execVote("kickbots", nil, false)

		elseif string.lower(text) == "vote passed: [poll] set botcount to 25pct\n" then
			execVote("botcount", 25, false)

		elseif string.lower(text) == "vote passed: [poll] set botcount to 50pct\n" then
			execVote("botcount", 50, false)

		elseif string.lower(text) == "vote passed: [poll] set botcount to 75pct\n" then
			execVote("botcount", 75, false)

		elseif string.lower(text) == "vote passed: [poll] set botcount to 100pct\n" then
			execVote("botcount", 100, false)

		elseif string.lower(text) == "vote passed: [poll] lock allies\n" then
			execVote("lockteam","b", false)

		elseif string.lower(text) == "vote passed: [poll] unlock allies\n" then
			execVote("unlockteam","b", false)

		elseif string.lower(text) == "vote passed: [poll] lock axis\n" then
			execVote("lockteam","r", false)

		elseif string.lower(text) == "vote passed: [poll] unlock axis\n" then
			execVote("unlockteam","r", false)

		elseif string.lower(text) == "vote passed: [poll] enable botwar: human team allies\n" then
			execVote("botwar",2, false)

		elseif string.lower(text) == "vote passed: [poll] enable botwar: human team axis\n" then
			execVote("botwar",1, false)

		elseif string.lower(text) == "vote passed: [poll] disable botwar\n" then
			execVote("botwar",0, false)
		end

		return
	end

	if botWarAssistant() == 1 then

		local a,b,id = string.find(text, "ClientBegin:%s+(%d+)\n")

		if id ~= nil and a == 1 and b == 15 then
			id = tonumber(id)

			local c = 1

			if et.trap_Cvar_Get("botwar") == "1" then
				c = 2
			end

			if et.Info_ValueForKey(et.trap_GetUserinfo(id),"ip") ~= "localhost" and et.gentity_get(id, "sess.sessionTeam") == c then
				et.trap_SendConsoleCommand(et.EXEC_APPEND,"!put " .. id .. " s;")
				et.trap_SendServerCommand(id, "cp \"You cannot join the bot team.")
			end
		end
	end
end

function et_ConsoleCommand(command)
	if string.lower(et.trap_Argv(0)) == "ref" then

		local arg1 = string.lower(et.trap_Argv(1))

		if (arg1 == "botwar" or arg1 == "botcount" or arg1 == "kickbots") and botWarAssistant() == 2 then
			return 1
		elseif (arg1 == "botwar" or arg1 == "botcount") and getVar(maxBots,"int") == nil then
			et.trap_SendServerCommand(clientNum, "cp \"maxBots not set.")
			return 1
		elseif arg1 == "botwar" and getVar(botsPerHuman,"int") == nil then
			et.trap_SendServerCommand(clientNum, "cp \"botsPerHuman not set.")
			return 1
		else
			return refCall(arg1,string.lower(et.trap_Argv(2)))
		end
	end

	return 0
end

function et_RunFrame(levelTime)
	if wakeUp then
		local i = 0
		for i=0, tonumber(et.trap_Cvar_Get("sv_maxclients"))-1 do
			local keepEyeOn = player[i].keepEyeOn
			if keepEyeOn ~= nil and et.trap_Milliseconds() >= keepEyeOn then
				if et.gentity_get( i, "pers.voteCount" ) > player[i].voteCount and et.gentity_get( i, "pers.connected" ) > 0 then
					voteInProgress = true
					player[i].voteCount = et.gentity_get( i, "pers.voteCount" )
					wakeUp = false
					player[i].keepEyeOn = nil
				end
			end
		end
	end
end

function execVote(name, value, byref)

	if name == "cointoss" then
		if math.floor(math.random() + 0.5) == 1 then
			et.trap_SendConsoleCommand(et.EXEC_APPEND,"qsay ^dAdvancedVoting: ^7Cointoss returns ^2Heads;")
		else
			et.trap_SendConsoleCommand(et.EXEC_APPEND,"qsay ^dAdvancedVoting: ^7Cointoss returns ^2Tails;")
		end

	elseif name == "thirdpersonmode" then
		if thirdPersonMode then
			et.trap_SendConsoleCommand(et.EXEC_APPEND,"qsay ^dAdvancedVoting: ^7Thirdperson Mode is now ^1Disabled;")
			thirdPersonMode = false
			et.trap_SendConsoleCommand(et.EXEC_APPEND,"forcecvar cg_thirdperson 0;")
		else
			et.trap_SendConsoleCommand(et.EXEC_APPEND,"qsay ^dAdvancedVoting: ^7Thirdperson Mode is now ^2Enabled;")
			thirdPersonMode = true
			et.trap_SendConsoleCommand(et.EXEC_APPEND,"forcecvar cg_thirdperson 1;")
		end

	elseif name == "headshotmode" then
		if et.trap_Cvar_Get("g_headshot") == "0" then
			et.trap_SendConsoleCommand(et.EXEC_APPEND,"qsay ^dAdvancedVoting: ^7Headshot Mode is now ^2Enabled;")
			et.trap_Cvar_Set( "g_headshot", getVar(g_headshot,"int"))
		else
			et.trap_SendConsoleCommand(et.EXEC_APPEND,"qsay ^dAdvancedVoting: ^7Headshot Mode is now ^1Disabled;")
			et.trap_Cvar_Set( "g_headshot", "0")
		end

	elseif name == "flymode" then
		if et.trap_Cvar_Get("g_gravity") ~= "800" then
			et.trap_SendConsoleCommand(et.EXEC_APPEND,"qsay ^dAdvancedVoting: ^7Fly Mode is now ^1Disabled;")
			et.trap_Cvar_Set( "g_gravity", "800")
		else
			et.trap_SendConsoleCommand(et.EXEC_APPEND,"qsay ^dAdvancedVoting: ^7Fly Mode is now ^2Enabled;")
			et.trap_Cvar_Set( "g_gravity", "200")
		end

	elseif name == "glowmode" then
		if glowMode then
			et.trap_SendConsoleCommand(et.EXEC_APPEND,"qsay ^dAdvancedVoting: ^7Glow Mode is now ^1Disabled;")
			glowMode = false
		else
			et.trap_SendConsoleCommand(et.EXEC_APPEND,"qsay ^dAdvancedVoting: ^7Glow Mode is now ^2Enabled;")
			glowMode = true
			et.trap_SendConsoleCommand(et.EXEC_APPEND,"!glow;")
		end

	elseif name == "speedmode" then
		if et.trap_Cvar_Get("g_speed") ~= "320" then
			et.trap_SendConsoleCommand(et.EXEC_APPEND,"qsay ^dAdvancedVoting: ^7Speed Mode is now ^1Disabled;")
			et.trap_Cvar_Set( "g_speed", "320")
		else
			et.trap_SendConsoleCommand(et.EXEC_APPEND,"qsay ^dAdvancedVoting: ^7Speed Mode is now ^2Enabled;")
			et.trap_Cvar_Set( "g_speed", getVar(g_speed,"int"))
		end

	elseif name == "maptimelimit" then
			et.trap_SendConsoleCommand(et.EXEC_APPEND,"qsay ^dAdvancedVoting: ^7Increasing Timelimit by ^2" .. value .. " ^7min..;")
			et.trap_Cvar_Set( "timelimit", tonumber(et.trap_Cvar_Get("timelimit")) + math.floor(tonumber(value)))

	elseif name == "doublejump" then
		if et.trap_Cvar_Get("g_doublejump") == "0" then
			et.trap_SendConsoleCommand(et.EXEC_APPEND,"qsay ^dAdvancedVoting: ^7DoubleJump is now ^2Enabled;")
			et.trap_Cvar_Set( "g_doublejump", getVar(g_doubleJump,"int"))
		else
			et.trap_SendConsoleCommand(et.EXEC_APPEND,"qsay ^dAdvancedVoting: ^7DoubleJump is now ^1Disabled;")
			et.trap_Cvar_Set( "g_doublejump", "0")
		end

	elseif name == "endmap" then
		et.trap_Cvar_Set("timelimit",".05")

	elseif name == "knifewar" then
		if et.trap_Cvar_Get("nq_war") == "2053" then
			et.trap_SendConsoleCommand(et.EXEC_APPEND,"qsay ^dAdvancedVoting: ^7KnifeWar is now ^1Disabled;")
			et.trap_Cvar_Set( "nq_war", "0" )
			et.trap_SendConsoleCommand(et.EXEC_APPEND,getVar(onWarEnd,"str") .. ";")
		else
			et.trap_SendConsoleCommand(et.EXEC_APPEND,"qsay ^dAdvancedVoting: ^7KnifeWar is now ^2Enabled;")
			et.trap_Cvar_Set( "nq_war", "2053" )
			et.trap_SendConsoleCommand(et.EXEC_APPEND,getVar(onWarStart,"str") .. ";")
		end

	elseif name == "sniperwar" then
		if et.trap_Cvar_Get("nq_war") == "2065" then
			et.trap_SendConsoleCommand(et.EXEC_APPEND,"qsay ^dAdvancedVoting: ^7SniperWar is now ^1Disabled;")
			et.trap_Cvar_Set( "nq_war", "0")
			et.trap_SendConsoleCommand(et.EXEC_APPEND,getVar(onWarEnd,"str") .. ";")
		else
			et.trap_SendConsoleCommand(et.EXEC_APPEND,"qsay ^dAdvancedVoting: ^7SniperWar is now ^2Enabled;")
			et.trap_Cvar_Set( "nq_war", "2065")
			et.trap_SendConsoleCommand(et.EXEC_APPEND,getVar(onWarStart,"str") .. ";")
		end

	elseif name == "panzerwar" then
		if et.trap_Cvar_Get("nq_war") == "2057" then
			et.trap_SendConsoleCommand(et.EXEC_APPEND,"qsay ^dAdvancedVoting: ^7PanzerWar is now ^1Disabled;")
			et.trap_Cvar_Set( "nq_war", "0")
			et.trap_SendConsoleCommand(et.EXEC_APPEND,getVar(onWarEnd,"str") .. ";")
		else
			et.trap_SendConsoleCommand(et.EXEC_APPEND,"qsay ^dAdvancedVoting: ^7PanzerWar is now ^2Enabled;")
			et.trap_Cvar_Set( "nq_war", "2057")
			et.trap_SendConsoleCommand(et.EXEC_APPEND,getVar(onWarStart,"str") .. ";")
		end

	elseif name == "riflewar" then
		if et.trap_Cvar_Get("nq_war") == "2113" then
			et.trap_SendConsoleCommand(et.EXEC_APPEND,"qsay ^dAdvancedVoting: ^7RifleWar is now ^1Disabled;")
			et.trap_Cvar_Set( "nq_war", "0")
			et.trap_SendConsoleCommand(et.EXEC_APPEND,getVar(onWarEnd,"str") .. ";")
		else
			et.trap_SendConsoleCommand(et.EXEC_APPEND,"qsay ^dAdvancedVoting: ^7RifleWar is now ^2Enabled;")
			et.trap_Cvar_Set( "nq_war", "2113")
			et.trap_SendConsoleCommand(et.EXEC_APPEND,getVar(onWarStart,"str") .. ";")
		end

	elseif name == "kickbots" then
		et.trap_SendConsoleCommand(et.EXEC_APPEND,"qsay ^dAdvancedVoting: ^7Kicking Bots..;")
		et.trap_SendConsoleCommand(et.EXEC_APPEND,"bot maxbots -1 ; bot kickall;")

	elseif name == "botcount" then
		et.trap_SendConsoleCommand(et.EXEC_APPEND,"qsay ^dAdvancedVoting: ^7Setting Botcount to ^2" .. integerBotCount(tonumber(value),false) .. " ^7Bots..;")
		et.trap_SendConsoleCommand(et.EXEC_APPEND,"bot maxbots " .. integerBotCount(tonumber(value),false) .. ";")

	elseif name == "lockteam" then
		et.trap_SendConsoleCommand(et.EXEC_APPEND,"!lock " .. value .. ";")

	elseif name == "unlockteam" then
		et.trap_SendConsoleCommand(et.EXEC_APPEND,"!unlock " .. value .. ";")

	elseif name == "botwar" then

		et.trap_Cvar_Set("botwar",value)		-- update botWar status indicator var

		if value == 0 then
			et.trap_SendConsoleCommand(et.EXEC_APPEND,"bot maxbots -1 ; bot kickall ; bot botwar -1;")
			et.trap_SendConsoleCommand(et.EXEC_APPEND,"qsay ^dAdvancedVoting: ^7BotWar is now ^1Disabled;")
		else
			local a = "r"		-- shrubbot shortcut of human team
			local b = 2		-- omnibot/lua shortcut of bot team
			local c = "^?Axis"	-- colored teamname of human team

			if value == 2 then
				a = "b"
				b = 1
				c = "^~Allies"
			end

			local i = 0
			for i=0, tonumber(et.trap_Cvar_Get("sv_maxclients"))-1 do
				if et.gentity_get( i, "pers.connected" ) > 0 and et.Info_ValueForKey(et.trap_GetUserinfo(i),"ip") ~= "localhost" then
					local team = et.gentity_get( i, "sess.sessionTeam" )
					if team == b then
						et.trap_SendConsoleCommand(et.EXEC_APPEND,string.format("!put %i %s;", i, a ))
					elseif team == value then
						et.trap_SendConsoleCommand(et.EXEC_APPEND,string.format("!gib %i;", i))
					end
				end
			end

			et.trap_SendConsoleCommand(et.EXEC_APPEND,string.format("bot maxbots %i ; bot botwar %i %i %i ; pause ; unpause;", integerBotCount(100,false), b, value, getVar(botsPerHuman,"int") ))

			-- enable botwar: /bot botwar <botTeam> <humanTeam> <botsPerHuman>

			et.trap_SendConsoleCommand(et.EXEC_APPEND,"qsay ^dAdvancedVoting: ^7BotWar is now ^2Enabled ^y| ^7Human Team: " .. c .. ";")
		end
	end

	et.G_globalSound( "sound/misc/referee.wav" )

	if byref then
		et.trap_SendServerCommand( -1, "cp \"^1** Referee Server Setting Change **")
	end
end

function checkVote(id,vote)

	-- this function returns two values:
	-- value1: vote allowed/disallowed (false if not)
	-- value2: string to be displayed (false if none)

	if et.trap_Cvar_Get( "gamestate" ) ~= "0" then
		return false,"You can only call votes during a round."
	end

	if vote == "coin toss" then
		if getVar(vote_allow_cointoss,"bool") or isRef(id) then
			return true,false
		end

	elseif vote == "toggle thirdperson mode" then
		if getVar(vote_allow_thirdpersonmode,"bool") or isRef(id) then
			return true,"^dAdvancedVoting: ^7Thirdperson Mode is currently " .. settingEnabled(vote)
		end

	elseif vote == "toggle headshot mode" then
		if getVar(vote_allow_headshotmode,"bool") or isRef(id) then
			return true,"^dAdvancedVoting: ^7Headshot Mode is currently " .. settingEnabled(vote)
		end

	elseif vote == "toggle low gravity/fly mode" then
		if getVar(vote_allow_flymode,"bool") or isRef(id) then
			return true,"^dAdvancedVoting: ^7Fly Mode is currently " .. settingEnabled(vote)
		end

	elseif vote == "toggle glow mode" then
		if getVar(vote_allow_glowmode,"bool") or isRef(id) then
			return true,"^dAdvancedVoting: ^7Glow Mode is currently " .. settingEnabled(vote)
		end

	elseif vote == "toggle speed mode" then
		if getVar(vote_allow_speedmode,"bool") or isRef(id) then
			return true,"^dAdvancedVoting: ^7Speed Mode is currently " .. settingEnabled(vote)
		end

	elseif (vote == "timelimit +10min" or vote == "timelimit +5min") then
		if getVar(vote_allow_maptimelimit,"bool") or isRef(id) then
			return true,false
		end

	elseif vote == "toggle doublejump" then
		if getVar(vote_allow_doublejump,"bool") or isRef(id) then
			return true,"^dAdvancedVoting: ^7DoubleJump is currently " .. settingEnabled(vote)
		end

	elseif vote == "end map" then
		if getVar(vote_allow_endmap,"bool") or isRef(id) then
			return true,false
		end

	elseif vote == "toggle knifewar" then
		if getVar(vote_allow_knifewar,"bool") or isRef(id) then
			return true,"^dAdvancedVoting: ^7KnifeWar is currently " .. settingEnabled(vote)
		end

	elseif vote == "toggle sniperwar" then
		if getVar(vote_allow_sniperwar,"bool") or isRef(id) then
			return true,"^dAdvancedVoting: ^7SniperWar is currently " .. settingEnabled(vote)
		end

	elseif vote == "toggle panzerwar" then
		if getVar(vote_allow_panzerwar,"bool") or isRef(id) then
			return true,"^dAdvancedVoting: ^7PanzerWar is currently " .. settingEnabled(vote)
		end

	elseif vote == "toggle riflewar" then
		if getVar(vote_allow_riflewar,"bool") or isRef(id) then
			return true,"^dAdvancedVoting: ^7RifleWar is currently " .. settingEnabled(vote)
		end

	elseif vote == "kick bots" then
		if botWarAssistant() == 2 then
			return false,"OmniBot not loaded."
		elseif botWarAssistant() == 1 then
			return false,"Not allowed during BotWar."
		elseif getVar(vote_allow_kickbots,"bool") or isRef(id) then
			return true,false
		end

	elseif (vote == "lock allies" or vote == "unlock allies" or vote == "lock axis" or vote == "unlock axis") then
		if getVar(vote_allow_lockteams,"bool") or isRef(id) then
			return true,false
		end

	elseif vote == "set botcount to 25pct" then
		if botWarAssistant() == 2 then
			return false,"OmniBot not loaded."
		elseif botWarAssistant() == 1 then
			return false,"Not allowed during BotWar."
		elseif getVar(vote_allow_botcount,"bool") or isRef(id) then
			if getVar(maxBots,"int") ~= nil then
				return true,"^dAdvancedVoting: ^325pct ^7correspond to ^2" .. integerBotCount(25,false) .. " ^7Bots"
			else
				return false,"maxBots not set."
			end
		end

	elseif vote == "set botcount to 50pct" then
		if botWarAssistant() == 2 then
			return false,"OmniBot not loaded."
		elseif botWarAssistant() == 1 then
			return false,"Not allowed during BotWar."
		elseif getVar(vote_allow_botcount,"bool") or isRef(id) then
			if getVar(maxBots,"int") ~= nil then
				return true,"^dAdvancedVoting: ^350pct ^7correspond to ^2" .. integerBotCount(50,false) .. " ^7Bots"
			else
				return false,"maxBots not set."
			end
		end

	elseif vote == "set botcount to 75pct" then
		if botWarAssistant() == 2 then
			return false,"OmniBot not loaded."
		elseif botWarAssistant() == 1 then
			return false,"Not allowed during BotWar."
		elseif getVar(vote_allow_botcount,"bool") or isRef(id) then
			if getVar(maxBots,"int") ~= nil then
				return true,"^dAdvancedVoting: ^375pct ^7correspond to ^2" .. integerBotCount(75,false) .. " ^7Bots"
			else
				return false,"maxBots not set."
			end
		end

	elseif vote == "set botcount to 100pct" then
		if botWarAssistant() == 2 then
			return false,"OmniBot not loaded."
		elseif botWarAssistant() == 1 then
			return false,"Not allowed during BotWar."
		elseif getVar(vote_allow_botcount,"bool") or isRef(id) then
			if getVar(maxBots,"int") ~= nil then
				return true,"^dAdvancedVoting: ^3100pct ^7correspond to ^2" .. integerBotCount(100,false) .. " ^7Bots"
			else
				return false,"maxBots not set."
			end
		end

	elseif vote == "enable botwar: human team allies" then
		if botWarAssistant() ~= 2 then
			if getVar(vote_allow_botwar,"bool") or isRef(id) then
				if getVar(botsPerHuman,"int") ~= nil then
					if getVar(maxBots,"int") ~= nil then
						if et.trap_Cvar_Get("botwar") ~= "2" then
							return true,"^dAdvancedVoting: ^7BotWar is currently " .. settingEnabled("botwar")
						else
							return false,"BotWar is already running with this setting."
						end
					else
						return false,"maxBots not set."
					end
				else
					return false,"botsPerHuman not set."
				end
			end
		else
			return false,"OmniBot not loaded."
		end

	elseif vote == "enable botwar: human team axis" then
		if botWarAssistant() ~= 2 then
			if getVar(vote_allow_botwar,"bool") or isRef(id) then
				if getVar(botsPerHuman,"int") ~= nil then
					if getVar(maxBots,"int") ~= nil then
						if et.trap_Cvar_Get("botwar") ~= "1" then
							return true,"^dAdvancedVoting: ^7BotWar is currently " .. settingEnabled("botwar")
						else
							return false,"BotWar is already running with this setting."
						end
					else
						return false,"maxBots not set."
					end
				else
					return false,"botsPerHuman not set."
				end
			end
		else
			return false,"OmniBot not loaded."
		end

	elseif vote == "disable botwar" then
		if botWarAssistant() ~= 2 then
			if getVar(vote_allow_botwar,"bool") or isRef(id) then
				if getVar(botsPerHuman,"int") ~= nil then
					if getVar(maxBots,"int") ~= nil then
						if et.trap_Cvar_Get("botwar") ~= "0" then
							return true,"^dAdvancedVoting: ^7BotWar is currently " .. settingEnabled("botwar")
						else
							return false,"BotWar is not currently running."
						end
					else
						return false,"maxBots not set."
					end
					
				else
					return false,"botsPerHuman not set."
				end
			end
		else
			return false,"OmniBot not loaded."
		end

	else
		if getVar(vote_allow_poll,"bool") or isRef(id) then
			return true,false
		end

		return false,"Custom polls have been disallowed."
	end

	return false,"This vote has been disabled."
end

function clientCmdAssistant(input)
	if input then
		return "^2Allowed"
	else
		return "^1Disallowed"
	end
end

function et_ClientSpawn( clientNum, revived )
	if glowMode and revived == 0 then
		et.trap_SendConsoleCommand(et.EXEC_APPEND,"!glow " .. clientNum .. ";")
	end
end

function settingEnabled(input)

	if input == "toggle thirdperson mode" then
		if thirdPersonMode then
			return "^2Enabled"
		end

	elseif input == "toggle headshot mode" then
		if tonumber(et.trap_Cvar_Get("g_headshot")) > 0 then
			return "^2Enabled"
		end

	elseif input == "toggle low gravity/fly mode" then
		if et.trap_Cvar_Get("g_gravity") ~= "800" then
			return "^2Enabled"
		end

	elseif input == "toggle glow mode" then
		if glowMode then
			return "^2Enabled"
		end

	elseif input == "toggle speed mode" then
		if et.trap_Cvar_Get("g_speed") ~= "320" then
			return "^2Enabled"
		end

	elseif input == "toggle doublejump" then
		if et.trap_Cvar_Get("g_doublejump") ~= "0" then
			return "^2Enabled"
		end

	elseif input == "toggle knifewar" then
		if et.trap_Cvar_Get("nq_war") == "2053" then
			return "^2Enabled"
		end

	elseif input == "toggle sniperwar" then
		if et.trap_Cvar_Get("nq_war") == "2065" then
			return "^2Enabled"
		end

	elseif input == "toggle panzerwar" then
		if et.trap_Cvar_Get("nq_war") == "2057" then
			return "^2Enabled"
		end

	elseif input == "toggle riflewar" then
		if et.trap_Cvar_Get("nq_war") == "2113" then
			return "^2Enabled"
		end

	elseif input == "botwar" then

		if botWarAssistant() ~= 2 then
			local botWar = tonumber(et.trap_Cvar_Get("botwar"))

			if botWar == 1 then
				return "^2Enabled ^y| ^7Human Team: ^?Axis"
			elseif botWar == 2 then
				return "^2Enabled ^y| ^7Human Team: ^~Allies"
			else
				if getVar(botsPerHuman,"int") ~= nil then
					return "^1Disabled ^y| ^7botsPerHuman: ^3" .. getVar(botsPerHuman,"int")
				end
			end
		else
			return "^1Disabled ^y| ^7OmniBot not loaded"
		end
	end

	return "^1Disabled"
end

function getVar(input,param)

	if type(input) == "string" and string.sub(input,1,5) == "cvar." then

		if param == "bool" then
			if et.trap_Cvar_Get(string.sub(input,6)) ~= "0" then
				return true
			else
				return false
			end

		elseif param == "int" then
			return tonumber(et.trap_Cvar_Get(string.sub(input,6)))

		elseif param == "str" then
			return et.trap_Cvar_Get(string.sub(input,6))
		end
	
	end

	return input
end

function refCall(input,param)

	if input == "cointoss" then
		execVote(input, nil, true)
		return 1

	elseif input == "thirdpersonmode" then
		execVote(input, nil, true)
		return 1

	elseif input == "headshotmode" then
		execVote(input, nil, true)
		return 1

	elseif input == "flymode" then
		execVote(input, nil, true)
		return 1

	elseif input == "glowmode" then
		execVote(input, nil, true)
		return 1

	elseif input == "speedmode" then
		execVote(input, nil, true)
		return 1

	elseif input == "maptimelimit" then
		execVote(input, math.floor(tonumber(param)), true)
		return 1

	elseif input == "doublejump" then
		execVote(input, nil, true)
		return 1

	elseif input == "endmap" then
		execVote(input, nil, true)
		return 1

	elseif input == "knifewar" then
		execVote(input, nil, true)
		return 1

	elseif input == "sniperwar" then
		execVote(input, nil, true)
		return 1

	elseif input == "panzerwar" then
		execVote(input, nil, true)
		return 1

	elseif input == "riflewar" then
		execVote(input, nil, true)
		return 1

	elseif input == "kickbots" then
		execVote(input, nil, true)
		return 1

	elseif input == "botcount" then
		execVote(input, tonumber(param), true)
		return 1

	elseif input == "lockteam" then
		execVote(input, param, true)
		return 1

	elseif input == "unlockteam" then
		execVote(input, param, true)
		return 1

	elseif input == "botwar" then
		execVote(input, tonumber(param), true)
		return 1
	end

	return 0
end

function botWarAssistant()

	-- this function returns the following values:
	-- 0 = botWar is not running
	-- 1 = botWar is running
	-- 2 = OmniBot not loaded

	if et.trap_Cvar_Get("omnibot_enable") ~= "1" or et.trap_Cvar_Get("botwar") == "" then
		return 2
	elseif et.trap_Cvar_Get("botwar") == "0" then
		return 0
	else
		return 1
	end
end
























