module_name    = "SpawnInvul"
module_version = "0.1"
Author         = "Nappy"
Description    = "Modify SpawnInvulerabiltiy durations"

-- This script modifies the duration of the spawn shield.  If either g_alliedSpawnInvul or g_axisSpawnInvul are non-zero, they will override g_spawnInvul.
-- Resulting cvars: g_spawnInvul < duration >, g_axisSpawnInvul < duration >, g_alliedSpawnInvul < duration >  ( all times in milliseconds )
-- If none of the above cvars are present, spawn shield time will default to defaultSpawnInvul 
 
-- DEFAULT VALUE
defaultSpawnInvul = 3


function et_InitGame(levelTime,randomSeed,restart)
        et.G_Print("SpawnInvul module loaded\n")
	et.RegisterModname(string.format("%s v%s", module_name, module_version))
end

function et_ClientSpawn(clientNum,revived)
	if ( revived == 0 ) then 

		local spawnInvul = defaultSpawnInvul
		local axisSpawnInvul = 0
		local alliedSpawnInvul = 0 

        	local client_team = tonumber(et.gentity_get(clientNum, "sess.sessionTeam"))
		local cvar_axisInvul = et.trap_Cvar_Get( "g_axisSpawnInvul" )
		local cvar_alliedInvul = et.trap_Cvar_Get( "g_alliedSpawnInvul" )
        	local cvar_spawnInvul = et.trap_Cvar_Get( "g_spawnInvul" )

		if( cvar_spawnInvul ~= "" ) then
			spawnInvul = tonumber( cvar_spawnInvul )
		end
		if( cvar_axisInvul ~= "" ) then
			axisSpawnInvul = tonumber( cvar_axisInvul )
		end
		if( cvar_alliedInvul ~= "" ) then
			alliedSpawnInvul = tonumber( cvar_alliedInvul )
		end
	
	
		if et_leveltime then
                	-- axis
			if ( client_team == 1 ) then
                        	if( axisSpawnInvul == 0 ) then 
               				et.gentity_set(clientNum, "ps.powerups", 1, spawnInvul + et_leveltime )
				else
               				et.gentity_set(clientNum, "ps.powerups", 1, axisSpawnInvul + et_leveltime )
				end
			end
                	-- allies
			if ( client_team == 2 ) then
                        	if( alliedSpawnInvul == 0 ) then 
               				et.gentity_set(clientNum, "ps.powerups", 1, spawnInvul + et_leveltime )
				else
               				et.gentity_set(clientNum, "ps.powerups", 1, alliedSpawnInvul + et_leveltime )
				end
			end
		end
	end

end

function et_RunFrame( levelTime )
	et_leveltime = levelTime
end

