-- Major Zeman's Rules printer
-- version 0.1 (20.7.2007)

-- changelog
--
-- v0.1
-- initial
-- v0.2
-- modname
-- server message

--
-- The printer can handle both unix and windows line endings (and mac, too)
-- in the input file, however as a price for this, it ignores any empty lines
-- in the input file. Therefore if you desire to print an empty line inside the
-- rules text, use a line with one space (or more of course) instead.
--

------------------------------------------ name ----------------------------------------------

Modname = "Rules"
Version = "0.2"
Text = "^wType ^1/rules ^wto see Server rules"

function et_InitGame(levelTime,randomSeed,restart)
   et.G_Print("[Rules] Version:0.2 Loaded\n")
   et.RegisterModname(Modname .. " " .. Version)
   et.trap_SendServerCommand(-1, "b 8 \""..Text.." \n\"" )
end



------------------------------------------ settings ----------------------------------------------

-- rules filename
RULES_FILENAME = "rules.txt"



----------------------------------------- functions ---------------------------------------------


-- print message to either client's console or (if clientID == nil) to server console
function printmsg(message, clientID)
    if not message then
        return
    end

    -- replace "s in message with 's
    local dummy
    message, dummy = string.gsub(message, "\"", "'")

    if clientID then
        et.trap_SendServerCommand(clientID, "print \"".. message .."^7\n\"")
    else
        if lastcallerID then
            et.trap_SendServerCommand(lastcallerID, "print \"".. message .."^7\n\"")
        else
            et.G_Print(message .."^7\n")
        end
    end
end


-- reads file and returns string array of rows (indexed from 1) and number of rows
function readFile(filename)
    local fd, len
    local rows = {}

    fd, len = et.trap_FS_FOpenFile(filename, et.FS_READ)

    if len == -1 then
        return rows, 0
    else
        --read it all
        local filestr = et.trap_FS_Read(fd, len)

        local rowcount = 0
        for line in string.gfind(filestr, "[^\r\n]+") do
            rowcount = rowcount + 1
            rows[rowcount] = line
        end

            et.trap_FS_FCloseFile(fd)
            return rows, rowcount
      end
end



---------------------------------- client command functions ------------------------------


-- print rules to client
function printrules(clientID)
    rows, numrows = readFile(RULES_FILENAME)

    printmsg("", clientID)

    for i = 1, numrows do
            printmsg(rows[i], clientID)
    end

    printmsg("", clientID)
end



--------------------------------------- callbacks ----------------------------------------

function et_ClientCommand( clientNum, command )
    -- lowercase
    command = string.lower(command)

    if command == "rules" then
        printrules(clientNum)
        return 1
    end

    return 0
end


