#!/bin/bash
	# etserver.sh v0.1b 11.April.2017 ETc|#Jay.# 
	# needed packages: apt-get install screen
	# features:
	# - ./etserver.sh start			[what is it doing? -> starts etserver.]
	# - ./etserver.sh stop			[what is it doing? -> stops etserver.]
	# - ./etserver.sh restart		[what is it doing? -> stops the etserver if running then it restarts etserver.]
	# - ./etserver.sh restart_log	[what is it doing? -> stops the etserver if running, renames your server.log/etconsole.log/admin.logcrash.log to name_of_log_day_month_year.log and moves it to a log folder. then it restarts etserver.]
	#
	# For logrotate + autorestart ET server every day, create a crontab. Example  (4:30am every day): */30 4 * * * /home/etserver/etserver.sh restart_log
	# Only autorestart ET Server every day, create a crontab. Example  (4:30am every day): */30 4 * * * /home/etserver/etserver.sh restart
	# If server crashed start it automaticly. Create a crontab. Example  (check every minute if server down. if down start Et Server ): * * * * * /home/etserver/etserver.sh start
	# Backup your logs first. Use at your own risk. check this site for updates https://pastebin.com/GbpyWbgp
	# dont run as root, create a user as example etserver. Dont forget to give the file et300 and etserver.sh chmod 755
	# ideas are welcome, report bugs to jay@clan-etc.de, support at http://www.clan-etc.de/phpBB3/viewtopic.php?f=29&t=3506
	# changelog: deleted alot of useless code, fixed echo´s, changed lognames to servername_year_month_day_etconsole.log



servername=server1 							#no spaces 
etpath=/home/etserver						#path to the etserver folder, same folder where the etded/et300 file is.
etded=etlded    							#standart is etded=etded.x86
ip=localhost								#gameserver ip 12.34.56.78 or localhost
port=27960									#2.60b port
mod=legacy									#game mod
logdir="$etpath/$mod/log" 					#the folder where the new log will be saved
serverlog="$etpath/$mod/server.log" 		#path to the log wich needs to be moved and renamed. # add a route infront of the line if you wont use it.
consolelog="$etpath/$mod/etconsole.log" 	#path to the log wich needs to be moved and renamed. # add a route infront of the line if you wont use it.
adminlog="$etpath/$mod/admin.log"			#path to the log wich needs to be moved and renamed. # add a route infront of the line if you wont use it.
#crashlog="$etpath/$mod/crash.log" 			#path to the log wich needs to be moved and renamed. # add a route infront of the line if you wont use it.
tstamp=$(date +"%Y_%m_%d")


#change nothing below, only if you know what you do.

case "$1" in

'start')
			echo -e "\e[92m--- $servername $etpath $ip:$port 2.60b $xport 2.55 $mod $map $tstamp start --- \e[0m"
	ps ax | grep "+set net_port $port" | grep -v "grep" > /dev/null 2>&1 		#check if the ET server is in the processes list
	if [ $? -ne 0 ]                                     					# NO ? so ...reload the ET Server
		then
			cd $etpath
			screen -m -d -S "$servername" ./$etded +set fs_basepath $etpath +set fs_homepath $etpath +set vm_game 0 +set net_ip $ip +set net_port $port +set fs_game $mod +exec etl_server.cfg +set sv_autoUpdate 1 +set ttycon 0 +set com_hunkmegs 128 +set com_zonemegs 128
			echo -e "\e[92m-- \e[0m"
			sleep 1
			echo -e "\e[92m-- \e[0m"
			sleep 1
			echo -e "\e[92m--- $servername $etpath $ip:$port 2.60b $xport 2.55 $mod $map $tstamp started --- \e[0m"
		else
			echo -e "\e[91m--- $servername $etpath $ip:$port 2.60b $xport 2.55 $mod is allready running!!! --- \e[0m"
	fi
exit 0
		;;

'stop')
   if [[ `screen -ls |grep $servername` ]]
		then
			echo -e "\e[92m--- $servername $etpath $ip:$port 2.60b $xport 2.55 $mod stop --- \e[0m"
			screen -X -S "$servername" quit 
			echo -e "\e[92m-- \e[0m"
			sleep 1
			echo -e "\e[92m-- \e[0m"
			sleep 1
			echo -e "\e[92m--- $servername $etpath $ip:$port 2.60b $xport 2.55 $mod stopped --- \e[0m"
		else
			echo -e "\e[91m--- $servername $etpath $ip:$port 2.60b $xport 2.55 $mod is not running. --- \e[0m"
	fi
		;;

'restart')
		$0 stop
		$0 start
		;;

'restart_log')
		$0 stop	
			echo -e "\e[91m---- move logs to folder: $etpath/$mod/log ---- \e[0m"
			mkdir -p $etpath/$mod/log 													#create log folder if not exist
            mv "$serverlog" "$logdir/${servername}_${tstamp}_etserver.log" 				#move and rename log. todo merge if allready exist
            mv "$consolelog" "$logdir/${servername}_${tstamp}_etconsole.log" 
			mv "$adminlog" "$logdir/${servername}_${tstamp}_admin.log" 
			# mv "$crashlog" "$logdir/${servername}_${tstamp}_crash.log" 
			echo -e "\e[91m---- logs moved to folder: $etpath/$mod/log ---- \e[0m"
		$0 start
		;;

*)
			echo "usage: $0 { start | stop | restart | restart_log }"
		;;

esac
exit 0