unit File_MainForm;

{$mode objfpc}{$H+}

interface

uses
    Classes,
    SysUtils,
    LResources,
    Forms,
    Controls,
    Graphics,
    Dialogs,
    Menus,
    ComCtrls,
    SynEdit,
    SynCompletion,
    SynMacroRecorder,
    SynHighlighterCPP,
    ExtCtrls,
    StdCtrls,
    fichierclassegoal,
    fichierclasseevents,
    fichierformselectforskeleton,
    Buttons,
    ActnList,
    CheckLst, SynHighlighterAny;



var
   tabIndent: array [0..8] of string;
   tabTeams: array [1..2] of string;

const
   STRTRIGFOONAME = 'TriggerFoo';

type

  { TMainForm }

TMainForm = class(TForm)
    actImportGoals: TAction;
    actGenSkelton: TAction;
    actImportEvents: TAction;
    actQuit: TAction;
    actOpenGM: TAction;
    actSaveGM: TAction;
    ActionList1: TActionList;
    btGenerate: TButton;
    cbxGoalAction: TComboBox;
    chklstGoals: TCheckListBox;
    cbxEvents: TComboBox;
    edBias: TEdit;
    grpbxAxis: TGroupBox;
    grpbxAxis1: TGroupBox;
    ImageList1: TImageList;
    Label1: TLabel;
    Label2: TLabel;
    MainMenu1: TMainMenu;
    MenuItem1: TMenuItem;
    mnuFile: TMenuItem;
    mniOpenGM: TMenuItem;
    mniClose: TMenuItem;
    mniSaveGM: TMenuItem;
    mniImportGoals: TMenuItem;
    mniGenSkelton: TMenuItem;
    OpenDialog1: TOpenDialog;
    OpenDialogDump: TOpenDialog;
    PageControl1: TPageControl;
    Panel1: TPanel;
    Panel2: TPanel;
    pnlGoalEdit: TPanel;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    RadioButton3: TRadioButton;
    RadioButton4: TRadioButton;
    RadioButton5: TRadioButton;
    RadioButton6: TRadioButton;
    SaveDialog1: TSaveDialog;
    Splitter1: TSplitter;
    StatusBar1: TStatusBar;
    SynAutoComplete1: TSynAutoComplete;
    SynAutoComplete2: TSynAutoComplete;
    SynCppSyn1: TSynCppSyn;
    memoEdition: TSynEdit;
    SynMacroRecorder1: TSynMacroRecorder;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    ToolBar1: TToolBar;
    ToolButton1: TToolButton;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;

    procedure actImportEventsExecute(Sender: TObject);
    procedure actSaveGMExecute(Sender: TObject);
    procedure btGenerateClick(Sender: TObject);
    procedure GenSkeltonClick(Sender: TObject);
    procedure grpbxAxisClick(Sender: TObject);
    procedure mniCloseClick(Sender: TObject);
    procedure mniImportGoalsClick(Sender: TObject);
    procedure mniOpenGMClick(Sender: TObject);
    procedure mniSaveGMClick(Sender: TObject);

  private
    { private declarations }
    iIndent: integer;
    
    strlstEvents: TStringList;
    strlstGoals: TStringList;

    procedure ReadGoalsFromFile(strFile: string);
    
    procedure AddLine(strLine: string; iIncr: integer = 0);
    procedure AddOnTrigger(pGoal: TGoal);
    procedure AddSetBias(pGoal: TGoal; strBias: string = '');
    procedure AddSetAvail(pGoal: TGoal; iTeam: integer; strAvail: string);
    procedure AddSetAvailAuto(pGoal: TGoal);
    procedure AddIfGoal(pGoal: TGoal);
    procedure AddEmptyIfGoal(pGoal: TGoal);
    procedure GenGoalFunc(pGoal: TGoal);
    procedure GenTriggerFoo(iEventIndex: integer; pEvent: TEvent);

  public
    { public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  end;

var
  MainForm: TMainForm;





implementation



{ TMainForm }

constructor TMainForm.Create(AOwner: TComponent);
begin
     inherited Create(Owner);
     
     tabIndent[0] := '';
     tabIndent[1] := #9;
     tabIndent[2] := #9#9;
     tabIndent[3] := #9#9#9;
     tabIndent[4] := #9#9#9#9;
     tabIndent[5] := #9#9#9#9#9;
     tabIndent[6] := #9#9#9#9#9#9;
     tabIndent[7] := #9#9#9#9#9#9#9;
     tabIndent[8] := #9#9#9#9#9#9#9#9;
     
     iIndent := 1;
     
     tabTeams[1] := 'TEAM.AXIS';
     tabTeams[2] := 'TEAM.ALLIES';

    strlstEvents := TStringList.Create;
    strlstGoals := TStringList.Create;

end;


destructor TMainForm.Destroy;
begin
     if Assigned(strlstEvents) then
     begin
          strlstEvents.Free;
          strlstEvents := nil;
     end;

     if Assigned(strlstGoals) then
     begin
          strlstGoals.Free;
          strlstGoals := nil;
     end;
     
     inherited;
end;




procedure TMainForm.ReadGoalsFromFile(strFile: string);
var
    Fichier: System.TextFile;
    strTmp: string;
    pGoal: TGoal;
begin

   if not FileExists(strFile) then
   begin
        ShowMessage('File do not exists !');
        Exit;
   end;

   FileMode := fmOpenRead;
   AssignFile(Fichier, strFile);
   Reset(Fichier);

   // Goals list reset
   strlstGoals.Clear;
   // Events list reset
   strlstEvents.Clear;
   
   // for each file's line
   repeat
	   readln(Fichier, strTmp);

      // We remove leading and ending spaces
      strTmp := Trim(strTmp);

      // If line is empty
      if strTmp = '' then
       // Next line
       continue;
          
       // if this is not a possible goal line...
      if (Pos('bias', strTmp) < 1) or (Pos('->', strTmp) < 1) then
      begin
         // This non empty line will be considered as an event
         // If this event do not allready exists
         if strlstEvents.IndexOf(strTmp) = -1 then
          // Add it to the events list
          strlstEvents.Add(strTmp);
         // Next line
         continue;
      end;
          

      // Goal object creation + initialisation (goal line parsing)
      pGoal := TGoal.Create(strTmp);

      // If this event do not allready exists
      if strlstGoals.IndexOf(pGoal.strName) = -1 then
      begin
         // Goal addition to cbxGoal
         strlstGoals.AddObject(pGoal.strName, pGoal);
       end
       else
           // This goal is allready known -> trash
           pGoal.free;
   until eof(Fichier);

   // All is done...
   CloseFile(Fichier);
end;




procedure TMainForm.AddOnTrigger(pGoal: TGoal);
begin
     AddLine('OnTrigger("' + pGoal.strName + '", ' + pGoal.strFuncName + ');');
end;




procedure TMainForm.AddSetBias(pGoal: TGoal; strBias: string = '');
var
   strTmp: string;
begin
     if strBias = '' then
        strTmp := pGoal.strBIas
     else
         strTmp := strBias;
         
     AddLine(pGoal.strVarName + '.Bias = ' + strTmp + ';')
end;




procedure TMainForm.AddSetAvail(pGoal: TGoal; iTeam: integer; strAvail: string);
begin
     AddLine(pGoal.strVarName + '.SetAvailable(' + tabTeams[iTeam] + ', ' + strAvail + ');');
end;


procedure TMainForm.AddSetAvailAuto(pGoal: TGoal);
begin
     // Axis SetAvail
     if(pGoal.iTeam and TEAMAXIS) = TEAMAXIS then
        AddSetAvail(pGoal, 1, 'true')
     else
         AddSetAvail(pGoal, 1, 'false');
     // Allied SetAvail
     if(pGoal.iTeam and TEAMALLIES) = TEAMALLIES then
         AddSetAvail(pGoal, 2, 'true')
     else
         AddSetAvail(pGoal, 2, 'false');
end;


procedure TMainForm.AddEmptyIfGoal(pGoal: TGoal);
begin
     // variable creation
     AddLine(pGoal.strVarName + ' = GetGoal("' + pGoal.strName + '");');
     // if begin
     AddLine('if(' + pGoal.strVarName + ')');
     AddLine('{');
     // Empty line
     AddLine('', -1);
     // if end
     AddLine('}');
     // Empty line
     AddLine('');
end;


procedure TMainForm.AddIfGoal(pGoal: TGoal);
begin
     // variable creation
     AddLine(pGoal.strVarName + ' = GetGoal("' + pGoal.strName + '");');
     // if begin
     AddLine('if(' + pGoal.strVarName + ')');
     AddLine('{');
     iIndent := iIndent + 1;
     // SetAvailable 2 teams
     AddSetAvailAuto(pGoal);
     // Bias...
     AddSetBias(pGoal);
     // if end
     iIndent := iIndent - 1;
     AddLine('}');
     // Empty line
     AddLine('');
end;

{
global OnDoor = function(trigger)
}
procedure TMainForm.GenGoalFunc(pGoal: TGoal);
begin
     // Empty line
     AddLine('');
     // function creation
     AddLine('global ' + pGoal.strFuncName + ' = function(trigger)');
     AddLine('{');
     iIndent := iIndent + 1;
     // if condition
     AddIfGoal(pGoal);
     // function end
     iIndent := iIndent - 1;
     AddLine('};');
     // Empty line
     AddLine('');
end;





procedure TMainForm.GenTriggerFoo(iEventIndex: integer; pEvent: tEvent);
var
   iCmpt: integer;
   pGoal: TGoal;
   strTmp: string;
begin
     // Empty line
     AddLine('');
     // function creation
     strTmp := STRTRIGFOONAME + IntToStr(iEventIndex);
     AddLine('// Trigger function for event : "' + pEvent.strName + '"');
     AddLine('global ' + strTmp + ' = function(trigger)');
     AddLine('{');
     iIndent := iIndent + 1;

     // Some usefull commented debug print
     AddLine('//print("^q DEBUG : ' + strTmp + '(' + pEvent.strName + ')");');
     // Now we parse Event for goals used in this one
     for iCmpt := 0 to pEvent.Count - 1 do
     begin
        pGoal := pEvent.GetGoal(iCmpt);
        
        // if somthing is wrong with this goal
        if not Assigned(pGoal) then
           // next goal (not critical)
           continue;

        // we add an if gaol + setavail + setbias
        AddIfGoal(pGoal);
        // Then an empty Line
        AddLine('');
     end;

     // function end
     iIndent := iIndent - 1;
     AddLine('};');

     // Some empty lines
     AddLine('');
     AddLine('');
     AddLine('');
     AddLine('');

end;




procedure TMainForm.AddLine(strLine: string; iIncr: integer = 0);
begin
     iIndent  := iIndent + iIncr;
     MemoEdition.Lines.Insert(MemoEdition.CaretY - 1, tabIndent[iIndent] + strLine);
     MemoEdition.CaretY := MemoEdition.CaretY + 1;
end;







procedure TMainForm.GenSkeltonClick(Sender: TObject);
var
   iCmpt: integer;
   iCmptGoals: integer;
   strGoalVar: string;
   pGoal: TGoal;
   pEvent: TEvent;
begin
   FormSelectForSkeleton.chklstEvents.Items := strlstEvents;
   FormSelectForSkeleton.chklstGoals.Items := strlstGoals;


   // editor file reinitialisation
   MemoEdition.ClearAll;
   // Just an empty line
   MemoEdition.Lines.Add('');;
   // Caret pos at the begining
   MemoEdition.CaretY := MemoEdition.CaretY + 1;
   MemoEdition.CaretX := 1;

   iIndent := 0;

   with FormSelectForSkeleton do
   begin
      EnableCtrl(chklstEvents, False);

      CheckList(chklstEvents, CHECKALL);
      ShowMessage('Select goals that you want to initialize in OnMapLoad function');

      if ShowModal = mrCancel then
         exit;
   end;

   // begining of map initialisation
   AddLine('global OnMapLoad = function()');
   AddLine('{');

   // ----------------------------------------------
   // For all selected goals : setAvail (per team) + setbias
   for iCmpt := 0 to strlstGoals.Count - 1 do
   begin
      // if goal is selected
      if FormSelectForSkeleton.chklstGoals.Checked[iCmpt] then
      begin
         iIndent := 1;
         // We get goal form objects of cbxGoal
         pGoal := TGoal(strlstGoals.Objects[iCmpt]);
         // Comment line lines
         AddLine('// Default initialisation for ' + pGoal.strName + ' goal');
         // if condition
         AddIfGoal(pGoal);
         // empty line
         AddLine('');
      end;
   end;

   // empty lines
   AddLine('');
   AddLine('');
   AddLine('');
   AddLine('');

   // Now triggers selection
   with FormSelectForSkeleton do
   begin
      EnableCtrl(chklstEvents, True);
      CheckList(chklstEvents, UNCHECKALL);
//      CheckList(chklstGoals, UNCHECKALL);
      ShowMessage('Now, select events / trigger (+ per events associated goals) that you wants tu use in your script');

      if ShowModal = mrCancel then
         exit;
   end;


   // ----------------------------------------------
   with FormSelectForSkeleton.chklstEvents do
   begin
      // for all checked events we add a OnTrigger in OnMapLoad
      for iCmpt := 0 to Items.Count - 1 do
      begin
         // If event isn't used
         if not Checked[iCmpt] then
           // Next event
           Continue;

         // Else we get the TEvent object from this item
         pEvent := TEvent(Items.Objects[iCmpt]);

         // If something is wrong with event pointer
         if not Assigned(pEvent) then
            // Next event (it's not so critical)
            Continue;

         AddLine('// OnTrigger for event "' + pEvent.strName + '"');
         AddLine('OnTrigger("' + pEvent.strName + '",' + STRTRIGFOONAME + IntToStr(iCmpt) + ');');
      end;
   end;

   // end of map initialisation
   iIndent := 0;
   AddLine('};');

   // empty lines
   AddLine('');
   AddLine('');
   AddLine('');
   AddLine('');

   // ----------------------------------------------
   with FormSelectForSkeleton.chklstEvents do
   begin
     // for all checked events we trigger function
     for iCmpt := 0 to Items.Count - 1 do
     begin
        // If event isn't used
        if not Checked[iCmpt] then
           // Next event
           Continue;

        // Else we get the TEvent object from this item
        pEvent := TEvent(Items.Objects[iCmpt]);

        // If something is wrong with event pointer
        if not Assigned(pEvent) then
           // Next event (it's not so critical)
           Continue;
        // we generate a function for this trigger
        GenTriggerFoo(iCmpt, pEvent);
     end;
   end;
end;

procedure TMainForm.grpbxAxisClick(Sender: TObject);
begin

end;




procedure TMainForm.mniCloseClick(Sender: TObject);
begin
   Close;
end;

procedure TMainForm.mniImportGoalsClick(Sender: TObject);
begin
   if(OpenDialogDump.Execute) then
   begin
       ReadGoalsFromFile(OpenDialogDump.FileName);

       cbxEvents.Items := strlstEvents;
       if cbxEvents.Items.Count > 0 then
          cbxEvents.ItemIndex := 0;

       chklstGoals.Items := strlstGoals;
       if chklstGoals.Items.Count > 0 then
          chklstGoals.ItemIndex := 0;
   end;

end;



procedure TMainForm.mniOpenGMClick(Sender: TObject);
begin
   if (OpenDialog1.Execute) then
   begin
       memoEdition.Lines.LoadFromFile(OpenDialog1.FileName);
   end;
end;




procedure TMainForm.mniSaveGMClick(Sender: TObject);
begin
  if (SaveDialog1.Execute) then
  begin
       memoEdition.Lines.SaveToFile(SaveDialog1.FileName);
  end;

end;




procedure TMainForm.btGenerateClick(Sender: TObject);
var
   iActionIndex: integer;
   iGoalIndex: integer;
   pGoal: TGoal;
begin
//   iGoalIndex := cbxGoal.ItemIndex;
   iActionIndex := cbxGoalAction.ItemIndex;

   if iActionIndex < 0 then
      exit;

   if iGoalIndex < 0 then
      exit;

//   pGoal := TGoal(cbxGoal.Items.Objects[iGoalIndex]);

   if not Assigned(pGoal) then
      exit;

   case iActionIndex of
      // Bias
      0: AddSetBias(pGoal);
      // Complete goal function
      1: GenGoalFunc(pGoal);
      // GetGoal + if
      2: AddEmptyIfGoal(pGoal);
      // GetGoal + if + setavailable 2 teams + bias
      3: AddIfGoal(pGoal);
      // OnTrigger
      4: AddOnTrigger(pGoal);
      // OnTrigger + setavailable 2 teams + bias
      5:
      begin
           AddOnTrigger(pGoal);
           AddSetAvailAuto(pGoal);
           AddSetBias(pGoal);
      end;
      // SetAvailable axis true
      6: AddSetAvail(pGoal, 1, 'true');
      // SetAvailable axis false
      7: AddSetAvail(pGoal, 1, 'false');
      // SetAvailable allies true
      8: AddSetAvail(pGoal, 2, 'true');
      // SetAvailable allies false
      9: AddSetAvail(pGoal, 2, 'false');
   end;
end;





procedure TMainForm.actSaveGMExecute(Sender: TObject);
begin
   if (SaveDialog1.Execute) then
   begin
      memoEdition.Lines.SaveToFile(SaveDialog1.FileName);
   end;
end;

procedure TMainForm.actImportEventsExecute(Sender: TObject);
begin
     // If no file have been selected
     if not OpenDialogDump.Execute then
        // Just go away
        exit;
     // If string list is available
     if assigned(strlstEvents) then
     begin
          // Clear list
          strlstEvents.Clear;
          // load list
          strlstEvents.LoadFromFile(OpenDialogDump.FileName);
     end;
end;




initialization
  {$I file_mainform.lrs}

end.

