unit FichierFormSelectForSkeleton;

{$mode objfpc}{$H+}

interface

uses
  Classes,
  SysUtils,
  LResources,
  Forms,
  Controls,
  Graphics,
  Dialogs,
  CheckLst,
  PairSplitter,
  ExtCtrls,
  StdCtrls,
  Buttons,
  fichierclassegoal, Menus, IDEWindowIntf;



const
   CHECKALL = 1;
   UNCHECKALL = 2;
   INVERTCHECK = 3;




type
{ TFormSelectForSkeleton }

TFormSelectForSkeleton = class(TForm)
      btGenerate: TButton;
      Button1: TButton;
      chkAllies: TCheckBox;
      chkAxis: TCheckBox;
      chklstEvents: TCheckListBox;
      chklstGoals: TCheckListBox;
      edBias: TEdit;
      IDEDialogLayoutStorage1: TIDEDialogLayoutStorage;
      lblBias: TLabel;
      mnuGoaInvert: TMenuItem;
      mnuEvtSel: TMenuItem;
      mnuEvtUnsel: TMenuItem;
      mnuGoalSel: TMenuItem;
      mnuGoalUnsel: TMenuItem;
      mnuEvtInvert: TMenuItem;
      PairSplitter1: TPairSplitter;
      PairSplitterSide1: TPairSplitterSide;
      PairSplitterSide2: TPairSplitterSide;
      pnlGoalEdit: TPanel;
      pnlAvailable: TPanel;
      pnlGoals: TPanel;
      EventsPopup: TPopupMenu;
      GoalsPopup: TPopupMenu;

      procedure chkAlliesClick(Sender: TObject);
      procedure chkAxisClick(Sender: TObject);
      procedure chklstEventsClick(Sender: TObject);
      procedure chklstEventsMouseUp(Sender: TOBject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
      procedure chklstGoalsClick(Sender: TObject);
      procedure chklstGoalsDblClick(Sender: TObject);
      procedure chklstGoalsDrawItem(Control: TWinControl; Index: Integer; ARect: TRect; State: TOwnerDrawState);
      procedure chklstGoalsMouseUp(Sender: TOBject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
      procedure edBiasChange(Sender: TObject);
      procedure MenuItem1Click(Sender: TObject);
      procedure mnuEvtInvertClick(Sender: TObject);
      procedure mnuEvtUnselClick(Sender: TObject);
      procedure mnuGoaInvertClick(Sender: TObject);
      procedure mnuGoalSelClick(Sender: TObject);
      procedure mnuGoalUnselClick(Sender: TObject);

   private
      function GetCurrentGoal : TGoal;
      procedure ChangeTeamAvailability(iTeam: integer; bAvail: boolean);
      procedure Popup(Sender: TOBject; pMenu: TPopupMenu; Button: TMouseButton; X, Y: Integer);

   public
      // Temporary, until "ModalResult" property is functionnal
      CloseCondition: integer;
      
      constructor Create(AOwner: TComponent); override;

      procedure CheckList(pList: TCheckListBox; iCheck: integer);
      procedure EnableCtrl(pCtrl: TWinControl; bEnable: boolean);
end;




var
  FormSelectForSkeleton: TFormSelectForSkeleton;

implementation

uses
    fichierclasseevents,
    LCLType,
    LCLProc;

{ TFormSelectForSkeleton }




function TFormSelectForSkeleton.GetCurrentGoal : TGoal;
var
   pGoal: TGoal;
   pEvent: TEvent;
   iGoalIndex: integer;
   iEventIndex: integer;
   strGoalName: string;
begin
   // base result : no goal found
   Result := nil;
   
   // if there is no goal selected
   iGoalIndex := chklstGoals.ItemIndex;
   if iGoalIndex < 0 then
      // bye
      exit;

   // if there is no event selected
   iEventIndex := chklstEvents.ItemIndex;
   if iEventIndex < 0 then
      // bye
      exit;

   // we get current goal name
   strGoalName := chklstGoals.Items[iGoalIndex];

   // We try now to get the selected event
   pEvent := TEvent(chklstEvents.Items.Objects[iEventIndex]);

   // If something is weird with event pointer
   if not Assigned(pEvent) then
   begin
      exit;
   end;

   // We try now to find and get the goal from event
//   ShowMessage('Event.find ' + strGoalName);
   iGoalIndex := pEvent.Find(strGoalName);

   // If goal haven't be found
   if iGoalIndex < 0 then
      // bye
      exit;

   // We get the associated goal object and set it as result \o/
   Result := pEvent.GetGoal(iGoalIndex);
//   ShowMessage(Result.strName);
end;




procedure TFormSelectForSkeleton.ChangeTeamAvailability(iTeam: integer; bAvail: boolean);
var
   pGoal: TGoal;
   iIndex: integer;
begin
   pGoal := GetCurrentGoal;
   if not Assigned(pGoal) then
      exit;

   // we set team availability from checkbox state
   if bAvail then
      pGoal.iTeam := (pGoal.iTeam OR iTeam)
   else
      pGoal.iTeam := (pGoal.iTeam and (not iTeam));

end;



procedure TFormSelectForSkeleton.chkAlliesClick(Sender: TObject);
begin
   ChangeTeamAvailability(TEAMALLIES, chkAllies.Checked);
end;




procedure TFormSelectForSkeleton.chkAxisClick(Sender: TObject);
begin
     ChangeTeamAvailability(TEAMAXIS, chkAxis.Checked);
end;





procedure TFormSelectForSkeleton.EnableCtrl(pCtrl: TWinControl; bEnable: boolean);
begin
//   pCtrl.Enabled := bEnable;
   pCtrl.Visible := bEnable;

{
   if bEnable then
      chklstGoals.Cursor := crDefault
   else
      chklstGoals.Cursor := crNo;
}
end;






procedure TFormSelectForSkeleton.chklstEventsClick(Sender: TObject);
var
   iIndex: integer;
   Event: TEvent;
   iCmpt: integer;
begin
   iIndex := chklstEvents.ItemIndex;

   if iIndex < 0 then
      exit;

   for iCmpt := 0 to chklstGoals.Count - 1 do
   begin
      chklstGoals.Checked[iCmpt] := False;
   end;

   if chklstEvents.Checked[iIndex] then
   begin
      // event is chacked -> enable goal list edition
      EnableCtrl(chklstGoals, True);

      // We get current event
      Event := TEvent(chklstEvents.Items.Objects[iIndex]);
      // if event is not initialised
      if not Assigned(Event) then
      begin
         // We create one
         Event := TEvent.Create;
         // Name setting
         Event.strName := chklstEvents.Items[iIndex];
         // List addition
         chklstEvents.Items.Objects[iIndex] := Event;
      end
      else
      // Event is initialised, so, we refresh goals list used by this one
      begin
         Event.SelectGoals(chklstGoals);
      end;
   end
   else
   begin
      EnableCtrl(chklstGoals, False);
   {
     Event := TEvent(chklstEvents.Items.Objects[iIndex]);
     if Assigned(Event) then
     begin
          Event.Free;
          Event := nil;
     end;
   }
   end;
end;


procedure TFormSelectForSkeleton.Popup(Sender: TOBject; pMenu: TPopupMenu; Button: TMouseButton; X, Y: Integer);
var
   pt: TPoint;
   pCtrl: TWinControl;
begin
   // If this is a right click
   if Button = mbRight then
   begin
      // Get the checklistbox that sent de message
      pCtrl := TWinControl(Sender);

      // Convert in control coordinates to screen coordinates
      pt.X := X;
      pt.Y := Y;
      
      pt := pCtrl.ClientToScreen(pt);
      // Show the menu near the cursor
      pMenu.PopUp(pt.X, pt.Y);
   end;

end;



procedure TFormSelectForSkeleton.chklstEventsMouseUp(Sender: TOBject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
   Popup(Sender, EventsPopup, Button, X, Y);
end;




procedure TFormSelectForSkeleton.chklstGoalsClick(Sender: TObject);
var
   iIndex: integer;
   iEventIndex: integer;
   Event: TEvent;
   Goal: TGoal;
   TmpGoal: TGoal;
   iTmp: integer;
begin
   // Goal is not editable by default
   EnableCtrl(pnlGoalEdit, False);

    // We get lists index for further usage
   iIndex := chklstGoals.ItemIndex;
   iEventIndex := chklstEvents.ItemIndex;

   // If no goals are selected : bye
   if iIndex < 0 then
      exit;

   // If no event are selected : bye
   if iEventIndex < 0 then
      exit;

   // if current event is not used : bye
   if not chklstEvents.Checked[iEventIndex] then
      exit;

   // We get current event
   Event := TEvent(chklstEvents.Items.Objects[iEventIndex]);
   // if there was a problem getting the event : bye
   if not Assigned(Event) then
      exit;

   // if current goal is used
   if chklstGoals.Checked[iIndex] then
   begin
      // Goal is editable
      EnableCtrl(pnlGoalEdit, True);

      // Is current event allready use this goal ?
      iTmp := Event.Find(chklstGoals.Items[iIndex]);
      if iTmp = -1 then
      begin
         // No, so, we add this goal to the event
         // Goal creation
         Goal := Event.Add;

         // We get goal object from goal list
         TmpGoal := nil;
         if Assigned(chklstGoals.Items.Objects[iIndex]) then
         begin
            TmpGoal := TGoal(chklstGoals.Items.Objects[iIndex]);
         end;

         // if there is no goal -> critical error
         if not Assigned(TmpGoal) then
         begin
            ShowMessage(Format('TFormSelectForSkeleton.chklstGoalsClick : Critical problem, no goal object for item %d', [iIndex]));
            exit;
         end;


         // we serialize original goal in this one (goal may be modified for event purpose, this is why a copy is made)
         // ASSIGN DONT WORK Goal.Assign(TmpGoal);
         // We make a copy of the goal
         Goal.strName := TmpGoal.strName;
         Goal.iTeam := TmpGoal.iTeam;
         Goal.strBias := TmpGoal.strBias;

         // we select axis and allies availability ans set default bias
         chkAllies.Checked := Goal.IsAllied;
         chkAxis.Checked := Goal.IsAxis;
         edBias.Text := Goal.strBias;
      end
      else
      begin
         // Yes goal allready used by this event
         Goal := Event.GetGoal(iTmp);
         // if goal exists, we set availability and bias
         if Assigned(Goal) then
         begin
            edBias.Text := Goal.strBias;
            chkAxis.Checked := Goal.IsAxis;
            chkAllies.Checked := Goal.IsAllied;
         end;
      end;
   end
   // goal is unchecked, so we remove it from event's goals list
   else
   begin
      // Is current event using this goal ?
      iTmp := Event.Find(chklstGoals.Items[iEventIndex]);
      if iTmp <> -1 then
      begin
         // Yes, so, we del this goal from the event
         Event.Del(iTmp);
      end;
   end;
end;






procedure TFormSelectForSkeleton.chklstGoalsDblClick(Sender: TObject);
begin
   with chklstGoals do
   begin
      if ItemIndex <> -1 then
      begin
         Checked[ItemIndex] := not Checked[ItemIndex];
{ debug
         if Checked[ItemIndex] then
             ShowMessage(Format('Check : %d', [ItemIndex]))
         else
             ShowMessage(Format('Uncheck : %d', [ItemIndex]));
}
      end;
   end;
   // Event Goal objects update
   chklstGoalsClick(Sender);
end;




{
type TBaseOwnerDrawState = set of (
  odSelected,
  odGrayed,
  odDisabled,
  odChecked,
  odFocused,
  odDefault,
  odHotLight,
  odInactive,
  odNoAccel,
  odNoFocusRect,
  odReserved1,
  odReserved2,
  odComboBoxEdit,
  odPainted

);}

procedure TFormSelectForSkeleton.chklstGoalsDrawItem(Control: TWinControl; Index: Integer; ARect: TRect; State: TOwnerDrawState);
var
   strTmp: string;
   clrRect: TColor;
   clrText: TColor;
   TmpRect: TRect;
const
   CheckMargin = 3;
begin
   // We are trying to add some usefull colors to render differntly MAP_GOAL / DEFEND / ATTACK, etc...
   // We get goal name
   with chklstGoals do
   begin
      strTmp := chklstGoals.Items[Index];

      clrText := clBlack;

      if Pos('DEFEND_', strTmp) > 0 then
         clrText := $0000B000
      else
      if Pos('ATTACK_', strTmp) > 0 then
         clrText := $008080FF
      else
      if Pos('DYNAMITE', strTmp) > 0 then
         clrText := $000000D5
      else
      if Pos('MAP_SNIPER_SPOT', strTmp) > 0 then
         clrText := $00C08000
      else
      if Pos('MAP_FALLEN', strTmp) > 0 then
         clrText := $00D7D7D7
      else
      if Pos('MAP_MOBILE_MG42', strTmp) > 0 then
         clrText := $00FF8000
      else
      if Pos('MAP_VEHICLE', strTmp) > 0 then
         clrText := $00FF8000
      else
      if Pos('AMMO_', strTmp) > 0 then
         clrText := $0074C7CB
      else
      if Pos('HEALTH_', strTmp) > 0 then
         clrText := $0074C7CB
      else
      if Pos('MAP_CONSTRUCTION', strTmp) > 0 then
         clrText := clFuchsia
      else
      if Pos('MAP_FLAG', strTmp) > 0 then
         clrText := clBlue
      else
      if Pos('MAP_ARTY_SPOT', strTmp) > 0 then
         clrText := $00C08080;



      with chklstGoals.Canvas do
      begin
         // Item background background rectangle
         if (odSelected in State) then
         begin
            Color := clHighlight;
            clrText := clYellow;
         end
         else
            Color := clCream;

         FillRect(ARect);

         TmpRect.Top := ARect.Top + CheckMargin;
         TmpRect.Right := Arect.Left + (ARect.Bottom  - ARect.Top - (CheckMargin * 2));

         // Checkbox
         // if checked
         if Checked[Index] then
         begin
            TmpRect.Left := ARect.Left + CheckMargin;
            TmpRect.Bottom := ARect.Bottom - CheckMargin;

            Color := $00716840;
            FillRect(TmpRect);
         end;

         Color := clrRect;

         // Text
         Font.Color := clrText;
         TextOut(TmpRect.Right + 3, TmpRect.Top, strTmp);
      end;
   end;
end;




procedure TFormSelectForSkeleton.chklstGoalsMouseUp(Sender: TOBject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
   Popup(Sender, GoalsPopup, Button, X, Y);
end;





procedure TFormSelectForSkeleton.edBiasChange(Sender: TObject);
var
   pGoal: TGoal;
   iTmp: integer;
begin
   iTmp := chklstGoals.ItemIndex;

   // If no goal is selected, show a warning and exit
   if iTmp = -1 then
   begin
      ShowMessage('No Goal selected');
      exit;
   end;

{
   // If no goal is selected, show a warning and exit
   if chklstGoals.Checked[iTmp] then
   begin
      ShowMessage(Format('Selected goal(%d) is not checked', [iTmp]));
      exit;
   end;
}
   pGoal := GetCurrentGoal;

   if not Assigned(pGoal) then
      exit;

   pGoal.strBias := edBias.Text;

end;





procedure TFormSelectForSkeleton.CheckList(pList: TCheckListBox; iCheck: integer);
var
   iCmpt: integer;
begin
   // if the list is not enabled -> exit
   if pList.Enabled = False then
      exit;

   with pList do
   begin
      for iCmpt := 0 to Items.Count - 1 do
      begin
         ItemIndex := iCmpt;
         if iCheck = CHECKALL then
            Checked[iCmpt] := True
         else
         if iCheck = UNCHECKALL then
            Checked[iCmpt] := False
         else
         if iCheck = INVERTCHECK then
            Checked[iCmpt] := not Checked[iCmpt];
         OnClick(Self);
      end;
   end;

end;





procedure TFormSelectForSkeleton.MenuItem1Click(Sender: TObject);
begin
   CheckList(chklstEvents, CHECKALL);
end;

procedure TFormSelectForSkeleton.mnuEvtInvertClick(Sender: TObject);
begin
   CheckList(chklstEvents, INVERTCHECK);
end;

procedure TFormSelectForSkeleton.mnuEvtUnselClick(Sender: TObject);
begin
   CheckList(chklstEvents, UNCHECKALL);
end;

procedure TFormSelectForSkeleton.mnuGoaInvertClick(Sender: TObject);
begin
   CheckList(chklstGoals, INVERTCHECK);
end;

procedure TFormSelectForSkeleton.mnuGoalSelClick(Sender: TObject);
begin
   CheckList(chklstGoals, CHECKALL);
end;

procedure TFormSelectForSkeleton.mnuGoalUnselClick(Sender: TObject);
begin
   CheckList(chklstGoals, INVERTCHECK);
end;


constructor TFormSelectForSkeleton.Create(AOwner: TComponent);
begin
   inherited Create(AOwner);
end;

initialization
  {$I fichierformselectforskeleton.lrs}

end.

