unit FichierClasseGoal;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils; 


const TEAMAXIS = 1;
const TEAMALLIES = 2;
const NOGENERATION = 4;

type

{ TGoal }

TGoal = class(TPersistent)
      private
            FstrBias: string;
            FstrName: ansistring;
            FstrVarName: string;
            FstrFuncName: string;
            FiTeam: integer;

            function GetstrVarName: string;
            function GetstrFuncName: string;

      public
            constructor Create(strGoalString: string);

            function IsAxis : boolean;
            function IsAllied : boolean;

      published
               property strName: string read FstrName write FstrName;
               property strBias: string read FstrBias write FstrBias;
               property strVarName: string read GetstrVarName;
               property strFuncName: string read GetstrFuncName;
               property iTeam: integer read FiTeam write FiTeam;
end;


implementation

uses
    Dialogs;


constructor TGoal.Create(strGoalString: string);
var
   iStep: integer;
   iCmpt: integer;
begin
     iStep := 0;
     
     FiTeam := 0;
     iCmpt := 1;
     FstrName := '';
     FstrVarName := '';
     FstrFuncName := '';
     FstrBias := '';

     // Simple state machine to parse goal line
     // goal line example : MAP_CONSTRUCTION_beachplanks -> 0100 0000 bias 1.50
     for iCmpt := 1 to Length(strGoalString) do
     begin
          // Get the name
          if iStep = 0 then
          begin
               if strGoalString[iCmpt] = ' ' then
               begin
                    iStep := 1;
                    continue;
               end
               else
               begin
                   FstrName := FstrName + strGoalString[iCmpt];
               end;
          end
          // remove the ->
          else if iStep = 1 then
          begin
               if strGoalString[iCmpt] = ' ' then
                    iStep := 2;
          end
          // is axis ?
          else if iStep = 2 then
          begin
               if strGoalString[iCmpt] = '1' then
               begin
                    FiTeam := TEAMAXIS;
               end;
               iStep := 3;
          end
          // is allies ?
          else if iStep = 3 then
          begin
               if strGoalString[iCmpt] = '1' then
               begin
                    FiTeam := FiTeam OR TEAMALLIES;
               end;
               iStep := 4;
          end
          // remove the next '00 '
          else if iStep = 4 then
          begin
               if strGoalString[iCmpt] = ' ' then
                    iStep := 5;
          end
          // remove the next '0000 '
          else if iStep = 5 then
          begin
               if strGoalString[iCmpt] = ' ' then
                    iStep := 6;
          end
          // remove the 'bias '
          else if iStep = 6 then
          begin
               if strGoalString[iCmpt] = ' ' then
                    iStep := 7;
          end
          // Get the bias string
          else if iStep = 7 then
          begin
               // if it's CR or LF
               if (strGoalString[iCmpt] = #10) or (strGoalString[iCmpt] = #10) then
               begin
                    // Go out, it's finnished
                    break;
               end
               else
                   FstrBias := FstrBias + strGoalString[iCmpt];
          end
     end;
end;




function TGoal.GetstrFuncName: string;
begin
     if FstrName = '' then
     begin
          Randomize;
          FstrName := Format('%d', [random(99999999999)]);
     end;

     Result := 'goalfunc' + FstrName;
end;



function TGoal.IsAxis: boolean;
begin
   Result := (iTeam and TEAMAXIS) = TEAMAXIS;
end;




function TGoal.IsAllied: boolean;
begin
   Result := (iTeam and TEAMALLIES) = TEAMALLIES;
end;




function TGoal.GetstrVarName : string;
begin
     if FstrName = '' then
     begin
          Randomize;
          FstrName := Format('%d', [random(99999999999)]);
     end;

     Result := 'goalvar' + FstrName;
end;



end.

