unit FichierClasseEvents;

{$mode objfpc}{$H+}

interface

uses
  Classes,
  SysUtils,
  FichierClasseGoal,
  CheckLst;


type

{ TEvent }

TEvent = class(TPersistent)
   private
      lstGoals: TList;
      FstrName: string;
      
   public
      procedure Del(iIndex: integer);
      // Select used goals in a checklistbox
      procedure SelectGoals(chklstGoals: TCheckListBox);

      function Add : TGoal;
      function Find(strName: string) : integer;
      function GetGoal(iIndex: integer) : TGoal;
      function GetCount : integer;
      
      Constructor Create;
      Destructor Destroy;
      
   published
      property strName: string read FstrName write FstrName;
      property Count: integer read GetCount;
end;

implementation

uses
    dialogs;

{ TEvent }

constructor TEvent.Create;
begin
  lstGoals := TList.Create;
end;






destructor TEvent.Destroy;
var
   iCmpt: integer;
begin
  // If we got an assigned list
  if Assigned(lstGoals) then
  begin
       // Free list objects
       for iCmpt := lstGoals.Count - 1 downto 0 do
       begin
          Del(iCmpt);
       end;
       // Fre list
       lstGoals.Free;
       lstGoals := nil;
  end;
end;





function TEvent.Add: TGoal;
var
   Goal: TGoal;
begin
   Goal := TGoal.Create('');
   lstGoals.Add(Goal);
   Result := Goal;
end;




function TEvent.Find(strName: string): integer;
var
   iCmpt: integer;
   Goal: TGoal;
begin
   Result := -1;
   
   for iCmpt := 0 to lstGoals.Count - 1 do
   begin
        Goal := TGoal(lstGoals.Items[iCmpt]);
        if Goal.strName = strName then
        begin
           Result := iCmpt;
           exit;
        end;
   end;
end;



function TEvent.GetGoal(iIndex: integer): TGoal;
var
   pGoal: TGoal;
begin
   if (iIndex < 0) or (iIndex < 0) then
   begin
      Result := nil;
      ShowMessage(Format('TEvent.GetGoal index out of range (%d) for event "%s"', [iIndex, strName]));
      exit;
   end;
   
   Result := TGoal(lstGoals.Items[iIndex]);
end;




function TEvent.GetCount: integer;
begin
     if Assigned(lstGoals) then
        Result := lstGoals.Count
     else
        Result := -1;
end;





procedure TEvent.Del(iIndex: integer);
var
   Goal: TGoal;
begin
   // if we are in list range
   if iIndex < 0 then
      exit;
      
   if iIndex >= lstGoals.Count then
      exit;

   // We get goal from list
   Goal := TGoal(lstGoals.Items[iIndex]);
   // If it's assigned
   if Assigned(Goal) then
   begin
        // Free and nil
        Goal.Free;
        Goal := nil;
   end;

   // Goal removal from list
   lstGoals.Delete(iIndex);
end;





procedure TEvent.SelectGoals(chklstGoals: TCheckListBox);
var
   iCmpt: integer;
   Goal: TGoal;
   strTmp: string;
begin

     for iCmpt := 0 to chklstGoals.Count - 1 do
     begin
          chklstGoals.Checked[iCmpt] := False;
          strTmp := chklstGoals.Items[iCmpt];
          
          if Find(strTmp) <> -1 then
               chklstGoals.Checked[iCmpt] := True;
     end;
end;




end.

