//
// FoXBot - AI Bot for Halflife's Team Fortress Classic
//
// (http://foxbot.net)
//
// linkfunc.cpp
//
// Copyright (C) 2003 - Tom "Redfox" Simpson
//
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
//
// See the GNU General Public License for more details at:
// http://www.gnu.org/copyleft/gpl.html
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

//#ifndef MR_META

#include "extdll.h"
#include "util.h"
#include "cbase.h"

#include "bot.h"

#ifdef __BORLANDC__
extern HINSTANCE _h_Library;
#elif _WIN32
extern HINSTANCE h_Library;
#else
extern void *h_Library;
#endif

#ifdef __BORLANDC__

#define LINK_ENTITY_TO_FUNC(mapClassName) \
 extern "C" EXPORT void mapClassName( entvars_t *pev ); \
 void mapClassName( entvars_t *pev ) { \
      static LINK_ENTITY_FUNC otherClassName = NULL; \
      static int skip_this = 0; \
      if (skip_this) return; \
      if (otherClassName == NULL) \
         otherClassName = (LINK_ENTITY_FUNC)GetProcAddress(_h_Library, #mapClassName); \
      if (otherClassName == NULL) { \
         skip_this = 1; return; \
      } \
      (*otherClassName)(pev); }

#else

#define LINK_ENTITY_TO_FUNC(mapClassName) \
 extern "C" EXPORT void mapClassName( entvars_t *pev ); \
 void mapClassName( entvars_t *pev ) { \
      static LINK_ENTITY_FUNC otherClassName = NULL; \
      static int skip_this = 0; \
      if (skip_this) return; \
      if (otherClassName == NULL) \
         otherClassName = (LINK_ENTITY_FUNC)GetProcAddress(h_Library, #mapClassName); \
      if (otherClassName == NULL) { \
         skip_this = 1; return; \
      } \
      (*otherClassName)(pev); }

#endif


// new stuff for 1.1.0.4 release
//LINK_ENTITY_TO_FUNC(CreateInterface);

// entities for Valve's hl.dll and Standard SDK...

LINK_ENTITY_TO_FUNC(AngleIMatrix);
LINK_ENTITY_TO_FUNC(AngleMatrix);
LINK_ENTITY_TO_FUNC(BALLS_airball);
LINK_ENTITY_TO_FUNC(CTF_Map);
LINK_ENTITY_TO_FUNC(CreateInterface);
LINK_ENTITY_TO_FUNC(DLLClassName);
LINK_ENTITY_TO_FUNC(DelayedUse);
LINK_ENTITY_TO_FUNC(FISHINGROD_bolt);
LINK_ENTITY_TO_FUNC(FOOT_bolt);
LINK_ENTITY_TO_FUNC(FlyingTomaHawk);
LINK_ENTITY_TO_FUNC(GetChaseOrigin);
LINK_ENTITY_TO_FUNC(IsoBomb);
LINK_ENTITY_TO_FUNC(PythRound);
LINK_ENTITY_TO_FUNC(RONINTeamScore);
LINK_ENTITY_TO_FUNC(SCAVENGERTeamScore);
LINK_ENTITY_TO_FUNC(Satelite__Laser);
LINK_ENTITY_TO_FUNC(TSAmmoPack);
LINK_ENTITY_TO_FUNC(TSWorldGun);
LINK_ENTITY_TO_FUNC(TS_bomb);
LINK_ENTITY_TO_FUNC(TSpowerup);
LINK_ENTITY_TO_FUNC(USMCTeamScore);
LINK_ENTITY_TO_FUNC(Zombie2Spit);
LINK_ENTITY_TO_FUNC(_spit);
LINK_ENTITY_TO_FUNC(acidgib);
LINK_ENTITY_TO_FUNC(aiscripted_sequence);
LINK_ENTITY_TO_FUNC(alien_slave_energy_ball);
LINK_ENTITY_TO_FUNC(alien_slave_sapper);
LINK_ENTITY_TO_FUNC(alienresourcetower);
LINK_ENTITY_TO_FUNC(ambient_generic);
LINK_ENTITY_TO_FUNC(ammo_1911clip);
LINK_ENTITY_TO_FUNC(ammo_30cal);
LINK_ENTITY_TO_FUNC(ammo_338magnum);
LINK_ENTITY_TO_FUNC(ammo_357);
LINK_ENTITY_TO_FUNC(ammo_357sig);
LINK_ENTITY_TO_FUNC(ammo_40glclip);
LINK_ENTITY_TO_FUNC(ammo_40mm);
LINK_ENTITY_TO_FUNC(ammo_44);
LINK_ENTITY_TO_FUNC(ammo_45acp);
LINK_ENTITY_TO_FUNC(ammo_50ae);
LINK_ENTITY_TO_FUNC(ammo_50cal);
LINK_ENTITY_TO_FUNC(ammo_556);
LINK_ENTITY_TO_FUNC(ammo_556nato);
LINK_ENTITY_TO_FUNC(ammo_556natobox);
LINK_ENTITY_TO_FUNC(ammo_57mm);
LINK_ENTITY_TO_FUNC(ammo_762);
LINK_ENTITY_TO_FUNC(ammo_762mmbox);
LINK_ENTITY_TO_FUNC(ammo_762nato);
LINK_ENTITY_TO_FUNC(ammo_766mm);
LINK_ENTITY_TO_FUNC(ammo_9mm);
LINK_ENTITY_TO_FUNC(ammo_9mmAR);
LINK_ENTITY_TO_FUNC(ammo_9mmbox);
LINK_ENTITY_TO_FUNC(ammo_9mmclip);
LINK_ENTITY_TO_FUNC(ammo_AK47clip);
LINK_ENTITY_TO_FUNC(ammo_ARgrenades);
LINK_ENTITY_TO_FUNC(ammo_BALLS);
LINK_ENTITY_TO_FUNC(ammo_Deagle);
LINK_ENTITY_TO_FUNC(ammo_FISHINGROD);
LINK_ENTITY_TO_FUNC(ammo_FOOT);
LINK_ENTITY_TO_FUNC(ammo_adrenaline);
LINK_ENTITY_TO_FUNC(ammo_ak101);
LINK_ENTITY_TO_FUNC(ammo_ak105);
LINK_ENTITY_TO_FUNC(ammo_ak47);
LINK_ENTITY_TO_FUNC(ammo_ak47clip);
LINK_ENTITY_TO_FUNC(ammo_ak5);
LINK_ENTITY_TO_FUNC(ammo_ak74);
LINK_ENTITY_TO_FUNC(ammo_ak74clip);
LINK_ENTITY_TO_FUNC(ammo_anaconda);
LINK_ENTITY_TO_FUNC(ammo_ar10clip);
LINK_ENTITY_TO_FUNC(ammo_ar33clip);
LINK_ENTITY_TO_FUNC(ammo_areaammo);
LINK_ENTITY_TO_FUNC(ammo_aug);
LINK_ENTITY_TO_FUNC(ammo_awm);
LINK_ENTITY_TO_FUNC(ammo_bar);
LINK_ENTITY_TO_FUNC(ammo_baretta);
LINK_ENTITY_TO_FUNC(ammo_beamgunclip);
LINK_ENTITY_TO_FUNC(ammo_benelli);
LINK_ENTITY_TO_FUNC(ammo_ber92f);
LINK_ENTITY_TO_FUNC(ammo_ber93r);
LINK_ENTITY_TO_FUNC(ammo_beretta);
LINK_ENTITY_TO_FUNC(ammo_berettaclip);
LINK_ENTITY_TO_FUNC(ammo_bizon);
LINK_ENTITY_TO_FUNC(ammo_bow);
LINK_ENTITY_TO_FUNC(ammo_brick);
LINK_ENTITY_TO_FUNC(ammo_buckshot);
LINK_ENTITY_TO_FUNC(ammo_buffalo);
LINK_ENTITY_TO_FUNC(ammo_cannon);
LINK_ENTITY_TO_FUNC(ammo_caseless);
LINK_ENTITY_TO_FUNC(ammo_chemical);
LINK_ENTITY_TO_FUNC(ammo_cloaker);
LINK_ENTITY_TO_FUNC(ammo_colt);
LINK_ENTITY_TO_FUNC(ammo_colt45clip);
LINK_ENTITY_TO_FUNC(ammo_coltgov);
LINK_ENTITY_TO_FUNC(ammo_colts);
LINK_ENTITY_TO_FUNC(ammo_concussion);
LINK_ENTITY_TO_FUNC(ammo_cougarclip);
LINK_ENTITY_TO_FUNC(ammo_crate);
LINK_ENTITY_TO_FUNC(ammo_crossbow);
LINK_ENTITY_TO_FUNC(ammo_d5kclip);
LINK_ENTITY_TO_FUNC(ammo_dbshot);
LINK_ENTITY_TO_FUNC(ammo_dd44clip);
LINK_ENTITY_TO_FUNC(ammo_de50);
LINK_ENTITY_TO_FUNC(ammo_deagleclip);
LINK_ENTITY_TO_FUNC(ammo_desert);
LINK_ENTITY_TO_FUNC(ammo_dmlclip);
LINK_ENTITY_TO_FUNC(ammo_doubleshotgun);
LINK_ENTITY_TO_FUNC(ammo_dragunovclip);
LINK_ENTITY_TO_FUNC(ammo_dualberettas);
LINK_ENTITY_TO_FUNC(ammo_dualscorpion);
LINK_ENTITY_TO_FUNC(ammo_dyno);
LINK_ENTITY_TO_FUNC(ammo_eagleclip);
LINK_ENTITY_TO_FUNC(ammo_egonclip);
LINK_ENTITY_TO_FUNC(ammo_famas);
LINK_ENTITY_TO_FUNC(ammo_famasclip);
LINK_ENTITY_TO_FUNC(ammo_fg42);
LINK_ENTITY_TO_FUNC(ammo_flameammo);
LINK_ENTITY_TO_FUNC(ammo_flashbang);
LINK_ENTITY_TO_FUNC(ammo_fnfal);
LINK_ENTITY_TO_FUNC(ammo_frag);
LINK_ENTITY_TO_FUNC(ammo_g36clip);
LINK_ENTITY_TO_FUNC(ammo_g36e);
LINK_ENTITY_TO_FUNC(ammo_g36k);
LINK_ENTITY_TO_FUNC(ammo_g3a3);
LINK_ENTITY_TO_FUNC(ammo_garand);
LINK_ENTITY_TO_FUNC(ammo_gatlinbox);
LINK_ENTITY_TO_FUNC(ammo_gattlinggun);
LINK_ENTITY_TO_FUNC(ammo_gaussclip);
LINK_ENTITY_TO_FUNC(ammo_gewehr);
LINK_ENTITY_TO_FUNC(ammo_glock17);
LINK_ENTITY_TO_FUNC(ammo_glockclip);
LINK_ENTITY_TO_FUNC(ammo_goldpp7clip);
LINK_ENTITY_TO_FUNC(ammo_gp25);
LINK_ENTITY_TO_FUNC(ammo_greasegun);
LINK_ENTITY_TO_FUNC(ammo_grenades);
LINK_ENTITY_TO_FUNC(ammo_helirockets);
LINK_ENTITY_TO_FUNC(ammo_hk21);
LINK_ENTITY_TO_FUNC(ammo_hk33clip);
LINK_ENTITY_TO_FUNC(ammo_hkmp5);
LINK_ENTITY_TO_FUNC(ammo_k43);
LINK_ENTITY_TO_FUNC(ammo_kar);
LINK_ENTITY_TO_FUNC(ammo_kf7clip);
LINK_ENTITY_TO_FUNC(ammo_knife);
LINK_ENTITY_TO_FUNC(ammo_knives);
LINK_ENTITY_TO_FUNC(ammo_launcher);
LINK_ENTITY_TO_FUNC(ammo_lgclip);
LINK_ENTITY_TO_FUNC(ammo_longslide);
LINK_ENTITY_TO_FUNC(ammo_lrclip);
LINK_ENTITY_TO_FUNC(ammo_luger);
LINK_ENTITY_TO_FUNC(ammo_m11);
LINK_ENTITY_TO_FUNC(ammo_m112);
LINK_ENTITY_TO_FUNC(ammo_m16);
LINK_ENTITY_TO_FUNC(ammo_m16a2clip);
LINK_ENTITY_TO_FUNC(ammo_m1carbine);
LINK_ENTITY_TO_FUNC(ammo_m2);
LINK_ENTITY_TO_FUNC(ammo_m203);
LINK_ENTITY_TO_FUNC(ammo_m4);
LINK_ENTITY_TO_FUNC(ammo_m40a1clip);
LINK_ENTITY_TO_FUNC(ammo_m4clip);
LINK_ENTITY_TO_FUNC(ammo_m60);
LINK_ENTITY_TO_FUNC(ammo_m60clip);
LINK_ENTITY_TO_FUNC(ammo_m79);
LINK_ENTITY_TO_FUNC(ammo_m82);
LINK_ENTITY_TO_FUNC(ammo_mac);
LINK_ENTITY_TO_FUNC(ammo_mac10);
LINK_ENTITY_TO_FUNC(ammo_machinegun);
LINK_ENTITY_TO_FUNC(ammo_mc51);
LINK_ENTITY_TO_FUNC(ammo_mf2clip);
LINK_ENTITY_TO_FUNC(ammo_mg34);
LINK_ENTITY_TO_FUNC(ammo_mg36);
LINK_ENTITY_TO_FUNC(ammo_mg42);
LINK_ENTITY_TO_FUNC(ammo_mindrayclip);
LINK_ENTITY_TO_FUNC(ammo_minigunClip);
LINK_ENTITY_TO_FUNC(ammo_mk23);
LINK_ENTITY_TO_FUNC(ammo_mossberg);
LINK_ENTITY_TO_FUNC(ammo_mp40);
LINK_ENTITY_TO_FUNC(ammo_mp44);
LINK_ENTITY_TO_FUNC(ammo_mp5a2);
LINK_ENTITY_TO_FUNC(ammo_mp5a4);
LINK_ENTITY_TO_FUNC(ammo_mp5a5);
LINK_ENTITY_TO_FUNC(ammo_mp5clip);
LINK_ENTITY_TO_FUNC(ammo_mp5grenades);
LINK_ENTITY_TO_FUNC(ammo_mp5k);
LINK_ENTITY_TO_FUNC(ammo_mp5pdwclip);
LINK_ENTITY_TO_FUNC(ammo_mp5sd);
LINK_ENTITY_TO_FUNC(ammo_msg90);
LINK_ENTITY_TO_FUNC(ammo_nato);
LINK_ENTITY_TO_FUNC(ammo_nato308);
LINK_ENTITY_TO_FUNC(ammo_natoclip);
LINK_ENTITY_TO_FUNC(ammo_needle);
LINK_ENTITY_TO_FUNC(ammo_null);
LINK_ENTITY_TO_FUNC(ammo_p99clip);
LINK_ENTITY_TO_FUNC(ammo_phantomclip);
LINK_ENTITY_TO_FUNC(ammo_pistol);
LINK_ENTITY_TO_FUNC(ammo_pkm);
LINK_ENTITY_TO_FUNC(ammo_pkmclip);
LINK_ENTITY_TO_FUNC(ammo_powercell);
LINK_ENTITY_TO_FUNC(ammo_psg1);
LINK_ENTITY_TO_FUNC(ammo_psg1clip);
LINK_ENTITY_TO_FUNC(ammo_railgun);
LINK_ENTITY_TO_FUNC(ammo_rcp90clip);
LINK_ENTITY_TO_FUNC(ammo_rifleclip);
LINK_ENTITY_TO_FUNC(ammo_rifleshot);
LINK_ENTITY_TO_FUNC(ammo_rocket);
LINK_ENTITY_TO_FUNC(ammo_rocketlauncher);
LINK_ENTITY_TO_FUNC(ammo_rocketpistol);
LINK_ENTITY_TO_FUNC(ammo_rpgclip);
LINK_ENTITY_TO_FUNC(ammo_rs202m2);
LINK_ENTITY_TO_FUNC(ammo_sa80clip);
LINK_ENTITY_TO_FUNC(ammo_saa);
LINK_ENTITY_TO_FUNC(ammo_saiga);
LINK_ENTITY_TO_FUNC(ammo_sako);
LINK_ENTITY_TO_FUNC(ammo_satchels);
LINK_ENTITY_TO_FUNC(ammo_sbarrelshot);
LINK_ENTITY_TO_FUNC(ammo_scatterclip);
LINK_ENTITY_TO_FUNC(ammo_scopedkar);
LINK_ENTITY_TO_FUNC(ammo_shells);
LINK_ENTITY_TO_FUNC(ammo_sig245clip);
LINK_ENTITY_TO_FUNC(ammo_silverpp7clip);
LINK_ENTITY_TO_FUNC(ammo_sks);
LINK_ENTITY_TO_FUNC(ammo_snUZI);
LINK_ENTITY_TO_FUNC(ammo_sniper);
LINK_ENTITY_TO_FUNC(ammo_spas12);
LINK_ENTITY_TO_FUNC(ammo_spasclip);
LINK_ENTITY_TO_FUNC(ammo_spellbook);
LINK_ENTITY_TO_FUNC(ammo_spitcarb);
LINK_ENTITY_TO_FUNC(ammo_spitclip);
LINK_ENTITY_TO_FUNC(ammo_spore);
LINK_ENTITY_TO_FUNC(ammo_spring);
LINK_ENTITY_TO_FUNC(ammo_srifleclip);
LINK_ENTITY_TO_FUNC(ammo_ssg3000);
LINK_ENTITY_TO_FUNC(ammo_sterling);
LINK_ENTITY_TO_FUNC(ammo_stg24);
LINK_ENTITY_TO_FUNC(ammo_stoner);
LINK_ENTITY_TO_FUNC(ammo_stonerscope);
LINK_ENTITY_TO_FUNC(ammo_stonersilencer);
LINK_ENTITY_TO_FUNC(ammo_stubcoolant);
LINK_ENTITY_TO_FUNC(ammo_stumpbox);
LINK_ENTITY_TO_FUNC(ammo_svd);
LINK_ENTITY_TO_FUNC(ammo_swarm_xen_secondary);
LINK_ENTITY_TO_FUNC(ammo_swarmprimary);
LINK_ENTITY_TO_FUNC(ammo_swarmsecondary);
LINK_ENTITY_TO_FUNC(ammo_tec9);
LINK_ENTITY_TO_FUNC(ammo_thompson);
LINK_ENTITY_TO_FUNC(ammo_tommy);
LINK_ENTITY_TO_FUNC(ammo_tommygun);
LINK_ENTITY_TO_FUNC(ammo_ump45);
LINK_ENTITY_TO_FUNC(ammo_uspclip);
LINK_ENTITY_TO_FUNC(ammo_uzi);
LINK_ENTITY_TO_FUNC(ammo_uziclip);
LINK_ENTITY_TO_FUNC(ammo_veprclip);
LINK_ENTITY_TO_FUNC(ammo_vomitclip);
LINK_ENTITY_TO_FUNC(ammo_vulcan);
LINK_ENTITY_TO_FUNC(ammo_wa2000);
LINK_ENTITY_TO_FUNC(ammo_whiskey);
LINK_ENTITY_TO_FUNC(ammo_winchesterclip);
LINK_ENTITY_TO_FUNC(ammo_xm4);
LINK_ENTITY_TO_FUNC(ammo_xm4slug);
LINK_ENTITY_TO_FUNC(ammo_zmgclip);
LINK_ENTITY_TO_FUNC(ammobox);
LINK_ENTITY_TO_FUNC(armoury_entity);
LINK_ENTITY_TO_FUNC(asl_charge_flare);
LINK_ENTITY_TO_FUNC(aura);
LINK_ENTITY_TO_FUNC(autogl_gren);
LINK_ENTITY_TO_FUNC(balle);
LINK_ENTITY_TO_FUNC(barneymine);
LINK_ENTITY_TO_FUNC(base_drive_ent);
LINK_ENTITY_TO_FUNC(basecurse);
LINK_ENTITY_TO_FUNC(beam);
LINK_ENTITY_TO_FUNC(beam_attack);
LINK_ENTITY_TO_FUNC(beamshot);
LINK_ENTITY_TO_FUNC(bean);
LINK_ENTITY_TO_FUNC(beanstalk);
LINK_ENTITY_TO_FUNC(bfg10k);
LINK_ENTITY_TO_FUNC(big_bang);
LINK_ENTITY_TO_FUNC(big_disk);
LINK_ENTITY_TO_FUNC(blaster_beam);
LINK_ENTITY_TO_FUNC(bmortar);
LINK_ENTITY_TO_FUNC(bodyque);
LINK_ENTITY_TO_FUNC(boolean_multisource);
LINK_ENTITY_TO_FUNC(bot);
LINK_ENTITY_TO_FUNC(bot_waypoint);
LINK_ENTITY_TO_FUNC(bowie_bolt);
LINK_ENTITY_TO_FUNC(bubgren);
LINK_ENTITY_TO_FUNC(building_dispenser);
LINK_ENTITY_TO_FUNC(building_sentrygun);
LINK_ENTITY_TO_FUNC(building_sentrygun_base);
LINK_ENTITY_TO_FUNC(building_teleporter);
LINK_ENTITY_TO_FUNC(bullet);
LINK_ENTITY_TO_FUNC(burning_attack);
LINK_ENTITY_TO_FUNC(button_aiwallplug);
LINK_ENTITY_TO_FUNC(button_target);
LINK_ENTITY_TO_FUNC(candy);
LINK_ENTITY_TO_FUNC(cannon_ball);
LINK_ENTITY_TO_FUNC(capture_point);
LINK_ENTITY_TO_FUNC(carried_book_team1);
LINK_ENTITY_TO_FUNC(carried_book_team2);
LINK_ENTITY_TO_FUNC(carried_flag_team1);
LINK_ENTITY_TO_FUNC(carried_flag_team2);
LINK_ENTITY_TO_FUNC(carry_resource);
LINK_ENTITY_TO_FUNC(carry_scientist);
LINK_ENTITY_TO_FUNC(cflag);
LINK_ENTITY_TO_FUNC(charge);
LINK_ENTITY_TO_FUNC(charged_bolt);
LINK_ENTITY_TO_FUNC(cine_blood);
LINK_ENTITY_TO_FUNC(controller_charge_ball);
LINK_ENTITY_TO_FUNC(controller_charged_ball);
LINK_ENTITY_TO_FUNC(controller_energy_ball);
LINK_ENTITY_TO_FUNC(controller_head_ball);
LINK_ENTITY_TO_FUNC(controller_health_ball);
LINK_ENTITY_TO_FUNC(controller_throw_ball);
LINK_ENTITY_TO_FUNC(counter);
LINK_ENTITY_TO_FUNC(crossbow_bolt);
LINK_ENTITY_TO_FUNC(ctb_point_one);
LINK_ENTITY_TO_FUNC(ctb_point_two);
LINK_ENTITY_TO_FUNC(ctc_capturepoint);
LINK_ENTITY_TO_FUNC(ctc_chicken);
LINK_ENTITY_TO_FUNC(ctf_blueflag);
LINK_ENTITY_TO_FUNC(ctf_bluespawn);
LINK_ENTITY_TO_FUNC(ctf_cloak);
LINK_ENTITY_TO_FUNC(ctf_crowbar);
LINK_ENTITY_TO_FUNC(ctf_cycle);
LINK_ENTITY_TO_FUNC(ctf_flag);
LINK_ENTITY_TO_FUNC(ctf_flagzone);
LINK_ENTITY_TO_FUNC(ctf_frag);
LINK_ENTITY_TO_FUNC(ctf_hook);
LINK_ENTITY_TO_FUNC(ctf_lowgrav);
LINK_ENTITY_TO_FUNC(ctf_protect);
LINK_ENTITY_TO_FUNC(ctf_redflag);
LINK_ENTITY_TO_FUNC(ctf_redspawn);
LINK_ENTITY_TO_FUNC(ctf_regen);
LINK_ENTITY_TO_FUNC(ctf_rune);
LINK_ENTITY_TO_FUNC(ctf_superglock);
LINK_ENTITY_TO_FUNC(ctf_trap);
LINK_ENTITY_TO_FUNC(ctf_vamp);
LINK_ENTITY_TO_FUNC(curse_spawner);
LINK_ENTITY_TO_FUNC(cust_11);
LINK_ENTITY_TO_FUNC(cust_12);
LINK_ENTITY_TO_FUNC(cust_13);
LINK_ENTITY_TO_FUNC(cust_21);
LINK_ENTITY_TO_FUNC(cust_22);
LINK_ENTITY_TO_FUNC(cust_24);
LINK_ENTITY_TO_FUNC(cust_25);
LINK_ENTITY_TO_FUNC(cust_2GaussPistolSniper);
LINK_ENTITY_TO_FUNC(cust_2MinigunCooled);
LINK_ENTITY_TO_FUNC(cust_31);
LINK_ENTITY_TO_FUNC(cust_33);
LINK_ENTITY_TO_FUNC(cust_34);
LINK_ENTITY_TO_FUNC(cust_41);
LINK_ENTITY_TO_FUNC(cust_43);
LINK_ENTITY_TO_FUNC(cycler);
LINK_ENTITY_TO_FUNC(cycler_prdroid);
LINK_ENTITY_TO_FUNC(cycler_sprite);
LINK_ENTITY_TO_FUNC(cycler_weapon);
LINK_ENTITY_TO_FUNC(cycler_wreckage);
LINK_ENTITY_TO_FUNC(davespit);
LINK_ENTITY_TO_FUNC(db_spawner);
LINK_ENTITY_TO_FUNC(dc_info_objective);
LINK_ENTITY_TO_FUNC(dc_info_objectposition);
LINK_ENTITY_TO_FUNC(dc_object);
LINK_ENTITY_TO_FUNC(dc_trigger_objectcapture);
LINK_ENTITY_TO_FUNC(dc_trigger_reset);
LINK_ENTITY_TO_FUNC(dc_trigger_team);
LINK_ENTITY_TO_FUNC(deal_columbian_start);
LINK_ENTITY_TO_FUNC(deal_italian_start);
LINK_ENTITY_TO_FUNC(deal_swat_start);
LINK_ENTITY_TO_FUNC(death_ball);
LINK_ENTITY_TO_FUNC(deathball);
LINK_ENTITY_TO_FUNC(deathsoul);
LINK_ENTITY_TO_FUNC(debris);
LINK_ENTITY_TO_FUNC(decore_aicore);
LINK_ENTITY_TO_FUNC(decore_asteroid);
LINK_ENTITY_TO_FUNC(decore_baboon);
LINK_ENTITY_TO_FUNC(decore_bodygib);
LINK_ENTITY_TO_FUNC(decore_butterflyflock);
LINK_ENTITY_TO_FUNC(decore_cactus);
LINK_ENTITY_TO_FUNC(decore_cam);
LINK_ENTITY_TO_FUNC(decore_corpse);
LINK_ENTITY_TO_FUNC(decore_eagle);
LINK_ENTITY_TO_FUNC(decore_explodable);
LINK_ENTITY_TO_FUNC(decore_foot);
LINK_ENTITY_TO_FUNC(decore_goldskull);
LINK_ENTITY_TO_FUNC(decore_gutspile);
LINK_ENTITY_TO_FUNC(decore_hatgib);
LINK_ENTITY_TO_FUNC(decore_ice);
LINK_ENTITY_TO_FUNC(decore_mushroom);
LINK_ENTITY_TO_FUNC(decore_mushroom2);
LINK_ENTITY_TO_FUNC(decore_nest);
LINK_ENTITY_TO_FUNC(decore_pipes);
LINK_ENTITY_TO_FUNC(decore_prickle);
LINK_ENTITY_TO_FUNC(decore_pteradon);
LINK_ENTITY_TO_FUNC(decore_scripted_boulder);
LINK_ENTITY_TO_FUNC(decore_sittingtubemortar);
LINK_ENTITY_TO_FUNC(decore_spacebebris);
LINK_ENTITY_TO_FUNC(decore_swampplants);
LINK_ENTITY_TO_FUNC(decore_torch);
LINK_ENTITY_TO_FUNC(decore_torchflame);
LINK_ENTITY_TO_FUNC(defensechamber);
LINK_ENTITY_TO_FUNC(demoman_mine);
LINK_ENTITY_TO_FUNC(detpack);
LINK_ENTITY_TO_FUNC(dg_streak_spiral);
LINK_ENTITY_TO_FUNC(disc);
LINK_ENTITY_TO_FUNC(disc_arena);
LINK_ENTITY_TO_FUNC(discarena);
LINK_ENTITY_TO_FUNC(displacer_ball);
LINK_ENTITY_TO_FUNC(dmgmirrorcurse);
LINK_ENTITY_TO_FUNC(dmgscalecurse);
LINK_ENTITY_TO_FUNC(dod_ammo_depot);
LINK_ENTITY_TO_FUNC(dod_camera);
LINK_ENTITY_TO_FUNC(dod_capture_area);
LINK_ENTITY_TO_FUNC(dod_control_point);
LINK_ENTITY_TO_FUNC(dod_control_point_master);
LINK_ENTITY_TO_FUNC(dod_location);
LINK_ENTITY_TO_FUNC(dod_object);
LINK_ENTITY_TO_FUNC(dod_object_goal);
LINK_ENTITY_TO_FUNC(dod_point_relay);
LINK_ENTITY_TO_FUNC(dod_round_timer);
LINK_ENTITY_TO_FUNC(dod_score_ent);
LINK_ENTITY_TO_FUNC(dod_secondary);
LINK_ENTITY_TO_FUNC(dod_stats);
LINK_ENTITY_TO_FUNC(dod_trigger_sandbag);
LINK_ENTITY_TO_FUNC(dove_flock);
LINK_ENTITY_TO_FUNC(dove_flyer);
LINK_ENTITY_TO_FUNC(dragonball);
LINK_ENTITY_TO_FUNC(drive_agrunt);
LINK_ENTITY_TO_FUNC(drive_agrunt_spawner);
LINK_ENTITY_TO_FUNC(drive_apache);
LINK_ENTITY_TO_FUNC(drive_apache_spawner);
LINK_ENTITY_TO_FUNC(drive_asl);
LINK_ENTITY_TO_FUNC(drive_assassin);
LINK_ENTITY_TO_FUNC(drive_assassin_spawner);
LINK_ENTITY_TO_FUNC(drive_bm);
LINK_ENTITY_TO_FUNC(drive_bm_spawner);
LINK_ENTITY_TO_FUNC(drive_bullsquid);
LINK_ENTITY_TO_FUNC(drive_bullsquid_spawner);
LINK_ENTITY_TO_FUNC(drive_chumtoad);
LINK_ENTITY_TO_FUNC(drive_controller);
LINK_ENTITY_TO_FUNC(drive_controller_spawner);
LINK_ENTITY_TO_FUNC(drive_garg);
LINK_ENTITY_TO_FUNC(drive_garg_spawner);
LINK_ENTITY_TO_FUNC(drive_headcrab);
LINK_ENTITY_TO_FUNC(drive_houndeye);
LINK_ENTITY_TO_FUNC(drive_houndeye_spawner);
LINK_ENTITY_TO_FUNC(drive_icky);
LINK_ENTITY_TO_FUNC(drive_icky_spawner);
LINK_ENTITY_TO_FUNC(drive_panth);
LINK_ENTITY_TO_FUNC(drive_panth_spawner);
LINK_ENTITY_TO_FUNC(drive_slave_spawner);
LINK_ENTITY_TO_FUNC(drive_turret);
LINK_ENTITY_TO_FUNC(drive_turret_spawner);
LINK_ENTITY_TO_FUNC(drop_bomb);
LINK_ENTITY_TO_FUNC(drunkcurse);
LINK_ENTITY_TO_FUNC(drv_hvr_rocket);
LINK_ENTITY_TO_FUNC(eagle_laser);
LINK_ENTITY_TO_FUNC(egon_mirv);
LINK_ENTITY_TO_FUNC(entity_botcam);
LINK_ENTITY_TO_FUNC(entity_clustergod);
LINK_ENTITY_TO_FUNC(entity_digitgod);
LINK_ENTITY_TO_FUNC(entity_spritegod);
LINK_ENTITY_TO_FUNC(entity_volcanospew);
LINK_ENTITY_TO_FUNC(env_ClusterExplosion);
LINK_ENTITY_TO_FUNC(env_animsprite);
LINK_ENTITY_TO_FUNC(env_beam);
LINK_ENTITY_TO_FUNC(env_beverage);
LINK_ENTITY_TO_FUNC(env_blood);
LINK_ENTITY_TO_FUNC(env_blowercannon);
LINK_ENTITY_TO_FUNC(env_bombglow);
LINK_ENTITY_TO_FUNC(env_bubbles);
LINK_ENTITY_TO_FUNC(env_customize);
LINK_ENTITY_TO_FUNC(env_debris);
LINK_ENTITY_TO_FUNC(env_electrified_wire);
LINK_ENTITY_TO_FUNC(env_explosion);
LINK_ENTITY_TO_FUNC(env_fade);
LINK_ENTITY_TO_FUNC(env_fadeone);
LINK_ENTITY_TO_FUNC(env_fire);
LINK_ENTITY_TO_FUNC(env_fog);
LINK_ENTITY_TO_FUNC(env_funnel);
LINK_ENTITY_TO_FUNC(env_gamma);
LINK_ENTITY_TO_FUNC(env_genewormcloud);
LINK_ENTITY_TO_FUNC(env_genewormspawn);
LINK_ENTITY_TO_FUNC(env_global);
LINK_ENTITY_TO_FUNC(env_glow);
LINK_ENTITY_TO_FUNC(env_laser);
LINK_ENTITY_TO_FUNC(env_lightning);
LINK_ENTITY_TO_FUNC(env_message);
LINK_ENTITY_TO_FUNC(env_model);
LINK_ENTITY_TO_FUNC(env_particles);
LINK_ENTITY_TO_FUNC(env_particles_custom);
LINK_ENTITY_TO_FUNC(env_particule);
LINK_ENTITY_TO_FUNC(env_precip);
LINK_ENTITY_TO_FUNC(env_rain);
LINK_ENTITY_TO_FUNC(env_render);
LINK_ENTITY_TO_FUNC(env_rope);
LINK_ENTITY_TO_FUNC(env_shake);
LINK_ENTITY_TO_FUNC(env_shooter);
LINK_ENTITY_TO_FUNC(env_smoker);
LINK_ENTITY_TO_FUNC(env_sound);
LINK_ENTITY_TO_FUNC(env_spark);
LINK_ENTITY_TO_FUNC(env_spawnereffect);
LINK_ENTITY_TO_FUNC(env_sprite);
LINK_ENTITY_TO_FUNC(env_spriteshooter);
LINK_ENTITY_TO_FUNC(env_spritetrain);
LINK_ENTITY_TO_FUNC(env_state);
LINK_ENTITY_TO_FUNC(env_sun);
LINK_ENTITY_TO_FUNC(env_warpball);
LINK_ENTITY_TO_FUNC(event_player_die);
LINK_ENTITY_TO_FUNC(event_player_join);
LINK_ENTITY_TO_FUNC(event_player_kill);
LINK_ENTITY_TO_FUNC(event_player_leave);
LINK_ENTITY_TO_FUNC(event_player_spawn);
LINK_ENTITY_TO_FUNC(event_round_end);
LINK_ENTITY_TO_FUNC(event_round_reset);
LINK_ENTITY_TO_FUNC(event_round_start);
LINK_ENTITY_TO_FUNC(event_team_die);
LINK_ENTITY_TO_FUNC(event_team_win);
LINK_ENTITY_TO_FUNC(explodingattack);
LINK_ENTITY_TO_FUNC(explosive_slug);
LINK_ENTITY_TO_FUNC(external_cam);
LINK_ENTITY_TO_FUNC(fa_drop_zone);
LINK_ENTITY_TO_FUNC(fa_parachute);
LINK_ENTITY_TO_FUNC(fa_push_flag);
LINK_ENTITY_TO_FUNC(fa_push_point);
LINK_ENTITY_TO_FUNC(fa_sd_object);
LINK_ENTITY_TO_FUNC(fa_team_goal);
LINK_ENTITY_TO_FUNC(fa_team_item);
LINK_ENTITY_TO_FUNC(fading_corpse);
LINK_ENTITY_TO_FUNC(final_flash);
LINK_ENTITY_TO_FUNC(finish);
LINK_ENTITY_TO_FUNC(fireanddie);
LINK_ENTITY_TO_FUNC(flag);
LINK_ENTITY_TO_FUNC(flag_capture_point);
LINK_ENTITY_TO_FUNC(flag_follow);
LINK_ENTITY_TO_FUNC(flag_world);
LINK_ENTITY_TO_FUNC(flak_grenade);
LINK_ENTITY_TO_FUNC(flakfrag);
LINK_ENTITY_TO_FUNC(flame_ball);
LINK_ENTITY_TO_FUNC(flamme);
LINK_ENTITY_TO_FUNC(flare);
LINK_ENTITY_TO_FUNC(flare_fire);
LINK_ENTITY_TO_FUNC(flying_crowbar);
LINK_ENTITY_TO_FUNC(fog);
LINK_ENTITY_TO_FUNC(follow_ent);
LINK_ENTITY_TO_FUNC(follower_basic);
LINK_ENTITY_TO_FUNC(freeze_beam);
LINK_ENTITY_TO_FUNC(freeze_timer);
LINK_ENTITY_TO_FUNC(friction_timer);
LINK_ENTITY_TO_FUNC(func_airstrike_area);
LINK_ENTITY_TO_FUNC(func_base);
LINK_ENTITY_TO_FUNC(func_bomb_target);
LINK_ENTITY_TO_FUNC(func_breakable);
LINK_ENTITY_TO_FUNC(func_button);
LINK_ENTITY_TO_FUNC(func_buyzone);
LINK_ENTITY_TO_FUNC(func_capture_area);
LINK_ENTITY_TO_FUNC(func_clouds);
LINK_ENTITY_TO_FUNC(func_conveyor);
LINK_ENTITY_TO_FUNC(func_ctb);
LINK_ENTITY_TO_FUNC(func_destroy_objective);
LINK_ENTITY_TO_FUNC(func_disctoggle);
LINK_ENTITY_TO_FUNC(func_door);
LINK_ENTITY_TO_FUNC(func_door_rotating);
LINK_ENTITY_TO_FUNC(func_escapezone);
LINK_ENTITY_TO_FUNC(func_friction);
LINK_ENTITY_TO_FUNC(func_goal_zone);
LINK_ENTITY_TO_FUNC(func_goalpoint);
LINK_ENTITY_TO_FUNC(func_golem_body);
LINK_ENTITY_TO_FUNC(func_golem_controls_attack);
LINK_ENTITY_TO_FUNC(func_golem_controls_forward);
LINK_ENTITY_TO_FUNC(func_golem_controls_left);
LINK_ENTITY_TO_FUNC(func_golem_controls_right);
LINK_ENTITY_TO_FUNC(func_golem_leftarm);
LINK_ENTITY_TO_FUNC(func_golem_leftleg);
LINK_ENTITY_TO_FUNC(func_golem_rightarm);
LINK_ENTITY_TO_FUNC(func_golem_rightleg);
LINK_ENTITY_TO_FUNC(func_grencatch);
LINK_ENTITY_TO_FUNC(func_guntarget);
LINK_ENTITY_TO_FUNC(func_healthcharger);
LINK_ENTITY_TO_FUNC(func_hostage_rescue);
LINK_ENTITY_TO_FUNC(func_illusionary);
LINK_ENTITY_TO_FUNC(func_jail_breakable);
LINK_ENTITY_TO_FUNC(func_jail_button);
LINK_ENTITY_TO_FUNC(func_jail_door);
LINK_ENTITY_TO_FUNC(func_jail_door_rotating);
LINK_ENTITY_TO_FUNC(func_jail_pushable);
LINK_ENTITY_TO_FUNC(func_ladder);
LINK_ENTITY_TO_FUNC(func_laddertype);
LINK_ENTITY_TO_FUNC(func_land_transport);
LINK_ENTITY_TO_FUNC(func_landtransport);
LINK_ENTITY_TO_FUNC(func_monsterclip);
LINK_ENTITY_TO_FUNC(func_mortar_field);
LINK_ENTITY_TO_FUNC(func_music);
LINK_ENTITY_TO_FUNC(func_nobuild);
LINK_ENTITY_TO_FUNC(func_nogrenades);
LINK_ENTITY_TO_FUNC(func_op4mortarcontroller);
LINK_ENTITY_TO_FUNC(func_pendulum);
LINK_ENTITY_TO_FUNC(func_plat);
LINK_ENTITY_TO_FUNC(func_plat_toggleremove);
LINK_ENTITY_TO_FUNC(func_platrot);
LINK_ENTITY_TO_FUNC(func_player_start);
LINK_ENTITY_TO_FUNC(func_point);
LINK_ENTITY_TO_FUNC(func_possesion);
LINK_ENTITY_TO_FUNC(func_protect);
LINK_ENTITY_TO_FUNC(func_pushable);
LINK_ENTITY_TO_FUNC(func_recharge);
LINK_ENTITY_TO_FUNC(func_reset);
LINK_ENTITY_TO_FUNC(func_resource);
LINK_ENTITY_TO_FUNC(func_rot_button);
LINK_ENTITY_TO_FUNC(func_rotating);
LINK_ENTITY_TO_FUNC(func_seethrough);
LINK_ENTITY_TO_FUNC(func_seethroughdoor);
LINK_ENTITY_TO_FUNC(func_tank);
LINK_ENTITY_TO_FUNC(func_tank_of);
LINK_ENTITY_TO_FUNC(func_tankcontrols);
LINK_ENTITY_TO_FUNC(func_tankcontrols_of);
LINK_ENTITY_TO_FUNC(func_tankdrive);
LINK_ENTITY_TO_FUNC(func_tankgib);
LINK_ENTITY_TO_FUNC(func_tankgib_gib);
LINK_ENTITY_TO_FUNC(func_tankgoauld);
LINK_ENTITY_TO_FUNC(func_tanklaser);
LINK_ENTITY_TO_FUNC(func_tanklaser_of);
LINK_ENTITY_TO_FUNC(func_tankmortar);
LINK_ENTITY_TO_FUNC(func_tankmortar_of);
LINK_ENTITY_TO_FUNC(func_tankrocket);
LINK_ENTITY_TO_FUNC(func_tankrocket_of);
LINK_ENTITY_TO_FUNC(func_tech_breakable);
LINK_ENTITY_TO_FUNC(func_trackautochange);
LINK_ENTITY_TO_FUNC(func_trackchange);
LINK_ENTITY_TO_FUNC(func_tracktrain);
LINK_ENTITY_TO_FUNC(func_train);
LINK_ENTITY_TO_FUNC(func_traincontrols);
LINK_ENTITY_TO_FUNC(func_use);
LINK_ENTITY_TO_FUNC(func_vehicle);
LINK_ENTITY_TO_FUNC(func_vehiclecontrols);
LINK_ENTITY_TO_FUNC(func_vip_safetyzone);
LINK_ENTITY_TO_FUNC(func_wall);
LINK_ENTITY_TO_FUNC(func_wall_toggle);
LINK_ENTITY_TO_FUNC(func_water);
LINK_ENTITY_TO_FUNC(func_weaponcheck);
LINK_ENTITY_TO_FUNC(func_weldable);
LINK_ENTITY_TO_FUNC(func_wind);
LINK_ENTITY_TO_FUNC(game_clock);
LINK_ENTITY_TO_FUNC(game_counter);
LINK_ENTITY_TO_FUNC(game_counter_set);
LINK_ENTITY_TO_FUNC(game_end);
LINK_ENTITY_TO_FUNC(game_endbattle);
LINK_ENTITY_TO_FUNC(game_item);
LINK_ENTITY_TO_FUNC(game_levelmusic);
LINK_ENTITY_TO_FUNC(game_player_die);
LINK_ENTITY_TO_FUNC(game_player_equip);
LINK_ENTITY_TO_FUNC(game_player_hurt);
LINK_ENTITY_TO_FUNC(game_player_message);
LINK_ENTITY_TO_FUNC(game_player_team);
LINK_ENTITY_TO_FUNC(game_playerdie);
LINK_ENTITY_TO_FUNC(game_roundend);
LINK_ENTITY_TO_FUNC(game_score);
LINK_ENTITY_TO_FUNC(game_team_master);
LINK_ENTITY_TO_FUNC(game_team_set);
LINK_ENTITY_TO_FUNC(game_team_win);
LINK_ENTITY_TO_FUNC(game_text);
LINK_ENTITY_TO_FUNC(game_zone_player);
LINK_ENTITY_TO_FUNC(garg_hull);
LINK_ENTITY_TO_FUNC(garg_stomp);
LINK_ENTITY_TO_FUNC(generic_model);
LINK_ENTITY_TO_FUNC(getGlobalStunLevel);
LINK_ENTITY_TO_FUNC(ghost);
LINK_ENTITY_TO_FUNC(gibable_corpse);
LINK_ENTITY_TO_FUNC(gibshooter);
LINK_ENTITY_TO_FUNC(gonarch_headcrabifier);
LINK_ENTITY_TO_FUNC(gonomeguts);
LINK_ENTITY_TO_FUNC(gr_shell);
LINK_ENTITY_TO_FUNC(grapple_bolt);
LINK_ENTITY_TO_FUNC(grapple_hook);
LINK_ENTITY_TO_FUNC(grapple_tip);
LINK_ENTITY_TO_FUNC(gren_projectile);
LINK_ENTITY_TO_FUNC(gren_smoke);
LINK_ENTITY_TO_FUNC(grenade);
LINK_ENTITY_TO_FUNC(guard_info);
LINK_ENTITY_TO_FUNC(guidedattack);
LINK_ENTITY_TO_FUNC(gunmancycler);
LINK_ENTITY_TO_FUNC(hallucgrenade);
LINK_ENTITY_TO_FUNC(halo_base);
LINK_ENTITY_TO_FUNC(hand_knife);
LINK_ENTITY_TO_FUNC(he_charge_flare);
LINK_ENTITY_TO_FUNC(he_eye_flare);
LINK_ENTITY_TO_FUNC(headcrab_teather);
LINK_ENTITY_TO_FUNC(holo_player);
LINK_ENTITY_TO_FUNC(hologram_beak);
LINK_ENTITY_TO_FUNC(hologram_damage);
LINK_ENTITY_TO_FUNC(holywars_rocket);
LINK_ENTITY_TO_FUNC(homing_balls);
LINK_ENTITY_TO_FUNC(hornet);
LINK_ENTITY_TO_FUNC(hospital);
LINK_ENTITY_TO_FUNC(hostage_entity);
LINK_ENTITY_TO_FUNC(hvr_blkop_rocket);
LINK_ENTITY_TO_FUNC(hvr_rocket);
LINK_ENTITY_TO_FUNC(i_p_t);
LINK_ENTITY_TO_FUNC(i_t_g);
LINK_ENTITY_TO_FUNC(i_t_t);
LINK_ENTITY_TO_FUNC(impail_arrow);
LINK_ENTITY_TO_FUNC(impgren);
LINK_ENTITY_TO_FUNC(in_shell);
LINK_ENTITY_TO_FUNC(indian_arrow);
LINK_ENTITY_TO_FUNC(infect);
LINK_ENTITY_TO_FUNC(info_Waterdetect);
LINK_ENTITY_TO_FUNC(info_administrator);
LINK_ENTITY_TO_FUNC(info_airstrike_node);
LINK_ENTITY_TO_FUNC(info_alias);
LINK_ENTITY_TO_FUNC(info_american_line);
LINK_ENTITY_TO_FUNC(info_areadef);
LINK_ENTITY_TO_FUNC(info_areamarker);
LINK_ENTITY_TO_FUNC(info_bananier);
LINK_ENTITY_TO_FUNC(info_bg_detect);
LINK_ENTITY_TO_FUNC(info_bigmomma);
LINK_ENTITY_TO_FUNC(info_bomb_target);
LINK_ENTITY_TO_FUNC(info_boobytrap);
LINK_ENTITY_TO_FUNC(info_botlandmark);
LINK_ENTITY_TO_FUNC(info_botnode);
LINK_ENTITY_TO_FUNC(info_british_line);
LINK_ENTITY_TO_FUNC(info_button_phonebooth);
LINK_ENTITY_TO_FUNC(info_caisse_128);
LINK_ENTITY_TO_FUNC(info_caisse_16);
LINK_ENTITY_TO_FUNC(info_caisse_256);
LINK_ENTITY_TO_FUNC(info_caisse_32);
LINK_ENTITY_TO_FUNC(info_caisse_64);
LINK_ENTITY_TO_FUNC(info_chicken);
LINK_ENTITY_TO_FUNC(info_chip);
LINK_ENTITY_TO_FUNC(info_civ_start);
LINK_ENTITY_TO_FUNC(info_css);
LINK_ENTITY_TO_FUNC(info_ctb_controller);
LINK_ENTITY_TO_FUNC(info_ctfdetect);
LINK_ENTITY_TO_FUNC(info_ctfspawn);
LINK_ENTITY_TO_FUNC(info_ctfspawn_powerup);
LINK_ENTITY_TO_FUNC(info_deathball_spawn);
LINK_ENTITY_TO_FUNC(info_defaultammo);
LINK_ENTITY_TO_FUNC(info_displacer_earth_target);
LINK_ENTITY_TO_FUNC(info_displacer_xen_target);
LINK_ENTITY_TO_FUNC(info_doddetect);
LINK_ENTITY_TO_FUNC(info_dragonrider_spawn);
LINK_ENTITY_TO_FUNC(info_drive_agrunt_spawn);
LINK_ENTITY_TO_FUNC(info_drive_apache_spawn);
LINK_ENTITY_TO_FUNC(info_drive_assassin_spawn);
LINK_ENTITY_TO_FUNC(info_drive_bm_spawn);
LINK_ENTITY_TO_FUNC(info_drive_bullsquid_spawn);
LINK_ENTITY_TO_FUNC(info_drive_controller_spawn);
LINK_ENTITY_TO_FUNC(info_drive_garg_spawn);
LINK_ENTITY_TO_FUNC(info_drive_houndeye_spawn);
LINK_ENTITY_TO_FUNC(info_drive_icky_spawn);
LINK_ENTITY_TO_FUNC(info_drive_panth_spawn);
LINK_ENTITY_TO_FUNC(info_drive_slave_spawn);
LINK_ENTITY_TO_FUNC(info_drive_turret_spawn);
LINK_ENTITY_TO_FUNC(info_escape_target);
LINK_ENTITY_TO_FUNC(info_evil_start);
LINK_ENTITY_TO_FUNC(info_firearms_detect);
LINK_ENTITY_TO_FUNC(info_firstround_spawn);
LINK_ENTITY_TO_FUNC(info_flagspawn);
LINK_ENTITY_TO_FUNC(info_flash);
LINK_ENTITY_TO_FUNC(info_frontline);
LINK_ENTITY_TO_FUNC(info_gameplay);
LINK_ENTITY_TO_FUNC(info_gameplaylogic);
LINK_ENTITY_TO_FUNC(info_gangsta_dm_start);
LINK_ENTITY_TO_FUNC(info_goldeneye);
LINK_ENTITY_TO_FUNC(info_good_start);
LINK_ENTITY_TO_FUNC(info_group);
LINK_ENTITY_TO_FUNC(info_gwGeneral_spawn);
LINK_ENTITY_TO_FUNC(info_gwars_map);
LINK_ENTITY_TO_FUNC(info_gwbriefing_spawn);
LINK_ENTITY_TO_FUNC(info_gwinmap_spawn);
LINK_ENTITY_TO_FUNC(info_gwplayer_spawn);
LINK_ENTITY_TO_FUNC(info_gwwaiting_spawn);
LINK_ENTITY_TO_FUNC(info_hlpaintctfdetect);
LINK_ENTITY_TO_FUNC(info_hmctfdetect);
LINK_ENTITY_TO_FUNC(info_hostage_rescue);
LINK_ENTITY_TO_FUNC(info_initial_player_allies);
LINK_ENTITY_TO_FUNC(info_initial_player_axis);
LINK_ENTITY_TO_FUNC(info_intermission);
LINK_ENTITY_TO_FUNC(info_italian_start);
LINK_ENTITY_TO_FUNC(info_join_autoassign);
LINK_ENTITY_TO_FUNC(info_join_team);
LINK_ENTITY_TO_FUNC(info_jumppad_target);
LINK_ENTITY_TO_FUNC(info_jwhite_capture);
LINK_ENTITY_TO_FUNC(info_jwhite_escape);
LINK_ENTITY_TO_FUNC(info_jwhite_rescue);
LINK_ENTITY_TO_FUNC(info_landmark);
LINK_ENTITY_TO_FUNC(info_landmine);
LINK_ENTITY_TO_FUNC(info_leave_game);
LINK_ENTITY_TO_FUNC(info_location);
LINK_ENTITY_TO_FUNC(info_map_parameters);
LINK_ENTITY_TO_FUNC(info_mapdetect);
LINK_ENTITY_TO_FUNC(info_mapinfo);
LINK_ENTITY_TO_FUNC(info_minefield);
LINK_ENTITY_TO_FUNC(info_multiple);
LINK_ENTITY_TO_FUNC(info_node);
LINK_ENTITY_TO_FUNC(info_node_air);
LINK_ENTITY_TO_FUNC(info_nomines);
LINK_ENTITY_TO_FUNC(info_null);
LINK_ENTITY_TO_FUNC(info_objective);
LINK_ENTITY_TO_FUNC(info_orientation);
LINK_ENTITY_TO_FUNC(info_paintball);
LINK_ENTITY_TO_FUNC(info_pitworm);
LINK_ENTITY_TO_FUNC(info_pitworm_steam_lock);
LINK_ENTITY_TO_FUNC(info_player_allies);
LINK_ENTITY_TO_FUNC(info_player_american);
LINK_ENTITY_TO_FUNC(info_player_attacker);
LINK_ENTITY_TO_FUNC(info_player_axis);
LINK_ENTITY_TO_FUNC(info_player_blue);
LINK_ENTITY_TO_FUNC(info_player_british);
LINK_ENTITY_TO_FUNC(info_player_deadstart);
LINK_ENTITY_TO_FUNC(info_player_deathmatch);
LINK_ENTITY_TO_FUNC(info_player_defender);
LINK_ENTITY_TO_FUNC(info_player_goauld);
LINK_ENTITY_TO_FUNC(info_player_jail);
LINK_ENTITY_TO_FUNC(info_player_judge);
LINK_ENTITY_TO_FUNC(info_player_marine);
LINK_ENTITY_TO_FUNC(info_player_nva_reenforcement);
LINK_ENTITY_TO_FUNC(info_player_observer);
LINK_ENTITY_TO_FUNC(info_player_perp);
LINK_ENTITY_TO_FUNC(info_player_red);
LINK_ENTITY_TO_FUNC(info_player_slayer);
LINK_ENTITY_TO_FUNC(info_player_spectator);
LINK_ENTITY_TO_FUNC(info_player_start);
LINK_ENTITY_TO_FUNC(info_player_team1);
LINK_ENTITY_TO_FUNC(info_player_team2);
LINK_ENTITY_TO_FUNC(info_player_teamspawn);
LINK_ENTITY_TO_FUNC(info_player_torri);
LINK_ENTITY_TO_FUNC(info_player_unas);
LINK_ENTITY_TO_FUNC(info_player_usmc_reenforcement);
LINK_ENTITY_TO_FUNC(info_player_vampire);
LINK_ENTITY_TO_FUNC(info_playerstart_blue);
LINK_ENTITY_TO_FUNC(info_playerstart_red);
LINK_ENTITY_TO_FUNC(info_rescue_monster);
LINK_ENTITY_TO_FUNC(info_rescue_point);
LINK_ENTITY_TO_FUNC(info_roundx_spawn);
LINK_ENTITY_TO_FUNC(info_russian_start);
LINK_ENTITY_TO_FUNC(info_scientist);
LINK_ENTITY_TO_FUNC(info_scientist_dead);
LINK_ENTITY_TO_FUNC(info_scientist_start);
LINK_ENTITY_TO_FUNC(info_semi_null);
LINK_ENTITY_TO_FUNC(info_sidetect);
LINK_ENTITY_TO_FUNC(info_spectate);
LINK_ENTITY_TO_FUNC(info_sprite);
LINK_ENTITY_TO_FUNC(info_status);
LINK_ENTITY_TO_FUNC(info_swat_start);
LINK_ENTITY_TO_FUNC(info_target);
LINK_ENTITY_TO_FUNC(info_team);
LINK_ENTITY_TO_FUNC(info_team_ronin);
LINK_ENTITY_TO_FUNC(info_team_scavenger);
LINK_ENTITY_TO_FUNC(info_team_start);
LINK_ENTITY_TO_FUNC(info_team_usmc);
LINK_ENTITY_TO_FUNC(info_teamplaydetect);
LINK_ENTITY_TO_FUNC(info_teamspawn);
LINK_ENTITY_TO_FUNC(info_teleport_destination);
LINK_ENTITY_TO_FUNC(info_tf_teamcheck);
LINK_ENTITY_TO_FUNC(info_tf_teamset);
LINK_ENTITY_TO_FUNC(info_tfdetect);
LINK_ENTITY_TO_FUNC(info_tfgoal);
LINK_ENTITY_TO_FUNC(info_tfgoal_timer);
LINK_ENTITY_TO_FUNC(info_transistor);
LINK_ENTITY_TO_FUNC(info_transport_node);
LINK_ENTITY_TO_FUNC(info_upko_start);
LINK_ENTITY_TO_FUNC(info_usa_start);
LINK_ENTITY_TO_FUNC(info_vip_start);
LINK_ENTITY_TO_FUNC(info_wanteddetect);
LINK_ENTITY_TO_FUNC(info_wwdetect);
LINK_ENTITY_TO_FUNC(info_zone);
LINK_ENTITY_TO_FUNC(info_zone_caisse);
LINK_ENTITY_TO_FUNC(infodecal);
LINK_ENTITY_TO_FUNC(item_acme);
LINK_ENTITY_TO_FUNC(item_airtank);
LINK_ENTITY_TO_FUNC(item_antidote);
LINK_ENTITY_TO_FUNC(item_antidotee);
LINK_ENTITY_TO_FUNC(item_armor);
LINK_ENTITY_TO_FUNC(item_armor1);
LINK_ENTITY_TO_FUNC(item_armor2);
LINK_ENTITY_TO_FUNC(item_armor3);
LINK_ENTITY_TO_FUNC(item_armorInv);
LINK_ENTITY_TO_FUNC(item_armour);
LINK_ENTITY_TO_FUNC(item_artifact_envirosuit);
LINK_ENTITY_TO_FUNC(item_artifact_invisibility);
LINK_ENTITY_TO_FUNC(item_artifact_invulnerability);
LINK_ENTITY_TO_FUNC(item_artifact_super_damage);
LINK_ENTITY_TO_FUNC(item_assaultsuit);
LINK_ENTITY_TO_FUNC(item_atde_object);
LINK_ENTITY_TO_FUNC(item_autodoc);
LINK_ENTITY_TO_FUNC(item_backpack);
LINK_ENTITY_TO_FUNC(item_badge);
LINK_ENTITY_TO_FUNC(item_bag1);
LINK_ENTITY_TO_FUNC(item_bag2);
LINK_ENTITY_TO_FUNC(item_bandage);
LINK_ENTITY_TO_FUNC(item_bandolier);
LINK_ENTITY_TO_FUNC(item_baril);
LINK_ENTITY_TO_FUNC(item_baril_bleu);
LINK_ENTITY_TO_FUNC(item_baril_rouge);
LINK_ENTITY_TO_FUNC(item_battery);
LINK_ENTITY_TO_FUNC(item_beans);
LINK_ENTITY_TO_FUNC(item_book_team1);
LINK_ENTITY_TO_FUNC(item_book_team2);
LINK_ENTITY_TO_FUNC(item_bottle);
LINK_ENTITY_TO_FUNC(item_briefcase);
LINK_ENTITY_TO_FUNC(item_c4);
LINK_ENTITY_TO_FUNC(item_cactus);
LINK_ENTITY_TO_FUNC(item_caisse_arme);
LINK_ENTITY_TO_FUNC(item_caisse_mega);
LINK_ENTITY_TO_FUNC(item_caisse_outil);
LINK_ENTITY_TO_FUNC(item_caisse_vie);
LINK_ENTITY_TO_FUNC(item_canteen);
LINK_ENTITY_TO_FUNC(item_capkey);
LINK_ENTITY_TO_FUNC(item_cash);
LINK_ENTITY_TO_FUNC(item_cells);
LINK_ENTITY_TO_FUNC(item_chicken);
LINK_ENTITY_TO_FUNC(item_claymore);
LINK_ENTITY_TO_FUNC(item_cloaker);
LINK_ENTITY_TO_FUNC(item_concussion);
LINK_ENTITY_TO_FUNC(item_ctfaccelerator);
LINK_ENTITY_TO_FUNC(item_ctfbackpack);
LINK_ENTITY_TO_FUNC(item_ctfbase);
LINK_ENTITY_TO_FUNC(item_ctfflag);
LINK_ENTITY_TO_FUNC(item_ctflongjump);
LINK_ENTITY_TO_FUNC(item_ctfportablehev);
LINK_ENTITY_TO_FUNC(item_ctfregeneration);
LINK_ENTITY_TO_FUNC(item_dish);
LINK_ENTITY_TO_FUNC(item_docbag);
LINK_ENTITY_TO_FUNC(item_dragonball);
LINK_ENTITY_TO_FUNC(item_dyno);
LINK_ENTITY_TO_FUNC(item_dyno1);
LINK_ENTITY_TO_FUNC(item_elixer);
LINK_ENTITY_TO_FUNC(item_elixir);
LINK_ENTITY_TO_FUNC(item_flag);
LINK_ENTITY_TO_FUNC(item_flag1);
LINK_ENTITY_TO_FUNC(item_flag2);
LINK_ENTITY_TO_FUNC(item_flag_atde);
LINK_ENTITY_TO_FUNC(item_flag_blue);
LINK_ENTITY_TO_FUNC(item_flag_center);
LINK_ENTITY_TO_FUNC(item_flag_cf);
LINK_ENTITY_TO_FUNC(item_flag_ctf);
LINK_ENTITY_TO_FUNC(item_flag_red);
LINK_ENTITY_TO_FUNC(item_flag_team1);
LINK_ENTITY_TO_FUNC(item_flag_team2);
LINK_ENTITY_TO_FUNC(item_flashbang);
LINK_ENTITY_TO_FUNC(item_flashlight);
LINK_ENTITY_TO_FUNC(item_frag);
LINK_ENTITY_TO_FUNC(item_gascan);
LINK_ENTITY_TO_FUNC(item_generic);
LINK_ENTITY_TO_FUNC(item_genericammo);
LINK_ENTITY_TO_FUNC(item_glass);
LINK_ENTITY_TO_FUNC(item_head);
LINK_ENTITY_TO_FUNC(item_health);
LINK_ENTITY_TO_FUNC(item_healthkit);
LINK_ENTITY_TO_FUNC(item_heavyarmor);
LINK_ENTITY_TO_FUNC(item_herbs);
LINK_ENTITY_TO_FUNC(item_highjump);
LINK_ENTITY_TO_FUNC(item_holster);
LINK_ENTITY_TO_FUNC(item_jetpack);
LINK_ENTITY_TO_FUNC(item_kevlar);
LINK_ENTITY_TO_FUNC(item_knife);
LINK_ENTITY_TO_FUNC(item_laser);
LINK_ENTITY_TO_FUNC(item_lgboiler);
LINK_ENTITY_TO_FUNC(item_longjump);
LINK_ENTITY_TO_FUNC(item_medboiler);
LINK_ENTITY_TO_FUNC(item_metal);
LINK_ENTITY_TO_FUNC(item_mine);
LINK_ENTITY_TO_FUNC(item_newspaper);
LINK_ENTITY_TO_FUNC(item_nightvision);
LINK_ENTITY_TO_FUNC(item_nuclearbomb);
LINK_ENTITY_TO_FUNC(item_nuclearbombbutton);
LINK_ENTITY_TO_FUNC(item_nuclearbombtimer);
LINK_ENTITY_TO_FUNC(item_nvg);
LINK_ENTITY_TO_FUNC(item_papers);
LINK_ENTITY_TO_FUNC(item_parachute);
LINK_ENTITY_TO_FUNC(item_pickaxe);
LINK_ENTITY_TO_FUNC(item_powerarmor);
LINK_ENTITY_TO_FUNC(item_powerup);
LINK_ENTITY_TO_FUNC(item_quad);
LINK_ENTITY_TO_FUNC(item_resource);
LINK_ENTITY_TO_FUNC(item_rockets);
LINK_ENTITY_TO_FUNC(item_scope);
LINK_ENTITY_TO_FUNC(item_security);
LINK_ENTITY_TO_FUNC(item_sensubeanbag);
LINK_ENTITY_TO_FUNC(item_shells);
LINK_ENTITY_TO_FUNC(item_shovel);
LINK_ENTITY_TO_FUNC(item_silencer);
LINK_ENTITY_TO_FUNC(item_silvercase);
LINK_ENTITY_TO_FUNC(item_smboiler);
LINK_ENTITY_TO_FUNC(item_sodacan);
LINK_ENTITY_TO_FUNC(item_speedburst);
LINK_ENTITY_TO_FUNC(item_spikes);
LINK_ENTITY_TO_FUNC(item_stealth);
LINK_ENTITY_TO_FUNC(item_steerribs);
LINK_ENTITY_TO_FUNC(item_steerskull);
LINK_ENTITY_TO_FUNC(item_stg24);
LINK_ENTITY_TO_FUNC(item_suit);
LINK_ENTITY_TO_FUNC(item_swarm_flag);
LINK_ENTITY_TO_FUNC(item_tag);
LINK_ENTITY_TO_FUNC(item_telegram);
LINK_ENTITY_TO_FUNC(item_telegraphkey);
LINK_ENTITY_TO_FUNC(item_tfgoal);
LINK_ENTITY_TO_FUNC(item_thighpack);
LINK_ENTITY_TO_FUNC(item_tombe_bleu);
LINK_ENTITY_TO_FUNC(item_tombe_rouge);
LINK_ENTITY_TO_FUNC(item_upgradevest);
LINK_ENTITY_TO_FUNC(item_vest);
LINK_ENTITY_TO_FUNC(item_wagonwheel);
LINK_ENTITY_TO_FUNC(item_weapon);
LINK_ENTITY_TO_FUNC(item_wheelside);
LINK_ENTITY_TO_FUNC(jail_execute);
LINK_ENTITY_TO_FUNC(jail_team_master);
LINK_ENTITY_TO_FUNC(jumppad_sign);
LINK_ENTITY_TO_FUNC(kamehameha);
LINK_ENTITY_TO_FUNC(killerrat);
LINK_ENTITY_TO_FUNC(knife);
LINK_ENTITY_TO_FUNC(knife_bolt);
LINK_ENTITY_TO_FUNC(knife_throw);
LINK_ENTITY_TO_FUNC(lance_proj);
LINK_ENTITY_TO_FUNC(laser_aimer);
LINK_ENTITY_TO_FUNC(laser_dot);
LINK_ENTITY_TO_FUNC(laser_spot);
LINK_ENTITY_TO_FUNC(laserbolt);
LINK_ENTITY_TO_FUNC(law_rocket);
LINK_ENTITY_TO_FUNC(lc_init_ent);
LINK_ENTITY_TO_FUNC(lc_respawner);
LINK_ENTITY_TO_FUNC(lc_spawner);
LINK_ENTITY_TO_FUNC(lifesoul);
LINK_ENTITY_TO_FUNC(light);
LINK_ENTITY_TO_FUNC(light_environment);
LINK_ENTITY_TO_FUNC(light_glow);
LINK_ENTITY_TO_FUNC(light_spot);
LINK_ENTITY_TO_FUNC(m61_grenade);
LINK_ENTITY_TO_FUNC(magicattack);
LINK_ENTITY_TO_FUNC(mapClassName);
LINK_ENTITY_TO_FUNC(marker);
LINK_ENTITY_TO_FUNC(master_key);
LINK_ENTITY_TO_FUNC(master_relay);
LINK_ENTITY_TO_FUNC(master_state);
LINK_ENTITY_TO_FUNC(master_team);
LINK_ENTITY_TO_FUNC(master_tech);
LINK_ENTITY_TO_FUNC(mastertoggle);
LINK_ENTITY_TO_FUNC(mazo);
LINK_ENTITY_TO_FUNC(mazoold);
LINK_ENTITY_TO_FUNC(medal);
LINK_ENTITY_TO_FUNC(medevac);
LINK_ENTITY_TO_FUNC(medivac);
LINK_ENTITY_TO_FUNC(meteor_god);
LINK_ENTITY_TO_FUNC(meteor_target);
LINK_ENTITY_TO_FUNC(mini_rocket);
LINK_ENTITY_TO_FUNC(momentary_door);
LINK_ENTITY_TO_FUNC(momentary_jail_door);
LINK_ENTITY_TO_FUNC(momentary_rot_button);
LINK_ENTITY_TO_FUNC(monster_ShockTrooper_dead);
LINK_ENTITY_TO_FUNC(monster_a10);
LINK_ENTITY_TO_FUNC(monster_adrian);
LINK_ENTITY_TO_FUNC(monster_adrian_dead);
LINK_ENTITY_TO_FUNC(monster_alarm);
LINK_ENTITY_TO_FUNC(monster_alien_babyvoltigore);
LINK_ENTITY_TO_FUNC(monster_alien_controller);
LINK_ENTITY_TO_FUNC(monster_alien_grunt);
LINK_ENTITY_TO_FUNC(monster_alien_panther);
LINK_ENTITY_TO_FUNC(monster_alien_slave);
LINK_ENTITY_TO_FUNC(monster_alien_slave_dead);
LINK_ENTITY_TO_FUNC(monster_alien_voltigore);
LINK_ENTITY_TO_FUNC(monster_allied_barney);
LINK_ENTITY_TO_FUNC(monster_allied_grunt);
LINK_ENTITY_TO_FUNC(monster_alliedgrunt_dead);
LINK_ENTITY_TO_FUNC(monster_annie);
LINK_ENTITY_TO_FUNC(monster_annie_dead);
LINK_ENTITY_TO_FUNC(monster_apache);
LINK_ENTITY_TO_FUNC(monster_archer);
LINK_ENTITY_TO_FUNC(monster_assassin_repel);
LINK_ENTITY_TO_FUNC(monster_assassin_target);
LINK_ENTITY_TO_FUNC(monster_axis_grunt);
LINK_ENTITY_TO_FUNC(monster_axisgrunt_dead);
LINK_ENTITY_TO_FUNC(monster_babycrab);
LINK_ENTITY_TO_FUNC(monster_babygarg);
LINK_ENTITY_TO_FUNC(monster_balllightning);
LINK_ENTITY_TO_FUNC(monster_barnacle);
LINK_ENTITY_TO_FUNC(monster_barney);
LINK_ENTITY_TO_FUNC(monster_barney_dead);
LINK_ENTITY_TO_FUNC(monster_barniel);
LINK_ENTITY_TO_FUNC(monster_barniel_dead);
LINK_ENTITY_TO_FUNC(monster_bbturret);
LINK_ENTITY_TO_FUNC(monster_beak);
LINK_ENTITY_TO_FUNC(monster_bear);
LINK_ENTITY_TO_FUNC(monster_beartrap);
LINK_ENTITY_TO_FUNC(monster_bigminer);
LINK_ENTITY_TO_FUNC(monster_bigminer_dead);
LINK_ENTITY_TO_FUNC(monster_bigmomma);
LINK_ENTITY_TO_FUNC(monster_blkop_apache);
LINK_ENTITY_TO_FUNC(monster_blkop_osprey);
LINK_ENTITY_TO_FUNC(monster_bloater);
LINK_ENTITY_TO_FUNC(monster_bodypart);
LINK_ENTITY_TO_FUNC(monster_bomb);
LINK_ENTITY_TO_FUNC(monster_buffalo);
LINK_ENTITY_TO_FUNC(monster_bullchicken);
LINK_ENTITY_TO_FUNC(monster_burnmine);
LINK_ENTITY_TO_FUNC(monster_c4);
LINK_ENTITY_TO_FUNC(monster_chicken);
LINK_ENTITY_TO_FUNC(monster_chumtoad);
LINK_ENTITY_TO_FUNC(monster_cine2_crispen);
LINK_ENTITY_TO_FUNC(monster_cine2_dave);
LINK_ENTITY_TO_FUNC(monster_cine2_hvyweapons);
LINK_ENTITY_TO_FUNC(monster_cine2_masala);
LINK_ENTITY_TO_FUNC(monster_cine2_nagatow);
LINK_ENTITY_TO_FUNC(monster_cine2_scientist);
LINK_ENTITY_TO_FUNC(monster_cine2_slave);
LINK_ENTITY_TO_FUNC(monster_cine2_tiedcolonel);
LINK_ENTITY_TO_FUNC(monster_cine2_townmex);
LINK_ENTITY_TO_FUNC(monster_cine2_wtowna);
LINK_ENTITY_TO_FUNC(monster_cine2_wtownb);
LINK_ENTITY_TO_FUNC(monster_cine3_annie);
LINK_ENTITY_TO_FUNC(monster_cine3_barney);
LINK_ENTITY_TO_FUNC(monster_cine3_crispen);
LINK_ENTITY_TO_FUNC(monster_cine3_dave);
LINK_ENTITY_TO_FUNC(monster_cine3_hoss);
LINK_ENTITY_TO_FUNC(monster_cine3_masala);
LINK_ENTITY_TO_FUNC(monster_cine3_nagatow);
LINK_ENTITY_TO_FUNC(monster_cine3_scientist);
LINK_ENTITY_TO_FUNC(monster_cine3_tiedcolonel);
LINK_ENTITY_TO_FUNC(monster_cine3_townmex);
LINK_ENTITY_TO_FUNC(monster_cine3_wtowna);
LINK_ENTITY_TO_FUNC(monster_cine3_wtownb);
LINK_ENTITY_TO_FUNC(monster_cine_annie);
LINK_ENTITY_TO_FUNC(monster_cine_barney);
LINK_ENTITY_TO_FUNC(monster_cine_crispen);
LINK_ENTITY_TO_FUNC(monster_cine_dave);
LINK_ENTITY_TO_FUNC(monster_cine_hoss);
LINK_ENTITY_TO_FUNC(monster_cine_masala);
LINK_ENTITY_TO_FUNC(monster_cine_nagatow);
LINK_ENTITY_TO_FUNC(monster_cine_panther);
LINK_ENTITY_TO_FUNC(monster_cine_scientist);
LINK_ENTITY_TO_FUNC(monster_cine_tiedcolonel);
LINK_ENTITY_TO_FUNC(monster_cine_townmex);
LINK_ENTITY_TO_FUNC(monster_cine_wtowna);
LINK_ENTITY_TO_FUNC(monster_cine_wtownb);
LINK_ENTITY_TO_FUNC(monster_civilian);
LINK_ENTITY_TO_FUNC(monster_civilian_dead);
LINK_ENTITY_TO_FUNC(monster_cleansuit_scientist);
LINK_ENTITY_TO_FUNC(monster_cleansuit_scientist_dead);
LINK_ENTITY_TO_FUNC(monster_cockroach);
LINK_ENTITY_TO_FUNC(monster_colonel);
LINK_ENTITY_TO_FUNC(monster_colonel_dead);
LINK_ENTITY_TO_FUNC(monster_cow);
LINK_ENTITY_TO_FUNC(monster_cowboy);
LINK_ENTITY_TO_FUNC(monster_cowboy_dead);
LINK_ENTITY_TO_FUNC(monster_cricket);
LINK_ENTITY_TO_FUNC(monster_crispen);
LINK_ENTITY_TO_FUNC(monster_crispen_dead);
LINK_ENTITY_TO_FUNC(monster_critter);
LINK_ENTITY_TO_FUNC(monster_darttrap);
LINK_ENTITY_TO_FUNC(monster_dave);
LINK_ENTITY_TO_FUNC(monster_dave_dead);
LINK_ENTITY_TO_FUNC(monster_dog);
LINK_ENTITY_TO_FUNC(monster_dragon);
LINK_ENTITY_TO_FUNC(monster_dragonfly);
LINK_ENTITY_TO_FUNC(monster_drillsergeant);
LINK_ENTITY_TO_FUNC(monster_eagle);
LINK_ENTITY_TO_FUNC(monster_eagle_flock);
LINK_ENTITY_TO_FUNC(monster_endboss);
LINK_ENTITY_TO_FUNC(monster_exp_alien_slave);
LINK_ENTITY_TO_FUNC(monster_fakemedkit);
LINK_ENTITY_TO_FUNC(monster_fgrunt_repel);
LINK_ENTITY_TO_FUNC(monster_flag1);
LINK_ENTITY_TO_FUNC(monster_flag2);
LINK_ENTITY_TO_FUNC(monster_flag3);
LINK_ENTITY_TO_FUNC(monster_flag4);
LINK_ENTITY_TO_FUNC(monster_flashlight);
LINK_ENTITY_TO_FUNC(monster_flyer);
LINK_ENTITY_TO_FUNC(monster_flyer_flock);
LINK_ENTITY_TO_FUNC(monster_furniture);
LINK_ENTITY_TO_FUNC(monster_garbage);
LINK_ENTITY_TO_FUNC(monster_gargantua);
LINK_ENTITY_TO_FUNC(monster_gator);
LINK_ENTITY_TO_FUNC(monster_generic);
LINK_ENTITY_TO_FUNC(monster_geneworm);
LINK_ENTITY_TO_FUNC(monster_giantplant);
LINK_ENTITY_TO_FUNC(monster_gman);
LINK_ENTITY_TO_FUNC(monster_goat);
LINK_ENTITY_TO_FUNC(monster_goblin);
LINK_ENTITY_TO_FUNC(monster_gonome);
LINK_ENTITY_TO_FUNC(monster_gonome_dead);
LINK_ENTITY_TO_FUNC(monster_gordon);
LINK_ENTITY_TO_FUNC(monster_gordon_dead);
LINK_ENTITY_TO_FUNC(monster_gps);
LINK_ENTITY_TO_FUNC(monster_grunt_ally_repel);
LINK_ENTITY_TO_FUNC(monster_grunt_repel);
LINK_ENTITY_TO_FUNC(monster_gunner_friendly);
LINK_ENTITY_TO_FUNC(monster_hatchetfish);
LINK_ENTITY_TO_FUNC(monster_headcrab);
LINK_ENTITY_TO_FUNC(monster_helicopter);
LINK_ENTITY_TO_FUNC(monster_hevbarn);
LINK_ENTITY_TO_FUNC(monster_hevbarn_dead);
LINK_ENTITY_TO_FUNC(monster_hevsuit_dead);
LINK_ENTITY_TO_FUNC(monster_hfgrunt_dead);
LINK_ENTITY_TO_FUNC(monster_hgrunt_dead);
LINK_ENTITY_TO_FUNC(monster_hiveback);
LINK_ENTITY_TO_FUNC(monster_horse);
LINK_ENTITY_TO_FUNC(monster_hoss);
LINK_ENTITY_TO_FUNC(monster_hoss_dead);
LINK_ENTITY_TO_FUNC(monster_houndeye);
LINK_ENTITY_TO_FUNC(monster_houndeye_dead);
LINK_ENTITY_TO_FUNC(monster_human_assassin);
LINK_ENTITY_TO_FUNC(monster_human_bandit);
LINK_ENTITY_TO_FUNC(monster_human_chopper);
LINK_ENTITY_TO_FUNC(monster_human_demoman);
LINK_ENTITY_TO_FUNC(monster_human_friendly_grunt);
LINK_ENTITY_TO_FUNC(monster_human_grunt);
LINK_ENTITY_TO_FUNC(monster_human_grunt_ally);
LINK_ENTITY_TO_FUNC(monster_human_grunt_ally_dead);
LINK_ENTITY_TO_FUNC(monster_human_gunman);
LINK_ENTITY_TO_FUNC(monster_human_medic_ally);
LINK_ENTITY_TO_FUNC(monster_human_scientist);
LINK_ENTITY_TO_FUNC(monster_human_spforce);
LINK_ENTITY_TO_FUNC(monster_human_terror);
LINK_ENTITY_TO_FUNC(monster_human_torch_ally);
LINK_ENTITY_TO_FUNC(monster_human_unarmed);
LINK_ENTITY_TO_FUNC(monster_hwgrunt);
LINK_ENTITY_TO_FUNC(monster_ichthyosaur);
LINK_ENTITY_TO_FUNC(monster_kaiewi);
LINK_ENTITY_TO_FUNC(monster_kaiewi_dead);
LINK_ENTITY_TO_FUNC(monster_kate);
LINK_ENTITY_TO_FUNC(monster_kate_dead);
LINK_ENTITY_TO_FUNC(monster_kid);
LINK_ENTITY_TO_FUNC(monster_killerbabycrab);
LINK_ENTITY_TO_FUNC(monster_largescorpion);
LINK_ENTITY_TO_FUNC(monster_larve);
LINK_ENTITY_TO_FUNC(monster_leech);
LINK_ENTITY_TO_FUNC(monster_llama);
LINK_ENTITY_TO_FUNC(monster_lrocket);
LINK_ENTITY_TO_FUNC(monster_m2);
LINK_ENTITY_TO_FUNC(monster_male_assassin);
LINK_ENTITY_TO_FUNC(monster_manta);
LINK_ENTITY_TO_FUNC(monster_masala);
LINK_ENTITY_TO_FUNC(monster_masala_dead);
LINK_ENTITY_TO_FUNC(monster_massassin_dead);
LINK_ENTITY_TO_FUNC(monster_medic_ally_repel);
LINK_ENTITY_TO_FUNC(monster_mexbandit);
LINK_ENTITY_TO_FUNC(monster_mexbandit_dead);
LINK_ENTITY_TO_FUNC(monster_microraptor);
LINK_ENTITY_TO_FUNC(monster_mine);
LINK_ENTITY_TO_FUNC(monster_miniturret);
LINK_ENTITY_TO_FUNC(monster_monkey);
LINK_ENTITY_TO_FUNC(monster_mortar);
LINK_ENTITY_TO_FUNC(monster_mouton);
LINK_ENTITY_TO_FUNC(monster_myself);
LINK_ENTITY_TO_FUNC(monster_myself_dead);
LINK_ENTITY_TO_FUNC(monster_nagatow);
LINK_ENTITY_TO_FUNC(monster_nagatow_dead);
LINK_ENTITY_TO_FUNC(monster_nihilanth);
LINK_ENTITY_TO_FUNC(monster_op4loader);
LINK_ENTITY_TO_FUNC(monster_osprey);
LINK_ENTITY_TO_FUNC(monster_otis);
LINK_ENTITY_TO_FUNC(monster_otis_dead);
LINK_ENTITY_TO_FUNC(monster_ourano);
LINK_ENTITY_TO_FUNC(monster_parachute);
LINK_ENTITY_TO_FUNC(monster_penguin);
LINK_ENTITY_TO_FUNC(monster_penta);
LINK_ENTITY_TO_FUNC(monster_pig);
LINK_ENTITY_TO_FUNC(monster_pilot);
LINK_ENTITY_TO_FUNC(monster_pitdrone);
LINK_ENTITY_TO_FUNC(monster_pitworm);
LINK_ENTITY_TO_FUNC(monster_pitworm_up);
LINK_ENTITY_TO_FUNC(monster_prisoner);
LINK_ENTITY_TO_FUNC(monster_prop_apache);
LINK_ENTITY_TO_FUNC(monster_proximity);
LINK_ENTITY_TO_FUNC(monster_puma);
LINK_ENTITY_TO_FUNC(monster_ramone);
LINK_ENTITY_TO_FUNC(monster_ramone_repel);
LINK_ENTITY_TO_FUNC(monster_raptor);
LINK_ENTITY_TO_FUNC(monster_rat);
LINK_ENTITY_TO_FUNC(monster_recruit);
LINK_ENTITY_TO_FUNC(monster_replicateur);
LINK_ENTITY_TO_FUNC(monster_rustbattery);
LINK_ENTITY_TO_FUNC(monster_rustbit);
LINK_ENTITY_TO_FUNC(monster_rustbit_friendly);
LINK_ENTITY_TO_FUNC(monster_rustflier);
LINK_ENTITY_TO_FUNC(monster_rustgunr);
LINK_ENTITY_TO_FUNC(monster_sarge_allies);
LINK_ENTITY_TO_FUNC(monster_satchel);
LINK_ENTITY_TO_FUNC(monster_scientist);
LINK_ENTITY_TO_FUNC(monster_scientist_dead);
LINK_ENTITY_TO_FUNC(monster_scorpion);
LINK_ENTITY_TO_FUNC(monster_sentry);
LINK_ENTITY_TO_FUNC(monster_sentry_mini);
LINK_ENTITY_TO_FUNC(monster_sheep);
LINK_ENTITY_TO_FUNC(monster_shockroach);
LINK_ENTITY_TO_FUNC(monster_shocktrooper);
LINK_ENTITY_TO_FUNC(monster_shocktrooper_repel);
LINK_ENTITY_TO_FUNC(monster_sitting_civilian);
LINK_ENTITY_TO_FUNC(monster_sitting_cleansuit_scientist);
LINK_ENTITY_TO_FUNC(monster_sitting_colonel);
LINK_ENTITY_TO_FUNC(monster_sitting_crispen);
LINK_ENTITY_TO_FUNC(monster_sitting_dave);
LINK_ENTITY_TO_FUNC(monster_sitting_masala);
LINK_ENTITY_TO_FUNC(monster_sitting_nagatow);
LINK_ENTITY_TO_FUNC(monster_sitting_scientist);
LINK_ENTITY_TO_FUNC(monster_sitting_townmex);
LINK_ENTITY_TO_FUNC(monster_sitting_twnwesta);
LINK_ENTITY_TO_FUNC(monster_sitting_twnwestb);
LINK_ENTITY_TO_FUNC(monster_sitting_villager);
LINK_ENTITY_TO_FUNC(monster_skeleton);
LINK_ENTITY_TO_FUNC(monster_skeleton_dead);
LINK_ENTITY_TO_FUNC(monster_skelly);
LINK_ENTITY_TO_FUNC(monster_skellydance);
LINK_ENTITY_TO_FUNC(monster_smallminer);
LINK_ENTITY_TO_FUNC(monster_smallminer_dead);
LINK_ENTITY_TO_FUNC(monster_snake);
LINK_ENTITY_TO_FUNC(monster_snark);
LINK_ENTITY_TO_FUNC(monster_spforce_dead);
LINK_ENTITY_TO_FUNC(monster_spforce_repel);
LINK_ENTITY_TO_FUNC(monster_sphere);
LINK_ENTITY_TO_FUNC(monster_spider);
LINK_ENTITY_TO_FUNC(monster_spiritdragon);
LINK_ENTITY_TO_FUNC(monster_spiritwiz);
LINK_ENTITY_TO_FUNC(monster_srocket);
LINK_ENTITY_TO_FUNC(monster_super_snark);
LINK_ENTITY_TO_FUNC(monster_tank);
LINK_ENTITY_TO_FUNC(monster_targetrocket);
LINK_ENTITY_TO_FUNC(monster_tentacle);
LINK_ENTITY_TO_FUNC(monster_tentaclemaw);
LINK_ENTITY_TO_FUNC(monster_terror_dead);
LINK_ENTITY_TO_FUNC(monster_terror_repel);
LINK_ENTITY_TO_FUNC(monster_test);
LINK_ENTITY_TO_FUNC(monster_thornbush);
LINK_ENTITY_TO_FUNC(monster_tied_colonel);
LINK_ENTITY_TO_FUNC(monster_torch_ally_repel);
LINK_ENTITY_TO_FUNC(monster_tornado);
LINK_ENTITY_TO_FUNC(monster_townmex);
LINK_ENTITY_TO_FUNC(monster_townmex_dead);
LINK_ENTITY_TO_FUNC(monster_trainingbot);
LINK_ENTITY_TO_FUNC(monster_tripmine);
LINK_ENTITY_TO_FUNC(monster_troop);
LINK_ENTITY_TO_FUNC(monster_tube);
LINK_ENTITY_TO_FUNC(monster_tube_embryo);
LINK_ENTITY_TO_FUNC(monster_turret);
LINK_ENTITY_TO_FUNC(monster_turretbase);
LINK_ENTITY_TO_FUNC(monster_twnwesta);
LINK_ENTITY_TO_FUNC(monster_twnwesta_dead);
LINK_ENTITY_TO_FUNC(monster_twnwestb);
LINK_ENTITY_TO_FUNC(monster_twnwestb_dead);
LINK_ENTITY_TO_FUNC(monster_valve_turret);
LINK_ENTITY_TO_FUNC(monster_villager);
LINK_ENTITY_TO_FUNC(monster_villager_dead);
LINK_ENTITY_TO_FUNC(monster_vortigaunt);
LINK_ENTITY_TO_FUNC(monster_wizardclone);
LINK_ENTITY_TO_FUNC(monster_wombat);
LINK_ENTITY_TO_FUNC(monster_worker);
LINK_ENTITY_TO_FUNC(monster_worker_dead);
LINK_ENTITY_TO_FUNC(monster_wwmine);
LINK_ENTITY_TO_FUNC(monster_xenome);
LINK_ENTITY_TO_FUNC(monster_xenome_embryo);
LINK_ENTITY_TO_FUNC(monster_zbarney);
LINK_ENTITY_TO_FUNC(monster_zombie);
LINK_ENTITY_TO_FUNC(monster_zombie2);
LINK_ENTITY_TO_FUNC(monster_zombie_barney);
LINK_ENTITY_TO_FUNC(monster_zombie_soldier);
LINK_ENTITY_TO_FUNC(monster_zombie_soldier_dead);
LINK_ENTITY_TO_FUNC(monstermaker);
LINK_ENTITY_TO_FUNC(mortar_shell);
LINK_ENTITY_TO_FUNC(mortarshell);
LINK_ENTITY_TO_FUNC(movementchamber);
LINK_ENTITY_TO_FUNC(moving_camera);
LINK_ENTITY_TO_FUNC(multi_alias);
LINK_ENTITY_TO_FUNC(multi_manager);
LINK_ENTITY_TO_FUNC(multi_watcher);
LINK_ENTITY_TO_FUNC(multisource);
LINK_ENTITY_TO_FUNC(my_monster);
LINK_ENTITY_TO_FUNC(nail);
LINK_ENTITY_TO_FUNC(neutrinobeam);
LINK_ENTITY_TO_FUNC(nihilanth_energy_ball);
LINK_ENTITY_TO_FUNC(node_viewer);
LINK_ENTITY_TO_FUNC(node_viewer_fly);
LINK_ENTITY_TO_FUNC(node_viewer_human);
LINK_ENTITY_TO_FUNC(node_viewer_large);
LINK_ENTITY_TO_FUNC(npc);
LINK_ENTITY_TO_FUNC(npc_skrunk);
LINK_ENTITY_TO_FUNC(nuke);
LINK_ENTITY_TO_FUNC(nuke_rocket);
LINK_ENTITY_TO_FUNC(object);
LINK_ENTITY_TO_FUNC(object_beacon);
LINK_ENTITY_TO_FUNC(object_follow);
LINK_ENTITY_TO_FUNC(object_maker);
LINK_ENTITY_TO_FUNC(object_superchip);
LINK_ENTITY_TO_FUNC(offensechamber);
LINK_ENTITY_TO_FUNC(ol_bell);
LINK_ENTITY_TO_FUNC(ol_bluecapture);
LINK_ENTITY_TO_FUNC(ol_blueflag);
LINK_ENTITY_TO_FUNC(ol_bottle);
LINK_ENTITY_TO_FUNC(ol_ctf_blueteam);
LINK_ENTITY_TO_FUNC(ol_ctf_redteam);
LINK_ENTITY_TO_FUNC(ol_furniture);
LINK_ENTITY_TO_FUNC(ol_lantern);
LINK_ENTITY_TO_FUNC(ol_redcapture);
LINK_ENTITY_TO_FUNC(ol_redflag);
LINK_ENTITY_TO_FUNC(ol_spitoon);
LINK_ENTITY_TO_FUNC(old_rocket);
LINK_ENTITY_TO_FUNC(oldbot);
LINK_ENTITY_TO_FUNC(op4mortar);
LINK_ENTITY_TO_FUNC(oz_logo);
LINK_ENTITY_TO_FUNC(oz_rune);
LINK_ENTITY_TO_FUNC(paintball);
LINK_ENTITY_TO_FUNC(para_roundtimer);
LINK_ENTITY_TO_FUNC(path_corner);
LINK_ENTITY_TO_FUNC(path_track);
LINK_ENTITY_TO_FUNC(pballblue);
LINK_ENTITY_TO_FUNC(pballred);
LINK_ENTITY_TO_FUNC(phasegate);
LINK_ENTITY_TO_FUNC(pickup_drive_agrunt);
LINK_ENTITY_TO_FUNC(pickup_drive_apache);
LINK_ENTITY_TO_FUNC(pickup_drive_assassin);
LINK_ENTITY_TO_FUNC(pickup_drive_bm);
LINK_ENTITY_TO_FUNC(pickup_drive_bullsquid);
LINK_ENTITY_TO_FUNC(pickup_drive_controller);
LINK_ENTITY_TO_FUNC(pickup_drive_garg);
LINK_ENTITY_TO_FUNC(pickup_drive_houndeye);
LINK_ENTITY_TO_FUNC(pickup_drive_icky);
LINK_ENTITY_TO_FUNC(pickup_drive_panth);
LINK_ENTITY_TO_FUNC(pickup_drive_slave);
LINK_ENTITY_TO_FUNC(pickup_drive_turret);
LINK_ENTITY_TO_FUNC(pipebomb);
LINK_ENTITY_TO_FUNC(pitdronespike);
LINK_ENTITY_TO_FUNC(pitworm_gib);
LINK_ENTITY_TO_FUNC(pitworm_gibshooter);
LINK_ENTITY_TO_FUNC(plasma_ball);
LINK_ENTITY_TO_FUNC(player);
LINK_ENTITY_TO_FUNC(player_beartrapstrip);
LINK_ENTITY_TO_FUNC(player_corpse);
LINK_ENTITY_TO_FUNC(player_flame);
LINK_ENTITY_TO_FUNC(player_giveitems);
LINK_ENTITY_TO_FUNC(player_glasses);
LINK_ENTITY_TO_FUNC(player_helmet);
LINK_ENTITY_TO_FUNC(player_loadsaved);
LINK_ENTITY_TO_FUNC(player_roach);
LINK_ENTITY_TO_FUNC(player_speaker);
LINK_ENTITY_TO_FUNC(player_togglehud);
LINK_ENTITY_TO_FUNC(player_weaponship);
LINK_ENTITY_TO_FUNC(player_weaponstrip);
LINK_ENTITY_TO_FUNC(point_win);
LINK_ENTITY_TO_FUNC(potatoc);
LINK_ENTITY_TO_FUNC(power_ballbag);
LINK_ENTITY_TO_FUNC(power_coco);
LINK_ENTITY_TO_FUNC(power_gloves);
LINK_ENTITY_TO_FUNC(power_shield);
LINK_ENTITY_TO_FUNC(power_shoes);
LINK_ENTITY_TO_FUNC(powerup_candy);
LINK_ENTITY_TO_FUNC(proj_bird);
LINK_ENTITY_TO_FUNC(proj_bursatchel);
LINK_ENTITY_TO_FUNC(proj_cocklebur);
LINK_ENTITY_TO_FUNC(proj_comet);
LINK_ENTITY_TO_FUNC(proj_doublemagicmissle);
LINK_ENTITY_TO_FUNC(proj_dragonfire);
LINK_ENTITY_TO_FUNC(proj_earthquakesatchel);
LINK_ENTITY_TO_FUNC(proj_fireball);
LINK_ENTITY_TO_FUNC(proj_firesatchel);
LINK_ENTITY_TO_FUNC(proj_firespiral);
LINK_ENTITY_TO_FUNC(proj_fissure);
LINK_ENTITY_TO_FUNC(proj_flame);
LINK_ENTITY_TO_FUNC(proj_flyingskull);
LINK_ENTITY_TO_FUNC(proj_healhurtsatchel);
LINK_ENTITY_TO_FUNC(proj_icepoke);
LINK_ENTITY_TO_FUNC(proj_lightningcloud);
LINK_ENTITY_TO_FUNC(proj_lightningsatchel);
LINK_ENTITY_TO_FUNC(proj_magicmissle);
LINK_ENTITY_TO_FUNC(proj_meteor);
LINK_ENTITY_TO_FUNC(proj_mindmissle);
LINK_ENTITY_TO_FUNC(proj_poisonsatchel);
LINK_ENTITY_TO_FUNC(proj_rollingstone);
LINK_ENTITY_TO_FUNC(proj_sporepod);
LINK_ENTITY_TO_FUNC(proj_suctionsatchel);
LINK_ENTITY_TO_FUNC(proj_tcrystal);
LINK_ENTITY_TO_FUNC(proj_throwingbone);
LINK_ENTITY_TO_FUNC(proj_toothsatchel);
LINK_ENTITY_TO_FUNC(proj_whirlwind);
LINK_ENTITY_TO_FUNC(proj_wyvern);
LINK_ENTITY_TO_FUNC(promagcurse);
LINK_ENTITY_TO_FUNC(pulsefrag);
LINK_ENTITY_TO_FUNC(quake_nail);
LINK_ENTITY_TO_FUNC(quake_rocket);
LINK_ENTITY_TO_FUNC(rage);
LINK_ENTITY_TO_FUNC(random_ammo);
LINK_ENTITY_TO_FUNC(random_speaker);
LINK_ENTITY_TO_FUNC(random_trigger);
LINK_ENTITY_TO_FUNC(random_weapon);
LINK_ENTITY_TO_FUNC(redflag_follow);
LINK_ENTITY_TO_FUNC(reetou_proj);
LINK_ENTITY_TO_FUNC(resourcetower);
LINK_ENTITY_TO_FUNC(reversecurse);
LINK_ENTITY_TO_FUNC(rocket_air_strike);
LINK_ENTITY_TO_FUNC(rocket_croix);
LINK_ENTITY_TO_FUNC(rocket_napalm);
LINK_ENTITY_TO_FUNC(rocket_pigeon);
LINK_ENTITY_TO_FUNC(rocket_snipe);
LINK_ENTITY_TO_FUNC(rope_sample);
LINK_ENTITY_TO_FUNC(rope_segment);
LINK_ENTITY_TO_FUNC(rpg7_rocket);
LINK_ENTITY_TO_FUNC(rpg_rocket);
LINK_ENTITY_TO_FUNC(rr_shell);
LINK_ENTITY_TO_FUNC(sams_shower);
LINK_ENTITY_TO_FUNC(satelite_laser);
LINK_ENTITY_TO_FUNC(scan);
LINK_ENTITY_TO_FUNC(scatterattack);
LINK_ENTITY_TO_FUNC(scattersplit);
LINK_ENTITY_TO_FUNC(sci_spawner);
LINK_ENTITY_TO_FUNC(scientistbomb);
LINK_ENTITY_TO_FUNC(scripted_action);
LINK_ENTITY_TO_FUNC(scripted_sentence);
LINK_ENTITY_TO_FUNC(scripted_sequence);
LINK_ENTITY_TO_FUNC(sdcurse);
LINK_ENTITY_TO_FUNC(secondary_point);
LINK_ENTITY_TO_FUNC(sensorychamber);
LINK_ENTITY_TO_FUNC(sgvortex);
LINK_ENTITY_TO_FUNC(shenlong);
LINK_ENTITY_TO_FUNC(shock_beam);
LINK_ENTITY_TO_FUNC(siegeturret);
LINK_ENTITY_TO_FUNC(slAGruntTakeCoverFromEnemy);
LINK_ENTITY_TO_FUNC(slAGruntThreatDisplay);
LINK_ENTITY_TO_FUNC(slAssassinTakeCoverFromBestSound);
LINK_ENTITY_TO_FUNC(slAssassinTakeCoverFromEnemy);
LINK_ENTITY_TO_FUNC(slAssassinTakeCoverFromEnemy2);
LINK_ENTITY_TO_FUNC(slBaFaceTarget);
LINK_ENTITY_TO_FUNC(slControllerTakeCover);
LINK_ENTITY_TO_FUNC(slFaceTarget);
LINK_ENTITY_TO_FUNC(slFaceTargetScared);
LINK_ENTITY_TO_FUNC(slGruntTakeCover);
LINK_ENTITY_TO_FUNC(slGruntTakeCoverFromBestSound);
LINK_ENTITY_TO_FUNC(slGruntTossGrenadeCover);
LINK_ENTITY_TO_FUNC(slIdleTrigger);
LINK_ENTITY_TO_FUNC(slRunToScript);
LINK_ENTITY_TO_FUNC(slTakeCoverFromBestSound);
LINK_ENTITY_TO_FUNC(slTakeCoverFromEnemy);
LINK_ENTITY_TO_FUNC(slTakeCoverFromOrigin);
LINK_ENTITY_TO_FUNC(slTlkIdleEyecontact);
LINK_ENTITY_TO_FUNC(slTlkIdleWatchClient);
LINK_ENTITY_TO_FUNC(slTwitchDie);
LINK_ENTITY_TO_FUNC(slWalkToScript);
LINK_ENTITY_TO_FUNC(slowcurse);
LINK_ENTITY_TO_FUNC(slowrefirecurse);
LINK_ENTITY_TO_FUNC(snark_cam);
LINK_ENTITY_TO_FUNC(snowball);
LINK_ENTITY_TO_FUNC(soundent);
LINK_ENTITY_TO_FUNC(spark_shower);
LINK_ENTITY_TO_FUNC(spawnfar);
LINK_ENTITY_TO_FUNC(speaker);
LINK_ENTITY_TO_FUNC(spear_bolt);
LINK_ENTITY_TO_FUNC(specailbc);
LINK_ENTITY_TO_FUNC(sphere_explosion);
LINK_ENTITY_TO_FUNC(spirit_bomb);
LINK_ENTITY_TO_FUNC(spitgunprojectile);
LINK_ENTITY_TO_FUNC(spore);
LINK_ENTITY_TO_FUNC(sporegunprojectile);
LINK_ENTITY_TO_FUNC(spy_camera);
LINK_ENTITY_TO_FUNC(spy_escape);
LINK_ENTITY_TO_FUNC(squadmaker);
LINK_ENTITY_TO_FUNC(squidspit);
LINK_ENTITY_TO_FUNC(streak_spiral);
LINK_ENTITY_TO_FUNC(sturmbody);
LINK_ENTITY_TO_FUNC(suck_mine);
LINK_ENTITY_TO_FUNC(swarm_garg_stomp);
LINK_ENTITY_TO_FUNC(swarm_spawnpt_acontroller);
LINK_ENTITY_TO_FUNC(swarm_spawnpt_agarg);
LINK_ENTITY_TO_FUNC(swarm_spawnpt_aheadcrab);
LINK_ENTITY_TO_FUNC(swarm_spawnpt_aslave);
LINK_ENTITY_TO_FUNC(swarm_spawnpt_atripod);
LINK_ENTITY_TO_FUNC(swarm_spawnpt_hassassin);
LINK_ENTITY_TO_FUNC(swarm_spawnpt_hcommander);
LINK_ENTITY_TO_FUNC(swarm_spawnpt_hengineer);
LINK_ENTITY_TO_FUNC(swarm_spawnpt_hgrunt);
LINK_ENTITY_TO_FUNC(swarm_spawnpt_hscientist);
LINK_ENTITY_TO_FUNC(swarm_spawnpt_human);
LINK_ENTITY_TO_FUNC(swarm_team_alien);
LINK_ENTITY_TO_FUNC(swarm_team_human);
LINK_ENTITY_TO_FUNC(targ_speaker);
LINK_ENTITY_TO_FUNC(target_all_players);
LINK_ENTITY_TO_FUNC(target_cdaudio);
LINK_ENTITY_TO_FUNC(target_changemaster);
LINK_ENTITY_TO_FUNC(target_changetarget);
LINK_ENTITY_TO_FUNC(target_give);
LINK_ENTITY_TO_FUNC(target_gravity);
LINK_ENTITY_TO_FUNC(target_help);
LINK_ENTITY_TO_FUNC(target_hurt);
LINK_ENTITY_TO_FUNC(target_kill);
LINK_ENTITY_TO_FUNC(target_mp3audio);
LINK_ENTITY_TO_FUNC(target_print);
LINK_ENTITY_TO_FUNC(target_random);
LINK_ENTITY_TO_FUNC(target_relay);
LINK_ENTITY_TO_FUNC(target_reset);
LINK_ENTITY_TO_FUNC(target_respawn);
LINK_ENTITY_TO_FUNC(target_score);
LINK_ENTITY_TO_FUNC(target_spectate);
LINK_ENTITY_TO_FUNC(target_team);
LINK_ENTITY_TO_FUNC(target_team_score);
LINK_ENTITY_TO_FUNC(target_teamdie);
LINK_ENTITY_TO_FUNC(target_teleport);
LINK_ENTITY_TO_FUNC(target_weaponstrip);
LINK_ENTITY_TO_FUNC(target_win);
LINK_ENTITY_TO_FUNC(team_advarmory);
LINK_ENTITY_TO_FUNC(team_advturretfactory);
LINK_ENTITY_TO_FUNC(team_armory);
LINK_ENTITY_TO_FUNC(team_armslab);
LINK_ENTITY_TO_FUNC(team_chemlab);
LINK_ENTITY_TO_FUNC(team_command);
LINK_ENTITY_TO_FUNC(team_hive);
LINK_ENTITY_TO_FUNC(team_infportal);
LINK_ENTITY_TO_FUNC(team_medlab);
LINK_ENTITY_TO_FUNC(team_nukeplant);
LINK_ENTITY_TO_FUNC(team_observatory);
LINK_ENTITY_TO_FUNC(team_prototypelab);
LINK_ENTITY_TO_FUNC(team_turretfactory);
LINK_ENTITY_TO_FUNC(team_webstrand);
LINK_ENTITY_TO_FUNC(telebecon);
LINK_ENTITY_TO_FUNC(teledeath);
LINK_ENTITY_TO_FUNC(test_effect);
LINK_ENTITY_TO_FUNC(testhull);
LINK_ENTITY_TO_FUNC(tf_ammo_rpgclip);
LINK_ENTITY_TO_FUNC(tf_flame);
LINK_ENTITY_TO_FUNC(tf_flamethrower_burst);
LINK_ENTITY_TO_FUNC(tf_gl_grenade);
LINK_ENTITY_TO_FUNC(tf_ic_rocket);
LINK_ENTITY_TO_FUNC(tf_nailgun_nail);
LINK_ENTITY_TO_FUNC(tf_rpg_rocket);
LINK_ENTITY_TO_FUNC(tf_weapon_ac);
LINK_ENTITY_TO_FUNC(tf_weapon_autorifle);
LINK_ENTITY_TO_FUNC(tf_weapon_axe);
LINK_ENTITY_TO_FUNC(tf_weapon_caltrop);
LINK_ENTITY_TO_FUNC(tf_weapon_caltropgrenade);
LINK_ENTITY_TO_FUNC(tf_weapon_concussiongrenade);
LINK_ENTITY_TO_FUNC(tf_weapon_empgrenade);
LINK_ENTITY_TO_FUNC(tf_weapon_flamethrower);
LINK_ENTITY_TO_FUNC(tf_weapon_gasgrenade);
LINK_ENTITY_TO_FUNC(tf_weapon_genericprimedgrenade);
LINK_ENTITY_TO_FUNC(tf_weapon_gl);
LINK_ENTITY_TO_FUNC(tf_weapon_ic);
LINK_ENTITY_TO_FUNC(tf_weapon_knife);
LINK_ENTITY_TO_FUNC(tf_weapon_medikit);
LINK_ENTITY_TO_FUNC(tf_weapon_mirvbomblet);
LINK_ENTITY_TO_FUNC(tf_weapon_mirvgrenade);
LINK_ENTITY_TO_FUNC(tf_weapon_nailgrenade);
LINK_ENTITY_TO_FUNC(tf_weapon_napalmgrenade);
LINK_ENTITY_TO_FUNC(tf_weapon_ng);
LINK_ENTITY_TO_FUNC(tf_weapon_normalgrenade);
LINK_ENTITY_TO_FUNC(tf_weapon_pl);
LINK_ENTITY_TO_FUNC(tf_weapon_railgun);
LINK_ENTITY_TO_FUNC(tf_weapon_rpg);
LINK_ENTITY_TO_FUNC(tf_weapon_shotgun);
LINK_ENTITY_TO_FUNC(tf_weapon_sniperrifle);
LINK_ENTITY_TO_FUNC(tf_weapon_spanner);
LINK_ENTITY_TO_FUNC(tf_weapon_superng);
LINK_ENTITY_TO_FUNC(tf_weapon_supershotgun);
LINK_ENTITY_TO_FUNC(tf_weapon_tranq);
LINK_ENTITY_TO_FUNC(throwing_knife);
LINK_ENTITY_TO_FUNC(thrown_knife);
LINK_ENTITY_TO_FUNC(timer);
LINK_ENTITY_TO_FUNC(tlAGruntTakeCoverFromEnemy);
LINK_ENTITY_TO_FUNC(tlAGruntThreatDisplay);
LINK_ENTITY_TO_FUNC(tlAssassinTakeCoverFromBestSound);
LINK_ENTITY_TO_FUNC(tlAssassinTakeCoverFromEnemy);
LINK_ENTITY_TO_FUNC(tlAssassinTakeCoverFromEnemy2);
LINK_ENTITY_TO_FUNC(tlBaFaceTarget);
LINK_ENTITY_TO_FUNC(tlControllerTakeCover);
LINK_ENTITY_TO_FUNC(tlFaceTarget);
LINK_ENTITY_TO_FUNC(tlFaceTargetScared);
LINK_ENTITY_TO_FUNC(tlGruntTakeCover1);
LINK_ENTITY_TO_FUNC(tlGruntTakeCoverFromBestSound);
LINK_ENTITY_TO_FUNC(tlGruntTossGrenadeCover1);
LINK_ENTITY_TO_FUNC(tlTakeCoverFromBestSound);
LINK_ENTITY_TO_FUNC(tlTakeCoverFromEnemy);
LINK_ENTITY_TO_FUNC(tlTakeCoverFromOrigin);
LINK_ENTITY_TO_FUNC(tlTlkIdleEyecontact);
LINK_ENTITY_TO_FUNC(tlTlkIdleWatchClient);
LINK_ENTITY_TO_FUNC(tlTlkIdleWatchClientStare);
LINK_ENTITY_TO_FUNC(tlTwitchDie);
LINK_ENTITY_TO_FUNC(tod_control_area);
LINK_ENTITY_TO_FUNC(tod_control_point);
LINK_ENTITY_TO_FUNC(tod_notripmine_area);
LINK_ENTITY_TO_FUNC(tod_roundend_trigger);
LINK_ENTITY_TO_FUNC(tod_roundstart_trigger);
LINK_ENTITY_TO_FUNC(tod_roundwon_trigger);
LINK_ENTITY_TO_FUNC(tombstone);
LINK_ENTITY_TO_FUNC(translocator_disc);
LINK_ENTITY_TO_FUNC(transport_apc);
LINK_ENTITY_TO_FUNC(transport_blackhawk);
LINK_ENTITY_TO_FUNC(trigger);
LINK_ENTITY_TO_FUNC(trigger_armory);
LINK_ENTITY_TO_FUNC(trigger_auto);
LINK_ENTITY_TO_FUNC(trigger_autosave);
LINK_ENTITY_TO_FUNC(trigger_baril);
LINK_ENTITY_TO_FUNC(trigger_camera);
LINK_ENTITY_TO_FUNC(trigger_capturetimer);
LINK_ENTITY_TO_FUNC(trigger_captureupdate);
LINK_ENTITY_TO_FUNC(trigger_cdaudio);
LINK_ENTITY_TO_FUNC(trigger_changealias);
LINK_ENTITY_TO_FUNC(trigger_changelevel);
LINK_ENTITY_TO_FUNC(trigger_changetarget);
LINK_ENTITY_TO_FUNC(trigger_comet);
LINK_ENTITY_TO_FUNC(trigger_control);
LINK_ENTITY_TO_FUNC(trigger_coop);
LINK_ENTITY_TO_FUNC(trigger_counter);
LINK_ENTITY_TO_FUNC(trigger_ctfgeneric);
LINK_ENTITY_TO_FUNC(trigger_deathmatch);
LINK_ENTITY_TO_FUNC(trigger_die);
LINK_ENTITY_TO_FUNC(trigger_discerturn);
LINK_ENTITY_TO_FUNC(trigger_discreturn);
LINK_ENTITY_TO_FUNC(trigger_endsection);
LINK_ENTITY_TO_FUNC(trigger_env_hurt);
LINK_ENTITY_TO_FUNC(trigger_fall);
LINK_ENTITY_TO_FUNC(trigger_geneworm_hit);
LINK_ENTITY_TO_FUNC(trigger_goal);
LINK_ENTITY_TO_FUNC(trigger_golem);
LINK_ENTITY_TO_FUNC(trigger_gravity);
LINK_ENTITY_TO_FUNC(trigger_gunmanteleport);
LINK_ENTITY_TO_FUNC(trigger_hold);
LINK_ENTITY_TO_FUNC(trigger_hurt);
LINK_ENTITY_TO_FUNC(trigger_hurt_bleu);
LINK_ENTITY_TO_FUNC(trigger_hurt_rouge);
LINK_ENTITY_TO_FUNC(trigger_jail);
LINK_ENTITY_TO_FUNC(trigger_jail_release);
LINK_ENTITY_TO_FUNC(trigger_jump);
LINK_ENTITY_TO_FUNC(trigger_jumppad);
LINK_ENTITY_TO_FUNC(trigger_katehealth);
LINK_ENTITY_TO_FUNC(trigger_kill_nogib);
LINK_ENTITY_TO_FUNC(trigger_killmonster);
LINK_ENTITY_TO_FUNC(trigger_lightstyle);
LINK_ENTITY_TO_FUNC(trigger_loadhazard);
LINK_ENTITY_TO_FUNC(trigger_mine);
LINK_ENTITY_TO_FUNC(trigger_monsterjump);
LINK_ENTITY_TO_FUNC(trigger_multiple);
LINK_ENTITY_TO_FUNC(trigger_music);
LINK_ENTITY_TO_FUNC(trigger_npcarea);
LINK_ENTITY_TO_FUNC(trigger_objectcapture);
LINK_ENTITY_TO_FUNC(trigger_once);
LINK_ENTITY_TO_FUNC(trigger_playerfreeze);
LINK_ENTITY_TO_FUNC(trigger_point_controle);
LINK_ENTITY_TO_FUNC(trigger_presence);
LINK_ENTITY_TO_FUNC(trigger_push);
LINK_ENTITY_TO_FUNC(trigger_random);
LINK_ENTITY_TO_FUNC(trigger_random_time);
LINK_ENTITY_TO_FUNC(trigger_regen);
LINK_ENTITY_TO_FUNC(trigger_relay);
LINK_ENTITY_TO_FUNC(trigger_respawn);
LINK_ENTITY_TO_FUNC(trigger_rndbased);
LINK_ENTITY_TO_FUNC(trigger_script);
LINK_ENTITY_TO_FUNC(trigger_secret);
LINK_ENTITY_TO_FUNC(trigger_section);
LINK_ENTITY_TO_FUNC(trigger_shutup);
LINK_ENTITY_TO_FUNC(trigger_sound);
LINK_ENTITY_TO_FUNC(trigger_sponly);
LINK_ENTITY_TO_FUNC(trigger_startpatrol);
LINK_ENTITY_TO_FUNC(trigger_teampush);
LINK_ENTITY_TO_FUNC(trigger_teleport);
LINK_ENTITY_TO_FUNC(trigger_transition);
LINK_ENTITY_TO_FUNC(trigger_xen_return);
LINK_ENTITY_TO_FUNC(trigger_zone);
LINK_ENTITY_TO_FUNC(trigger_zone_bleu);
LINK_ENTITY_TO_FUNC(trigger_zone_rouge);
LINK_ENTITY_TO_FUNC(trip_beam);
LINK_ENTITY_TO_FUNC(turf_zone);
LINK_ENTITY_TO_FUNC(turret);
LINK_ENTITY_TO_FUNC(umbracloud);
LINK_ENTITY_TO_FUNC(vehicle);
LINK_ENTITY_TO_FUNC(vehicle_tank);
LINK_ENTITY_TO_FUNC(victim_scientist);
LINK_ENTITY_TO_FUNC(vote_llama);
LINK_ENTITY_TO_FUNC(vscrossbow_bolt);
LINK_ENTITY_TO_FUNC(watcher);
LINK_ENTITY_TO_FUNC(weapmortar);
LINK_ENTITY_TO_FUNC(weapon_1100);
LINK_ENTITY_TO_FUNC(weapon_1911);
LINK_ENTITY_TO_FUNC(weapon_30cal);
LINK_ENTITY_TO_FUNC(weapon_357);
LINK_ENTITY_TO_FUNC(weapon_40gl);
LINK_ENTITY_TO_FUNC(weapon_50cal);
LINK_ENTITY_TO_FUNC(weapon_90mm);
LINK_ENTITY_TO_FUNC(weapon_92d);
LINK_ENTITY_TO_FUNC(weapon_9mmAR);
LINK_ENTITY_TO_FUNC(weapon_9mmhandgun);
LINK_ENTITY_TO_FUNC(weapon_9mmm41a);
LINK_ENTITY_TO_FUNC(weapon_BrownBess);
LINK_ENTITY_TO_FUNC(weapon_Charleville);
LINK_ENTITY_TO_FUNC(weapon_G11);
LINK_ENTITY_TO_FUNC(weapon_Knife);
LINK_ENTITY_TO_FUNC(weapon_Pennsylvania);
LINK_ENTITY_TO_FUNC(weapon_PistolA);
LINK_ENTITY_TO_FUNC(weapon_PistolB);
LINK_ENTITY_TO_FUNC(weapon_Revolutionnaire);
LINK_ENTITY_TO_FUNC(weapon_SPchemicalgun);
LINK_ENTITY_TO_FUNC(weapon_Sabre);
LINK_ENTITY_TO_FUNC(weapon_aandagger);
LINK_ENTITY_TO_FUNC(weapon_acannon);
LINK_ENTITY_TO_FUNC(weapon_acidrocket);
LINK_ENTITY_TO_FUNC(weapon_acidrocketgun);
LINK_ENTITY_TO_FUNC(weapon_adrenaline);
LINK_ENTITY_TO_FUNC(weapon_aicore);
LINK_ENTITY_TO_FUNC(weapon_air_strike);
LINK_ENTITY_TO_FUNC(weapon_ak);
LINK_ENTITY_TO_FUNC(weapon_ak101);
LINK_ENTITY_TO_FUNC(weapon_ak47);
LINK_ENTITY_TO_FUNC(weapon_ak5);
LINK_ENTITY_TO_FUNC(weapon_ak5s);
LINK_ENTITY_TO_FUNC(weapon_ak74);
LINK_ENTITY_TO_FUNC(weapon_akimbo_glocks);
LINK_ENTITY_TO_FUNC(weapon_akimbob);
LINK_ENTITY_TO_FUNC(weapon_akimcolt);
LINK_ENTITY_TO_FUNC(weapon_akimsaa);
LINK_ENTITY_TO_FUNC(weapon_alarm);
LINK_ENTITY_TO_FUNC(weapon_aliencannon);
LINK_ENTITY_TO_FUNC(weapon_amerknife);
LINK_ENTITY_TO_FUNC(weapon_anaconda);
LINK_ENTITY_TO_FUNC(weapon_angel);
LINK_ENTITY_TO_FUNC(weapon_ar10);
LINK_ENTITY_TO_FUNC(weapon_ar33);
LINK_ENTITY_TO_FUNC(weapon_aug);
LINK_ENTITY_TO_FUNC(weapon_autococker);
LINK_ENTITY_TO_FUNC(weapon_autogl);
LINK_ENTITY_TO_FUNC(weapon_automag);
LINK_ENTITY_TO_FUNC(weapon_awm);
LINK_ENTITY_TO_FUNC(weapon_awp);
LINK_ENTITY_TO_FUNC(weapon_b93r);
LINK_ENTITY_TO_FUNC(weapon_babblergun);
LINK_ENTITY_TO_FUNC(weapon_babblerprojectile);
LINK_ENTITY_TO_FUNC(weapon_balllightningspell);
LINK_ENTITY_TO_FUNC(weapon_banane);
LINK_ENTITY_TO_FUNC(weapon_bandage);
LINK_ENTITY_TO_FUNC(weapon_bar);
LINK_ENTITY_TO_FUNC(weapon_baretta);
LINK_ENTITY_TO_FUNC(weapon_barnacle);
LINK_ENTITY_TO_FUNC(weapon_barney9mmar);
LINK_ENTITY_TO_FUNC(weapon_barney9mmhg);
LINK_ENTITY_TO_FUNC(weapon_barneyhandgrenade);
LINK_ENTITY_TO_FUNC(weapon_barneyshotgun);
LINK_ENTITY_TO_FUNC(weapon_bat);
LINK_ENTITY_TO_FUNC(weapon_baton);
LINK_ENTITY_TO_FUNC(weapon_batsup);
LINK_ENTITY_TO_FUNC(weapon_batte);
LINK_ENTITY_TO_FUNC(weapon_battleaxe);
LINK_ENTITY_TO_FUNC(weapon_bayonet);
LINK_ENTITY_TO_FUNC(weapon_bazooka);
LINK_ENTITY_TO_FUNC(weapon_beamgun);
LINK_ENTITY_TO_FUNC(weapon_beanstalkspell);
LINK_ENTITY_TO_FUNC(weapon_bearbite);
LINK_ENTITY_TO_FUNC(weapon_bearclaw);
LINK_ENTITY_TO_FUNC(weapon_beartrap);
LINK_ENTITY_TO_FUNC(weapon_benelli);
LINK_ENTITY_TO_FUNC(weapon_ber92f);
LINK_ENTITY_TO_FUNC(weapon_ber93r);
LINK_ENTITY_TO_FUNC(weapon_beretta);
LINK_ENTITY_TO_FUNC(weapon_bigbang);
LINK_ENTITY_TO_FUNC(weapon_biggun);
LINK_ENTITY_TO_FUNC(weapon_bilebomb);
LINK_ENTITY_TO_FUNC(weapon_bilebombgun);
LINK_ENTITY_TO_FUNC(weapon_binoculars);
LINK_ENTITY_TO_FUNC(weapon_binos);
LINK_ENTITY_TO_FUNC(weapon_birdspell);
LINK_ENTITY_TO_FUNC(weapon_bite2gun);
LINK_ENTITY_TO_FUNC(weapon_bitegun);
LINK_ENTITY_TO_FUNC(weapon_bizon);
LINK_ENTITY_TO_FUNC(weapon_blink);
LINK_ENTITY_TO_FUNC(weapon_boltrifle);
LINK_ENTITY_TO_FUNC(weapon_bomb);
LINK_ENTITY_TO_FUNC(weapon_bomber);
LINK_ENTITY_TO_FUNC(weapon_bow);
LINK_ENTITY_TO_FUNC(weapon_brickcannon);
LINK_ENTITY_TO_FUNC(weapon_briefcase);
LINK_ENTITY_TO_FUNC(weapon_bsword);
LINK_ENTITY_TO_FUNC(weapon_buffalo);
LINK_ENTITY_TO_FUNC(weapon_burningattack);
LINK_ENTITY_TO_FUNC(weapon_bush);
LINK_ENTITY_TO_FUNC(weapon_bushmaster);
LINK_ENTITY_TO_FUNC(weapon_c4);
LINK_ENTITY_TO_FUNC(weapon_cal50);
LINK_ENTITY_TO_FUNC(weapon_camera);
LINK_ENTITY_TO_FUNC(weapon_candy);
LINK_ENTITY_TO_FUNC(weapon_cannon);
LINK_ENTITY_TO_FUNC(weapon_caws);
LINK_ENTITY_TO_FUNC(weapon_cellphone);
LINK_ENTITY_TO_FUNC(weapon_chaingun);
LINK_ENTITY_TO_FUNC(weapon_chainsaw);
LINK_ENTITY_TO_FUNC(weapon_charge);
LINK_ENTITY_TO_FUNC(weapon_charged);
LINK_ENTITY_TO_FUNC(weapon_claw);
LINK_ENTITY_TO_FUNC(weapon_claws);
LINK_ENTITY_TO_FUNC(weapon_claymore);
LINK_ENTITY_TO_FUNC(weapon_clip_generic);
LINK_ENTITY_TO_FUNC(weapon_cloak);
LINK_ENTITY_TO_FUNC(weapon_cloaker);
LINK_ENTITY_TO_FUNC(weapon_cluster);
LINK_ENTITY_TO_FUNC(weapon_cocker);
LINK_ENTITY_TO_FUNC(weapon_cocogrenade);
LINK_ENTITY_TO_FUNC(weapon_colt);
LINK_ENTITY_TO_FUNC(weapon_colt45);
LINK_ENTITY_TO_FUNC(weapon_coltgov);
LINK_ENTITY_TO_FUNC(weapon_colts);
LINK_ENTITY_TO_FUNC(weapon_combospell);
LINK_ENTITY_TO_FUNC(weapon_cometspell);
LINK_ENTITY_TO_FUNC(weapon_concussion);
LINK_ENTITY_TO_FUNC(weapon_controlled);
LINK_ENTITY_TO_FUNC(weapon_cougar);
LINK_ENTITY_TO_FUNC(weapon_coujaf);
LINK_ENTITY_TO_FUNC(weapon_couteau);
LINK_ENTITY_TO_FUNC(weapon_croix);
LINK_ENTITY_TO_FUNC(weapon_crossbow);
LINK_ENTITY_TO_FUNC(weapon_crowbar);
LINK_ENTITY_TO_FUNC(weapon_d5k);
LINK_ENTITY_TO_FUNC(weapon_daystick);
LINK_ENTITY_TO_FUNC(weapon_dblshot);
LINK_ENTITY_TO_FUNC(weapon_dbshot);
LINK_ENTITY_TO_FUNC(weapon_dd44);
LINK_ENTITY_TO_FUNC(weapon_de50);
LINK_ENTITY_TO_FUNC(weapon_deagle);
LINK_ENTITY_TO_FUNC(weapon_deathball);
LINK_ENTITY_TO_FUNC(weapon_deathrayspell);
LINK_ENTITY_TO_FUNC(weapon_desert);
LINK_ENTITY_TO_FUNC(weapon_deserteagle);
LINK_ENTITY_TO_FUNC(weapon_destructodisc);
LINK_ENTITY_TO_FUNC(weapon_devastator);
LINK_ENTITY_TO_FUNC(weapon_disc);
LINK_ENTITY_TO_FUNC(weapon_disclauncher);
LINK_ENTITY_TO_FUNC(weapon_discoballs);
LINK_ENTITY_TO_FUNC(weapon_disintegrator);
LINK_ENTITY_TO_FUNC(weapon_displacer);
LINK_ENTITY_TO_FUNC(weapon_divinewind);
LINK_ENTITY_TO_FUNC(weapon_dml);
LINK_ENTITY_TO_FUNC(weapon_double);
LINK_ENTITY_TO_FUNC(weapon_doublemagicmisslespell);
LINK_ENTITY_TO_FUNC(weapon_doubleshotgun);
LINK_ENTITY_TO_FUNC(weapon_dragonball);
LINK_ENTITY_TO_FUNC(weapon_dragonbreathspell);
LINK_ENTITY_TO_FUNC(weapon_dragonspell);
LINK_ENTITY_TO_FUNC(weapon_dragunov);
LINK_ENTITY_TO_FUNC(weapon_dsr1);
LINK_ENTITY_TO_FUNC(weapon_dualberettas);
LINK_ENTITY_TO_FUNC(weapon_dualscorpion);
LINK_ENTITY_TO_FUNC(weapon_dummy);
LINK_ENTITY_TO_FUNC(weapon_dynamite);
LINK_ENTITY_TO_FUNC(weapon_dynomite);
LINK_ENTITY_TO_FUNC(weapon_eagle);
LINK_ENTITY_TO_FUNC(weapon_eballblaster);
LINK_ENTITY_TO_FUNC(weapon_egon);
LINK_ENTITY_TO_FUNC(weapon_elite);
LINK_ENTITY_TO_FUNC(weapon_emsniper);
LINK_ENTITY_TO_FUNC(weapon_excal);
LINK_ENTITY_TO_FUNC(weapon_experimental);
LINK_ENTITY_TO_FUNC(weapon_expgrenade);
LINK_ENTITY_TO_FUNC(weapon_eyelaser);
LINK_ENTITY_TO_FUNC(weapon_famas);
LINK_ENTITY_TO_FUNC(weapon_fev);
LINK_ENTITY_TO_FUNC(weapon_fg42);
LINK_ENTITY_TO_FUNC(weapon_finalflash);
LINK_ENTITY_TO_FUNC(weapon_fingerlaser);
LINK_ENTITY_TO_FUNC(weapon_finishingbuster);
LINK_ENTITY_TO_FUNC(weapon_fireballspell);
LINK_ENTITY_TO_FUNC(weapon_fishingrod);
LINK_ENTITY_TO_FUNC(weapon_fist);
LINK_ENTITY_TO_FUNC(weapon_fists);
LINK_ENTITY_TO_FUNC(weapon_fiveseven);
LINK_ENTITY_TO_FUNC(weapon_flakcannon);
LINK_ENTITY_TO_FUNC(weapon_flame);
LINK_ENTITY_TO_FUNC(weapon_flamegrenade);
LINK_ENTITY_TO_FUNC(weapon_flamegun);
LINK_ENTITY_TO_FUNC(weapon_flamelickspell);
LINK_ENTITY_TO_FUNC(weapon_flamethrower);
LINK_ENTITY_TO_FUNC(weapon_flaregun);
LINK_ENTITY_TO_FUNC(weapon_flarepistol);
LINK_ENTITY_TO_FUNC(weapon_flashbang);
LINK_ENTITY_TO_FUNC(weapon_fleshgrenade);
LINK_ENTITY_TO_FUNC(weapon_flute);
LINK_ENTITY_TO_FUNC(weapon_fnfal);
LINK_ENTITY_TO_FUNC(weapon_forcespell);
LINK_ENTITY_TO_FUNC(weapon_frag);
LINK_ENTITY_TO_FUNC(weapon_freezer);
LINK_ENTITY_TO_FUNC(weapon_freezerayspell);
LINK_ENTITY_TO_FUNC(weapon_friezadisc);
LINK_ENTITY_TO_FUNC(weapon_fusil);
LINK_ENTITY_TO_FUNC(weapon_g11);
LINK_ENTITY_TO_FUNC(weapon_g36);
LINK_ENTITY_TO_FUNC(weapon_g36c);
LINK_ENTITY_TO_FUNC(weapon_g36cs);
LINK_ENTITY_TO_FUNC(weapon_g36e);
LINK_ENTITY_TO_FUNC(weapon_g36k);
LINK_ENTITY_TO_FUNC(weapon_g3a3);
LINK_ENTITY_TO_FUNC(weapon_g3sg1);
LINK_ENTITY_TO_FUNC(weapon_ga2uss);
LINK_ENTITY_TO_FUNC(weapon_gacgoa);
LINK_ENTITY_TO_FUNC(weapon_galil);
LINK_ENTITY_TO_FUNC(weapon_gallitgun);
LINK_ENTITY_TO_FUNC(weapon_garand);
LINK_ENTITY_TO_FUNC(weapon_gasgrenade);
LINK_ENTITY_TO_FUNC(weapon_gatlin);
LINK_ENTITY_TO_FUNC(weapon_gattlinggun);
LINK_ENTITY_TO_FUNC(weapon_gauss);
LINK_ENTITY_TO_FUNC(weapon_gausspistol);
LINK_ENTITY_TO_FUNC(weapon_generic);
LINK_ENTITY_TO_FUNC(weapon_genericbeam);
LINK_ENTITY_TO_FUNC(weapon_gerknife);
LINK_ENTITY_TO_FUNC(weapon_germanknife);
LINK_ENTITY_TO_FUNC(weapon_gewehr);
LINK_ENTITY_TO_FUNC(weapon_giantplantspell);
LINK_ENTITY_TO_FUNC(weapon_glauncher);
LINK_ENTITY_TO_FUNC(weapon_glock);
LINK_ENTITY_TO_FUNC(weapon_glock17);
LINK_ENTITY_TO_FUNC(weapon_glock18);
LINK_ENTITY_TO_FUNC(weapon_goldpp7);
LINK_ENTITY_TO_FUNC(weapon_gps);
LINK_ENTITY_TO_FUNC(weapon_grappin);
LINK_ENTITY_TO_FUNC(weapon_grapple);
LINK_ENTITY_TO_FUNC(weapon_grease);
LINK_ENTITY_TO_FUNC(weapon_greasegun);
LINK_ENTITY_TO_FUNC(weapon_gren);
LINK_ENTITY_TO_FUNC(weapon_grenade);
LINK_ENTITY_TO_FUNC(weapon_grenadegun);
LINK_ENTITY_TO_FUNC(weapon_grenadelauncher);
LINK_ENTITY_TO_FUNC(weapon_guardian);
LINK_ENTITY_TO_FUNC(weapon_hache);
LINK_ENTITY_TO_FUNC(weapon_hammer);
LINK_ENTITY_TO_FUNC(weapon_handcannon);
LINK_ENTITY_TO_FUNC(weapon_handgrenade);
LINK_ENTITY_TO_FUNC(weapon_handgrenade_ex);
LINK_ENTITY_TO_FUNC(weapon_harpoongun);
LINK_ENTITY_TO_FUNC(weapon_healingspray);
LINK_ENTITY_TO_FUNC(weapon_heavymachinegun);
LINK_ENTITY_TO_FUNC(weapon_hegrenade);
LINK_ENTITY_TO_FUNC(weapon_helico);
LINK_ENTITY_TO_FUNC(weapon_hk21);
LINK_ENTITY_TO_FUNC(weapon_hk33);
LINK_ENTITY_TO_FUNC(weapon_hk33ka2);
LINK_ENTITY_TO_FUNC(weapon_hkmp5);
LINK_ENTITY_TO_FUNC(weapon_holybsword);
LINK_ENTITY_TO_FUNC(weapon_hornetgun);
LINK_ENTITY_TO_FUNC(weapon_hyperblaster);
LINK_ENTITY_TO_FUNC(weapon_icepokespell);
LINK_ENTITY_TO_FUNC(weapon_infector);
LINK_ENTITY_TO_FUNC(weapon_invis);
LINK_ENTITY_TO_FUNC(weapon_islavezap);
LINK_ENTITY_TO_FUNC(weapon_ithaca);
LINK_ENTITY_TO_FUNC(weapon_jackhammer);
LINK_ENTITY_TO_FUNC(weapon_jetfist);
LINK_ENTITY_TO_FUNC(weapon_jetpack);
LINK_ENTITY_TO_FUNC(weapon_k43);
LINK_ENTITY_TO_FUNC(weapon_kameha);
LINK_ENTITY_TO_FUNC(weapon_kamehameha);
LINK_ENTITY_TO_FUNC(weapon_kamikaze);
LINK_ENTITY_TO_FUNC(weapon_kar);
LINK_ENTITY_TO_FUNC(weapon_katana);
LINK_ENTITY_TO_FUNC(weapon_kbar);
LINK_ENTITY_TO_FUNC(weapon_kf7);
LINK_ENTITY_TO_FUNC(weapon_kiblast);
LINK_ENTITY_TO_FUNC(weapon_kmedkit);
LINK_ENTITY_TO_FUNC(weapon_knife);
LINK_ENTITY_TO_FUNC(weapon_lance);
LINK_ENTITY_TO_FUNC(weapon_larve);
LINK_ENTITY_TO_FUNC(weapon_laser);
LINK_ENTITY_TO_FUNC(weapon_lasergatling);
LINK_ENTITY_TO_FUNC(weapon_launcher);
LINK_ENTITY_TO_FUNC(weapon_law);
LINK_ENTITY_TO_FUNC(weapon_lawgiver);
LINK_ENTITY_TO_FUNC(weapon_lawrod);
LINK_ENTITY_TO_FUNC(weapon_leap);
LINK_ENTITY_TO_FUNC(weapon_levitationspell);
LINK_ENTITY_TO_FUNC(weapon_lightning);
LINK_ENTITY_TO_FUNC(weapon_lightningboltspell);
LINK_ENTITY_TO_FUNC(weapon_lightningcloudspell);
LINK_ENTITY_TO_FUNC(weapon_lightsabre);
LINK_ENTITY_TO_FUNC(weapon_lngun);
LINK_ENTITY_TO_FUNC(weapon_longslide);
LINK_ENTITY_TO_FUNC(weapon_longsword);
LINK_ENTITY_TO_FUNC(weapon_lr300);
LINK_ENTITY_TO_FUNC(weapon_lr300s);
LINK_ENTITY_TO_FUNC(weapon_luger);
LINK_ENTITY_TO_FUNC(weapon_m11);
LINK_ENTITY_TO_FUNC(weapon_m14);
LINK_ENTITY_TO_FUNC(weapon_m16);
LINK_ENTITY_TO_FUNC(weapon_m16a2);
LINK_ENTITY_TO_FUNC(weapon_m1carbine);
LINK_ENTITY_TO_FUNC(weapon_m2);
LINK_ENTITY_TO_FUNC(weapon_m21);
LINK_ENTITY_TO_FUNC(weapon_m249);
LINK_ENTITY_TO_FUNC(weapon_m3);
LINK_ENTITY_TO_FUNC(weapon_m4);
LINK_ENTITY_TO_FUNC(weapon_m40a1);
LINK_ENTITY_TO_FUNC(weapon_m41);
LINK_ENTITY_TO_FUNC(weapon_m4a1);
LINK_ENTITY_TO_FUNC(weapon_m60);
LINK_ENTITY_TO_FUNC(weapon_m79);
LINK_ENTITY_TO_FUNC(weapon_m82);
LINK_ENTITY_TO_FUNC(weapon_m86);
LINK_ENTITY_TO_FUNC(weapon_m92s);
LINK_ENTITY_TO_FUNC(weapon_m96);
LINK_ENTITY_TO_FUNC(weapon_m98);
LINK_ENTITY_TO_FUNC(weapon_mac);
LINK_ENTITY_TO_FUNC(weapon_mac10);
LINK_ENTITY_TO_FUNC(weapon_machete);
LINK_ENTITY_TO_FUNC(weapon_machinegun);
LINK_ENTITY_TO_FUNC(weapon_mag);
LINK_ENTITY_TO_FUNC(weapon_magicmisslespell);
LINK_ENTITY_TO_FUNC(weapon_main);
LINK_ENTITY_TO_FUNC(weapon_masenko);
LINK_ENTITY_TO_FUNC(weapon_mat49);
LINK_ENTITY_TO_FUNC(weapon_maverick);
LINK_ENTITY_TO_FUNC(weapon_mc51);
LINK_ENTITY_TO_FUNC(weapon_medkit);
LINK_ENTITY_TO_FUNC(weapon_melee);
LINK_ENTITY_TO_FUNC(weapon_meteorspell);
LINK_ENTITY_TO_FUNC(weapon_mf2);
LINK_ENTITY_TO_FUNC(weapon_mg34);
LINK_ENTITY_TO_FUNC(weapon_mg36);
LINK_ENTITY_TO_FUNC(weapon_mg42);
LINK_ENTITY_TO_FUNC(weapon_mindmisslespell);
LINK_ENTITY_TO_FUNC(weapon_mindray);
LINK_ENTITY_TO_FUNC(weapon_mine);
LINK_ENTITY_TO_FUNC(weapon_minicanon);
LINK_ENTITY_TO_FUNC(weapon_minigun);
LINK_ENTITY_TO_FUNC(weapon_mk23);
LINK_ENTITY_TO_FUNC(weapon_model98);
LINK_ENTITY_TO_FUNC(weapon_molotov);
LINK_ENTITY_TO_FUNC(weapon_mop);
LINK_ENTITY_TO_FUNC(weapon_mortar);
LINK_ENTITY_TO_FUNC(weapon_mortier);
LINK_ENTITY_TO_FUNC(weapon_morve);
LINK_ENTITY_TO_FUNC(weapon_mosin);
LINK_ENTITY_TO_FUNC(weapon_mossberg);
LINK_ENTITY_TO_FUNC(weapon_mouthblast);
LINK_ENTITY_TO_FUNC(weapon_mouton);
LINK_ENTITY_TO_FUNC(weapon_mp40);
LINK_ENTITY_TO_FUNC(weapon_mp44);
LINK_ENTITY_TO_FUNC(weapon_mp5);
LINK_ENTITY_TO_FUNC(weapon_mp510);
LINK_ENTITY_TO_FUNC(weapon_mp5a2);
LINK_ENTITY_TO_FUNC(weapon_mp5a4);
LINK_ENTITY_TO_FUNC(weapon_mp5a5);
LINK_ENTITY_TO_FUNC(weapon_mp5k);
LINK_ENTITY_TO_FUNC(weapon_mp5navy);
LINK_ENTITY_TO_FUNC(weapon_mp5pdw);
LINK_ENTITY_TO_FUNC(weapon_mp5sd);
LINK_ENTITY_TO_FUNC(weapon_msg90);
LINK_ENTITY_TO_FUNC(weapon_musket);
LINK_ENTITY_TO_FUNC(weapon_mwgun);
LINK_ENTITY_TO_FUNC(weapon_nailgun);
LINK_ENTITY_TO_FUNC(weapon_napalm);
LINK_ENTITY_TO_FUNC(weapon_ndagger);
LINK_ENTITY_TO_FUNC(weapon_needle);
LINK_ENTITY_TO_FUNC(weapon_ngun);
LINK_ENTITY_TO_FUNC(weapon_nightstick);
LINK_ENTITY_TO_FUNC(weapon_not_in_use_grenade);
LINK_ENTITY_TO_FUNC(weapon_nukegun);
LINK_ENTITY_TO_FUNC(weapon_nuker);
LINK_ENTITY_TO_FUNC(weapon_null);
LINK_ENTITY_TO_FUNC(weapon_nva_grenade);
LINK_ENTITY_TO_FUNC(weapon_oicw);
LINK_ENTITY_TO_FUNC(weapon_p226);
LINK_ENTITY_TO_FUNC(weapon_p228);
LINK_ENTITY_TO_FUNC(weapon_p90);
LINK_ENTITY_TO_FUNC(weapon_p99);
LINK_ENTITY_TO_FUNC(weapon_paintball);
LINK_ENTITY_TO_FUNC(weapon_paintgrenade);
LINK_ENTITY_TO_FUNC(weapon_paralysis);
LINK_ENTITY_TO_FUNC(weapon_parasite);
LINK_ENTITY_TO_FUNC(weapon_pdw);
LINK_ENTITY_TO_FUNC(weapon_penguin);
LINK_ENTITY_TO_FUNC(weapon_pgp);
LINK_ENTITY_TO_FUNC(weapon_phantom);
LINK_ENTITY_TO_FUNC(weapon_pick);
LINK_ENTITY_TO_FUNC(weapon_pigeon);
LINK_ENTITY_TO_FUNC(weapon_pipebomb);
LINK_ENTITY_TO_FUNC(weapon_pipewrench);
LINK_ENTITY_TO_FUNC(weapon_pistol);
LINK_ENTITY_TO_FUNC(weapon_pkm);
LINK_ENTITY_TO_FUNC(weapon_plasma);
LINK_ENTITY_TO_FUNC(weapon_pmine);
LINK_ENTITY_TO_FUNC(weapon_poolstick);
LINK_ENTITY_TO_FUNC(weapon_powerbeam);
LINK_ENTITY_TO_FUNC(weapon_prifle);
LINK_ENTITY_TO_FUNC(weapon_primalscream);
LINK_ENTITY_TO_FUNC(weapon_proximity);
LINK_ENTITY_TO_FUNC(weapon_psg);
LINK_ENTITY_TO_FUNC(weapon_psg1);
LINK_ENTITY_TO_FUNC(weapon_pt);
LINK_ENTITY_TO_FUNC(weapon_python);
LINK_ENTITY_TO_FUNC(weapon_quakegun);
LINK_ENTITY_TO_FUNC(weapon_radio);
LINK_ENTITY_TO_FUNC(weapon_railgun);
LINK_ENTITY_TO_FUNC(weapon_rcp90);
LINK_ENTITY_TO_FUNC(weapon_reetou);
LINK_ENTITY_TO_FUNC(weapon_regeneration);
LINK_ENTITY_TO_FUNC(weapon_rifle);
LINK_ENTITY_TO_FUNC(weapon_rmine);
LINK_ENTITY_TO_FUNC(weapon_rocketlauncher);
LINK_ENTITY_TO_FUNC(weapon_rocketpistol);
LINK_ENTITY_TO_FUNC(weapon_rollingstonespell);
LINK_ENTITY_TO_FUNC(weapon_rpd);
LINK_ENTITY_TO_FUNC(weapon_rpg);
LINK_ENTITY_TO_FUNC(weapon_rpg7);
LINK_ENTITY_TO_FUNC(weapon_rs202m2);
LINK_ENTITY_TO_FUNC(weapon_rumgun);
LINK_ENTITY_TO_FUNC(weapon_runner);
LINK_ENTITY_TO_FUNC(weapon_sa80);
LINK_ENTITY_TO_FUNC(weapon_saa);
LINK_ENTITY_TO_FUNC(weapon_saber);
LINK_ENTITY_TO_FUNC(weapon_saiga);
LINK_ENTITY_TO_FUNC(weapon_sainte);
LINK_ENTITY_TO_FUNC(weapon_sako);
LINK_ENTITY_TO_FUNC(weapon_satchel);
LINK_ENTITY_TO_FUNC(weapon_satelitelaser);
LINK_ENTITY_TO_FUNC(weapon_sawedoff);
LINK_ENTITY_TO_FUNC(weapon_sawgun);
LINK_ENTITY_TO_FUNC(weapon_sbarrel);
LINK_ENTITY_TO_FUNC(weapon_scatterbeam);
LINK_ENTITY_TO_FUNC(weapon_scattergun);
LINK_ENTITY_TO_FUNC(weapon_scattershot);
LINK_ENTITY_TO_FUNC(weapon_scopedfg42);
LINK_ENTITY_TO_FUNC(weapon_scopedkar);
LINK_ENTITY_TO_FUNC(weapon_scorpion);
LINK_ENTITY_TO_FUNC(weapon_scout);
LINK_ENTITY_TO_FUNC(weapon_sensu);
LINK_ENTITY_TO_FUNC(weapon_sg550);
LINK_ENTITY_TO_FUNC(weapon_sg552);
LINK_ENTITY_TO_FUNC(weapon_sgenerator);
LINK_ENTITY_TO_FUNC(weapon_shield);
LINK_ENTITY_TO_FUNC(weapon_shieldattack);
LINK_ENTITY_TO_FUNC(weapon_shieldgun);
LINK_ENTITY_TO_FUNC(weapon_shieldspell);
LINK_ENTITY_TO_FUNC(weapon_shocker);
LINK_ENTITY_TO_FUNC(weapon_shocker2k);
LINK_ENTITY_TO_FUNC(weapon_shockrifle);
LINK_ENTITY_TO_FUNC(weapon_shockroach);
LINK_ENTITY_TO_FUNC(weapon_shotgun);
LINK_ENTITY_TO_FUNC(weapon_shrinker);
LINK_ENTITY_TO_FUNC(weapon_sig245);
LINK_ENTITY_TO_FUNC(weapon_sigpro);
LINK_ENTITY_TO_FUNC(weapon_silverpp7);
LINK_ENTITY_TO_FUNC(weapon_sixshooter);
LINK_ENTITY_TO_FUNC(weapon_skeletonspell);
LINK_ENTITY_TO_FUNC(weapon_sks);
LINK_ENTITY_TO_FUNC(weapon_skullspell);
LINK_ENTITY_TO_FUNC(weapon_sl68);
LINK_ENTITY_TO_FUNC(weapon_slappers);
LINK_ENTITY_TO_FUNC(weapon_sledge);
LINK_ENTITY_TO_FUNC(weapon_smkgrenade);
LINK_ENTITY_TO_FUNC(weapon_smokegrenade);
LINK_ENTITY_TO_FUNC(weapon_snUZI);
LINK_ENTITY_TO_FUNC(weapon_snark);
LINK_ENTITY_TO_FUNC(weapon_snipe);
LINK_ENTITY_TO_FUNC(weapon_sniper);
LINK_ENTITY_TO_FUNC(weapon_sniper3);
LINK_ENTITY_TO_FUNC(weapon_sniperrifle);
LINK_ENTITY_TO_FUNC(weapon_snowball);
LINK_ENTITY_TO_FUNC(weapon_solarflare);
LINK_ENTITY_TO_FUNC(weapon_soniccannon);
LINK_ENTITY_TO_FUNC(weapon_sonicgrenade);
LINK_ENTITY_TO_FUNC(weapon_spade);
LINK_ENTITY_TO_FUNC(weapon_spas);
LINK_ENTITY_TO_FUNC(weapon_spas12);
LINK_ENTITY_TO_FUNC(weapon_spear);
LINK_ENTITY_TO_FUNC(weapon_specialbeamcannon);
LINK_ENTITY_TO_FUNC(weapon_spectre);
LINK_ENTITY_TO_FUNC(weapon_spiderbomb);
LINK_ENTITY_TO_FUNC(weapon_spikegun);
LINK_ENTITY_TO_FUNC(weapon_spiritbomb);
LINK_ENTITY_TO_FUNC(weapon_spiritwizspell);
LINK_ENTITY_TO_FUNC(weapon_spit);
LINK_ENTITY_TO_FUNC(weapon_spitcarbine);
LINK_ENTITY_TO_FUNC(weapon_spitpistol);
LINK_ENTITY_TO_FUNC(weapon_spore);
LINK_ENTITY_TO_FUNC(weapon_sporelauncher);
LINK_ENTITY_TO_FUNC(weapon_spotboltspell);
LINK_ENTITY_TO_FUNC(weapon_spring);
LINK_ENTITY_TO_FUNC(weapon_spy);
LINK_ENTITY_TO_FUNC(weapon_spycam);
LINK_ENTITY_TO_FUNC(weapon_spyder);
LINK_ENTITY_TO_FUNC(weapon_srifle);
LINK_ENTITY_TO_FUNC(weapon_ssg3000);
LINK_ENTITY_TO_FUNC(weapon_sshotgun);
LINK_ENTITY_TO_FUNC(weapon_staff);
LINK_ENTITY_TO_FUNC(weapon_sterling);
LINK_ENTITY_TO_FUNC(weapon_stg24);
LINK_ENTITY_TO_FUNC(weapon_stickgrenade);
LINK_ENTITY_TO_FUNC(weapon_stickgrenade_ex);
LINK_ENTITY_TO_FUNC(weapon_stinger);
LINK_ENTITY_TO_FUNC(weapon_stingray2);
LINK_ENTITY_TO_FUNC(weapon_stoner);
LINK_ENTITY_TO_FUNC(weapon_stonerscope);
LINK_ENTITY_TO_FUNC(weapon_stonersilencer);
LINK_ENTITY_TO_FUNC(weapon_stubgun);
LINK_ENTITY_TO_FUNC(weapon_stumpgun);
LINK_ENTITY_TO_FUNC(weapon_stupid);
LINK_ENTITY_TO_FUNC(weapon_super_mouton);
LINK_ENTITY_TO_FUNC(weapon_supernailgun);
LINK_ENTITY_TO_FUNC(weapon_supershotgun);
LINK_ENTITY_TO_FUNC(weapon_svd);
LINK_ENTITY_TO_FUNC(weapon_swarm_gargflame);
LINK_ENTITY_TO_FUNC(weapon_swipe);
LINK_ENTITY_TO_FUNC(weapon_tdagger);
LINK_ENTITY_TO_FUNC(weapon_tec9);
LINK_ENTITY_TO_FUNC(weapon_teleporteur);
LINK_ENTITY_TO_FUNC(weapon_thompson);
LINK_ENTITY_TO_FUNC(weapon_thornblastspell);
LINK_ENTITY_TO_FUNC(weapon_throwing_knife);
LINK_ENTITY_TO_FUNC(weapon_tknife);
LINK_ENTITY_TO_FUNC(weapon_tmine);
LINK_ENTITY_TO_FUNC(weapon_tmp);
LINK_ENTITY_TO_FUNC(weapon_tnt);
LINK_ENTITY_TO_FUNC(weapon_toad);
LINK_ENTITY_TO_FUNC(weapon_tokarev);
LINK_ENTITY_TO_FUNC(weapon_tomahawk);
LINK_ENTITY_TO_FUNC(weapon_tommygun);
LINK_ENTITY_TO_FUNC(weapon_tornadospell);
LINK_ENTITY_TO_FUNC(weapon_transistor);
LINK_ENTITY_TO_FUNC(weapon_translocator);
LINK_ENTITY_TO_FUNC(weapon_trident);
LINK_ENTITY_TO_FUNC(weapon_triplaser);
LINK_ENTITY_TO_FUNC(weapon_tripmine);
LINK_ENTITY_TO_FUNC(weapon_trooper);
LINK_ENTITY_TO_FUNC(weapon_tsgun);
LINK_ENTITY_TO_FUNC(weapon_tucan);
LINK_ENTITY_TO_FUNC(weapon_umbra);
LINK_ENTITY_TO_FUNC(weapon_ump45);
LINK_ENTITY_TO_FUNC(weapon_updraftspell);
LINK_ENTITY_TO_FUNC(weapon_us_grenade);
LINK_ENTITY_TO_FUNC(weapon_usas12);
LINK_ENTITY_TO_FUNC(weapon_usp);
LINK_ENTITY_TO_FUNC(weapon_uzi);
LINK_ENTITY_TO_FUNC(weapon_uziakimbo);
LINK_ENTITY_TO_FUNC(weapon_vepr);
LINK_ENTITY_TO_FUNC(weapon_vomit);
LINK_ENTITY_TO_FUNC(weapon_vsclaw);
LINK_ENTITY_TO_FUNC(weapon_vscolt);
LINK_ENTITY_TO_FUNC(weapon_vscrossbow);
LINK_ENTITY_TO_FUNC(weapon_vsdbshotgun);
LINK_ENTITY_TO_FUNC(weapon_vsmp5);
LINK_ENTITY_TO_FUNC(weapon_vsshotgun);
LINK_ENTITY_TO_FUNC(weapon_vsstake);
LINK_ENTITY_TO_FUNC(weapon_vulcan);
LINK_ENTITY_TO_FUNC(weapon_wa2000);
LINK_ENTITY_TO_FUNC(weapon_webspinner);
LINK_ENTITY_TO_FUNC(weapon_welder);
LINK_ENTITY_TO_FUNC(weapon_whirlwindspell);
LINK_ENTITY_TO_FUNC(weapon_whiskey);
LINK_ENTITY_TO_FUNC(weapon_whiterayspell);
LINK_ENTITY_TO_FUNC(weapon_winchester);
LINK_ENTITY_TO_FUNC(weapon_wombatspell);
LINK_ENTITY_TO_FUNC(weapon_wyvernspell);
LINK_ENTITY_TO_FUNC(weapon_xm1014);
LINK_ENTITY_TO_FUNC(weapon_xm4);
LINK_ENTITY_TO_FUNC(weapon_zat);
LINK_ENTITY_TO_FUNC(weapon_zatarc);
LINK_ENTITY_TO_FUNC(weapon_zmg);
LINK_ENTITY_TO_FUNC(weaponbox);
LINK_ENTITY_TO_FUNC(weather_genie);
LINK_ENTITY_TO_FUNC(weather_litnode);
LINK_ENTITY_TO_FUNC(webgunprojectile);
LINK_ENTITY_TO_FUNC(wheel);
LINK_ENTITY_TO_FUNC(whiskey_whisk);
LINK_ENTITY_TO_FUNC(world_items);
LINK_ENTITY_TO_FUNC(worldspawn);
LINK_ENTITY_TO_FUNC(ww_monstermaker);
LINK_ENTITY_TO_FUNC(xen_hair);
LINK_ENTITY_TO_FUNC(xen_hull);
LINK_ENTITY_TO_FUNC(xen_plantlight);
LINK_ENTITY_TO_FUNC(xen_spore_large);
LINK_ENTITY_TO_FUNC(xen_spore_medium);
LINK_ENTITY_TO_FUNC(xen_spore_small);
LINK_ENTITY_TO_FUNC(xen_tree);
LINK_ENTITY_TO_FUNC(xen_ttrigger);
LINK_ENTITY_TO_FUNC(zone);
LINK_ENTITY_TO_FUNC(zone_nodamage);

//#endif /* not MR_META */
