//
// FoXBot - AI Bot for Halflife's Team Fortress Classic
//
// (http://foxbot.net)
//
// dll.cpp
//
// Copyright (C) 2003 - Tom "Redfox" Simpson
//
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
//
// See the GNU General Public License for more details at:
// http://www.gnu.org/copyleft/gpl.html
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

#include "extdll.h"
#include <enginecallback.h>
//#include "util.h"
//#include "cbase.h"
#include <entity_state.h>

//#include <osdep.h>

#ifndef __linux__
#  include <tchar.h>
#endif

#include "bot.h"
#include "bot_func.h"
#include "bot_weapons.h"
#include "waypoint.h"

//meta mod includes
#include <dllapi.h>
#include <meta_api.h>

//new stuff for botcam
#include <cbase.h>
#include "player.h"
#include "botcam.h"

//void UTIL_CSavePent(CBaseEntity *pent);
void DisplayBotInfo();

#define VER_MAJOR 0
#define VER_MINOR 701
#define VER_BUILD 0

#define MENU_NONE  0
#define MENU_1     1
#define MENU_2     2
#define MENU_3     3
#define MENU_4     4
#define MENU_5     5
#define MENU_6     6
#define MENU_7     7

cvar_t foxbot = {"foxbot","0.701", FCVAR_SERVER | FCVAR_UNLOGGED };
cvar_t enable_foxbot = {"enable_foxbot","1", FCVAR_SERVER | FCVAR_UNLOGGED };

extern GETENTITYAPI other_GetEntityAPI;
extern GETNEWDLLFUNCTIONS other_GetNewDLLFunctions;
extern enginefuncs_t g_engfuncs;
extern int debug_engine;
extern globalvars_t  *gpGlobals;
extern char *g_argv;
extern bool g_waypoint_on;
extern bool g_waypoint_cache;
extern bool g_auto_waypoint;
extern bool g_path_waypoint;
extern bool g_find_waypoint;
extern long g_find_wp;
extern bool g_path_connect;

extern bool g_path_oneway;
extern bool g_path_twoway;
extern int wpt1;
extern int wpt2;

extern bool bot_can_use_teleporter;
extern bool bot_can_build_teleporter;

extern int pipeCheckFrame;
extern bool g_bot_debug;
extern bool defensive_chatter;
extern bool offensive_chatter;
extern bool frag_commander;
extern int num_waypoints;  // number of waypoints currently in use
//waypoint author
extern char waypoint_author[256];
extern WAYPOINT waypoints[MAX_WAYPOINTS];
extern float wp_display_time[MAX_WAYPOINTS];
extern bot_t bots[32];
extern int b_team[32];
extern int b_class[32];
extern bool b_observer_mode;
extern bool b_botdontshoot;
extern bool b_botchat;

extern int  bot_spy_random_check;

extern bot_weapon_t weapon_defs[MAX_WEAPONS];
char welcome_msg[255] = "--FoxBot--\n\nhttp://www.foxbot.net\nhttp://forums.foxbot.net For help\n";

int RoleStatus[] = { 50,50,50,50 };

extern bool g_area_def;
extern AREA areas[MAX_WAYPOINTS];
extern int num_areas;

static FILE *fp;

DLL_FUNCTIONS other_gFunctionTable;
DLL_GLOBAL const Vector g_vecZero = Vector(0,0,0);

int mod_id = TFC_DLL;
int m_spriteTexture = 0;
int default_bot_skill = 2;
int isFakeClientCommand = 0;
int fake_arg_count;
float bot_check_time = 30.0;
edict_t *first_player = NULL;
int min_bots = -1;
int max_bots = -1;
int num_bots = 0;
int prev_num_bots = 0;
bool g_GameRules = FALSE;
edict_t *clients[32];
float welcome_time = 0.0;
int welcome_index = -1;
bool welcome_sent = FALSE;
int g_menu_waypoint;
int g_menu_state = 0;

float is_team_play = 0.0;
char team_names[MAX_TEAMS][MAX_TEAMNAME_LENGTH];
int num_teams = 0;
bool checked_teamplay = FALSE;
edict_t *pent_info_tfdetect = NULL;
edict_t *pent_info_ctfdetect = NULL;
edict_t *pent_info_frontline = NULL;
edict_t *pent_item_tfgoal = NULL;
int max_team_players[4];
int team_class_limits[4];
int team_allies[4];  // bit mapped allies BLUE, RED, YELLOW, and GREEN
int max_teams = 0;
FLAG_S flags[MAX_FLAGS];
int num_flags = 0;

FILE *bot_cfg_fp = NULL;
//changed..cus we set it else where
bool need_to_open_cfg = FALSE;
bool need_to_open_cfg2 = FALSE;
int cfg_file=1;

//my display stuff...
bool display_bot_vars = TRUE;
float display_start_time;
bool script_loaded=FALSE;
bool script_parsed=FALSE;

short scanpos;
bool player_vis[8];

float bot_cfg_pause_time = 0.0;
float respawn_time = 0.0;
bool spawn_time_reset = FALSE;
bool botcamEnabled = false;

int flf_bug_fix;
int flf_bug_check;


char bot_whine[MAX_BOT_WHINE][81];
int whine_count;
int recent_bot_whine[5];

//my chat stuff
char bot_greet[MAX_BOT_WHINE][81];
int greet_count;
char bot_kill_hi[MAX_BOT_WHINE][81];
int kill_hi_count;
int recent_bot_kill_hi[5];
char bot_kill_lo[MAX_BOT_WHINE][81];
int kill_lo_count;
int recent_bot_kill_lo[5];
char bot_die_hi[MAX_BOT_WHINE][81];
int die_hi_count;
int recent_bot_die_hi[5];
char bot_die_lo[MAX_BOT_WHINE][81];
int die_lo_count;
int recent_bot_die_lo[5];

cvar_t sv_bot = {"bot",""};

// Main menu
char *show_menu_1 = {"Waypoint Tags\n\n1. Team Specific\n2. Locations\n3. Items\n4. Actions p1\n5. Actions p2\n6. Control Points\n7. Exit"};
char *show_menu_2 = {"Team Specific Tags\n\n1. Team 1\n2. Team 2\n3. Team 3\n4. Team 4\n5. CANCEL\n6. EXIT"};
char *show_menu_3 = {"Location Tags\n\n1. Flag Location\n2. Flag Goal Location"};
char *show_menu_4 = {"Item Tags\n\n1. Health\n2. Armor\n3. Ammo"};
char *show_menu_5 = {"Action Tags p1\n\n1. Defend (Soldier/HW/Demo)\n2. Defend(Demo-man Only)\n3. Sniper\n4. Build Sentry\n5. Rotate SG 180\n6. Build TP Entrance\n7. Build TP Exit"};
char *show_menu_6 = {"Action Tags p2\n\n1. RJ/CJ\n2. Jump\n3. Detpack\n4. Wait For Lift\n5. Walk"};
char *show_menu_7 = {"Waypoint Tags\n\n1. Point1\n2. Point2\n3. Point3\n4. Point4\n5. Point5\n6. Point6\n7. Point7\n8. Point8\n9 CANCEL"};

//meta mod shiznit
extern bool mr_meta;
//my shit

extern int drop_flag[32][4];
extern edict_t *drop_flage[32][4];

extern bool bot_xmas;

char prevmapname[32];

extern bool attack[4]; //teams attack
extern bool defend[4]; //teams defend

extern bool blue_av[8];
extern bool red_av[8];
extern bool green_av[8];
extern bool yellow_av[8];

/*struct msg_com_struct
{
char ifs[32];
int blue_av[8];
int red_av[8];
int green_av[8];
int yellow_av[8];
struct msg_com_struct *next;
};*/

char arg[255];
int teams[4];
bool is_team[4];

bool bot_team_balance = false;
bool bot_bot_balance = false;

float last_frame_time;
float last_frame_time_prev;

extern char sz_error_check[255];


void UTIL_HudMessage(CBaseEntity *pEntity, const hudtextparms_t &textparms, 
		const char *pMessage)
{
	if ( !pEntity )
		return;

	MESSAGE_BEGIN( MSG_ONE, SVC_TEMPENTITY, NULL, ENT(pEntity->pev) );
		WRITE_BYTE( TE_TEXTMESSAGE );
		WRITE_BYTE( textparms.channel & 0xFF );

		WRITE_SHORT( FixedSigned16( textparms.x, 1<<13 ) );
		WRITE_SHORT( FixedSigned16( textparms.y, 1<<13 ) );
		WRITE_BYTE( textparms.effect );

		WRITE_BYTE( textparms.r1 );
		WRITE_BYTE( textparms.g1 );
		WRITE_BYTE( textparms.b1 );
		WRITE_BYTE( textparms.a1 );

		WRITE_BYTE( textparms.r2 );
		WRITE_BYTE( textparms.g2 );
		WRITE_BYTE( textparms.b2 );
		WRITE_BYTE( textparms.a2 );

		WRITE_SHORT( FixedUnsigned16( textparms.fadeinTime, 1<<8 ) );
		WRITE_SHORT( FixedUnsigned16( textparms.fadeoutTime, 1<<8 ) );
		WRITE_SHORT( FixedUnsigned16( textparms.holdTime, 1<<8 ) );

		if ( textparms.effect == 2 )
			WRITE_SHORT( FixedUnsigned16( textparms.fxTime, 1<<8 ) );
		
		if ( strlen( pMessage ) < 512 )
		{
			WRITE_STRING( pMessage );
		}
		else
		{
			char tmp[512];
			strncpy( tmp, pMessage, 511 );
			tmp[511] = 0;
			WRITE_STRING( tmp );
		}
	MESSAGE_END();
}

void KewlHUDNotify(edict_t *pEntity, const char *msg_name)
{
	MESSAGE_BEGIN(MSG_ONE, SVC_TEMPENTITY, NULL, pEntity);
	WRITE_BYTE( TE_TEXTMESSAGE);
	WRITE_BYTE( 3 & 0xFF );
	WRITE_SHORT( FixedSigned16( 1, -1<<13 ) );
	WRITE_SHORT( FixedSigned16( 1, -1<<13 ) );
	WRITE_BYTE(2); //effect

	WRITE_BYTE(205);
	WRITE_BYTE(205);
	WRITE_BYTE(10);
	WRITE_BYTE(255);

	WRITE_BYTE(0);
	WRITE_BYTE(0);
	WRITE_BYTE(255);
	WRITE_BYTE(255);
	WRITE_SHORT( FixedUnsigned16( 0.03, 1<<8 ) );
	WRITE_SHORT( FixedUnsigned16( 1, 1<<8 ) );
	WRITE_SHORT( FixedUnsigned16( 6, 1<<8 ) );
	WRITE_SHORT( FixedUnsigned16( 4, 1<<8 ) );
	WRITE_STRING(msg_name);
	MESSAGE_END();
}


bool BotBalanceTeams(int a,int b)
{
	if(teams[a-1]-1 > teams[b-1] && (max_team_players[b-1]>teams[b-1] || max_team_players[b-1]==0) 
		&& is_team[b-1]) 
	{
		for (int i=31; i >= 0; i--)
		{
			if (bots[i].is_used && bots[i].pEdict->v.team==a)  // is this slot used?
			{
				char msg[255];
				sprintf(msg,"%d",b);
				FakeClientCommand(bots[i].pEdict, "jointeam", msg, NULL);
				bots[i].bot_team=b;
				bots[i].not_started=1;
				bots[i].create_time = gpGlobals->time+2;
				bots[i].sg=false;
				return true;
			}
		}
	}
	return false;
}

bool BBotBalanceTeams(int a,int b)
{
	//now just setup teams to include bots in them :D
	int bteams[4];
	bteams[0]=0;
	bteams[1]=0;
	bteams[2]=0;
	bteams[3]=0;
	for (int i = 0; i < 32; i++) //<32
	{
		if(bots[i].is_used)
		{
			char *infobuffer;
			char cl_name[128];
			cl_name[0]=NULL;
			infobuffer = (*g_engfuncs.pfnGetInfoKeyBuffer)(bots[i].pEdict);
			strcpy(cl_name,g_engfuncs.pfnInfoKeyValue(infobuffer, "name"));
			if(cl_name[0]!=NULL)
			{
				int team=(bots[i].pEdict->v.team)-1;
				if(team>=0 && team<4) 
				{
					bteams[team]=bteams[team]+1;
				}
			}
		}
	}
	if(bteams[a-1]-1 > bteams[b-1] && (max_team_players[b-1]>teams[b-1] || max_team_players[b-1]==0) 
		&& is_team[b-1]) 
	{
		for (int i=31; i >= 0; i--)
		{
			if (bots[i].is_used && bots[i].pEdict->v.team==a)  // is this slot used?
			{
				char msg[255];
				sprintf(msg,"%d",b);
				FakeClientCommand(bots[i].pEdict, "jointeam", msg, NULL);
				bots[i].bot_team=b;
				bots[i].not_started=1;
				bots[i].create_time = gpGlobals->time+2;
				bots[i].sg=false;
				return true;
			}
		}
	}
	return false;
}

bool HBalanceTeams(int a,int b)
{
	if(teams[a-1]-1 > teams[b-1] && (max_team_players[b-1]>teams[b-1] || max_team_players[b-1]==0) 
		&& is_team[b-1]) 
	{
		for (int i=1; i <=32; i++)
		{
			bool not_bot=true;
			for (int j=1; j <=32; j++)
			{
				if(bots[j].is_used && bots[j].pEdict==INDEXENT(i))
					not_bot=false;
			}
			if(not_bot && INDEXENT(i)!=NULL)
			{
				if (INDEXENT(i)->v.team==a && INDEXENT(i)->v.netname!=NULL)
				{
					CLIENT_COMMAND(INDEXENT(i), UTIL_VarArgs("jointeam %d\n",b));
					return true;
				}
			}

		}
	}
	return false;
}

extern struct msg_com_struct msg_com[MSG_MAX];
extern char msg_msg[64][MSG_MAX]; 

void BotNameInit(void);
void UpdateClientData(const struct edict_s *ent, int sendweapons, struct clientdata_s *cd);
void ProcessBotCfgFile(void);

void GameDLLInit( void )
{
	char filename[256];
	char buffer[256];
	int i, length;
	FILE *bfp;
	char *ptr;

	CVAR_REGISTER (&foxbot);
	CVAR_REGISTER (&sv_bot);
	CVAR_REGISTER (&enable_foxbot);

	for (i=0; i<32; i++)
		clients[i] = NULL;

	whine_count = 0;

	// initialize the bots array of structures...
	memset(bots, 0, sizeof(bots));

	for (i=0; i < 5; i++)
		recent_bot_whine[i] = -1;

	BotNameInit();
	
	//my bot chat
	UTIL_BuildFileName(filename, "foxbot_chat.txt", NULL);
	bfp = fopen(filename, "r");

	if(bfp==NULL)
	{
		UTIL_BuildFileNameOld(filename, "foxbot_chat.txt", NULL);
		bfp = fopen(filename, "r");
	}

	int inp = -1;

	if (bfp != NULL)
	{
		while ((fgets(buffer, 80, bfp) != NULL))
		{
			length = strlen(buffer);

			if (buffer[length-1] == '\n')
			{
				buffer[length-1] = 0;  // remove '\n'
				length--;
			}

			if ((ptr = strstr(buffer, "%n")) != NULL)
			{
				*(ptr+1) = 's';  // change %n to %s
			}

			if (buffer[0]=='-')
			{
				inp++;
				continue;
			}

			if ((greet_count < MAX_BOT_WHINE) && length > 0 && inp==0)
			{
				strcpy(bot_greet[greet_count], buffer);
				greet_count++;
			}
			if ((kill_hi_count < MAX_BOT_WHINE) && length > 0 && inp==1)
			{
				strcpy(bot_kill_hi[kill_hi_count], buffer);
				kill_hi_count++;
			}
			if ((kill_lo_count < MAX_BOT_WHINE) && length > 0 && inp==2)
			{
				strcpy(bot_kill_lo[kill_lo_count], buffer);
				kill_lo_count++;
			}
			if ((die_hi_count < MAX_BOT_WHINE) && length > 0 && inp==3)
			{
				strcpy(bot_die_hi[die_hi_count], buffer);
				die_hi_count++;
			}
			if ((die_lo_count < MAX_BOT_WHINE) && length > 0 && inp==4)
			{
				strcpy(bot_die_lo[die_lo_count], buffer);
				die_lo_count++;
			}
		}
		fclose(bfp);
	}

	if(!mr_meta)
		(*other_gFunctionTable.pfnGameInit)();
	else
		SET_META_RESULT(MRES_HANDLED);
}

int DispatchSpawn( edict_t *pent )
{
	int index;

	if (gpGlobals->deathmatch)
	{
		char *pClassname = (char *)STRING(pent->v.classname);

		if (debug_engine)
		{
			fp=fopen("bot.txt","a");
			fprintf(fp, "DispatchSpawn: %x %s\n",pent,pClassname);
			if (pent->v.model != 0)
				fprintf(fp, " model=%s\n",STRING(pent->v.model));
			if (pent->v.target != 0)
				fprintf(fp, " t=%s\n",STRING(pent->v.target));
			if (pent->v.targetname != 0)
				fprintf(fp, " tn=%s\n",STRING(pent->v.targetname));
			fclose(fp);
		}

		if (strcmp(pClassname, "worldspawn") == 0)
		{
			// do level initialization stuff here...

			WaypointInit();
			WaypointLoad(NULL);
			AreaDefLoad(NULL);
			//setup junctions, for multi path
			JunctionCalculate();

			//my clear var for lev reload..
			strcpy(prevmapname,"null");

			pent_info_tfdetect = NULL;
			pent_info_ctfdetect = NULL;
			pent_info_frontline = NULL;
			pent_item_tfgoal = NULL;

			for (index=0; index < 4; index++)
			{
				max_team_players[index] = 0;  // no player limit
				team_class_limits[index] = 0;  // no class limits
				team_allies[index] = 0;
			}

			max_teams = 0;
			is_team[0]=false;
			is_team[1]=false;
			is_team[2]=false;
			is_team[3]=false;
			num_flags = 0;

			g_waypoint_cache=false;
			if(g_waypoint_on || g_area_def)
			{
				//precache stuff here
				PRECACHE_MODEL("sprites/dot.spr");
				PRECACHE_MODEL("sprites/arrow1.spr");
				PRECACHE_MODEL("sprites/gargeye1.spr");
				PRECACHE_MODEL("sprites/cnt1.spr");
				PRECACHE_MODEL("models/w_medkit.mdl");
				PRECACHE_MODEL("models/r_armor.mdl");
				PRECACHE_MODEL("models/backpack.mdl");
				PRECACHE_MODEL("models/p_sniper.mdl");
				PRECACHE_MODEL("models/flag.mdl");
				PRECACHE_MODEL("models/bigrat.mdl");
				PRECACHE_MODEL("models/sentry1.mdl");
				PRECACHE_MODEL("models/w_longjump.mdl");
				PRECACHE_MODEL("models/detpack.mdl");
				PRECACHE_MODEL("models/teleporter.mdl");
				PRECACHE_MODEL("models/mechgibs.mdl");
				PRECACHE_SOUND("weapons/xbow_hit1.wav");      // waypoint add
				PRECACHE_SOUND("weapons/mine_activate.wav");  // waypoint delete
				PRECACHE_SOUND("common/wpn_hudoff.wav");      // path add/delete start
				PRECACHE_SOUND("common/wpn_hudon.wav");       // path add/delete done
				PRECACHE_SOUND("common/wpn_moveselect.wav");  // path add/delete cancel
				PRECACHE_SOUND("common/wpn_denyselect.wav");  // path add/delete error

				g_waypoint_cache=true;
			}

			PRECACHE_MODEL("models/presentlg.mdl");
			PRECACHE_MODEL("models/presentsm.mdl");

			PRECACHE_SOUND("barney/c1a4_ba_octo4.wav");
			PRECACHE_SOUND("misc/b2.wav");
			PRECACHE_SOUND("misc/party2.wav");
			PRECACHE_SOUND("misc/party1.wav");

			m_spriteTexture = PRECACHE_MODEL( "sprites/lgtning.spr");

			g_GameRules = TRUE;

			is_team_play = 0.0;
			memset(team_names, 0, sizeof(team_names));
			num_teams = 0;
			checked_teamplay = FALSE;

			respawn_time = 0.0;
			spawn_time_reset = FALSE;

			prev_num_bots = num_bots;
			num_bots = 0;

			flf_bug_fix = 0;
			flf_bug_check = 0;

			bot_check_time = gpGlobals->time + 30.0;
		}
	}

	if(!mr_meta)
		return (*other_gFunctionTable.pfnSpawn)(pent);
	else
	{
		RETURN_META_VALUE(MRES_HANDLED, 0);
	}
}

void DispatchThink( edict_t *pent )
{
	if(FStrEq(STRING(pent->v.classname), "entity_botcam"))
	{
		TraceResult tr;
		int off_f = 16;
		UTIL_MakeVectors(pent->v.euser1->v.v_angle);
		if(pent->v.euser1!=NULL && !FNullEnt(pent->v.euser1) &&
			pent->v.owner!=NULL && !FNullEnt(pent->v.owner))
		{
			bot_t *pBot=UTIL_GetBotPointer(pent->v.euser1);
			if(pBot->backwards) off_f=80;
			UTIL_TraceLine(pent->v.euser1->v.origin + pent->v.euser1->v.view_ofs + gpGlobals->v_forward * off_f,
				pent->v.euser1->v.origin + pent->v.euser1->v.view_ofs + gpGlobals->v_forward * 4000,
				ignore_monsters, pent->v.euser1, &tr );

			Vector st;
			Vector end;

			MESSAGE_BEGIN(MSG_ONE, SVC_TEMPENTITY, NULL, pent->v.owner);
			WRITE_BYTE( TE_TEXTMESSAGE);
			WRITE_BYTE( 2 & 0xFF );
			WRITE_SHORT( FixedSigned16( 1, -1<<13 ) );
			WRITE_SHORT( FixedSigned16( 1, 0<<13 ) );
			WRITE_BYTE(0); //effect

			WRITE_BYTE(255);
			WRITE_BYTE(10);
			WRITE_BYTE(10);
			WRITE_BYTE(255);

			WRITE_BYTE(255);
			WRITE_BYTE(0);
			WRITE_BYTE(0);
			WRITE_BYTE(128);
			WRITE_SHORT( FixedUnsigned16( 1, 1<<8 ) );
			WRITE_SHORT( FixedUnsigned16( 3, 1<<8 ) );
			WRITE_SHORT( FixedUnsigned16( 1, 1<<8 ) );
			// Try putting together a string for more information in botcam
			char msg[255];
			char myClass[80];
			switch (pBot->pEdict->v.playerclass)
			{
				case TFC_CLASS_CIVILIAN:
					strcpy(myClass,"Civilian");
					break;
				case TFC_CLASS_SCOUT:
					strcpy(myClass,"Scout");
					break;
				case TFC_CLASS_SOLDIER:
					strcpy(myClass,"Soldier");
					break;
				case TFC_CLASS_DEMOMAN:
					strcpy(myClass,"Demo-man");
					break;
				case TFC_CLASS_MEDIC:
					strcpy(myClass,"Medic");
					break;
				case TFC_CLASS_HWGUY:
					strcpy(myClass,"HW-Guy");
					break;
				case TFC_CLASS_PYRO:
					strcpy(myClass,"Pyro");
					break;
				case TFC_CLASS_SPY:
					strcpy(myClass,"Spy");
					break;
				case TFC_CLASS_ENGINEER:
					strcpy(myClass,"Engineer");
					break;
			}
			if (pBot->mission == pBot->Attacker)
			{
				sprintf(msg, "BotCam: Name: %s Class: %s Role: Attacker Health: %d Armor: %d", pBot->name, myClass, BotHealthValue(pBot->pEdict), BotArmorValue(pBot->pEdict));
				WRITE_STRING(msg);
                //WRITE_STRING("BotCam!");
			}
			else if (pBot->mission == pBot->Defender)
			{
				sprintf(msg, "BotCam: Name: %s Class: %s  Role: Defender (%d) Health: %d Armor: %d", pBot->name, myClass, pBot->defendPoint, BotHealthValue(pBot->pEdict), BotArmorValue(pBot->pEdict));
				WRITE_STRING(msg);
				//WRITE_STRING("BotCam!");
			} else
			{
				sprintf(msg, "BotCam: Name: %s Class: %s Role: None Health: %d Armor: %d", pBot->name, myClass, BotHealthValue(pBot->pEdict), BotArmorValue(pBot->pEdict));
				WRITE_STRING(msg);
			}
			MESSAGE_END();

			if(pBot->pBotEnemy!=NULL)
			{
				double pi = 3.1415926535897932384626433832795;
				float zz;
				zz=pBot->pBotEnemy->v.maxs.z;
				zz=(zz/4)/2;
				float xo,xx,yy;
				xx=pBot->pBotEnemy->v.maxs.x;
				xx=(xx/2);
				if(scanpos>1)
					zz=zz*2;
				if(scanpos>3)
					zz=zz*2;
				if(scanpos>5)
					zz=zz*2;
				if(scanpos==0 ||
					scanpos==2 ||
					scanpos==4 ||
					scanpos==6)
					xx=-xx;
				xo=xx;
				Vector vang = pBot->pBotEnemy->v.origin - pBot->pEdict->v.origin;
				float distance = vang.Length();
				vang=UTIL_VecToAngles(vang);
				vang.y=vang.y+45;
				if(vang.y<0) vang.y=vang.y+360;
				vang.y=vang.y*pi;
				vang.y=vang.y/180;
				xx=xo*cos(vang.y);
				yy=xo*sin(vang.y);

				tr.pHit=NULL;
				UTIL_TraceLine(pent->v.euser1->v.origin + pent->v.euser1->v.view_ofs,
					pBot->pBotEnemy->v.origin+ Vector(xx,yy,zz),
					dont_ignore_monsters,dont_ignore_glass, pent->v.euser1, &tr );

				if(tr.pHit==pBot->pBotEnemy || tr.flFraction==1.0)
					player_vis[scanpos]=true;
				else
					player_vis[scanpos]=false;
				scanpos++;
				if(scanpos>7) //7
					scanpos=0;
				float p_vis=0;
				for(int i=0;i<8;i++)
				{
					if(player_vis[i])
						p_vis=p_vis+12.5;
				}

				char msg[511];
				int amb=0;
				int vidsize=2;
				float sz=((pBot->pBotEnemy->v.maxs.z)*(vidsize/distance))*100;
				int d=GETENTITYILLUM(pBot->pBotEnemy);
				if(amb==0)
				{
					edict_t *pent=NULL;
					edict_t *pPoint=NULL;
					while ((pent = FIND_ENTITY_IN_SPHERE( pent, pBot->pBotEnemy->v.origin, 50 )) != NULL &&
						(!FNullEnt(pent)) && amb==0)
					{
						if(strcmp(STRING(pent->v.classname),"entity_botlightvalue")==0)
						{
							pPoint=pent;
						}

					}
					if(pPoint==NULL)
					{
						pPoint = CREATE_NAMED_ENTITY(MAKE_STRING("info_target"));
						DispatchSpawn(pPoint);
						pPoint->v.origin = pBot->pBotEnemy->v.origin;
						pPoint->v.takedamage = DAMAGE_NO;
						pPoint->v.solid = SOLID_NOT;
						pPoint->v.owner = pBot->pBotEnemy;
						pPoint->v.movetype = MOVETYPE_FLY; //noclip
						pPoint->v.classname = MAKE_STRING("entity_botlightvalue");
						pPoint->v.nextthink = gpGlobals->time;
						pPoint->v.rendermode = kRenderNormal;
						pPoint->v.renderfx = kRenderFxNone;
						pPoint->v.renderamt = 0;
						SET_MODEL(pPoint, "models/mechgibs.mdl");
						amb=GETENTITYILLUM(pPoint);
					}
					else
					{
						amb=GETENTITYILLUM(pPoint);
						REMOVE_ENTITY(pPoint);
					}

				}
				double dgrad;
				Vector v = pBot->pEdict->v.v_angle;
				v.y=v.y+180;
				if (v.y > 180)
					v.y -= 360;
				if (v.y < -180)
					v.y += 360;
				dgrad=(double)(v.y);
				dgrad=dgrad+180;
				if (dgrad > 180)
					dgrad -= 360;
				if (dgrad < -180)
					dgrad += 360;
				dgrad=dgrad*pi;
				dgrad=dgrad/180;
				Vector vel;
				vel=pBot->pBotEnemy->v.velocity;
				vel.x=vel.x*sin(dgrad);
				vel.y=vel.y*cos(dgrad);
				dgrad=(double)(v.x);
				dgrad=dgrad+180;
				if (dgrad > 180)
					dgrad -= 360;
				if (dgrad < -180)
					dgrad += 360;
				dgrad=dgrad*pi;
				dgrad=dgrad/180;
				vel.z=vel.z*cos(dgrad);

				if(vel.x<0) vel.x=-vel.x;
				if(vel.y<0) vel.y=-vel.y;
				if(vel.z<0) vel.z=-vel.z;
				float veloff;
				veloff=vel.x+vel.y+vel.z;
				veloff=(veloff*(vidsize/distance))*10;

				snprintf(msg,510,"Vis %.1f\nAmb %d %d\nSz %.1f\nveloff %.1f",
					p_vis,
					amb,d,
					sz,veloff);

				MESSAGE_BEGIN(MSG_ONE, SVC_TEMPENTITY, NULL, pent->v.owner);
				WRITE_BYTE( TE_TEXTMESSAGE);
				WRITE_BYTE( 4 & 0xFF );
				WRITE_SHORT( FixedSigned16( 0.3, 1<<13 ) );
				WRITE_SHORT( FixedSigned16( 0.3, 1<<13 ) );
				WRITE_BYTE(1); //effect
				WRITE_BYTE(255);
				WRITE_BYTE(255);
				WRITE_BYTE(255);
				WRITE_BYTE(255);
				WRITE_BYTE(255);
				WRITE_BYTE(255);
				WRITE_BYTE(255);
				WRITE_BYTE(255);
				WRITE_SHORT( FixedUnsigned16( 0, 1<<8 ) );
				WRITE_SHORT( FixedUnsigned16( 0, 1<<8 ) );
				WRITE_SHORT( FixedUnsigned16( 1, 1<<8 ) );
				WRITE_STRING(msg);
				MESSAGE_END();


				MESSAGE_BEGIN(MSG_ONE, SVC_TEMPENTITY, NULL, pent->v.owner);
				WRITE_BYTE( TE_BOX);
				st=pBot->pBotEnemy->v.absmin;
				end=pBot->pBotEnemy->v.absmax;
				WRITE_COORD(st.x);
				WRITE_COORD(st.y);
				WRITE_COORD(st.z);
				WRITE_COORD(end.x);
				WRITE_COORD(end.y);
				WRITE_COORD(end.z);
				WRITE_SHORT( 1 ); // life in 0.1's
				WRITE_BYTE( 255);   // r, g, b
				WRITE_BYTE( 0 );   // r, g, b
				WRITE_BYTE( 0 );   // r, g, b
				MESSAGE_END();
			}
			else if(pBot->pBotPickupItem!=NULL)
			{
				MESSAGE_BEGIN(MSG_ONE, SVC_TEMPENTITY, NULL, pent->v.owner);
				WRITE_BYTE( TE_BOX);
				st=pBot->pBotPickupItem->v.absmin;
				end=pBot->pBotPickupItem->v.absmax;
				WRITE_COORD(st.x);
				WRITE_COORD(st.y);
				WRITE_COORD(st.z);
				WRITE_COORD(end.x);
				WRITE_COORD(end.y);
				WRITE_COORD(end.z);
				WRITE_SHORT( 1 ); // life in 0.1's
				WRITE_BYTE( 0);   // r, g, b
				WRITE_BYTE( 255 );   // r, g, b
				WRITE_BYTE( 0 );   // r, g, b
				MESSAGE_END();
			}
		}
		//UTIL_MakeVectors(pent->v.euser1->v.v_angle);
		UTIL_TraceLine(pent->v.euser1->v.origin + pent->v.euser1->v.view_ofs,
			pent->v.euser1->v.origin + pent->v.euser1->v.view_ofs + gpGlobals->v_forward * off_f, // + gpGlobals->v_up * 10
			ignore_monsters, pent->v.euser1, &tr );

		//UTIL_SetOrigin(pent, tr.vecEndPos);
		pent->v.origin=tr.vecEndPos;

		pent->v.angles = pent->v.euser1->v.v_angle;
		pent->v.velocity=Vector(0,0,0);
		if (pent->v.angles.y >= 360)
			pent->v.angles.y -= 360;
		if (pent->v.angles.y < 0)
			pent->v.angles.y += 360;
		pent->v.nextthink = gpGlobals->time;
	}
	if(!mr_meta)
		(*other_gFunctionTable.pfnThink)(pent);
	else
		SET_META_RESULT(MRES_HANDLED);
}

void DispatchUse( edict_t *pentUsed, edict_t *pentOther )
{
	if (debug_engine) { fp=fopen("bot.txt","a"); fprintf(fp, "DispatchUse: used %x other %x\n",pentUsed,pentOther); fclose(fp); }
	if(!mr_meta)
		(*other_gFunctionTable.pfnUse)(pentUsed, pentOther);
	else
		SET_META_RESULT(MRES_HANDLED);
}

void DispatchTouch( edict_t *pentTouched, edict_t *pentOther )
{
	if(!mr_meta)
		(*other_gFunctionTable.pfnTouch)(pentTouched, pentOther);
	else
		SET_META_RESULT(MRES_HANDLED);
}

void DispatchBlocked( edict_t *pentBlocked, edict_t *pentOther )
{
	if(!mr_meta)
		(*other_gFunctionTable.pfnBlocked)(pentBlocked, pentOther);
	else
		SET_META_RESULT(MRES_HANDLED);
}

void DispatchKeyValue( edict_t *pentKeyvalue, KeyValueData *pkvd )
{
	static edict_t *temp_pent;
	static int flag_index;

	if (mod_id == TFC_DLL)
	{
		if (pentKeyvalue == pent_info_tfdetect)
		{
			if (strcmp(pkvd->szKeyName, "ammo_medikit") == 0)  // max BLUE players
				max_team_players[0] = atoi(pkvd->szValue);
			else if (strcmp(pkvd->szKeyName, "ammo_detpack") == 0)  // max RED players
				max_team_players[1] = atoi(pkvd->szValue);
			else if (strcmp(pkvd->szKeyName, "maxammo_medikit") == 0)  // max YELLOW players
				max_team_players[2] = atoi(pkvd->szValue);
			else if (strcmp(pkvd->szKeyName, "maxammo_detpack") == 0)  // max GREEN players
				max_team_players[3] = atoi(pkvd->szValue);

			else if (strcmp(pkvd->szKeyName, "maxammo_shells") == 0)  // BLUE class limits
				team_class_limits[0] = atoi(pkvd->szValue);
			else if (strcmp(pkvd->szKeyName, "maxammo_nails") == 0)  // RED class limits
				team_class_limits[1] = atoi(pkvd->szValue);
			else if (strcmp(pkvd->szKeyName, "maxammo_rockets") == 0)  // YELLOW class limits
				team_class_limits[2] = atoi(pkvd->szValue);
			else if (strcmp(pkvd->szKeyName, "maxammo_cells") == 0)  // GREEN class limits
				team_class_limits[3] = atoi(pkvd->szValue);

			else if (strcmp(pkvd->szKeyName, "team1_allies") == 0)  // BLUE allies
				team_allies[0] = atoi(pkvd->szValue);
			else if (strcmp(pkvd->szKeyName, "team2_allies") == 0)  // RED allies
				team_allies[1] = atoi(pkvd->szValue);
			else if (strcmp(pkvd->szKeyName, "team3_allies") == 0)  // YELLOW allies
				team_allies[2] = atoi(pkvd->szValue);
			else if (strcmp(pkvd->szKeyName, "team4_allies") == 0)  // GREEN allies
				team_allies[3] = atoi(pkvd->szValue);
		}
		else if (pent_info_tfdetect == NULL)
		{
			if ((strcmp(pkvd->szKeyName, "classname") == 0) &&
				(strcmp(pkvd->szValue, "info_tfdetect") == 0))
			{
				pent_info_tfdetect = pentKeyvalue;
			}
		}

		if (pentKeyvalue == pent_item_tfgoal)
		{
			if (strcmp(pkvd->szKeyName, "team_no") == 0)
				flags[flag_index].team_no = atoi(pkvd->szValue);

			if ((strcmp(pkvd->szKeyName, "mdl") == 0) &&
				((strcmp(pkvd->szValue, "models/flag.mdl") == 0) ||
				(strcmp(pkvd->szValue, "models/keycard.mdl") == 0) ||
				(strcmp(pkvd->szValue, "models/ball.mdl") == 0)))
			{
				flags[flag_index].mdl_match = TRUE;
				num_flags++;
			}
		}
		else if (pent_item_tfgoal == NULL)
		{
			if ((strcmp(pkvd->szKeyName, "classname") == 0) &&
				(strcmp(pkvd->szValue, "item_tfgoal") == 0))
			{
				if (num_flags < MAX_FLAGS)
				{
					pent_item_tfgoal = pentKeyvalue;

					flags[num_flags].mdl_match = FALSE;
					flags[num_flags].team_no = 0;  // any team unless specified
					flags[num_flags].edict = pentKeyvalue;

					flag_index = num_flags;  // in case the mdl comes before team_no
				}
			}
		}
		else
		{
			pent_item_tfgoal = NULL;  // reset for non-flag item_tfgoal's
		}

		if ((strcmp(pkvd->szKeyName, "classname") == 0) &&
			((strcmp(pkvd->szValue, "info_player_teamspawn") == 0) ||
			(strcmp(pkvd->szValue, "info_tf_teamcheck") == 0) ||
			(strcmp(pkvd->szValue, "i_p_t") == 0)))
		{
			temp_pent = pentKeyvalue;
		}
		else if (pentKeyvalue == temp_pent)
		{
			if (strcmp(pkvd->szKeyName, "team_no") == 0)
			{
				int value = atoi(pkvd->szValue);

				is_team[value-1]=true;
				if (value > max_teams)
					max_teams = value;
			}
		}
	}
	else if (mod_id == GEARBOX_DLL)
	{
		if (pent_info_ctfdetect == NULL)
		{
			if ((strcmp(pkvd->szKeyName, "classname") == 0) &&
				(strcmp(pkvd->szValue, "info_ctfdetect") == 0))
			{
				pent_info_ctfdetect = pentKeyvalue;
			}
		}
	}

	if(!mr_meta)
		(*other_gFunctionTable.pfnKeyValue)(pentKeyvalue, pkvd);
	else
		SET_META_RESULT(MRES_HANDLED);
}

void DispatchSave( edict_t *pent, SAVERESTOREDATA *pSaveData )
{
	if(!mr_meta)
		(*other_gFunctionTable.pfnSave)(pent, pSaveData);
	else
		SET_META_RESULT(MRES_HANDLED);
}

int DispatchRestore( edict_t *pent, SAVERESTOREDATA *pSaveData, int globalEntity )
{
	if(!mr_meta)
		return (*other_gFunctionTable.pfnRestore)(pent, pSaveData, globalEntity);
	else
	{
		SET_META_RESULT(MRES_HANDLED);
		return(0);
	}
}

void DispatchObjectCollsionBox( edict_t *pent )
{
	if(!mr_meta)
		(*other_gFunctionTable.pfnSetAbsBox)(pent);
	else
		SET_META_RESULT(MRES_HANDLED);
}

void SaveWriteFields( SAVERESTOREDATA *pSaveData, const char *pname, void *pBaseData, TYPEDESCRIPTION *pFields, int fieldCount )
{
	if(!mr_meta)
		(*other_gFunctionTable.pfnSaveWriteFields)(pSaveData, pname, pBaseData, pFields, fieldCount);
	else
		SET_META_RESULT(MRES_HANDLED);
}

void SaveReadFields( SAVERESTOREDATA *pSaveData, const char *pname, void *pBaseData, TYPEDESCRIPTION *pFields, int fieldCount )
{
	if(!mr_meta)
		(*other_gFunctionTable.pfnSaveReadFields)(pSaveData, pname, pBaseData, pFields, fieldCount);
	else
		SET_META_RESULT(MRES_HANDLED);
}

void SaveGlobalState( SAVERESTOREDATA *pSaveData )
{
	if(!mr_meta)
		(*other_gFunctionTable.pfnSaveGlobalState)(pSaveData);
	else
		SET_META_RESULT(MRES_HANDLED);
}

void RestoreGlobalState( SAVERESTOREDATA *pSaveData )
{
	if(!mr_meta)
		(*other_gFunctionTable.pfnRestoreGlobalState)(pSaveData);
	else
		SET_META_RESULT(MRES_HANDLED);
}

void ResetGlobalState( void )
{
	if(!mr_meta)
		(*other_gFunctionTable.pfnResetGlobalState)();
	else
		SET_META_RESULT(MRES_HANDLED);
}

BOOL ClientConnect( edict_t *pEntity, const char *pszName, const char *pszAddress, char szRejectReason[ 128 ]  )
{ 
	if (gpGlobals->deathmatch)
	{
		int i;
		int count = 0;
		if (debug_engine) { fp=fopen("bot.txt","a"); fprintf(fp, "ClientConnect: pent=%x name=%s\n",pEntity,pszName); fclose(fp); }

		//ALERT(at_console,"[FOXBOT] This server is running FoxBot (%d build %d), Get it at foxbot.net!\n",VER_MINOR,VER_BUILD);
		if(!mr_meta)
		{
			char msg[255];
			//sprintf(msg,"[FOXBOT] This server is running FoxBot (v %d build %d), Get it at foxbot.net!\n",VER_MINOR,VER_BUILD);
			sprintf(msg,"[FOXBOT] This server is running FoxBot (v%d.%d), Get it at foxbot.net!\n",VER_MAJOR,VER_MINOR);
			CLIENT_PRINTF(pEntity,print_console,msg);
		}

		// check if this is NOT a bot joining the server...
		if (strcmp(pszAddress, "127.0.0.1") != 0)
		{
			i = 0;
			while ((i < 32) && (clients[i] != NULL && clients[i] != pEntity))
				i++;
			if (i < 32)
				clients[i] = pEntity;
			if (welcome_index == -1)
				welcome_index = i;
			// don't try to add bots for 30 seconds, give client time to get added
			bot_check_time = gpGlobals->time + 45.0;
			// save the edict of the first player to join this server...
			if (first_player == NULL)
				first_player = pEntity;
		}
	}

	if(!mr_meta)
		return (*other_gFunctionTable.pfnClientConnect)(pEntity, pszName, pszAddress, szRejectReason);
	else
	{
		RETURN_META_VALUE(MRES_HANDLED, TRUE);
	}
}

BOOL ClientConnect_Post( edict_t *pEntity, const char *pszName, const char *pszAddress, char szRejectReason[ 128 ]  )
{ 
	if (gpGlobals->deathmatch)
	{

		if (debug_engine) { fp=fopen("bot.txt","a"); fprintf(fp, "ClientConnect_Post: pent=%x name=%s\n",pEntity,pszName); fclose(fp); }

		//ALERT(at_console,"[FOXBOT] This server is running FoxBot (%d build %d), Get it at foxbot.net!\n",VER_MINOR,VER_BUILD);
		char msg[255];
		//sprintf(msg,"[FOXBOT] This server is running FoxBot (v %d build %d), Get it at foxbot.net!\n",VER_MINOR,VER_BUILD);
		sprintf(msg,"[FOXBOT] This server is running FoxBot (v%d.%d), Get it at foxbot.net!\n",VER_MAJOR,VER_MINOR);
		CLIENT_PRINTF(pEntity,print_console,msg);
	}
	RETURN_META_VALUE(MRES_HANDLED, TRUE);
}


void ClientDisconnect( edict_t *pEntity )
{
	if (gpGlobals->deathmatch)
	{
		int i, index;

		if (debug_engine) { fp=fopen("bot.txt","a"); fprintf(fp, "ClientDisconnect: %x\n",pEntity); fclose(fp); }

		index = -1;

		for (i=0; i < 32; i++)
		{
			if (bots[i].pEdict == pEntity && bots[i].is_used)
			{
				index = i;
				break;
			}
		}

		if (index != -1)
		{
			// someone kicked this bot off of the server...
			bots[index].sg=false;
			bots[index].is_used = FALSE;  // this slot is now free to use
			bots[index].kick_time = gpGlobals->time;  // save the kicked time
		}
		else
		{	
			i = 0;
			while ((i < 32) && (clients[i] != pEntity))
				i++;
			if (i < 32)
				clients[i] = NULL;
			//human left?
			// what about lev changes..
		}
	}

	if(!mr_meta)
		(*other_gFunctionTable.pfnClientDisconnect)(pEntity);
	else
	{
		RETURN_META(MRES_HANDLED);
	}
}

void ClientKill( edict_t *pEntity )
{
	if (debug_engine) { fp=fopen("bot.txt","a"); fprintf(fp, "ClientKill: %x\n",pEntity); fclose(fp); }
	if(!mr_meta)
		(*other_gFunctionTable.pfnClientKill)(pEntity);
	else
		SET_META_RESULT(MRES_HANDLED);
}

void ClientPutInServer( edict_t *pEntity )
{
	if (debug_engine) { fp=fopen("bot.txt","a"); fprintf(fp, "ClientPutInServer: %x\n",pEntity); fclose(fp); }
	if(!mr_meta)
		(*other_gFunctionTable.pfnClientPutInServer)(pEntity);
	else
	{
		RETURN_META(MRES_HANDLED);
	}
}

void ClientCommand( edict_t *pEntity )
{
	//tfc saveme sommand means somones calling for a medic, 
	//can we put code in here to get medic too respond?
	if(mod_id==TFC_DLL && pEntity!=NULL)
	{
		const char *pcmd = CMD_ARGV(0);
		const char *arg1 = CMD_ARGV(1);
		const char *arg2 = CMD_ARGV(2);
		const char *arg3 = CMD_ARGV(3);
		const char *arg4 = CMD_ARGV(4);
		//char msg[80];
		if (debug_engine)
		{
			fp=fopen("bot.txt","a"); fprintf(fp,"ClientCommand: %s %x",pcmd,pEntity);
			if ((arg1 != NULL))
			{
				if((*arg1 != 0))
					fprintf(fp," 1:%s", arg1);
			}
			if ((arg2 != NULL))
			{
				if((*arg2 != 0))
					fprintf(fp," 2:%s", arg2);
			}
			if ((arg3 != NULL))
			{
				if((*arg3 != 0))
					fprintf(fp," 3:%s", arg3);
			}
			if ((arg4 != NULL))
			{
				if((*arg4 != 0))
					fprintf(fp," 4:%s", arg4);
			}
			fprintf(fp, "\n");
			fclose(fp);
		}
		if(FStrEq(pcmd, "saveme") && IsAlive(pEntity))
		{
			bot_t *closest;
			closest=NULL;
			float min_distance;
			float distance;
			min_distance = 9999.0;
			TraceResult tr;
			for (int index = 0; index < 32; index++)
			{
				if (bots[index].is_used && ((bots[index].pEdict->v.playerclass == TFC_CLASS_MEDIC) || 
					(bots[index].pEdict->v.playerclass == TFC_CLASS_ENGINEER)) && !bots[index].pBotEnemy && 
					!bots[index].bot_has_flag && !bots[index].ConcJumping)
				{	
					//workout distance, get closest
					distance = (bots[index].pEdict->v.origin - pEntity->v.origin).Length();

					if(distance<min_distance)
					{
						UTIL_TraceLine( pEntity->v.origin, bots[index].pEdict->v.origin, ignore_monsters, pEntity->v.pContainingEntity, &tr );
						if (tr.flFraction >= 1.0)
						{
							closest= &bots[index];
							min_distance=distance;
						}
					}
				}
			}			
			//...and the players not dead/spec
			if(closest && (closest->pEdict->v.origin.z > (pEntity->v.origin.z-32)))
			{
				// Check to see if this was a valid call before assigning the enemy
				if (((closest->pEdict->v.playerclass == TFC_CLASS_MEDIC) && (pEntity->v.health < pEntity->v.max_health+20)) || 
					(((closest->pEdict->v.playerclass == TFC_CLASS_ENGINEER) && !BotIsInfected(pEntity) && (BotArmorValue(pEntity) < 90)) &&
					closest->m_rgAmmo[weapon_defs[TF_WEAPON_SPANNER].iAmmo1] >= 20) && !(closest->sg_building))
				{
					closest->pBotEnemy=pEntity;
					closest->ras=false;
					closest->backwards=false;
					//do gren and back time aswell
					closest->backwards_time=gpGlobals->time+30;
				}
			}
		}
	}

	if ((gpGlobals->deathmatch) && (!IS_DEDICATED_SERVER()) && pEntity==INDEXENT(1))
	{
		const char *pcmd = CMD_ARGV(0);
		const char *arg1 = CMD_ARGV(1);
		const char *arg2 = CMD_ARGV(2);
		const char *arg3 = CMD_ARGV(3);
		const char *arg4 = CMD_ARGV(4);
		char msg[512];

		if (debug_engine)
		{
			fp=fopen("bot.txt","a"); fprintf(fp,"ClientCommand: %s %x",pcmd,pEntity);
			if ((arg1 != NULL))
			{
				if((*arg1 != 0))
					fprintf(fp," '%s'(1)", arg1);
			}
			if ((arg2 != NULL))
			{
				if((*arg2 != 0))
					fprintf(fp," '%s'(2)", arg2);
			}
			if ((arg3 != NULL))
			{
				if((*arg3 != 0))
					fprintf(fp," '%s'(3)", arg3);
			}
			if ((arg4 != NULL))
			{
				if((*arg4 != 0))
					fprintf(fp," '%s'(4)", arg4);
			}
			fprintf(fp, "\n");
			fclose(fp);
		}

		if (FStrEq(pcmd, "addbot") || FStrEq(pcmd, "foxbot_addbot"))
		{
			if(arg2!=NULL && (*arg2 != 0))
				BotCreate( pEntity, arg1, arg2, arg3, arg4 );
			else
			{
				char c[8];
				strcpy(c,"-1");
				BotCreate( pEntity, arg1,c, arg3, arg4 );
			}
			bot_check_time = gpGlobals->time + 5.0;
			if(mr_meta) 
				RETURN_META(MRES_SUPERCEDE);
			return;
		}
		else if (FStrEq(pcmd, "min_bots"))
		{
			char msg[255];
			if(arg1!=NULL && (*arg1 != 0))
			{
				min_bots = atoi( arg1 );
				if ((min_bots < -1) || (min_bots > 31))
					min_bots = 1;
				sprintf(msg, "min_bots set to %d\n", min_bots);
			}
			else
				sprintf(msg, "min_bots is %d\n", min_bots);
			ClientPrint(pEntity, HUD_PRINTNOTIFY, msg);
			if(mr_meta) 
				RETURN_META(MRES_SUPERCEDE);
			return;
		}
		else if (FStrEq(pcmd, "max_bots"))
		{
			char msg[255];
			if(arg1!=NULL && (*arg1 != 0))
			{
				max_bots = atoi( arg1 );
				if ((max_bots < -1) || (max_bots > 31)) 
					max_bots = 1;
				sprintf(msg, "max_bots set to %d\n", max_bots);
			}
			else
				sprintf(msg, "max_bots is %d\n", max_bots);
			ClientPrint(pEntity, HUD_PRINTNOTIFY, msg);
			if(mr_meta) 
				RETURN_META(MRES_SUPERCEDE);
			return;
		}
		else if (FStrEq(pcmd, "bot_info"))
		{
			DisplayBotInfo();
			if(mr_meta) 
				RETURN_META(MRES_SUPERCEDE);
			return;
		}
		else if (FStrEq(pcmd, "bot_team_balance"))
		{
			if ((arg1 != NULL))
			{
				if((*arg1 != 0))
				{
					int temp = atoi(arg1);
					if (temp)
						bot_team_balance = TRUE;
					else
						bot_team_balance = FALSE;
				}
			}
			if (bot_team_balance)
				ClientPrint(pEntity, HUD_PRINTNOTIFY, "bot_team_balance (1) On\n");
			else
				ClientPrint(pEntity, HUD_PRINTNOTIFY, "bot_team_balance (0) Off\n");
			if(mr_meta) 
				RETURN_META(MRES_SUPERCEDE);
			return;
		}
		else if (FStrEq(pcmd, "bot_bot_balance"))
		{
			if ((arg1 != NULL))
			{
				if((*arg1 != 0))
				{
					int temp = atoi(arg1);
					if (temp)
						bot_bot_balance = TRUE;
					else
						bot_bot_balance = FALSE;
				}
			}

			if (bot_bot_balance)
				ClientPrint(pEntity, HUD_PRINTNOTIFY, "bot_bot_balance (1) On\n");
			else
				ClientPrint(pEntity, HUD_PRINTNOTIFY, "bot_bot_balance (0) Off\n");			

			if(mr_meta) RETURN_META(MRES_SUPERCEDE);
			return;
		}
		else if (FStrEq(pcmd, "kickall") || FStrEq(pcmd, "foxbot_kickall"))
		{
			// kick any bot off of the server after time/frag limit...
			for (int index = 0; index < 32; index++)
			{
				if (bots[index].is_used)  // is this slot used?
				{
					char cmd[40];

					sprintf(cmd, "kick \"%s\"\n", bots[index].name);

					//if (mod_id == TFC_DLL) FakeClientCommand(bots[index].pEdict,"spectate",NULL,NULL);
					//bots[index].respawn_state = RESPAWN_NEED_TO_RESPAWN;

					SERVER_COMMAND(cmd);  // kick the bot using (kick "name")
					//fixed the fecking addbot bug!
					//bots[index].pEdict->v.team=6;
					b_team[index]=-1;
					b_class[index]=-1;
					bots[index].sg = false;
					bots[index].sg_edict = NULL;							
					bots[index].sg_wp = -1;
					bots[index].SGRotated = false;
					bots[index].is_used=false;
				}
			}
		}
		else if (FStrEq(pcmd, "kickteam") || FStrEq(pcmd, "foxbot_kickteam"))
		{
			for (int index = 0; index < 32; index++)
			{
				if (bots[index].is_used)  // is this slot used?
				{
					char cmd[40];
					int whichTeam = atoi(arg1);
					// skip teams that dont meet the argument.
					if (bots[index].bot_team != whichTeam)
						continue;

					sprintf(cmd, "kick \"%s\"\n", bots[index].name);

					SERVER_COMMAND(cmd);  // kick the bot using (kick "name")

					b_team[index]=-1;
					b_class[index]=-1;
					bots[index].sg = false;
					bots[index].sg_edict = NULL;							
					bots[index].sg_wp = -1;
					bots[index].SGRotated = false;
					bots[index].is_used=false;
				}
			}
		}
		else if (FStrEq(pcmd, "observer"))
		{
			if ((arg1 != NULL))
			{
				if((*arg1 != 0))
				{
					int temp = atoi(arg1);
					if (temp)
						b_observer_mode = TRUE;
					else
						b_observer_mode = FALSE;
				}
			}

			if (b_observer_mode)
				ClientPrint(pEntity, HUD_PRINTNOTIFY, "observer mode ENABLED\n");
			else
				ClientPrint(pEntity, HUD_PRINTNOTIFY, "observer mode DISABLED\n");

			if(mr_meta) RETURN_META(MRES_SUPERCEDE);
			return;
		}
		else if (FStrEq(pcmd, "botskill"))
		{
			if ((arg1 != NULL))
			{
				if((*arg1 != 0))
				{
					int temp = atoi(arg1);

					if ((temp < 1) || (temp > 5))
						ClientPrint(pEntity, HUD_PRINTNOTIFY, "invalid botskill value!\n");
					else
						default_bot_skill = temp;
				}
			}

			sprintf(msg, "botskill is %d\n", default_bot_skill);
			ClientPrint(pEntity, HUD_PRINTNOTIFY, msg);

			if(mr_meta) RETURN_META(MRES_SUPERCEDE);
			return;
		}
		else if (FStrEq(pcmd, "botdontshoot"))
		{
			if ((arg1 != NULL))
			{
				if((*arg1 != 0))
				{
					int temp = atoi(arg1);
					if (temp)
						b_botdontshoot = TRUE;
					else
						b_botdontshoot = FALSE;
				}
			}

			if (b_botdontshoot)
				ClientPrint(pEntity, HUD_PRINTNOTIFY, "botdontshoot ENABLED\n");
			else
				ClientPrint(pEntity, HUD_PRINTNOTIFY, "botdontshoot DISABLED\n");

			if(mr_meta) RETURN_META(MRES_SUPERCEDE);
			return;
		}
		else if (FStrEq(pcmd, "debug_engine") || FStrEq(pcmd, "foxbot_debug_engine"))
		{
			if (FStrEq(arg1, "on"))
			{
				debug_engine = 1;

				ClientPrint(pEntity, HUD_PRINTNOTIFY, "debug_engine enabled!\n");
			}
			else if (FStrEq(arg1, "off"))
			{
				debug_engine = 0;

				ClientPrint(pEntity, HUD_PRINTNOTIFY, "debug_engine disabled!\n");
			}
			if(mr_meta) RETURN_META(MRES_SUPERCEDE);
			return;
		}

		//botcam
		else if (FStrEq(pcmd, "botcam" ))
		{
			edict_t *pBot=NULL;
			char botname[BOT_NAME_LEN+1];
			int index;

			botname[0] = 0;

			if ((arg1 != NULL))
			{
				if((*arg1 != 0))
				{
					if (strstr(arg1, "\"") == NULL)
						strcpy(botname, arg1);
					else
						sscanf(arg1, "\"%s\"", &botname[0]);

					index = 0;

					while (index < 32)
					{
						if ((bots[index].is_used) &&
							(stricmp(bots[index].name, botname) == 0))
							break;
						else
							index++;
					}

					if (index < 32)
					{
						pBot=bots[index].pEdict;
					}
				}
			}
			else
			{
				index = 0;

				while ((bots[index].is_used == FALSE) && (index < 32))
					index++;

				if (index < 32)
				{
					pBot=bots[index].pEdict;
				}
			}

			if (pBot == NULL)
			{
				if (botname[0])
					CLIENT_PRINTF( pEntity, print_console, UTIL_VarArgs("there is no bot named \"%s\"!\n", botname) );
				else
					CLIENT_PRINTF( pEntity, print_console, UTIL_VarArgs("there are no bots!\n") );
			}
			else
			{	
				if(!g_waypoint_cache)
					CLIENT_PRINTF( pEntity, print_console, "Turn waypoints on so proper entities can be cached. Then retry botcam.");
				else
				{
					KillCamera(pEntity);
					CreateCamera(pEntity,pBot);
					botcamEnabled = true;
				}				
			}
			if(mr_meta) RETURN_META(MRES_SUPERCEDE);
			return;
		}
		else if (FStrEq(pcmd, "nobotcam" ))
		{
			KillCamera(pEntity);
			botcamEnabled = false;
			if(mr_meta) RETURN_META(MRES_SUPERCEDE);
			return;
		}
		else if (FStrEq(pcmd, "waypoint_author" ))
		{
			if ((arg1 != NULL))
			{
				if((*arg1 != 0))
				{
					char msg[512];
					sprintf(msg,"Waypoint author set to : %s",arg1);
					CLIENT_PRINTF( pEntity, print_console, UTIL_VarArgs(msg) );
					strncpy(waypoint_author,arg1,250);
					waypoint_author[251]=NULL;
					CBaseEntity *p;
					p=CBaseEntity::Instance(INDEXENT(1));
					hudtextparms_t h;
					h.channel=2;
					h.effect=1;
					h.r1=255;
					h.g1=128;
					h.b1=0;
					h.a1=255;
					h.r2=255;
					h.g2=170;
					h.b2=0;
					h.a2=255;
					h.fadeinTime=1;
					h.fadeoutTime=1;
					h.holdTime=7;
					h.x=-1;
					h.y=0.8;
					sprintf(msg,"-- Waypoint author: %s --",waypoint_author);
					UTIL_HudMessage(p,h,msg);
				}
			}
			if(mr_meta) RETURN_META(MRES_SUPERCEDE);
			return;
		}



		else if (FStrEq(pcmd, "waypoint"))
		{
			if (FStrEq(arg1, "on"))
			{
				g_waypoint_on = TRUE;

				ClientPrint(pEntity, HUD_PRINTNOTIFY, "waypoints are ON\n");
			}
			else if (FStrEq(arg1, "off"))
			{
				g_waypoint_on = FALSE;
				g_path_oneway = FALSE;
				g_path_twoway = FALSE;

				ClientPrint(pEntity, HUD_PRINTNOTIFY, "waypoints are OFF\n");
			}
			else if (FStrEq(arg1, "add"))
			{
				if (!g_waypoint_on)
					g_waypoint_on = TRUE;  // turn waypoints on if off

				WaypointAdd(pEntity);
			}
			else if (FStrEq(arg1, "delete") && g_waypoint_on)
			{
				if (!g_waypoint_on)
					g_waypoint_on = TRUE;  // turn waypoints on if off

				WaypointDelete(pEntity);
			}
			else if (FStrEq(arg1, "save") && g_waypoint_on)
			{
				WaypointSave();

				ClientPrint(pEntity, HUD_PRINTNOTIFY, "waypoints saved\n");
			}
			else if (FStrEq(arg1, "load"))
			{
				if (WaypointLoad(pEntity))
					ClientPrint(pEntity, HUD_PRINTNOTIFY, "waypoints loaded\n");
				JunctionCalculate();
			}
			else if (FStrEq(arg1, "menu") && g_waypoint_on)
			{
				int index;
				index = WaypointFindNearest(pEntity, 50.0, -1);
				if(num_waypoints>0 && index!=-1)
				{
					g_menu_waypoint = index;
					g_menu_state = MENU_1;

				UTIL_ShowMenu(pEntity, 0x7F, -1, FALSE, show_menu_1);
				//	UTIL_ShowMenu(pEntity, 0x3F, -1, FALSE, show_menu_1);
					
				}
			}
			else if (FStrEq(arg1, "info"))
			{
				WaypointPrintInfo(pEntity);
			}
			else if (FStrEq(arg1, "autobuild"))
			{
				if (!g_waypoint_on)
					g_waypoint_on = TRUE;  // turn waypoints on if off

				WaypointAutoBuild(pEntity);
			}
			else
			{
				if (g_waypoint_on)
					ClientPrint(pEntity, HUD_PRINTNOTIFY, "waypoints are ON\n");
				else
					ClientPrint(pEntity, HUD_PRINTNOTIFY, "waypoints are OFF\n");
			}

			if(mr_meta) RETURN_META(MRES_SUPERCEDE);
			return;
		}
		else if (FStrEq(pcmd, "autowaypoint"))
		{
			if (FStrEq(arg1, "on"))
			{
				g_auto_waypoint = TRUE;
				g_waypoint_on = TRUE;  // turn this on just in case
			}
			else if (FStrEq(arg1, "off"))
			{
				g_auto_waypoint = FALSE;
			}

			if (g_auto_waypoint)
				sprintf(msg, "autowaypoint is ON\n");
			else
				sprintf(msg, "autowaypoint is OFF\n");

			ClientPrint(pEntity, HUD_PRINTNOTIFY, msg);

			if(mr_meta) RETURN_META(MRES_SUPERCEDE);
			return;
		}
		else if (FStrEq(pcmd, "bot_debug"))
		{
			if (FStrEq(arg1, "on"))
			{
				CVAR_SET_STRING("developer","1");
				g_bot_debug = TRUE;


				ClientPrint(pEntity, HUD_PRINTNOTIFY, "bot debugging is ON\n");
			}
			else if (FStrEq(arg1, "off"))
			{
				g_bot_debug = FALSE;

				ClientPrint(pEntity, HUD_PRINTNOTIFY, "bot debugging is OFF\n");
				CVAR_SET_STRING("developer","0");
			}
			if(mr_meta) RETURN_META(MRES_SUPERCEDE);
			return;
		}
		else if (FStrEq(pcmd, "available"))
		{
			int i;
			char msg2[512];
			msg2[0]=NULL;

			for(i=0;i<8;i++)
			{
				if(blue_av[i]) 
					sprintf(msg,"B %d 1 ",i+1);
				else
					sprintf(msg,"B %d 0 ",i+1);
				if(red_av[i])
					snprintf(msg,250,"%sR %d 1 ",msg,i+1);
				else
					snprintf(msg,250,"%sR %d 0 ",msg,i+1);
				if(yellow_av[i]) 
					snprintf(msg,250,"%sY %d 1 ",msg,i+1);
				else
					snprintf(msg,250,"%sY %d 0 ",msg,i+1);
				if(green_av[i])
					snprintf(msg,250,"%sG %d 1\n",msg,i+1);
				else
					snprintf(msg,250,"%sG %d 0\n",msg,i+1);
				ClientPrint(pEntity, HUD_PRINTNOTIFY, msg);
				snprintf(msg2,250,"%s%s",msg2,msg);
				msg[251]=NULL;
				msg2[251]=NULL;
			}
			hudtextparms_t h;
			h.channel=4;
			h.effect=1;
			h.r1=10;
			h.g1=53;
			h.b1=81;
			h.a1=255;
			h.r2=10;
			h.g2=53;
			h.b2=81;
			h.a2=168;
			h.fadeinTime=1;
			h.fadeoutTime=1;
			h.holdTime=20;
			h.x=0;
			h.y=0;
			CBaseEntity *p;
			p=CBaseEntity::Instance(INDEXENT(1));
			UTIL_HudMessage(p,h,msg);
			if(mr_meta) RETURN_META(MRES_SUPERCEDE);
			return;
		}
		else if (FStrEq(pcmd, "bot_chat") || FStrEq(pcmd, "foxbot_bot_chat"))
		{
			if (FStrEq(arg1, "on"))
			{
				b_botchat = TRUE;
				ClientPrint(pEntity, HUD_PRINTNOTIFY, "bot chat is ON\n");
			}
			else if (FStrEq(arg1, "off"))
			{
				b_botchat = FALSE;
				ClientPrint(pEntity, HUD_PRINTNOTIFY, "bot chat is OFF\n");
			}
			if(mr_meta) RETURN_META(MRES_SUPERCEDE);
			return;
		}
		else if (FStrEq(pcmd, "bot_xmas"))
		{
			if (FStrEq(arg1, "on"))
			{
				bot_xmas = TRUE;
				ClientPrint(pEntity, HUD_PRINTNOTIFY, "bot xmas is ON\n");
			}
			else if (FStrEq(arg1, "off"))
			{
				bot_xmas = FALSE;
				ClientPrint(pEntity, HUD_PRINTNOTIFY, "bot xmas is OFF\n");
			}
			if(mr_meta) RETURN_META(MRES_SUPERCEDE);
			return;
		//bot_spy_random_check - by yuraj
		}
		else if (FStrEq(pcmd, "bot_spy_random_check"))
		{
			if ((arg1 != NULL))
			{
			if((*arg1 != 0))
			{
				char a[512];
				sprintf(a,"bot_spy_random_check is %d \n",arg1);
				bot_spy_random_check = *arg1;
				ClientPrint(pEntity, HUD_PRINTNOTIFY, a);
			}
			}
			if(mr_meta) RETURN_META(MRES_SUPERCEDE);
			return;
			//
  
			//bot_can_use_teleporter - by yuraj
		}
		else if (FStrEq(pcmd, "bot_can_use_teleporter"))
		{
			if (FStrEq(arg1, "on"))
			{
				bot_can_use_teleporter = TRUE;
				ClientPrint(pEntity, HUD_PRINTNOTIFY, "bot_can_use_teleporter is ON\n");
			}
			else if (FStrEq(arg1, "off"))
			{
				bot_can_use_teleporter = FALSE;
				ClientPrint(pEntity, HUD_PRINTNOTIFY, "bot_can_use_teleporter is OFF\n");
			}
			if(mr_meta) RETURN_META(MRES_SUPERCEDE);
			return;
			//
            //bot_can_build_teleporter - by yuraj
		}
		else if (FStrEq(pcmd, "bot_can_build_teleporter"))
		{
			if (FStrEq(arg1, "on"))
			{
				bot_can_build_teleporter = TRUE;
				ClientPrint(pEntity, HUD_PRINTNOTIFY, "bot_can_build_teleporter is ON\n");
			}
			else if (FStrEq(arg1, "off"))
			{
				bot_can_build_teleporter = FALSE;
				ClientPrint(pEntity, HUD_PRINTNOTIFY, "bot_can_build_teleporter is OFF\n");
			}
			if(mr_meta) RETURN_META(MRES_SUPERCEDE);
			return;
			//
		}
		else if (FStrEq(pcmd, "locate_waypoint"))
		{
			if (FStrEq(arg1, "on"))
			{
				g_find_waypoint = TRUE;
				g_path_waypoint = TRUE;
				g_waypoint_on = TRUE;  // turn this on just in case
				ClientPrint(pEntity, HUD_PRINTNOTIFY, "locate waypoint is ON\n");
			}
			else if (FStrEq(arg1, "off"))
			{
				g_find_waypoint = FALSE;
				ClientPrint(pEntity, HUD_PRINTNOTIFY, "locate waypoint is OFF\n");
			}
			else 
			{
				g_find_waypoint = TRUE;
				g_waypoint_on = TRUE;  // turn this on just in case

				long l;
				l=atol(arg1);
				if(l<=num_waypoints) 
				{
					g_find_wp=l;
					char s[255];
					sprintf(s,"locate waypoint %d\n",l);
					ClientPrint(pEntity, HUD_PRINTNOTIFY, s);
				}
			}
			if(mr_meta) RETURN_META(MRES_SUPERCEDE);
			return;
		}
		else if (FStrEq(pcmd, "pathwaypoint_connect"))
		{
			if (FStrEq(arg1, "on"))
			{
				g_path_waypoint = TRUE;
				g_waypoint_on = TRUE;  // turn this on just in case
				g_path_connect = TRUE;


				ClientPrint(pEntity, HUD_PRINTNOTIFY, "pathwaypoint auto connect is ON\n");
			}
			else if (FStrEq(arg1, "off"))
			{
				g_path_connect = FALSE;

				ClientPrint(pEntity, HUD_PRINTNOTIFY, "pathwaypoint auto connect is OFF\n");
			}
			if(mr_meta) RETURN_META(MRES_SUPERCEDE);
			return;
		}
		else if (FStrEq(pcmd, "pathrun_oneway"))
		{
			if (FStrEq(arg1, "on"))
			{
				wpt1=-1;
				wpt2=-1;
				g_path_waypoint = TRUE;
				g_waypoint_on = TRUE;  // turn this on just in case
				g_path_connect = FALSE;
				g_path_oneway = TRUE;
				g_path_twoway = FALSE;

				ClientPrint(pEntity, HUD_PRINTNOTIFY, "pathrun oneway ON\n");
			}
			else if (FStrEq(arg1, "off"))
			{
				g_path_oneway = FALSE;

				ClientPrint(pEntity, HUD_PRINTNOTIFY, "pathrun oneway OFF\n");
			}
			if(mr_meta) RETURN_META(MRES_SUPERCEDE);
			return;
		}
		else if (FStrEq(pcmd, "pathrun_twoway"))
		{
			if (FStrEq(arg1, "on"))
			{
				wpt1=-1;
				wpt2=-1;
				g_path_waypoint = TRUE;
				g_waypoint_on = TRUE;  // turn this on just in case
				g_path_connect = FALSE;
				g_path_oneway = FALSE;
				g_path_twoway = TRUE;

				ClientPrint(pEntity, HUD_PRINTNOTIFY, "pathrun twoway ON\n");
			}
			else if (FStrEq(arg1, "off"))
			{
				g_path_twoway = FALSE;

				ClientPrint(pEntity, HUD_PRINTNOTIFY, "pathrun twoway OFF\n");
			}
			if(mr_meta) RETURN_META(MRES_SUPERCEDE);
			return;
		}
		else if (FStrEq(pcmd, "pathwaypoint"))
		{
			if (FStrEq(arg1, "on"))
			{
				g_path_waypoint = TRUE;
				g_waypoint_on = TRUE;  // turn this on just in case

				ClientPrint(pEntity, HUD_PRINTNOTIFY, "pathwaypoint is ON\n");
			}
			else if (FStrEq(arg1, "off"))
			{
				g_path_waypoint = FALSE;

				ClientPrint(pEntity, HUD_PRINTNOTIFY, "pathwaypoint is OFF\n");
			}
			else if (FStrEq(arg1, "create1") && g_path_waypoint)
			{
				WaypointCreatePath(pEntity, 1);
			}
			else if (FStrEq(arg1, "create2") && g_path_waypoint)
			{
				WaypointCreatePath(pEntity, 2);
			}
			else if (FStrEq(arg1, "remove1") && g_path_waypoint)
			{
				WaypointRemovePath(pEntity, 1);
			}
			else if (FStrEq(arg1, "remove2") && g_path_waypoint)
			{
				WaypointRemovePath(pEntity, 2);
			}

			if(mr_meta) RETURN_META(MRES_SUPERCEDE);
			return;
		}
		else if (FStrEq(pcmd, "area"))
		{
			if (FStrEq(arg1, "on"))
			{
				g_area_def = TRUE;

				ClientPrint(pEntity, HUD_PRINTNOTIFY, "area is ON\n");
			}
			else if (FStrEq(arg1, "off"))
			{
				g_area_def = FALSE;

				ClientPrint(pEntity, HUD_PRINTNOTIFY, "area is OFF\n");
			}
			else if (FStrEq(arg1, "add"))
			{
				g_area_def = TRUE;
				AreaDefCreate(pEntity);
			}
			else if (FStrEq(arg1, "delete") && g_area_def)
			{
				g_area_def = TRUE;
				AreaDefDelete(pEntity);
			}
			else if (FStrEq(arg1, "save") && g_area_def)
			{
				AreaDefSave();

				ClientPrint(pEntity, HUD_PRINTNOTIFY, "areas saved\n");
			}
			else if (FStrEq(arg1, "load"))
			{
				if (AreaDefLoad(pEntity))
					ClientPrint(pEntity, HUD_PRINTNOTIFY, "areas loaded\n");
			}
			else if (FStrEq(arg1, "info"))
			{
				AreaDefPrintInfo(pEntity);
			}
			else if (FStrEq(arg1, "name") && g_area_def)
			{
				int i;
				i=AreaInsideClosest(pEntity);
				if(i!=-1 && strlen(arg2)<64)
				{
					strcpy(areas[i].namea,arg2);
					strcpy(areas[i].nameb,arg2);
					strcpy(areas[i].namec,arg2);
					strcpy(areas[i].named,arg2);
				}
				AreaDefPrintInfo(pEntity);
			}
			else if (FStrEq(arg1, "name1") && g_area_def)
			{
				int i;
				i=AreaInsideClosest(pEntity);
				if(i!=-1 && strlen(arg2)<64)
				{
					strcpy(areas[i].namea,arg2);
				}
				AreaDefPrintInfo(pEntity);
			}
			else if (FStrEq(arg1, "name2") && g_area_def)
			{
				int i;
				i=AreaInsideClosest(pEntity);
				if(i!=-1 && strlen(arg2)<64)
				{
					strcpy(areas[i].nameb,arg2);
				}
				AreaDefPrintInfo(pEntity);
			}
			else if (FStrEq(arg1, "name3") && g_area_def)
			{
				int i;
				i=AreaInsideClosest(pEntity);
				if(i!=-1 && strlen(arg2)<64)
				{
					strcpy(areas[i].namec,arg2);
				}
				AreaDefPrintInfo(pEntity);
			}
			else if (FStrEq(arg1, "name4") && g_area_def)
			{
				int i;
				i=AreaInsideClosest(pEntity);
				if(i!=-1 && strlen(arg2)<64)
				{
					strcpy(areas[i].named,arg2);
				}
				AreaDefPrintInfo(pEntity);
			}
			else if (FStrEq(arg1, "autobuild1"))
			{
				g_area_def = TRUE;

				AreaAutoBuild1();

				//ClientPrint(pEntity, HUD_PRINTNOTIFY, "area is ON\n");
			}
			else if (FStrEq(arg1, "merge"))
			{
				g_area_def = TRUE;

				AreaAutoMerge();

				//ClientPrint(pEntity, HUD_PRINTNOTIFY, "area is ON\n");
			}
			if(mr_meta) RETURN_META(MRES_SUPERCEDE);
			return;
		}
		else if (FStrEq(pcmd, "menuselect") && (g_menu_state != MENU_NONE))
		{

			if (g_menu_state == MENU_1)  // main menu...
			{
				if (FStrEq(arg1, "1"))  // team specific...
				{
					g_menu_state = MENU_2;  // display team specific menu...
					UTIL_ShowMenu(pEntity, 0x1F, -1, FALSE, show_menu_2);
					if(mr_meta) RETURN_META(MRES_SUPERCEDE);
					return;
				}
				else if (FStrEq(arg1, "2"))  // dislpay locations menu
				{
					g_menu_state = MENU_3;  // display team specific menu...
					UTIL_ShowMenu(pEntity, 0x03, -1, FALSE, show_menu_3);

					if(mr_meta) RETURN_META(MRES_SUPERCEDE);
					return;
				}
				else if (FStrEq(arg1, "3"))  // dislpay items menu
				{
					g_menu_state = MENU_4;  // display team specific menu...
					UTIL_ShowMenu(pEntity, 0x07, -1, FALSE, show_menu_4);

					if(mr_meta) RETURN_META(MRES_SUPERCEDE);
					return;
				}
				else if (FStrEq(arg1, "4"))  // dislpay actions menu 1
				{
					g_menu_state = MENU_5;  // display team specific menu...
					UTIL_ShowMenu(pEntity, 0x7F, -1, FALSE, show_menu_5);

					if(mr_meta) RETURN_META(MRES_SUPERCEDE);
					return;
				}
				else if (FStrEq(arg1, "5"))  // dislpay actions menu 2
				{
					g_menu_state = MENU_6;  // display team specific menu...
					UTIL_ShowMenu(pEntity, 0x1F, -1, FALSE, show_menu_6);

					if(mr_meta) RETURN_META(MRES_SUPERCEDE);
					return;
				}
				else if (FStrEq(arg1, "6"))  // control points
				{
					g_menu_state = MENU_7;
					UTIL_ShowMenu(pEntity, 0x1FF, -1, FALSE, show_menu_7);
					if(mr_meta) RETURN_META(MRES_SUPERCEDE);
					return;
				}
				
			}
			else if (g_menu_state == MENU_2)  // team specific tags
			{
				int team = atoi(arg1); 	team--; // make 0 - 3
				if ((waypoints[g_menu_waypoint].flags & W_FL_TEAM_SPECIFIC) && (team >= 0 && team <= 3))
				{
					waypoints[g_menu_waypoint].flags &= ~W_FL_TEAM;
					waypoints[g_menu_waypoint].flags &= ~W_FL_TEAM_SPECIFIC; // off
				}
				else
				{
					if (team >= 0 && team <= 3)
					{						
						waypoints[g_menu_waypoint].flags |= team;
						waypoints[g_menu_waypoint].flags |= W_FL_TEAM_SPECIFIC; // on
					}
				}
			}
			else if (g_menu_state == MENU_3)  // location tags
			{
				if (mod_id == TFC_DLL)
				{
					if (FStrEq(arg1, "1"))  // flag location
					{
						if (waypoints[g_menu_waypoint].flags & W_FL_TFC_FLAG)
							waypoints[g_menu_waypoint].flags &= ~W_FL_TFC_FLAG;  // off
						else
							waypoints[g_menu_waypoint].flags |= W_FL_TFC_FLAG;  // on
					}
					else if (FStrEq(arg1, "2"))  // flag goal
					{
						if (waypoints[g_menu_waypoint].flags & W_FL_TFC_FLAG_GOAL)
							waypoints[g_menu_waypoint].flags &= ~W_FL_TFC_FLAG_GOAL;  // off
						else
							waypoints[g_menu_waypoint].flags |= W_FL_TFC_FLAG_GOAL;  // on
					}				
				}
			}
			else if (g_menu_state == MENU_4) // item tags
			{
				if (FStrEq(arg1, "1"))  // set health
				{
					if (waypoints[g_menu_waypoint].flags & W_FL_HEALTH)
						waypoints[g_menu_waypoint].flags &= ~W_FL_HEALTH;  // off
					else
						waypoints[g_menu_waypoint].flags |= W_FL_HEALTH;  // on
				}				
				else if (FStrEq(arg1, "2"))  // set armor
				{
					if (waypoints[g_menu_waypoint].flags & W_FL_ARMOR)
						waypoints[g_menu_waypoint].flags &= ~W_FL_ARMOR;  // off
					else
						waypoints[g_menu_waypoint].flags |= W_FL_ARMOR;  // on
				}
				else if (FStrEq(arg1, "3"))  // set ammo
				{
					if (waypoints[g_menu_waypoint].flags & W_FL_AMMO)
						waypoints[g_menu_waypoint].flags &= ~W_FL_AMMO;  // off
					else
						waypoints[g_menu_waypoint].flags |= W_FL_AMMO;  // on
				}
			}
			else if (g_menu_state == MENU_5) // action tags
			{
				if (FStrEq(arg1, "1"))  // set sold/hw defender
				{
					if (waypoints[g_menu_waypoint].flags & W_FL_TFC_PL_DEFEND)
						waypoints[g_menu_waypoint].flags &= ~W_FL_TFC_PL_DEFEND;  // off
					else
					{
						waypoints[g_menu_waypoint].flags |= W_FL_TFC_PL_DEFEND;  // on
						WaypointAddAiming(pEntity);
					}
				}	
				else if (FStrEq(arg1, "2"))  // set demo defender
				{
					if (waypoints[g_menu_waypoint].flags & W_FL_TFC_PIPETRAP)
						waypoints[g_menu_waypoint].flags &= ~W_FL_TFC_PIPETRAP;  // off
					else
					{
						waypoints[g_menu_waypoint].flags |= W_FL_TFC_PIPETRAP;  // on
						WaypointAddAiming(pEntity);
					}
				}
				else if (FStrEq(arg1, "3"))  // sniper spot
				{
					if (waypoints[g_menu_waypoint].flags & W_FL_SNIPER)
						waypoints[g_menu_waypoint].flags &= ~W_FL_SNIPER;  // off
					else
					{
						waypoints[g_menu_waypoint].flags |= W_FL_SNIPER;  // on
						// set the aiming waypoint...
						WaypointAddAiming(pEntity);
					}
				}	
				else if (FStrEq(arg1, "4"))  // set sentry
				{
					if (waypoints[g_menu_waypoint].flags & W_FL_TFC_DEFEND)
						waypoints[g_menu_waypoint].flags &= ~W_FL_TFC_DEFEND;  // off
					else
					{
						waypoints[g_menu_waypoint].flags |= W_FL_TFC_DEFEND;  // on
						WaypointAddAiming(pEntity);
					}
				}
				else if (FStrEq(arg1, "5"))  // set 180 sentry
				{
					if (waypoints[g_menu_waypoint].flags & W_FL_TFC_DEFEND)
					{					
						if (waypoints[g_menu_waypoint].flags & W_FL_TFC_DEFEND180)
							waypoints[g_menu_waypoint].flags &= ~W_FL_TFC_DEFEND180;  // off
						else
						{
							waypoints[g_menu_waypoint].flags |= W_FL_TFC_DEFEND180;  // on
						}
					} else
					{
						ClientPrint(pEntity, HUD_PRINTNOTIFY, "This MUST be placed on an existing sentry waypoint\n");
					}
				}
				else if (FStrEq(arg1, "6"))  // set to teleport entrance
				{
					if (waypoints[g_menu_waypoint].flags & W_FL_TFC_TELEPORTER_ENTRANCE)
						waypoints[g_menu_waypoint].flags &= ~W_FL_TFC_TELEPORTER_ENTRANCE;  // off
					else
					{
						waypoints[g_menu_waypoint].flags |= W_FL_TFC_TELEPORTER_ENTRANCE;  // on
						WaypointAddAiming(pEntity);
					}					
				}
				else if (FStrEq(arg1, "7"))  // set to teleport exit
				{
					if (waypoints[g_menu_waypoint].flags & W_FL_TFC_TELEPORTER_EXIT)
						waypoints[g_menu_waypoint].flags &= ~W_FL_TFC_TELEPORTER_EXIT;  // off
					else
					{
						waypoints[g_menu_waypoint].flags |= W_FL_TFC_TELEPORTER_EXIT;  // on
						WaypointAddAiming(pEntity);
					}					
				}
			}
			else if (g_menu_state == MENU_6) // action tags p2
			{
				if (FStrEq(arg1, "1"))  // RJ CJ
				{
					if (waypoints[g_menu_waypoint].flags & W_FL_TFC_JUMP)
						waypoints[g_menu_waypoint].flags &= ~W_FL_TFC_JUMP;  // off
					else
						waypoints[g_menu_waypoint].flags |= W_FL_TFC_JUMP;  // on
				}
				else if (FStrEq(arg1, "2"))  // set jump
				{
					if (waypoints[g_menu_waypoint].flags & W_FL_JUMP)
						waypoints[g_menu_waypoint].flags &= ~W_FL_JUMP;  // off
					else
						waypoints[g_menu_waypoint].flags |= W_FL_JUMP;  // on
				}	

				else if (FStrEq(arg1, "3"))  // set detpack
				{
					if (waypoints[g_menu_waypoint].flags & W_FL_TFC_DEMO)
						waypoints[g_menu_waypoint].flags &= ~W_FL_TFC_DEMO;  // off
					else
						waypoints[g_menu_waypoint].flags |= W_FL_TFC_DEMO;  // on
				}
				else if (FStrEq(arg1, "4"))  // wait for lift...
				{
					if (waypoints[g_menu_waypoint].flags & W_FL_LIFT)
						waypoints[g_menu_waypoint].flags &= ~W_FL_LIFT;  // off
					else
						waypoints[g_menu_waypoint].flags |= W_FL_LIFT;  // on
				}
				else if (FStrEq(arg1, "5"))  // walk waypoint
				{
					if (waypoints[g_menu_waypoint].flags & W_FL_DOOR)
						waypoints[g_menu_waypoint].flags &= ~W_FL_DOOR;  // off
					else
						waypoints[g_menu_waypoint].flags |= W_FL_DOOR;  // on
				}
			}
			else if (g_menu_state == MENU_7)  // control point tags
			{
				if (FStrEq(arg1, "1"))  // point1
				{
					if (waypoints[g_menu_waypoint].flags & W_FL_POINT1)
						waypoints[g_menu_waypoint].flags &= ~W_FL_POINT1;  // off
					else
						waypoints[g_menu_waypoint].flags |= W_FL_POINT1;  // on
				}
				else if (FStrEq(arg1, "2"))  // point2
				{
					if (waypoints[g_menu_waypoint].flags & W_FL_POINT2)
						waypoints[g_menu_waypoint].flags &= ~W_FL_POINT2;  // off
					else
						waypoints[g_menu_waypoint].flags |= W_FL_POINT2;  // on
				}
				else if (FStrEq(arg1, "3"))  // point3
				{
					if (waypoints[g_menu_waypoint].flags & W_FL_POINT3)
						waypoints[g_menu_waypoint].flags &= ~W_FL_POINT3;  // off
					else
						waypoints[g_menu_waypoint].flags |= W_FL_POINT3;  // on
				}
				else if (FStrEq(arg1, "4"))  // point4
				{
					if (waypoints[g_menu_waypoint].flags & W_FL_POINT4)
						waypoints[g_menu_waypoint].flags &= ~W_FL_POINT4;  // off
					else
						waypoints[g_menu_waypoint].flags |= W_FL_POINT4;  // on
				}
				else if (FStrEq(arg1, "5"))  // point5
				{
					if (waypoints[g_menu_waypoint].flags & W_FL_POINT5)
						waypoints[g_menu_waypoint].flags &= ~W_FL_POINT5;  // off
					else
						waypoints[g_menu_waypoint].flags |= W_FL_POINT5;  // on
				}
				else if (FStrEq(arg1, "6"))  // point6
				{
					if (waypoints[g_menu_waypoint].flags & W_FL_POINT6)
						waypoints[g_menu_waypoint].flags &= ~W_FL_POINT6;  // off
					else
						waypoints[g_menu_waypoint].flags |= W_FL_POINT6;  // on
				}
				else if (FStrEq(arg1, "7"))  // point7
				{
					if (waypoints[g_menu_waypoint].flags & W_FL_POINT7)
						waypoints[g_menu_waypoint].flags &= ~W_FL_POINT7;  // off
					else
						waypoints[g_menu_waypoint].flags |= W_FL_POINT7;  // on
				}
				else if (FStrEq(arg1, "8"))  // point8
				{
					if (waypoints[g_menu_waypoint].flags & W_FL_POINT8)
						waypoints[g_menu_waypoint].flags &= ~W_FL_POINT8;  // off
					else
						waypoints[g_menu_waypoint].flags |= W_FL_POINT8;  // on
				}
				g_menu_state = MENU_NONE;
			}
			if(mr_meta) RETURN_META(MRES_SUPERCEDE);
			return;

		}
		else if (FStrEq(pcmd, "search"))
		{
			edict_t *pent = NULL;
			float radius = 50;
			char str[80];
			ClientPrint(pEntity, HUD_PRINTCONSOLE, "searching...\n");
			while ((pent = FIND_ENTITY_IN_SPHERE( pent, pEntity->v.origin, radius )) != NULL &&
				(!FNullEnt(pent)))
			{
				sprintf(str, "Found %s at %5.2f %5.2f %5.2f modelindex- %d t %s tn %s\n",
					STRING(pent->v.classname),
					pent->v.origin.x, pent->v.origin.y,
					pent->v.origin.z, pent->v.modelindex,
					STRING(pent->v.target),STRING(pent->v.targetname));
				ClientPrint(pEntity, HUD_PRINTCONSOLE, str);

				FILE *fp=fopen("bot.txt", "a");
				fprintf(fp, "ClientCommmand: search %s\n", str);
				//fwrite(&pent->v, sizeof(pent->v), 1, fp);
				fclose(fp);
				UTIL_SavePent(pent);
			}

			if(mr_meta) RETURN_META(MRES_SUPERCEDE);
			return;
		}
		// DREVIL CVARS
		else if (FStrEq(pcmd, "defensive_chatter"))
		{
			if (FStrEq(arg1, "on"))
			{
				defensive_chatter = TRUE;
				ClientPrint(pEntity, HUD_PRINTNOTIFY, "Defensive Chatter is ON\n");
			}
			else if (FStrEq(arg1, "off"))
			{
				defensive_chatter = FALSE;
				ClientPrint(pEntity, HUD_PRINTNOTIFY, "Defensive Chatter is OFF\n");
			}
			else if (FStrEq(arg1, "1"))
			{
				defensive_chatter = TRUE;
				ClientPrint(pEntity, HUD_PRINTNOTIFY, "Defensive Chatter is ON\n");
			}
			else if (FStrEq(arg1, "0"))
			{
				defensive_chatter = FALSE;
				ClientPrint(pEntity, HUD_PRINTNOTIFY, "Defensive Chatter is OFF\n");
			}
			return;
		} 
		else if (FStrEq(pcmd, "offensive_chatter"))
		{
			if (FStrEq(arg1, "on"))
			{
				offensive_chatter = TRUE;
				ClientPrint(pEntity, HUD_PRINTNOTIFY, "Offensive Chatter is ON\n");
			}
			else if (FStrEq(arg1, "off"))
			{
				offensive_chatter = FALSE;
				ClientPrint(pEntity, HUD_PRINTNOTIFY, "Offensive Chatter is OFF\n");
			}
			else if (FStrEq(arg1, "1"))
			{
				offensive_chatter = TRUE;
				ClientPrint(pEntity, HUD_PRINTNOTIFY, "Offensive Chatter is ON\n");
			}
			else if (FStrEq(arg1, "0"))
			{
				offensive_chatter = FALSE;
				ClientPrint(pEntity, HUD_PRINTNOTIFY, "Offensive Chatter is OFF\n");
			}
			return;
		} 
		else if (FStrEq(pcmd, "frag_commander"))
		{
			if (FStrEq(arg1, "on"))
			{
				frag_commander = TRUE;
				ClientPrint(pEntity, HUD_PRINTNOTIFY, "Score-based commander is ON\n");
			}
			else if (FStrEq(arg1, "off"))
			{
				frag_commander = FALSE;
				ClientPrint(pEntity, HUD_PRINTNOTIFY, "Score-based commander is OFF\n");
			}
			else if (FStrEq(arg1, "1"))
			{
				frag_commander = TRUE;
				ClientPrint(pEntity, HUD_PRINTNOTIFY, "Score-based commander is ON\n");
			}
			else if (FStrEq(arg1, "0"))
			{
				frag_commander = FALSE;
				ClientPrint(pEntity, HUD_PRINTNOTIFY, "Score-based commander is OFF\n");
			}
			return;
		} 
	}

	if(!mr_meta)
		(*other_gFunctionTable.pfnClientCommand)(pEntity);
	else
	{
		SET_META_RESULT(MRES_HANDLED);
	}
}

void ClientUserInfoChanged( edict_t *pEntity, char *infobuffer )
{
	if (debug_engine) { fp=fopen("bot.txt", "a"); fprintf(fp, "ClientUserInfoChanged: pEntity=%x infobuffer=%s\n", pEntity, infobuffer); fclose(fp); }

	if(!mr_meta)
		(*other_gFunctionTable.pfnClientUserInfoChanged)(pEntity, infobuffer);
	else
		SET_META_RESULT(MRES_HANDLED);
}

void ServerActivate( edict_t *pEdictList, int edictCount, int clientMax )
{
	if(!mr_meta)
		(*other_gFunctionTable.pfnServerActivate)(pEdictList, edictCount, clientMax);
	else
		SET_META_RESULT(MRES_HANDLED);
}

void ServerDeactivate( void )
{
	if(!mr_meta)
		(*other_gFunctionTable.pfnServerDeactivate)();
	else
		SET_META_RESULT(MRES_HANDLED);
}

void PlayerPreThink( edict_t *pEntity )
{
	if(!mr_meta)
		(*other_gFunctionTable.pfnPlayerPreThink)(pEntity);
	else
		SET_META_RESULT(MRES_HANDLED);
}

void PlayerPostThink( edict_t *pEntity )
{
	if(!mr_meta)
		(*other_gFunctionTable.pfnPlayerPostThink)(pEntity);
	else
		SET_META_RESULT(MRES_HANDLED);
}

void StartFrame( void )
{
	//v7 last frame timing
	last_frame_time=last_frame_time_prev;
	last_frame_time_prev=gpGlobals->time;

	// Reset pipeCheck frame counter.
	if (pipeCheckFrame < 0)
		pipeCheckFrame = 20;

	//if (debug_engine) { fp=fopen("bot.txt", "a"); fprintf(fp, "StartFrame\n"); fclose(fp); }
	if (gpGlobals->deathmatch)
	{
		edict_t *pPlayer;
		static float check_server_cmd;
		check_server_cmd = gpGlobals->time;
		static int i, index, player_index, bot_index;
		static float previous_time = -1.0;
		static float client_update_time = 0.0;
		clientdata_s cd;
		char msg[256];
		int count;

		// if a new map has started then (MUST BE FIRST IN StartFrame)...
		//if ((gpGlobals->time + 0.1) < previous_time)
		if(strcmp(STRING(gpGlobals->mapname),prevmapname)!=0)
		{
			//for(int i=0;i<32;i++)
			//clients[i] = NULL;
			//if (debug_engine) { fp=fopen("bot.txt", "a"); fprintf(fp, "StartFrame-new map\n"); fclose(fp); }
			char filename[256];
			char mapname[64];

			first_player = NULL;
			display_bot_vars=TRUE;
			display_start_time=gpGlobals->time+10;

			need_to_open_cfg=TRUE;

			// check if mapname_bot.cfg file exists...

			if ((gpGlobals->time + 0.1) < previous_time)
			{
				strcpy(mapname, STRING(gpGlobals->mapname));
				strcat(mapname, "_bot.cfg");

				bot_cfg_fp=NULL;
				UTIL_BuildFileName(filename, "configs", mapname);
				bot_cfg_fp = fopen(filename, "r");


				if(bot_cfg_fp==NULL)
				{
					UTIL_BuildFileNameOld(filename, "maps", mapname);
					bot_cfg_fp = fopen(filename, "r");
				}
				if(bot_cfg_fp==NULL)
				{
					UTIL_BuildFileName(filename, "default.cfg", NULL);
					bot_cfg_fp = fopen(filename, "r");
				}
				if (bot_cfg_fp != NULL)
				{
					//sprintf(msg, "Executing %s\n", filename);
					//ALERT( at_console, msg );

					for (index = 0; index < 32; index++)
					{
						bots[index].is_used = FALSE;
						bots[index].respawn_state = 0;
						bots[index].kick_time = 0.0;
					}
					fclose(bot_cfg_fp);
					bot_cfg_fp=NULL;
				}
				else
				{
					count = 0;
					// mark the bots as needing to be respawned...
					for (index = 0; index < 32; index++)
					{
						if (count >= prev_num_bots)
						{
							bots[index].is_used = FALSE;
							bots[index].respawn_state = 0;
							bots[index].kick_time = 0.0;
						}

						if (bots[index].is_used)  // is this slot used?
						{
							bots[index].respawn_state = RESPAWN_NEED_TO_RESPAWN;
							count++;
						}

						// check for any bots that were very recently kicked...
						if ((bots[index].kick_time + 5.0) > previous_time)
						{
							bots[index].respawn_state = RESPAWN_NEED_TO_RESPAWN;
							count++;
						}
						else
							bots[index].kick_time = 0.0;  // reset to prevent false spawns later
					}

					// set the respawn time
					if (IS_DEDICATED_SERVER())
						respawn_time = gpGlobals->time + 10.0;
					else
						respawn_time = gpGlobals->time + 20.0;
				}
			}

			client_update_time = gpGlobals->time + 10.0;  // start updating client data again

			bot_check_time = gpGlobals->time + 30.0;
		}

		//end of config map check stuff.

		if (!IS_DEDICATED_SERVER())
		{
			if ((welcome_index != -1) && (welcome_sent == FALSE) &&
				(welcome_time < 1.0))
			{
				// are they out of observer mode yet?
				if(clients[welcome_index]!=NULL)
				{
					if (IsAlive(clients[welcome_index]))
						welcome_time = gpGlobals->time + 5.0;  // welcome in 5 seconds
				}
			}

			if ((welcome_time > 0.0) && (welcome_time < gpGlobals->time) &&
				(welcome_sent == FALSE))
			{
				char version[20];

				//sprintf(version," Beta v%d.%d Build#%d\n", VER_MAJOR, VER_MINOR, VER_BUILD);
				sprintf(version," v%d.%d \n", VER_MAJOR, VER_MINOR);
				strcat(welcome_msg, version);
				// let's send a welcome message to this client...
				//UTIL_SayText(welcome_msg, clients[welcome_index]);

				KewlHUDNotify(clients[welcome_index],welcome_msg);
				welcome_sent = TRUE;  // clear this so we only do it once
			}
		}

		if (client_update_time <= gpGlobals->time)
		{
			//if (debug_engine) { fp=fopen("bot.txt", "a"); fprintf(fp, "clientupdate\n"); fclose(fp); }
			client_update_time = gpGlobals->time + 1.0;

			for (i=0; i < 32; i++)
			{
				if (bots[i].is_used)
				{
					memset(&cd, 0, sizeof(cd));

					if(mr_meta) MDLL_UpdateClientData( bots[i].pEdict, 1, &cd );
					else UpdateClientData( bots[i].pEdict, 1, &cd );

					// see if a weapon was dropped...
					if (bots[i].bot_weapons != cd.weapons)
					{
						bots[i].bot_weapons = cd.weapons;
					}
				}
			}
		}


		count = 0;

		for (bot_index = 0; bot_index < gpGlobals->maxClients; bot_index++)
		{
			if ((bots[bot_index].is_used) &&  // is this slot used AND
				(bots[bot_index].respawn_state == RESPAWN_IDLE))  // not respawning
			{
				BotThink(&bots[bot_index]);

				count++;

				if ((mod_id == FRONTLINE_DLL) && (flf_bug_check == 0))
				{
					edict_t *pent = NULL;
					int fix_flag = 0;

					flf_bug_check = 1;

					while ((pent = FIND_ENTITY_BY_CLASSNAME( pent, "capture_point" )) != NULL &&
						(!FNullEnt(pent)))
					{
						if (pent->v.skin != 0)  // not blue skin?
						{
							flf_bug_fix = 1;  // need to use bug fix code
						}
					}
				}
			}
		}

		if (count > num_bots)
			num_bots = count;

		for (player_index = 1; player_index <= gpGlobals->maxClients; player_index++)
		{
			pPlayer = INDEXENT(player_index);

			if (pPlayer && !pPlayer->free)
			{
				if ((g_area_def || g_waypoint_on) && FBitSet(pPlayer->v.flags, FL_CLIENT))
				{
					WaypointThink(pPlayer);
				}

				if ((mod_id == FRONTLINE_DLL) && (flf_bug_check == 0))
				{
					edict_t *pent = NULL;
					int fix_flag = 0;

					flf_bug_check = 1;

					while ((pent = FIND_ENTITY_BY_CLASSNAME( pent, "capture_point" )) != NULL &&
						(!FNullEnt(pent)))
					{
						if (pent->v.skin != 0)  // not blue skin?
						{
							flf_bug_fix = 1;  // need to use bug fix code
						}
					}
				}
			}
		}

		// are we currently respawning bots and is it time to spawn one yet?
		if ((respawn_time > 1.0) && (respawn_time <= gpGlobals->time))
		{
			int index = 0;

			// find bot needing to be respawned...
			while ((index < 32) &&
				(bots[index].respawn_state != RESPAWN_NEED_TO_RESPAWN))
				index++;

			if (index < 32)
			{
				bots[index].respawn_state = RESPAWN_IS_RESPAWNING;
				bots[index].is_used = FALSE;      // free up this slot

				// respawn 1 bot then wait a while (otherwise engine crashes)
				if ((mod_id == VALVE_DLL) ||
					((mod_id == GEARBOX_DLL) && (pent_info_ctfdetect == NULL)))
				{
					char c_skill[2];

					sprintf(c_skill, "%d", bots[index].bot_skill);

					BotCreate(NULL, bots[index].skin, bots[index].name, c_skill, NULL);
				}
				else
				{
					char c_skill[2];
					char c_team[2];
					char c_class[3];

					sprintf(c_skill, "%d", bots[index].bot_skill);
					sprintf(c_team, "%d", bots[index].bot_team);
					sprintf(c_class, "%d", bots[index].bot_class);

					if ((mod_id == TFC_DLL) || (mod_id == GEARBOX_DLL))
						BotCreate(NULL, NULL, NULL, bots[index].name, c_skill);
					else
						BotCreate(NULL, c_team, c_class, bots[index].name, c_skill);
				}

				respawn_time = gpGlobals->time + 2.0;  // set next respawn time

				bot_check_time = gpGlobals->time + 5.0;
			}
			else
			{
				respawn_time = 0.0;
			}
		}

		if (g_GameRules)
		{
			if (need_to_open_cfg)  // have we open foxbot.cfg file yet?
			{
				//if (debug_engine) { fp=fopen("bot.txt", "a"); fprintf(fp, "StartFrame-opening foxbot.cfg\n"); fclose(fp); }
				char filename[256];
				char mapname[64];

				need_to_open_cfg = FALSE;  // only do this once!!!
				cfg_file=1;
				display_bot_vars=TRUE;
				display_start_time=gpGlobals->time+10;

				// check if mapname_bot.cfg file exists...

				strcpy(mapname, STRING(gpGlobals->mapname));
				strcat(mapname, "_bot.cfg");

				bot_cfg_fp=NULL;
				UTIL_BuildFileName(filename, "foxbot.cfg", NULL);
				bot_cfg_fp = fopen(filename, "r");

				if(bot_cfg_fp==NULL)
				{
					UTIL_BuildFileNameOld(filename, "foxbot.cfg", NULL);
					bot_cfg_fp = fopen(filename, "r");
				}

				if (bot_cfg_fp == NULL)
				{
					if (IS_DEDICATED_SERVER())
					{
						printf("foxbot.cfg file not found\n" );
					}
					else
						ALERT( at_console, "foxbot.cfg file not found\n" );
				}
				else
				{
					sprintf(msg, "Executing %s\n", filename);
					if (IS_DEDICATED_SERVER())
					{
						printf(msg);
					}
					else
						ALERT( at_console, msg );
				}

				if (IS_DEDICATED_SERVER())
					bot_cfg_pause_time = gpGlobals->time + 8.0; //was 5
				else
					bot_cfg_pause_time = gpGlobals->time + 8.0; //was 20
			}

			if (need_to_open_cfg2)  // have we open foxbot.cfg file yet?
			{
				bot_cfg_pause_time = gpGlobals->time+1;
				char filename[256];
				char mapname[64];

				need_to_open_cfg2 = FALSE;  // only do this once!!!
				cfg_file=2;
				//display_bot_vars=TRUE;
				//display_start_time=gpGlobals->time+10;

				// check if mapname_bot.cfg file exists...

				strcpy(mapname, STRING(gpGlobals->mapname));
				strcat(mapname, "_bot.cfg");

				bot_cfg_fp=NULL;
				UTIL_BuildFileName(filename, "configs", mapname);
				bot_cfg_fp = fopen(filename, "r");

				if(bot_cfg_fp==NULL)
				{
					UTIL_BuildFileNameOld(filename, "maps", mapname);
					bot_cfg_fp = fopen(filename, "r");
				}

				if ( bot_cfg_fp!= NULL)
				{
					sprintf(msg, "\nExecuting %s\n", filename);
					if (IS_DEDICATED_SERVER())
					{
						printf(msg);
					}
					else
						ALERT( at_console, msg );
				}
				else
				{
					//first say map config not found
					sprintf(msg, "\n%s not found\n", filename);
					if (IS_DEDICATED_SERVER())
					{
						printf(msg);
					}
					else
						ALERT( at_console, msg );

					bot_cfg_fp=NULL;
					UTIL_BuildFileName(filename, "default.cfg", NULL);
					bot_cfg_fp = fopen(filename, "r");

					if (bot_cfg_fp == NULL)
					{
						if (IS_DEDICATED_SERVER())
						{
							printf("\ndefault.cfg file not found\n" );
						}
						else
							ALERT( at_console, "\ndefault.cfg file not found\n" );
					}
					else
					{
						sprintf(msg, "\nExecuting %s\n", filename);
						if (IS_DEDICATED_SERVER())
						{
							printf(msg);
						}
						else
							ALERT( at_console, msg );
					}
				}
			}

			//end need config

			if (!IS_DEDICATED_SERVER() && !spawn_time_reset)
			{
				if (first_player != NULL)
				{
					if (IsAlive(first_player))
					{
						spawn_time_reset = TRUE;

						if (respawn_time >= 1.0)
							respawn_time = min(respawn_time, gpGlobals->time + (float)1.0);

						if (bot_cfg_pause_time >= 1.0)
							bot_cfg_pause_time = min(bot_cfg_pause_time, gpGlobals->time + (float)1.0);
					}
				}
			}
			if (//(bot_cfg_fp) &&
				(bot_cfg_pause_time >= 1.0) && (bot_cfg_pause_time <= gpGlobals->time))
			{
				// process bot.cfg file options...
				ProcessBotCfgFile();
				display_start_time=0;
			}
			else if(bot_cfg_fp==NULL && display_bot_vars && display_start_time<=gpGlobals->time)
			{
				DisplayBotInfo();
				display_bot_vars=FALSE;
			}
		}      

		// if time to check for server commands then do so...
		if ((check_server_cmd <= gpGlobals->time) && IS_DEDICATED_SERVER())
		{
			check_server_cmd = gpGlobals->time + 1.0;

			char *cvar_bot = (char *)CVAR_GET_STRING( "bot" );

			if ( cvar_bot && cvar_bot[0] )
			{
				char cmd_line[80];
				char *cmd, *arg1, *arg2, *arg3, *arg4;

				strcpy(cmd_line, cvar_bot);

				index = 0;
				cmd = cmd_line;
				arg1 = arg2 = arg3 = arg4 = NULL;

				// skip to blank or end of string...
				while ((cmd_line[index] != ' ') && (cmd_line[index] != 0))
					index++;

				if (cmd_line[index] == ' ')
				{
					cmd_line[index++] = 0;
					arg1 = &cmd_line[index];

					// skip to blank or end of string...
					while ((cmd_line[index] != ' ') && (cmd_line[index] != 0))
						index++;

					if (cmd_line[index] == ' ')
					{
						cmd_line[index++] = 0;
						arg2 = &cmd_line[index];

						// skip to blank or end of string...
						while ((cmd_line[index] != ' ') && (cmd_line[index] != 0))
							index++;

						if (cmd_line[index] == ' ')
						{
							cmd_line[index++] = 0;
							arg3 = &cmd_line[index];

							// skip to blank or end of string...
							while ((cmd_line[index] != ' ') && (cmd_line[index] != 0))
								index++;

							if (cmd_line[index] == ' ')
							{
								cmd_line[index++] = 0;
								arg4 = &cmd_line[index];
							}
						}
					}
				}

				if (strcmp(cmd, "addbot") == 0)
				{
					BotCreate( NULL, arg1, arg2, arg3, arg4 );

					bot_check_time = gpGlobals->time + 5.0;
				}
				else if (strcmp(cmd, "min_bots") == 0)
				{
					if(arg1!=NULL)
					{
						min_bots = atoi( arg1 );

						if ((min_bots < -1) || (min_bots > 31))
							min_bots = 1;

						sprintf(msg, "min_bots set to %d\n", min_bots);
					}
					else
						sprintf(msg, "min_bots is %d\n", min_bots);
					printf(msg);
				}
				else if (strcmp(cmd, "max_bots") == 0)
				{
					if(arg1!=NULL)
					{
						max_bots = atoi( arg1 );

						if ((max_bots < -1) || (max_bots > 31)) 
							max_bots = 1;

						sprintf(msg, "max_bots set to %d\n", max_bots);
					}
					else
						sprintf(msg, "max_bots is %d\n", max_bots);
					printf(msg);
				}
				else if (strcmp(cmd, "bot_info") == 0)
				{
					DisplayBotInfo();
				}
				else if (strcmp(cmd, "bot_team_balance")==0)
				{
					if ((arg1 != NULL))
					{
						if((*arg1 != 0))
						{
							int temp = atoi(arg1);
							if (temp)
								bot_team_balance = TRUE;
							else
								bot_team_balance = FALSE;
						}
					}

					if (bot_team_balance)
						printf("bot_team_balance (1) On\n");
					else
						printf("bot_team_balance (0) Off\n");
				}
				else if (strcmp(cmd, "bot_bot_balance")==0)
				{
					if ((arg1 != NULL))
					{
						if((*arg1 != 0))
						{
							int temp = atoi(arg1);
							if (temp)
								bot_bot_balance = TRUE;
							else
								bot_bot_balance = FALSE;
						}
					}

					if (bot_bot_balance)
						printf("bot_bot_balance (1) On\n");
					else
						printf("bot_bot_balance (0) Off\n");
				}
				else if (strcmp(cmd, "kickall") == 0)
				{
					// kick any bot off of the server after time/frag limit...
					for (int index = 0; index < 32; index++)
					{
						if (bots[index].is_used)  // is this slot used?
						{
							char cmd[40];

							sprintf(cmd, "kick \"%s\"\n", bots[index].name);
							SERVER_COMMAND(cmd);  // kick the bot using (kick "name")
							bots[index].sg=false;
							b_team[index]=-1;
							b_class[index]=-1;
							bots[index].sg = false;
							bots[index].sg_edict = NULL;							
							bots[index].sg_wp = -1;
							bots[index].SGRotated = false;
							bots[index].is_used=false;
						}
					}
				}
				else if ((strcmp(cmd, "kickteam") == 0) || (strcmp(cmd, "foxbot_kickteam") == 0))
				{
					if (!arg1)
						printf("Use proper syntax: bot \"kickteam 1\"\n");
					else
					{
						int whichTeam;
						if ((strcmp(arg1, "blue") == 0))
							whichTeam = 1;
						else if ((strcmp(arg1, "red") == 0))
							whichTeam = 2;
						else if ((strcmp(arg1, "yellow") == 0))
							whichTeam = 3;
						else if ((strcmp(arg1, "green") == 0))
							whichTeam = 4;
						else
							whichTeam = atoi(arg1);
						for (int index = 0; index < 32; index++)
						{
							if (bots[index].is_used)  // is this slot used?
							{
								char cmd[40];

								// skip teams that dont meet the argument.
								if (bots[index].bot_team != whichTeam)
									continue;

								sprintf(cmd, "kick \"%s\"\n", bots[index].name);

								SERVER_COMMAND(cmd);  // kick the bot using (kick "name")

								b_team[index]=-1;
								b_class[index]=-1;
								bots[index].sg = false;
								bots[index].sg_edict = NULL;							
								bots[index].sg_wp = -1;
								bots[index].SGRotated = false;
								bots[index].is_used=false;
							}
						}
					}					
				}
				else if (strcmp(cmd, "bot_chat") == 0 && arg1!=NULL)
				{
					if (strcmp(arg1, "on")==0)
					{
						b_botchat = TRUE;

						printf("bot chat is ON\n");
					}
					else if (strcmp(arg1, "off")==0)
					{
						b_botchat = FALSE;

						printf("bot chat is OFF\n");
					}
				}
				else if (strcmp(cmd, "botskill") == 0 && arg1!=NULL)
				{
					if ((arg1 != NULL))
					{
						if((*arg1 != 0))
						{
							int temp = atoi(arg1);

							if ((temp < 1) || (temp > 5))
								printf("invalid botskill value!\n");
							else
							{
								printf("botskill set to %d\n",temp);
								default_bot_skill = temp;
							}
						}
					}
				}
				else if (strcmp(cmd, "bot_xmas") == 0 && arg1!=NULL)
				{
					if (strcmp(arg1, "on")==0)
					{
						bot_xmas = TRUE;

						printf("bot xmas is ON\n");
					}
					else if (strcmp(arg1, "off")==0)
					{
						bot_xmas = FALSE;

						printf("bot xmas is OFF\n");
					}
				}
				else if (strcmp(cmd, "dump") == 0)
				{
					edict_t *pent=NULL;
					while ((pent = FIND_ENTITY_IN_SPHERE( pent,Vector(0,0,0), 8192 )) != NULL &&
						(!FNullEnt(pent)))
					{
						UTIL_SavePent(pent);
					}
				}
				//dedicated server input
			}
			// moved this line down one
			CVAR_SET_STRING("bot", "");
		}

		// check if time to see if a bot needs to be created...
		if (bot_check_time < gpGlobals->time)
		{
			//if (debug_engine) { fp=fopen("bot.txt", "a"); fprintf(fp, "StartFrame-min/max\n"); fclose(fp); }
			//min/max cheacking..
			//and team balance checking..
			teams[0]=0;
			teams[1]=0;
			teams[2]=0;
			teams[3]=0;
			if(max_bots>32) max_bots=32;
			if(max_bots>gpGlobals->maxClients) max_bots=gpGlobals->maxClients;
			if(max_bots<-1) max_bots=-1;
			if(min_bots>max_bots) min_bots=max_bots;
			if(min_bots<-1) min_bots=-1;	
			if(min_bots==0) min_bots=-1;
			int count = 0;

			bot_check_time = gpGlobals->time + 5.0;

			for (i = 1; i <= 32; i++) //<32
			{
				if(INDEXENT(i)!=NULL)
				{
					char *infobuffer;
					char cl_name[128];
					cl_name[0]=NULL;
					infobuffer = (*g_engfuncs.pfnGetInfoKeyBuffer)(INDEXENT(i));
					strcpy(cl_name,g_engfuncs.pfnInfoKeyValue(infobuffer, "name"));
					//{ fp=fopen("bot.txt","a"); fprintf(fp,"cl %d name %s\n",i,cl_name); fclose(fp); }
					if(cl_name[0]!=NULL)
					{
						count++;
						int team=(INDEXENT(i)->v.team)-1;
						if(team>=0 && team<4) 
						{
							teams[team]=teams[team]+1;
							//count++;
						}
					}
				}
			}

			//sort out is_team, just incase the map ents r fucked
			bool i_t=false;
			for(i=0;i<4;i++)
			{
				if(is_team[i]) i_t=true;
			}
			if(!i_t)
			{
				is_team[0]=true;
				is_team[1]=true;
				is_team[2]=false;
				is_team[3]=false;
			}
			if(is_team[2]==false && is_team[3]==true)
				is_team[3]=false;
			if(mod_id==TFC_DLL && bot_team_balance && !bot_bot_balance)
			{
				bool done=false;
				//team 1 has more than team 2?
				done=BotBalanceTeams(1,2);
				if(!done) done=BotBalanceTeams(1,3);
				if(!done) done=BotBalanceTeams(1,4);

				if(!done) done=BotBalanceTeams(2,1);
				if(!done) done=BotBalanceTeams(2,3);
				if(!done) done=BotBalanceTeams(2,4);

				if(!done) done=BotBalanceTeams(3,1);
				if(!done) done=BotBalanceTeams(3,2);
				if(!done) done=BotBalanceTeams(3,4);

				if(!done) done=BotBalanceTeams(4,1);
				if(!done) done=BotBalanceTeams(4,2);
				if(!done) done=BotBalanceTeams(4,3);
			}
			if(mod_id==TFC_DLL && bot_bot_balance)
			{
				bool done=false;
				//team 1 has more than team 2?
				done=BBotBalanceTeams(1,2);
				if(!done) done=BBotBalanceTeams(1,3);
				if(!done) done=BBotBalanceTeams(1,4);

				if(!done) done=BBotBalanceTeams(2,1);
				if(!done) done=BBotBalanceTeams(2,3);
				if(!done) done=BBotBalanceTeams(2,4);

				if(!done) done=BBotBalanceTeams(3,1);
				if(!done) done=BBotBalanceTeams(3,2);
				if(!done) done=BBotBalanceTeams(3,4);

				if(!done) done=BBotBalanceTeams(4,1);
				if(!done) done=BBotBalanceTeams(4,2);
				if(!done) done=BBotBalanceTeams(4,3);

				if(!done && bot_team_balance)
				{
					//balance the humans!
					//team 1 has more than team 2?
					done=HBalanceTeams(1,2);
					if(!done) done=HBalanceTeams(1,3);
					if(!done) done=HBalanceTeams(1,4);

					if(!done) done=HBalanceTeams(2,1);
					if(!done) done=HBalanceTeams(2,3);
					if(!done) done=HBalanceTeams(2,4);

					if(!done) done=HBalanceTeams(3,1);
					if(!done) done=HBalanceTeams(3,2);
					if(!done) done=HBalanceTeams(3,4);

					if(!done) done=HBalanceTeams(4,1);
					if(!done) done=HBalanceTeams(4,2);
					if(!done) done=HBalanceTeams(4,3);
				}
			}

			//random simulation of new clients joining/leaving
			//if(RANDOM_LONG(0,100)>95 && max_bots<14) max_bots++;
			//if(RANDOM_LONG(0,100)>95 && max_bots>8) max_bots--;
			// if there are currently less than the maximum number of "players"
			// then add another bot using the default skill level...
			if ((count < max_bots) && (max_bots != -1))
			{
				//{ fp=fopen("bot.txt","a"); fprintf(fp,"add: \n"); fclose(fp); }
				BotCreate( NULL, NULL, NULL, NULL, NULL );
			}
			// do bot max_bot kick here...
			// if there are currently more than the minimum number of bots running
			// then kick one of the bots off the server...
			if ((count > max_bots) && (max_bots != -1))
			{
				int cnt2=0;
				for (i=0;i<=31;i++)
				{
					if(bots[i].is_used) cnt2++;
				}
				if(cnt2>min_bots)
				{
					for (i=31; i >= 0; i--)
					{
						// && ((i+1)>=min_bots)
						if (bots[i].is_used)  // is this slot used?
						{
							char cmd[80];

							sprintf(cmd, "kick \"%s\"\n", bots[i].name);					  
							SERVER_COMMAND(cmd);  // kick the bot using (kick "name")
							b_team[i]=-1;
							b_class[i]=-1;
							bots[index].sg = false;
							bots[index].sg_edict = NULL;							
							bots[index].sg_wp = -1;
							bots[index].SGRotated = false;
							bots[i].is_used=false;
							break;
						}
					}
				}
			}
		}
		else if(bot_check_time > gpGlobals->time + 100.0)
			bot_check_time = gpGlobals->time + 10.0;


		previous_time = gpGlobals->time;
	}

	// this is where the behaviour config is interpreted..
	// i.e. new lev, load behaviour, and parse it

	if(strcmp(STRING(gpGlobals->mapname),prevmapname)!=0)
	{
		if (debug_engine) { fp=fopen("bot.txt", "a"); fprintf(fp, "StartFrame-my shiznit\n"); fclose(fp); }
		edict_t *pent = NULL;
		//while ((pent = FIND_ENTITY_BY_STRING( pent, "classname","trigger_multiple" )) != NULL &&
		//(!FNullEnt(pent)))
		while ((pent = FIND_ENTITY_IN_SPHERE( pent, Vector(0,0,0),8000 )) != NULL &&
			(!FNullEnt(pent)))
		{
			if(pent->v.absmin.x==-1 &&
				pent->v.absmin.y==-1 &&
				pent->v.absmin.z==-1)
			{
				if(pent->v.absmax.x==1 &&
					pent->v.absmax.y==1 &&
					pent->v.absmax.z==1)
				{
					{ fp=fopen("bot.txt", "a"); fprintf(fp, "Fixing entity current map %s last map %s\n",STRING(gpGlobals->mapname),prevmapname); fclose(fp); }
					//UTIL_SavePent(pent);
					if(strcmp(STRING(pent->v.classname),"info_tfgoal")!=0)
					{
						pent->v.absmin=pent->v.absmin+pent->v.mins;
						pent->v.absmax=pent->v.absmax+pent->v.maxs;
						if(mr_meta)
							MDLL_Spawn(pent);
						else
							DispatchSpawn(pent);
					}
					else //is info goal
					{
						int max=0;
						int t=0;
						t=pent->v.mins.x;
						if(t<0) t=-t;
						if(t>max) max=t;
						t=pent->v.mins.y;
						if(t<0) t=-t;
						if(t>max) max=t;
						t=pent->v.mins.z;
						if(t<0) t=-t;
						if(t>max) max=t;
						t=pent->v.maxs.x;
						if(t<0) t=-t;
						if(t>max) max=t;
						t=pent->v.maxs.y;
						if(t<0) t=-t;
						if(t>max) max=t;
						t=pent->v.maxs.z;
						if(t<0) t=-t;
						if(t>max) max=t;
						pent->v.absmin=pent->v.absmin-Vector(max,max,max);
						pent->v.absmax=pent->v.absmax+Vector(max,max,max);
						pent->v.nextthink=0;
						if(mr_meta)
							MDLL_Spawn(pent);
						else
							DispatchSpawn(pent);
						//UTIL_SavePent(pent);
					}
				}
			}
			//UTIL_SavePent(pent);
			if(strcmp(STRING(pent->v.classname),"func_door")==0 &&
				pent->v.nextthink!=-1)
				pent->v.nextthink=-1;
		}
		script_loaded=FALSE;
		script_parsed=FALSE;
		strcpy(prevmapname,STRING(gpGlobals->mapname));
		char filename[256];
		char mapname[64];

		int i,index;
		for(i=0;i<4;i++)
		{
			attack[i]=false;
			defend[i]=false;
			index=0;
			while(index<32)
			{
				drop_flag[index][i]=-1;
				drop_flage[index][i]=NULL;
				index++;
			}
		}
		for(i=0;i<8;i++)
		{
			blue_av[i]=false;
			red_av[i]=false;
			green_av[i]=false;
			yellow_av[i]=false;
		}
		//clear up all the model icons here!
		//don't remove them as the engine does this its self on a map change
		//just clear the pointers..doh!
		/*for(i=0; i<128; i++)
		{
		if(!mdlb[i])
		if(mdlp[i]!=NULL)
		{
		//REMOVE_ENTITY(mdlp[i]);
		mdlp[i]=NULL;
		mdlb[i]=true;
		}
		}*/
		//ok, do other level data clearing here!

		struct msg_com_struct *prev;
		struct msg_com_struct *curr;
		for(i=0;i<MSG_MAX;i++)
		{
			//assuming i only goes to 64 on next line..see msg_msg[64][msg_max]
			//was [0][i] before...may be a problem
			msg_msg[0][i]=NULL; //clear the messages, for level changes

			msg_com[i].ifs[0]=NULL;
			//the idea behind this delete function is
			// if the root.next isnt null, then
			// it finds the last item in list (the one with item.next =null)
			// and deletes it.. then repets it all again.. if root.next etc
			while(msg_com[i].next!=NULL)
			{
				curr=&msg_com[i];
				//{ fp=fopen("bot.txt", "a"); fprintf(fp, "StartFrame-del %d\n",curr->next); fclose(fp); }

				while(curr->next!=NULL && curr->next!=0 && (int)curr->next!=-1)
				{
					prev=curr;
					curr=curr->next;
				}
				delete prev->next;
				prev->next=NULL; // make sure it doesnt go over 
			}
			msg_com[i].next=NULL; // make sure it dont crash..gr
			//{ fp=fopen("bot.txt", "a"); fprintf(fp, "StartFrame-del %d\n",msg_com[i].next); fclose(fp); }
		}
		//{ fp=fopen("bot.txt", "a"); fprintf(fp, "StartFrame-made it past clear data\n"); fclose(fp); }

		// check if mapname_bot.cfg file exists...

		strcpy(mapname, STRING(gpGlobals->mapname));
		strcat(mapname, "_fb.cfg");

		FILE *bfp;

		UTIL_BuildFileName(filename, "scripts", mapname);
		bfp = fopen(filename, "r");

		if(bfp==NULL)
		{
			UTIL_BuildFileNameOld(filename, "maps", mapname);
			bfp = fopen(filename, "r");
		}

		if ((bfp != NULL) && mod_id==TFC_DLL)
		{
			script_loaded=TRUE;
			char msg[255];
			sprintf(msg, "\nExecuting FoXBot TFC behaviour file %s\n\n", filename);
			ALERT( at_console, msg );
			int ch;
			ch = fgetc(bfp);
			int i;
			char buffer[14097];
			for( i=0; (i < 14096 ) && ( feof( bfp ) == 0 ); i++ )
			{
				buffer[i] = (char)ch;
				if(buffer[i]=='\t') buffer[i]=' ';
				ch = fgetc( bfp );
			}
			buffer[i]=NULL;
			char *buf;
			//weve read it into buffer, now we need to check the syntax..
			// ooo lexical analysis, hehe
			int braces=0; // check for an even number of braces i.e. {..}
			bool commentline=false; //used to ignore comment lines
			int start=0; // used to check if were in a start section or not
			int havestart=0;
			int msgsection=0; // used to check if were in a message section section or not
			int ifsec=0; // used to check if were in an if statement
			buf=buffer;
			//ALERT( at_console, buf);
			//ALERT( at_console, "\n");
			bool random_shit_error=false;
			for( i=0; (i < 14096 ) && ( buffer[i]!=NULL ) && (!random_shit_error); i++ )
			{
				// first off.. need to ignore comment lines!
				if(strncmp(buf,"//",2)==0) 
				{
					commentline=true;
					i++;
					buf = _strinc(buf);
				}
				if(buffer[i]=='\n') commentline=false;
				if(commentline==false)
				{
					//need to check for section definition (on_...)
					if(strncmp(buf,"on_start",8)==0) 
					{
						if(start>0) start=99; //check for nested start defs
						else	start=1;
						if(havestart>0) havestart=99; //check for more than one on_start section
						else havestart=1;
						for(int j=0;j<8;j++)
						{
							i++;
							buf = _strinc(buf);
						}//try and move to end of on start
					}
					if(strncmp(buf,"on_msg",6)==0) 
					{
						if(msgsection>0) msgsection=99; //check for nested msg defs
						else	msgsection=1;
						for(int j=0;j<6;j++)
						{
							i++;
							buf = _strinc(buf);
						}//try and move to end of on_msg
						//now check input var!
						if(buffer[i]!='(') msgsection=99;
						//make sure it starts wif a (
						else
						{
							i++;
							buf = _strinc(buf);
							if(buffer[i]==')') msgsection=99;
							//make sure message isnt empty
							else
							{
								//if it isn't empty, move to end (ignore msg)
								while(buffer[i]!=')')
								{
									i++;
									buf = _strinc(buf);
								}
							}
						}
					}
					//attack
					else if(strncmp(buf,"blue_attack",11)==0) 
					{
						// this can only be in a section
						if(start==0 && msgsection==0) random_shit_error=true;
						for(int j=0;j<11;j++)
						{
							i++;
							buf = _strinc(buf);
							RoleStatus[0] = 90;
						}//move to end
					}
					else if(strncmp(buf,"red_attack",10)==0) 
					{
						// this can only be in a section
						if(start==0 && msgsection==0) random_shit_error=true;
						for(int j=0;j<10;j++)
						{
							i++;
							buf = _strinc(buf);
							RoleStatus[1] = 90;
						}//move to end
					}
					else if(strncmp(buf,"yellow_attack",13)==0) 
					{
						// this can only be in a section
						if(start==0 && msgsection==0) random_shit_error=true;
						for(int j=0;j<13;j++)
						{
							i++;
							buf = _strinc(buf);
							RoleStatus[3] = 90;
						}//move to end
					}
					else if(strncmp(buf,"green_attack",12)==0) 
					{
						// this can only be in a section
						if(start==0 && msgsection==0) random_shit_error=true;
						for(int j=0;j<12;j++)
						{
							i++;
							buf = _strinc(buf);
							RoleStatus[3] = 90;
						}//move to end
					}					

					//defend
					else if(strncmp(buf,"blue_defend",11)==0) 
					{
						// this can only be in a section
						if(start==0 && msgsection==0) random_shit_error=true;
						for(int j=0;j<11;j++)
						{
							i++;
							buf = _strinc(buf);
							RoleStatus[0] = 15;
						}//move to end
					}
					else if(strncmp(buf,"red_defend",10)==0) 
					{
						// this can only be in a section
						if(start==0 && msgsection==0) random_shit_error=true;
						for(int j=0;j<10;j++)
						{
							i++;
							buf = _strinc(buf);
							RoleStatus[1] = 15;
						}//move to end
					}
					else if(strncmp(buf,"yellow_defend",13)==0) 
					{
						// this can only be in a section
						if(start==0 && msgsection==0) random_shit_error=true;
						for(int j=0;j<13;j++)
						{
							i++;
							buf = _strinc(buf);
							RoleStatus[2] = 15;
						}//move to end
					}
					else if(strncmp(buf,"green_defend",12)==0) 
					{
						// this can only be in a section
						if(start==0 && msgsection==0) random_shit_error=true;
						for(int j=0;j<12;j++)
						{
							i++;
							buf = _strinc(buf);
							RoleStatus[3] = 15;
						}//move to end
					}					
					else if(strncmp(buf,"blue_normal",11)==0) 
					{
						// this can only be in a section
						if(start==0 && msgsection==0) random_shit_error=true;
						for(int j=0;j<11;j++)
						{
							i++;
							buf = _strinc(buf);
							RoleStatus[0] = 50;
						}//move to end
					}
					else if(strncmp(buf,"red_normal",10)==0) 
					{
						// this can only be in a section
						if(start==0 && msgsection==0) random_shit_error=true;
						for(int j=0;j<10;j++)
						{
							i++;
							buf = _strinc(buf);
							RoleStatus[1] = 50;
						}//move to end
					}
					else if(strncmp(buf,"yellow_normal",13)==0) 
					{
						// this can only be in a section
						if(start==0 && msgsection==0) random_shit_error=true;
						for(int j=0;j<13;j++)
						{
							i++;
							buf = _strinc(buf);
							RoleStatus[2] = 50;
						}//move to end
					}
					else if(strncmp(buf,"green_normal",12)==0) 
					{
						// this can only be in a section
						if(start==0 && msgsection==0) random_shit_error=true;
						for(int j=0;j<12;j++)
						{
							i++;
							buf = _strinc(buf);
							RoleStatus[3] = 50;
						}//move to end
					}					

					//point<n> availabe_only (exclusive)
					else if(strncmp(buf,"blue_available_only_point",25)==0) 
					{
						// this can only be in a section
						if(start==0 && msgsection==0) random_shit_error=true;
						for(int j=0;j<25;j++)
						{
							i++;
							buf = _strinc(buf);
						}//move to end
						if(buffer[i]!='1' && buffer[i]!='2' && buffer[i]!='3' && buffer[i]!='4' && buffer[i]!='5' && 
							buffer[i]!='6' && buffer[i]!='7' && buffer[i]!='8') random_shit_error=true;
						else
						{
							i++;
							buf = _strinc(buf);
						}//move to end
					}
					else if(strncmp(buf,"red_available_only_point",24)==0) 
					{
						// this can only be in a section
						if(start==0 && msgsection==0) random_shit_error=true;
						for(int j=0;j<24;j++)
						{
							i++;
							buf = _strinc(buf);
						}//move to end
						if(buffer[i]!='1' && buffer[i]!='2' && buffer[i]!='3' && buffer[i]!='4' && buffer[i]!='5' && 
							buffer[i]!='6' && buffer[i]!='7' && buffer[i]!='8') random_shit_error=true;
						else
						{
							i++;
							buf = _strinc(buf);
						}//move to end
					}				   
					else if(strncmp(buf,"green_available_only_point",26)==0) 
					{
						// this can only be in a section
						if(start==0 && msgsection==0) random_shit_error=true;
						for(int j=0;j<26;j++)
						{
							i++;
							buf = _strinc(buf);
						}//move to end
						if(buffer[i]!='1' && buffer[i]!='2' && buffer[i]!='3' && buffer[i]!='4' && buffer[i]!='5' && 
							buffer[i]!='6' && buffer[i]!='7' && buffer[i]!='8') random_shit_error=true;
						else
						{
							i++;
							buf = _strinc(buf);
						}//move to end
					}				   
					else if(strncmp(buf,"yellow_available_only_point",27)==0) 
					{
						// this can only be in a section
						if(start==0 && msgsection==0) random_shit_error=true;
						for(int j=0;j<27;j++)
						{
							i++;
							buf = _strinc(buf);
						}//move to end
						if(buffer[i]!='1' && buffer[i]!='2' && buffer[i]!='3' && buffer[i]!='4' && buffer[i]!='5' && 
							buffer[i]!='6' && buffer[i]!='7' && buffer[i]!='8') random_shit_error=true;
						else
						{
							i++;
							buf = _strinc(buf);
						}//move to end
					}				   

					//point<n> availabe (set to true)
					else if(strncmp(buf,"blue_available_point",20)==0) 
					{
						// this can only be in a section
						if(start==0 && msgsection==0) random_shit_error=true;
						for(int j=0;j<20;j++)
						{
							i++;
							buf = _strinc(buf);
						}//move to end
						if(buffer[i]!='1' && buffer[i]!='2' && buffer[i]!='3' && buffer[i]!='4' && buffer[i]!='5' && 
							buffer[i]!='6' && buffer[i]!='7' && buffer[i]!='8') random_shit_error=true;
						else
						{
							i++;
							buf = _strinc(buf);
						}//move to end
					}
					else if(strncmp(buf,"red_available_point",19)==0) 
					{
						// this can only be in a section
						if(start==0 && msgsection==0) random_shit_error=true;
						for(int j=0;j<19;j++)
						{
							i++;
							buf = _strinc(buf);
						}//move to end
						if(buffer[i]!='1' && buffer[i]!='2' && buffer[i]!='3' && buffer[i]!='4' && buffer[i]!='5' && 
							buffer[i]!='6' && buffer[i]!='7' && buffer[i]!='8') random_shit_error=true;
						else
						{
							i++;
							buf = _strinc(buf);
						}//move to end
					}				   
					else if(strncmp(buf,"green_available_point",21)==0) 
					{
						// this can only be in a section
						if(start==0 && msgsection==0) random_shit_error=true;
						for(int j=0;j<21;j++)
						{
							i++;
							buf = _strinc(buf);
						}//move to end
						if(buffer[i]!='1' && buffer[i]!='2' && buffer[i]!='3' && buffer[i]!='4' && buffer[i]!='5' && 
							buffer[i]!='6' && buffer[i]!='7' && buffer[i]!='8') random_shit_error=true;
						else
						{
							i++;
							buf = _strinc(buf);
						}//move to end
					}				   
					else if(strncmp(buf,"yellow_available_point",22)==0) 
					{
						// this can only be in a section
						if(start==0 && msgsection==0) random_shit_error=true;
						for(int j=0;j<22;j++)
						{
							i++;
							buf = _strinc(buf);
						}//move to end
						if(buffer[i]!='1' && buffer[i]!='2' && buffer[i]!='3' && buffer[i]!='4' && buffer[i]!='5' && 
							buffer[i]!='6' && buffer[i]!='7' && buffer[i]!='8') random_shit_error=true;
						else
						{
							i++;
							buf = _strinc(buf);
						}//move to end
					}				   

					//point<n> not_availabe (set to false)
					else if(strncmp(buf,"blue_notavailable_point",23)==0) 
					{
						// this can only be in a section
						if(start==0 && msgsection==0) random_shit_error=true;
						for(int j=0;j<23;j++)
						{
							i++;
							buf = _strinc(buf);
						}//move to end
						if(buffer[i]!='1' && buffer[i]!='2' && buffer[i]!='3' && buffer[i]!='4' && buffer[i]!='5' && 
							buffer[i]!='6' && buffer[i]!='7' && buffer[i]!='8') random_shit_error=true;
						else
						{
							i++;
							buf = _strinc(buf);
						}//move to end
					}
					else if(strncmp(buf,"red_notavailable_point",22)==0) 
					{
						// this can only be in a section
						if(start==0 && msgsection==0) random_shit_error=true;
						for(int j=0;j<22;j++)
						{
							i++;
							buf = _strinc(buf);
						}//move to end
						if(buffer[i]!='1' && buffer[i]!='2' && buffer[i]!='3' && buffer[i]!='4' && buffer[i]!='5' && 
							buffer[i]!='6' && buffer[i]!='7' && buffer[i]!='8') random_shit_error=true;
						else
						{
							i++;
							buf = _strinc(buf);
						}//move to end
					}				   
					else if(strncmp(buf,"green_notavailable_point",24)==0) 
					{
						// this can only be in a section
						if(start==0 && msgsection==0) random_shit_error=true;
						for(int j=0;j<24;j++)
						{
							i++;
							buf = _strinc(buf);
						}//move to end
						if(buffer[i]!='1' && buffer[i]!='2' && buffer[i]!='3' && buffer[i]!='4' && buffer[i]!='5' && 
							buffer[i]!='6' && buffer[i]!='7' && buffer[i]!='8') random_shit_error=true;
						else
						{
							i++;
							buf = _strinc(buf);
						}//move to end
					}				   
					else if(strncmp(buf,"yellow_notavailable_point",25)==0) 
					{
						// this can only be in a section
						if(start==0 && msgsection==0) random_shit_error=true;
						for(int j=0;j<25;j++)
						{
							i++;
							buf = _strinc(buf);
						}//move to end
						if(buffer[i]!='1' && buffer[i]!='2' && buffer[i]!='3' && buffer[i]!='4' && buffer[i]!='5' && 
							buffer[i]!='6' && buffer[i]!='7' && buffer[i]!='8') random_shit_error=true;
						else
						{
							i++;
							buf = _strinc(buf);
						}//move to end
					}				   

					//is point<n> availabe?
					else if(strncmp(buf,"if_blue_point",13)==0) 
					{
						// this can only be in a section
						if(msgsection==0) random_shit_error=true;
						if(ifsec>0) ifsec=99; //check for nested if defs
						else	ifsec=1;
						for(int j=0;j<13;j++)
						{
							i++;
							buf = _strinc(buf);
						}//move to end
						if(buffer[i]!='1' && buffer[i]!='2' && buffer[i]!='3' && buffer[i]!='4' && buffer[i]!='5' && 
							buffer[i]!='6' && buffer[i]!='7' && buffer[i]!='8') random_shit_error=true;
						else
						{
							i++;
							buf = _strinc(buf);
						}//move to end
					}
					else if(strncmp(buf,"if_red_point",12)==0) 
					{
						// this can only be in a section
						if(msgsection==0) random_shit_error=true;
						if(ifsec>0) ifsec=99; //check for nested if defs
						else	ifsec=1;
						for(int j=0;j<12;j++)
						{
							i++;
							buf = _strinc(buf);
						}//move to end
						if(buffer[i]!='1' && buffer[i]!='2' && buffer[i]!='3' && buffer[i]!='4' && buffer[i]!='5' && 
							buffer[i]!='6' && buffer[i]!='7' && buffer[i]!='8') random_shit_error=true;
						else
						{
							i++;
							buf = _strinc(buf);
						}//move to end
					}				   
					else if(strncmp(buf,"if_green_point",14)==0) 
					{
						// this can only be in a section
						if(msgsection==0) random_shit_error=true;
						if(ifsec>0) ifsec=99; //check for nested if defs
						else	ifsec=1;
						for(int j=0;j<14;j++)
						{
							i++;
							buf = _strinc(buf);
						}//move to end
						if(buffer[i]!='1' && buffer[i]!='2' && buffer[i]!='3' && buffer[i]!='4' && buffer[i]!='5' && 
							buffer[i]!='6' && buffer[i]!='7' && buffer[i]!='8') random_shit_error=true;
						else
						{
							i++;
							buf = _strinc(buf);
						}//move to end
					}				   
					else if(strncmp(buf,"if_yellow_point",15)==0) 
					{
						// this can only be in a section
						if(msgsection==0) random_shit_error=true;
						if(ifsec>0) ifsec=99; //check for nested if defs
						else	ifsec=1;
						for(int j=0;j<15;j++)
						{
							i++;
							buf = _strinc(buf);
						}//move to end
						if(buffer[i]!='1' && buffer[i]!='2' && buffer[i]!='3' && buffer[i]!='4' && buffer[i]!='5' && 
							buffer[i]!='6' && buffer[i]!='7' && buffer[i]!='8') random_shit_error=true;
						else
						{
							i++;
							buf = _strinc(buf);
						}//move to end
					}				   

					//is point<n> NOT availabe?
					else if(strncmp(buf,"ifn_blue_point",14)==0) 
					{
						// this can only be in a section
						if(msgsection==0) random_shit_error=true;
						if(ifsec>0) ifsec=99; //check for nested if defs
						else	ifsec=1;
						for(int j=0;j<14;j++)
						{
							i++;
							buf = _strinc(buf);
						}//move to end
						if(buffer[i]!='1' && buffer[i]!='2' && buffer[i]!='3' && buffer[i]!='4' && buffer[i]!='5' && 
							buffer[i]!='6' && buffer[i]!='7' && buffer[i]!='8') random_shit_error=true;
						else
						{
							i++;
							buf = _strinc(buf);
						}//move to end
					}
					else if(strncmp(buf,"ifn_red_point",13)==0) 
					{
						// this can only be in a section
						if(msgsection==0) random_shit_error=true;
						if(ifsec>0) ifsec=99; //check for nested if defs
						else	ifsec=1;
						for(int j=0;j<13;j++)
						{
							i++;
							buf = _strinc(buf);
						}//move to end
						if(buffer[i]!='1' && buffer[i]!='2' && buffer[i]!='3' && buffer[i]!='4' && buffer[i]!='5' && 
							buffer[i]!='6' && buffer[i]!='7' && buffer[i]!='8') random_shit_error=true;
						else
						{
							i++;
							buf = _strinc(buf);
						}//move to end
					}				   
					else if(strncmp(buf,"ifn_green_point",15)==0) 
					{
						// this can only be in a section
						if(msgsection==0) random_shit_error=true;
						if(ifsec>0) ifsec=99; //check for nested if defs
						else	ifsec=1;
						for(int j=0;j<15;j++)
						{
							i++;
							buf = _strinc(buf);
						}//move to end
						if(buffer[i]!='1' && buffer[i]!='2' && buffer[i]!='3' && buffer[i]!='4' && buffer[i]!='5' && 
							buffer[i]!='6' && buffer[i]!='7' && buffer[i]!='8') random_shit_error=true;
						else
						{
							i++;
							buf = _strinc(buf);
						}//move to end
					}				   
					else if(strncmp(buf,"ifn_yellow_point",16)==0) 
					{
						// this can only be in a section
						if(msgsection==0) random_shit_error=true;
						if(ifsec>0) ifsec=99; //check for nested if defs
						else	ifsec=1;
						for(int j=0;j<16;j++)
						{
							i++;
							buf = _strinc(buf);
						}//move to end
						if(buffer[i]!='1' && buffer[i]!='2' && buffer[i]!='3' && buffer[i]!='4' && buffer[i]!='5' && 
							buffer[i]!='6' && buffer[i]!='7' && buffer[i]!='8') random_shit_error=true;
						else
						{
							i++;
							buf = _strinc(buf);
						}//move to end
					}				   

					//
					//multipoint ifs
					//
					else if(strncmp(buf,"if_blue_mpoint",14)==0) 
					{
						// this can only be in a section
						if(msgsection==0) random_shit_error=true;
						if(ifsec>0) ifsec=99; //check for nested if defs
						else	ifsec=1;
						int j;
						for(j=0;j<14;j++)
						{
							i++;
							buf = _strinc(buf);
						}//move to end
						//check for 8 if vals
						for(j=0;j<8;j++)
						{
							if(buffer[i]!='1' && buffer[i]!='0') random_shit_error=true;
							else
							{
								i++;
								buf = _strinc(buf);
							}//move to end
						}
					}
					else if(strncmp(buf,"if_red_mpoint",13)==0) 
					{
						// this can only be in a section
						if(msgsection==0) random_shit_error=true;
						if(ifsec>0) ifsec=99; //check for nested if defs
						else	ifsec=1;
						int j;
						for(j=0;j<13;j++)
						{
							i++;
							buf = _strinc(buf);
						}//move to end
						//check for 8 if vals
						for(j=0;j<8;j++)
						{
							if(buffer[i]!='1' && buffer[i]!='0') random_shit_error=true;
							else
							{
								i++;
								buf = _strinc(buf);
							}//move to end
						}
					}				   
					else if(strncmp(buf,"if_green_mpoint",15)==0) 
					{
						// this can only be in a section
						if(msgsection==0) random_shit_error=true;
						if(ifsec>0) ifsec=99; //check for nested if defs
						else	ifsec=1;
						int j;
						for(j=0;j<15;j++)
						{
							i++;
							buf = _strinc(buf);
						}//move to end
						//check for 8 if vals
						for(j=0;j<8;j++)
						{
							if(buffer[i]!='1' && buffer[i]!='0') random_shit_error=true;
							else
							{
								i++;
								buf = _strinc(buf);
							}//move to end
						}
					}				   
					else if(strncmp(buf,"if_yellow_mpoint",16)==0) 
					{
						// this can only be in a section
						if(msgsection==0) random_shit_error=true;
						if(ifsec>0) ifsec=99; //check for nested if defs
						else	ifsec=1;
						int j;
						for(j=0;j<16;j++)
						{
							i++;
							buf = _strinc(buf);
						}//move to end
						//check for 8 if vals
						for(j=0;j<8;j++)
						{
							if(buffer[i]!='1' && buffer[i]!='0') random_shit_error=true;
							else
							{
								i++;
								buf = _strinc(buf);
							}//move to end
						}
					}				   
					//end of multipoint ifs


					// ignore endlines
					// and comments
					else if((buffer[i]!='/' && buffer[i]!='{' && 
						buffer[i]!='}' && buffer[i]!=' ' && 
						buffer[i]!='\n') && commentline==false &&
						random_shit_error==false)
					{
						random_shit_error=true;
						ALERT( at_console, "\\/\\/\\/\\/\\/\\/\n");
						ALERT( at_console, buf);
						ALERT( at_console, "\n");
					}

					//do your magic lexical analysis here..
					//first braces
					switch(buffer[i])
					{
					case '{':
						braces++;
						if(start==1) start=2;
						else if(start>0) start=99;
						//need to check that more braces aernt put in than nesesarry
						// i.e. start=2 then generate error,
						//cus only have variable setting in start section
						if(ifsec==1) ifsec=2;
						else if(ifsec>0) ifsec=99;
						if(msgsection==1) msgsection=2;
						else if(msgsection>0 && ifsec==0) msgsection=99;
						break;
					case '}':
						braces--;
						if(start==2) start=0;
						if(msgsection==2 && ifsec==0) msgsection=0;
						if(ifsec==2) ifsec=0; //cancel ifs before ending message section
						break;
					};
				}
				if(!random_shit_error) buf = _strinc(buf); //like i++ but for stringcmp stuff
			}		   
			bool syntax_error;
			syntax_error=false;
			//syntax errors
			if(braces!=0) 
			{
				ALERT( at_console, "Syntax error, wrong number of braces\n");
				syntax_error=true;
			}
			if(start!=0)
			{
				ALERT( at_console, "Syntax error, on_start error\n");
				syntax_error=true;
			}
			if(msgsection!=0)
			{
				ALERT( at_console, "Syntax error, on_msg error\n");
				syntax_error=true;
			}
			if(ifsec!=0)
			{
				ALERT( at_console, "Syntax error, if error\n");
				syntax_error=true;
			}
			if(havestart>1)
			{
				ALERT( at_console, "Syntax error, more than 1 on_start\n");
				syntax_error=true;
			}
			if(random_shit_error) 
			{
				ALERT( at_console, "Syntax error, unrecognised command\n");
				syntax_error=true;
				FILE *fp;
				{ fp=fopen("bot.txt","a"); fprintf(fp,"Syntax error, unrecognised command\n%s\n",buf); fclose(fp); }
			}

			//warnings
			if(havestart==0) ALERT( at_console, "Warning, no on_start section\n");
			// after all the lexical stuff, if we dont have any errors
			// pass the text into the command data types for use
			if(syntax_error==false)
			{
				script_parsed=TRUE;
				//pass everything to data array
				bool pass_debug;
				pass_debug=true;
				ALERT( at_console, "Passing data to behaviour arrays\n\n");
				braces=0; // check for an even number of braces i.e. {..}
				commentline=false; //used to ignore comment lines
				start=0; // used to check if were in a start section or not
				havestart=0;
				msgsection=0; // used to check if were in a message section section or not
				ifsec=0; // used to check if were in an if statement
				buf=buffer;
				random_shit_error=false;
				int pnt;
				char msgtext[64];
				int cnt;
				int current_msg;
				current_msg=-1;
				for( i=0; (i < 14096 ) && ( buffer[i]!=NULL ); i++ )
				{
					// first off.. need to ignore comment lines!
					if(strncmp(buf,"//",2)==0) 
					{
						commentline=true;
						i++;
						buf = _strinc(buf);
					}
					if(buffer[i]=='\n') commentline=false;
					if(commentline==false)
					{
						//need to check for section definition (on_...)
						if(strncmp(buf,"on_start",8)==0) 
						{
							if(start>0) start=99; //check for nested start defs
							else	start=1;
							if(havestart>0) havestart=99; //check for more than one on_start section
							else havestart=1;
							for(int j=0;j<8;j++)
							{
								i++;
								buf = _strinc(buf);
							}//try and move to end of on start
						}
						if(strncmp(buf,"on_msg",6)==0) 
						{
							current_msg++;
							if(msgsection>0) msgsection=99; //check for nested msg defs
							else	msgsection=1;
							for(int j=0;j<6;j++)
							{
								i++;
								buf = _strinc(buf);
							}//try and move to end of on_msg
							//now check input var!
							if(buffer[i]!='(') msgsection=99;
							//make sure it starts wif a (
							else
							{
								i++;
								buf = _strinc(buf);
								if(buffer[i]==')') msgsection=99;
								//make sure message isnt empty
								else
								{
									cnt=0;
									//if it isn't empty, move to end (ignore msg)
									while(buffer[i]!=')')
									{
										msgtext[cnt]=buffer[i];
										cnt++;
										i++;
										buf = _strinc(buf);
									}
									msgtext[cnt]=NULL; // terminate string
									strcpy(msg_msg[current_msg],msgtext);
									//ALERT( at_console, msg_msg[current_msg]);
									// now we have the message, we should probably clear out
									// all the available data
									for(int i=0;i<8;i++)
									{
										msg_com[current_msg].blue_av[i]=-1;
										msg_com[current_msg].red_av[i]=-1;
										msg_com[current_msg].yellow_av[i]=-1;
										msg_com[current_msg].green_av[i]=-1;
									}
									//clear the next pointer to stop it craching out.
									msg_com[current_msg].next=NULL;
									curr=&msg_com[current_msg];
								}
							}
						}
						//attack
						else if(strncmp(buf,"blue_attack",11)==0) 
						{
							// this can only be in a section
							if(start==0 && msgsection==0) random_shit_error=true;
							for(int j=0;j<11;j++)
							{
								i++;
								buf = _strinc(buf);
							}//move to end
							attack[0]=true;
						}
						else if(strncmp(buf,"red_attack",10)==0) 
						{
							// this can only be in a section
							if(start==0 && msgsection==0) random_shit_error=true;
							for(int j=0;j<10;j++)
							{
								i++;
								buf = _strinc(buf);
							}//move to end
							attack[1]=true;
						}
						else if(strncmp(buf,"green_attack",12)==0) 
						{
							// this can only be in a section
							if(start==0 && msgsection==0) random_shit_error=true;
							for(int j=0;j<12;j++)
							{
								i++;
								buf = _strinc(buf);
							}//move to end
							attack[2]=true;
						}
						else if(strncmp(buf,"yellow_attack",13)==0) 
						{
							// this can only be in a section
							if(start==0 && msgsection==0) random_shit_error=true;
							for(int j=0;j<13;j++)
							{
								i++;
								buf = _strinc(buf);
							}//move to end
							attack[3]=true;
						}

						//defend
						else if(strncmp(buf,"blue_defend",11)==0) 
						{
							// this can only be in a section
							if(start==0 && msgsection==0) random_shit_error=true;
							for(int j=0;j<11;j++)
							{
								i++;
								buf = _strinc(buf);
							}//move to end
							defend[0]=true;
						}
						else if(strncmp(buf,"red_defend",10)==0) 
						{
							// this can only be in a section
							if(start==0 && msgsection==0) random_shit_error=true;
							for(int j=0;j<10;j++)
							{
								i++;
								buf = _strinc(buf);
							}//move to end
							defend[1]=true;
						}
						else if(strncmp(buf,"green_defend",12)==0) 
						{
							// this can only be in a section
							if(start==0 && msgsection==0) random_shit_error=true;
							for(int j=0;j<12;j++)
							{
								i++;
								buf = _strinc(buf);
							}//move to end
							defend[2]=true;
						}
						else if(strncmp(buf,"yellow_defend",13)==0) 
						{
							// this can only be in a section
							if(start==0 && msgsection==0) random_shit_error=true;
							for(int j=0;j<13;j++)
							{
								i++;
								buf = _strinc(buf);
							}//move to end
							defend[3]=true;
						}
						//normal (defend+attack)??
						//not used yet..

						else if(strncmp(buf,"blue_normal",11)==0) 
						{
							// this can only be in a section
							if(start==0 && msgsection==0) random_shit_error=true;
							for(int j=0;j<11;j++)
							{
								i++;
								buf = _strinc(buf);
							}//move to end
						}
						else if(strncmp(buf,"red_normal",10)==0) 
						{
							// this can only be in a section
							if(start==0 && msgsection==0) random_shit_error=true;
							for(int j=0;j<10;j++)
							{
								i++;
								buf = _strinc(buf);
							}//move to end
						}
						else if(strncmp(buf,"green_normal",12)==0) 
						{
							// this can only be in a section
							if(start==0 && msgsection==0) random_shit_error=true;
							for(int j=0;j<12;j++)
							{
								i++;
								buf = _strinc(buf);
							}//move to end
						}
						else if(strncmp(buf,"yellow_normal",13)==0) 
						{
							// this can only be in a section
							if(start==0 && msgsection==0) random_shit_error=true;
							for(int j=0;j<13;j++)
							{
								i++;
								buf = _strinc(buf);
							}//move to end
						}

						//point<n> availabe_only (exclusive)
						else if(strncmp(buf,"blue_available_only_point",25)==0) 
						{
							// this can only be in a section
							if(start==0 && msgsection==0) random_shit_error=true;
							for(int j=0;j<25;j++)
							{
								i++;
								buf = _strinc(buf);
							}//move to end
							if(buffer[i]!='1' && buffer[i]!='2' && buffer[i]!='3' && buffer[i]!='4' && buffer[i]!='5' && 
								buffer[i]!='6' && buffer[i]!='7' && buffer[i]!='8') random_shit_error=true;
							else
							{
								pnt=atoi(&buffer[i]); // get the var
								pnt--;
								i++;
								buf = _strinc(buf);
							}//move to end
							if(start==2)
							{
								for(int j=0;j<8;j++)
								{
									blue_av[j]=false;
								}
								blue_av[pnt]=true;
							}
							if(msgsection==2 && ifsec==0)
							{
								for(int j=0;j<8;j++)
								{
									msg_com[current_msg].blue_av[j]=0; //false
								}
								msg_com[current_msg].blue_av[pnt]=1; //true
							}
							if(msgsection==2 && ifsec==2)
							{
								for(int j=0;j<8;j++)
								{
									curr->blue_av[j]=0; //false
								}
								curr->blue_av[pnt]=1; //true
							}
						}
						else if(strncmp(buf,"red_available_only_point",24)==0) 
						{
							// this can only be in a section
							if(start==0 && msgsection==0) random_shit_error=true;
							for(int j=0;j<24;j++)
							{
								i++;
								buf = _strinc(buf);
							}//move to end
							if(buffer[i]!='1' && buffer[i]!='2' && buffer[i]!='3' && buffer[i]!='4' && buffer[i]!='5' && 
								buffer[i]!='6' && buffer[i]!='7' && buffer[i]!='8') random_shit_error=true;
							else
							{
								pnt=atoi(&buffer[i]); // get the var
								pnt--;
								i++;
								buf = _strinc(buf);
							}//move to end
							if(start==2)
							{
								for(int j=0;j<8;j++)
								{
									red_av[j]=false;
								}
								red_av[pnt]=true;
							}
							if(msgsection==2 && ifsec==0)
							{
								for(int j=0;j<8;j++)
								{
									msg_com[current_msg].red_av[j]=0; //false
								}
								msg_com[current_msg].red_av[pnt]=1; //true
							}
							if(msgsection==2 && ifsec==2)
							{
								for(int j=0;j<8;j++)
								{
									curr->red_av[j]=0; //false
								}
								curr->red_av[pnt]=1; //true
							}
						}				   
						else if(strncmp(buf,"green_available_only_point",26)==0) 
						{
							// this can only be in a section
							if(start==0 && msgsection==0) random_shit_error=true;
							for(int j=0;j<26;j++)
							{
								i++;
								buf = _strinc(buf);
							}//move to end
							if(buffer[i]!='1' && buffer[i]!='2' && buffer[i]!='3' && buffer[i]!='4' && buffer[i]!='5' && 
								buffer[i]!='6' && buffer[i]!='7' && buffer[i]!='8') random_shit_error=true;
							else
							{
								pnt=atoi(&buffer[i]); // get the var
								pnt--;
								i++;
								buf = _strinc(buf);
							}//move to end
							if(start==2)
							{
								for(int j=0;j<8;j++)
								{
									green_av[j]=false;
								}
								green_av[pnt]=true;
							}
							if(msgsection==2 && ifsec==0)
							{
								for(int j=0;j<8;j++)
								{
									msg_com[current_msg].green_av[j]=0; //false
								}
								msg_com[current_msg].green_av[pnt]=1; //true
							}
							if(msgsection==2 && ifsec==2)
							{
								for(int j=0;j<8;j++)
								{
									curr->green_av[j]=0; //false
								}
								curr->green_av[pnt]=1; //true
							}
						}				   
						else if(strncmp(buf,"yellow_available_only_point",27)==0) 
						{
							// this can only be in a section
							if(start==0 && msgsection==0) random_shit_error=true;
							for(int j=0;j<27;j++)
							{
								i++;
								buf = _strinc(buf);
							}//move to end
							if(buffer[i]!='1' && buffer[i]!='2' && buffer[i]!='3' && buffer[i]!='4' && buffer[i]!='5' && 
								buffer[i]!='6' && buffer[i]!='7' && buffer[i]!='8') random_shit_error=true;
							else
							{
								pnt=atoi(&buffer[i]); // get the var
								pnt--;
								i++;
								buf = _strinc(buf);
							}//move to end
							if(start==2)
							{
								for(int j=0;j<8;j++)
								{
									yellow_av[j]=false;
								}
								yellow_av[pnt]=true;
							}
							if(msgsection==2 && ifsec==0)
							{
								for(int j=0;j<8;j++)
								{
									msg_com[current_msg].yellow_av[j]=0; //false
								}
								msg_com[current_msg].yellow_av[pnt]=1; //true
							}
							if(msgsection==2 && ifsec==2)
							{
								for(int j=0;j<8;j++)
								{
									curr->yellow_av[j]=0; //false
								}
								curr->yellow_av[pnt]=1; //true
							}
						}				   

						//point<n> availabe (set to true)
						else if(strncmp(buf,"blue_available_point",20)==0) 
						{
							// this can only be in a section
							if(start==0 && msgsection==0) random_shit_error=true;
							for(int j=0;j<20;j++)
							{
								i++;
								buf = _strinc(buf);
							}//move to end
							if(buffer[i]!='1' && buffer[i]!='2' && buffer[i]!='3' && buffer[i]!='4' && buffer[i]!='5' && 
								buffer[i]!='6' && buffer[i]!='7' && buffer[i]!='8') random_shit_error=true;
							else
							{
								pnt=atoi(&buffer[i]); // get the var
								pnt--;
								i++;
								buf = _strinc(buf);
							}//move to end
							if(start==2)
							{
								blue_av[pnt]=true;
							}
							if(msgsection==2 && ifsec==0)
							{
								msg_com[current_msg].blue_av[pnt]=1; //true
							}
							if(msgsection==2 && ifsec==2)
							{
								curr->blue_av[pnt]=1; //true
							}
						}
						else if(strncmp(buf,"red_available_point",19)==0) 
						{
							// this can only be in a section
							if(start==0 && msgsection==0) random_shit_error=true;
							for(int j=0;j<19;j++)
							{
								i++;
								buf = _strinc(buf);
							}//move to end
							if(buffer[i]!='1' && buffer[i]!='2' && buffer[i]!='3' && buffer[i]!='4' && buffer[i]!='5' && 
								buffer[i]!='6' && buffer[i]!='7' && buffer[i]!='8') random_shit_error=true;
							else
							{
								pnt=atoi(&buffer[i]); // get the var
								pnt--;
								i++;
								buf = _strinc(buf);
							}//move to end
							if(start==2)
							{
								red_av[pnt]=true;
							}
							if(msgsection==2 && ifsec==0)
							{
								msg_com[current_msg].red_av[pnt]=1; //true
							}
							if(msgsection==2 && ifsec==2)
							{
								curr->red_av[pnt]=1; //true
							}
						}				   
						else if(strncmp(buf,"green_available_point",21)==0) 
						{
							// this can only be in a section
							if(start==0 && msgsection==0) random_shit_error=true;
							for(int j=0;j<21;j++)
							{
								i++;
								buf = _strinc(buf);
							}//move to end
							if(buffer[i]!='1' && buffer[i]!='2' && buffer[i]!='3' && buffer[i]!='4' && buffer[i]!='5' && 
								buffer[i]!='6' && buffer[i]!='7' && buffer[i]!='8') random_shit_error=true;
							else
							{
								pnt=atoi(&buffer[i]); // get the var
								pnt--;
								i++;
								buf = _strinc(buf);
							}//move to end
							if(start==2)
							{
								green_av[pnt]=true;
							}
							if(msgsection==2 && ifsec==0)
							{
								msg_com[current_msg].green_av[pnt]=1; //true
							}
							if(msgsection==2 && ifsec==2)
							{
								curr->green_av[pnt]=1; //true
							}
						}				   
						else if(strncmp(buf,"yellow_available_point",22)==0) 
						{
							// this can only be in a section
							if(start==0 && msgsection==0) random_shit_error=true;
							for(int j=0;j<22;j++)
							{
								i++;
								buf = _strinc(buf);
							}//move to end
							if(buffer[i]!='1' && buffer[i]!='2' && buffer[i]!='3' && buffer[i]!='4' && buffer[i]!='5' && 
								buffer[i]!='6' && buffer[i]!='7' && buffer[i]!='8') random_shit_error=true;
							else
							{
								pnt=atoi(&buffer[i]); // get the var
								pnt--;
								i++;
								buf = _strinc(buf);
							}//move to end
							if(start==2)
							{
								yellow_av[pnt]=true;
							}
							if(msgsection==2 && ifsec==0)
							{
								msg_com[current_msg].yellow_av[pnt]=1; //true
							}
							if(msgsection==2 && ifsec==2)
							{
								curr->yellow_av[pnt]=1; //true
							}
						}				   

						//point<n> not_availabe (set to false)
						else if(strncmp(buf,"blue_notavailable_point",23)==0) 
						{
							// this can only be in a section
							if(start==0 && msgsection==0) random_shit_error=true;
							for(int j=0;j<23;j++)
							{
								i++;
								buf = _strinc(buf);
							}//move to end
							if(buffer[i]!='1' && buffer[i]!='2' && buffer[i]!='3' && buffer[i]!='4' && buffer[i]!='5' && 
								buffer[i]!='6' && buffer[i]!='7' && buffer[i]!='8') random_shit_error=true;
							else
							{
								pnt=atoi(&buffer[i]); // get the var
								pnt--;
								i++;
								buf = _strinc(buf);
							}//move to end
							if(start==2)
							{
								blue_av[pnt]=false;
							}
							if(msgsection==2 && ifsec==0)
							{
								msg_com[current_msg].blue_av[pnt]=0; //false
							}
							if(msgsection==2 && ifsec==2)
							{
								curr->blue_av[pnt]=0; //false
							}
						}
						else if(strncmp(buf,"red_notavailable_point",22)==0) 
						{
							// this can only be in a section
							if(start==0 && msgsection==0) random_shit_error=true;
							for(int j=0;j<22;j++)
							{
								i++;
								buf = _strinc(buf);
							}//move to end
							if(buffer[i]!='1' && buffer[i]!='2' && buffer[i]!='3' && buffer[i]!='4' && buffer[i]!='5' && 
								buffer[i]!='6' && buffer[i]!='7' && buffer[i]!='8') random_shit_error=true;
							else
							{
								pnt=atoi(&buffer[i]); // get the var
								pnt--;
								i++;
								buf = _strinc(buf);
							}//move to end
							if(start==2)
							{
								red_av[pnt]=false;
							}
							if(msgsection==2 && ifsec==0)
							{
								msg_com[current_msg].red_av[pnt]=0; //false
							}
							if(msgsection==2 && ifsec==2)
							{
								curr->red_av[pnt]=0; //false
							}
						}				   
						else if(strncmp(buf,"green_notavailable_point",24)==0) 
						{
							// this can only be in a section
							if(start==0 && msgsection==0) random_shit_error=true;
							for(int j=0;j<24;j++)
							{
								i++;
								buf = _strinc(buf);
							}//move to end
							if(buffer[i]!='1' && buffer[i]!='2' && buffer[i]!='3' && buffer[i]!='4' && buffer[i]!='5' && 
								buffer[i]!='6' && buffer[i]!='7' && buffer[i]!='8') random_shit_error=true;
							else
							{
								pnt=atoi(&buffer[i]); // get the var
								pnt--;
								i++;
								buf = _strinc(buf);
							}//move to end
							if(start==2)
							{
								green_av[pnt]=false;
							}
							if(msgsection==2 && ifsec==0)
							{
								msg_com[current_msg].green_av[pnt]=0; //false
							}
							if(msgsection==2 && ifsec==2)
							{
								curr->green_av[pnt]=0; //false
							}
						}				   
						else if(strncmp(buf,"yellow_notavailable_point",25)==0) 
						{
							// this can only be in a section
							if(start==0 && msgsection==0) random_shit_error=true;
							for(int j=0;j<25;j++)
							{
								i++;
								buf = _strinc(buf);
							}//move to end
							if(buffer[i]!='1' && buffer[i]!='2' && buffer[i]!='3' && buffer[i]!='4' && buffer[i]!='5' && 
								buffer[i]!='6' && buffer[i]!='7' && buffer[i]!='8') random_shit_error=true;
							else
							{
								pnt=atoi(&buffer[i]); // get the var
								pnt--;
								i++;
								buf = _strinc(buf);
							}//move to end
							if(start==2)
							{
								yellow_av[pnt]=false;
							}
							if(msgsection==2 && ifsec==0)
							{
								msg_com[current_msg].yellow_av[pnt]=0; //false
							}
							if(msgsection==2 && ifsec==2)
							{
								curr->yellow_av[pnt]=0; //false
							}
						}				   

						//is point<n> availabe?
						else if(strncmp(buf,"if_blue_point",13)==0) 
						{
							// this can only be in a section
							if(msgsection==0) random_shit_error=true;
							if(ifsec>0) ifsec=99; //check for nested if defs
							else	ifsec=1;
							for(int j=0;j<13;j++)
							{
								i++;
								buf = _strinc(buf);
							}//move to end
							if(buffer[i]!='1' && buffer[i]!='2' && buffer[i]!='3' && buffer[i]!='4' && buffer[i]!='5' && 
								buffer[i]!='6' && buffer[i]!='7' && buffer[i]!='8') random_shit_error=true;
							else
							{
								pnt=atoi(&buffer[i]); // get the var
								i++;
								buf = _strinc(buf);
							}//move to end
							while(curr->next!=NULL && curr->next!=0 && (int)curr->next!=-1)
								curr=curr->next; // get to null

							curr->next=new msg_com_struct;
							curr=curr->next;
							//clear next pointer..
							curr->next=0;
							for(int i=0;i<8;i++)
							{
								curr->blue_av[i]=-1;
								curr->red_av[i]=-1;
								curr->yellow_av[i]=-1;
								curr->green_av[i]=-1;
							}
							sprintf(msg,"b_p_%d",pnt);
							strcpy(curr->ifs,msg);
						}
						else if(strncmp(buf,"if_red_point",12)==0) 
						{
							// this can only be in a section
							if(msgsection==0) random_shit_error=true;
							if(ifsec>0) ifsec=99; //check for nested if defs
							else	ifsec=1;
							for(int j=0;j<12;j++)
							{
								i++;
								buf = _strinc(buf);
							}//move to end
							if(buffer[i]!='1' && buffer[i]!='2' && buffer[i]!='3' && buffer[i]!='4' && buffer[i]!='5' && 
								buffer[i]!='6' && buffer[i]!='7' && buffer[i]!='8') random_shit_error=true;
							else
							{
								pnt=atoi(&buffer[i]); // get the var
								i++;
								buf = _strinc(buf);
							}//move to end
							while(curr->next!=NULL && curr->next!=0 && (int)curr->next!=-1)
								curr=curr->next; // get to null

							curr->next=new msg_com_struct;
							curr=curr->next;
							//clear next pointer..
							curr->next=0;
							for(int i=0;i<8;i++)
							{
								curr->blue_av[i]=-1;
								curr->red_av[i]=-1;
								curr->yellow_av[i]=-1;
								curr->green_av[i]=-1;
							}
							sprintf(msg,"r_p_%d",pnt);
							strcpy(curr->ifs,msg);
						}				   
						else if(strncmp(buf,"if_green_point",14)==0) 
						{
							// this can only be in a section
							if(msgsection==0) random_shit_error=true;
							if(ifsec>0) ifsec=99; //check for nested if defs
							else	ifsec=1;
							for(int j=0;j<14;j++)
							{
								i++;
								buf = _strinc(buf);
							}//move to end
							if(buffer[i]!='1' && buffer[i]!='2' && buffer[i]!='3' && buffer[i]!='4' && buffer[i]!='5' && 
								buffer[i]!='6' && buffer[i]!='7' && buffer[i]!='8') random_shit_error=true;
							else
							{
								pnt=atoi(&buffer[i]); // get the var
								i++;
								buf = _strinc(buf);
							}//move to end
							while(curr->next!=NULL && curr->next!=0 && (int)curr->next!=-1)
								curr=curr->next; // get to null

							curr->next=new msg_com_struct;
							curr=curr->next;
							//clear next pointer..
							curr->next=0;
							for(int i=0;i<8;i++)
							{
								curr->blue_av[i]=-1;
								curr->red_av[i]=-1;
								curr->yellow_av[i]=-1;
								curr->green_av[i]=-1;
							}
							sprintf(msg,"g_p_%d",pnt);
							strcpy(curr->ifs,msg);
						}				   
						else if(strncmp(buf,"if_yellow_point",15)==0) 
						{
							// this can only be in a section
							if(msgsection==0) random_shit_error=true;
							if(ifsec>0) ifsec=99; //check for nested if defs
							else	ifsec=1;
							for(int j=0;j<15;j++)
							{
								i++;
								buf = _strinc(buf);
							}//move to end
							if(buffer[i]!='1' && buffer[i]!='2' && buffer[i]!='3' && buffer[i]!='4' && buffer[i]!='5' && 
								buffer[i]!='6' && buffer[i]!='7' && buffer[i]!='8') random_shit_error=true;
							else
							{
								pnt=atoi(&buffer[i]); // get the var
								i++;
								buf = _strinc(buf);
							}//move to end
							while(curr->next!=NULL && curr->next!=0 && (int)curr->next!=-1)
								curr=curr->next; // get to null

							curr->next=new msg_com_struct;
							curr=curr->next;
							//clear next pointer..
							curr->next=0;
							for(int i=0;i<8;i++)
							{
								curr->blue_av[i]=-1;
								curr->red_av[i]=-1;
								curr->yellow_av[i]=-1;
								curr->green_av[i]=-1;
							}
							sprintf(msg,"y_p_%d",pnt);
							strcpy(curr->ifs,msg);
						}				   


						//is point<n> NOT availabe?
						else if(strncmp(buf,"ifn_blue_point",14)==0) 
						{
							// this can only be in a section
							if(msgsection==0) random_shit_error=true;
							if(ifsec>0) ifsec=99; //check for nested if defs
							else	ifsec=1;
							for(int j=0;j<14;j++)
							{
								i++;
								buf = _strinc(buf);
							}//move to end
							if(buffer[i]!='1' && buffer[i]!='2' && buffer[i]!='3' && buffer[i]!='4' && buffer[i]!='5' && 
								buffer[i]!='6' && buffer[i]!='7' && buffer[i]!='8') random_shit_error=true;
							else
							{
								pnt=atoi(&buffer[i]); // get the var
								i++;
								buf = _strinc(buf);
							}//move to end
							while(curr->next!=NULL && curr->next!=0 && (int)curr->next!=-1)
								curr=curr->next; // get to null

							curr->next=new msg_com_struct;
							curr=curr->next;
							//clear next pointer..
							curr->next=0;
							for(int i=0;i<8;i++)
							{
								curr->blue_av[i]=-1;
								curr->red_av[i]=-1;
								curr->yellow_av[i]=-1;
								curr->green_av[i]=-1;
							}
							sprintf(msg,"b_pn_%d",pnt);
							strcpy(curr->ifs,msg);
						}
						else if(strncmp(buf,"ifn_red_point",13)==0) 
						{
							// this can only be in a section
							if(msgsection==0) random_shit_error=true;
							if(ifsec>0) ifsec=99; //check for nested if defs
							else	ifsec=1;
							for(int j=0;j<13;j++)
							{
								i++;
								buf = _strinc(buf);
							}//move to end
							if(buffer[i]!='1' && buffer[i]!='2' && buffer[i]!='3' && buffer[i]!='4' && buffer[i]!='5' && 
								buffer[i]!='6' && buffer[i]!='7' && buffer[i]!='8') random_shit_error=true;
							else
							{
								pnt=atoi(&buffer[i]); // get the var
								i++;
								buf = _strinc(buf);
							}//move to end
							while(curr->next!=NULL && curr->next!=0 && (int)curr->next!=-1)
								curr=curr->next; // get to null

							curr->next=new msg_com_struct;
							curr=curr->next;
							//clear next pointer..
							curr->next=0;
							for(int i=0;i<8;i++)
							{
								curr->blue_av[i]=-1;
								curr->red_av[i]=-1;
								curr->yellow_av[i]=-1;
								curr->green_av[i]=-1;
							}
							sprintf(msg,"r_pn_%d",pnt);
							strcpy(curr->ifs,msg);
						}				   
						else if(strncmp(buf,"ifn_green_point",15)==0) 
						{
							// this can only be in a section
							if(msgsection==0) random_shit_error=true;
							if(ifsec>0) ifsec=99; //check for nested if defs
							else	ifsec=1;
							for(int j=0;j<15;j++)
							{
								i++;
								buf = _strinc(buf);
							}//move to end
							if(buffer[i]!='1' && buffer[i]!='2' && buffer[i]!='3' && buffer[i]!='4' && buffer[i]!='5' && 
								buffer[i]!='6' && buffer[i]!='7' && buffer[i]!='8') random_shit_error=true;
							else
							{
								pnt=atoi(&buffer[i]); // get the var
								i++;
								buf = _strinc(buf);
							}//move to end
							while(curr->next!=NULL && curr->next!=0 && (int)curr->next!=-1)
								curr=curr->next; // get to null

							curr->next=new msg_com_struct;
							curr=curr->next;
							//clear next pointer..
							curr->next=0;
							for(int i=0;i<8;i++)
							{
								curr->blue_av[i]=-1;
								curr->red_av[i]=-1;
								curr->yellow_av[i]=-1;
								curr->green_av[i]=-1;
							}
							sprintf(msg,"g_pn_%d",pnt);
							strcpy(curr->ifs,msg);
						}				   
						else if(strncmp(buf,"ifn_yellow_point",16)==0) 
						{
							// this can only be in a section
							if(msgsection==0) random_shit_error=true;
							if(ifsec>0) ifsec=99; //check for nested if defs
							else	ifsec=1;
							for(int j=0;j<16;j++)
							{
								i++;
								buf = _strinc(buf);
							}//move to end
							if(buffer[i]!='1' && buffer[i]!='2' && buffer[i]!='3' && buffer[i]!='4' && buffer[i]!='5' && 
								buffer[i]!='6' && buffer[i]!='7' && buffer[i]!='8') random_shit_error=true;
							else
							{
								pnt=atoi(&buffer[i]); // get the var
								i++;
								buf = _strinc(buf);
							}//move to end
							while(curr->next!=NULL && curr->next!=0 && (int)curr->next!=-1)
								curr=curr->next; // get to null

							curr->next=new msg_com_struct;
							curr=curr->next;
							//clear next pointer..
							curr->next=0;
							for(int i=0;i<8;i++)
							{
								curr->blue_av[i]=-1;
								curr->red_av[i]=-1;
								curr->yellow_av[i]=-1;
								curr->green_av[i]=-1;
							}
							sprintf(msg,"y_pn_%d",pnt);
							strcpy(curr->ifs,msg);
						}				   

						//
						//multipoint ifs
						//
						else if(strncmp(buf,"if_blue_mpoint",14)==0) 
						{
							// this can only be in a section
							if(msgsection==0) random_shit_error=true;
							if(ifsec>0) ifsec=99; //check for nested if defs
							else	ifsec=1;
							int j;
							for(j=0;j<14;j++)
							{
								i++;
								buf = _strinc(buf);
							}//move to end
							//check for 8 if vals
							char pnts[9];
							for(j=0;j<8;j++)
							{
								if(buffer[i]!='1' && buffer[i]!='0') random_shit_error=true;
								else
								{
									pnts[j]=buffer[i];
									i++;
									buf = _strinc(buf);
								}//move to end
							}
							while(curr->next!=NULL && curr->next!=0 && (int)curr->next!=-1)
								curr=curr->next; // get to null

							curr->next=new msg_com_struct;
							curr=curr->next;
							//clear next pointer..
							curr->next=0;
							for(int i=0;i<8;i++)
							{
								curr->blue_av[i]=-1;
								curr->red_av[i]=-1;
								curr->yellow_av[i]=-1;
								curr->green_av[i]=-1;
							}
							pnts[8]=NULL;
							sprintf(msg,"b_mp_%s",pnts);
							strcpy(curr->ifs,msg);
						}
						else if(strncmp(buf,"if_red_mpoint",13)==0) 
						{
							// this can only be in a section
							if(msgsection==0) random_shit_error=true;
							if(ifsec>0) ifsec=99; //check for nested if defs
							else	ifsec=1;
							int j;
							for(j=0;j<13;j++)
							{
								i++;
								buf = _strinc(buf);
							}//move to end
							//check for 8 if vals
							char pnts[9];
							for(j=0;j<8;j++)
							{
								if(buffer[i]!='1' && buffer[i]!='0') random_shit_error=true;
								else
								{
									pnts[j]=buffer[i];
									i++;
									buf = _strinc(buf);
								}//move to end
							}
							while(curr->next!=NULL && curr->next!=0 && (int)curr->next!=-1)
								curr=curr->next; // get to null

							curr->next=new msg_com_struct;
							curr=curr->next;
							//clear next pointer..
							curr->next=0;
							for(int i=0;i<8;i++)
							{
								curr->blue_av[i]=-1;
								curr->red_av[i]=-1;
								curr->yellow_av[i]=-1;
								curr->green_av[i]=-1;
							}
							pnts[8]=NULL;
							sprintf(msg,"r_mp_%s",pnts);
							strcpy(curr->ifs,msg);
						}				   
						else if(strncmp(buf,"if_green_mpoint",15)==0) 
						{
							// this can only be in a section
							if(msgsection==0) random_shit_error=true;
							if(ifsec>0) ifsec=99; //check for nested if defs
							else	ifsec=1;
							int j;
							for(j=0;j<15;j++)
							{
								i++;
								buf = _strinc(buf);
							}//move to end
							//check for 8 if vals
							char pnts[9];
							for(j=0;j<8;j++)
							{
								if(buffer[i]!='1' && buffer[i]!='0') random_shit_error=true;
								else
								{
									pnts[j]=buffer[i];
									i++;
									buf = _strinc(buf);
								}//move to end
							}
							while(curr->next!=NULL && curr->next!=0 && (int)curr->next!=-1)
								curr=curr->next; // get to null

							curr->next=new msg_com_struct;
							curr=curr->next;
							//clear next pointer..
							curr->next=0;
							for(int i=0;i<8;i++)
							{
								curr->blue_av[i]=-1;
								curr->red_av[i]=-1;
								curr->yellow_av[i]=-1;
								curr->green_av[i]=-1;
							}
							pnts[8]=NULL;
							sprintf(msg,"g_mp_%s",pnts);
							strcpy(curr->ifs,msg);
						}				   
						else if(strncmp(buf,"if_yellow_mpoint",16)==0) 
						{
							// this can only be in a section
							if(msgsection==0) random_shit_error=true;
							if(ifsec>0) ifsec=99; //check for nested if defs
							else	ifsec=1;
							int j;
							for(j=0;j<16;j++)
							{
								i++;
								buf = _strinc(buf);
							}//move to end
							//check for 8 if vals
							char pnts[9];
							for(j=0;j<8;j++)
							{
								if(buffer[i]!='1' && buffer[i]!='0') random_shit_error=true;
								else
								{
									pnts[j]=buffer[i];
									i++;
									buf = _strinc(buf);
								}//move to end
							}
							while(curr->next!=NULL && curr->next!=0 && (int)curr->next!=-1)
								curr=curr->next; // get to null

							curr->next=new msg_com_struct;
							curr=curr->next;
							//clear next pointer..
							curr->next=0;
							for(int i=0;i<8;i++)
							{
								curr->blue_av[i]=-1;
								curr->red_av[i]=-1;
								curr->yellow_av[i]=-1;
								curr->green_av[i]=-1;
							}
							pnts[8]=NULL;
							sprintf(msg,"y_mp_%s",pnts);
							strcpy(curr->ifs,msg);
						}				   
						//end of multipoint ifs

						// ignore endlines
						// and comments
						else if((buffer[i]!='/' && buffer[i]!='{' && 
							buffer[i]!='}' && buffer[i]!=' ' && 
							buffer[i]!='\n') && commentline==false &&
							random_shit_error==false)
						{
							random_shit_error=true;
							ALERT( at_console, "\\/\\/\\/\\/\\/\\/\n");
							ALERT( at_console, buf);
							ALERT( at_console, "\n");
						}

						//do your magic lexical analysis here..
						//first braces
						switch(buffer[i])
						{
						case '{':
							braces++;
							if(start==1) start=2;
							else if(start>0) start=99;
							//need to check that more braces aernt put in than nesesarry
							// i.e. start=2 then generate error,
							//cus only have variable setting in start section
							if(ifsec==1) ifsec=2;
							else if(ifsec>0) ifsec=99;
							if(msgsection==1) msgsection=2;
							else if(msgsection>0 && ifsec==0) msgsection=99;
							break;
						case '}':
							braces--;
							if(start==2) start=0;
							if(ifsec==2) ifsec=0;
							if(msgsection==2) msgsection=0;
							break;
						};
					}
					buf = _strinc(buf); //like i++ but for stringcmp stuff
				}		   

			}
			else
			{
				ALERT( at_console, "\nConfig will not be used until their are no syntax errors\n\n");
			}
		}

		//{ fp=fopen("bot.txt", "a"); fprintf(fp, "StartFrame-my shiznit (end)\n"); fclose(fp); }
		//strcpy(prevmapname,STRING(gpGlobals->mapname));
	}

	if(!mr_meta)
		(*other_gFunctionTable.pfnStartFrame)();
	else
		SET_META_RESULT(MRES_HANDLED);
}

void ParmsNewLevel( void )
{
	if(!mr_meta)
		(*other_gFunctionTable.pfnParmsNewLevel)();
	else
		SET_META_RESULT(MRES_HANDLED);
}

void ParmsChangeLevel( void )
{
	if(!mr_meta)
		(*other_gFunctionTable.pfnParmsChangeLevel)();
	else
		SET_META_RESULT(MRES_HANDLED);
}

const char *GetGameDescription( void )
{
	if(!mr_meta)
		return (*other_gFunctionTable.pfnGetGameDescription)();
	else
	{
		SET_META_RESULT(MRES_HANDLED);
		return("");
	}
}

void PlayerCustomization( edict_t *pEntity, customization_t *pCust )
{
	if (debug_engine) { fp=fopen("bot.txt", "a"); fprintf(fp, "PlayerCustomization: %x\n",pEntity); fclose(fp); }

	if(!mr_meta)
		(*other_gFunctionTable.pfnPlayerCustomization)(pEntity, pCust);
	else
		SET_META_RESULT(MRES_HANDLED);
}

void SpectatorConnect( edict_t *pEntity )
{
	if(!mr_meta)
		(*other_gFunctionTable.pfnSpectatorConnect)(pEntity);
	else
		SET_META_RESULT(MRES_HANDLED);
}

void SpectatorDisconnect( edict_t *pEntity )
{
	if(!mr_meta)
		(*other_gFunctionTable.pfnSpectatorDisconnect)(pEntity);
	else
		SET_META_RESULT(MRES_HANDLED);
}

void SpectatorThink( edict_t *pEntity )
{
	if(!mr_meta)
		(*other_gFunctionTable.pfnSpectatorThink)(pEntity);
	else
		SET_META_RESULT(MRES_HANDLED);
}

void Sys_Error( const char *error_string )
{
	//int y = 1, x = 1;

	//x = x - 1;  // x is zero
	//y = y / x;  // cause an divide by zero exception

	//if (debug_engine) 
	sz_error_check[251]=NULL;
	{ 
		fp=fopen("bot.txt", "a");
		fprintf(fp, "SytemError: %s %s\n",error_string,sz_error_check); 
		int i;
		for(i=0;i<32;i++)
		{
			if(clients[i]!=NULL)
				fprintf(fp,"%x %d\n",clients[i],i);
		}
		fclose(fp); 
		for(i=0;i<=32;i++)
		{
			if(INDEXENT(i)!=NULL)
				UTIL_SavePent(INDEXENT(i));
		}
	}
	if(!mr_meta)
		(*other_gFunctionTable.pfnSys_Error)(error_string);
	else
		SET_META_RESULT(MRES_HANDLED);
}

void PM_Move ( struct playermove_s *ppmove, int server )
{
	if(!mr_meta)
		(*other_gFunctionTable.pfnPM_Move)(ppmove, server);
	else
		SET_META_RESULT(MRES_HANDLED);
}

void PM_Init ( struct playermove_s *ppmove )
{
	if(!mr_meta)
		(*other_gFunctionTable.pfnPM_Init)(ppmove);
	else
		SET_META_RESULT(MRES_HANDLED);
}

char PM_FindTextureType( char *name )
{
	if(!mr_meta)
		return (*other_gFunctionTable.pfnPM_FindTextureType)(name);
	else
	{
		SET_META_RESULT(MRES_HANDLED);
		return('\0');
	}
}

void SetupVisibility( edict_t *pViewEntity, edict_t *pClient, unsigned char **pvs, unsigned char **pas )
{
	if(!mr_meta)
		(*other_gFunctionTable.pfnSetupVisibility)(pViewEntity, pClient, pvs, pas);
	else
		SET_META_RESULT(MRES_HANDLED);
}

void UpdateClientData ( const struct edict_s *ent, int sendweapons, struct clientdata_s *cd )
{
	if(!mr_meta)
		(*other_gFunctionTable.pfnUpdateClientData)(ent, sendweapons, cd);
	else
	{
		gpGamedllFuncs->dllapi_table->pfnUpdateClientData(ent, sendweapons, cd);
		SET_META_RESULT(MRES_SUPERCEDE);
	}
}

int AddToFullPack( struct entity_state_s *state, int e, edict_t *ent, edict_t *host, int hostflags, int player, unsigned char *pSet )
{
	if(!mr_meta)
		return (*other_gFunctionTable.pfnAddToFullPack)(state, e, ent, host, hostflags, player, pSet);
	else
	{
		SET_META_RESULT(MRES_HANDLED);
		return(0);
	}
}

void CreateBaseline( int player, int eindex, struct entity_state_s *baseline, struct edict_s *entity, int playermodelindex, vec3_t player_mins, vec3_t player_maxs )
{
	if(!mr_meta)
		(*other_gFunctionTable.pfnCreateBaseline)(player, eindex, baseline, entity, playermodelindex, player_mins, player_maxs);
	else
		SET_META_RESULT(MRES_HANDLED);
}

void RegisterEncoders( void )
{
	if(!mr_meta)
		(*other_gFunctionTable.pfnRegisterEncoders)();
	else
		SET_META_RESULT(MRES_HANDLED);
}

int GetWeaponData( struct edict_s *player, struct weapon_data_s *info )
{
	if(!mr_meta)
		return (*other_gFunctionTable.pfnGetWeaponData)(player, info);
	else
	{
		SET_META_RESULT(MRES_HANDLED);
		return(1);
	}
}

void CmdStart( const edict_t *player, const struct usercmd_s *cmd, unsigned int random_seed )
{
	if(!mr_meta)
		(*other_gFunctionTable.pfnCmdStart)(player, cmd, random_seed);
	else
		SET_META_RESULT(MRES_HANDLED);
}

void CmdEnd ( const edict_t *player )
{
	if(!mr_meta)
		(*other_gFunctionTable.pfnCmdEnd)(player);
	else
		SET_META_RESULT(MRES_HANDLED);
}

int ConnectionlessPacket( const struct netadr_s *net_from, const char *args, char *response_buffer, int *response_buffer_size )
{
	if(!mr_meta)
		return (*other_gFunctionTable.pfnConnectionlessPacket)(net_from, args, response_buffer, response_buffer_size);
	else
	{
		SET_META_RESULT(MRES_HANDLED);
		return(0);
	}
}

int GetHullBounds( int hullnumber, float *mins, float *maxs )
{
	if(!mr_meta)
		return (*other_gFunctionTable.pfnGetHullBounds)(hullnumber, mins, maxs);
	else
	{
		SET_META_RESULT(MRES_HANDLED);
		return(0);
	}
}

void CreateInstancedBaselines( void )
{
	if(!mr_meta)
		(*other_gFunctionTable.pfnCreateInstancedBaselines)();
	else
		SET_META_RESULT(MRES_HANDLED);
}

int InconsistentFile( const edict_t *player, const char *filename, char *disconnect_message )
{
	if (debug_engine) { fp=fopen("bot.txt", "a"); fprintf(fp, "InconsistentFile: %x filename=%s\n",player,filename); fclose(fp); }

	if(!mr_meta)
		return (*other_gFunctionTable.pfnInconsistentFile)(player, filename, disconnect_message);
	else
	{
		RETURN_META_VALUE(MRES_HANDLED, 0);
		return(0);
	}
}

int AllowLagCompensation( void )
{
	if(!mr_meta)
		return (*other_gFunctionTable.pfnAllowLagCompensation)();
	else
	{
		SET_META_RESULT(MRES_HANDLED);
		return(1);
	}
}


DLL_FUNCTIONS gFunctionTable =
{
	GameDLLInit,               //pfnGameInit
		DispatchSpawn,             //pfnSpawn
		DispatchThink,             //pfnThink
		DispatchUse,               //pfnUse
		DispatchTouch,             //pfnTouch
		DispatchBlocked,           //pfnBlocked
		DispatchKeyValue,          //pfnKeyValue
		DispatchSave,              //pfnSave
		DispatchRestore,           //pfnRestore
		DispatchObjectCollsionBox, //pfnAbsBox

		SaveWriteFields,           //pfnSaveWriteFields
		SaveReadFields,            //pfnSaveReadFields

		SaveGlobalState,           //pfnSaveGlobalState
		RestoreGlobalState,        //pfnRestoreGlobalState
		ResetGlobalState,          //pfnResetGlobalState

		ClientConnect,             //pfnClientConnect
		ClientDisconnect,          //pfnClientDisconnect
		ClientKill,                //pfnClientKill
		ClientPutInServer,         //pfnClientPutInServer
		ClientCommand,             //pfnClientCommand
		ClientUserInfoChanged,     //pfnClientUserInfoChanged
		ServerActivate,            //pfnServerActivate
		ServerDeactivate,          //pfnServerDeactivate

		PlayerPreThink,            //pfnPlayerPreThink
		PlayerPostThink,           //pfnPlayerPostThink

		StartFrame,                //pfnStartFrame
		ParmsNewLevel,             //pfnParmsNewLevel
		ParmsChangeLevel,          //pfnParmsChangeLevel

		GetGameDescription,        //pfnGetGameDescription    Returns string describing current .dll game.
		PlayerCustomization,       //pfnPlayerCustomization   Notifies .dll of new customization for player.

		SpectatorConnect,          //pfnSpectatorConnect      Called when spectator joins server
		SpectatorDisconnect,       //pfnSpectatorDisconnect   Called when spectator leaves the server
		SpectatorThink,            //pfnSpectatorThink        Called when spectator sends a command packet (usercmd_t)

		Sys_Error,                 //pfnSys_Error          Called when engine has encountered an error

		PM_Move,                   //pfnPM_Move
		PM_Init,                   //pfnPM_Init            Server version of player movement initialization
		PM_FindTextureType,        //pfnPM_FindTextureType

		SetupVisibility,           //pfnSetupVisibility        Set up PVS and PAS for networking for this client
		UpdateClientData,          //pfnUpdateClientData       Set up data sent only to specific client
		AddToFullPack,             //pfnAddToFullPack
		CreateBaseline,            //pfnCreateBaseline        Tweak entity baseline for network encoding, allows setup of player baselines, too.
		RegisterEncoders,          //pfnRegisterEncoders      Callbacks for network encoding
		GetWeaponData,             //pfnGetWeaponData
		CmdStart,                  //pfnCmdStart
		CmdEnd,                    //pfnCmdEnd
		ConnectionlessPacket,      //pfnConnectionlessPacket
		GetHullBounds,             //pfnGetHullBounds
		CreateInstancedBaselines,  //pfnCreateInstancedBaselines
		InconsistentFile,          //pfnInconsistentFile
		AllowLagCompensation,      //pfnAllowLagCompensation
};

/*#ifdef __BORLANDC__
int EXPORT GetEntityAPI( DLL_FUNCTIONS *pFunctionTable, int interfaceVersion )
#else
extern "C" EXPORT int GetEntityAPI( DLL_FUNCTIONS *pFunctionTable, int interfaceVersion )
#endif*/

C_DLLEXPORT int GetEntityAPI( DLL_FUNCTIONS *pFunctionTable, int interfaceVersion )
{
	// check if engine's pointer is valid and version is correct...

	if ( !pFunctionTable || interfaceVersion != INTERFACE_VERSION )
		return FALSE;

	// pass engine callback function table to engine...
	memcpy( pFunctionTable, &gFunctionTable, sizeof( DLL_FUNCTIONS ) );

	if(!mr_meta)
	{
		// pass other DLLs engine callbacks to function table...
		if (!(*other_GetEntityAPI)(&other_gFunctionTable, INTERFACE_VERSION))
		{
			return FALSE;  // error initializing function table!!!
		}
	}

	return TRUE;
}



/*#ifdef __BORLANDC__
int EXPORT GetNewDLLFunctions( NEW_DLL_FUNCTIONS *pFunctionTable, int *interfaceVersion )
#else
extern "C" EXPORT int GetNewDLLFunctions( NEW_DLL_FUNCTIONS *pFunctionTable, int *interfaceVersion )
#endif*/
C_DLLEXPORT int GetNewDLLFunctions( NEW_DLL_FUNCTIONS *pFunctionTable, int *interfaceVersion )
{
	if (other_GetNewDLLFunctions == NULL)
		return FALSE;

	if(!mr_meta)
	{
		// pass other DLLs engine callbacks to function table...
		if (!(*other_GetNewDLLFunctions)(pFunctionTable, interfaceVersion))
		{
			return FALSE;  // error initializing function table!!!
		}
	}

	return TRUE;
}


/*void FakeClientCommand (edict_t *pFakeClient, const char *fmt, ...) 
{    
// the purpose of this function is to provide fakeclients (bots) with the same client    
// command-scripting advantages (putting multiple commands in one line between semicolons)    
// as real players. It is an improved version of botman's FakeClientCommand, in which you    
// supply directly the whole string as if you were typing it in the bot's "console". It    
// is supposed to work exactly like the pfnClientCommand (server-sided client command).     
va_list argptr;    
static char command[256];    
int length, fieldstart, fieldstop, i, index, stringindex = 0;      

if(pFakeClient==NULL)
return;
// concatenate all the arguments in one string    
va_start (argptr, fmt);    
vsprintf (command, fmt, argptr);    
va_end (argptr);     

if ((command == NULL) || (*command == 0))       
return; // if nothing in the command buffer, return     

isFakeClientCommand = TRUE; // set the "fakeclient command" flag    
length = strlen (command); // get the total length of the command string     
// process all individual commands (separated by a semicolon) one each a time    
while (stringindex < length)    
{       
fieldstart = stringindex; // save field start position (first character)       
while ((stringindex < length) && (command[stringindex] != ';'))          
stringindex++; // reach end of field       
if (command[stringindex - 1] == '\n')          
fieldstop = stringindex - 2; // discard any trailing '\n' if needed       
else          
fieldstop = stringindex - 1; // save field stop position (last character before semicolon or end)       
for (i = fieldstart; i <= fieldstop; i++)          
g_argv[i - fieldstart] = command[i]; // store the field value in the g_argv global string       
g_argv[i - fieldstart] = 0; // terminate the string       
stringindex++; // move the overall string index one step further to bypass the semicolon        
index = 0;       
fake_arg_count = 0; // let's now parse that command and count the different arguments        
// count the number of arguments       
while (index < i - fieldstart)       
{          
while ((index < i - fieldstart) && (g_argv[index] == ' '))             
index++; // ignore spaces           
// is this field a group of words between quotes or a single word ?          
if (g_argv[index] == '"')          
{             
index++; // move one step further to bypass the quote             
while ((index < i - fieldstart) && (g_argv[index] != '"'))                
index++; // reach end of field             
index++; // move one step further to bypass the quote          
}          
else             
while ((index < i - fieldstart) && (g_argv[index] != ' '))                
index++; // this is a single word, so reach the end of field           
fake_arg_count++; // we have processed one argument more       
}        
}     
if(!mr_meta)
ClientCommand (pFakeClient); // tell now the MOD DLL to execute this ClientCommand...    
else
MDLL_ClientCommand(pFakeClient);
g_argv[0] = 0; // when it's done, reset the g_argv field    
isFakeClientCommand = FALSE; // reset the "fakeclient command" flag    
fake_arg_count = 0; // and the argument count 
}*/

void FakeClientCommand(edict_t *pBot, char *arg1, char *arg2, char *arg3)
{
	int length,i;
	i=0;
	while(i<256)
	{
		g_argv[i] = NULL;
		i++;
	}

	if ((arg1 == NULL) || (*arg1 == 0))
		return;

	if(strncmp(arg1,"kill",4)==0)
	{
		if(!mr_meta)
			ClientKill(pBot);
		else
			MDLL_ClientKill(pBot);
		return;
	}

	if ((arg2 == NULL) || (*arg2 == 0))
	{
		length = snprintf(&g_argv[0],250, "%s", arg1);
		fake_arg_count = 1;
	}
	else if ((arg3 == NULL) || (*arg3 == 0))
	{
		length = snprintf(&g_argv[0],250, "%s %s", arg1, arg2);
		fake_arg_count = 2;
	}
	else
	{
		length = snprintf(&g_argv[0],250, "%s %s %s", arg1, arg2, arg3);
		fake_arg_count = 3;
	}
	isFakeClientCommand = 1;
	g_argv[length] = NULL;  // null terminate just in case

	if (debug_engine) { fp=fopen("bot.txt","a"); fprintf(fp,"FakeClientCommand=%s %x\n",g_argv,pBot); fclose(fp); }
	// allow the MOD DLL to execute the ClientCommand...
	if(mr_meta) 
	{
		MDLL_ClientCommand(pBot);
	}
	else ClientCommand(pBot);

	isFakeClientCommand = 0;
}


/*const char *pfnCmd_Args (void) {    
// this function returns a pointer to the whole current client command string. Since bots    
// have no client DLL and we may want a bot to execute a client command, we had to implement    
// a g_argv string in the bot DLL for holding the bots' commands, and also keep track of the    
// argument count. Hence this hook not to let the engine ask an unexistent client DLL for a    
// command we are holding here. Of course, real clients commands are still retrieved the    
// normal way, by asking the engine.     
// is this a bot issuing that client command ?    
if (isFakeClientCommand)    
{       
// is it a "say" or "say_team" client command ?       
if (strncmp ("say ", g_argv, 4) == 0)          
return (&g_argv[0] + 4); // skip the "say" bot client command (bug in HL engine)     


else if (strncmp ("say_team ", g_argv, 9) == 0)          
return (&g_argv[0] + 9); // skip the "say_team" bot client command (bug in HL 

engine)        
return (&g_argv[0]); // else return the whole bot client command string we know    
}     
return ((*g_engfuncs.pfnCmd_Args) ()); // ask the client command string to the 

engine 
} */

const char *Cmd_Args( void )
{
	if(!mr_meta)
	{
		if (isFakeClientCommand)
		{
			if (debug_engine) { fp=fopen("bot.txt","a"); fprintf(fp,"fake cmd_args%s\n",&g_argv[0]); fclose(fp); }
			// is it a "say" or "say_team" client command ?       
			if (strncmp ("say ", g_argv, 4) == 0)          
				return (&g_argv[0] + 4); // skip the "say" bot client command (bug in HL engine)     
			//sprintf(g_argv,"%s",&g_argv[0] + 4);
			else if (strncmp ("say_team ", g_argv, 9) == 0)          
				return (&g_argv[0] + 9); // skip the "say_team" bot client command (bug in HL engine)
			//sprintf(g_argv,"%s",&g_argv[0] + 9);

			return &g_argv[0];
		}
		else
		{
			return (*g_engfuncs.pfnCmd_Args)();
		}
	}
	else
	{
		if (isFakeClientCommand)
		{
			if (debug_engine) { fp=fopen("bot.txt","a"); fprintf(fp,"fake cmd_args%s\n",&g_argv[0]); fclose(fp); }
			// is it a "say" or "say_team" client command ?       
			if (strncmp ("say ", g_argv, 4) == 0)          
				RETURN_META_VALUE(MRES_SUPERCEDE, &g_argv[0] + 4); // skip the "say" bot client command (bug in HL engine)     
			else if (strncmp ("say_team ", g_argv, 9) == 0)          
				RETURN_META_VALUE(MRES_SUPERCEDE, &g_argv[0] + 9); // skip the "say_team" bot client command (bug in HL engine)
			else 
				/*if (strncmp ("say ", g_argv, 4) == 0)          
				//return (&g_argv[0] + 4); // skip the "say" bot client command (bug in HL engine)     
				sprintf(g_argv,"%s",&g_argv[0] + 4);
				else if (strncmp ("say_team ", g_argv, 9) == 0)          
				//return (&g_argv[0] + 9); // skip the "say_team" bot client command (bug in HL engine)
				sprintf(g_argv,"%s",&g_argv[0] + 9);*/
				RETURN_META_VALUE(MRES_SUPERCEDE, &g_argv[0]);
		}
		else
		{
			RETURN_META_VALUE(MRES_IGNORED, NULL);
		}
	}
}

const char *GetArg (const char *command, int arg_number) 
{    
	// the purpose of this function is to provide fakeclients (bots) with the same Cmd_Argv    
	// convenience the engine provides to real clients. This way the handling of real client    
	// commands and bot client commands is exactly the same, just have a look in engine.cpp    
	// for the hooking of pfnCmd_Argc, pfnCmd_Args and pfnCmd_Argv, which redirects the call    
	// either to the actual engine functions (when the caller is a real client), either on    
	// our function here, which does the same thing, when the caller is a bot.     
	int length, i, index = 0, arg_count = 0, fieldstart, fieldstop;  
	arg[0] = 0; // reset arg    
	length = strlen (command); // get length of command     
	// while we have not reached end of line    
	while ((index < length) && (arg_count <= arg_number))    
	{       
		while ((index < length) && (command[index] == ' '))          
			index++; // ignore spaces        
		// is this field multi-word between quotes or single word ?       
		if (command[index] == '"')       
		{          
			index++; // move one step further to bypass the quote          
			fieldstart = index; // save field start position          
			while ((index < length) && (command[index] != '"'))             
				index++; // reach end of field          
			fieldstop = index - 1; // save field stop position          
			index++; // move one step further to bypass the quote       
		}       
		else       
		{          
			fieldstart = index; // save field start position          
			while ((index < length) && (command[index] != ' '))             
				index++; // reach end of field          
			fieldstop = index - 1; // save field stop position       
		}        
		// is this argument we just processed the wanted one ?       
		if (arg_count == arg_number)       
		{          
			for (i = fieldstart; i <= fieldstop; i++) 
				arg[i - fieldstart] = command[i]; // store the field value in a string          
			arg[i - fieldstart] = 0; // terminate the string       
		}        
		arg_count++; // we have processed one argument more    
	}     
	return (&arg[0]); // returns the wanted argument 
} 


const char *Cmd_Argv( int argc )
{
	// this function returns a pointer to a certain argument of the current client command. Since    
	// bots have no client DLL and we may want a bot to execute a client command, we had to    
	// implement a g_argv string in the bot DLL for holding the bots' commands, and also keep    
	// track of the argument count. Hence this hook not to let the engine ask an unexistent client    
	// DLL for a command we are holding here. Of course, real clients commands are still retrieved    
	// the normal way, by asking the engine.     
	// is this a bot issuing that client command ?    
	//return ((*g_engfuncs.pfnCmd_Argv) (argc)); // ask the argument number "argc" to the engine 
	if (isFakeClientCommand)       
	{
		if(!mr_meta)
			return (GetArg (g_argv, argc)); // if so, then return the wanted argument we know     
		else
			RETURN_META_VALUE(MRES_SUPERCEDE, GetArg (g_argv, argc));
	}
	else
	{
		if(!mr_meta)
		{
			return (*g_engfuncs.pfnCmd_Argv)(argc);
		}
		else 
		{
			RETURN_META_VALUE(MRES_IGNORED, NULL);
		}
	}
}


int Cmd_Argc( void )
{
	if(!mr_meta)
	{
		if (debug_engine) { fp=fopen("bot.txt","a"); fprintf(fp,"fake cmd_argc%d\n",fake_arg_count); fclose(fp); }
		if (isFakeClientCommand)
		{
			return fake_arg_count;
		}
		else
		{
			return (*g_engfuncs.pfnCmd_Argc)();
		}
	}
	else
	{
		if (isFakeClientCommand)
		{
			RETURN_META_VALUE(MRES_SUPERCEDE, fake_arg_count);
		}
		else
		{
			RETURN_META_VALUE(MRES_IGNORED, 0);
		}
	}
}

//meta mod post functions

void DispatchKeyValue_Post( edict_t *pentKeyvalue, KeyValueData *pkvd )
{
	static edict_t *temp_pent;
	static int flag_index;

	//fp=fopen("bot.txt","a"); fprintf(fp, "DispatchKeyValue: %x %s=%s\n",pentKeyvalue,pkvd->szKeyName,pkvd->szValue); fclose(fp);

	if (mod_id == TFC_DLL)
	{
		if (pentKeyvalue == pent_info_tfdetect)
		{
			if (strcmp(pkvd->szKeyName, "ammo_medikit") == 0)  // max BLUE players
				max_team_players[0] = atoi(pkvd->szValue);
			else if (strcmp(pkvd->szKeyName, "ammo_detpack") == 0)  // max RED players
				max_team_players[1] = atoi(pkvd->szValue);
			else if (strcmp(pkvd->szKeyName, "maxammo_medikit") == 0)  // max YELLOW players
				max_team_players[2] = atoi(pkvd->szValue);
			else if (strcmp(pkvd->szKeyName, "maxammo_detpack") == 0)  // max GREEN players
				max_team_players[3] = atoi(pkvd->szValue);

			else if (strcmp(pkvd->szKeyName, "maxammo_shells") == 0)  // BLUE class limits
				team_class_limits[0] = atoi(pkvd->szValue);
			else if (strcmp(pkvd->szKeyName, "maxammo_nails") == 0)  // RED class limits
				team_class_limits[1] = atoi(pkvd->szValue);
			else if (strcmp(pkvd->szKeyName, "maxammo_rockets") == 0)  // YELLOW class limits
				team_class_limits[2] = atoi(pkvd->szValue);
			else if (strcmp(pkvd->szKeyName, "maxammo_cells") == 0)  // GREEN class limits
				team_class_limits[3] = atoi(pkvd->szValue);

			else if (strcmp(pkvd->szKeyName, "team1_allies") == 0)  // BLUE allies
				team_allies[0] = atoi(pkvd->szValue);
			else if (strcmp(pkvd->szKeyName, "team2_allies") == 0)  // RED allies
				team_allies[1] = atoi(pkvd->szValue);
			else if (strcmp(pkvd->szKeyName, "team3_allies") == 0)  // YELLOW allies
				team_allies[2] = atoi(pkvd->szValue);
			else if (strcmp(pkvd->szKeyName, "team4_allies") == 0)  // GREEN allies
				team_allies[3] = atoi(pkvd->szValue);
		}
		else if (pent_info_tfdetect == NULL)
		{
			if ((strcmp(pkvd->szKeyName, "classname") == 0) &&
				(strcmp(pkvd->szValue, "info_tfdetect") == 0))
			{
				pent_info_tfdetect = pentKeyvalue;
			}
		}

		if (pentKeyvalue == pent_item_tfgoal)
		{
			if (strcmp(pkvd->szKeyName, "team_no") == 0)
				flags[flag_index].team_no = atoi(pkvd->szValue);

			if ((strcmp(pkvd->szKeyName, "mdl") == 0) &&
				((strcmp(pkvd->szValue, "models/flag.mdl") == 0) ||
				(strcmp(pkvd->szValue, "models/keycard.mdl") == 0) ||
				(strcmp(pkvd->szValue, "models/ball.mdl") == 0)))
			{
				flags[flag_index].mdl_match = TRUE;
				num_flags++;
			}
		}
		else if (pent_item_tfgoal == NULL)
		{
			if ((strcmp(pkvd->szKeyName, "classname") == 0) &&
				(strcmp(pkvd->szValue, "item_tfgoal") == 0))
			{
				if (num_flags < MAX_FLAGS)
				{
					pent_item_tfgoal = pentKeyvalue;

					flags[num_flags].mdl_match = FALSE;
					flags[num_flags].team_no = 0;  // any team unless specified
					flags[num_flags].edict = pentKeyvalue;

					flag_index = num_flags;  // in case the mdl comes before team_no
				}
			}
		}
		else
		{
			pent_item_tfgoal = NULL;  // reset for non-flag item_tfgoal's
		}

		if ((strcmp(pkvd->szKeyName, "classname") == 0) &&
			((strcmp(pkvd->szValue, "info_player_teamspawn") == 0) ||
			(strcmp(pkvd->szValue, "info_tf_teamcheck") == 0) ||
			(strcmp(pkvd->szValue, "i_p_t") == 0)))
		{
			temp_pent = pentKeyvalue;
		}
		else if (pentKeyvalue == temp_pent)
		{
			if (strcmp(pkvd->szKeyName, "team_no") == 0)
			{
				int value = atoi(pkvd->szValue);

				//is_team[value-1]=true;
				//if (value > max_teams)
				//max_teams = value;
			}
		}
	}
	else if (mod_id == GEARBOX_DLL)
	{
		if (pent_info_ctfdetect == NULL)
		{
			if ((strcmp(pkvd->szKeyName, "classname") == 0) &&
				(strcmp(pkvd->szValue, "info_ctfdetect") == 0))
			{
				pent_info_ctfdetect = pentKeyvalue;
			}
		}
	}

	/*if(!mr_meta)
	(*other_gFunctionTable.pfnKeyValue)(pentKeyvalue, pkvd);
	else*/
	SET_META_RESULT(MRES_HANDLED);
}

static DLL_FUNCTIONS gFunctionTable_Post = 
{
	NULL,				//! pfnGameInit()				Initialize the game (one-time call after loading of game .dll)
		NULL,				//! pfnSpawn()
		NULL,				//! pfnThink()
		NULL,				//! pfnUse()
		NULL,				//! pfnTouch()
		NULL,			//! pfnBlocked()
		NULL, //DispatchKeyValue_Post,			//! pfnKeyValue()
		NULL,				//! pfnSave()
		NULL,			//! pfnRestore()
		NULL,	//! pfnSetAbsBox()

		NULL,			//! pfnSaveWriteFields()
		NULL,			//! pfnSaveReadFields()

		NULL,			//! pfnSaveGlobalState()
		NULL,		//! pfnRestoreGlobalState()
		NULL,			//! pfnResetGlobalState()

		ClientConnect_Post,				//! pfnClientConnect()			(wd) Client has connected
		NULL,			//! pfnClientDisconnect()		(wd) Player has left the game
		NULL,				//! pfnClientKill()				(wd) Player has typed "kill"
		NULL,			//! pfnClientPutInServer()		(wd) Client is entering the game
		NULL,				//! pfnClientCommand()			(wd) Player has sent a command (typed, or from a bind)
		NULL,		//! pfnClientUserInfoChanged()	(wd) Client has updated their setinfo structure
		NULL,			//! pfnServerActivate()			(wd) Server is starting a new map
		NULL,			//! pfnServerDeactivate()		(wd) Server is leaving the map (shutdown, or changelevel); SDK2

		NULL,			//! pfnPlayerPreThink()
		NULL,			//! pfnPlayerPostThink()

		NULL,				//! pfnStartFrame()
		NULL,				//! pfnParmsNewLevel()
		NULL,			//! pfnParmsChangeLevel()

		NULL,		//! pfnGetGameDescription()		Returns string describing current .dll.  E.g. "TeamFotrress 2", "Half-Life"
		NULL,		//! pfnPlayerCustomization()	Notifies .dll of new customization for player.

		NULL,			//! pfnSpectatorConnect()		Called when spectator joins server
		NULL,		//! pfnSpectatorDisconnect()	Called when spectator leaves the server
		NULL,			//! pfnSpectatorThink()			Called when spectator sends a command packet (usercmd_t)

		NULL,					//! pfnSys_Error()				Notify game .dll that engine is going to shut down.  Allows mod authors to set a breakpoint.  SDK2

		NULL,					//! pfnPM_Move()				(wd) SDK2
		NULL,					//! pfnPM_Init()				Server version of player movement initialization; (wd) SDK2
		NULL,		//! pfnPM_FindTextureType()		(wd) SDK2

		NULL,			//! pfnSetupVisibility()		Set up PVS and PAS for networking for this client; (wd) SDK2
		NULL,			//! pfnUpdateClientData()		Set up data sent only to specific client; (wd) SDK2
		NULL,				//! pfnAddToFullPack()			(wd) SDK2
		NULL,			//! pfnCreateBaseline()			Tweak entity baseline for network encoding, allows setup of player baselines, too.; (wd) SDK2
		NULL,			//! pfnRegisterEncoders()		Callbacks for network encoding; (wd) SDK2
		NULL,				//! pfnGetWeaponData()			(wd) SDK2
		NULL,					//! pfnCmdStart()				(wd) SDK2
		NULL,					//! pfnCmdEnd()					(wd) SDK2
		NULL,		//! pfnConnectionlessPacket()	(wd) SDK2
		NULL,				//! pfnGetHullBounds()			(wd) SDK2
		NULL,	//! pfnCreateInstancedBaselines()	(wd) SDK2
		NULL,			//! pfnInconsistentFile()		(wd) SDK2
		NULL,		//! pfnAllowLagCompensation()	(wd) SDK2
};

C_DLLEXPORT int GetEntityAPI_Post( DLL_FUNCTIONS *pFunctionTable, int interfaceVersion )
{
	if(!pFunctionTable) {
		return(FALSE);
	}
	else if(interfaceVersion != INTERFACE_VERSION) {
		return(FALSE);
	}
	memcpy(pFunctionTable, &gFunctionTable_Post, sizeof( DLL_FUNCTIONS ) );
	return(TRUE);
}



void ProcessBotCfgFile(void)
{
	int ch;
	char cmd_line[512];
	int cmd_index;
	static char server_cmd[514];
	char *cmd, *arg1, *arg2, *arg3, *arg4;
	char msg[255];

	if (bot_cfg_pause_time > gpGlobals->time)
		return;

	if (bot_cfg_fp == NULL)
	{
		if(cfg_file==1) need_to_open_cfg2=TRUE;
		if(cfg_file==2) 
		{
			cfg_file=0;
			bot_cfg_pause_time = 0.0; //stop it checking the file again :)
		}
		return;	
	}

	cmd_index = 0;
	cmd_line[cmd_index] = 0;
	cmd_line[510] = 0;

	ch = fgetc(bot_cfg_fp);

	// skip any leading blanks
	while (ch == ' ')
		ch = fgetc(bot_cfg_fp);

	while ((ch != EOF) && (ch != '\r') && (ch != '\n') && (cmd_index<510))
	{
		if (ch == '\t')  // convert tabs to spaces
			ch = ' ';

		//{ fp=fopen("bot.txt","a"); fprintf(fp,"cfg %d %i\n",cmd_index,ch); fclose(fp); }
		cmd_line[cmd_index] = ch;

		ch = fgetc(bot_cfg_fp);

		// skip multiple spaces in input file
		while ((cmd_line[cmd_index] == ' ') &&
			(ch == ' '))      
			ch = fgetc(bot_cfg_fp);

		cmd_index++;
	}

	if (ch == '\r')  // is it a carriage return?
	{
		ch = fgetc(bot_cfg_fp);  // skip the linefeed
	}

	// if reached end of file, then close it
	if (ch == EOF)
	{
		fclose(bot_cfg_fp);

		bot_cfg_fp = NULL;
		//if (debug_engine) { fp=fopen("bot.txt","a"); fprintf(fp,"close cfg\n"); fclose(fp); }

		//dam reset
		//bot_cfg_pause_time = 0.0;

		//sort new cfg shiznit out
		if(cfg_file==1) need_to_open_cfg2=TRUE;
		if(cfg_file==2) 
		{
			cfg_file=3; //0 is for if it was null when we passed in
			bot_cfg_pause_time = 0.0;
		}
	}

	cmd_line[cmd_index] = 0;  // terminate the command line

	if ((cmd_line[0] == '#') || (cmd_line[0] == 0))
		return;  // return if comment or blank line

	// DREVIL
	if (strncmp("echo", cmd_line, 4) == 0)
		return;

	// copy the command line to a server command buffer...
	strcpy(server_cmd, cmd_line);
	strcat(server_cmd, "\n");

	cmd_index = 0;
	cmd = cmd_line;
	arg1 = arg2 = arg3 = arg4 = NULL;

	// skip to blank or end of string...
	while ((cmd_line[cmd_index] != ' ') && (cmd_line[cmd_index] != 0) && (cmd_index<510))
		cmd_index++;
	if (cmd_line[cmd_index] == ' ' && (cmd_index<510))
	{
		cmd_line[cmd_index++] = 0;
		arg1 = &cmd_line[cmd_index];
		// skip to blank or end of string...
		while ((cmd_line[cmd_index] != ' ') && (cmd_line[cmd_index] != 0) && (cmd_index<510))
			cmd_index++;
		if (cmd_line[cmd_index] == ' ' && (cmd_index<510))
		{
			cmd_line[cmd_index++] = 0;
			arg2 = &cmd_line[cmd_index];
			while ((cmd_line[cmd_index] != ' ') && (cmd_line[cmd_index] != 0) && (cmd_index<510))
				cmd_index++;
			if (cmd_line[cmd_index] == ' ' && (cmd_index<510))
			{
				cmd_line[cmd_index++] = 0;
				arg3 = &cmd_line[cmd_index];
				while ((cmd_line[cmd_index] != ' ') && (cmd_line[cmd_index] != 0) && (cmd_index<510))
					cmd_index++;
				if (cmd_line[cmd_index] == ' ' && (cmd_index<510))
				{
					cmd_line[cmd_index++] = 0;
					arg4 = &cmd_line[cmd_index];
				}
			}
		}
	}

	if (strcmp(cmd, "addbot") == 0)
	{
		if (IS_DEDICATED_SERVER())
		{
			printf("[Config] add bot (%s,%s,%s,%s)\n", arg1, arg2, arg3, arg4 );
		}
		else
		{
			sprintf(msg,"[Config] add bot (%s,%s,%s,%s)\n", arg1, arg2, arg3, arg4 );
			ALERT( at_console, msg);
		}
		BotCreate( NULL, arg1, arg2, arg3, arg4 );

		// have to delay here or engine gives "Tried to write to
		// uninitialized sizebuf_t" error and crashes...

		bot_cfg_pause_time = gpGlobals->time + 2.0;
		bot_check_time = gpGlobals->time + 5.0;

		return;
	}

	if (strcmp(cmd, "bot_chat") == 0)
	{
		int temp = atoi(arg1);
		if (temp==0) 
		{
			b_botchat=FALSE;
			if (IS_DEDICATED_SERVER())
			{
				printf("[Config] bot chat (0) off\n");
			}
			else
			{
				sprintf(msg,"[Config] bot chat (0) off\n");
				ALERT( at_console, msg);
			}
		}
		else
		{
			b_botchat=TRUE;
			if (IS_DEDICATED_SERVER())
			{
				printf("[Config] bot chat (1) on\n");
			}
			else
			{
				sprintf(msg,"[Config] bot chat (1) on\n");
				ALERT( at_console, msg);
			}
		}
		return;
	}

	if (strcmp(cmd, "botskill") == 0)
	{
		int temp = atoi(arg1);

		if ((temp >= 1) && (temp <= 5))
		{
			default_bot_skill = atoi( arg1 );  // set default bot skill level
			if (IS_DEDICATED_SERVER())
			{
				printf("[Config] botskill set to %d\n",temp);
			}
			else
			{
				sprintf(msg,"[Config] botskill set to %d\n",temp);
				ALERT( at_console, msg);
			}
		}
		return;
	}

	if (strcmp(cmd, "observer") == 0)
	{
		int temp = atoi(arg1);

		if (temp)
			b_observer_mode = TRUE;
		else
			b_observer_mode = FALSE;

		return;
	}

	if (strcmp(cmd, "min_bots") == 0)
	{
		min_bots = atoi( arg1 );

		if ((min_bots < -1) || (min_bots > 31))
			min_bots = 1;

		if (IS_DEDICATED_SERVER())
		{
			sprintf(msg, "[Config] min_bots set to %d\n", min_bots);
			printf(msg);
		}
		else
		{
			sprintf(msg, "[Config] min_bots set to %d\n", min_bots);
			ALERT( at_console, msg);
		}

		return;
	}

	if (strcmp(cmd, "max_bots") == 0)
	{
		max_bots = atoi( arg1 );

		if ((max_bots < -1) || (max_bots > 31)) 
			max_bots = 1;

		if (IS_DEDICATED_SERVER())
		{
			sprintf(msg, "[Config] max_bots set to %d\n", max_bots);
			printf(msg);
		}
		else
		{
			sprintf(msg, "[Config] max_bots set to %d\n", max_bots);
			ALERT( at_console, msg);
		}

		return;
	}

	if (strcmp(cmd, "bot_team_balance")==0)
	{
		if ((arg1 != NULL))
		{
			int temp = atoi(arg1);
			if (temp)
				bot_team_balance = TRUE;
			else
				bot_team_balance = FALSE;
		}

		if (IS_DEDICATED_SERVER())
		{
			if (bot_team_balance)
				printf("[Config] bot_team_balance (1) On\n");
			else
				printf("[Config] bot_team_balance (0) Off\n");
		}
		else
		{
			if (bot_team_balance)
				ALERT( at_console,"[Config] bot_team_balance (1) On\n");
			else
				ALERT( at_console,"[Config] bot_team_balance (0) Off\n");
		}
		return;
	}
	if (strcmp(cmd, "bot_bot_balance")==0)
	{
		if ((arg1 != NULL))
		{
			int temp = atoi(arg1);
			if (temp)
				bot_bot_balance = TRUE;
			else
				bot_bot_balance = FALSE;
		}

		if (IS_DEDICATED_SERVER())
		{
			if (bot_bot_balance)
				printf("[Config] bot_bot_balance (1) On\n");
			else
				printf("[Config] bot_bot_balance (0) Off\n");
		}
		else
		{
			if (bot_bot_balance)
				ALERT( at_console,"[Config] bot_bot_balance (1) On\n");
			else
				ALERT( at_console,"[Config] bot_bot_balance (0) Off\n");
		}
		return;
	}

	if (strcmp(cmd, "bot_xmas") == 0)
	{
		int temp = atoi(arg1);
		bot_xmas=TRUE;
		if (temp==0) 
		{
			bot_xmas=FALSE;
			if (IS_DEDICATED_SERVER())
			{
				printf("[Config] bot xmas (0) off\n");
			}
			else
			{
				sprintf(msg,"[Config] bot xmas (0) off\n");
				ALERT( at_console, msg);
			}
		}
		else
		{
			if (IS_DEDICATED_SERVER())
			{
				printf("[Config] bot xmas (1) on\n");
			}
			else
			{
				sprintf(msg,"[Config] bot xmas (1) on\n");
				ALERT( at_console, msg);
			}
		}
		return;
	}

	if (strcmp(cmd, "pause") == 0)
	{
		bot_cfg_pause_time = gpGlobals->time + atoi( arg1 );
		if (IS_DEDICATED_SERVER())
		{
			printf("[Config] pause is %s\n",arg1);
		}
		else
		{
			sprintf(msg,"[Config] pause is %s\n",arg1);
			ALERT( at_console, msg);
		}
		return;
	}

	if (strcmp(cmd, "defensive_chatter") == 0)
	{
		int temp = atoi( arg1 );
		if (temp == 0)
			defensive_chatter = false;
		else
			defensive_chatter = true;

		if (IS_DEDICATED_SERVER())
		{
			printf("[Config] defensive chatter is %s\n",arg1);
		}
		else
		{
			sprintf(msg,"[Config] defensive chatter is %s\n",arg1);
			ALERT( at_console, msg);
		}
		return;
	}
	if (strcmp(cmd, "offensive_chatter") == 0)
	{
		int temp = atoi( arg1 );
		if (temp == 0)
			offensive_chatter = false;
		else 
			offensive_chatter = true;

		if (IS_DEDICATED_SERVER())
		{
			printf("[Config] offensive chatter is %s\n",arg1);
		}
		else
		{
			sprintf(msg,"[Config] offensive chatter is %s\n",arg1);
			ALERT( at_console, msg);
		}
		return;
	}	
	if (strcmp(cmd, "frag_commander") == 0)
	{
		int temp = atoi( arg1 );
		if (temp == 0)
			frag_commander = false;
		else 
			frag_commander = true;

		if (IS_DEDICATED_SERVER())
		{
			printf("[Config] Score-based commander is %s\n",arg1);
		}
		else
		{
			sprintf(msg,"[Config] Score-based commander is %s\n",arg1);
			ALERT( at_console, msg);
		}
		return;
	}

	sprintf(msg, "executing server command: %s\n", server_cmd);
	ALERT( at_console, msg );

	if (IS_DEDICATED_SERVER())
		printf(msg);

	SERVER_COMMAND(server_cmd);
} 


void UTIL_SavePent(edict_t *pent)
{
	FILE *fp=fopen("bot.txt", "a");
	fprintf(fp, "*edict_t %x\n", pent);
	fprintf(fp, "classname %s\n", STRING(pent->v.classname));
	fprintf(fp, "globalname %s\n", STRING(pent->v.globalname));
	fprintf(fp, "origin %f %f %f\n", pent->v.origin.x,pent->v.origin.y,pent->v.origin.z);
	fprintf(fp, "oldorigin %f %f %f\n", pent->v.oldorigin.x,pent->v.oldorigin.y,pent->v.oldorigin.z);
	fprintf(fp, "velocity %f %f %f\n", pent->v.velocity.x,pent->v.velocity.y,pent->v.velocity.z);
	fprintf(fp, "basevelocity %f %f %f\n", pent->v.basevelocity.x,pent->v.basevelocity.y,pent->v.basevelocity.z);
	fprintf(fp, "clbasevelocity %f %f %f\n", pent->v.clbasevelocity.x,pent->v.clbasevelocity.y,pent->v.clbasevelocity.z);
	fprintf(fp, "movedir %f %f %f\n", pent->v.movedir.x,pent->v.movedir.y,pent->v.movedir.z);
	fprintf(fp, "angles %f %f %f\n", pent->v.angles.x,pent->v.angles.y,pent->v.angles.z);
	fprintf(fp, "avelocity %f %f %f\n", pent->v.avelocity.x,pent->v.avelocity.y,pent->v.avelocity.z);
	fprintf(fp, "punchangle %f %f %f\n", pent->v.punchangle.x,pent->v.punchangle.y,pent->v.punchangle.z);
	fprintf(fp, "v_angles %f %f %f\n", pent->v.v_angle.x,pent->v.v_angle.y,pent->v.v_angle.z);
	fprintf(fp, "endpos %f %f %f\n", pent->v.endpos.x,pent->v.endpos.y,pent->v.endpos.z);
	fprintf(fp, "startpos %f %f %f\n", pent->v.startpos.x,pent->v.startpos.y,pent->v.startpos.z);
	fprintf(fp, "impacttime %f\n", pent->v.impacttime);
	fprintf(fp, "starttime %f\n", pent->v.starttime);
	fprintf(fp, "fixangle %d\n", pent->v.fixangle);
	fprintf(fp, "idealpitch %f\n", pent->v.idealpitch);
	fprintf(fp, "pitch_speed %f\n", pent->v.pitch_speed);
	fprintf(fp, "ideal_yaw %f\n", pent->v.ideal_yaw);
	fprintf(fp, "yaw_speed %f\n", pent->v.yaw_speed);
	fprintf(fp, "modelindex %d\n", pent->v.modelindex);
	fprintf(fp, "model %s\n", STRING(pent->v.model));
	fprintf(fp, "viewmodel %d\n", pent->v.viewmodel);
	fprintf(fp, "weaponmodel %d\n", pent->v.weaponmodel);
	fprintf(fp, "absmin %f %f %f\n", pent->v.absmin.x,pent->v.absmin.y,pent->v.absmin.z);
	fprintf(fp, "absmax %f %f %f\n", pent->v.absmax.x,pent->v.absmax.y,pent->v.absmax.z);
	fprintf(fp, "mins %f %f %f\n", pent->v.mins.x,pent->v.mins.y,pent->v.mins.z);
	fprintf(fp, "maxs %f %f %f\n", pent->v.maxs.x,pent->v.maxs.y,pent->v.maxs.z);
	fprintf(fp, "size %f %f %f\n", pent->v.size.x,pent->v.size.y,pent->v.size.z);
	fprintf(fp, "ltime %f\n", pent->v.ltime);
	fprintf(fp, "nextthink %f\n", pent->v.nextthink);
	fprintf(fp, "movetype %d\n", pent->v.movetype);
	fprintf(fp, "solid %d\n", pent->v.solid);
	fprintf(fp, "skin %d\n", pent->v.skin);
	fprintf(fp, "body %d\n", pent->v.body);
	fprintf(fp, "effects %d\n", pent->v.effects);
	fprintf(fp, "gravity %f\n", pent->v.gravity);
	fprintf(fp, "friction %f\n", pent->v.friction);
	fprintf(fp, "light_level %d %d\n", pent->v.light_level,GETENTITYILLUM(pent));
	if((pent->v.pContainingEntity)!=NULL)
		fprintf(fp, "cont light_level %d\n", GETENTITYILLUM(pent->v.pContainingEntity));
	fprintf(fp, "health %f\n", pent->v.health);
	fprintf(fp, "frags %f\n", pent->v.frags);
	fprintf(fp, "weapons %d\n", pent->v.weapons);
	fprintf(fp, "takedamage %f\n", pent->v.takedamage);
	fprintf(fp, "deadflag %d\n", pent->v.deadflag);
	fprintf(fp, "view_ofs %f %f %f\n", pent->v.view_ofs.x,pent->v.view_ofs.y,pent->v.view_ofs.z);
	fprintf(fp, "button %d\n", pent->v.button);
	fprintf(fp, "impulse %d\n", pent->v.impulse);
	fprintf(fp, "*chain %x\n", pent->v.chain);
	fprintf(fp, "*dmg_inflictor %x\n", pent->v.dmg_inflictor);
	fprintf(fp, "*enemy %x\n", pent->v.enemy);
	fprintf(fp, "*aiment %x\n", pent->v.aiment);
	fprintf(fp, "*owner %x\n", pent->v.owner);
	fprintf(fp, "*grounentity %x\n", pent->v.groundentity);
	fprintf(fp, "spawnflags %d\n", pent->v.spawnflags);
	fprintf(fp, "flags %d\n", pent->v.flags);
	fprintf(fp, "colormap %d\n", pent->v.colormap);
	fprintf(fp, "team %d\n", pent->v.team);
	fprintf(fp, "max_health %f\n", pent->v.max_health);
	fprintf(fp, "teleport_time %f\n", pent->v.teleport_time);
	fprintf(fp, "armortype %f\n", pent->v.armortype);
	fprintf(fp, "armorvalue %f\n", pent->v.armorvalue);
	fprintf(fp, "waterlevel %d\n", pent->v.waterlevel);
	fprintf(fp, "watertype %d\n", pent->v.watertype);
	fprintf(fp, "target %s\n", STRING(pent->v.target));
	fprintf(fp, "targetname %s\n", STRING(pent->v.targetname));
	fprintf(fp, "netname %s\n", STRING(pent->v.netname));
	fprintf(fp, "message %s\n", STRING(pent->v.message));
	fprintf(fp, "dmg_take %f\n", pent->v.dmg_take);
	fprintf(fp, "dmg_save %f\n", pent->v.dmg_save);
	fprintf(fp, "dmg %f\n", pent->v.dmg);
	fprintf(fp, "dmgtime %f\n", pent->v.dmgtime);
	fprintf(fp, "noise %s\n", STRING(pent->v.noise));
	fprintf(fp, "noise1 %s\n", STRING(pent->v.noise1));
	fprintf(fp, "noise2 %s\n", STRING(pent->v.noise2));
	fprintf(fp, "noise3 %s\n", STRING(pent->v.noise3));
	fprintf(fp, "speed %f\n", pent->v.speed);
	fprintf(fp, "air_finished %f\n", pent->v.air_finished);
	fprintf(fp, "pain_finished %f\n", pent->v.pain_finished);
	fprintf(fp, "pContainingEntity %x\n", (pent->v.pContainingEntity));
	fprintf(fp, "playerclass %d\n", pent->v.playerclass);
	fprintf(fp, "maxspeed %f\n", pent->v.maxspeed);
	fprintf(fp, "fov %f\n", pent->v.fov);
	fprintf(fp, "weaponanim %d\n", pent->v.weaponanim);
	fprintf(fp, "pushmsec %d\n", pent->v.pushmsec);
	fprintf(fp, "bInDuck %d\n", pent->v.bInDuck);
	fprintf(fp, "flTimeStepSound %d\n", pent->v.flTimeStepSound);
	fprintf(fp, "flSwimTime %d\n", pent->v.flSwimTime);
	fprintf(fp, "flDuckTime %d\n", pent->v.flDuckTime);
	fprintf(fp, "iStepLeft %d\n", pent->v.iStepLeft);
	fprintf(fp, "flFallVelocity %f\n", pent->v.flFallVelocity);
	fprintf(fp, "gamestate %d\n", pent->v.gamestate);
	fprintf(fp, "oldbuttons %d\n", pent->v.oldbuttons);
	fprintf(fp, "groupinfo %d\n", pent->v.groupinfo);
	fprintf(fp, "iuser1 %d\n", pent->v.iuser1);
	fprintf(fp, "iuser2 %d\n", pent->v.iuser2);
	fprintf(fp, "iuser3 %d\n", pent->v.iuser3);
	fprintf(fp, "iuser4 %d\n", pent->v.iuser4);
	fprintf(fp, "fuser1 %f\n", pent->v.fuser1);
	fprintf(fp, "fuser2 %f\n", pent->v.fuser2);
	fprintf(fp, "fuser3 %f\n", pent->v.fuser3);
	fprintf(fp, "fuser4 %f\n", pent->v.fuser4);
	fprintf(fp, "vuser1 %f %f %f\n", pent->v.vuser1.x,pent->v.vuser1.y,pent->v.vuser1.z);
	fprintf(fp, "vuser2 %f %f %f\n", pent->v.vuser2.x,pent->v.vuser2.y,pent->v.vuser2.z);
	fprintf(fp, "vuser3 %f %f %f\n", pent->v.vuser3.x,pent->v.vuser3.y,pent->v.vuser3.z);
	fprintf(fp, "vuser4 %f %f %f\n", pent->v.vuser4.x,pent->v.vuser4.y,pent->v.vuser4.z);
	fprintf(fp, "euser1 %x\n", (pent->v.euser1));
	fprintf(fp, "euser2 %x\n", (pent->v.euser2));
	fprintf(fp, "euser3 %x\n", (pent->v.euser3));
	fprintf(fp, "euser4 %x\n", (pent->v.euser4));

	fprintf(fp, "-info buffer %s\n",g_engfuncs.pfnGetInfoKeyBuffer( pent ));
	fclose(fp);
}

void DisplayBotInfo()
{	
	char msg[255];
	char msg2[512];
	if (IS_DEDICATED_SERVER())
	{
		//tell the console all the bot vars
		sprintf(msg,"--FoxBot Loaded--\n--Visit 'www.foxbot.net' for updates and info--\n");
		printf(msg);
		snprintf(msg2,511,msg);

		//sprintf(msg,"--* foxbot v%d.%d build# %d *--\n",VER_MAJOR,VER_MINOR,VER_BUILD);
		sprintf(msg,"--* foxbot v%d.%d *--\n",VER_MAJOR,VER_MINOR);
		printf(msg);
		snprintf(msg2,511,"%s%s",msg2,msg);
		sprintf(msg,"\n--FoxBot info--\n");
		printf(msg);
		snprintf(msg2,511,"%s%s",msg2,msg);
		//waypoints
		if(num_waypoints>0)
			sprintf(msg,"Waypoints loaded\n");
		else
			sprintf(msg,"Waypoints NOT loaded\n--Warning bots will not navigate correctly!--\n");
		printf(msg);
		snprintf(msg2,511,"%s%s",msg2,msg);
		//area file
		if(num_areas>0)
			sprintf(msg,"Areas loaded\n");
		else
			sprintf(msg,"Areas not loaded\n");
		printf(msg);
		snprintf(msg2,511,"%s%s",msg2,msg);
		//scripts...loaded/passed?
		if(script_loaded)
		{
			if(script_parsed)
				sprintf(msg,"Script loaded and parsed\n");
			else
				sprintf(msg,"Script loaded and NOT parsed\n--Warning script file has an error in it, will NOT be used!--\n");
		}
		else
			sprintf(msg,"No script file loaded\n");
		printf(msg);
		snprintf(msg2,511,"%s%s",msg2,msg);

		//now bots vars
		sprintf(msg,"\n--FoxBot vars--\n");
		printf(msg);
		snprintf(msg2,511,"%s%s",msg2,msg);
		//bot skill
		sprintf(msg,"Bot skill %d\n",default_bot_skill);
		printf(msg);
		snprintf(msg2,511,"%s%s",msg2,msg);
		//bot chat
		sprintf(msg,"max_bots %d\nmin_bots %d\n",max_bots,min_bots);
		printf(msg);
		snprintf(msg2,511,"%s%s",msg2,msg);
		if(b_botchat)
			sprintf(msg,"Bot chat on\n");
		else
			sprintf(msg,"Bot chat off\n");
		printf(msg);
		snprintf(msg2,511,"%s%s",msg2,msg);
		if (bot_team_balance)
			sprintf(msg,"Bot auto team balance On\n");
		else
			sprintf(msg,"Bot auto team balance Off\n");
		printf(msg);
		snprintf(msg2,511,"%s%s",msg2,msg);
		if (bot_bot_balance)
			sprintf(msg,"Bot per team balance On\n");
		else
			sprintf(msg,"Bot per team balance Off\n");
		printf(msg);
		snprintf(msg2,511,"%s%s",msg2,msg);
		sprintf(msg,"\n--All bot commands must be inclosed in quotes--\n");
		printf(msg);
		snprintf(msg2,511,"%s%s",msg2,msg);
		sprintf(msg,"e.g. bot \"bot_chat off\"\n\n");
		printf(msg);
		snprintf(msg2,511,"%s%s",msg2,msg);
		ALERT( at_logged,"[FOXBOT]: %s", msg2);
	}
	else
	{
		// have to switch developer 'on' if its not already
		char *cvar_dev = (char *)CVAR_GET_STRING( "developer" );
		int dev;
		if(strcmp(cvar_dev,"0")==0)
			dev=0;
		else
			dev=1;
		//tell the console all the bot vars
		if(dev==0) 
			CVAR_SET_STRING("developer","1");
		CBaseEntity *p;
		p=CBaseEntity::Instance(INDEXENT(1));
		hudtextparms_t h;
		h.channel=4;
		h.effect=1;
		h.r1=10;
		h.g1=53;
		h.b1=81;
		h.a1=255;
		h.r2=10;
		h.g2=53;
		h.b2=81;
		h.a2=168;
		h.fadeinTime=1;
		h.fadeoutTime=1;
		h.holdTime=5;
		h.x=0;
		h.y=0;
		sprintf(msg,"--FoxBot Loaded--\n--Visit 'www.foxbot.net' for updates and info--\n");
		ALERT( at_console, msg );
		snprintf(msg2,511,msg);
		//sprintf(msg,"--* foxbot v%d.%d build# %d *--\n",VER_MAJOR,VER_MINOR,VER_BUILD);
		sprintf(msg,"--* foxbot v%d.%d *--\n",VER_MAJOR,VER_MINOR);
		ALERT( at_console, msg );
		snprintf(msg2,511,"%s%s",msg2,msg);
		sprintf(msg,"\n--FoxBot info--\n");
		ALERT( at_console, msg );
		snprintf(msg2,511,"%s%s",msg2,msg);
		//waypoints
		if(num_waypoints>0)
			sprintf(msg,"Waypoints loaded\n");
		else
			sprintf(msg,"Waypoints NOT loaded\n--Warning bots will not navigate correctly!--\n");
		ALERT( at_console, msg );
		snprintf(msg2,511,"%s%s",msg2,msg);
		//area file
		if(num_areas>0)
			sprintf(msg,"Areas loaded\n");
		else
			sprintf(msg,"Areas not loaded\n");
		ALERT( at_console, msg );
		snprintf(msg2,511,"%s%s",msg2,msg);
		//scripts...loaded/passed?
		if(script_loaded)
		{
			if(script_parsed)
				sprintf(msg,"Script loaded and parsed\n");
			else
				sprintf(msg,"Script loaded and NOT parsed\n--Warning script file has an error in it, will NOT be used!--\n");
		}
		else
			sprintf(msg,"No script file loaded\n");
		ALERT( at_console, msg );
		snprintf(msg2,511,"%s%s",msg2,msg);

		//now bots vars
		sprintf(msg,"\n--FoxBot vars--\n");
		ALERT( at_console, msg );
		snprintf(msg2,511,"%s%s",msg2,msg);
		//bot skill
		sprintf(msg,"Bot skill %d\n",default_bot_skill);
		ALERT( at_console, msg );
		snprintf(msg2,511,"%s%s",msg2,msg);
		//bot chat
		sprintf(msg,"max_bots %d\nmin_bots %d\n",max_bots,min_bots);
		ALERT( at_console, msg );
		snprintf(msg2,511,"%s%s",msg2,msg);
		if(b_botchat)
			sprintf(msg,"Bot chat on\n");
		else
			sprintf(msg,"Bot chat off\n");
		ALERT( at_console, msg );
		snprintf(msg2,511,"%s%s",msg2,msg);
		if (bot_team_balance)
			sprintf(msg,"Bot auto team balance On\n");
		else
			sprintf(msg,"Bot auto team balance Off\n");
		ALERT( at_console, msg );
		snprintf(msg2,511,"%s%s",msg2,msg);

		if (bot_bot_balance)
			sprintf(msg,"Bot per team balance On\n");
		else
			sprintf(msg,"Bot per team balance Off\n");
		ALERT( at_console, msg );
		snprintf(msg2,511,"%s%s",msg2,msg);
		sprintf(msg,"\n");
		ALERT( at_console, msg );
		snprintf(msg2,511,"%s%s",msg2,msg);
		ALERT( at_logged,"[FOXBOT]: %s", msg2);
		ALERT( at_console, "\n\n\n" );
		//clear it up if it was 0
		if(dev==0) 
			CVAR_SET_STRING("developer","0");
		if(!display_bot_vars)
			UTIL_HudMessage(p,h,msg2);
		if(waypoint_author[0]!=NULL)
		{
			h.channel=2;
			h.effect=1;
			h.r1=255;
			h.g1=128;
			h.b1=0;
			h.a1=255;
			h.r2=255;
			h.g2=170;
			h.b2=0;
			h.a2=255;
			h.fadeinTime=1;
			h.fadeoutTime=1;
			h.holdTime=7;
			h.x=-1;
			h.y=0.8;
			sprintf(msg,"-- Waypoint author: %s --",waypoint_author);
			UTIL_HudMessage(p,h,msg);
		}
	}
}



