//
// FoXBot - AI Bot for Halflife's Team Fortress Classic
//
// (http://foxbot.net)
//
// bot_navigate.cpp
//
// Copyright (C) 2003 - Tom "Redfox" Simpson
//
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
//
// See the GNU General Public License for more details at:
// http://www.gnu.org/copyleft/gpl.html
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//


#include "extdll.h"
#include "util.h"
#include "cbase.h"

#include "bot.h"
#include "bot_func.h"
#include "waypoint.h"
#include "bot_weapons.h"
#include "list.h"

extern bot_weapon_t weapon_defs[MAX_WEAPONS];
extern edict_t *clients[32];
extern bot_t bots[32];

extern int mod_id;
extern WAYPOINT waypoints[MAX_WAYPOINTS];
extern PATH *paths[MAX_WAYPOINTS];
extern int num_waypoints;  // number of waypoints currently in use
extern int team_allies[4];
extern edict_t *pent_info_ctfdetect;
extern float is_team_play;
extern bool checked_teamplay;
extern FLAG_S flags[MAX_FLAGS];
extern int num_flags;

//
extern bool bot_can_use_teleporter;
extern bool TPWASUSED=false;
//area defs...
extern AREA areas[MAX_WAYPOINTS];
extern int num_areas;

extern int flf_bug_fix;

int CheckTeleporterExitTime=0;
int a=0;

static FILE *fp;

extern bool g_bot_debug;

extern float last_frame_time;

CBaseEntity *UTIL_FindEntityInSphere( CBaseEntity *pStartEntity, const Vector &vecCenter, float flRadius )
{
	edict_t	*pentEntity;

	if (pStartEntity)
		pentEntity = pStartEntity->edict();
	else
		pentEntity = NULL;

	pentEntity = FIND_ENTITY_IN_SPHERE( pentEntity, vecCenter, flRadius);

	if (!FNullEnt(pentEntity))
		return CBaseEntity::Instance(pentEntity);
	return NULL;
}
void BotFixIdealPitch(edict_t *pEdict)
{
	// check for wrap around of angle...
	if (pEdict->v.idealpitch > 180)
		pEdict->v.idealpitch -= 360;

	if (pEdict->v.idealpitch < -180)
		pEdict->v.idealpitch += 360;
}

float BotChangePitch( bot_t *pBot, float speed )
{
	edict_t *pEdict = pBot->pEdict;
	float ideal = pEdict->v.idealpitch;
	float current = -pEdict->v.v_angle.x;
	float current_180;  // current +/- 180 degrees
	float diff;

	// turn from the current v_angle pitch to the idealpitch by selecting
	// the quickest way to turn to face that direction
	// find the difference in the current and ideal angle
	diff = fabs(current - ideal);

	// check if the bot is already facing the idealpitch direction...
	if (diff <= 0.01)
		return diff;  // return number of degrees turned

	//should keep turn speed the same under any fps...hopefully
	speed *= (gpGlobals->time-last_frame_time);
	speed *= 10;

	// check if difference is less than the max degrees per turn
	if (diff < speed)
		speed = diff;  // just need to turn a little bit (less than max)

	// here we have four cases, both angle positive, one positive and
	// the other negative, one negative and the other positive, or
	// both negative.  handle each case separately...

	if ((current >= 0) && (ideal >= 0))  // both positive
	{
		if (current > ideal)
			current -= speed;
		else
			current += speed;
	}
	else if ((current >= 0) && (ideal < 0))
	{
		current_180 = current - 180;

		if (current_180 > ideal)
			current += speed;
		else
			current -= speed;
	}
	else if ((current < 0) && (ideal >= 0))
	{
		current_180 = current + 180;
		if (current_180 > ideal)
			current += speed;
		else
			current -= speed;
	}
	else  // (current < 0) && (ideal < 0)  both negative
	{
		if (current > ideal)
			current -= speed;
		else
			current += speed;
	}

	// check for wrap around of angle...
	if (current > 180)
		current -= 360;
	if (current < -180)
		current += 360;

	pEdict->v.v_angle.x = current + pEdict->v.punchangle.x;
	pEdict->v.angles.x = pEdict->v.v_angle.x / 3;
	pEdict->v.v_angle.x = -pEdict->v.v_angle.x;
	pEdict->v.angles.z = 0;

	return speed;  // return number of degrees turned
}


void BotFixIdealYaw(edict_t *pEdict)
{
	// check for wrap around of angle...
	if (pEdict->v.ideal_yaw > 180)
		pEdict->v.ideal_yaw -= 360;
	if (pEdict->v.ideal_yaw < -180)
		pEdict->v.ideal_yaw += 360;
}


float BotChangeYaw( bot_t *pBot, float speed )
{
	edict_t *pEdict = pBot->pEdict;
	float ideal = pEdict->v.ideal_yaw;
	float current = pEdict->v.v_angle.y;
	float current_180;  // current +/- 180 degrees
	float diff;

	// turn from the current v_angle yaw to the ideal_yaw by selecting
	// the quickest way to turn to face that direction	
	// find the difference in the current and ideal angle
	diff = fabs(current - ideal);
	// check if the bot is already facing the ideal_yaw direction...
	if (diff <= 0.01)
		return diff;  // return number of degrees turned
	speed *= (gpGlobals->time-last_frame_time);
	speed *= 10;
	// check if difference is less than the max degrees per turn
	if (diff < speed)
		speed = diff;  // just need to turn a little bit (less than max)
	// here we have four cases, both angle positive, one positive and
	// the other negative, one negative and the other positive, or
	// both negative.  handle each case separately...
	if ((current >= 0) && (ideal >= 0))  // both positive
	{
		if (current > ideal)
			current -= speed;
		else
			current += speed;
	}
	else if ((current >= 0) && (ideal < 0))
	{
		current_180 = current - 180;
		if (current_180 > ideal)
			current += speed;
		else
			current -= speed;
	}
	else if ((current < 0) && (ideal >= 0))
	{
		current_180 = current + 180;
		if (current_180 > ideal)
			current += speed;
		else
			current -= speed;
	}
	else  // (current < 0) && (ideal < 0)  both negative
	{
		if (current > ideal)
			current -= speed;
		else
			current += speed;
	}

	// check for wrap around of angle...
	if (current > 180)
		current -= 360;
	if (current < -180)
		current += 360;

	pEdict->v.v_angle.y = current + pEdict->v.punchangle.y;
	pEdict->v.angles.y = pEdict->v.v_angle.y;
	pEdict->v.angles.z = 0;

	return speed;  // return number of degrees turned
}


bool BotFindWaypoint( bot_t *pBot )
{
	BotRoleCheck(pBot);
	// Do whatever you want here to find the next waypoint that the bot should head towards
	int i,k;
	float d;
	edict_t *pEdict = pBot->pEdict;
	if(pBot->f_waypoint_time <= gpGlobals->time)
	{
		pBot->curr_waypoint_index = pBot->goto_wp = -1;
		if(pEdict->v.movetype == MOVETYPE_FLY) 
			pEdict->v.button |= IN_JUMP;
	}
	//ok, try some optimisation here
	if(pEdict->v.playerclass == TFC_CLASS_SCOUT) pBot->ras = true; //should ras all the time..
	if(pBot->f_wpt_check_time > gpGlobals->time && pBot->curr_waypoint_index != -1 && pBot->goto_wp != -1)
	{
		i = pBot->curr_waypoint_index;
		//if same waypoint but not close to it
		if((waypoints[i].flags & W_FL_SNIPER) != W_FL_SNIPER)
		{
			if (pBot->curr_waypoint_index != -1 && mod_id==TFC_DLL)
			{
				Vector v_direction = waypoints[i].origin - pEdict->v.origin;
				Vector bot_angles = UTIL_VecToAngles( v_direction );
				if(!pBot->pBotEnemy) 
				{
					pBot->idle_angle = bot_angles.y;
					pEdict->v.ideal_yaw = pBot->idle_angle;
					if(pBot->backwards)
						pEdict->v.ideal_yaw=pEdict->v.ideal_yaw+180;
					pEdict->v.idealpitch = bot_angles.x;
				} 
				return true;
			}
		}		   
	}
	//only do item shit every 0.6 seconds
	pBot->f_wpt_check_time = gpGlobals->time+0.1;
	// If we dont have a current waypoint, this should get us heading to the closest.
	if (pBot->curr_waypoint_index == -1)
	{
		//clear multi path init, so its recalculated
		pBot->last_dest = -1;
		// find the nearest visible waypoint
		if(RANDOM_FLOAT(0.0, 100.0) < 10) pBot->goto_wp = -1;
		i = WaypointFindNearest(pEdict, REACHABLE_RANGE, UTIL_GetTeam(pEdict));
		if (i != -1)
		{
			Vector v_direction = waypoints[i].origin - pEdict->v.origin;
			Vector bot_angles = UTIL_VecToAngles( v_direction );
			if(pBot->pBotEnemy == NULL) 
			{
				//face backwards
				if(UTIL_GetBotPointer(pEdict)->backwards && UTIL_GetBotPointer(pEdict)->pBotEnemy==NULL)
				{
					bot_angles.y+=180;
					// check for wrap around of angle...
					if (bot_angles.y > 180)
						bot_angles.y -= 360;
					if (bot_angles.y < -180)
						bot_angles.y += 360;
				}

				pBot->idle_angle = bot_angles.y;
				pEdict->v.idealpitch = bot_angles.x;
				pEdict->v.ideal_yaw = pBot->idle_angle;// + RANDOM_FLOAT(0.0, 10.0) - 5.0;
			}// end ras
			pBot->curr_waypoint_index=i;
			pBot->f_waypoint_time=gpGlobals->time + 6;
			return true;
		}
		else
		{
			return FALSE;  // couldn't find a waypoint
		}
	}
	else // if we already have a waypoint
	{
		//fix going to wrong wpt if falling could help wif rocket jumping :D
		if(pEdict->v.velocity.z < -350 && pBot->pEdict->v.waterlevel == 0 &&
			waypoints[pBot->curr_waypoint_index].origin.z > pEdict->v.origin.z && !ENT_IS_ON_FLOOR(pBot->pEdict))
		{
			//UTIL_HostSay(pEdict,0,"I fell off");
			pBot->curr_waypoint_index = WaypointFindNearest(pEdict, REACHABLE_RANGE, UTIL_GetTeam(pEdict));
		}
		// find the nearest visible waypoint
		if(pBot->prev_waypoint_index[0] != pBot->curr_waypoint_index)
		{
			pBot->prev_waypoint_index[1]=pBot->prev_waypoint_index[0];
			pBot->prev_waypoint_index[0]=pBot->curr_waypoint_index;
		}
		i = pBot->curr_waypoint_index;
		//if same waypoint but not close to it
		if (i != -1 && mod_id == TFC_DLL)
		{
			//sniper stay still..random
			d = (waypoints[i].origin - pEdict->v.origin).Length();
			if(((waypoints[i].flags & W_FL_SNIPER) == W_FL_SNIPER) &&
				(pBot->goto_wp==i) && (d<50) &&
				(pEdict->v.playerclass == TFC_CLASS_SNIPER) && pBot->current_weapon.iId == TF_WEAPON_SNIPERRIFLE)
		 {
			 if(pBot->f_snipe_time > gpGlobals->time)
			 {
				 //UTIL_HostSay(pEdict,0,"gr");
				 pBot->f_move_speed = 0;
				 pBot->f_waypoint_time = gpGlobals->time + 6;
				 pEdict->v.button |= IN_ATTACK;   // charge the weapon
				 return true;
			 }
			 else if(pBot->f_snipe_time+2 < gpGlobals->time)
			 {
				 //ntf_feature_antimissile
				 char *cvar_ntf_feature_antimissile = (char *)CVAR_GET_STRING( "ntf_feature_antimissile" );
				 if(strcmp(cvar_ntf_feature_antimissile,"1")==0)
				 {
					 // drop ntf gren pod
					 FakeClientCommand(pEdict,"buildspecial",NULL,NULL);
				 }
				 pBot->f_snipe_time = gpGlobals->time+RANDOM_FLOAT(10.0, 300);
				 pBot->f_move_speed = 0;
				 pBot->f_waypoint_time = gpGlobals->time + 6;
				 pEdict->v.button |= IN_ATTACK;   // charge the weapon
				 return true;
			 }
		 }
			else if(pBot->pBotEnemy == NULL && pBot->f_snipe_time > gpGlobals->time)
		 {
			 //clear it up if were not fighting and we need to navigate!
			 pBot->f_snipe_time=gpGlobals->time;
		 }
		 Vector v_direction = waypoints[i].origin - pEdict->v.origin;

		 //ladder shit, get of the top right
		 if(pEdict->v.movetype == MOVETYPE_FLY && waypoints[i].origin.z > pEdict->v.origin.z)
			 v_direction.z = v_direction.z + 50;

		 Vector bot_angles = UTIL_VecToAngles( v_direction );
		 if(pBot->pBotEnemy==NULL) 
		 {
			 //face backwards
			 if(UTIL_GetBotPointer(pEdict)->backwards && UTIL_GetBotPointer(pEdict)->pBotEnemy==NULL)
			 {
				 bot_angles.y+=180;
				 // check for wrap around of angle...
				 if (bot_angles.y > 180)
					 bot_angles.y -= 360;
				 if (bot_angles.y < -180)
					 bot_angles.y += 360;				  
			 }			  
			 pBot->idle_angle = bot_angles.y;
			 pEdict->v.idealpitch = bot_angles.x;
			 pEdict->v.ideal_yaw = pBot->idle_angle;	 
		 } // end ras
		 d = (waypoints[i].origin - pEdict->v.origin).Length();
		 int dz;
		 //ladder get off probs..this should fix it :D
		 //going up the ladder
		 if(waypoints[i].origin.z > pEdict->v.origin.z )
			 dz = waypoints[i].origin.z - (pEdict->v.origin.z + 90);
		 else
			 dz = waypoints[i].origin.z - pEdict->v.origin.z;
		 if(dz < 0) 
			 dz = -dz;
		 if (((((d<50) && ((waypoints[pBot->curr_waypoint_index].flags & W_FL_LIFT)!=W_FL_LIFT) && 
			 pEdict->v.movetype != MOVETYPE_FLY) || ((d<25) && 
			 ((waypoints[pBot->curr_waypoint_index].flags & W_FL_LIFT)==W_FL_LIFT)) ||
			 (pEdict->v.movetype == MOVETYPE_FLY && d<=40 && dz<=40) ||
			 ((pEdict->v.waterlevel >= 2) && (d<80))) && i!=pBot->goto_wp) || (i==pBot->goto_wp && d<25) || 
			 (((waypoints[pBot->curr_waypoint_index].flags & W_FL_JUMP)==W_FL_JUMP) && d<80))
		 {
			 k = i;
			 int team = UTIL_GetTeam(pEdict);
			 int action;
			 //roaming behaviour...do somthing random.
			 if(pBot->goto_wp == -1 || (pBot->goto_wp==pBot->curr_waypoint_index && !pBot->track_player) || (pEdict->v.health < 5 && !pBot->bot_has_flag))
			 {
				 if(pBot->goto_wp != -1)
				 {
					 if((!((waypoints[pBot->goto_wp].flags & W_FL_TFC_FLAG) == W_FL_TFC_FLAG
						 || (waypoints[pBot->goto_wp].flags & W_FL_TFC_DEFEND) == W_FL_TFC_DEFEND))
						 && pBot->f_snipe_time<gpGlobals->time)
					 {
						 pBot->goto_wp = -1; //clear it so no confusion!
					 }
				 }
				 //clear the junction stuff..just to make sure
				 pBot->last_distance = 0; //was 999999
				 pBot->next_junc = pBot->last_wp[0] = pBot->last_wp[1] = pBot->last_wp[2] = pBot->last_wp[3] = pBot->last_wp[4] = -1;

				 //////////////////////
				 // Choose an action //
				 //////////////////////
				 action = RANDOM_LONG(0, 6);
				 // Scouts/Medics always go for flag.
				 if((pEdict->v.playerclass == TFC_CLASS_SCOUT) || (pEdict->v.playerclass == TFC_CLASS_MEDIC)) action = 0; 
				 // Check for these guys defenders.
				 if (pEdict->v.playerclass == TFC_CLASS_HWGUY || pEdict->v.playerclass == TFC_CLASS_SOLDIER ||
					 pEdict->v.playerclass == TFC_CLASS_DEMOMAN || pEdict->v.playerclass == TFC_CLASS_PYRO)
				 {
					 // Lets choose an action based on our mission
					 if (pBot->mission == pBot->Attacker)
					 {
						 action = 0;
						 if (pEdict->v.playerclass == TFC_CLASS_DEMOMAN && pBot->detpack==2)						 
							 action = 5;						
					 }
					 else if (pBot->mission == pBot->Defender)
						 action = 7;
				 }				 
				 if(pEdict->v.playerclass == TFC_CLASS_SPY && RANDOM_FLOAT(0.0, 10)<8) action = 0;
				 if(pEdict->v.playerclass == TFC_CLASS_SNIPER && RANDOM_FLOAT(0.0, 10)<8) action = 5;				 
				 if(pEdict->v.playerclass == TFC_CLASS_ENGINEER) 
				 {
					 //if we don't have a sg we should have one!!
					 if (!pBot->sg)
					 {
						 action = 5;
						 pBot->goto_wp = -1;
					 }
					 else 
					 {
						 action = 5; // for now.
					 }
					 // Might need to go for metal.
					 if(pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SPANNER].iAmmo1]<140)
					 {
						 pBot->goto_wp = -1;
						 action = 6;
					 }
				 }					 

				 // Might need to go for health.
				 if ((BotHealthValue(pEdict) < 20) && (pBot->mission != pBot->Attacker)) 
					 action = 2;
				 //spawn cheack, do we have armor?
				 if(pBot->spawn_goal_check)
				 {
					 pBot->spawn_goal_check=false;
					 if (BotArmorValue(pEdict) < 75)
					 {
						 action = 3;
						 pBot->goto_wp = -1;
					 }
				 }

				 // Run off if infected.
				 if (BotIsInfected(pEdict))
					 action = 0;

				 //if we have the flag return it!
				 if(pBot->bot_has_flag)
				 {
					 action = 1; 
					 pBot->goto_wp = -1;
				 }

				 int timeout = 0;
				 while((pBot->goto_wp == -1) && (timeout < 4))
				 {
					 switch (action)
					 {
					 case 0: // GO FOR THE FLAG //
						 BotGoForFlag(pBot);						
						 break;
					 case 1: // GO FOR THE FLAG GOAL //
						 BotGoForFlagGoal(pBot);
						 break;
					 case 2:
						 if(BotHealthValue(pEdict) < 40)
							 BotGoForHealth(pBot);
						 break;
					 case 3: // GO FOR ARMOR //
						 if (BotArmorValue(pEdict) < 40)
							 BotGoForArmor(pBot);						 
						 break;
					 case 4: // GO FOR AMMO //
						 BotGoForAmmo(pBot);
						 break;
					 case 5: // CLASS SPECIFIC STUFF //
						 if(pEdict->v.playerclass == TFC_CLASS_SNIPER)
						 {
							 BotGoForSniperSpot(pBot);	

							 //just in case
							 if(pBot->goto_wp == -1) 
								 BotGoForFlag(pBot);												 
						 } else if(pEdict->v.playerclass == TFC_CLASS_DEMOMAN && pBot->detpack==2)
						 {
							 pBot->goto_wp = WaypointFindRandomGoal(pEdict,team,W_FL_TFC_DEMO);
							 if(pBot->goto_wp == -1) 
							 {
								 pBot->goto_wp = WaypointFindRandomGoal(pEdict,-1,W_FL_TFC_DEMO);
								 pBot->mission = pBot->Attacker;
								 pBot->goalType = pBot->Detpack;
							 }
							 if(pBot->goto_wp != -1) pBot->ras = true; //run to det point
							 //just in case
							 if(pBot->goto_wp == -1) 
								 BotGoForFlag(pBot);	
						 } else if(pEdict->v.playerclass == TFC_CLASS_ENGINEER)
						 {
							 // Sg still alive?
							 if(pBot->sg)
							 {
								 if(pBot->sg_edict == NULL)								 
									 pBot->sg = false;								 
								 else if(FNullEnt(pBot->sg_edict))
								 {
									 pBot->sg = false;
									 pBot->sg_edict = NULL;
								 }
							 }
							 // TP entrance still alive?
							 if(pBot->hasTPEntrance)
							 {
								 if(pBot->tpEntrance && pBot->tpEntrance->v.health <= 0.0f)
								 {
									 pBot->hasTPEntrance = false;
									 pBot->tpEntrance = NULL;
								 }
							 }
							 // TP exit still alive?
							 if(pBot->hasTPExit)
							 {
								 if(pBot->tpExit && pBot->tpExit->v.health <= 0.0f)
								 {
									 pBot->hasTPExit = false;
									 pBot->tpExit->v.health = NULL;
								 }
							 }					

							 if(pBot->teleportInfo.pEntrance)
							 {
								 if(pBot->teleportInfo.pEntrance->v.health <= 0.0f)
								 {
									 pBot->goto_wp = pBot->teleportInfo.iFinalGoal;
									 memset(&(pBot->teleportInfo), 0, sizeof(pBot->teleportInfo));
								 }
							 }

							 if(pBot->teleportInfo.pExit)
							 {
								 if(pBot->teleportInfo.pExit->v.health <= 0.0f)
								 {
									 pBot->goto_wp = pBot->teleportInfo.iFinalGoal;
									 memset(&(pBot->teleportInfo), 0, sizeof(pBot->teleportInfo));
								 }
							 }

							 if(RANDOM_LONG(1,1000) < 150)
							 {
								 bool done = false;
								 if(!pBot->hasTPEntrance)
								 {					
									 if(BotGoForTeleportBuild(pBot, W_FL_TFC_TELEPORTER_ENTRANCE))
										 done = true;
								 } 
								 if(!pBot->hasTPExit && !done)
								 {
									 BotGoForTeleportBuild(pBot, W_FL_TFC_TELEPORTER_EXIT);
								 }
								 break;
							 }

							 // Dispenser still alive?
							 if(pBot->dispensor)
							 {
								 if(pBot->dispensor_edict==NULL)
									 pBot->dispensor=false;
								 else if(FNullEnt(pBot->dispensor_edict))
								 {
									 pBot->dispensor = false;
									 pBot->dispensor_edict = NULL;
								 }
							 }
							 if(pBot->sg)
							 {
								 if(WaypointAvailable(pBot->sg_wp,UTIL_GetTeam(pEdict)))
								 {
									 pBot->goto_wp = pBot->sg_wp;
									 pBot->ras = true;
									 if(strcmp(STRING(pBot->sg_edict->v.model),"models/sentry3.mdl")==0 && pBot->sg_edict->v.health == pBot->sg_edict->v.max_health) // TODO: <= optimize this
									 {
										 if(pBot->dispensor == false && pBot->sg_ammo >= 80)
										 {
											 int ntf_mgarmor;
											 char *cvar_ntf_feature_multigun = (char *)CVAR_GET_STRING( "ntf_feature_multigun" );
											 if(strcmp(cvar_ntf_feature_multigun,"1")==0)
											 {
												 char *cvar_ntf_mg_armor = (char *)CVAR_GET_STRING( "ntf_mg_armor" );
												 ntf_mgarmor = atoi(cvar_ntf_mg_armor);
											 }
											 if(pEdict->v.armorvalue >= ntf_mgarmor)
											 {
												 pBot->goto_wp = WaypointFindRandomGoal(pBot->sg_edict->v.origin,pEdict,300,team,0);
												 if(pBot->goto_wp == -1) 
													 pBot->goto_wp = WaypointFindRandomGoal(pBot->sg_edict->v.origin,pEdict,300,-1,0);
												 pBot->mission = pBot->Defender;
												 pBot->goalType = pBot->Builder;
											 }
											 else
											 {
												 pBot->goto_wp = WaypointFindNearestGoal(pEdict,pBot->curr_waypoint_index,team,W_FL_ARMOR);
												 pBot->mission = pBot->Defender;
												 pBot->goalType = pBot->Armor;
												 if(pBot->goto_wp == -1) 
												 {
													 pBot->goto_wp=WaypointFindNearestGoal(pEdict,pBot->curr_waypoint_index,team,W_FL_AMMO);
													 pBot->mission = pBot->Defender;
													 pBot->goalType = pBot->Ammo;
												 }
												 if(pBot->goto_wp == -1) 
												 {
													 pBot->goto_wp = WaypointFindNearestGoal(pEdict,pBot->curr_waypoint_index,-1,W_FL_ARMOR);
													 pBot->mission = pBot->Defender;
													 pBot->goalType = pBot->Armor;
												 }
												 if(pBot->goto_wp == -1) 
												 {
													 pBot->goto_wp = WaypointFindNearestGoal(pEdict,pBot->curr_waypoint_index,-1,W_FL_AMMO);
													 pBot->mission = pBot->Defender;
													 pBot->goalType = pBot->Ammo;
												 }
											 }
										 }
										 else if(pBot->sg_ammo == 100)
										 {
											 // Try to build teleporters.
											 bool done = false;
											 if(!pBot->hasTPEntrance)
											 {					
												 if(BotGoForTeleportBuild(pBot, W_FL_TFC_TELEPORTER_ENTRANCE))
													 done = true;
											 } 
											 if(!pBot->hasTPExit && !done)
											 {
												 BotGoForTeleportBuild(pBot, W_FL_TFC_TELEPORTER_EXIT);
											 }
											 else if(RANDOM_LONG(0,10) >= 8)
											 {
												 timeout++;
												 if(RANDOM_LONG(1,10) < 5)
													 pBot->goto_wp = -1;
												 else
												 {
													 pBot->goto_wp = WaypointFindRandomGoal(pEdict,team,W_FL_TFC_DEFEND);
													 if(pBot->goto_wp == -1) 
														 pBot->goto_wp=WaypointFindRandomGoal(pEdict,-1,W_FL_TFC_DEFEND);
													 pBot->mission = pBot->Defender;
													 pBot->goalType = pBot->Builder;
													 //just in case
													 if(pBot->goto_wp == -1) 
														 pBot->goto_wp = WaypointFindRandomGoal(pEdict,team,W_FL_TFC_FLAG);
													 if(pBot->goto_wp == -1) 
														 pBot->goto_wp = WaypointFindRandomGoal(pEdict,-1,W_FL_TFC_FLAG);
												 }
											 }
										 }
									 }
								 }
								 else
								 {
									 //det the sentry if its a scripted sg pint, and it changed
									 FakeClientCommand(pEdict,"detsentry",NULL,NULL);
									 pBot->sg=false;
									 pBot->sg_edict=NULL;
									 FakeClientCommand(pEdict,"detdispensor",NULL,NULL);
									 pBot->dispensor=false;
									 pBot->dispensor_edict=NULL;
								 }
							 }
							 else
							 {
								 // Try to grab the location closest to our flag first.
								 int OurFlag = -1, closestSGPointToOurFlag = -1;
								 int myTeam = UTIL_GetTeam(pEdict);
								 if (myTeam == 0)
									 OurFlag = WaypointFindNearestGoal(pEdict,pBot->curr_waypoint_index,myTeam+1,W_FL_TFC_FLAG);
								 else if (myTeam == 1)
									 OurFlag = WaypointFindNearestGoal(pEdict,pBot->curr_waypoint_index,myTeam-1,W_FL_TFC_FLAG);
								 if (OurFlag != -1)
									 closestSGPointToOurFlag = WaypointFindNearestGoal(pEdict, OurFlag, myTeam, W_FL_TFC_DEFEND);

								 // 60% chance to go to closest SG to our flag.
								 if (RANDOM_LONG(1,100) < 60)
								 {

									 if ((closestSGPointToOurFlag != -1) && BotSGAtPoint(waypoints[closestSGPointToOurFlag].origin, 700))
										 pBot->goto_wp = WaypointFindRandomGoal(pEdict,team,W_FL_TFC_DEFEND);
									 else if (closestSGPointToOurFlag != -1)
										 pBot->goto_wp = closestSGPointToOurFlag;
								 }
								 if(pBot->goto_wp == -1) pBot->goto_wp = WaypointFindRandomGoal(pEdict,-1,W_FL_TFC_DEFEND);
								 pBot->mission = pBot->Defender;
								 pBot->goalType = pBot->Builder;
								 //just in case
								 if(pBot->goto_wp == -1) 
									 BotGoForFlag(pBot);
							 }
						 }
						 break;
					 case 6: // ARMOR | AMMO //
						 pBot->goto_wp = WaypointFindNearestGoal(pEdict,pBot->curr_waypoint_index,team,W_FL_ARMOR);
						 pBot->goalType = pBot->Armor;
						 if(pBot->goto_wp == -1) 
						 {
							 pBot->goto_wp = WaypointFindNearestGoal(pEdict,pBot->curr_waypoint_index,team,W_FL_AMMO);
							 pBot->goalType = pBot->Ammo;
						 }
						 if(pBot->goto_wp == -1) 
						 {
							 pBot->goto_wp = WaypointFindNearestGoal(pEdict,pBot->curr_waypoint_index,-1,W_FL_ARMOR);
							 pBot->goalType = pBot->Armor;
						 }
						 if(pBot->goto_wp == -1) 
						 {
							 pBot->goto_wp = WaypointFindNearestGoal(pEdict,pBot->curr_waypoint_index,-1,W_FL_AMMO);
							 pBot->goalType = pBot->Ammo;
						 }
						 break;
					 case 7: // DEFENDERS //
						 pBot->f_move_speed = pBot->f_max_speed;
						 int myArmor = BotArmorValue(pBot->pEdict);
						 int myHealth = BotHealthValue(pBot->pEdict);
						 if ( myHealth > 60 && myArmor > 50)
						 {
							 pBot->goto_wp = BotFindDefensePoint(pBot);
							 if (pBot->goto_wp == -1) 
								 pBot->goto_wp = WaypointFindNearestGoal(pEdict,pBot->curr_waypoint_index,team,W_FL_TFC_FLAG);
							 if (pBot->goto_wp == -1) 
								 pBot->goto_wp = WaypointFindNearestGoal(pEdict,pBot->curr_waypoint_index,-1,W_FL_TFC_FLAG);                        						
						 } else
						 {
							 // we are low on health / armor
							 // TODO: maybe make him spam a 2nd nade before heading off
							 if (myHealth <= myArmor)
							 {
								 BotGoForHealth(pBot);
							 } else
							 {

								 pBot->goto_wp = WaypointFindNearestGoal(pEdict,pBot->curr_waypoint_index,team,W_FL_ARMOR);
								 if(pBot->goto_wp == -1) 
									 pBot->goto_wp = WaypointFindNearestGoal(pEdict,pBot->curr_waypoint_index,-1,W_FL_ARMOR);
								 pBot->ras = true;
								 pBot->goalType = pBot->Armor;
							 }
						 }
						 break;
					 };
					 if(pBot->goto_wp == -1) 
						 action = RANDOM_LONG(0, 5);
					 else 
					 {
                //known teleporter bug #2 - fixed by yuraj
					if(CheckTeleporterExitTime < gpGlobals->time)
					{
					a=0;
                    BotFindTeleportShortCut(pBot);
					}
					 k = WaypointRouteFromTo(pBot->curr_waypoint_index,pBot->goto_wp,team);
					 if(k == -1 || k>num_waypoints) 
					 pBot->goto_wp = -1;
					 if(timeout == 0 && RANDOM_LONG(0,99)<50) action = 5;
					 {
					 timeout++;
					 }
					 }
}
				/*char temp[80];
				 sprintf(temp, "action %d, timeout %d", action, timeout);
				 UTIL_HostSay(pBot->pEdict,0, temp);*/

				 if(pBot->goto_wp == -1 && g_bot_debug)
				 {
					 char s[255];
					 sprintf(s,"%s couldn't find a path to an object/goal at %d, looking for",pBot->name,pBot->curr_waypoint_index);
					 if(action==0) sprintf(s,"%s flag/key\n",s);
					 if(action==1) sprintf(s,"%s flag/key cap point\n",s);
					 if(action==2) sprintf(s,"%s health\n",s);
					 if(action==3) sprintf(s,"%s armor\n",s);
					 if(action==4) sprintf(s,"%s ammo\n",s);
					 if(action==5) sprintf(s,"%s sniperspot or defence point waypoint\n",s);
					 ALERT( at_console, s );
				 }
				 //sort out circle waypoint bug??
				 if(pBot->goto_wp != -1) pBot->lastgoto_wp = pBot->goto_wp;
				 if(pBot->goto_wp == -1) pBot->goto_wp = RANDOM_LONG(0, num_waypoints);
				 //go after the last sean enemy....bwahaha!
				 if(pBot->lastenemypos !=-1 && pBot->ras==false && pBot->bot_has_flag==false)
				 {
					 edict_t *pent;
					 pent = NULL; 
					 while ((pent = FIND_ENTITY_BY_CLASSNAME( pent, "item_tfgoal" )) != NULL &&
						 (!FNullEnt(pent))) 
					 {  
						 if (pent->v.owner == pBot->lastenemy && pBot->bot_has_flag==false)  // is this bot carrying the item? 
						 { 
							 pBot->goto_wp=pBot->lastenemypos;
							 pBot->lastenemypos=-1;
							 break;  // break out of while loop 
						 } 
					 }					 
					 if(RANDOM_FLOAT(0.0, 100)<95 && 
						 pEdict->v.health > 20 && pBot->bot_has_flag==false &&
						 pEdict->v.playerclass != TFC_CLASS_SCOUT &&
						 pEdict->v.playerclass != TFC_CLASS_CIVILIAN &&
						 pEdict->v.playerclass != TFC_CLASS_SPY)
					 {
						 pBot->goto_wp=pBot->lastenemypos;
						 pBot->lastenemypos=-1;
					 }
				 }
			 }

			 k = WaypointRouteFromTo(pBot->curr_waypoint_index,pBot->goto_wp,team);
			 if(k!=-1) i=k;
			 // problem with i being -1 or >max wps
			 if(i==-1 || i>num_waypoints) 
			 {
				 i=pBot->curr_waypoint_index;
				 pBot->goto_wp=-1;
			 }
			 Vector v_direction = waypoints[i].origin - pEdict->v.origin;

			 Vector bot_angles = UTIL_VecToAngles( v_direction );
			 if(pBot->pBotEnemy==NULL) 
			 {

				 //if were still insisting on going to the same goal were at
				 //pause and look kewl :D
				 if(pBot->track_player == NULL)
				 {
					 if((v_direction).Length()<100)
					 {						 
						 if(pBot->goto_wp!=-1 && pBot->goto_wp==pBot->curr_waypoint_index 
							 && pBot->goto_wp==pBot->lastgoto_wp && pBot->pBotPickupItem==NULL)
						 {
							 if((waypoints[pBot->goto_wp].flags & W_FL_TFC_FLAG) == W_FL_TFC_FLAG
								 || (waypoints[pBot->goto_wp].flags & W_FL_TFC_DEFEND) == W_FL_TFC_DEFEND
								 || ((waypoints[pBot->goto_wp].flags & W_FL_HEALTH) == W_FL_HEALTH && pEdict->v.health<(pEdict->v.max_health)/2))
							 {
								 //if not an engy, only sit at defend spots and flags and health
								 //or engys sit at anything that isn't a defend spot
								 if(pEdict->v.playerclass != TFC_CLASS_ENGINEER ||
									 (pEdict->v.playerclass == TFC_CLASS_ENGINEER && (waypoints[pBot->goto_wp].flags & W_FL_TFC_DEFEND) != W_FL_TFC_DEFEND))
								 {
									 pBot->f_pause_time=gpGlobals->time+0.5;
									 pBot->f_duck_time=gpGlobals->time+0.9;
								 }
								 else if (pEdict->v.playerclass == TFC_CLASS_ENGINEER && pBot->sg && pBot->sg_edict!=NULL)
								 {
									 //if engy, only sit if sg is level 3
									 if(strcmp(STRING(pBot->sg_edict->v.model),"models/sentry3.mdl")==0)
									 {
										 pBot->f_pause_time=gpGlobals->time+0.5;
										 pBot->f_duck_time=gpGlobals->time+0.9;
									 }
								 }
								 else
								 {
									 pBot->f_pause_time=gpGlobals->time;
									 pBot->f_duck_time=gpGlobals->time;
								 }
							 }
							 else
							 {
								 pBot->f_pause_time=gpGlobals->time;
								 pBot->f_duck_time=gpGlobals->time;
							 }
						 }
						 else
						 {
							 pBot->f_pause_time=gpGlobals->time;
							 pBot->f_duck_time=gpGlobals->time;
						 }

					 }
				 }
				 else
				 {
					 Vector trk = pBot->track_player->v.origin - pEdict->v.origin;
					 if(pBot->goto_wp==pBot->curr_waypoint_index && pBot->goto_wp!=-1
						 && (v_direction).Length()<120
						 && trk.Length()>200)
					 {
						 pBot->f_pause_time=gpGlobals->time+0.2;
					 }
				 }

				 //pEdict->v.v_angle = UTIL_VecToAngles( v_direction );
				 //face backwards
				 if(UTIL_GetBotPointer(pEdict)->backwards && UTIL_GetBotPointer(pEdict)->pBotEnemy==NULL)
				 {
					 bot_angles.y+=180;
					 // check for wrap around of angle...
					 if (bot_angles.y > 180)
						 bot_angles.y -= 360;
					 if (bot_angles.y < -180)
						 bot_angles.y += 360;
					 pEdict->v.v_angle.y+=180;
				 }
				 pBot->idle_angle = bot_angles.y;
				 pEdict->v.idealpitch = bot_angles.x;
				 pEdict->v.ideal_yaw = pBot->idle_angle + RANDOM_FLOAT(0.0, 10.0) - 5.0;
			 }//end ras
			 // amount of time to geto new waypoint
			 if(i!=pBot->curr_waypoint_index) pBot->f_waypoint_time=gpGlobals->time + 6;
			 pBot->curr_waypoint_index = i;
			 if ((pBot->pBotPickupItem!=NULL) && pBot->inact==0)
			 {
				 BotFindItem( pBot );  // see if there are any visible items
			 }
		 }
		 return true;
		}
		{
			return FALSE;  // couldn't find a waypoint
		}
	}
	return false;
}


bool BotHeadTowardWaypoint( bot_t *pBot )
{
	// You could do other stuff here if you needed to.
	// This would probably be a good place to check to see how close to a
	// the current waypoint the bot is, and if the bot is close enough to
	// the desired waypoint then call BotFindWaypoint to find the next one.

	if (BotFindWaypoint(pBot))
		return TRUE;
	else
		return FALSE;
}


void BotOnLadder( bot_t *pBot, float moved_distance )
{	
	Vector v_src, v_dest, view_angles;
	TraceResult tr;
	float angle = 45.0;
	bool done = FALSE;

	edict_t *pEdict = pBot->pEdict;

	// move forward (i.e. in the direction the bot is looking, up or down)
	pEdict->v.button |= IN_FORWARD;
	pBot->backwards=false;
	if(num_waypoints>0) return; // we dont need this function...rf



	// check if the bot has JUST touched this ladder...
	if (pBot->ladder_dir == LADDER_UNKNOWN)
	{
		// try to square up the bot on the ladder...
		while ((!done) && (angle < 180.0))
		{
			// try looking in one direction (forward + angle)
			view_angles = pEdict->v.v_angle;
			view_angles.y = pEdict->v.v_angle.y + angle;

			if (view_angles.y < 0.0)
				view_angles.y += 360.0;
			if (view_angles.y > 360.0)
				view_angles.y -= 360.0;

			UTIL_MakeVectors( view_angles );

			v_src = pEdict->v.origin + pEdict->v.view_ofs;
			v_dest = v_src + gpGlobals->v_forward * 30;

			UTIL_TraceLine( v_src, v_dest, dont_ignore_monsters,
				pEdict->v.pContainingEntity, &tr);

			if (tr.flFraction < 1.0)  // hit something?
			{
				if (strcmp("func_wall", STRING(tr.pHit->v.classname)) == 0)
				{
					// square up to the wall...
					view_angles = UTIL_VecToAngles(tr.vecPlaneNormal);

					// Normal comes OUT from wall, so flip it around...
					view_angles.y += 180;

					if (view_angles.y > 180)
						view_angles.y -= 360;

					pEdict->v.ideal_yaw = view_angles.y;

					BotFixIdealYaw(pEdict);

					done = TRUE;
				}
			}
			else
			{
				// try looking in the other direction (forward - angle)
				view_angles = pEdict->v.v_angle;
				view_angles.y = pEdict->v.v_angle.y - angle;

				if (view_angles.y < 0.0)
					view_angles.y += 360.0;
				if (view_angles.y > 360.0)
					view_angles.y -= 360.0;

				UTIL_MakeVectors( view_angles );

				v_src = pEdict->v.origin + pEdict->v.view_ofs;
				v_dest = v_src + gpGlobals->v_forward * 30;

				UTIL_TraceLine( v_src, v_dest, dont_ignore_monsters,
					pEdict->v.pContainingEntity, &tr);

				if (tr.flFraction < 1.0)  // hit something?
				{
					if (strcmp("func_wall", STRING(tr.pHit->v.classname)) == 0)
					{
						// square up to the wall...
						view_angles = UTIL_VecToAngles(tr.vecPlaneNormal);

						// Normal comes OUT from wall, so flip it around...
						view_angles.y += 180;

						if (view_angles.y > 180)
							view_angles.y -= 360;

						pEdict->v.ideal_yaw = view_angles.y;

						BotFixIdealYaw(pEdict);

						done = TRUE;
					}
				}
			}

			angle += 10;
		}

		if (!done)  // if didn't find a wall, just reset ideal_yaw...
		{
			// set ideal_yaw to current yaw (so bot won't keep turning)
			pEdict->v.ideal_yaw = pEdict->v.v_angle.y;

			BotFixIdealYaw(pEdict);
		}
	}

	// moves the bot up or down a ladder.  if the bot can't move
	// (i.e. get's stuck with someone else on ladder), the bot will
	// change directions and go the other way on the ladder.

	if (pBot->ladder_dir == LADDER_UP)  // is the bot currently going up?
	{
		pEdict->v.v_angle.x = -60;  // look upwards

		// check if the bot hasn't moved much since the last location...
		if ((moved_distance <= 1) && (pBot->prev_speed >= 1.0))
		{
			// the bot must be stuck, change directions...

			pEdict->v.v_angle.x = 60;  // look downwards
			pBot->ladder_dir = LADDER_DOWN;
		}
	}
	else if (pBot->ladder_dir == LADDER_DOWN)  // is the bot currently going down?
	{
		pEdict->v.v_angle.x = 60;  // look downwards

		// check if the bot hasn't moved much since the last location...
		if ((moved_distance <= 1) && (pBot->prev_speed >= 1.0))
		{
			// the bot must be stuck, change directions...

			pEdict->v.v_angle.x = -60;  // look upwards
			pBot->ladder_dir = LADDER_UP;
		}
	}
	else  // the bot hasn't picked a direction yet, try going up...
	{
		pEdict->v.v_angle.x = -60;  // look upwards
		pBot->ladder_dir = LADDER_UP;
	}

	// move forward (i.e. in the direction the bot is looking, up or down)
	pEdict->v.button |= IN_FORWARD;
}


void BotUnderWater( bot_t *pBot )
{
	bool found_waypoint = FALSE;

	edict_t *pEdict = pBot->pEdict;

	// are there waypoints in this level (and not trying to exit water)?
	if ((num_waypoints > 0) &&
		(pBot->f_exit_water_time < gpGlobals->time))
	{
		// head towards a waypoint
		found_waypoint = BotHeadTowardWaypoint(pBot);
	}

	if (found_waypoint == FALSE)
	{
		// handle movements under water.  right now, just try to keep from
		// drowning by swimming up towards the surface and look to see if
		// there is a surface the bot can jump up onto to get out of the
		// water.  bots DON'T like water!

		Vector v_src, v_forward;
		TraceResult tr;
		int contents;

		// swim up towards the surface
		pEdict->v.v_angle.x = -60;  // look upwards

		// move forward (i.e. in the direction the bot is looking, up or down)
		pEdict->v.button |= IN_FORWARD;

		// set gpGlobals angles based on current view angle (for TraceLine)
		UTIL_MakeVectors( pEdict->v.v_angle );

		// look from eye position straight forward (remember: the bot is looking
		// upwards at a 60 degree angle so TraceLine will go out and up...

		v_src = pEdict->v.origin + pEdict->v.view_ofs;  // EyePosition()
		v_forward = v_src + gpGlobals->v_forward * 90;

		// trace from the bot's eyes straight forward...
		UTIL_TraceLine( v_src, v_forward, dont_ignore_monsters,
			pEdict->v.pContainingEntity, &tr);

		// check if the trace didn't hit anything (i.e. nothing in the way)...
		if (tr.flFraction >= 1.0)
		{
			// find out what the contents is of the end of the trace...
			contents = UTIL_PointContents( tr.vecEndPos );

			// check if the trace endpoint is in open space...
			if (contents == CONTENTS_EMPTY)
			{
				// ok so far, we are at the surface of the water, continue...

				v_src = tr.vecEndPos;
				v_forward = v_src;
				v_forward.z -= 90;

				// trace from the previous end point straight down...
				UTIL_TraceLine( v_src, v_forward, dont_ignore_monsters,
					pEdict->v.pContainingEntity, &tr);

				// check if the trace hit something...
				if (tr.flFraction < 1.0)
				{
					contents = UTIL_PointContents( tr.vecEndPos );

					// if contents isn't water then assume it's land, jump!
					if (contents != CONTENTS_WATER)
					{
						pEdict->v.button |= IN_JUMP;
					}
				}
			}
		}
	}
}


void BotUseLift( bot_t *pBot, float moved_distance )
{
	edict_t *pEdict = pBot->pEdict;

	// just need to press the button once, when the flag gets set...
	if (pBot->f_use_button_time == gpGlobals->time)
	{

		// face opposite from the button
		//pEdict->v.ideal_yaw += 180;  // rotate 180 degrees
		//deal with push/shoot buttons
		if(pBot->pBotPickupItem!=NULL)
		{
			if((pBot->pBotPickupItem->v.spawnflags & 256)==256) 
				pEdict->v.button = IN_FORWARD;
			else
			{
				pBot->f_pause_time=gpGlobals->time+1;
				pEdict->v.button = IN_USE;
			}
		}
		else
		{
			pBot->f_pause_time=gpGlobals->time+1;
			pEdict->v.button = IN_USE;
		}

		BotFixIdealYaw(pEdict);
	}

	// check if the bot has waited too long for the lift to move...
	if (((pBot->f_use_button_time + 2.0) < gpGlobals->time) &&
		(!pBot->b_lift_moving))
	{
		// clear use button flag
		pBot->b_use_button = FALSE;

		// bot doesn't have to set f_find_item since the bot
		// should already be facing away from the button

		pBot->f_move_speed = pBot->f_max_speed;
	}

	// check if lift has started moving...
	if ((moved_distance > 1) && (!pBot->b_lift_moving))
	{
		pBot->b_lift_moving = TRUE;
		pBot->f_pause_time=gpGlobals->time+0.5;
	}

	// check if lift has stopped moving...
	if ((moved_distance <= 1) && (pBot->b_lift_moving))
	{
		TraceResult tr1, tr2;
		Vector v_src, v_forward, v_right, v_left;
		Vector v_down, v_forward_down, v_right_down, v_left_down;

		pBot->b_use_button = FALSE;

		// TraceLines in 4 directions to find which way to go...

		UTIL_MakeVectors( pEdict->v.v_angle );

		v_src = pEdict->v.origin + pEdict->v.view_ofs;
		v_forward = v_src + gpGlobals->v_forward * 90;
		v_right = v_src + gpGlobals->v_right * 90;
		v_left = v_src + gpGlobals->v_right * -90;

		v_down = pEdict->v.v_angle;
		v_down.x = v_down.x + 45;  // look down at 45 degree angle

		UTIL_MakeVectors( v_down );

		v_forward_down = v_src + gpGlobals->v_forward * 100;
		v_right_down = v_src + gpGlobals->v_right * 100;
		v_left_down = v_src + gpGlobals->v_right * -100;

		// try tracing forward first...
		UTIL_TraceLine( v_src, v_forward, dont_ignore_monsters,
			pEdict->v.pContainingEntity, &tr1);
		UTIL_TraceLine( v_src, v_forward_down, dont_ignore_monsters,
			pEdict->v.pContainingEntity, &tr2);

		// check if we hit a wall or didn't find a floor...
		if ((tr1.flFraction < 1.0) || (tr2.flFraction >= 1.0))
		{
			// try tracing to the RIGHT side next...
			UTIL_TraceLine( v_src, v_right, dont_ignore_monsters,
				pEdict->v.pContainingEntity, &tr1);
			UTIL_TraceLine( v_src, v_right_down, dont_ignore_monsters,
				pEdict->v.pContainingEntity, &tr2);

			// check if we hit a wall or didn't find a floor...
			if ((tr1.flFraction < 1.0) || (tr2.flFraction >= 1.0))
			{
				// try tracing to the LEFT side next...
				UTIL_TraceLine( v_src, v_left, dont_ignore_monsters,
					pEdict->v.pContainingEntity, &tr1);
				UTIL_TraceLine( v_src, v_left_down, dont_ignore_monsters,
					pEdict->v.pContainingEntity, &tr2);

				// check if we hit a wall or didn't find a floor...
				if ((tr1.flFraction < 1.0) || (tr2.flFraction >= 1.0))
				{
					// only thing to do is turn around...
					pEdict->v.ideal_yaw += 180;  // turn all the way around
				}
				else
				{
					pEdict->v.ideal_yaw += 90;  // turn to the LEFT
				}
			}
			else
			{
				pEdict->v.ideal_yaw -= 90;  // turn to the RIGHT
			}

			BotFixIdealYaw(pEdict);
		}

		BotChangeYaw( pBot, pEdict->v.yaw_speed );

		pBot->f_move_speed = pBot->f_max_speed;
	}
}


bool BotStuckInCorner( bot_t *pBot )
{
	TraceResult tr;
	Vector v_src, v_dest;
	edict_t *pEdict = pBot->pEdict;

	UTIL_MakeVectors( pEdict->v.v_angle );

	// trace 45 degrees to the right...
	v_src = pEdict->v.origin;
	v_dest = v_src + gpGlobals->v_forward*20 + gpGlobals->v_right*20;

	UTIL_TraceLine( v_src, v_dest, dont_ignore_monsters,
		pEdict->v.pContainingEntity, &tr);

	if (tr.flFraction >= 1.0)
		return FALSE;  // no wall, so not in a corner

	// trace 45 degrees to the left...
	v_src = pEdict->v.origin;
	v_dest = v_src + gpGlobals->v_forward*20 - gpGlobals->v_right*20;

	UTIL_TraceLine( v_src, v_dest, dont_ignore_monsters,
		pEdict->v.pContainingEntity, &tr);

	if (tr.flFraction >= 1.0)
		return FALSE;  // no wall, so not in a corner

	return TRUE;  // bot is in a corner
}


void BotTurnAtWall( bot_t *pBot, TraceResult *tr )
{
	edict_t *pEdict = pBot->pEdict;
	Vector Normal;
	float Y, Y1, Y2, D1, D2, Z;

	// Find the normal vector from the trace result.  The normal vector will
	// be a vector that is perpendicular to the surface from the TraceResult.

	Normal = UTIL_VecToAngles(tr->vecPlaneNormal);

	// Since the bot keeps it's view angle in -180 < x < 180 degrees format,
	// and since TraceResults are 0 < x < 360, we convert the bot's view
	// angle (yaw) to the same format at TraceResult.

	Y = pEdict->v.v_angle.y;
	Y = Y + 180;
	if (Y > 359) Y -= 360;

	// Turn the normal vector around 180 degrees (i.e. make it point towards
	// the wall not away from it.  That makes finding the angles that the
	// bot needs to turn a little easier.

	Normal.y = Normal.y - 180;
	if (Normal.y < 0)
		Normal.y += 360;

	// Here we compare the bots view angle (Y) to the Normal - 90 degrees (Y1)
	// and the Normal + 90 degrees (Y2).  These two angles (Y1 & Y2) represent
	// angles that are parallel to the wall surface, but heading in opposite
	// directions.  We want the bot to choose the one that will require the
	// least amount of turning (saves time) and have the bot head off in that
	// direction.

	Y1 = Normal.y - 90;
	if (RANDOM_LONG(1, 100) <= 50)
	{
		Y1 = Y1 - RANDOM_FLOAT(5.0, 20.0);
	}
	if (Y1 < 0) Y1 += 360;

	Y2 = Normal.y + 90;
	if (RANDOM_LONG(1, 100) <= 50)
	{
		Y2 = Y2 + RANDOM_FLOAT(5.0, 20.0);
	}
	if (Y2 > 359) Y2 -= 360;

	// D1 and D2 are the difference (in degrees) between the bot's current
	// angle and Y1 or Y2 (respectively).

	D1 = abs(Y - Y1);
	if (D1 > 179) D1 = abs(D1 - 360);
	D2 = abs(Y - Y2);
	if (D2 > 179) D2 = abs(D2 - 360);

	// If difference 1 (D1) is more than difference 2 (D2) then the bot will
	// have to turn LESS if it heads in direction Y1 otherwise, head in
	// direction Y2.  I know this seems backwards, but try some sample angles
	// out on some graph paper and go through these equations using a
	// calculator, you'll see what I mean.

	if (D1 > D2)
		Z = Y1;
	else
		Z = Y2;

	// convert from TraceResult 0 to 360 degree format back to bot's
	// -180 to 180 degree format.

	if (Z > 180)
		Z -= 360;

	// set the direction to head off into...
	pEdict->v.ideal_yaw = Z;

	BotFixIdealYaw(pEdict);
}


bool BotCantMoveForward( bot_t *pBot, TraceResult *tr )
{
	edict_t *pEdict = pBot->pEdict;

	// use some TraceLines to determine if anything is blocking the current
	// path of the bot.

	Vector v_src, v_forward;

	UTIL_MakeVectors( pEdict->v.v_angle );

	// first do a trace from the bot's eyes forward...

	v_src = pEdict->v.origin + pEdict->v.view_ofs;  // EyePosition()
	v_forward = v_src + gpGlobals->v_forward * 40;

	// trace from the bot's eyes straight forward...
	UTIL_TraceLine( v_src, v_forward, dont_ignore_monsters,
		pEdict->v.pContainingEntity, tr);

	// check if the trace hit something...
	if (tr->flFraction < 1.0)
	{
		return TRUE;  // bot's head will hit something
	}

	// bot's head is clear, check at waist level...

	v_src = pEdict->v.origin;
	v_forward = v_src + gpGlobals->v_forward * 40;

	// trace from the bot's waist straight forward...
	UTIL_TraceLine( v_src, v_forward, dont_ignore_monsters,
		pEdict->v.pContainingEntity, tr);

	// check if the trace hit something...
	if (tr->flFraction < 1.0)
	{
		return TRUE;  // bot's body will hit something
	}

	return FALSE;  // bot can move forward, return false
}


bool BotCanJumpUp( bot_t *pBot )
{
	// What I do here is trace 3 lines straight out, one unit higher than
	// the highest normal jumping distance.  I trace once at the center of
	// the body, once at the right side, and once at the left side.  If all
	// three of these TraceLines don't hit an obstruction then I know the
	// area to jump to is clear.  I then need to trace from head level,
	// above where the bot will jump to, downward to see if there is anything
	// blocking the jump.  There could be a narrow opening that the body
	// will not fit into.  These horizontal and vertical TraceLines seem
	// to catch most of the problems with falsely trying to jump on something
	// that the bot can not get onto.

	// Don't jump at tps
	if(pBot->f_tp_find_time >= gpGlobals->time)
		return FALSE;

	TraceResult tr;
	Vector v_jump, v_source, v_dest;
	edict_t *pEdict = pBot->pEdict;

	// convert current view angle to vectors for TraceLine math...

	v_jump = pEdict->v.v_angle;
	v_jump.x = 0;  // reset pitch to 0 (level horizontally)
	v_jump.z = 0;  // reset roll to 0 (straight up and down)

	UTIL_MakeVectors( v_jump );

	// use center of the body first...

	// maximum jump height is 45, so check one unit above that (46)
	int hight=66;
	v_source = pEdict->v.origin + Vector(0, 0, -36 + hight);
	v_dest = v_source + gpGlobals->v_forward * 24;

	// trace a line forward at maximum jump height...
	UTIL_TraceLine( v_source, v_dest, dont_ignore_monsters,
		pEdict->v.pContainingEntity, &tr);

	// if trace hit something, return FALSE
	if (tr.flFraction < 1.0)
		return FALSE;

	// now check same height to one side of the bot...
	v_source = pEdict->v.origin + gpGlobals->v_right * 16 + Vector(0, 0, -36 + hight);
	v_dest = v_source + gpGlobals->v_forward * 24;

	// trace a line forward at maximum jump height...
	UTIL_TraceLine( v_source, v_dest, dont_ignore_monsters,
		pEdict->v.pContainingEntity, &tr);

	// if trace hit something, return FALSE
	if (tr.flFraction < 1.0)
		return FALSE;

	// now check same height on the other side of the bot...
	v_source = pEdict->v.origin + gpGlobals->v_right * -16 + Vector(0, 0, -36 + hight);
	v_dest = v_source + gpGlobals->v_forward * 24;

	// trace a line forward at maximum jump height...
	UTIL_TraceLine( v_source, v_dest, dont_ignore_monsters,
		pEdict->v.pContainingEntity, &tr);

	// if trace hit something, return FALSE
	if (tr.flFraction < 1.0)
		return FALSE;

	// now trace from head level downward to check for obstructions...

	// start of trace is 24 units in front of bot, 72 units above head...
	v_source = pEdict->v.origin + gpGlobals->v_forward * 24;

	// offset 72 units from top of head (72 + 36)
	v_source.z = v_source.z + 108;

	// end point of trace is 99 units straight down from start...
	// (99 is 108 minus the jump limit height which is 45 - 36 = 9)
	//was -99
	v_dest = v_source + Vector(0, 0, -(108-(hight-36)));

	// trace a line straight down toward the ground...
	UTIL_TraceLine( v_source, v_dest, dont_ignore_monsters,
		pEdict->v.pContainingEntity, &tr);

	// if trace hit something, return FALSE
	if (tr.flFraction < 1.0)
		return FALSE;

	// now check same height to one side of the bot...
	v_source = pEdict->v.origin + gpGlobals->v_right * 16 + gpGlobals->v_forward * 24;
	v_source.z = v_source.z + 108;
	v_dest = v_source + Vector(0, 0, -(108-(hight-36)));

	// trace a line straight down toward the ground...
	UTIL_TraceLine( v_source, v_dest, dont_ignore_monsters,
		pEdict->v.pContainingEntity, &tr);

	// if trace hit something, return FALSE
	if (tr.flFraction < 1.0)
		return FALSE;

	// now check same height on the other side of the bot...
	v_source = pEdict->v.origin + gpGlobals->v_right * -16 + gpGlobals->v_forward * 24;
	v_source.z = v_source.z + 108;
	v_dest = v_source + Vector(0, 0, -(108-(hight-36)));

	// trace a line straight down toward the ground...
	UTIL_TraceLine( v_source, v_dest, dont_ignore_monsters,
		pEdict->v.pContainingEntity, &tr);

	// if trace hit something, return FALSE
	if (tr.flFraction < 1.0)
		return FALSE;

	return TRUE;
}


bool BotCanDuckUnder( bot_t *pBot )
{
	// What I do here is trace 3 lines straight out, one unit higher than
	// the ducking height.  I trace once at the center of the body, once
	// at the right side, and once at the left side.  If all three of these
	// TraceLines don't hit an obstruction then I know the area to duck to
	// is clear.  I then need to trace from the ground up, 72 units, to make
	// sure that there is something blocking the TraceLine.  Then we know
	// we can duck under it.

	TraceResult tr;
	Vector v_duck, v_source, v_dest;
	edict_t *pEdict = pBot->pEdict;

	// convert current view angle to vectors for TraceLine math...

	v_duck = pEdict->v.v_angle;
	v_duck.x = 0;  // reset pitch to 0 (level horizontally)
	v_duck.z = 0;  // reset roll to 0 (straight up and down)

	UTIL_MakeVectors( v_duck );

	// use center of the body first...

	// duck height is 36, so check one unit above that (37)
	v_source = pEdict->v.origin + Vector(0, 0, -36 + 37);
	v_dest = v_source + gpGlobals->v_forward * 24;

	// trace a line forward at duck height...
	UTIL_TraceLine( v_source, v_dest, dont_ignore_monsters,
		pEdict->v.pContainingEntity, &tr);

	// if trace hit something, return FALSE
	if (tr.flFraction < 1.0)
		return FALSE;

	// now check same height to one side of the bot...
	v_source = pEdict->v.origin + gpGlobals->v_right * 16 + Vector(0, 0, -36 + 37);
	v_dest = v_source + gpGlobals->v_forward * 24;

	// trace a line forward at duck height...
	UTIL_TraceLine( v_source, v_dest, dont_ignore_monsters,
		pEdict->v.pContainingEntity, &tr);

	// if trace hit something, return FALSE
	if (tr.flFraction < 1.0)
		return FALSE;

	// now check same height on the other side of the bot...
	v_source = pEdict->v.origin + gpGlobals->v_right * -16 + Vector(0, 0, -36 + 37);
	v_dest = v_source + gpGlobals->v_forward * 24;

	// trace a line forward at duck height...
	UTIL_TraceLine( v_source, v_dest, dont_ignore_monsters,
		pEdict->v.pContainingEntity, &tr);

	// if trace hit something, return FALSE
	if (tr.flFraction < 1.0)
		return FALSE;

	// now trace from the ground up to check for object to duck under...

	// start of trace is 24 units in front of bot near ground...
	v_source = pEdict->v.origin + gpGlobals->v_forward * 24;
	v_source.z = v_source.z - 35;  // offset to feet + 1 unit up

	// end point of trace is 72 units straight up from start...
	v_dest = v_source + Vector(0, 0, 72);

	// trace a line straight up in the air...
	UTIL_TraceLine( v_source, v_dest, dont_ignore_monsters,
		pEdict->v.pContainingEntity, &tr);

	// if trace didn't hit something, return FALSE
	if (tr.flFraction >= 1.0)
		return FALSE;

	// now check same height to one side of the bot...
	v_source = pEdict->v.origin + gpGlobals->v_right * 16 + gpGlobals->v_forward * 24;
	v_source.z = v_source.z - 35;  // offset to feet + 1 unit up
	v_dest = v_source + Vector(0, 0, 72);

	// trace a line straight up in the air...
	UTIL_TraceLine( v_source, v_dest, dont_ignore_monsters,
		pEdict->v.pContainingEntity, &tr);

	// if trace didn't hit something, return FALSE
	if (tr.flFraction >= 1.0)
		return FALSE;

	// now check same height on the other side of the bot...
	v_source = pEdict->v.origin + gpGlobals->v_right * -16 + gpGlobals->v_forward * 24;
	v_source.z = v_source.z - 35;  // offset to feet + 1 unit up
	v_dest = v_source + Vector(0, 0, 72);

	// trace a line straight up in the air...
	UTIL_TraceLine( v_source, v_dest, dont_ignore_monsters,
		pEdict->v.pContainingEntity, &tr);

	// if trace didn't hit something, return FALSE
	if (tr.flFraction >= 1.0)
		return FALSE;

	return TRUE;
}


void BotRandomTurn( bot_t *pBot )
{
	pBot->f_move_speed = 0;  // don't move while turning

	if (RANDOM_LONG(1, 100) <= 10)
	{
		// 10 percent of the time turn completely around...
		pBot->pEdict->v.ideal_yaw += 180;
	}
	else
	{
		// turn randomly between 30 and 60 degress
		if (pBot->wander_dir == WANDER_LEFT)
			pBot->pEdict->v.ideal_yaw += RANDOM_LONG(30, 60);
		else
			pBot->pEdict->v.ideal_yaw -= RANDOM_LONG(30, 60);
	}

	BotFixIdealYaw(pBot->pEdict);
}


bool BotFollowUser( bot_t *pBot )
{
	return false;
	bool user_visible;
	float f_distance;
	edict_t *pEdict = pBot->pEdict;

	Vector vecEnd = pBot->pBotUser->v.origin + pBot->pBotUser->v.view_ofs;

	if (pBot->pEdict->v.waterlevel != 3)  // is bot NOT under water?
		pEdict->v.v_angle.x = 0;  // reset pitch to 0 (level horizontally)

	pEdict->v.v_angle.z = 0;  // reset roll to 0 (straight up and down)

	pEdict->v.angles.x = 0;
	pEdict->v.angles.y = pEdict->v.v_angle.y;
	pEdict->v.angles.z = 0;

	if( pBot->pBotUser==NULL ) return FALSE;
	if (!IsAlive( pBot->pBotUser ))
	{
		// the bot's user is dead!
		pBot->pBotUser = NULL;
		return FALSE;
	}

	user_visible = FInViewCone( &vecEnd, pEdict ) && FVisible( vecEnd, pEdict );

	// check if the "user" is still visible or if the user has been visible
	// in the last 5 seconds (or the player just starting "using" the bot)

	if (user_visible || (pBot->f_bot_use_time + 5 > gpGlobals->time))
	{
		if (user_visible)
			pBot->f_bot_use_time = gpGlobals->time;  // reset "last visible time"

		// face the user
		Vector v_user = pBot->pBotUser->v.origin - pEdict->v.origin;
		Vector bot_angles = UTIL_VecToAngles( v_user );

		pEdict->v.ideal_yaw = bot_angles.y;

		BotFixIdealYaw(pEdict);

		f_distance = v_user.Length( );  // how far away is the "user"?

		if (f_distance > 200)      // run if distance to enemy is far
			pBot->f_move_speed = pBot->f_max_speed;
		else if (f_distance > 20)  // walk if distance is closer
			pBot->f_move_speed = pBot->f_max_speed / 2;
		else                     // don't move if close enough
			pBot->f_move_speed = 0.0;

		if (f_distance < 50 && pBot->follow)
			pBot->f_move_speed = 0.0;

		return TRUE;
	}
	else
	{
		// person to follow has gone out of sight...
		pBot->pBotUser = NULL;

		return FALSE;
	}
}


bool BotCheckWallOnLeft( bot_t *pBot )
{
	edict_t *pEdict = pBot->pEdict;
	Vector v_src, v_left;
	TraceResult tr;

	UTIL_MakeVectors( pEdict->v.v_angle );

	// do a trace to the left...

	v_src = pEdict->v.origin;
	v_left = v_src + gpGlobals->v_right * -40;  // 40 units to the left

	UTIL_TraceLine( v_src, v_left, dont_ignore_monsters,
		pEdict->v.pContainingEntity, &tr);

	// check if the trace hit something...
	if (tr.flFraction < 1.0)
	{
		if (pBot->f_wall_on_left < 1.0)
			pBot->f_wall_on_left = gpGlobals->time;

		return TRUE;
	}

	return FALSE;
}


bool BotCheckWallOnRight( bot_t *pBot )
{
	edict_t *pEdict = pBot->pEdict;
	Vector v_src, v_right;
	TraceResult tr;
	UTIL_MakeVectors( pEdict->v.v_angle );
	// do a trace to the right...
	v_src = pEdict->v.origin;
	v_right = v_src + gpGlobals->v_right * 40;  // 40 units to the right
	UTIL_TraceLine( v_src, v_right, dont_ignore_monsters,
		pEdict->v.pContainingEntity, &tr);
	// check if the trace hit something...
	if (tr.flFraction < 1.0)
	{
		if (pBot->f_wall_on_right < 1.0)
			pBot->f_wall_on_right = gpGlobals->time;
		return TRUE;
	}
	return FALSE;
}

int BotFindDefensePoint(bot_t *pBot)
{
	// BotFindDefensePoint - This function returns an unused defense point
	int team = UTIL_GetTeam(pBot->pEdict);
	int wp = -1;
	// If he's a demo, try to find him a pipetrap defend point first.
	if (pBot->pEdict->v.playerclass == TFC_CLASS_DEMOMAN)
	{
		//wp = WaypointFindNearestGoal(pBot->pEdict, pBot->curr_waypoint_index, team, W_FL_TFC_PIPETRAP);
		wp = WaypointFindRandomGoal(pBot->pEdict, team, W_FL_TFC_PIPETRAP);
		if (wp == -1 || BotDefenderAtPoint(pBot, waypoints[wp].origin, 300) || !WaypointAvailable(wp, team))
		{
			for (int i = 0; i < 10; i++)
			{
				wp = WaypointFindRandomGoal(pBot->pEdict, -1, W_FL_TFC_PIPETRAP);
				if (wp != -1 && !BotDefenderAtPoint(pBot, waypoints[wp].origin, 300) && WaypointAvailable(wp, team))
				{
					pBot->defendPoint = wp;
					return wp;
				} else
					wp = -1;
			}
		} else
		{
			pBot->defendPoint = wp;
			return wp;
		}
	}
	wp = WaypointFindNearestGoal(pBot->pEdict, pBot->curr_waypoint_index, team, W_FL_TFC_PL_DEFEND);
	// Is there someone there?
	if (BotDefenderAtPoint(pBot, waypoints[wp].origin, 400) || !WaypointAvailable(wp, team))
		wp = WaypointFindNearestGoal(pBot->pEdict, pBot->curr_waypoint_index, -1, W_FL_TFC_PL_DEFEND);

	if (BotDefenderAtPoint(pBot, waypoints[wp].origin, 400) || !WaypointAvailable(wp, team))
	{		
		for (int i = 0; i < 10; i++)
		{
			wp = WaypointFindRandomGoal(pBot->pEdict, -1, W_FL_TFC_PL_DEFEND);
			if (!BotDefenderAtPoint(pBot, waypoints[wp].origin, 400) && WaypointAvailable(wp, team))
				break;
			else
				wp = -1;
		}		
	}	
	if (wp != -1) 	
		pBot->defendPoint = wp;	

	return wp;
}

bool BotGoForAmmo(bot_t * pBot)
{
	// BotGoForAmmo - This function sends a bot after an ammo pack. 
	// Returns true if successful, false otherwise.
	int team = UTIL_GetTeam(pBot->pEdict);

	pBot->goto_wp = WaypointFindNearestGoal(pBot->pEdict,pBot->curr_waypoint_index,team,W_FL_AMMO);
	if(pBot->goto_wp == -1) pBot->goto_wp = WaypointFindRandomGoal(pBot->pEdict,team,W_FL_AMMO);
	if(pBot->goto_wp == -1) pBot->goto_wp = WaypointFindRandomGoal(pBot->pEdict,-1,W_FL_AMMO);

	if(pBot->goto_wp == -1)
		return false;
	else
	{
		pBot->goalType = pBot->Ammo;
		return true;		
	}	
}

bool BotGoForTeleportBuild(bot_t *pBot, int iType)
{
	// BotGoForAmmo - This function sends a bot after an ammo pack. 
	// Returns true if successful, false otherwise.
	int team = UTIL_GetTeam(pBot->pEdict), i = 0;

	pBot->goto_wp = WaypointFindRandomGoal(pBot->pEdict,team,iType);
	if((pBot->goto_wp == -1) || BotTeleporterAtPoint(waypoints[pBot->goto_wp].origin, 200))
	{
		for(i = 0; i < 5; ++i)
		{
			pBot->goto_wp = WaypointFindRandomGoal(pBot->pEdict,-1,iType);
			
			if((pBot->goto_wp != -1) && !BotTeleporterAtPoint(waypoints[pBot->goto_wp].origin, 200))
				break;
		}
	}
	
	if(pBot->goto_wp == -1)
		return false;
	else
	{
		pBot->goalType = pBot->Builder;
		return true;		
	}
}

bool BotGoForArmor(bot_t * pBot)
{
	// BotGoForArmor - This function sends a bot after some armor
	// Returns true if successful, false otherwise.
	int team = UTIL_GetTeam(pBot->pEdict);
	pBot->goto_wp = WaypointFindNearestGoal(pBot->pEdict,pBot->curr_waypoint_index,team,W_FL_ARMOR);
	if(pBot->goto_wp == -1) 
		pBot->goto_wp = WaypointFindNearestGoal(pBot->pEdict,pBot->curr_waypoint_index,-1,W_FL_ARMOR);	
	if(pBot->goto_wp == -1)
		pBot->goto_wp = WaypointFindRandomGoal(pBot->pEdict,team,W_FL_ARMOR);
	if(pBot->goto_wp == -1) 
		pBot->goto_wp = WaypointFindRandomGoal(pBot->pEdict,-1,W_FL_ARMOR);

	if(pBot->goto_wp == -1)
		return false;
	else
	{
		// Success!
		pBot->goalType = pBot->Armor;
		return true;
	}	
}

bool BotGoForHealth(bot_t *pBot)
{
	// BotGoForHealth - This function sends a bot after some health
	// Returns true if successful, false otherwise
	int team = UTIL_GetTeam(pBot->pEdict);

	int flagWP = -1, healthWP = -1;
	float flagDistance = WAYPOINT_UNREACHABLE, healthDistance = WAYPOINT_UNREACHABLE;

	// Get closest flag location.
	flagWP = WaypointFindNearestGoal(pBot->pEdict,pBot->curr_waypoint_index,team,W_FL_TFC_FLAG);
	if(flagWP == -1) flagWP = WaypointFindNearestGoal(pBot->pEdict,pBot->curr_waypoint_index,-1,W_FL_TFC_FLAG);

	// Get closest health location.
	healthWP = WaypointFindNearestGoal(pBot->pEdict,pBot->curr_waypoint_index,team,W_FL_HEALTH);
	if(healthWP == -1) healthWP = WaypointFindNearestGoal(pBot->pEdict,pBot->curr_waypoint_index,-1,W_FL_HEALTH);

	// Get my distance to both
	if(pBot->curr_waypoint_index != -1)
	{
		flagDistance = WaypointDistanceFromTo(pBot->curr_waypoint_index, flagWP, -1);
		healthDistance = WaypointDistanceFromTo(pBot->curr_waypoint_index, healthWP, -1);        
	}

	// If health distance twice as close as flag distance
	if (healthDistance < (flagDistance*0.5f))
	{
		pBot->goto_wp = healthWP;        
		pBot->goalType = pBot->Health;
		pBot->ras = true;
		if(g_bot_debug)
		{
			char s[255];
			sprintf(s,"%s health low, heading for flag Not health at %d",pBot->name,pBot->goto_wp);
			ALERT( at_console, s );
		}
	} else
	{
		pBot->goto_wp = flagWP;
		pBot->mission = pBot->Attacker;
		pBot->goalType = pBot->Flag; 
		pBot->ras = true;		
	}	

	if(pBot->goto_wp == -1)
		return false;
	else 
		return true;
}

bool BotGoForFlag(bot_t * pBot)
{
	// BotGoForFlag - This function sends a bot after a flag. 
	// Returns true if successful, false otherwise.
	int team = UTIL_GetTeam(pBot->pEdict);

	pBot->goto_wp = WaypointFindRandomGoal(pBot->pEdict,team,W_FL_TFC_FLAG);
	if(pBot->goto_wp == -1) 
		pBot->goto_wp = WaypointFindRandomGoal(pBot->pEdict,-1,W_FL_TFC_FLAG);

	if(pBot->goto_wp == -1)
		return false;
	else
	{
		// Success!
		pBot->mission = pBot->Attacker;
		pBot->goalType = pBot->Flag;
		pBot->ras = true;
		return true;
	}
}

bool BotGoForFlagGoal(bot_t * pBot)
{
	// BotGoForFlag - This function sends a bot after a flag goal. 
	// Returns true if successful, false otherwise.
	int team = UTIL_GetTeam(pBot->pEdict);

	pBot->goto_wp = WaypointFindRandomGoal(pBot->pEdict,team,W_FL_TFC_FLAG_GOAL);
	if(pBot->goto_wp == -1) 
		pBot->goto_wp = WaypointFindRandomGoal(pBot->pEdict,-1,W_FL_TFC_FLAG_GOAL);

	if(pBot->goto_wp == -1)
		return false;
	else
	{
		// Success!
		pBot->mission = pBot->Attacker;
		pBot->goalType = pBot->CapPoint; 
		pBot->ras = true;
		return true;
	}	
}

bool BotGoForSniperSpot(bot_t *pBot)
{
	// BotGoForSniperSpot - This function sends a bot after a sniper spot. 
	// Returns true if successful, false otherwise.
	int team = UTIL_GetTeam(pBot->pEdict);
	pBot->mission = pBot->Defender;
	pBot->goalType = pBot->Sniper;

	pBot->goto_wp = WaypointFindRandomGoal(pBot->pEdict,team,W_FL_SNIPER);

	if((pBot->goto_wp == -1) || !WaypointAvailable(pBot->goto_wp, team) || BotDefenderAtPoint(pBot, waypoints[pBot->goto_wp].origin, 100))
		pBot->goto_wp = WaypointFindRandomGoal(pBot->pEdict,-1,W_FL_SNIPER);	

	if(pBot->goto_wp == -1)
		return false;
	else
	{
		// Success!		
		//pBot->snipePoint = pBot->goto_wp;
		return true;        
	}	
}


bool BotFindTeleportShortCut(bot_t *pBot)
{
if(bot_can_use_teleporter==true)
{
	// This bots team.
	int team = UTIL_GetTeam(pBot->pEdict);
	edict_t *pent = NULL;
	edict_t *pent1 = NULL;
	bool bExists;
	// List of friendly teleport owners to this bot.
	List<teleport_info_t> teleportOwners;
	LIter<teleport_info_t> iter(&teleportOwners);
	teleport_info_t tempTPinfo;
	teleport_info_t *bestTP = NULL;
	// Don't do this if the bot has the flag.
	if(pBot->bot_has_flag)
	return false;
	// Search for teleporters.	
	while ((pent = FIND_ENTITY_BY_CLASSNAME(pent, "building_teleporter")) && !FNullEnt(pent))
	{
		bExists = false;
		// Look to see if there is already a teleport_info for this owner.        
		for (iter.begin(); !iter.end(); ++iter)
		{		
			// Already exists?
			if ((*iter.current()).pOwner == pent->v.euser1)
			{
				// It's already been made.
				bExists = true;
				// Fill in the appropriate slot
				if(pent->v.iuser1 == W_FL_TFC_TELEPORTER_ENTRANCE)
				{
					iter.current()->pEntrance = pent;
					iter.current()->iEntranceWaypointIndex = WaypointFindNearest(pent, 300, -1);
				} 
				else if(pent->v.iuser1 == W_FL_TFC_TELEPORTER_EXIT)
				{
					iter.current()->pExit = pent;
					//fixed by yuraj (known crash)
					if(WaypointFindNearest(pent, 300, -1)!=-1)
					{
					iter.current()->iExitWaypointIndex = WaypointFindNearest(pent, 300, -1);
					continue;
					}
					else
					{
					return false;
					}
				}
			}
		}
		// Only if it wasn't found above.
		if(!bExists)
		{
			// Set tp info to initial state
			tempTPinfo.bIsUsed = false;
			tempTPinfo.iEntranceWaypointIndex = tempTPinfo.iExitWaypointIndex = -1;
			tempTPinfo.pEntrance = tempTPinfo.pExit = NULL;

			// Make sure the owner is the proper team.
			if (team != UTIL_GetTeam(pent->v.euser1))
				continue;
			// Fill in the appropriate slot
			if(pent->v.iuser1 == W_FL_TFC_TELEPORTER_ENTRANCE)
			{
				tempTPinfo.pOwner = pent->v.euser1;
				tempTPinfo.pEntrance = pent;
				tempTPinfo.iEntranceWaypointIndex = WaypointFindNearest(pent, 500, -1);
			} 
			else if(pent->v.iuser1 == W_FL_TFC_TELEPORTER_EXIT)
			{
				tempTPinfo.pOwner = pent->v.euser1;
				tempTPinfo.pExit = pent;
				tempTPinfo.iExitWaypointIndex = WaypointFindNearest(pent, 500, -1);
			}

			// Add this to the list of found teleporters.
			teleportOwners.addTail(tempTPinfo);
		}
	}

	// Tag all slots as used that have both entrance and exit
	for (iter.begin(); !iter.end(); )
	{
		if(iter.current()->pEntrance && iter.current()->pExit)
		{
			++iter;
			continue;
		}
		else
			teleportOwners.remove(iter);
	}
    //

	// We now have only valid teleporters.
	float shortestDistance = 99999.0f;
	float totalDistance;
	for (iter.begin(); !iter.end(); ++iter)
	{

		// Find the teleporter which results in the shortest path to goal.
		totalDistance = WaypointDistanceFromTo(pBot->curr_waypoint_index, iter.current()->iEntranceWaypointIndex, team) 
			+ WaypointDistanceFromTo(iter.current()->iExitWaypointIndex, pBot->goto_wp, team);
		if(totalDistance < shortestDistance)
		{
			shortestDistance = totalDistance;
			bestTP = iter.current();
		}
	}
	// Got the best saving teleporter, now see if it saves us distance to our goal without taking it.
	if((shortestDistance < WaypointDistanceFromTo(pBot->curr_waypoint_index, pBot->goto_wp, team)) && (bestTP->bIsUsed==false))
	{
	// Copy this teleporters information into the bot struct.
		bestTP->bIsUsed = true;
		pBot->teleportInfo = *bestTP;
		//Spy stuff by yuraj
/*		if(pBot->pEdict->v.playerclass == TFC_CLASS_SPY )
		if(pBot->f_disguise_state!=0)
		{
pBot->f_disguise_state=0;
		}*/

	}
	// Clear the remaining entries.
	teleportOwners.clear();
	if(pBot->teleportInfo.bIsUsed)
	{
		pBot->teleportInfo.iFinalGoal = pBot->goto_wp;
		pBot->goto_wp = pBot->teleportInfo.iEntranceWaypointIndex;
        return true;
	}
}
	return false;
}