//
// FoXBot - AI Bot for Halflife's Team Fortress Classic
//
// (http://foxbot.net)
//
// bot_func.h
//
// Copyright (C) 2003 - Tom "Redfox" Simpson
//
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
//
// See the GNU General Public License for more details at:
// http://www.gnu.org/copyleft/gpl.html
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

#ifndef BOT_FUNC_H
#define BOT_FUNC_H


//prototypes of bot functions...

void BotSpawnInit( bot_t *pBot );
void BotCreate( edict_t *pPlayer, const char *arg1, const char *arg2,
                const char *arg3, const char *arg4 );
void BotStartGame( bot_t *pBot );
int BotInFieldOfView( bot_t *pBot, Vector dest );
bool BotEntityIsVisible( bot_t *pBot, Vector dest );
void BotFindItem( bot_t *pBot );
void BotThink( bot_t *pBot );


void BotFixIdealPitch( edict_t *pEdict );
float BotChangePitch( bot_t *pBot, float speed );
void BotFixIdealYaw( edict_t *pEdict );
float BotChangeYaw( bot_t *pBot, float speed );
bool BotFindWaypoint( bot_t *pBot );
bool BotHeadTowardWaypoint( bot_t *pBot );
void BotOnLadder( bot_t *pBot, float moved_distance );
void BotUnderWater( bot_t *pBot );
void BotUseLift( bot_t *pBot, float moved_distance );
bool BotStuckInCorner( bot_t *pBot );
void BotTurnAtWall( bot_t *pBot, TraceResult *tr );
bool BotCantMoveForward( bot_t *pBot, TraceResult *tr );
bool BotCanJumpUp( bot_t *pBot );
bool BotCanDuckUnder( bot_t *pBot );
void BotRandomTurn( bot_t *pBot );
bool BotFollowUser( bot_t *pBot );
bool BotCheckWallOnLeft( bot_t *pBot );
bool BotCheckWallOnRight( bot_t *pBot );

edict_t *BotFindEnemy( bot_t *pBot );
Vector BotBodyTarget( edict_t *pBotEnemy, bot_t *pBot );
bool BotFireWeapon( Vector v_enemy, bot_t *pBot, int weapon_choice);
void BotShootAtEnemy( bot_t *pBot );

// DrEvils functions.
// Handles bots grenade priming, and throwing, based on timer & target dist
int BotNadeHandler( bot_t *pBot, bool timed, char nadeTyp);
int BotAssessThreatLevel( bot_t *pBot );
int BotLeadTarget( edict_t *pBotEnemy, bot_t *pBot , int projSpeed, int &x, int &y, int &z);
bool BotOutOfNades(bot_t *pBot);
void BotSGSpotted(bot_t *pBot, edict_t *sg);
void BotCheckForJump(bot_t *pBot);
void BotCheckForConcJump(bot_t *pBot);
int BotTeamColorCheck(edict_t *pent);
int BotFindDefensePoint(bot_t *pBot);
void BotCheckForMultiguns(bot_t *pBot, float nearestdistance, edict_t *pNewEnemy, bool &rtn);
void BotSoundSense(edict_t *pEdict,const char *pszSample,float fVolume);
bool BotIsInfected(edict_t *pBot);
bool BotGoForAmmo(bot_t * pBot);
bool BotGoForHealth(bot_t *pBot);
bool BotGoForTeleportBuild(bot_t *pBot, int iType);
bool BotGoForArmor(bot_t * pBot);
bool BotGoForFlag(bot_t * pBot);
bool BotGoForFlagGoal(bot_t * pBot);
bool BotGoForSniperSpot(bot_t *pBot);
bool BotChangeClass(bot_t *pBot, int iClass, const char *from);
bool BotChangeRole(bot_t *pBot, const char *cmdLine, const char *from);
bool botVerifyAccess(edict_t *pPlayer);
bool BotFindTeleportShortCut(bot_t *pBot);


#endif // BOT_FUNC_H

