//
// FoXBot - AI Bot for Halflife's Team Fortress Classic
//
// (http://foxbot.net)
//
// bot_combat.cpp
//
// Copyright (C) 2003 - Tom "Redfox" Simpson
//
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
//
// See the GNU General Public License for more details at:
// http://www.gnu.org/copyleft/gpl.html
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

// DrEvil #define
#define NADEVELOCITY 650

#include "extdll.h"
#include "util.h"
#include "cbase.h"

#include "bot.h"
#include "bot_func.h"
#include "bot_weapons.h"

#include "waypoint.h"
extern WAYPOINT waypoints[MAX_WAYPOINTS];
extern int num_waypoints;  // number of waypoints currently in use

//area defs...
extern AREA areas[MAX_WAYPOINTS];
extern int num_areas;

extern int mod_id;
extern bot_weapon_t weapon_defs[MAX_WEAPONS];
extern bool b_observer_mode;
extern int team_allies[4];
extern edict_t *pent_info_ctfdetect;
extern float is_team_play;
extern bool checked_teamplay;
extern int bot_spy_random_check;

extern bot_t bots[32];

FILE *fp;

typedef struct
{
	int iId;  // the weapon ID value
	char  weapon_name[64];  // name of the weapon when selecting it
	int   skill_level;   // bot skill must be less than or equal to this value
	float primary_min_distance;   // 0 = no minimum
	float primary_max_distance;   // 9999 = no maximum
	float secondary_min_distance; // 0 = no minimum
	float secondary_max_distance; // 9999 = no maximum
	int   use_percent;   // times out of 100 to use this weapon when available
	bool  can_use_underwater;     // can use this weapon underwater
	int   primary_fire_percent;   // times out of 100 to use primary fire
	int   min_primary_ammo;       // minimum ammout of primary ammo needed to fire
	int   min_secondary_ammo;     // minimum ammout of seconday ammo needed to fire
	bool  primary_fire_hold;      // hold down primary fire button to use?
	bool  secondary_fire_hold;    // hold down secondary fire button to use?
	bool  primary_fire_charge;    // charge weapon using primary fire?
	bool  secondary_fire_charge;  // charge weapon using secondary fire?
	float primary_charge_delay;   // time to charge weapon
	float secondary_charge_delay; // time to charge weapon
} bot_weapon_select_t;

typedef struct
{
	int iId;
	float primary_base_delay;
	float primary_min_delay[5];
	float primary_max_delay[5];
	float secondary_base_delay;
	float secondary_min_delay[5];
	float secondary_max_delay[5];
} bot_fire_delay_t;

// This holds the multigun names we will check using a repeat loop
#define NumNTFGuns 8
char *ntfTargetChecks[] = {
	"ntf_teslacoil",
	"ntf_grenlauncher",
	"ntf_rocklauncher",
	"ntf_lrlauncher",
	"ntf_flamegun",
	"ntf_crowbar",
	"ntf_displacer",
	"ntf_biocannon",
};

// weapons are stored in priority order, most desired weapon should be at
// the start of the array and least desired should be at the end
bot_weapon_select_t tfc_weapon_select[] = {
	{TF_WEAPON_KNIFE, "tf_weapon_knife", 5, 0.0, 90.0, 0.0, 0.0, 100, TRUE, 100, 0, 0, FALSE, FALSE, FALSE, FALSE, 0.0, 0.0},
	{TF_WEAPON_SPANNER, "tf_weapon_spanner", 5, 0.0, 90.0, 0.0, 0.0, 100, TRUE, 100, 0, 0, FALSE, FALSE, FALSE, FALSE, 0.0, 0.0},
	{TF_WEAPON_MEDIKIT, "tf_weapon_medikit", 5, 0.0, 90.0, 0.0, 0.0, 100, TRUE, 100, 0, 0, FALSE, FALSE, FALSE, FALSE, 0.0, 0.0},
	{TF_WEAPON_SNIPERRIFLE, "tf_weapon_sniperrifle", 5, 300.0, 4000.0, 0.0, 0.0, 100, TRUE, 100, 1, 0, FALSE, FALSE, TRUE, FALSE, 2.0, 0.0},
	{TF_WEAPON_FLAMETHROWER, "tf_weapon_flamethrower", 5, 0.0, 400.0, 0.0, 0.0, 100, FALSE, 100, 1, 0, TRUE, FALSE, FALSE, FALSE, 0.0, 0.0},
	{TF_WEAPON_AC, "tf_weapon_ac", 5, 0.0, 2500.0, 0.0, 0.0, 100, TRUE, 100, 1, 0, TRUE, FALSE, FALSE, FALSE, 0.0, 0.0},
	{TF_WEAPON_GL, "tf_weapon_gl", 5, 50.0, 900.0, 0.0, 0.0, 100, TRUE, 100, 1, 0, FALSE, FALSE, FALSE, FALSE, 0.0, 0.0},
	{TF_WEAPON_RPG, "tf_weapon_rpg", 5, 50.0, 3000.0, 0.0, 0.0, 100, TRUE, 100, 1, 0, FALSE, FALSE, FALSE, FALSE, 0.0, 0.0},
	{TF_WEAPON_IC, "tf_weapon_ic", 5, 300.0, 2000.0, 0.0, 0.0, 100, TRUE, 100, 1, 0, FALSE, FALSE, FALSE, FALSE, 0.0, 0.0},
	{TF_WEAPON_SUPERSHOTGUN, "tf_weapon_supershotgun", 5, 0.0, 2000.0, 0.0, 0.0, 100, TRUE, 100, 2, 0, FALSE, FALSE, FALSE, FALSE, 0.0, 0.0},
	{TF_WEAPON_SUPERNAILGUN, "tf_weapon_superng", 5, 40.0, 3000.0, 0.0, 0.0, 100, TRUE, 100, 1, 0, TRUE, FALSE, FALSE, FALSE, 0.0, 0.0},
	{TF_WEAPON_TRANQ, "tf_weapon_tranq", 5, 40.0, 1000.0, 0.0, 0.0, 100, TRUE, 100, 1, 0, FALSE, FALSE, FALSE, FALSE, 0.0, 0.0},
	{TF_WEAPON_AUTORIFLE, "tf_weapon_autorifle", 5, 0.0, 1000.0, 0.0, 0.0, 100, TRUE, 100, 1, 0, FALSE, FALSE, FALSE, FALSE, 0.0, 0.0},
	{TF_WEAPON_SHOTGUN, "tf_weapon_shotgun", 5, 0.0, 4000.0, 0.0, 0.0, 100, TRUE, 100, 1, 0, FALSE, FALSE, FALSE, FALSE, 0.0, 0.0},
	{TF_WEAPON_NAILGUN, "tf_weapon_ng", 5, 0.0, 3000.0, 0.0, 0.0, 100, TRUE, 100, 1, 0, FALSE, FALSE, FALSE, FALSE, 0.0, 0.0},
	{TF_WEAPON_RAILGUN, "tf_weapon_railgun", 5, 40.0, 4000.0, 0.0, 0.0, 100, TRUE, 100, 1, 0, FALSE, FALSE, FALSE, FALSE, 0.0, 0.0},
	{TF_WEAPON_AXE, "tf_weapon_axe", 5, 0.0, 90.0, 0.0, 0.0, 70, TRUE, 100, 0, 0, FALSE, FALSE, FALSE, FALSE, 0.0, 0.0},
	/* terminator */
	{0, "", 0, 0.0, 0.0, 0.0, 0.0, 0, TRUE, 0, 1, 1, FALSE, FALSE, FALSE, FALSE, 0.0, 0.0}
};

bot_fire_delay_t tfc_fire_delay[] = {
	{TF_WEAPON_KNIFE,
	0.3, {0.0, 0.2, 0.3, 0.4, 0.6}, {0.1, 0.3, 0.5, 0.7, 1.0},
	0.0, {0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0}},
	{TF_WEAPON_SPANNER,
	0.3, {0.0, 0.2, 0.3, 0.4, 0.6}, {0.1, 0.3, 0.5, 0.7, 1.0},
	0.0, {0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0}},
	{TF_WEAPON_MEDIKIT,
	0.3, {0.0, 0.2, 0.3, 0.4, 0.6}, {0.1, 0.3, 0.5, 0.7, 1.0},
	0.0, {0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0}},
	{TF_WEAPON_SNIPERRIFLE,
	0.5, {0.0, 0.2, 0.6, 0.8, 1.0}, {0.3, 0.5, 0.7, 0.9, 1.1},
	0.0, {0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0}},
	{TF_WEAPON_FLAMETHROWER,
	0.0, {0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0},
	0.0, {0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0}},
	{TF_WEAPON_AC,
	0.0, {0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0},
	0.0, {0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0}},
	{TF_WEAPON_GL,
	0.6, {0.0, 0.2, 0.5, 0.8, 1.0}, {0.25, 0.4, 0.7, 1.0, 1.3},
	0.0, {0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0}},
	{TF_WEAPON_RPG,
	0.6, {0.0, 0.1, 0.3, 0.6, 1.0}, {0.1, 0.2, 0.7, 1.0, 2.0},
	0.0, {0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0}},
	{TF_WEAPON_IC,
	0.6, {1.0, 2.0, 3.0, 4.0, 5.0}, {3.0, 4.0, 5.0, 6.0, 7.0},
	0.0, {0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0}},
	{TF_WEAPON_SUPERSHOTGUN,
	0.6, {0.0, 0.2, 0.5, 0.8, 1.0}, {0.25, 0.4, 0.7, 1.0, 1.3},
	0.0, {0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0}},
	{TF_WEAPON_SUPERNAILGUN,
	0.0, {0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0},
	0.0, {0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0}},
	{TF_WEAPON_TRANQ,
	1.5, {1.0, 2.0, 3.0, 4.0, 5.0}, {3.0, 4.0, 5.0, 6.0, 7.0},
	0.0, {0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0}},
	{TF_WEAPON_AUTORIFLE,
	0.1, {0.0, 0.1, 0.2, 0.4, 0.6}, {0.1, 0.2, 0.5, 0.7, 1.0},
	0.0, {0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0}},
	{TF_WEAPON_SHOTGUN,
	0.5, {0.0, 0.2, 0.4, 0.6, 0.8}, {0.25, 0.5, 0.8, 1.2, 2.0},
	0.0, {0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0}},
	{TF_WEAPON_NAILGUN,
	0.1, {0.0, 0.1, 0.2, 0.4, 0.6}, {0.1, 0.2, 0.5, 0.7, 1.0},
	0.0, {0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0}},
	{TF_WEAPON_RAILGUN,
	0.4, {0.0, 0.1, 0.2, 0.3, 0.4}, {0.1, 0.2, 0.3, 0.4, 0.5},
	0.0, {0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0}},
	{TF_WEAPON_AXE,
	0.3, {0.0, 0.2, 0.3, 0.4, 0.6}, {0.1, 0.3, 0.5, 0.7, 1.0},
	0.0, {0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0}},
	/* terminator */
	{0, 0.0, {0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0},
	0.0, {0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0}}
};

void BotCheckTeamplay(void)
{
	// is this TFC or Counter-Strike or OpFor teamplay or FrontLineForce?
	if ((mod_id == TFC_DLL) || (mod_id == CSTRIKE_DLL) ||
		((mod_id == GEARBOX_DLL) && (pent_info_ctfdetect != NULL)) ||
		(mod_id == FRONTLINE_DLL))
		is_team_play = 1.0;
	else
		is_team_play = CVAR_GET_FLOAT("mp_teamplay");  // teamplay enabled?

	checked_teamplay = TRUE;
}

edict_t *BotFindEnemy( bot_t *pBot )
{    

	Vector vecEnd;
	static bool flag;
	flag=TRUE;
	edict_t *pent = NULL;
	edict_t *pNewEnemy = NULL;
	float nearestdistance;
	int i;
	bool rtnnull = false;
	edict_t *pEdict = pBot->pEdict;

	//stupidity check.. dont target yourself moron.
	if(pBot->pBotEnemy==pEdict) pBot->pBotEnemy=NULL;
	//ok..we don't want to change goals after fighting..lets see what this does
	if(pBot->pBotEnemy!=NULL) pBot->f_waypoint_time=gpGlobals->time + 6;
	if(pBot->f_snipe_time>gpGlobals->time)
	{
		pEdict->v.button |= IN_ATTACK;
	}
	//optimization...
	if(pBot->f_enemy_check_time>gpGlobals->time)
		return pBot->pBotEnemy;
	//only do enmey shit every 0.2 seconds
	pBot->f_enemy_check_time=gpGlobals->time+0.2;

	//civilian hunted behaviour..
	//needs to pause if being followed and no one in front of him!
	if(pEdict->v.playerclass == TFC_CLASS_CIVILIAN) 
	{
		bool is_seen,is_near;
		is_near = is_seen = false;
		for (int i = 1; i <= gpGlobals->maxClients; i++ )
		{
			edict_t *pPlayers = INDEXENT(i);
			if (pPlayers && !pPlayers->free && (pPlayers != pEdict))
			{
				if (!IsAlive(pPlayers))
					continue;
				Vector dis = pPlayers->v.origin - pEdict->v.origin;
				Vector vecEnd = pPlayers->v.origin + pEdict->v.view_ofs;
				int bot_team=UTIL_GetTeam(pEdict);
				int players_team=UTIL_GetTeam(pPlayers);
				//near and same team/ally
				if(dis.Length()<600	&& (bot_team==players_team || 
					team_allies[bot_team] & (1<<players_team)))
				{
					//they are visible to us (but maybe not seen)
					if(FVisible( vecEnd, pEdict ))
					{
						is_near=true;
						//they are in front of us
						//i.e. we can see them
						//if(FInViewCone( &vecEnd, pEdict ))
						//is_seen=true;
						Vector2D vec2LOS;
						float    flDot;

						UTIL_MakeVectors ( pEdict->v.angles );

						vec2LOS = ( vecEnd - pEdict->v.origin ).Make2D();
						vec2LOS = vec2LOS.Normalize();
						flDot = DotProduct (vec2LOS , gpGlobals->v_forward.Make2D() );
						//what if their a bit too close..
						//we don't want to shadow our protector
						if ( flDot > 0.40) 
						{
							is_seen=true;
							if(dis.Length()<100)
							{
								pBot->f_move_speed=pBot->f_max_speed/2;
								pBot->f_duck_time=gpGlobals->time+1;
							}
						}
					}
				}
			}
		}
		if(pBot->curr_waypoint_index!=-1 && pBot->goto_wp!=-1)
		{
			if(WaypointDistanceFromTo(pBot->curr_waypoint_index,pBot->goto_wp,UTIL_GetTeam(pEdict))<500)
				is_near=false;
		}

		//if theirs a friend near and they are not in our FOV
		//i.e. hunted can't see them infront
		//pause for a bit
		if(is_near && !is_seen)
		{
			pBot->f_pause_time=gpGlobals->time+0.8;
			pBot->f_duck_time=gpGlobals->time+1;
		}
		else
		{
			pBot->f_pause_time=gpGlobals->time;
			//pBot->f_duck_time=gpGlobals->time;
		}
	}

	//tracking of player.
	if(pBot->track_player)
	{
		//UTIL_HostSay(pEdict, 0, "tracking");
		//WARNING!
		//tracking may cause probs wif multipath calculations in the future..
		//due to changing the goal!
		Vector vecEnd = pBot->track_player->v.origin + pBot->track_player->v.view_ofs;
		if (FVisible( vecEnd, pEdict ))
		{
			pBot->goto_wp=WaypointFindNearest(pBot->track_player, REACHABLE_RANGE, -1);
			if(pBot->track_player->v.playerclass == TFC_CLASS_CIVILIAN)
			{
				bool goals=true;
				if(pBot->curr_waypoint_index!=-1 && pBot->goto_wp!=-1 && pBot->pBotEnemy==NULL)
				{
					int dst=WaypointFindNearestGoal(pEdict,pBot->curr_waypoint_index,UTIL_GetTeam(pEdict),W_FL_TFC_FLAG);
					if(dst==-1)
						dst=WaypointFindNearestGoal(pEdict,pBot->curr_waypoint_index,-1,W_FL_TFC_FLAG);
					if(dst!=-1)
						if(WaypointDistanceFromTo(pBot->goto_wp,dst,UTIL_GetTeam(pEdict))<800 ||
							WaypointDistanceFromTo(pBot->goto_wp,dst,-1)<800)
						{
							//work out numbre of trackers of this player
							//if its greater than 2, goto this goal
							int cnt=0;
							i=0;
							// DrEvil optimization
							// get out if we've counted 2 since thats what we're checking for below.
							while(i<32 && cnt < 1)
							{
								//if this bot is on the same team, and following, count it!
								if(bots[i].is_used)
								{
									if(bots[i].track_player == pBot->track_player && bots[i].pEdict!=pEdict)
										cnt++;
								}
								i++;							 
							}
							if(cnt>=1)
							{
								pBot->goto_wp = dst;
								goals=false;
								pBot->track_player=NULL;
							}
						}
				}
				if(goals)
				{	
					int team = UTIL_GetTeam(pBot->track_player);
					int goal = WaypointFindRandomGoal(pEdict,team,W_FL_TFC_FLAG_GOAL);					
					if(goal== -1) goal=WaypointFindRandomGoal(pEdict,-1,W_FL_TFC_FLAG_GOAL);
					if(goal!= -1 && pBot->goto_wp !=- 1) goal = WaypointRouteFromTo(pBot->goto_wp,goal,team);
					if(goal!= -1 && goal < num_waypoints) 
					{
						Vector trk = pBot->track_player->v.origin - waypoints[pBot->goto_wp].origin;
						pBot->goto_wp = goal;						
						if(trk.Length()<200)
						{
							goal = WaypointFindRandomGoal(pEdict,team,W_FL_TFC_FLAG_GOAL);
							if(goal == -1) goal = WaypointFindRandomGoal(pEdict,-1,W_FL_TFC_FLAG_GOAL);
							if(goal != -1 && pBot->goto_wp != -1) goal = WaypointRouteFromTo(pBot->goto_wp,goal,team);
							if(goal != -1 && goal < num_waypoints) pBot->goto_wp=goal;							
						}

					}
				}
			}
			pBot->track_time=gpGlobals->time;
		}
		else
		{
			//now the other stuff
			//if we can't see the player were tracking
			//got to be able to pick our goals without seeming as though we're
			//able to track without being able to see them
			float distance = (pBot->track_player->v.origin - pEdict->v.origin).Length();
			if(distance<300)
			{
				pBot->goto_wp=WaypointFindNearest(pBot->track_player, REACHABLE_RANGE, -1);
				if(pBot->track_player->v.playerclass == TFC_CLASS_CIVILIAN)
				{
					bool goals=true;
					if(pBot->curr_waypoint_index!=-1 && pBot->goto_wp!=-1 && pBot->pBotEnemy==NULL)
					{
						int dst=WaypointFindNearestGoal(pEdict,pBot->curr_waypoint_index,UTIL_GetTeam(pEdict),W_FL_TFC_FLAG);
						if(dst==-1)
							dst=WaypointFindNearestGoal(pEdict,pBot->curr_waypoint_index,-1,W_FL_TFC_FLAG);
						if(dst!=-1)
							if(WaypointDistanceFromTo(pBot->goto_wp,dst,UTIL_GetTeam(pEdict))<800 ||
								WaypointDistanceFromTo(pBot->goto_wp,dst,-1)<800)
							{
								//work out numbre of trackers of this player
								//if its greater than 2, goto this goal
								int cnt=0;
								i=0;
								// DrEvil optimization
								// get out if we've counted 2 since thats what we checking for below.
								while(i<32 && cnt < 1)
								{
									//if this bot is on the same team, and follwing, count it!
									if(bots[i].is_used)
									{
										if(bots[i].track_player==pBot->track_player && bots[i].pEdict!=pEdict)
											cnt++;
									}
									i++;
								}
								if(cnt>=1)
								{
									pBot->goto_wp=dst;
									goals=false;
									pBot->track_player=NULL;
								}
							}
					}
					if(goals)
					{

						int tteam = UTIL_GetTeam(pBot->track_player);
						int goal = WaypointFindRandomGoal(pEdict,tteam,W_FL_TFC_FLAG_GOAL);
						if(goal==-1) goal=WaypointFindRandomGoal(pEdict,-1,W_FL_TFC_FLAG_GOAL);
						if(goal!=-1 && pBot->goto_wp!=-1) goal=WaypointRouteFromTo(pBot->goto_wp,goal,tteam);
						if(goal!=-1 && goal<num_waypoints) pBot->goto_wp=goal;
					}
				}
			}
			else if(distance<700)
			{
				Vector rand;
				rand.x=RANDOM_LONG(-150,150);
				rand.y=RANDOM_LONG(-150,150);
				pBot->goto_wp=WaypointFindNearest((pBot->track_player->v.origin)+rand, REACHABLE_RANGE, -1);
				if(pBot->track_player->v.playerclass == TFC_CLASS_CIVILIAN)
				{
					bool goals=true;
					if(pBot->curr_waypoint_index!=-1 &&
						pBot->goto_wp!=-1 &&
						pBot->pBotEnemy==NULL)
					{
						int dst=WaypointFindNearestGoal(pEdict,pBot->curr_waypoint_index,UTIL_GetTeam(pEdict),W_FL_TFC_FLAG);
						if(dst==-1)
							dst=WaypointFindNearestGoal(pEdict,pBot->curr_waypoint_index,-1,W_FL_TFC_FLAG);
						if(dst!=-1)
							if(WaypointDistanceFromTo(pBot->goto_wp,dst,UTIL_GetTeam(pEdict))<800 ||
								WaypointDistanceFromTo(pBot->goto_wp,dst,-1)<800)
							{
								//work out numbre of trackers of this player
								//if its greater than 2, goto this goal
								int cnt=0;
								i=0;
								// DrEvil optimization
								// get out if we've counted 2 since thats what we checking for below.
								while(i<32 && cnt < 1)
								{
									//if this bot is on the same team, and follwing, count it!
									if(bots[i].is_used)
									{
										if(bots[i].track_player==pBot->track_player && bots[i].pEdict!=pEdict)
											cnt++;								
									}
									i++;
								}
								if(cnt>1)
								{
									pBot->goto_wp=dst;
									goals=false;
									pBot->track_player=NULL;
								}
							}
					}
					if(goals)
					{						
						int tteam = UTIL_GetTeam(pBot->track_player);
						int goal = WaypointFindRandomGoal(pEdict,tteam,W_FL_TFC_FLAG_GOAL);
						if(goal==-1) goal=WaypointFindRandomGoal(pEdict,-1,W_FL_TFC_FLAG_GOAL);
						if(goal!=-1 && pBot->goto_wp!=-1) goal=WaypointRouteFromTo(pBot->goto_wp,goal,tteam);
						if(goal!=-1 && goal<num_waypoints) pBot->goto_wp=goal;
					}
				}
			}
			if(distance>=700)
			{
				Vector rand;
				rand.x=RANDOM_LONG(-300,300);
				rand.y=RANDOM_LONG(-300,300);
				pBot->goto_wp=WaypointFindNearest((pBot->track_player->v.origin)+rand, REACHABLE_RANGE, -1);
				if(pBot->track_player->v.playerclass == TFC_CLASS_CIVILIAN)
				{
					int goal;
					int tteam=UTIL_GetTeam(pBot->track_player);
					goal=WaypointFindRandomGoal(pEdict,tteam,W_FL_TFC_FLAG_GOAL);
					if(goal==-1) goal=WaypointFindRandomGoal(pEdict,-1,W_FL_TFC_FLAG_GOAL);
					if(goal!=-1 && pBot->goto_wp!=-1) goal=WaypointRouteFromTo(pBot->goto_wp,goal,tteam);
					if(goal!=-1 && goal<num_waypoints) pBot->goto_wp=goal;
				}
				//if their a Long way away, might stop tracking
				if(distance>1400)
				{
					if(RANDOM_LONG(0,1000)>999) pBot->track_player=NULL;
				}
			}
		}
		//ok, missed 1 point
		//why should we stop tracking?
		edict_t *pent = NULL; 
		bool bb=false;
		//check bb to true if your ment to be following them
		//for another reason

		//check if the tracked has the flag
		while ((pent = FIND_ENTITY_BY_CLASSNAME( pent, "item_tfgoal" )) != NULL && (!FNullEnt(pent))) 
		{  
			if (pent->v.owner == pBot->track_player) 
				bb=true;
		}

		// DrEvil - throw nades at tracked targets?
		// Chance to throw a nade at the tracked target.
		if (!pBot->nadePrimed && (RANDOM_LONG(1, 100) > 20))
			BotNadeHandler(pBot, true, bot_t::Damage);
		// NULL our track_player if they are no longer a valid target to track.
		if(pBot->track_player!=NULL)
			if(!IsAlive(pBot->track_player) || gpGlobals->time-10>pBot->track_time || !bb) pBot->track_player=NULL;
	}
	else
		//if we aernt tracking, then maybee we should be?
	{
		if(mod_id==TFC_DLL)
		{
			//ok, help our flag carrier if we can't see the enemy?
			if(!pBot->pBotEnemy && !pBot->bot_has_flag)
			{
				//search for flag carrier if their visible then track them.
				edict_t *pent = NULL; 
				while ((pent = FIND_ENTITY_BY_CLASSNAME( pent, "item_tfgoal" )) != NULL && (!FNullEnt(pent))) 
				{  
					if (pent->v.owner !=NULL && pent->v.owner!=pEdict )
					{ 
						//work out how many bots are follwing this person 1 max
						int cnt=0;
						i=0;
						while(i<32)
						{
							//if this bot is on the same team, and follwing, count it!
							if(bots[i].is_used)
							{
								if(bots[i].track_player==pent->v.owner && (UTIL_GetTeamColor(pent->v.owner)==UTIL_GetTeam(bots[i].pEdict)
									|| team_allies[UTIL_GetTeam(pent->v.owner)] & (1<<UTIL_GetTeam(bots[i].pEdict))))
									cnt++;
							}
							i++;
						}
						// perhaps we should put a check in to see if theirs atleast 1 bot 
						// not following this guy, if the whole team is (i.e. team has 4 players)


						if((cnt<1) && (bots[i].mission != bots[i].Defender) && ((UTIL_GetTeamColor(pent->v.owner)==UTIL_GetTeam(pEdict) || team_allies[UTIL_GetTeam(pent->v.owner)] & (1<<UTIL_GetTeam(pEdict)))
							&& pBot->bot_class!=TFC_CLASS_SNIPER && pBot->bot_class!=TFC_CLASS_SPY && pBot->bot_class!=TFC_CLASS_ENGINEER
							&& pBot->bot_class!=TFC_CLASS_CIVILIAN && pBot->bot_class!=TFC_CLASS_SCOUT) || 
							(UTIL_GetTeam(pent->v.owner)!=UTIL_GetTeam(pEdict) && !(team_allies[UTIL_GetTeam(pent->v.owner)] & (1<<UTIL_GetTeam(pEdict)))))
						{
							//if we can see them!
							Vector vecEnd = pent->v.owner->v.origin + pent->v.owner->v.view_ofs;
							if (FInViewCone( &vecEnd, pEdict ) && FVisible( vecEnd, pEdict ))
							{
								//make them our tracker target
								pBot->ras = true;
								pBot->track_player=pent->v.owner;
								break;  // break out of while loop 
							}
						}
					} 
				}
			}
			//ok, if we aern't tracking anyone
			//should we look for someone to follow
			//why should we follow someone?
			//leave this till later!
		}
	}

	// try to sort out flag carry bug thing
	//if on ladder and spot enemy jump off ladder
	if(pBot->pBotEnemy!=NULL && pEdict->v.movetype == MOVETYPE_FLY)
	{
		pBot->ras=true;
		pEdict->v.button |= IN_FORWARD;
	}
	pBot->lastenemypos =-1;
	if(mod_id==TFC_DLL)
	{
		// Test our lastsg to see if its still valid
		if (pBot->pBotLastSgEnemy && !FNullEnt(pBot->pBotLastSgEnemy))
		{
			// Is it a sentry or a mg?
			if((strcmp(STRING(pBot->pBotLastSgEnemy->v.classname),"building_sentrygun")==0 || 
				strncmp(STRING(pBot->pBotLastSgEnemy->v.classname),"ntf_",4)==0) &&
				(BotTeamColorCheck(pBot->pBotLastSgEnemy) != UTIL_GetTeam(pEdict)))
			{
				// Ok, its a sentry.			    
				if (!IsAlive(pBot->pBotLastSgEnemy))
				{
					edict_t *sg = pBot->pBotLastSgEnemy;
					// It's dead. Have the killer announce it.
					// TODO : make the killer say it. right now its the first guy to notice				   
					// Communicate!
					if (sg->v.origin != Vector(0,0,0))
					{
						char ss[255];
						int team;
						int area = AreaInsideClosest(sg);					
						if(area != -1)
						{
							team = UTIL_GetTeam(pBot->pEdict);
							if(team==0) sprintf(ss,"Sentry Down %s",areas[area].namea);
							if(team==1) sprintf(ss,"Sentry Down %s",areas[area].nameb);
							if(team==2) sprintf(ss,"Sentry Down %s",areas[area].namec);
							if(team==3) sprintf(ss,"Sentry Down %s",areas[area].named);
							if(strcmp(pBot->lastmessage,ss)!=0)
								UTIL_HostSay(pBot->pEdict,1, ss);
							strcpy(pBot->lastmessage,ss);
						}

						// Clear this sg from everyones memory					
						for(int i = 0; i < 32; i++)	
						{		
							if(bots[i].is_used)
							{							
								if(bots[i].pBotLastSgEnemy == sg)						   							   
									bots[i].pBotLastSgEnemy = NULL;
							}
						} 
					}
				}
			} else
			{
				// Clear the invalid sg.
				pBot->pBotLastSgEnemy = NULL;
			}		   
		}	  
		if(pBot->pBotEnemy) 
		{
			pBot->lastenemy = pBot->pBotEnemy;
			pBot->inact=0;
		}
		//do spy self check here (and why not)
			if(pEdict->v.playerclass == TFC_CLASS_SPY)
		{
			if(pBot->f_disguise_state==0 && pBot->pBotEnemy==NULL)
			{
				int ss;
				do 
				{
					ss = RANDOM_LONG(2, 9);				   		   
				} while (ss == 6 || ss == 8); 
				char choice[2];
				itoa(ss, choice, 10);
				FakeClientCommand(pEdict,"disguise_enemy", choice, NULL);
				pBot->f_disguise_state=1;
				pBot->f_disguise_time=gpGlobals->time+12;
			}
			//if not diguised by time over, reset
			//also if taking damage and less than 30% health
			if((pBot->f_disguise_time<gpGlobals->time && pBot->f_disguise_state!=2)
				|| (pBot->f_take_damage && (pEdict->v.health / pEdict->v.max_health) <= 0.30))
			{
				pBot->f_disguise_state = 0; // reset if we didn't diguis;
				if(pBot->f_strafe==3) pBot->f_strafe = 1;
			}

			if(UTIL_GetTeam(pEdict)!=UTIL_GetTeamColor(pEdict)) 
			{
				//if(pBot->f_disguise_state==1) UTIL_HostSay(pEdict, 1, "Going under cover");
				pBot->f_disguise_state = 2;
			}
			else if(pBot->f_disguise_state!=1) 
			{
				pBot->f_disguise_state = 0; //if not start disguis, were not disguised
				if(pBot->f_strafe==3) pBot->f_strafe=1;
			}
		}
		if(pEdict->v.playerclass == TFC_CLASS_SPY && !pBot->follow && !pBot->pBotEnemy && pBot->f_disguise_state==2
			&& !(pBot->f_take_damage || (pEdict->v.health / pEdict->v.max_health) <= 0.20)) rtnnull=true;
		//sort out 'if shot/carrying flag, shootback'
		if(pBot->f_take_damage && pBot->bot_has_flag) rtnnull=false;

		if(pEdict->v.playerclass == TFC_CLASS_SNIPER && pBot->current_weapon.iId == TF_WEAPON_SNIPERRIFLE &&
			pBot->pBotEnemy)
			//&& !pBot->bot_has_flag) //  && !pBot->ras
		{
			//work out fire delay timings..
			if(//pBot->f_snipe_time>gpGlobals->time+8 ||
				(pBot->bot_skill==0 && pBot->f_snipe_time>gpGlobals->time+1) ||
				(pBot->bot_skill!=0 && pBot->f_snipe_time>gpGlobals->time+pBot->bot_skill+0.55) ||
				(pBot->bot_skill==0 && (pBot->f_snipe_time+pBot->bot_skill+0.2)<gpGlobals->time) ||
				(pBot->bot_skill!=0 && (pBot->f_snipe_time+pBot->bot_skill-0.6)<gpGlobals->time))
			{
				if(pBot->bot_skill!=0) pBot->f_snipe_time=gpGlobals->time+RANDOM_FLOAT(pBot->bot_skill-0.8,pBot->bot_skill+0.5);
				else pBot->f_snipe_time=gpGlobals->time+RANDOM_FLOAT(0,0.5);
				pEdict->v.button |= IN_ATTACK;
				pBot->f_pause_time=(gpGlobals->time)+0.5;
			}
			vecEnd = pBot->pBotEnemy->v.origin + pBot->pBotEnemy->v.view_ofs;
			if (FInViewCone( &vecEnd, pEdict ) &&
				FVisible( vecEnd, pEdict )) 
			{
				if(pBot->f_snipe_time>gpGlobals->time)				   
				{
					pEdict->v.button |= IN_ATTACK;
				}
			}
			else
				pEdict->v.button |= IN_ATTACK;
		}
		else if (pBot->pBotEnemy!=NULL) pBot->f_sniper_aim_time = gpGlobals->time;
	}
	if (pBot->pBotEnemy)  // does the bot already have an enemy?
	{
		//sort out nav, if we're fighting;
		if(!pBot->ras)
			pBot->curr_waypoint_index=WaypointFindNearest(pEdict, REACHABLE_RANGE, UTIL_GetTeam(pEdict));

		vecEnd = pBot->pBotEnemy->v.origin + pBot->pBotEnemy->v.view_ofs;

		pBot->f_take_damage=false;
		pBot->lastenemypos = WaypointFindNearest(pBot->pBotEnemy, REACHABLE_RANGE, UTIL_GetTeam(pBot->pBotEnemy));
		// if the enemy is dead?
		if (!IsAlive(pBot->pBotEnemy) &&!(pBot->pBotEnemy->v.deadflag == 5 && RANDOM_LONG(0,(pBot->bot_skill+1)*1000)<900))  // is the enemy dead?, assume bot killed it
		{
			// the enemy is dead, jump for joy about 20% of the time
			if (RANDOM_LONG(1, 100) <= 20)
				pEdict->v.button |= IN_JUMP;
			if (RANDOM_LONG(1, 100) <= 20)
				BotSprayLogo(pEdict);

			// don't have an enemy anymore so null out the pointer...
			pBot->lastenemypos =-1;
			pBot->pBotEnemy = NULL;
		}
		//neottf sg bug fix?
		//does this fwuck anything else?
		else if ((pBot->pBotEnemy->v.flags & FL_KILLME)==FL_KILLME)
		{
			// the enemy is dead, jump for joy about 20% of the time
			if (RANDOM_LONG(1, 100) <= 20)
				pEdict->v.button |= IN_JUMP;
			if (RANDOM_LONG(1, 100) <= 20)
				BotSprayLogo(pEdict);

			// don't have an enemy anymore so null out the pointer...
			pBot->lastenemypos =-1;
			pBot->pBotEnemy = NULL;
			//pBot->goto_wp=pBot->lastgoto_wp; //will this work?!	  
		}
		else if (FInViewCone( &vecEnd, pEdict ) && FVisible( vecEnd, pEdict ))
		{
			// DrEvil modifications
			// added 20 to health check to allow medic buffing.
			// Added engineer armor healing
			int myClass = pEdict->v.playerclass;
			if ((mod_id == TFC_DLL) && ((myClass == TFC_CLASS_MEDIC) || (myClass == TFC_CLASS_ENGINEER)) 
				&& (UTIL_GetTeam(pEdict)==UTIL_GetTeam(pBot->pBotEnemy)))
			{
				pBot->f_strafe=2;
				if (myClass == TFC_CLASS_MEDIC && (pBot->ConcJumping || (pBot->pBotEnemy->v.health > pBot->pBotEnemy->v.max_health+20 && pBot->follow==false)))
				{
					pBot->pBotEnemy = NULL;  // player is healed & buffed, null out pointer
					pBot->lastenemypos =-1;
					pBot->ras=true;
				}
				if ((myClass == TFC_CLASS_ENGINEER) && ((BotArmorValue(pBot->pBotEnemy) > 98) ||
					(pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SPANNER].iAmmo1] < 50) || BotIsInfected(pBot->pBotEnemy)))
				{
					pBot->pBotEnemy = NULL;  // player is healed & buffed, null out pointer
					pBot->lastenemypos =-1;
					pBot->ras=true;
				}
				rtnnull=false;
			}	
			else
			{
				// if enemy is still visible and in field of view, keep it
				// face the enemy
				Vector v_enemy = pBot->pBotEnemy->v.origin - pEdict->v.origin;
				Vector bot_angles = UTIL_VecToAngles( v_enemy );

				pEdict->v.ideal_yaw = bot_angles.y;
				pEdict->v.idealpitch = bot_angles.x;
				if(pEdict->v.playerclass == TFC_CLASS_SNIPER && pBot->current_weapon.iId == TF_WEAPON_SNIPERRIFLE &&
					pBot->bot_skill>0 && mod_id==TFC_DLL)
				{
					//BotChangeYaw(pBot,0.000001);
				}
				else
				{
					BotFixIdealYaw(pEdict);
				}

				// keep track of when we last saw an enemy
				pBot->f_bot_see_enemy_time = gpGlobals->time;

				if (pBot->current_weapon.iId==TF_WEAPON_GL && pBot->current_weapon.iClip==0 && (mod_id == TFC_DLL) &&
					(pEdict->v.playerclass == TFC_CLASS_DEMOMAN)) 
				{
					pEdict->v.button |= IN_RELOAD;  // press reload button
					pBot->f_shoot_time=gpGlobals->time+3;
				}
				if(pBot->bot_skill<=2 && pBot->f_disguise_state!=2)
				{
					if (RANDOM_LONG(1, 100) <= 12 && !(pEdict->v.playerclass == TFC_CLASS_SNIPER && mod_id==TFC_DLL)) //jump randomly in battle
						pEdict->v.button |= IN_JUMP;
					if (pEdict->v.playerclass == TFC_CLASS_SNIPER && mod_id==TFC_DLL
						&& pBot->current_weapon.iId == TF_WEAPON_SNIPERRIFLE) 
					{
						//duck randomly in battle
						if (RANDOM_LONG(1, 100) <= 30) 
							pBot->f_duck_time=gpGlobals->time+0.8;
				 }
					else
				 {
					 if (RANDOM_LONG(1, 100) <= 10) //duck randomly in battle
						 //pEdict->v.button |= IN_DUCK;
						 pBot->f_duck_time=gpGlobals->time+0.6;
				 }
				}

				// check for closer enemy, or enemy wif flag here! and sentry guns!!!!!!
				pent=NULL;
				float nearestdistance=9999;
				while ((pent = FIND_ENTITY_BY_CLASSNAME( pent, "building_sentrygun" )) != NULL &&
					(!FNullEnt(pent)))
				{
					int sentry_team = BotTeamColorCheck(pent);
					int bot_team = UTIL_GetTeam(pEdict);

					// don't target your own team's sentry guns...
					if (bot_team == sentry_team)				  
						continue;

					// don't target your allie's sentry guns either...
					if (team_allies[bot_team] & (1<<sentry_team))				  
						continue;				  

					vecEnd = pent->v.origin + pent->v.view_ofs;

					// is this sentry gun visible?
					if (FInViewCone( &vecEnd, pEdict ) && FVisible( vecEnd, pEdict ))
					{
						float distance = (pent->v.origin - pEdict->v.origin).Length();

						// is this the closest sentry gun?
						if (distance < nearestdistance)
						{
							nearestdistance = distance;
							pNewEnemy = pent;
							pBot->pBotUser = NULL;  // don't follow user when enemy found	                                                        
							BotNadeHandler(pBot, false, bot_t::Stationary);
							rtnnull=false;
							BotSGSpotted(pBot, pent);
						}
					}
				}

				// This checks for uncaptures multiguns.
				pent=NULL;
				while ((pent = FIND_ENTITY_BY_CLASSNAME( pent, "ntf_multigun" )) != NULL && (!FNullEnt(pent)))
			 {
				 int sentry_team = pent->v.team-1;
				 int bot_team = UTIL_GetTeam(pEdict);
				 if ((pent->v.flags & FL_KILLME)==FL_KILLME)
					 continue;
				 // don't target your own team's sentry guns...
				 if (bot_team == sentry_team)
					 continue;
				 // don't target your allie's sentry guns either...
				 if (team_allies[bot_team] & (1<<sentry_team))
					 continue;
				 //ntf_capture_mg 1 = ignore, we can cap it
				 char *cvar_ntf_capture_mg = (char *)CVAR_GET_STRING( "ntf_capture_mg" );
				 if(strcmp(cvar_ntf_capture_mg,"1")==0)
					 continue;
				 vecEnd = pent->v.origin + pent->v.view_ofs;
				 // is this sentry gun visible?
				 if (FInViewCone( &vecEnd, pEdict ) && FVisible( vecEnd, pEdict ))
				 {
					 float distance = (pent->v.origin - pEdict->v.origin).Length();					
					 // is this the closest sentry gun?
					 if (distance < nearestdistance)
					 {
						 nearestdistance = distance;
						 pNewEnemy = pent;
						 pBot->pBotUser = NULL;  // don't follow user when enemy found
						 BotNadeHandler(pBot, false, bot_t::Stationary);
						 rtnnull=false;
						 BotSGSpotted(pBot, pent);
					 }
				 }
			 }

			 // This function loops through the multiguns looking for a better target.
			 BotCheckForMultiguns(pBot, nearestdistance, pNewEnemy, rtnnull);

			 if(pNewEnemy) 
				 return pNewEnemy;

			 //only return enemy we got if their close..
			 //and we're not sniping
			 //and their not the player were tracking
			 if(pBot->pBotEnemy)
			 {
				 //put random in, so cpu is hopefully a bit less
				 if(!pBot->follow && ((pBot->pBotEnemy->v.origin - pEdict->v.origin).Length() < 250 || 
					 RANDOM_LONG(1,100)<70) && pBot->f_snipe_time<gpGlobals->time && 
					 pBot->pBotEnemy!=pBot->track_player) 
					 return (pBot->pBotEnemy);
			 }
			 else
				 if(!pBot->follow) 
					 return (pBot->pBotEnemy);
		 }
		}
		else pBot->f_shoot_time=gpGlobals->time+1; // normally +2
	}
	pent = pNewEnemy = NULL; 
	nearestdistance = 1000;

	if (pBot->follow)
	{
		// search the world for players...
		for (i = 1; i <= gpGlobals->maxClients; i++)
		{
			edict_t *pPlayer = INDEXENT(i);		   
			// skip invalid players and skip self (i.e. this bot)
			if ((pPlayer) && (!pPlayer->free) && (pPlayer != pEdict))
			{
				// skip this player if not alive (i.e. dead or dying)
				if (!IsAlive(pPlayer) && !(pPlayer->v.deadflag == 5 && RANDOM_LONG(0,(pBot->bot_skill+1)*1000)<900))
					continue;
				if ((b_observer_mode) && !((pPlayer->v.flags & FL_FAKECLIENT)==FL_FAKECLIENT))
					continue;

				int player_team = UTIL_GetTeam(pPlayer);
				int bot_team = UTIL_GetTeam(pEdict);
				vecEnd = pPlayer->v.origin + pPlayer->v.view_ofs;
				// see if bot can see the player...
				if (FInViewCone( &vecEnd, pEdict ) && FVisible( vecEnd, pEdict ))
				{
					float distance = (pPlayer->v.origin - pEdict->v.origin).Length();
					if (distance < nearestdistance)
					{
						nearestdistance = distance;
						pNewEnemy = pPlayer;
						pBot->pBotUser = NULL;  // don't follow user when enemy found
						continue;
					}
				}
			}
		}
	}
	if (mod_id == TFC_DLL)
	{
		int myClass = pEdict->v.playerclass;
		if (myClass == TFC_CLASS_MEDIC || myClass == TFC_CLASS_ENGINEER)
		{
			// search the world for players...
			for (i = 1; i <= gpGlobals->maxClients; i++)
			{
				edict_t *pPlayer = INDEXENT(i);

				// skip invalid players and skip self (i.e. this bot)
				if ((pPlayer) && (!pPlayer->free) && (pPlayer != pEdict))
				{
					// skip this player if not alive (i.e. dead or dying)
					if (!IsAlive(pPlayer))
						continue;
					if ((b_observer_mode) && !((pPlayer->v.flags & FL_FAKECLIENT)==FL_FAKECLIENT))
						continue;
					int player_team = UTIL_GetTeamColor(pPlayer);
					int bot_team = UTIL_GetTeam(pEdict);				   
					// don't target your enemies...
					if ((bot_team != player_team) && !(team_allies[bot_team] & (1<<player_team)))
						continue;				   
					// check if player needs to be healed...
					if (myClass == TFC_CLASS_MEDIC && (pBot->ConcJumping || (pPlayer->v.health / pPlayer->v.max_health) > 0.70))
						continue;  // health greater than 70% so ignore				   
					// DrEvil armor healing
					// check if player needs to be armored...
					if ((myClass == TFC_CLASS_ENGINEER) && (BotArmorValue(pPlayer) > 40 || 
						!pBot->sg || pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SPANNER].iAmmo1] < 50))
						continue;  // armor greater than 50% so ignore				   
					vecEnd = pPlayer->v.origin + pPlayer->v.view_ofs;				   
					// see if bot can see the player...
					if (FInViewCone( &vecEnd, pEdict ) && FVisible( vecEnd, pEdict ))
					{
						float distance = (pPlayer->v.origin - pEdict->v.origin).Length();
						if (distance < nearestdistance)
						{
							nearestdistance = distance;
							pNewEnemy = pPlayer;
							pBot->pBotUser = NULL;  // don't follow user when enemy found
							rtnnull=false;
							pBot->f_strafe=2;
							pBot->ras=false;
						}
					}
				}
			}
		}

		if (!pNewEnemy)
		{
			//check for snipers
			pent=NULL;
			while ((pent = FIND_ENTITY_BY_CLASSNAME( pent, "laser_spot" )) != NULL && (!FNullEnt(pent)))
			{
				//ignore your own sniper spot
				if(pent->v.owner==pEdict)
					continue;
				int sniper_team = UTIL_GetTeam(pent->v.owner);
				int bot_team = UTIL_GetTeam(pEdict);
				//ignore sniper spots from your team
				if(sniper_team==bot_team)
					continue;
				//ignore sniper spots from your allies
				if (team_allies[bot_team] & (1<<sniper_team))
					continue;
				//ok..check distance to see if its nearish to the bot..
				//if its is and they can see the sniper..make them the enemy!
				//not very human like..but fun!
				//distance to sniper spot
				float distance = (pent->v.origin - pEdict->v.origin).Length();
				if(distance<500)
				{
					vecEnd = pent->v.owner->v.origin + pent->v.owner->v.view_ofs;
					if (FVisible( vecEnd, pEdict ))
					{
						// DrEvil
						// Lets add some error into this. annoying when the bots always snapshot as soon
						// as they see your dot.
						if ((pBot->bot_skill*10 + RANDOM_LONG(0,50)) < 60)
							pNewEnemy=pent->v.owner;
					}
				}
		 }

			//check for sg's
			pent=NULL;
			while ((pent = FIND_ENTITY_BY_CLASSNAME( pent, "building_sentrygun" )) != NULL && (!FNullEnt(pent)))
			{
				int sentry_team = BotTeamColorCheck(pent);
				int bot_team = UTIL_GetTeam(pEdict);

				// don't target your own team's sentry guns...
				vecEnd = pent->v.origin + pent->v.view_ofs;// + Vector(0,0,16);
				if (bot_team == sentry_team)
				{
					float distance = (pent->v.origin - pEdict->v.origin).Length();
					if(distance<300 && pEdict->v.playerclass != TFC_CLASS_ENGINEER && FVisible( vecEnd, pEdict )
						&& FInViewCone( &vecEnd, pEdict )) 
					{
						//ntf_feature_antigren
						char *cvar_ntf_feature_antigren = (char *)CVAR_GET_STRING( "ntf_feature_antigren" );
						if(strcmp(cvar_ntf_feature_antigren,"1")==0  && pEdict->v.playerclass == TFC_CLASS_MEDIC)
						{
							FakeClientCommand(pEdict,"_special2",NULL,NULL);
						}
						FakeClientCommand(pEdict,"discard",NULL,NULL);
					}
					continue;
				}

				// don't target your allie's sentry guns either...
				if (team_allies[bot_team] & (1<<sentry_team))
				{
					float distance = (pent->v.origin - pEdict->v.origin).Length();
					if(distance<300 && pEdict->v.playerclass != TFC_CLASS_ENGINEER && FVisible( vecEnd, pEdict )
						&& FInViewCone( &vecEnd, pEdict )) 
					{
						//ntf_feature_antigren
						char *cvar_ntf_feature_antigren = (char *)CVAR_GET_STRING( "ntf_feature_antigren" );
						if(strcmp(cvar_ntf_feature_antigren,"1")==0  && pEdict->v.playerclass == TFC_CLASS_MEDIC)
						{
							FakeClientCommand(pEdict,"_special2",NULL,NULL);
						}
						FakeClientCommand(pEdict,"discard",NULL,NULL);
					}
					continue;
				}

				// is this sentry gun visible?
				if (FInViewCone( &vecEnd, pEdict ) && FVisible( vecEnd, pEdict ))
				{
					float distance = (pent->v.origin - pEdict->v.origin).Length();

					// is this the closest sentry gun?
					if (distance < nearestdistance)
					{
						nearestdistance = distance;
						pNewEnemy = pent;
						pBot->pBotUser = NULL;  // don't follow user when enemy found
						BotNadeHandler(pBot, false, bot_t::Stationary);
						rtnnull=false;
						BotSGSpotted(pBot, pent);
					}
				}
			}
			//neotf guns
			pent=NULL;
			while ((pent = FIND_ENTITY_BY_CLASSNAME( pent, "ntf_multigun" )) != NULL && (!FNullEnt(pent)))
			{
				int sentry_team = pent->v.team-1;
				int bot_team = UTIL_GetTeam(pEdict);
				if ((pent->v.flags & FL_KILLME)==FL_KILLME)			  
					continue;
				// don't target your own team's sentry guns...
				if (bot_team == sentry_team)			 
					continue;
				// don't target your allie's sentry guns either...
				if (team_allies[bot_team] & (1<<sentry_team))			 
					continue;
				//ntf_capture_mg 1 = ignore, we can cap it
				char *cvar_ntf_capture_mg = (char *)CVAR_GET_STRING( "ntf_capture_mg" );
				if(strcmp(cvar_ntf_capture_mg,"1")==0)				 
					continue;
				vecEnd = pent->v.origin + pent->v.view_ofs;
				// is this sentry gun visible?
				if (FInViewCone( &vecEnd, pEdict ) && FVisible( vecEnd, pEdict ))
				{
					float distance = (pent->v.origin - pEdict->v.origin).Length();

					// is this the closest sentry gun?
					if (distance < nearestdistance)
					{
						nearestdistance = distance;
						pNewEnemy = pent;

						pBot->pBotUser = NULL;  // don't follow user when enemy found
						BotNadeHandler(pBot, false, bot_t::Stationary);
						rtnnull=false;
					}
				}
			}
			// This function loops through the multiguns looking for a better target.
			BotCheckForMultiguns(pBot, nearestdistance, pNewEnemy, rtnnull);		  
		}
	} // end tfc mod if

	if (!pNewEnemy || (pBot->follow))
	{
		nearestdistance = 3000;

		// search the world for players...
		for (i = 1; i <= gpGlobals->maxClients; i++)
		{
			edict_t *pPlayer = INDEXENT(i);
			// skip invalid players and skip self (i.e. this bot)
			if ((pPlayer) && (!pPlayer->free) && (pPlayer != pEdict))
			{
				// skip this player if not alive (i.e. dead or dying)
				if (!IsAlive(pPlayer) && !(pPlayer->v.deadflag == 5 && RANDOM_LONG(0,(pBot->bot_skill+1)*1000)<900))
					continue;
				if ((b_observer_mode) && !((pPlayer->v.flags & FL_FAKECLIENT)==FL_FAKECLIENT))
					continue;
				if (!checked_teamplay)  // check for team play...
					BotCheckTeamplay();

				// is team play enabled?
				if (is_team_play > 0.0)
				{
					int player_team = UTIL_GetTeam(pPlayer);
					int bot_team = UTIL_GetTeam(pEdict);

					// don't target your teammates...
					if (bot_team == player_team)
						continue;
					if (mod_id == TFC_DLL)
					{
						// don't target your allies either...
						if (team_allies[bot_team] & (1<<player_team))
							continue;
						//so spys wont attack other disguised spys
						if(pEdict->v.playerclass == TFC_CLASS_SPY && (pPlayer->v.playerclass == TFC_CLASS_SPY) && 
							UTIL_GetTeam(pEdict)==UTIL_GetTeamColor(pPlayer)) 
							continue;
					}
				}

				vecEnd = pPlayer->v.origin + pPlayer->v.view_ofs;

				// see if bot can see the player...
				if (FInViewCone( &vecEnd, pEdict ) && FVisible( vecEnd, pEdict ))
				{
					float distance = (pPlayer->v.origin - pEdict->v.origin).Length();
					if (distance < nearestdistance)
					{
						nearestdistance = distance;
						pNewEnemy = pPlayer;
						pBot->pBotUser = NULL;  // don't follow user when enemy found
					}
				}
			}
		}
	}

	//don't target spys
	if(pNewEnemy && mod_id==TFC_DLL)
	{
		float distance = (pNewEnemy->v.origin - pEdict->v.origin).Length( );
		vecEnd = pEdict->v.origin + pEdict->v.view_ofs;
		if(pEdict->v.playerclass == TFC_CLASS_SPY && pBot->bot_health>25 && 
			!pBot->follow && !pBot->pBotEnemy && pBot->f_disguise_state==2 &&
			distance<400 && !(FInViewCone( &vecEnd, pNewEnemy ) && FVisible( vecEnd, pNewEnemy )))
		{
			//backstab routine...might work :)
			pBot->f_strafe=3;
			rtnnull=false;
		}
		if((UTIL_GetTeam(pEdict)==UTIL_GetTeamColor(pNewEnemy)) && (pBot->f_strafe!=3) && (pBot->f_strafe!=2)) 
		{
			//(simple ass) spy checking! :D
			if(!(((pNewEnemy->v.origin - pEdict->v.origin).Length()<1200
				&& RANDOM_LONG(0,(pBot->bot_skill+1)*1000)<bot_spy_random_check)
				|| pNewEnemy->v.deadflag == 5))	
				return (pBot->pBotEnemy);
		}
		if(rtnnull) //return null(if rtnnull==true) only if the enemy hasn't got your flag
		{
			edict_t *pent;
			bool bot_has_flag;
			pent = NULL; 
			bot_has_flag = false;    //clear it unless we know we have it
			while ((pent = FIND_ENTITY_BY_CLASSNAME( pent, "item_tfgoal" )) != NULL && (!FNullEnt(pent))) 
			{  
				if (pent->v.owner == pNewEnemy && pNewEnemy!=pEdict)
				{ 
					// is the enemy carrying the flag/card/ball 
					bot_has_flag = true; 
					if(pBot->bot_has_flag==false) 
					{
						pBot->ras=false; //we dont wanna run away from enemy flag carrier
						//track the enemy skum!
						//pBot->track_player=pent->v.owner;
						//UTIL_HostSay(pEdict, 0, "Going under cover");
					}
					break;  // break out of while loop 
				} 
			}
			if(bot_has_flag==false && ((pBot->f_bot_see_enemy_time + 2.0) <= gpGlobals->time)) 
				return (pBot->pBotEnemy); // if the enemy doesn't have the flag
		}
	}

	if (pNewEnemy)
	{	   
		Vector v_enemy = pNewEnemy->v.origin - pEdict->v.origin;
		Vector bot_angles = UTIL_VecToAngles( v_enemy );

		pEdict->v.ideal_yaw = bot_angles.y;
		pEdict->v.idealpitch = bot_angles.x;

		if(pEdict->v.playerclass == TFC_CLASS_SNIPER && pBot->current_weapon.iId == TF_WEAPON_SNIPERRIFLE &&
			pBot->bot_skill>0 && mod_id==TFC_DLL)
		{
			//BotChangeYaw(pBot,1);
		}
		else
		{
			BotFixIdealYaw(pEdict);	
		}

		// keep track of when we last saw an enemy
		pBot->f_bot_see_enemy_time = gpGlobals->time;
	}

	// has the bot NOT seen an ememy for at least 2 seconds (time to reload)?
	if ((pBot->f_bot_see_enemy_time > 0) && ((pBot->f_bot_see_enemy_time + 0.5) <= gpGlobals->time))
	{
		if(RANDOM_FLOAT(0.0, 100)<50 && pEdict->v.health > 20 && pBot->bot_has_flag==false &&
			pEdict->v.playerclass != TFC_CLASS_SCOUT &&
			pEdict->v.playerclass != TFC_CLASS_CIVILIAN &&
			pEdict->v.playerclass != TFC_CLASS_SPY &&
			pEdict->v.playerclass != TFC_CLASS_MEDIC)
		{
			pBot->goto_wp = pBot->lastenemypos;
			pBot->lastenemypos = -1;
			pBot->ras = false;
		}
		pBot->f_bot_see_enemy_time = -1;  // so we won't keep reloading
		return (pNewEnemy);

		if ((mod_id == VALVE_DLL) || (mod_id == GEARBOX_DLL) || (mod_id == TFC_DLL))
		{
			pEdict->v.button |= IN_RELOAD;  // press reload button
		}
	}

	if(!pNewEnemy)
	{
		//if(pBot->f_take_damage && pBot->pBotEnemy==NULL) UTIL_HostSay(pBot->pEdict, 0, "I'm on your team!!");
		if (RANDOM_LONG(1, 1000) <= 50)
		{
			if(pBot->f_side_direction)
				pBot->f_side_direction = false;
			else
				pBot->f_side_direction = true;
		}
		pEdict->v.button |= IN_RELOAD;  // press reload button
		//pBot->f_move_speed=-pBot->f_max_speed;
		if(!(mod_id==TFC_DLL && pEdict->v.playerclass == TFC_CLASS_SPY && pBot->f_disguise_state==2))
		{
			return (pBot->pBotEnemy);
		}
	}
	return (pNewEnemy);
}

Vector BotBodyTarget( edict_t *pBotEnemy, bot_t *pBot )
{
	edict_t *pEdict = pBot->pEdict;
	Vector target;
	float f_distance = (pBotEnemy->v.origin - pEdict->v.origin).Length();
	float f_scale;
	int d_x, d_y, d_z;	

	if (f_distance > 1000)
		f_scale = 1.0;
	else if (f_distance > 100)
		f_scale = f_distance / 1000.0;
	else
		f_scale = 0.1;
	if(pEdict->v.playerclass == TFC_CLASS_SNIPER && pBot->current_weapon.iId == TF_WEAPON_SNIPERRIFLE)
	{
		switch (pBot->bot_skill)
		{
		case 0:
			// VERY GOOD, same as from CBasePlayer::BodyTarget (in player.h)
			target = pBotEnemy->v.origin + pBotEnemy->v.view_ofs * RANDOM_FLOAT( 0.6, 1.4 );
			d_x = RANDOM_FLOAT(-10, 10) * f_scale;
			d_y = RANDOM_FLOAT(-10, 10) * f_scale;
			d_z = RANDOM_FLOAT(-15, 0) * f_scale;;
			break;
		case 1:
			// GOOD, offset a little for x, y, and z
			target = pBotEnemy->v.origin + pBotEnemy->v.view_ofs * RANDOM_FLOAT( 0.4, 1.2 );  // aim for the head (if you can find it)
			d_x = RANDOM_FLOAT(-15, 15) * f_scale;
			d_y = RANDOM_FLOAT(-15, 15) * f_scale;
			d_z = RANDOM_FLOAT(-20, 10) * f_scale;
			break;
		case 2:
			// FAIR, offset somewhat for x, y, and z
			target = pBotEnemy->v.origin;  // aim for the body
			d_x = RANDOM_FLOAT(-20, 20) * f_scale;
			d_y = RANDOM_FLOAT(-20, 20) * f_scale;
			d_z = RANDOM_FLOAT(-28, 18) * f_scale;
			break;
		case 3:
			// POOR, offset for x, y, and z
			target = pBotEnemy->v.origin;  // aim for the body
			d_x = RANDOM_FLOAT(-30, 30) * f_scale;
			d_y = RANDOM_FLOAT(-30, 30) * f_scale;
			d_z = RANDOM_FLOAT(-42, 32) * f_scale;
			break;
		case 4:
			// BAD, offset lots for x, y, and z
			target = pBotEnemy->v.origin;  // aim for the body
			d_x = RANDOM_FLOAT(-45, 45) * f_scale;
			d_y = RANDOM_FLOAT(-45, 45) * f_scale;
			d_z = RANDOM_FLOAT(-60, 50) * f_scale;
			break;
		}
	}
	else
	{
		switch (pBot->bot_skill)
		{
		case 0:
			// VERY GOOD, same as from CBasePlayer::BodyTarget (in player.h)
			target = pBotEnemy->v.origin + pBotEnemy->v.view_ofs * RANDOM_FLOAT( 0.5, 1.1 );
			d_x = 0;  // no offset
			d_y = 0;
			d_z = RANDOM_FLOAT(-10, 0) * f_scale;;
			break;
		case 1:
			// GOOD, offset a little for x, y, and z
			target = pBotEnemy->v.origin + pBotEnemy->v.view_ofs * RANDOM_FLOAT( 0.2, 1.1 );  // aim for the head (if you can find it)
			d_x = RANDOM_FLOAT(-40, 40) * f_scale;
			d_y = RANDOM_FLOAT(-40, 40) * f_scale;
			d_z = RANDOM_FLOAT(-40, 40) * f_scale;
			break;
		case 2:
			// FAIR, offset somewhat for x, y, and z
			target = pBotEnemy->v.origin;  // aim for the body
			d_x = RANDOM_FLOAT(-50, 50) * f_scale;
			d_y = RANDOM_FLOAT(-50, 50) * f_scale;
			d_z = RANDOM_FLOAT(-58, 38) * f_scale;
			break;
		case 3:
			// POOR, offset for x, y, and z
			target = pBotEnemy->v.origin;  // aim for the body
			d_x = RANDOM_FLOAT(-70, 70) * f_scale;
			d_y = RANDOM_FLOAT(-70, 70) * f_scale;
			d_z = RANDOM_FLOAT(-82, 72) * f_scale;
			break;
		case 4:
			// BAD, offset lots for x, y, and z
			target = pBotEnemy->v.origin;  // aim for the body
			d_x = RANDOM_FLOAT(-85, 85) * f_scale;
			d_y = RANDOM_FLOAT(-85, 85) * f_scale;
			d_z = RANDOM_FLOAT(-80, 80) * f_scale;
			break;
		}
	}	

	// projectile prediction targetting & grenade arcing
	int zDiff;
	float dist2d;

	zDiff = (pBot->pBotEnemy->v.origin.z - pBot->pEdict->v.origin.z);
	dist2d = (pBotEnemy->v.origin - pEdict->v.origin).Length2D();

	// Add some error into the distance calculation based on skill level. This should add some lead error.
	dist2d += RANDOM_LONG(-dist2d*0.95f, dist2d*0.95f);
	dist2d += RANDOM_LONG(-pBot->bot_skill, pBot->bot_skill) * 10;

	if(!pBot->tossNade && pBot->current_weapon.iId == TF_WEAPON_RPG ||
		pBot->current_weapon.iId == TF_WEAPON_IC ||
		pBot->current_weapon.iId == TF_WEAPON_GL)
	{   
		BotLeadTarget(pBotEnemy, pBot, 725, d_x, d_y, d_z);	

		// arc grenade launcher
		if (pBot->current_weapon.iId == TF_WEAPON_GL)
		{
			if (zDiff > 100 || dist2d > 650)
			{
				d_z += dist2d/3; 			
			}	
		}
	} 

	// Lead for the nade.
	if (pBot->tossNade)
	{
		// Need to arc up more if they are high or far away.
		if (zDiff > 70 || dist2d > 500)
		{
			d_z += dist2d; 
			//UTIL_HostSay(pBot->pEdict, 0, "arcing up");	
		}	
		pBot->tossNade = 0;	
	}	

	if(mod_id==TFC_DLL && (pBot->pEdict->v.playerclass==TFC_CLASS_MEDIC || pBot->pEdict->v.playerclass==TFC_CLASS_ENGINEER) &&
		((pBot->current_weapon.iId==TF_WEAPON_MEDIKIT) || (pBot->current_weapon.iId==TF_WEAPON_SPANNER)))
		target = pBotEnemy->v.origin + pBotEnemy->v.view_ofs;
	if(mod_id==TFC_DLL && pBot->pEdict->v.playerclass==TFC_CLASS_HWGUY && pBot->current_weapon.iId==TF_WEAPON_AC)
	{
		target = pBotEnemy->v.origin + pBotEnemy->v.view_ofs;
		int botSkill = pBot->bot_skill;
		d_x += RANDOM_FLOAT(-8-botSkill,8+botSkill);
		d_y += RANDOM_FLOAT(-8-botSkill,8+botSkill);
		d_z += RANDOM_FLOAT(-8-botSkill,8+botSkill);
	}

	// Make them less accurate based on targets speed.
	if (pBot->pEdict->v.velocity.Length() > 400)
	{
		//UTIL_HostSay(pBot->pEdict, 0, "Your too fast.");
		float error = RANDOM_FLOAT(-pBot->pEdict->v.velocity.Length(), pBot->pEdict->v.velocity.Length()) * 0.10f;
		d_x += error;
		d_y += error;
		d_z += error;
	}
	if((pBotEnemy->v.deadflag == 5) && (pBot->pEdict->v.playerclass!=TFC_CLASS_SOLDIER))
		d_z -= 32;

	target = target + Vector(d_x, d_y, d_z);
	return target;
}

// specifing a weapon_choice allows you to choose the weapon the bot will
// use (assuming enough ammo exists for that weapon)
// BotFireWeapon will return TRUE if weapon was fired, FALSE otherwise
bool BotFireWeapon( Vector v_enemy, bot_t *pBot, int weapon_choice)
{
	bot_weapon_select_t *pSelect = NULL;
	bot_fire_delay_t *pDelay = NULL;
	int select_index, iId;
	bool use_primary, use_secondary;
	int use_percent, primary_percent;

	edict_t *pEdict = pBot->pEdict;
	float f_distance = v_enemy.Length();  // how far away is the enemy? 

	if(pBot->concuss)
	{
		pEdict->v.ideal_yaw += RANDOM_FLOAT(-45,45);
		pEdict->v.idealpitch += RANDOM_FLOAT(-45,45);
		BotFixIdealYaw(pEdict);
		BotFixIdealPitch(pEdict);
		//UTIL_HostSay(pEdict, 0, "concussed");
	}

	if ((pBot->pEdict->v.playerclass == TFC_CLASS_PYRO) && (pBot->FreezeDelay < gpGlobals->time) && (f_distance < 200) && (RANDOM_LONG(1,10) > 2+pBot->bot_skill))
	{
		pBot->FreezeDelay = gpGlobals->time + 1.0;
		FakeClientCommand(pEdict,"freeze", "102",NULL);
	} else
		pBot->FreezeDelay = gpGlobals->time + 0.2f;

	if(pBot->current_weapon.iId == TF_WEAPON_RPG || pBot->current_weapon.iId == TF_WEAPON_IC || 
		pBot->current_weapon.iId == TF_WEAPON_GL)
	{
		double pi = 3.1415926535897932384626433832795;
		double diff=pEdict->v.v_angle.y;//-pEdict->v.ideal_yaw;
		double ang;
		if(diff<-180)
			diff=diff+360;
		if(diff>180)
			diff=diff-360;
		diff=diff-pEdict->v.ideal_yaw;
		if(diff<-180)
			diff=diff+360;
		if(diff>180)
			diff=diff-360;

		ang=(((32*pBot->bot_skill)+16)/f_distance);
		ang=tan(ang);
		ang=ang*180;

		if(diff<0)
			diff=-diff;

		/*char msg[512];
		sprintf(msg,"%f  %f",ang,diff);
		UTIL_HostSay(pEdict,0,msg);*/
		if(ang<diff) //|| (FInViewCone( &v_enemy, pEdict ) && FVisible( v_enemy, pEdict )))
			return false;
	} 
	//////////////////
	int distance = f_distance;

	if(pEdict->v.playerclass == TFC_CLASS_SNIPER && mod_id==TFC_DLL && ((pEdict->v.waterlevel >= 2 || pEdict->v.movetype == MOVETYPE_FLY)) &&
		(!((pEdict->v.button & IN_ATTACK)==IN_ATTACK && pBot->current_weapon.iId == TF_WEAPON_SNIPERRIFLE) || pEdict->v.waterlevel >= 2))
	{
		distance=100; // use autorifle when running
	}
	else 
	{
		if(pEdict->v.playerclass == TFC_CLASS_SNIPER && pBot->current_weapon.iId == TF_WEAPON_SNIPERRIFLE &&
			pBot->pBotEnemy!=NULL && mod_id == TFC_DLL && distance>300)
			return true;
	}
	//demoman gl launcher hight restriction :D
	if(pEdict->v.playerclass == TFC_CLASS_DEMOMAN && mod_id==TFC_DLL && distance<900)
	{
		if(pBot->pBotEnemy!=NULL)
		{
			int z;
			z=pBot->pBotEnemy->v.origin.z - pEdict->v.origin.z;
			if(z > 0 && z < 300 && distance<901)
				distance=(pBot->pBotEnemy->v.origin - pEdict->v.origin).Length2D()+(z*3);
			else if(z>300 && distance<901)
				distance=901;
		}
	}

	if (mod_id == TFC_DLL)
	{
		pSelect = &tfc_weapon_select[0];
		pDelay = &tfc_fire_delay[0];
	}

	if (pSelect)
	{
		// are we charging the primary fire?
		if (pBot->f_primary_charging > 0)
		{
			iId = pBot->charging_weapon_id;
			if (mod_id == TFC_DLL)
			{
				if (iId == TF_WEAPON_SNIPERRIFLE)
				{
					pBot->f_move_speed = 0;  // don't move while using sniper rifle
				}
			}

			// is it time to fire the charged weapon?
			if (pBot->f_primary_charging <= gpGlobals->time)
			{
				// we DON'T set pEdict->v.button here to release the
				// fire button which will fire the charged weapon

				pBot->f_primary_charging = -1;  // -1 means not charging
				// find the correct fire delay for this weapon
				select_index = 0;

				while ((pSelect[select_index].iId) && (pSelect[select_index].iId != iId))
					select_index++;

				// set next time to shoot
				int skill = pBot->bot_skill;
				float base_delay, min_delay, max_delay;

				base_delay = pDelay[select_index].primary_base_delay;
				min_delay = pDelay[select_index].primary_min_delay[skill];
				max_delay = pDelay[select_index].primary_max_delay[skill];

				//pBot->f_shoot_time = gpGlobals->time + base_delay +
				//   RANDOM_FLOAT(min_delay, max_delay);
				return TRUE;
			}
			else
			{
				pEdict->v.button |= IN_ATTACK;   // charge the weapon
				pBot->f_shoot_time = gpGlobals->time;  // keep charging
				return TRUE;
			}
		}

		// are we charging the secondary fire?
		if (pBot->f_secondary_charging > 0)
		{
			iId = pBot->charging_weapon_id;
			// is it time to fire the charged weapon?
			if (pBot->f_secondary_charging <= gpGlobals->time)
			{
				// we DON'T set pEdict->v.button here to release the
				// fire button which will fire the charged weapon

				pBot->f_secondary_charging = -1;  // -1 means not charging
				// find the correct fire delay for this weapon
				select_index = 0;

				while ((pSelect[select_index].iId) && (pSelect[select_index].iId != iId))
					select_index++;

				// set next time to shoot
				int skill = pBot->bot_skill;
				float base_delay, min_delay, max_delay;

				base_delay = pDelay[select_index].secondary_base_delay;
				min_delay = pDelay[select_index].secondary_min_delay[skill];
				max_delay = pDelay[select_index].secondary_max_delay[skill];
				return TRUE;
			}
			else
			{
				pEdict->v.button |= IN_ATTACK2;  // charge the weapon
				pBot->f_shoot_time = gpGlobals->time;  // keep charging
				return TRUE;
			}
		}

		select_index = 0;
		use_primary = FALSE;
		use_secondary = FALSE;
		// loop through all the weapons until terminator is found...
		pBot->lowammo = false;
		while (pSelect[select_index].iId && !use_primary && !use_secondary)
		{
			// was a weapon choice specified? (and if so do they NOT match?)
			if ((weapon_choice != 0) && (weapon_choice != pSelect[select_index].iId))
			{
				select_index++;  // skip to next weapon
				continue;
			}

			// is the bot NOT carrying this weapon?
			if (!(pBot->bot_weapons & (1<<pSelect[select_index].iId)))
			{
				select_index++;  // skip to next weapon
				continue;
			}   

			// is the bot NOT skilled enough to use this weapon?
			if ((pBot->bot_skill+1) > pSelect[select_index].skill_level)
			{
				select_index++;  // skip to next weapon
				continue;
			}

			// is the bot underwater and does this weapon NOT work under water?
			if ((pEdict->v.waterlevel == 3) && !(pSelect[select_index].can_use_underwater))
			{
				select_index++;  // skip to next weapon
				continue;
			}

			use_percent=0;

			// is use percent greater than weapon use percent?
			if (use_percent > pSelect[select_index].use_percent)
			{
				select_index++;  // skip to next weapon
				continue;
			}

			iId = pSelect[select_index].iId;
			use_primary = use_secondary = FALSE;
			primary_percent = 0;

			//my code for get ammo on low
			if((pBot->m_rgAmmo[weapon_defs[iId].iAmmo1] < pSelect[select_index].min_primary_ammo))
			{
				pBot->lowammo=true;
			}
			else pBot->lowammo=false;

			// is primary percent less than weapon primary percent AND
			// no ammo required for this weapon OR
			// enough ammo available to fire AND
			// the bot is far enough away to use primary fire AND
			// the bot is close enough to the enemy to use primary fire

			if ((primary_percent <= pSelect[select_index].primary_fire_percent) &&
				((weapon_defs[iId].iAmmo1 == -1) || (pBot->m_rgAmmo[weapon_defs[iId].iAmmo1] >=
				pSelect[select_index].min_primary_ammo)) && (distance >= pSelect[select_index].primary_min_distance) &&
				(distance <= pSelect[select_index].primary_max_distance))
			{
				use_primary = TRUE;
			}

			// otherwise see if there is enough secondary ammo AND
			// the bot is far enough away to use secondary fire AND
			// the bot is close enough to the enemy to use secondary fire
			else if (((weapon_defs[iId].iAmmo2 == -1) || (pBot->m_rgAmmo[weapon_defs[iId].iAmmo2] >=
				pSelect[select_index].min_secondary_ammo)) && (distance >= pSelect[select_index].secondary_min_distance) &&
				(distance <= pSelect[select_index].secondary_max_distance))
			{
				use_secondary = TRUE;
			}

			// see if there wasn't enough ammo to fire the weapon...
			if ((use_primary == FALSE) && (use_secondary == FALSE))
			{
				select_index++;  // skip to next weapon
				continue;
			}

			// select this weapon if it isn't already selected
			if (pBot->current_weapon.iId != iId)
				UTIL_SelectItem(pEdict, pSelect[select_index].weapon_name);

			if (pDelay[select_index].iId != iId)
			{
				char msg[80];
				sprintf(msg, "fire_delay mismatch for weapon id=%d\n",iId);
				ALERT(at_console, msg);
				return FALSE;
			}

			if (mod_id == TFC_DLL)
			{
				if (iId == TF_WEAPON_SNIPERRIFLE)
				{
					pBot->f_move_speed = 0;  // don't move while using sniper rifle

					if (pEdict->v.velocity.Length() > 50)					
						return FALSE;  // don't press attack key until velocity is < 50
				}

				if ((pEdict->v.playerclass == TFC_CLASS_MEDIC) || (pEdict->v.playerclass == TFC_CLASS_ENGINEER))
				{
					int player_team = UTIL_GetTeam(pBot->pBotEnemy);
					int bot_team = UTIL_GetTeam(pEdict); 

					// only heal your teammates or allies...
					if (((bot_team == player_team) || (team_allies[bot_team] & (1<<player_team))) &&
						((iId != TF_WEAPON_MEDIKIT) && (iId != TF_WEAPON_SPANNER)))
					{
						pBot->backwards=false;
						pBot->backwards_time=0;
						pBot->f_strafe=2;
						//return FALSE;  // don't "fire" unless weapon is medikit
						use_primary=false;
					}
				} 
			}

			if (use_primary)
			{
				pEdict->v.button |= IN_ATTACK;  // use primary attack

				if (pSelect[select_index].primary_fire_charge)
				{
					pBot->charging_weapon_id = iId;					
					// release primary fire after the appropriate delay...
					pBot->f_primary_charging = gpGlobals->time + pSelect[select_index].primary_charge_delay;
					pBot->f_shoot_time = gpGlobals->time;  // keep charging
				}
				else
				{
					// set next time to shoot
					if (pSelect[select_index].primary_fire_hold)
						pBot->f_shoot_time = gpGlobals->time;  // don't let button up
					else
					{
						int skill = pBot->bot_skill;
						float base_delay, min_delay, max_delay;

						base_delay = pDelay[select_index].primary_base_delay;
						min_delay = pDelay[select_index].primary_min_delay[skill];
						max_delay = pDelay[select_index].primary_max_delay[skill];

						//pBot->f_shoot_time = gpGlobals->time + base_delay +
						//   RANDOM_FLOAT(min_delay, max_delay);
						pBot->f_shoot_time = gpGlobals->time + 0.05;
					}
				}
			}
			else  // MUST be use_secondary...
			{
				pEdict->v.button |= IN_ATTACK2;  // use secondary attack
				if (pSelect[select_index].secondary_fire_charge)
				{
					pBot->charging_weapon_id = iId;

					// release secondary fire after the appropriate delay...
					pBot->f_secondary_charging = gpGlobals->time + pSelect[select_index].secondary_charge_delay;
					pBot->f_shoot_time = gpGlobals->time;  // keep charging
				}
				else
				{
					// set next time to shoot
					if (pSelect[select_index].secondary_fire_hold)
						pBot->f_shoot_time = gpGlobals->time;  // don't let button up
					else
					{
						float base_delay, min_delay, max_delay;						
						base_delay = pDelay[select_index].secondary_base_delay;
						min_delay = pDelay[select_index].secondary_min_delay[pBot->bot_skill];
						max_delay = pDelay[select_index].secondary_max_delay[pBot->bot_skill];						
						//pBot->f_shoot_time = gpGlobals->time + base_delay +
						//   RANDOM_FLOAT(min_delay, max_delay);
						pBot->f_shoot_time = gpGlobals->time + 0.05;
					}
				}
			}
			return TRUE;  // weapon was fired
		}
	}
	// didn't have any available weapons or ammo, return FALSE
	return FALSE;
}


void BotShootAtEnemy( bot_t *pBot )
{
	if (mod_id == TFC_DLL)
	{
		edict_t *pEdict = pBot->pEdict;
		// aim for the head and/or body
		Vector v_enemy = BotBodyTarget( pBot->pBotEnemy, pBot ) - GetGunPosition(pEdict);
		float f_distance = v_enemy.Length();  // how far away is the enemy scum?

		//return in spy isn't in range to backstab....muwhahaha!
		if(pBot->f_strafe==3 && f_distance>50) 
			return;

		// aim at feet
		if ((pBot->pBotEnemy->v.origin.z <= (pEdict->v.origin.z+35)) && 
			((pEdict->v.playerclass == TFC_CLASS_PYRO) && (pBot->current_weapon.iId == TF_WEAPON_IC)) ||
			((pEdict->v.playerclass == TFC_CLASS_SOLDIER) && (pBot->current_weapon.iId == TF_WEAPON_RPG)))
			v_enemy.z = v_enemy.z-RANDOM_LONG(20, 40);


		Vector vv = UTIL_VecToAngles( v_enemy );	
		pBot->idle_angle = vv.y;
		pEdict->v.idealpitch = vv.x;
		pEdict->v.ideal_yaw = pBot->idle_angle;
		v_enemy.z = 0;  // ignore z component (up & down)

		//if on the same team(follow) don't shoot!
		// is team play enabled?
		if (is_team_play > 0.0)
		{
			if ((pEdict->v.playerclass == TFC_CLASS_MEDIC) || (pEdict->v.playerclass == TFC_CLASS_ENGINEER)) 
			{
				//try to get medic to heal only.
				// is it time to shoot yet?
				if (pBot->f_shoot_time <= gpGlobals->time)
				{
					pBot->f_move_speed = pBot->f_max_speed;
					pBot->f_strafe=2;
					pBot->backwards=false;
					pBot->backwards_time=0;
					// select the best weapon to use at this distance and fire...
					BotFireWeapon(v_enemy, pBot, 0);
					if(UTIL_GetTeamColor(pBot->pBotEnemy) == UTIL_GetTeam(pEdict)) 
						return;
				}
			}
			int player_team = UTIL_GetTeam(pBot->pBotEnemy);
			int bot_team = UTIL_GetTeam(pEdict);

			// don't target your teammates...
			if (bot_team == player_team)
			{
				pBot->f_strafe = 2;
				return;
			}

			// don't target your allies either...
			if (team_allies[bot_team] & (1<<player_team))
			{
				pBot->f_strafe=2;
				return;
			}
		}
		// is it time to shoot yet?
		if (pBot->f_shoot_time <= gpGlobals->time)
		{
			// select the best weapon to use at this distance and fire...
			BotFireWeapon(v_enemy, pBot, 0);
		}
	}	
}

// Handles bots grenade priming, and throwing, based on timer & target dist
int BotNadeHandler( bot_t *pBot, bool timed, char nadeTyp)
{
	// BotNadeHandler - This function handles all grenade related actions, except for concussion grenade primings
	// when used for conc jumps. A call to this function would pass in the bot, the grenade type, and whether or
	// not this call is intended to be timed or not. If there is already a grenade primed when a new call is made, 
	// the new call is ignored and the function exits after the evaluations on whether it is time to throw or not.
	// If a call to throw a stationary grenade type(usually sentrys) is recieved, the bot will toss any priming grenades
	// at the target immediately. // This function also handles looking ahead to the next waypoint and checking
	// whether or not the sentry they have in memory is viewable from there. If so they will anticipate contact
	// and prime a grenade, and acquire the target early just before contact. This should help their ability to kill it.

	// Lets try putting discard code in here. (dont let the engy discard)
	if (pBot->discard_time < gpGlobals->time && pBot->pEdict->v.playerclass != TFC_CLASS_ENGINEER)
	{
        FakeClientCommand(pBot->pEdict,"discard",NULL,NULL);
		if (pBot->mission == pBot->Attacker) pBot->discard_time = gpGlobals->time + 5.0f;
		else if (pBot->mission == pBot->Defender) pBot->discard_time = gpGlobals->time + 15.0f;
		else pBot->discard_time = gpGlobals->time + 15.0f;
	}

	if (pBot->ConcJumping)
		return 0;

#define BACKWARDS_TIME 1.0
	// Our return value.
	int rtnValue = 0;	
	edict_t *pEdict = pBot->pEdict;

	// Do we need to toss? No for now...
	bool toss = false;

	// Time left to detonation
	float timeToDet = 4.0f - (gpGlobals->time - pBot->primeTime);
	float zDiff = 0;
	float distanceToTarget;
	int player_team, bot_team;

	// try to turn around backwards if nades about to explode
	if (timeToDet <= 0.80 && pBot->nadePrimed && !pBot->pBotEnemy)
	{
		pBot->backwards = true;
		pBot->backwards_time = gpGlobals->time + BACKWARDS_TIME;
	}

	// Go ahead and throw if its about to splode.
	if (pBot->nadePrimed && timeToDet <= 0.80 && (pBot->nadeType=bot_t::MIRV))	
		toss = true;
	else if (pBot->nadePrimed && timeToDet <= 0.50)	
		toss = true;

	// If we're tracking an enemy.
	if(pBot->pBotEnemy && pBot->nadePrimed) 
	{ 
		player_team = UTIL_GetTeam(pBot->pBotEnemy);
		bot_team = UTIL_GetTeam(pEdict);				
		distanceToTarget = (pBot->pBotEnemy->v.origin - pEdict->v.origin).Length();

		// Check the distance against where the bot thinks the nade will blow if thrown now.
		float distanceThrown = NADEVELOCITY * timeToDet;

		// Elevation check, until they can toss shit up to ledges better.
		zDiff = pBot->pBotEnemy->v.origin.z - pEdict->v.origin.z;
		// Throw it if we got a good chance at landing good splash damage.
		if (abs(distanceThrown - distanceToTarget) < 20 || (distanceThrown-distanceToTarget) < -200)	
		{
			toss = true;
			pBot->tossNade = 1;
			//UTIL_HostSay(pEdict, 0, "Die Bitch!!");
		}

		// If target is rapidly(ish) moving away from me, go ahead and throw.
		// Uses a timer delay between checks
		if ((pBot->lastDistanceCheck <= gpGlobals->time) && (pBot->lastDistance > (distanceToTarget + 375)
			&& (distanceToTarget > 500)))
		{
			toss = true;
			pBot->tossNade = 1;
			pBot->lastDistanceCheck = gpGlobals->time + 1;
			//UTIL_HostSay(pEdict, 0, "Come Back Here!!"); 
		}
		// go ahead and toss if enemy is our team
		if (player_team == bot_team)
		{
			toss = true;
			pBot->tossNade = 2;
		}		

		// Update last distance to target for comparison purposes with above check.
		pBot->lastDistance = distanceToTarget;
	}   

	// Time to throw?
	if(toss || (pEdict->v.waterlevel == 3))
	{	
		// Throw the mofos!
		FakeClientCommand(pEdict,"-gren1", "102",NULL);
		FakeClientCommand(pEdict,"-gren2", "101",NULL); 
		rtnValue = 1;
		pBot->nadePrimed = false;
		pBot->nadeType = 0;	
	}     

	if (pBot->curr_waypoint_index != pBot->lastWPIndexChecked)
	{
		pBot->lastWPIndexChecked = pBot->curr_waypoint_index;
		// If we have a last seen sg, lets try checking the visibility from the next waypoint we are heading. 	
		if (pBot->pBotLastSgEnemy) 
		{
			zDiff = pBot->pBotLastSgEnemy->v.origin.z - waypoints[pBot->curr_waypoint_index].origin.z;
			float dist = (pBot->pEdict->v.origin - waypoints[pBot->curr_waypoint_index].origin).Length();
			rtnValue = zDiff;
			TraceResult result;
			UTIL_TraceLine( waypoints[pBot->curr_waypoint_index].origin, pBot->pBotLastSgEnemy->v.origin, ignore_monsters, pEdict->v.pContainingEntity, &result );

			// Are we close enough to attack?
			if ((result.flFraction >= 1.0) && (dist < 600) && (zDiff <= 700))
			{
				// Lets see if the scout can use the ring of shadows
				if (pEdict->v.playerclass == TFC_CLASS_SCOUT)
					FakeClientCommand(pEdict,"_special2", "102",NULL);

				/*char buffer[150];
				sprintf(buffer, "SG Early Prime P: %d S: %d", pBot->grenades[bot_t::Primary], pBot->grenades[bot_t::Secondary]); 
				UTIL_HostSay(pEdict, 0, buffer);*/

				nadeTyp = bot_t::Damage;
				timed = true;           
				pBot->pBotEnemy = pBot->pBotLastSgEnemy; 
			} 	
		}
	}
	// Get out if: nothing NEW to throw, or underwater
	if (!nadeTyp || (pEdict->v.waterlevel == 3))
		return rtnValue;

	if (pBot->pBotEnemy)
	{		
		distanceToTarget = (pBot->pBotEnemy->v.origin - pEdict->v.origin).Length();
		player_team = UTIL_GetTeam(pBot->pBotEnemy);
		bot_team = UTIL_GetTeam(pEdict);
		if (player_team == bot_team)
			return rtnValue;
	}
	// Skill level based primed grenade hold time.
	float primeError = -RANDOM_FLOAT(0.0,float(pBot->bot_skill)) * 0.1f;	

	// Otherwise Do throw stuff if we don't currently have a nade primed
	if ((!pBot->nadePrimed && (zDiff <= 400) && (distanceToTarget < 1200)) && 
		pBot->pBotEnemy && (player_team != bot_team))
	{
		switch(pEdict->v.playerclass)
		{
		case TFC_CLASS_SCOUT:
			if (nadeTyp == bot_t::Distract)
			{
				FakeClientCommand(pEdict,"+gren2", "101",NULL); 
				pBot->nadeType = bot_t::Concussion;				
				pBot->nadePrimed = true; 
				pBot->primeTime = gpGlobals->time + primeError;
			} else if (nadeTyp == bot_t::Damage)
			{
				FakeClientCommand(pEdict,"+gren1", "102",NULL);
				pBot->nadeType = bot_t::Caltrop;				
				pBot->nadePrimed = true; 
				pBot->primeTime = gpGlobals->time + primeError;	
			}
			break;
		case TFC_CLASS_SNIPER:
			if (nadeTyp == bot_t::Damage)
			{
				FakeClientCommand(pEdict,"+gren1", "102",NULL);
				pBot->nadeType = bot_t::Grenade;				
				pBot->nadePrimed = true; 
				pBot->primeTime = gpGlobals->time + primeError;
			}
			break;
		case TFC_CLASS_SOLDIER:
			if (nadeTyp == bot_t::Stationary)
			{
				FakeClientCommand(pEdict,"+gren2", "101",NULL);
				FakeClientCommand(pEdict,"-gren2", "101",NULL);
			} else if (nadeTyp == bot_t::Damage)
			{
				FakeClientCommand(pEdict,"+gren1", "102",NULL);
				pBot->nadeType = bot_t::Grenade;				
				pBot->nadePrimed = true; 
				pBot->primeTime = gpGlobals->time + primeError;
			} else if (nadeTyp == bot_t::Random)
			{
				if (RANDOM_LONG(0, 100) >= 80)
				{
					FakeClientCommand(pEdict,"+gren2", "101",NULL);
					FakeClientCommand(pEdict,"-gren2", "101",NULL);
				}
				else
				{
					FakeClientCommand(pEdict,"+gren1", "102",NULL);
					pBot->nadeType = bot_t::Grenade;
					pBot->nadePrimed = true; 
					pBot->primeTime = gpGlobals->time + primeError;
				}						
			}					
			break;
		case TFC_CLASS_DEMOMAN:
			if (nadeTyp == bot_t::Stationary)
			{
				FakeClientCommand(pEdict,"+gren2", "101",NULL);
				FakeClientCommand(pEdict,"-gren2", "101",NULL);	
			} else if (nadeTyp == bot_t::Damage)
			{
				FakeClientCommand(pEdict,"+gren1", "102",NULL);
				pBot->nadeType = bot_t::Grenade;				
				pBot->nadePrimed = true; 
				pBot->primeTime = gpGlobals->time + primeError;
			} else if (nadeTyp == bot_t::Random)
			{
				if ((RANDOM_LONG(0, 100) >= 70) || (BotHealthValue(pEdict) < 40))
				{
					FakeClientCommand(pEdict,"+gren2", "101",NULL);
					pBot->nadeType = bot_t::MIRV;
				}
				else
				{	
					FakeClientCommand(pEdict,"+gren1", "102",NULL);
					pBot->nadeType = bot_t::Grenade;
				}						
				pBot->nadePrimed = true; 
				pBot->primeTime = gpGlobals->time + primeError;
			}
			break; 
		case TFC_CLASS_MEDIC:
			if (nadeTyp == bot_t::Distract)
			{
				FakeClientCommand(pEdict,"+gren2", "101",NULL); 
				pBot->nadeType = bot_t::Concussion;					
				pBot->nadePrimed = true; 
				pBot->primeTime = gpGlobals->time + primeError;
			} else if ((nadeTyp == bot_t::Damage))
			{
				if (RANDOM_LONG(0,100) < 20)
					FakeClientCommand(pEdict,"snark",NULL,NULL);
				FakeClientCommand(pEdict,"+gren1", "102",NULL);
				pBot->nadeType = bot_t::Grenade;					
				pBot->nadePrimed = true; 
				pBot->primeTime = gpGlobals->time + primeError;
			} else if (nadeTyp == bot_t::Stationary)
			{	
				if (pBot->grenades[bot_t::Primary] <= 0)
				{
					FakeClientCommand(pEdict,"+gren2", "101",NULL);
					FakeClientCommand(pEdict,"-gren2", "101",NULL);	
				}
				FakeClientCommand(pEdict,"+gren1", "102",NULL);
				FakeClientCommand(pEdict,"-gren1", "102",NULL);
				FakeClientCommand(pEdict,"snark",NULL,NULL);
				FakeClientCommand(pEdict,"snark",NULL,NULL);
				pBot->primeTime = gpGlobals->time + primeError;
			}
			break;
		case TFC_CLASS_HWGUY:
			if (nadeTyp == bot_t::Stationary)
			{
				FakeClientCommand(pEdict,"+gren2", "101",NULL);
				FakeClientCommand(pEdict,"-gren2", "101",NULL);
			} else if (nadeTyp == bot_t::Damage)
			{
				FakeClientCommand(pEdict,"+gren1", "102",NULL);
				pBot->nadeType = bot_t::Grenade;				
				pBot->nadePrimed = true; 
				pBot->primeTime = gpGlobals->time + primeError;
			} else if (nadeTyp == bot_t::Random)
			{
				if (RANDOM_LONG(0, 100) >= 50)
				{
					FakeClientCommand(pEdict,"+gren2", "101",NULL);
					pBot->nadeType = bot_t::MIRV;
				}
				else
				{
					FakeClientCommand(pEdict,"+gren1", "102",NULL);
					pBot->nadeType = bot_t::Grenade;
				}							
				pBot->nadePrimed = true; 
				pBot->primeTime = gpGlobals->time + primeError;
			}
			break;
		case TFC_CLASS_PYRO:
			if (nadeTyp == bot_t::Stationary)
			{
				FakeClientCommand(pEdict,"+gren2", "101",NULL);
				FakeClientCommand(pEdict,"-gren2", "101",NULL);
				FakeClientCommand(pEdict,"+gren2", "101",NULL);
				FakeClientCommand(pEdict,"-gren2", "101",NULL);	
			} else if (nadeTyp == bot_t::Damage)
			{
				FakeClientCommand(pEdict,"+gren1", "102",NULL);
				pBot->nadeType = bot_t::Grenade;				
				pBot->nadePrimed = true; 
				pBot->primeTime = gpGlobals->time + primeError;
			} else if (nadeTyp == bot_t::Random)
			{
				if (RANDOM_LONG(0, 100) >= 50)
				{
					FakeClientCommand(pEdict,"+gren2", "101",NULL);
					pBot->nadeType = bot_t::Flame;
				}
				else
				{
					FakeClientCommand(pEdict,"+gren1", "102",NULL);
					pBot->nadeType = bot_t::Grenade;
				}					
				pBot->nadePrimed = true; 
				pBot->primeTime = gpGlobals->time + primeError;
			}
			break;
		case TFC_CLASS_SPY:
			if (nadeTyp == bot_t::Stationary)
			{
				FakeClientCommand(pEdict,"+gren1", "102",NULL);
				FakeClientCommand(pEdict,"-gren1", "102",NULL);
				FakeClientCommand(pEdict,"+gren1", "102",NULL);
				FakeClientCommand(pEdict,"-gren1", "102",NULL);
				if (pBot->grenades[bot_t::Primary] <= 0)
				{
					FakeClientCommand(pEdict,"+gren2", "101",NULL);
					FakeClientCommand(pEdict,"-gren2", "101",NULL);	
				}						
			} else if (nadeTyp == bot_t::Distract)
			{
				FakeClientCommand(pEdict,"+gren2", "101",NULL); 
				pBot->nadeType = bot_t::Gas;					
				pBot->nadePrimed = true; 
				pBot->primeTime = gpGlobals->time + primeError;
			} else if (nadeTyp == bot_t::Damage)
			{
				FakeClientCommand(pEdict,"+gren1", "102",NULL);
				pBot->nadeType = bot_t::Grenade;				
				pBot->nadePrimed = true; 
				pBot->primeTime = gpGlobals->time + primeError;
			} else if (nadeTyp == bot_t::Random)
			{				
				FakeClientCommand(pEdict,"+gren1", "102",NULL);
				pBot->nadeType = bot_t::Grenade;

				pBot->nadePrimed = true; 
				pBot->primeTime = gpGlobals->time + primeError;
			}
			break;
		case TFC_CLASS_ENGINEER:
			if (nadeTyp == bot_t::Stationary && pBot->grenades[bot_t::Secondary] != 0)
			{
				FakeClientCommand(pEdict,"+gren2", "101",NULL);
				FakeClientCommand(pEdict,"-gren2", "101",NULL);
				FakeClientCommand(pEdict,"+gren2", "101",NULL);
				FakeClientCommand(pEdict,"-gren2", "101",NULL);
			} else if (nadeTyp == bot_t::Damage && pBot->grenades[bot_t::Primary] != 0)
			{
				FakeClientCommand(pEdict,"+gren1", "102",NULL);
				pBot->nadeType = bot_t::Grenade;				
				pBot->nadePrimed = true; 
				pBot->primeTime = gpGlobals->time + primeError;
			} else if (nadeTyp == bot_t::Random)
			{
				if (pBot->pBotEnemy->v.playerclass == TFC_CLASS_HWGUY ||
					pBot->pBotEnemy->v.playerclass == TFC_CLASS_DEMOMAN ||
					pBot->pBotEnemy->v.playerclass == TFC_CLASS_SOLDIER &&
					pBot->grenades[bot_t::Secondary] != 0 ||
					pBot->grenades[bot_t::Primary] == 0)
				{
					FakeClientCommand(pEdict,"+gren2", "101",NULL);
					pBot->nadeType = bot_t::EMP;
				}
				else
				{
					FakeClientCommand(pEdict,"+gren1", "102",NULL);
					pBot->nadeType = bot_t::Grenade;
				}							
				pBot->nadePrimed = true; 
				pBot->primeTime = gpGlobals->time + primeError;
			}
			break;
		}
	}

	// Go ahead and toss em if they aren't meant to be timed.
	if (!timed)
	{		
		FakeClientCommand(pEdict,"-gren1", "102",NULL);
		FakeClientCommand(pEdict,"-gren2", "101",NULL); 
		pBot->tossNade = 1;
		rtnValue = 1;
		pBot->nadePrimed = false;
	}
	return rtnValue;
}

// Assess the threat level of the target using their class & my class.
// 0-100 scale higher is more dangerous
// returns -1 if error or no target.
int BotAssessThreatLevel( bot_t *pBot )
{
	// BotAssessThreatLevel - This function evaluates the threat level of a target based on the following.
	// 1) This bots class
	// 2) The enemy bots class
	// 3) Distance to the target (modifier by class, since some are deadlier at different distances than others)
	// 4) This bots health.
	// Returns a 0 - 100 integer that is the result of the threat assesment. 
	// Code can compare against certain values ( threat > 50.. ) to trigger various events.
	// This forms the backbone of pre-emptive grenade tossing. No more completely random or when he is low health.

	// Error checking. Do we even have an enemy?
	if(!pBot->pBotEnemy) 
		return -1;

	edict_t *pEdict = pBot->pEdict;

	// Distance to target from me?
	float distanceToTarget = (pBot->pBotEnemy->v.origin - pEdict->v.origin).Length();

	// This will keep track of the threat level.
	int Threat = 0;

	// Set base threat from MY class
	switch(pEdict->v.playerclass)
	{
	case TFC_CLASS_CIVILIAN:
		Threat = 20;
		break;
	case TFC_CLASS_SCOUT:
		Threat = 20;
		break;
	case TFC_CLASS_SOLDIER:
		Threat = 8;
		break;
	case TFC_CLASS_DEMOMAN:
		Threat = 12;
		break;
	case TFC_CLASS_MEDIC:
		Threat = 12;
		break;
	case TFC_CLASS_HWGUY:
		Threat = 0;
		break;
	case TFC_CLASS_PYRO:
		Threat = 15;
		break;
	case TFC_CLASS_SPY:
		Threat = 15;
		break;
	case TFC_CLASS_ENGINEER:
		Threat = 17;
		break;
	}

	// Then add based on targets class.
	switch(pBot->pBotEnemy->v.playerclass)
	{
	case TFC_CLASS_CIVILIAN:
		Threat += 0;
		break;
	case TFC_CLASS_SCOUT:
		Threat += 5;
		break;
	case TFC_CLASS_SOLDIER:
		Threat += 15;
		if (distanceToTarget < 400) Threat+=15;
		break;
	case TFC_CLASS_DEMOMAN:
		Threat += 13;
		if (distanceToTarget < 400) Threat+=10;
		break;
	case TFC_CLASS_MEDIC:
		Threat += 10;
		if (distanceToTarget < 50) Threat+=15;
		break;
	case TFC_CLASS_HWGUY:
		Threat += 15;
		if (distanceToTarget < 400) Threat+=35;
		break;
	case TFC_CLASS_PYRO:
		Threat += 10;
		if (distanceToTarget < 100) Threat+=10;
		break;
	case TFC_CLASS_SPY:
		Threat += 15;
		if (distanceToTarget < 50) Threat+=35;
		break;
	case TFC_CLASS_ENGINEER:
		Threat += 15;
		if (distanceToTarget < 300) Threat+=10;
		break;
	}
	// The less our health, the higher threat the enemy is.
	Threat += (100 - BotHealthValue(pEdict));
	return (Threat <= 100) ? Threat : 100;	
}

int BotTeamColorCheck(edict_t *pent)
{
	// BotTeamColorCheck -  Use this for getting sentry teams. Checks team based on the colormap.
	if (pent->v.colormap == 0xA096)
		return 0;  // blue team's sentry
	if (pent->v.colormap == 0x04FA)
		return 1;  // red team's sentry
	if (pent->v.colormap == 0x372D)
		return 2;  // yellow team's sentry
	if (pent->v.colormap == 0x6E64)
		return 3;  // green team's sentry
	// None of these?
	return -1;
}

int BotLeadTarget( edict_t *pBotEnemy, bot_t *pBot , int projSpeed, int &d_x, int &d_y, int &d_z)
{
	// BotLeadTarget - I moved the leading into a function, so that I could use it for grenades as well without 
	// duplicating code. This leads a target based on a passed projectile speed.

	float f_distance = (pBotEnemy->v.origin - pBot->pEdict->v.origin).Length();
	// Lets try some error in the projectile prediction based on skill level
	f_distance += RANDOM_LONG(-pBot->bot_skill, pBot->bot_skill) * 5;

	if(f_distance > 1000)
		f_distance = 1000;

	d_x += (pBot->pBotEnemy->v.velocity.x * (f_distance/projSpeed));
	d_y += (pBot->pBotEnemy->v.velocity.y * (f_distance/projSpeed));

	if(pBot->pBotEnemy->v.velocity.z < -30) //falling
		d_z += (pBot->pBotEnemy->v.velocity.z * (f_distance/2000));
	else
		d_z += (pBot->pBotEnemy->v.velocity.z * (f_distance/1000));

	return (pBot->pBotEnemy->v.origin.z - pBot->pEdict->v.origin.z);	
}

inline bool BotOutOfNades(bot_t *pBot)
{
	// BotOutOfNades - Are we out of grenades?
	return ((pBot->grenades[0] == 0) && (pBot->grenades[1] == 0));
}

void BotCheckForMultiguns(bot_t *pBot, float nearestdistance, edict_t *pNewEnemy, bool &rtn)
{
	// BotCheckForMultiguns - Loops through all the multigun types looking for the closest type of sentry.
	// This 40ish lines of code replaces 500 used previously. Also, adding new mg types to check for
	// is as simple as adding another string to the ntfTargetChecks array.

	// Skip this shit if neotf isnt present
	char *cvar_ntf = (char *)CVAR_GET_STRING( "neotf" );
	if(strcmp(cvar_ntf,"1")) // No neotf
		return;

	Vector vecEnd;
	// Loop through all the multigun types, checking for a closer target and storing it in nearestdistance, and pNewEnemy
	for(int i = 0; i < NumNTFGuns; i++)
	{
		edict_t *pent = NULL;
		while ((pent = FIND_ENTITY_BY_CLASSNAME( pent, ntfTargetChecks[i] )) != NULL && (!FNullEnt(pent)))
		{
			int sentry_team = pent->v.team-1;
			int bot_team = UTIL_GetTeam(pBot->pEdict);
			if ((pent->v.flags & FL_KILLME)==FL_KILLME)
				continue;
			// don't target your own team's sentry guns...
			if (bot_team == sentry_team)
				continue;
			// don't target your allie's sentry guns either...
			if (team_allies[bot_team] & (1<<sentry_team))
				continue;
			vecEnd = pent->v.origin + pent->v.view_ofs;
			// is this sentry gun visible?
			if (FInViewCone( &vecEnd, pBot->pEdict ) && FVisible( vecEnd, pBot->pEdict ))
			{
				float distance = (pent->v.origin - pBot->pEdict->v.origin).Length();
				// is this the closest sentry gun?
				if (distance < nearestdistance)
				{
					nearestdistance = distance;
					pNewEnemy = pent;					
					pBot->pBotUser = NULL;  // don't follow user when enemy found
					BotNadeHandler(pBot, false, bot_t::Stationary);
					rtn=false;
					BotSGSpotted(pBot, pent);
				}
			}
		}
	}
}

bool BotIsInfected(edict_t *pEntity)  
{  
	edict_t *pent = NULL;  
	while ((pent = FIND_ENTITY_BY_CLASSNAME( pent, "timer" )) != NULL && (!FNullEnt(pent))) 
	{ 
		//UTIL_SavePent(pent);
		if((pent->v.owner == pEntity) && pent->v.enemy)  
		{  			
			if ((pent->v.enemy->v.playerclass == TFC_CLASS_MEDIC))
				return true;
		} 
	}
	return FALSE;  
}


