//
// FoXBot - AI Bot for Halflife's Team Fortress Classic
//
// (http://foxbot.net)
//
// bot.h
//
// Copyright (C) 2003 - Tom "Redfox" Simpson
//
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
//
// See the GNU General Public License for more details at:
// http://www.gnu.org/copyleft/gpl.html
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

#ifndef BOT_H
#define BOT_H

#include "osdep.h"

// stuff for Win32 vs. Linux builds

#ifndef __linux__

typedef int (FAR *GETENTITYAPI)(DLL_FUNCTIONS *, int);
typedef int (FAR *GETNEWDLLFUNCTIONS)(NEW_DLL_FUNCTIONS *, int *);
typedef void (DLLEXPORT *GIVEFNPTRSTODLL)(enginefuncs_t *, globalvars_t *);
typedef void (FAR *LINK_ENTITY_FUNC)(entvars_t *);

#else

#include <dlfcn.h>
#define GetProcAddress dlsym

typedef int BOOL;

typedef int (*GETENTITYAPI)(DLL_FUNCTIONS *, int);
typedef int (*GETNEWDLLFUNCTIONS)(NEW_DLL_FUNCTIONS *, int *);
typedef void (*GIVEFNPTRSTODLL)(enginefuncs_t *, globalvars_t *);
typedef void (*LINK_ENTITY_FUNC)(entvars_t *);

#endif

// define constants used to identify the MOD we are playing...

#define VALVE_DLL      1
#define TFC_DLL        2
#define CSTRIKE_DLL    3
#define GEARBOX_DLL    4
#define FRONTLINE_DLL  5


// define some function prototypes...
BOOL ClientConnect( edict_t *pEntity, const char *pszName,
				   const char *pszAddress, char szRejectReason[ 128 ] );
void ClientPutInServer( edict_t *pEntity );
void ClientCommand( edict_t *pEntity );
void ClientKill( edict_t *pEntity );

void FakeClientCommand(edict_t *pBot, char *arg1, char *arg2, char *arg3);
//void FakeClientCommand (edict_t *pFakeClient, const char *fmt, ...);


const char *Cmd_Args( void );
const char *Cmd_Argv( int argc );
int Cmd_Argc( void );


#define LADDER_UNKNOWN  0
#define LADDER_UP       1
#define LADDER_DOWN     2

#define WANDER_LEFT  1
#define WANDER_RIGHT 2

#define BOT_PITCH_SPEED 20
#define BOT_YAW_SPEED 20

#define RESPAWN_IDLE             1
#define RESPAWN_NEED_TO_RESPAWN  2
#define RESPAWN_IS_RESPAWNING    3

// game start messages for TFC...
#define MSG_TFC_IDLE          1
#define MSG_TFC_TEAM_SELECT   2
#define MSG_TFC_CLASS_SELECT  3

// game start messages for CS...
#define MSG_CS_IDLE         1
#define MSG_CS_TEAM_SELECT  2
#define MSG_CS_CT_SELECT    3
#define MSG_CS_T_SELECT     4

// game start messages for OpFor...
#define MSG_OPFOR_IDLE          1
#define MSG_OPFOR_TEAM_SELECT   2
#define MSG_OPFOR_CLASS_SELECT  3

// game start messages for FrontLineForce...
#define MSG_FLF_IDLE            1
#define MSG_FLF_TEAM_SELECT     2
#define MSG_FLF_CLASS_SELECT    3
#define MSG_FLF_PISTOL_SELECT   4
#define MSG_FLF_WEAPON_SELECT   5
#define MSG_FLF_RIFLE_SELECT    6
#define MSG_FLF_SHOTGUN_SELECT  7
#define MSG_FLF_SUBMACHINE_SELECT   8
#define MSG_FLF_HEAVYWEAPONS_SELECT 9


#define TFC_CLASS_CIVILIAN  11
#define TFC_CLASS_SCOUT     1
#define TFC_CLASS_SNIPER    2
#define TFC_CLASS_SOLDIER   3
#define TFC_CLASS_DEMOMAN   4
#define TFC_CLASS_MEDIC     5
#define TFC_CLASS_HWGUY     6
#define TFC_CLASS_PYRO      7
#define TFC_CLASS_SPY       8
#define TFC_CLASS_ENGINEER  9


#define BOT_SKIN_LEN 32
#define BOT_NAME_LEN 32

#define MAX_BOT_WHINE 100

//my message script intercept stuff
#define MSG_MAX 64

struct msg_com_struct
{
	char ifs[32];
	int blue_av[8];
	int red_av[8];
	int green_av[8];
	int yellow_av[8];
	struct msg_com_struct *next;
};

typedef struct
{
	int  iId;     // weapon ID
	int  iClip;   // amount of ammo in the clip
	int  iAmmo1;  // amount of ammo in primary reserve
	int  iAmmo2;  // amount of ammo in secondary reserve
} bot_current_weapon_t;

struct teleport_info_t {
	int iEntranceWaypointIndex;
	int iExitWaypointIndex;
	int iFinalGoal;
	edict_t *pEntrance;
	edict_t *pExit;
	edict_t *pOwner;
	bool bIsUsed;
};

typedef struct
{
	bool is_used;
	int respawn_state;
	edict_t *pEdict;
	bool need_to_initialize;
	char name[BOT_NAME_LEN+1];
	char skin[BOT_SKIN_LEN+1];
	int bot_skill;
	int not_started;
	int start_action;
	float kick_time;
	float create_time;

	// TheFatal - START
	int msecnum;
	float msecdel;
	float msecval;
	// TheFatal - END

	// things from pev in CBasePlayer...
	int bot_team;
	int bot_class;
	int bot_health;
	int bot_armor;
	int bot_weapons;      // bit map of weapons the bot is carrying
	int bot_money;        // for Counter-Strike
	int primary_weapon;   // for Front Line Force
	int secondary_weapon; // for Front Line Force
	int defender;         // for Front Line Force
	int warmup;           // for Front Line Force
	float idle_angle;
	float idle_angle_time;  // for Front Line Force
	int round_end;        // round has ended (in round based games)
	float blinded_time;

	float f_max_speed;
	float prev_speed;
	float prev_time;
	Vector v_prev_origin;

	float f_find_item;
	edict_t *pBotPickupItem;

	int ladder_dir;
	float f_start_use_ladder_time;
	float f_end_use_ladder_time;
	bool  waypoint_top_of_ladder;

	float f_wall_check_time;
	float f_wall_on_right;
	float f_wall_on_left;
	float f_dont_avoid_wall_time;
	float f_look_for_waypoint_time;
	float f_jump_time;
	float f_dont_check_stuck;

	int wander_dir;
	float f_exit_water_time;

	Vector waypoint_origin;
	float f_waypoint_time;
	int curr_waypoint_index;
	int prev_waypoint_index[5];
	float f_random_waypoint_time;
	int waypoint_goal;
	float f_waypoint_goal_time;
	bool waypoint_near_flag;
	Vector waypoint_flag_origin;
	float prev_waypoint_distance;

	edict_t *pBotEnemy;
	float f_bot_see_enemy_time;
	float f_bot_find_enemy_time;
	edict_t *pBotUser;
	float f_bot_use_time;
	float f_bot_spawn_time;
	edict_t *killer_edict;
	bool  b_bot_say_killed;
	float f_bot_say_killed;
	float f_sniper_aim_time;


	float f_shoot_time;
	float f_primary_charging;
	float f_secondary_charging;
	int   charging_weapon_id;
	float f_move_speed;
	//my vars
	float f_side_speed;
	int f_strafe;
	bool f_side_direction;
	char message[255];
	char msgstart[255];
	bool newmsg;
	bool follow;
	int goto_wp;
	int lastgoto_wp;
	bool lowammo;
	int lastenemypos;
	int f_disguise_state;
	float f_disguise_time;
	bool f_take_damage;
	bool sg;
	bool sg_building;
	int sg_wp;
	int sg_ammo;
	bool dispensor;
	edict_t *dispensor_edict;
	int detpack;
	edict_t *sg_edict;
	float f_build_time;
	float f_sg_find_time;
	float f_tp_find_time;
	edict_t *lastenemy;
	char lastmessage[255];
	float f_duck_time;
	bool backwards;
	float backwards_time;
	bool greeting;
	edict_t *killed_edict;
	bool concuss;
	float concuss_time;
	bool ras; //run and shoot
	Vector lastliftvector;
	int inact;
	Vector inact_veca;
	Vector inact_vecb;
	float last_distance;
	int last_wp[5];
	int next_junc;
	float f_flag_check_time;
	float f_enemy_check_time;
	float f_item_check_time;
	float f_wpt_check_time;

	int curr_area;
	//now multipath stuff..
	//unsigned short int multi_path_dist[1024*1024]; //will take 1meg
	unsigned int rating[1024]; //will take 1k
	int last_start;
	int last_dest;
	int bot_start2;
	float bot_start3;
	bool clearenemy;
	int flag_impulse;
	edict_t *track_player;
	float track_time;
	float track_ttime;

	float kill_time;
	float f_snipe_time;
	bool spawn_goal_check;
	// last SG
	edict_t *pBotLastSgEnemy;
	//end my vars
	float f_pause_time;
	float f_sound_update_time;
	bool  bot_has_flag;

	bool  b_see_tripmine;
	bool  b_shoot_tripmine;
	Vector v_tripmine;

	bool  b_use_health_station;
	float f_use_health_time;
	bool  b_use_HEV_station;
	float f_use_HEV_time;

	bool  b_use_button;
	float f_use_button_time;
	bool  b_lift_moving;

	bool  b_use_capture;
	float f_use_capture_time;
	edict_t *pCaptureEdict;

	bot_current_weapon_t current_weapon;  // one current weapon for each bot
	int m_rgAmmo[MAX_AMMO_SLOTS];  // total ammo amounts (1 array for each bot)

	/////////////////
	// DrEvil vars //
	/////////////////
	bool nadePrimed;
	bool lockMission;
	char nadeType;
	float last_spawn_time;
	float primeTime;
	float detTime;
	float lastDistance;
	float lastDistanceCheck;
	float discard_time;
	float RJTime;

	char grenades[2];
	int tossNade;
	int defendPoint;
	int snipePoint;
	int pipePoint;
	bool defending;
	bool piping;
	bool piped;
	bool detting;
	float pipeTime;
	int lastFrameHealth;
	bool hasTPEntrance, hasTPExit;
	bool buildingTPEntrance, buildingTPExit;
	edict_t *tpEntrance, *tpExit;
	int tpEntranceWP, tpExitWP;
	teleport_info_t teleportInfo;

	// RJ vars
	int RJwp;
	int lastWPIndexChecked;
	float RJ_checkTime;
	float RJHeadingTime;
	float RJClosingDistance;
	float ConcCruise;
	float FreezeDelay;
	float defenseSayDelay;
	bool RJDelaying;	
	bool RocketJumping;
	bool ConcJumping;
	bool SGRotated;
	char mission;
	char goalType;
	Vector ConcAngle;
	
	enum nadeTypes { Concussion = 1, Grenade, MIRV, EMP, Flash, Nail, Flame, Gas, Caltrop, Damage, Distract, Stationary, Spam, Flee, Random};
	enum GoalType { None, Attacker, Defender, Patrol, Health, Armor, Ammo, Flag, CapPoint, Spammer, Builder, Sniper, Detpack };
	enum nadeSlots { Primary = 0, Secondary = 1, };
	enum Misc { MAXRJWAYPOINTS = 20, };
	
	/////////////////////
	// end DrEvil vars //
	/////////////////////
} bot_t;

#define MAX_TEAMS 32
#define MAX_TEAMNAME_LENGTH 16


#define MAX_FLAGS  5

typedef struct {
	bool mdl_match;
	int  team_no;
	edict_t *edict;
} FLAG_S;

// new UTIL.CPP functions...
/*edict_t *UTIL_FindEntityInSphere( edict_t *pentStart, const Vector &vecCenter, float flRadius );
edict_t *UTIL_FindEntityByString( edict_t *pentStart, const char *szKeyword, const char *szValue );
edict_t *UTIL_FindEntityByClassname( edict_t *pentStart, const char *szName );
edict_t *UTIL_FindEntityByTargetname( edict_t *pentStart, const char *szName );
*/
void HUDNotify(edict_t *pEntity, const char *msg_name);

void ClientPrint( edict_t *pEdict, int msg_dest, const char *msg_name);
void UTIL_SayText( const char *pText, edict_t *pEdict );
void UTIL_HostSay( edict_t *pEntity, int teamonly, char *message );
int UTIL_GetTeamColor(edict_t *pEntity);
int UTIL_GetTeam(edict_t *pEntity);
int UTIL_GetClass(edict_t *pEntity);
int UTIL_GetBotIndex(edict_t *pEdict);
bot_t *UTIL_GetBotPointer(edict_t *pEdict);
bool IsAlive(edict_t *pEdict);
bool FInViewCone(Vector *pOrigin, edict_t *pEdict);
bool FVisible( const Vector &vecOrigin, edict_t *pEdict );
Vector Center(edict_t *pEdict);
Vector GetGunPosition(edict_t *pEdict);
void UTIL_SelectItem(edict_t *pEdict, char *item_name);
Vector VecBModelOrigin(edict_t *pEdict);
bool UpdateSounds(edict_t *pEdict, edict_t *pPlayer);
void UTIL_ShowMenu( edict_t *pEdict, int slots, int displaytime, bool needmore, char *pText );
void UTIL_BuildFileName(char *filename, char *arg1, char *arg2);
void UTIL_BuildFileNameOld(char *filename, char *arg1, char *arg2);

//my functions
void script(const char* sz);
int BotArmorValue(edict_t *pEdict);
int BotHealthValue(edict_t *pEdict);
void UTIL_SavePent(edict_t *pent);
void GetEntvarsKeyvalue( entvars_t *pev, KeyValueData *pkvd );
void BotSprayLogo(edict_t *pEntity);
edict_t *BotSGAtPoint(const Vector &location, const float range);
edict_t *BotTeleporterAtPoint(const Vector &location, const float range);
bot_t *BotDefenderAtPoint(const bot_t *pBot, const Vector &location, const float range);
void BotEngineerThink(bot_t *pBot);
void BotRoleCheck(bot_t *pBot);


#endif // BOT_H

