//
// FoXBot - AI Bot for Halflife's Team Fortress Classic
//
// (http://foxbot.net)
//
// bot.cpp
//
// Copyright (C) 2003 - Tom "Redfox" Simpson
//
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
//
// See the GNU General Public License for more details at:
// http://www.gnu.org/copyleft/gpl.html
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//


#include "extdll.h"
//#include "util.h"
#include "bot.h"
#include <meta_api.h>
#include "cbase.h"
#include "tf_defs.h"

#include "list.h"

#include "bot_func.h"
#include "waypoint.h"
#include "bot_weapons.h"

#include "math.h"
#include "engine.h" //originally commented 

#include <sys/types.h>
#include <sys/stat.h>

//#include "list.h"
extern List<char *> commanders;

#ifndef __linux__
extern HINSTANCE h_Library;
#else
extern void *h_Library;
#endif

extern int mod_id;
extern WAYPOINT waypoints[MAX_WAYPOINTS];
extern int num_waypoints;  // number of waypoints currently in use
extern int default_bot_skill;
extern edict_t *pent_info_ctfdetect;

extern int max_team_players[4];
extern int team_class_limits[4];
extern int max_teams;
extern char bot_whine[MAX_BOT_WHINE][81];
extern int whine_count;

extern char bot_greet[MAX_BOT_WHINE][81];
extern int greet_count;
extern char bot_kill_hi[MAX_BOT_WHINE][81];
extern int kill_hi_count;
extern char bot_kill_lo[MAX_BOT_WHINE][81];
extern int kill_lo_count;
extern char bot_die_hi[MAX_BOT_WHINE][81];
extern int die_hi_count;
extern char bot_die_lo[MAX_BOT_WHINE][81];
extern int die_lo_count;

extern bot_weapon_t weapon_defs[MAX_WEAPONS];

extern int team_allies[4];
extern int MatchScores[4];

extern int flf_bug_fix;

extern int a;

extern int CheckTeleporterExitTime;

extern int RoleStatus[];

static FILE *fp;

int pipeCheckFrame = 15;
extern int debug_engine;

extern bool spawn_check_crash;
extern int spawn_check_crash_count;
extern edict_t *spawn_check_crash_edict;
//silly stuff
bool bot_xmas=false;
//updates by yuraj
bool bot_can_use_teleporter=true;
bool bot_can_build_teleporter=true;
int bot_spy_random_check=250;

extern int min_bots;
extern int max_bots;
//my global var for checking if were using metamod or not?
//i.e. should we be a plugin..
bool mr_meta=false;

extern edict_t *clients[32];

bool g_bot_debug = FALSE;

// cvar stuff
bool defensive_chatter = true;
bool offensive_chatter = true;
bool frag_commander = false;

//area defs...
extern AREA areas[MAX_WAYPOINTS];
extern int num_areas;

//32 wpt slots for places to look for dropped flags :)
int drop_flag[32][4];
edict_t *drop_flage[32][4];

bool attack[4]; //teams attack
bool defend[4]; //teams defend

//working arrays.. these are what are referenced by the bots
//i.e. hold the current available state of points 1..8 for each team
bool blue_av[8];
bool red_av[8];
bool green_av[8];
bool yellow_av[8];

// Rocket jump globals
extern int RJPoints[bot_t::MAXRJWAYPOINTS][2];
float roleCheckTimer = 10;

struct msg_com_struct msg_com[MSG_MAX]; // pre defined msg type.. 64 empty msg command list

char msg_msg[64][MSG_MAX]; // and 64 empty msg's, to be filled with messages to intercept

#define PLAYER_SEARCH_RADIUS     50.0
#define FLF_PLAYER_SEARCH_RADIUS 60.0

#define GETPLAYERAUTHID	(*g_engfuncs.pfnGetPlayerAuthId)

double pi = 3.1415926535897932384626433832795;

bot_t bots[32];   // max of 32 bots in a game
int b_team[32];
int b_class[32];
bool b_observer_mode = FALSE;
bool b_botdontshoot = FALSE;
bool b_botchat = TRUE;

extern int recent_bot_whine[5];
extern int recent_bot_kill_hi[5];
extern int recent_bot_kill_lo[5];
extern int recent_bot_die_hi[5];
extern int recent_bot_die_lo[5];

int number_names = 0;

#define MAX_BOT_NAMES 128

#define VALVE_MAX_SKINS    10
#define GEARBOX_MAX_SKINS  20

// indicate which models are currently used for random model allocation
bool valve_skin_used[VALVE_MAX_SKINS] = {
FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE};

bool gearbox_skin_used[GEARBOX_MAX_SKINS] = {
FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE};

// store the names of the models...
char *valve_bot_skins[VALVE_MAX_SKINS] = {
"barney", "gina", "gman", "gordon", "helmet",
"hgrunt", "recon", "robo", "scientist", "zombie"};

char *gearbox_bot_skins[GEARBOX_MAX_SKINS] = {
"barney", "beret", "cl_suit", "drill", "fassn", "gina", "gman",
"gordon", "grunt", "helmet", "hgrunt", "massn", "otis", "recon",
"recruit", "robo", "scientist", "shepard", "tower", "zombie"};

// store the player names for each of the models...
char *valve_bot_names[VALVE_MAX_SKINS] = {
"Barney", "Gina", "G-Man", "Gordon", "Helmet",
"H-Grunt", "Recon", "Robo", "Scientist", "Zombie"};

char *gearbox_bot_names[GEARBOX_MAX_SKINS] = {
"Barney", "Beret", "Cl_suit", "Drill", "Fassn", "Gina", "G-Man",
"Gordon", "Grunt", "Helmet", "H-Grunt", "Massn", "Otis", "Recon",
"Recruit", "Robo", "Scientist", "Shepard", "Tower", "Zombie"};

struct TeamLayout {
	List<bot_t * > attackers[4];
	List<bot_t * > defenders[4];
	List<edict_t * > humanAttackers[4];
	List<edict_t * > humanDefenders[4];
	int total[4];
};

char bot_names[MAX_BOT_NAMES][BOT_NAME_LEN+1];

// how often (out of 1000 times) the bot will pause, based on bot skill
float pause_frequency[5] = {3, 6, 9, 13, 18};

float pause_time[5][2] = {{0.0, 0.0}, {0.0, 0.4}, {0.3, 1.1}, {1.0, 1.5}, {1.2, 2.0}};

float defendMaxRespondDist[] = { 300, 1500, 500, 1500, 800, 1500, 1500, 1500, 1500, 1500 };

inline edict_t *CREATE_FAKE_CLIENT( const char *netname )
{
	if (debug_engine) { fp=fopen("bot.txt", "a"); fprintf(fp, "createfakeclient: %s\n",netname); fclose(fp); }
	return (*g_engfuncs.pfnCreateFakeClient)( netname );
}

inline char *GET_INFOBUFFER( edict_t *e )
{
	if (debug_engine) { fp=fopen("bot.txt", "a"); fprintf(fp, "getinfobuffer: %x\n",e); fclose(fp); }
	return (*g_engfuncs.pfnGetInfoKeyBuffer)( e );	
}

inline char *GET_INFO_KEY_VALUE( char *infobuffer, char *key )
{
	if (debug_engine) { fp=fopen("bot.txt", "a"); fprintf(fp, "getinfokeyvalue: %s %s\n",infobuffer,key); fclose(fp); }
	return (*g_engfuncs.pfnInfoKeyValue)( infobuffer, key );
}

inline void SET_CLIENT_KEY_VALUE( int clientIndex, char *infobuffer,
            char *key, char *value )
{
	if (debug_engine) { fp=fopen("bot.txt","a"); fprintf(fp,"pfnSetClientKeyValue: %s %s\n",key,value); fclose(fp); }
	(*g_engfuncs.pfnSetClientKeyValue)( clientIndex, infobuffer, key, value );
}


// this is the LINK_ENTITY_TO_CLASS function that creates a player (bot)
void player( entvars_t *pev )
{
	static LINK_ENTITY_FUNC otherClassName = NULL;
	if (otherClassName == NULL)
	{
		otherClassName = (LINK_ENTITY_FUNC)GetProcAddress(h_Library, "player");
	}
	if (otherClassName != NULL)
	{
		(*otherClassName)(pev);
	}
}


void BotSpawnInit( bot_t *pBot )
{
	pBot->v_prev_origin = Vector(9999.0, 9999.0, 9999.0);
	pBot->prev_time = gpGlobals->time;

	pBot->waypoint_origin = Vector(0, 0, 0);
	pBot->f_waypoint_time = 0.0;
	pBot->curr_waypoint_index = -1;
	pBot->prev_waypoint_index[0] = -1;
	pBot->prev_waypoint_index[1] = -1;
	pBot->prev_waypoint_index[2] = -1;
	pBot->prev_waypoint_index[3] = -1;
	pBot->prev_waypoint_index[4] = -1;

	pBot->f_random_waypoint_time = gpGlobals->time;
	pBot->waypoint_goal = -1;
	pBot->f_waypoint_goal_time = 0.0;
	pBot->waypoint_near_flag = FALSE;
	pBot->waypoint_flag_origin = Vector(0, 0, 0);
	pBot->prev_waypoint_distance = 0.0;

	pBot->msecnum = 0;
	pBot->msecdel = 0.0;
	pBot->msecval = 0.0;

	pBot->bot_health = 0;
	pBot->bot_armor = 0;
	pBot->bot_weapons = 0;
	pBot->blinded_time = 0.0;

	pBot->f_max_speed = CVAR_GET_FLOAT("sv_maxspeed");

	pBot->prev_speed = 0.0;  // fake "paused" since bot is NOT stuck

	pBot->f_find_item = 0.0;

	pBot->ladder_dir = LADDER_UNKNOWN;
	pBot->f_start_use_ladder_time = 0.0;
	pBot->f_end_use_ladder_time = 0.0;
	pBot->waypoint_top_of_ladder = FALSE;

	pBot->f_wall_check_time = 0.0;
	pBot->f_wall_on_right = 0.0;
	pBot->f_wall_on_left = 0.0;
	pBot->f_dont_avoid_wall_time = 0.0;
	pBot->f_look_for_waypoint_time = 0.0;
	pBot->f_jump_time = 0.0;
	pBot->f_dont_check_stuck = 0.0;

	// pick a wander direction (50% of the time to the left, 50% to the right)
	if (RANDOM_LONG(1, 100) <= 50)
		pBot->wander_dir = WANDER_LEFT;
	else
		pBot->wander_dir = WANDER_RIGHT;

	pBot->f_exit_water_time = 0.0;

	pBot->pBotEnemy = NULL;
	pBot->f_bot_see_enemy_time = gpGlobals->time;
	pBot->f_bot_find_enemy_time = gpGlobals->time;
	pBot->pBotUser = NULL;
	pBot->f_bot_use_time = 0.0;
	pBot->b_bot_say_killed = FALSE;
	pBot->f_bot_say_killed = 0.0;
	pBot->f_sniper_aim_time = 0.0;

	pBot->f_shoot_time = gpGlobals->time;
	pBot->f_primary_charging = -1.0;
	pBot->f_secondary_charging = -1.0;
	pBot->charging_weapon_id = 0;

	pBot->f_pause_time = 0.0;
	pBot->f_sound_update_time = 0.0;

	pBot->bot_has_flag = FALSE;

	pBot->b_see_tripmine = FALSE;
	pBot->b_shoot_tripmine = FALSE;
	pBot->v_tripmine = Vector(0,0,0);

	pBot->b_use_health_station = FALSE;
	pBot->f_use_health_time = 0.0;
	pBot->b_use_HEV_station = FALSE;
	pBot->f_use_HEV_time = 0.0;

	pBot->b_use_button = FALSE;
	pBot->f_use_button_time = 0;
	pBot->b_lift_moving = FALSE;

	pBot->b_use_capture = FALSE;
	pBot->f_use_capture_time = 0.0;
	pBot->pCaptureEdict = NULL;

	//mine
	pBot->goto_wp=-1;
	pBot->lastgoto_wp=-1;
	pBot->follow=false;
	pBot->ras=false;
	pBot->inact=0;
	pBot->last_distance=999999;
	pBot->last_wp[0]=-1;
	pBot->last_wp[1]=-1;
	pBot->last_wp[2]=-1;
	pBot->last_wp[3]=-1;
	pBot->last_wp[4]=-1;
	//pBot->last_wp[5]=-1; //memory leak!
	pBot->next_junc=-1;
	pBot->last_start=-1;
	pBot->last_dest=-1;
	pBot->f_flag_check_time = gpGlobals->time;
	pBot->f_enemy_check_time = gpGlobals->time;
	pBot->f_item_check_time = gpGlobals->time;
	pBot->f_wpt_check_time = gpGlobals->time;
	pBot->f_build_time =gpGlobals->time;
	//pBot->sg=false;
	pBot->concuss_time = gpGlobals->time;
	pBot->concuss=FALSE;
	pBot->clearenemy=false;
	pBot->curr_area=-1;
	pBot->flag_impulse=-1;
	pBot->track_player=NULL;
	pBot->spawn_goal_check=false;
	//v1.1.0.8 on xp..(or possibly fast machines)
	//had the bot crash if it tried to respawn too soon!
	//so put a pause in to stop it pressing 'fire' to soon...
	//this should fix it!!
	pBot->kill_time=gpGlobals->time;
	//but it appears to be a bug in valves code, even without bots..
	//so not actually needed

	pBot->f_snipe_time=gpGlobals->time;
	pBot->f_sg_find_time=gpGlobals->time;
	pBot->f_disguise_time=gpGlobals->time;
	pBot->f_disguise_state=0;
	pBot->lowammo=false;

	/////////////////
	// DrEvil vars //
	/////////////////

	pBot->RJDelaying = pBot->RocketJumping = pBot->ConcJumping = pBot->nadePrimed = false;
	pBot->nadeType = NULL;
	pBot->ConcCruise = pBot->primeTime = pBot->lastDistance = pBot->lastDistanceCheck = pBot->FreezeDelay = pBot->detTime = 0.0f;   
	pBot->last_spawn_time = gpGlobals->time;
	pBot->RJ_checkTime = gpGlobals->time + 2;    
	pBot->RJwp = NULL;

	pBot->defenseSayDelay = gpGlobals->time + 10;
	pBot->defending = false;
	pBot->discard_time = gpGlobals->time + 10.0f;
	pBot->pipeTime = gpGlobals->time + 9999;
	pBot->pipePoint = -1;
	pBot->piped = false;
	pBot->piping = false;
	pBot->detting = false;	
	memset(&(pBot->teleportInfo.bIsUsed), 0, sizeof(pBot->teleportInfo.bIsUsed));
	// Send spies after enemy SG's
	if (pBot->pEdict->v.playerclass == TFC_CLASS_SPY && pBot->pBotLastSgEnemy)
	{
		pBot->goto_wp = WaypointFindNearest(pBot->pBotLastSgEnemy, 250, UTIL_GetTeam(pBot->pEdict));
		pBot->mission = pBot->Attacker;
		pBot->goalType = pBot->Spammer;
	}
	// A chance to send soldiers after enemy sg's too
	if (pBot->pEdict->v.playerclass == TFC_CLASS_SOLDIER && (pBot->mission == pBot->Attacker) && (RANDOM_LONG(0,100) > 40) && pBot->pBotLastSgEnemy)
	{
		pBot->goto_wp = WaypointFindNearest(pBot->pBotLastSgEnemy, 250, UTIL_GetTeam(pBot->pEdict));		
		pBot->goalType = pBot->Spammer;
	}	

	// Send defenders back to their point
	if (pBot->defendPoint != -1) pBot->goto_wp = pBot->defendPoint;

	// Clear defend point if we change roles.
	if (pBot->mission == pBot->Attacker)
		pBot->defender = -1;
	
	/////////////////////
	// end DrEvil vars //
	/////////////////////

	memset(&(pBot->current_weapon), 0, sizeof(pBot->current_weapon));
	memset(&(pBot->m_rgAmmo), 0, sizeof(pBot->m_rgAmmo));
}


void BotNameInit( void )
{
	FILE *bot_name_fp;
	char bot_name_filename[256];
	int str_index;
	char name_buffer[80];
	int length, index;

	UTIL_BuildFileName(bot_name_filename, "foxbot_names.txt", NULL);
	bot_name_fp = fopen(bot_name_filename, "r");

	if (bot_name_fp == NULL)
	{
		UTIL_BuildFileNameOld(bot_name_filename, "foxbot_names.txt", NULL);
		bot_name_fp = fopen(bot_name_filename, "r");
	}

	if (bot_name_fp != NULL)
	{
		while ((number_names < MAX_BOT_NAMES) &&
			(fgets(name_buffer, 80, bot_name_fp) != NULL))
		{
			length = strlen(name_buffer);

			if (name_buffer[length-1] == '\n')
			{
				name_buffer[length-1] = NULL;  // remove '\n'
				length--;
			}

			str_index = 0;
			while (str_index < length)
			{
				if ((name_buffer[str_index] < ' ') || (name_buffer[str_index] > '~') ||
					(name_buffer[str_index] == '"'))
					for (index=str_index; index < length; index++)
						name_buffer[index] = name_buffer[index+1];

				str_index++;
			}

			if (name_buffer[0] != 0)
			{
				strncpy(bot_names[number_names], name_buffer, BOT_NAME_LEN);

				number_names++;
			}
		}

		fclose(bot_name_fp);
	}
}


void BotPickName( char *name_buffer )
{
	int name_index, index;
	bool used;
	edict_t *pPlayer;
	int attempts = 0;

	// see if a name exists from a kicked bot (if so, reuse it)
	for (index=0; index < 32; index++)
	{
		if ((bots[index].is_used == FALSE) && (bots[index].name[0]!=NULL))
		{
			strcpy(name_buffer, bots[index].name);

			return;
		}   
	}

	name_index = RANDOM_LONG(1, number_names) - 1;  // zero based
	//name_index=0;

	// check make sure this name isn't used
	used = TRUE;

	while (used)
	{
		used = FALSE;

		for (index = 1; index <= gpGlobals->maxClients; index++)
		{
			pPlayer = INDEXENT(index);

			if (pPlayer && !pPlayer->free)
			{
				if (strcmp(bot_names[name_index], STRING(pPlayer->v.netname)) == 0)
				{
					used = TRUE;
					break;
				}
			}
		}

		if (used)
		{
			name_index++;

			if (name_index == number_names)
			{
				name_index = 0;
				attempts++;
			}

			if (attempts == 2)
				used = FALSE;  // break out of loop even if already used
		}
	}

	strcpy(name_buffer, bot_names[name_index]);
}


void BotCreate( edict_t *pPlayer, const char *arg1, const char *arg2,
const char *arg3, const char *arg4)
{

	edict_t *BotEnt;
	bot_t *pBot;
	char c_skin[BOT_SKIN_LEN+1];
	char c_name[BOT_NAME_LEN+1];
	c_name[0]=NULL;
	int skill;
	int index;
	int i, j, length;
	bool found = FALSE;
	//min/max cheacking..
	if(max_bots>32) max_bots=32;
	if(max_bots<-1) max_bots=-1;
	if(min_bots>max_bots) min_bots=max_bots;
	if(min_bots<-1) min_bots=-1;
	int count = 0;
	for (i = 1; i <= 32; i++) //<32
	{
		char *infobuffer;
		char cl_name[128];
		cl_name[0]=NULL;
		infobuffer = (*g_engfuncs.pfnGetInfoKeyBuffer)(INDEXENT(i));
		strcpy(cl_name,g_engfuncs.pfnInfoKeyValue(infobuffer, "name"));
		if(cl_name[0]!=NULL)
			count++;
	}
	int cnt2=0;
	for (i=0;i<=31;i++)
	{
		if(bots[i].is_used) cnt2++;
	}
	if ((count >= max_bots && cnt2>=min_bots) && (max_bots != -1))
	{
		//don't create another bot..
		if (pPlayer)
		{
			ClientPrint( pPlayer, HUD_PRINTNOTIFY, "Max bots reached... Can't create bot!\n");
		}
		if (IS_DEDICATED_SERVER())
		{
			printf("Max bots reached... Can't create bot!\n");
		}
		return;
	}

	if ((mod_id == VALVE_DLL) ||
		((mod_id == GEARBOX_DLL) && (pent_info_ctfdetect == NULL)))
	{
		int  max_skin_index;

		if (mod_id == VALVE_DLL)
			max_skin_index = VALVE_MAX_SKINS;
		else  // must be GEARBOX_DLL
			max_skin_index = GEARBOX_MAX_SKINS;

		if ((arg1 == NULL) || (*arg1 == 0))
		{
			bool *pSkinUsed;

			// pick a random skin
			if (mod_id == VALVE_DLL)
			{
				index = RANDOM_LONG(0, VALVE_MAX_SKINS-1);
				pSkinUsed = &valve_skin_used[0];
			}
			else  // must be GEARBOX_DLL
			{
				index = RANDOM_LONG(0, GEARBOX_MAX_SKINS-1);
				pSkinUsed = &gearbox_skin_used[0];
			}

			// check if this skin has already been used...
			while (pSkinUsed[index] == TRUE)
			{
				index++;

				if (index == max_skin_index)
					index = 0;
			}

			pSkinUsed[index] = TRUE;

			// check if all skins are now used...
			for (i = 0; i < max_skin_index; i++)
			{
				if (pSkinUsed[i] == FALSE)
					break;
			}

			// if all skins are used, reset used to FALSE for next selection
			if (i == max_skin_index)
			{
				for (i = 0; i < max_skin_index; i++)
					pSkinUsed[i] = FALSE;
			}

			if (mod_id == VALVE_DLL)
				strcpy( c_skin, valve_bot_skins[index] );
			else // must be GEARBOX_DLL
				strcpy( c_skin, gearbox_bot_skins[index] );
		}
		else
		{
			strncpy( c_skin, arg1, BOT_SKIN_LEN-1 );
			c_skin[BOT_SKIN_LEN] = 0;  // make sure c_skin is null terminated
		}

		for (i = 0; c_skin[i] != 0; i++)
			c_skin[i] = tolower( c_skin[i] );  // convert to all lowercase

		index = 0;

		while ((!found) && (index < max_skin_index))
		{
			if (mod_id == VALVE_DLL)
			{
				if (strcmp(c_skin, valve_bot_skins[index]) == 0)
					found = TRUE;
				else
					index++;
			}
			else // must be GEARBOX_DLL
			{
				if (strcmp(c_skin, gearbox_bot_skins[index]) == 0)
					found = TRUE;
				else
					index++;
			}
		}

		if (found == TRUE)
		{
			if ((arg2 != NULL) && (*arg2 != 0))
			{
				strncpy( c_name, arg2, BOT_SKIN_LEN-1 );
				c_name[BOT_SKIN_LEN] = 0;  // make sure c_name is null terminated
			}
			else
			{
				if (number_names > 0)
					BotPickName( c_name );
				else if (mod_id == VALVE_DLL)
					strcpy( c_name, valve_bot_names[index] );
				else // must be GEARBOX_DLL
					strcpy( c_name, gearbox_bot_names[index] );
			}
		}
		else
		{
			char dir_name[128];
			char filename[128];

			struct stat stat_str;

			GET_GAME_DIR(dir_name);

#ifndef __linux__
			sprintf(filename, "%s\\models\\player\\%s", dir_name, c_skin);
#else
			sprintf(filename, "%s/models/player/%s", dir_name, c_skin);
#endif

			if (stat(filename, &stat_str) != 0)
			{
#ifndef __linux__
				sprintf(filename, "valve\\models\\player\\%s", c_skin);
#else
				sprintf(filename, "valve/models/player/%s", c_skin);
#endif
				if (stat(filename, &stat_str) != 0)
				{
					char err_msg[80];

					sprintf( err_msg, "model \"%s\" is unknown.\n", c_skin );
					if (pPlayer)
						ClientPrint(pPlayer, HUD_PRINTNOTIFY, err_msg );
					if (IS_DEDICATED_SERVER())
						printf(err_msg);

					if (pPlayer)
						ClientPrint(pPlayer, HUD_PRINTNOTIFY,
						"use barney, gina, gman, gordon, helmet, hgrunt,\n");
					if (IS_DEDICATED_SERVER())
						printf("use barney, gina, gman, gordon, helmet, hgrunt,\n");
					if (pPlayer)
						ClientPrint(pPlayer, HUD_PRINTNOTIFY,
						"    recon, robo, scientist, or zombie\n");
					if (IS_DEDICATED_SERVER())
						printf("    recon, robo, scientist, or zombie\n");
					return;
				}
			}

			if ((arg2 != NULL) && (*arg2 != 0))
			{
				strncpy( c_name, arg2, BOT_NAME_LEN-1 );
				c_name[BOT_NAME_LEN] = 0;  // make sure c_name is null terminated
			}
			else
			{
				if (number_names > 0)
					BotPickName( c_name );
				else
				{
					// copy the name of the model to the bot's name...
					strncpy( c_name, arg1, BOT_NAME_LEN-1 );
					c_name[BOT_NAME_LEN] = NULL;  // make sure c_skin is null terminated
				}
			}
		}

		skill = 0;

		if ((arg3 != NULL) && (*arg3 != 0))
			skill = atoi(arg3);

		if ((skill < 1) || (skill > 5))
			skill = default_bot_skill;
	}
	else
	{
		if ((arg3 != NULL) && (*arg3 != 0))
		{
			strncpy( c_name, arg3, BOT_NAME_LEN-1 );
			c_name[BOT_NAME_LEN] = NULL;  // make sure c_name is null terminated
		}
		else
		{
			if (number_names > 0)
				BotPickName( c_name );
			else
				strcpy(c_name, "Bot");
		}

		skill = 0;

		if ((arg4 != NULL) && (*arg4 != 0))
			skill = atoi(arg4);

		if ((skill < 1) || (skill > 5))
			skill = default_bot_skill;
	}

	length = strlen(c_name);

	// remove any illegal characters from name...
	for (i = 0; i < length; i++)
	{
		if ((c_name[i] <= ' ') || (c_name[i] > '~') ||
			(c_name[i] == '"'))
		{
			for (j = i; j < length; j++)  // shuffle chars left (and null)
				c_name[j] = c_name[j+1];
			length--;
		}               
	}

	BotEnt = CREATE_FAKE_CLIENT( c_name );

	if (FNullEnt( BotEnt ))
	{
		if (pPlayer)
			ClientPrint( pPlayer, HUD_PRINTNOTIFY, "Max. Players reached.  Can't create bot!\n");
	}
	else
	{
		char ptr[256];  // allocate space for message from ClientConnect
		char *infobuffer;
		int clientIndex;
		int index;

		if (IS_DEDICATED_SERVER())
			printf("Creating bot...\n");
		else if (pPlayer)
			ClientPrint( pPlayer, HUD_PRINTNOTIFY, "Creating bot...\n");

		index = 0;
		while ((bots[index].is_used) && (index < 32))
			index++;

		if (index == 32)
		{
			ClientPrint( pPlayer, HUD_PRINTNOTIFY, "Can't create bot!\n");
			return;
		}

		//clear shit up for clientprintf and clientcommand checking (for Admin Mod)
		//only helps if we've just created a bot
		//probably never used
		i = 0;
		while ((i < 32) && (clients[i] != BotEnt))
			i++;

		if (i < 32)
			clients[i] = NULL;
		//why put these here?
		//well admin mod plugin may sneak in as their connecting
		//and before we can add this shit for checking purposes
		pBot = &bots[index];
		pBot->pEdict = BotEnt;

		player( VARS(BotEnt) ); //redundant?

		infobuffer = GET_INFOBUFFER( BotEnt );
		//infobuffer= g_engfuncs.pfnGetInfoKeyBuffer(BotEnt);
		clientIndex = ENTINDEX( BotEnt );
		//clientIndex = g_engfuncs.pfnIndexOfEdict(BotEnt);
		//else clientIndex= gpGamedllFuncs->dllapi_table->pfnIndexOfEdict(BotEnt);

		if ((mod_id == VALVE_DLL) || (mod_id == GEARBOX_DLL))
			SET_CLIENT_KEY_VALUE( clientIndex, infobuffer, "model", c_skin );
		else // other mods
			SET_CLIENT_KEY_VALUE( clientIndex, infobuffer, "model", "gina" );

		if (mod_id == CSTRIKE_DLL)
		{
			SET_CLIENT_KEY_VALUE( clientIndex, infobuffer, "rate", "3500.000000");
			SET_CLIENT_KEY_VALUE( clientIndex, infobuffer, "cl_updaterate", "20");
			SET_CLIENT_KEY_VALUE( clientIndex, infobuffer, "cl_lw", "1");
			SET_CLIENT_KEY_VALUE( clientIndex, infobuffer, "cl_lc", "1");
			SET_CLIENT_KEY_VALUE( clientIndex, infobuffer, "tracker", "0");
			SET_CLIENT_KEY_VALUE( clientIndex, infobuffer, "cl_dlmax", "128");
			SET_CLIENT_KEY_VALUE( clientIndex, infobuffer, "lefthand", "1");
			SET_CLIENT_KEY_VALUE( clientIndex, infobuffer, "friends", "0");
			SET_CLIENT_KEY_VALUE( clientIndex, infobuffer, "dm", "0");
			SET_CLIENT_KEY_VALUE( clientIndex, infobuffer, "ah", "1");
		}

		//{fp=fopen("bot.txt","a"); fprintf(fp, "-bot connect %x\n",BotEnt); fclose(fp); }
		if(mr_meta)
		{
			MDLL_ClientConnect( BotEnt, c_name, "127.0.0.1", ptr );
			spawn_check_crash=true;
			spawn_check_crash_count=0;
			spawn_check_crash_edict=BotEnt;
			MDLL_ClientPutInServer( BotEnt );
			spawn_check_crash=false;
			spawn_check_crash_edict=NULL;
			/*i = 0;
			while ((i < 32) && (clients[i] != NULL))
			i++;

			if (i < 32)
			clients[i] = BotEnt;*/
		}
		else
		{
			ClientConnect( BotEnt, c_name, "127.0.0.1", ptr );	  
			spawn_check_crash=true;
			spawn_check_crash_count=0;
			spawn_check_crash_edict=BotEnt;
			ClientPutInServer( BotEnt ); //<- this is the important one..
			spawn_check_crash=false;
			spawn_check_crash_edict=NULL;
		}

		//{ fp=fopen("bot.txt","a"); fprintf(fp,"e\n"); fclose(fp); }
		BotEnt->v.flags |= FL_FAKECLIENT;

		pBot->is_used = TRUE;
		pBot->respawn_state = RESPAWN_IDLE;
		pBot->create_time = (gpGlobals->time)+1;
		//{ fp=fopen("bot.txt","a"); fprintf(fp,"a%f %f\n",pBot->create_time,gpGlobals->time); fclose(fp); }
		pBot->name[0] = 0;  // name not set by server yet
		pBot->bot_money = 0;
		pBot->sg=false;
		pBot->sg_building=false;
		pBot->SGRotated = false;
		pBot->sg_edict=NULL;
		pBot->dispensor=false;
		pBot->dispensor_edict=NULL;
		pBot->pBotLastSgEnemy=NULL;
		pBot->mission = pBot->Attacker;
		pBot->lockMission = false;
		pBot->defendPoint = -1;
		pBot->snipePoint = -1;
		pBot->hasTPEntrance = pBot->hasTPExit = false;
		pBot->tpEntrance = pBot->tpExit = NULL;
		pBot->tpEntranceWP = pBot->tpExitWP = -1;

		roleCheckTimer = gpGlobals->time + 5;

		// Reset them frags and deaths!!!! 
		/*edict_t *pEdict = pBot->pEdict; 
		CBasePlayer *m_pBot = (CBasePlayer*)GET_PRIVATE(pEdict); 
		if (m_pBot)
		m_pBot->m_iDeaths = 0; 
		pEdict->v.frags = 0;*/

		//my setup....may need to be moved..
		//does it clear at level start etc..
		//probably move to team/join game etc
		int i;
		for(i=0;i<1024;i++)
		{
			pBot->rating[i]=0;
		}

		strcpy(pBot->skin, c_skin);

		pBot->not_started = 1;  // hasn't joined game yet
		pBot->bot_start2=1;
		pBot->bot_start3=0;
		if(pBot->greeting==false) 
			pBot->bot_class=-1;
		else
		{
			for (int index = 0; index < 32; index++)
			{
				if(bots[index].pEdict==pBot->pEdict)
				{
					pBot->bot_team=b_team[index];
					pBot->bot_class=b_class[index];
					//char msg[255];
					//sprintf(msg,"--- t%d c%d i%d\n",pBot->bot_team,pBot->bot_class,index);
					//ALERT(at_console, msg);
				}
			}
		}

		if (mod_id == TFC_DLL)
			pBot->start_action = MSG_TFC_IDLE;
		else if (mod_id == CSTRIKE_DLL)
			pBot->start_action = MSG_CS_IDLE;
		else if ((mod_id == GEARBOX_DLL) && (pent_info_ctfdetect != NULL))
			pBot->start_action = MSG_OPFOR_IDLE;
		else if (mod_id == FRONTLINE_DLL)
			pBot->start_action = MSG_FLF_IDLE;
		else
			pBot->start_action = 0;  // not needed for non-team MODs


		//{fp=fopen("bot.txt","a"); fprintf(fp, "-bot d \n",BotEnt); fclose(fp); }
		BotSpawnInit(pBot);

		pBot->need_to_initialize = FALSE;  // don't need to initialize yet

		BotEnt->v.idealpitch = BotEnt->v.v_angle.x;
		BotEnt->v.ideal_yaw = BotEnt->v.v_angle.y;
		BotEnt->v.pitch_speed = BOT_PITCH_SPEED;
		BotEnt->v.yaw_speed = BOT_YAW_SPEED;

		pBot->warmup = 0;  // for Front Line Force
		pBot->idle_angle = 0.0;
		pBot->idle_angle_time = 0.0;
		pBot->round_end = 0;
		pBot->defender = 0;

		pBot->bot_skill = skill - 1;  // 0 based for array indexes

		if ((mod_id == TFC_DLL) || (mod_id == CSTRIKE_DLL) ||
			((mod_id == GEARBOX_DLL) && (pent_info_ctfdetect != NULL)) ||
			(mod_id == FRONTLINE_DLL))
		{
			if ((arg1 != NULL) && (arg1[0] != 0))
			{
				pBot->bot_team = atoi(arg1);

				if ((arg2 != NULL) && (arg2[0] != 0))
				{
					pBot->bot_class = atoi(arg2);
				}
			}
		}
	}
}


int BotInFieldOfView(bot_t *pBot, Vector dest)
{
	// find angles from source to destination...
	Vector entity_angles = UTIL_VecToAngles( dest );

	// make yaw angle 0 to 360 degrees if negative...
	if (entity_angles.y < 0)
		entity_angles.y += 360;

	// get bot's current view angle...
	float view_angle = pBot->pEdict->v.v_angle.y;

	// make view angle 0 to 360 degrees if negative...
	if (view_angle < 0)
		view_angle += 360;

	// return the absolute value of angle to destination entity
	// zero degrees means straight ahead,  45 degrees to the left or
	// 45 degrees to the right is the limit of the normal view angle

	// rsm - START angle bug fix
	int angle = abs((int)view_angle - (int)entity_angles.y);

	if (angle > 180)
		angle = 360 - angle;

	return angle;
	// rsm - END
}


bool BotEntityIsVisible( bot_t *pBot, Vector dest )
{
	TraceResult tr;

	// trace a line from bot's eyes to destination...
	UTIL_TraceLine( pBot->pEdict->v.origin + pBot->pEdict->v.view_ofs,
		dest, ignore_monsters,
		pBot->pEdict->v.pContainingEntity, &tr );

	// check if line of sight to object is not blocked (i.e. visible)
	if (tr.flFraction >= 1.0)
		return TRUE;
	else
		return FALSE;
}


void BotFindItem( bot_t *pBot )
{  
	if(pBot->f_item_check_time>gpGlobals->time)
	{
		if (pBot->pBotPickupItem != NULL 
			&& (pBot->f_item_check_time<=gpGlobals->time+0.5 || (pBot->f_dont_avoid_wall_time>=gpGlobals->time) ||
			(pBot->f_sg_find_time>=gpGlobals->time && pBot->f_sg_find_time<gpGlobals->time+10) ||
			(pBot->f_tp_find_time>=gpGlobals->time && pBot->f_tp_find_time<gpGlobals->time+10)))
		{
			if(strcmp(STRING(pBot->pBotPickupItem->v.classname),"building_sentrygun")==0)
			{
				// let's head off toward that item...
				Vector v_item = pBot->pBotPickupItem->v.origin - pBot->pEdict->v.origin;
				Vector bot_angles = UTIL_VecToAngles( v_item );
				pBot->pEdict->v.ideal_yaw = bot_angles.y;
				pBot->pEdict->v.idealpitch = bot_angles.x;
				BotFixIdealYaw(pBot->pEdict);
				pBot->f_waypoint_time=gpGlobals->time + 6;
			}
			if(strcmp(STRING(pBot->pBotPickupItem->v.classname),"building_teleporter")==0 &&
				(pBot->pBotPickupItem->v.iuser1 == W_FL_TFC_TELEPORTER_ENTRANCE) &&
				(pBot->pBotPickupItem == pBot->teleportInfo.pEntrance) &&
				(a==0) )
			{
				// let's head off toward that item...
				Vector v_item = pBot->pBotPickupItem->v.origin - pBot->pEdict->v.origin;
				Vector bot_angles = UTIL_VecToAngles( v_item );
				pBot->pEdict->v.ideal_yaw = bot_angles.y;
				pBot->pEdict->v.idealpitch = bot_angles.x;
				BotFixIdealYaw(pBot->pEdict);
				pBot->f_waypoint_time=gpGlobals->time + 6;

				float distance = (pBot->pBotPickupItem->v.origin - pBot->pEdict->v.origin).Length2D();
				if(distance < 32)
				{
					// Close enough? Stop.
					pBot->f_move_speed = 0;
					pBot->f_pause_time = gpGlobals->time + 2.0f;
					//
					CheckTeleporterExitTime = gpGlobals->time + 10.0f;
					a=1;
				}
				else if(distance < 120)
				{
					pBot->f_move_speed = pBot->f_max_speed / 5;
				}
			}
			if(!pBot->b_use_button && (strcmp(STRING(pBot->pBotPickupItem->v.classname),"func_button")==0
				|| strcmp(STRING(pBot->pBotPickupItem->v.classname),"func_rot_button")==0))
			{
				// let's head off toward that item...
				Vector v_item = pBot->pBotPickupItem->v.absmin - pBot->pEdict->v.origin;
				Vector bot_angles = UTIL_VecToAngles( v_item );
				pBot->pEdict->v.ideal_yaw = bot_angles.y;
				pBot->pEdict->v.idealpitch = bot_angles.x;
				BotFixIdealYaw(pBot->pEdict);

				pBot->f_waypoint_time=gpGlobals->time + 6;
				if((pBot->pBotPickupItem->v.spawnflags & 256)!=256) 
				{
					pBot->f_move_speed=pBot->f_max_speed/1.5;
				}
			}
		}
		//to stop stupid nav problems..
		if(pBot->pBotPickupItem!=NULL) 
			pBot->curr_waypoint_index = WaypointFindNearest(pBot->pEdict, REACHABLE_RANGE, UTIL_GetTeam(pBot->pEdict));
		return;
	}
	//only do item shit every 0.5 seconds
	pBot->f_item_check_time=gpGlobals->time+0.5;

	edict_t *pent = NULL;
	edict_t *pPickupEntity = NULL;
	Vector pickup_origin;
	Vector entity_origin;
	float radius = 500;
	bool can_pickup;
	float min_distance;
	char item_name[40];
	TraceResult tr;
	Vector vecStart;
	Vector vecEnd;
	int angle_to_entity;
	edict_t *pEdict = pBot->pEdict;

	pBot->pBotPickupItem = NULL;

	// use a MUCH smaller search radius when waypoints are available
	if ((num_waypoints > 0) && (pBot->curr_waypoint_index != -1))
		radius = 500.0;
	else
		radius = 700.0;

	min_distance = radius + 1.0;

	pent=NULL;

	while ((pent = FIND_ENTITY_IN_SPHERE( pent, pEdict->v.origin, radius )) != NULL &&
		(!FNullEnt(pent)))
	{
		can_pickup = FALSE;  // assume can't use it until known otherwise

		strcpy(item_name, STRING(pent->v.classname));

		// see if this is a "func_" type of entity (func_button, etc.)...
		if (strncmp("func_", item_name, 5) == 0)
		{
			// BModels have 0,0,0 for origin so must use VecBModelOrigin...
			entity_origin = VecBModelOrigin(pent);

			vecStart = pEdict->v.origin + pEdict->v.view_ofs;
			vecEnd = entity_origin;

			angle_to_entity = BotInFieldOfView( pBot, vecEnd - vecStart );

			// check if entity is outside field of view (+/- 45 degrees)
			if (angle_to_entity > 45)
				continue;  // skip this item if bot can't "see" it

			UTIL_TraceLine( vecStart, vecEnd, dont_ignore_monsters,
				pEdict->v.pContainingEntity, &tr);

			//can we see the item?
			//if not skip
			if (!(tr.flFraction >= 1.0 || tr.pHit==pent))
				continue;

			// check if entity is a button...
			if (strcmp("func_button", item_name) == 0 || strcmp("func_rot_button", item_name) == 0)
			{
				// use the button about 100% of the time, if haven't
				// used a button in at least 4 seconds...
				// check if flag not set and facing it...
				//also check 'target' to check if its not just a 'display' button
				//pos stupid level designers..urg
				if (!pBot->b_use_button && pent->v.target!=0 &&
					((pBot->f_use_button_time + 1) < gpGlobals->time) &&
					(vecEnd - vecStart).Length()<250)
				{
					if(!WaypointAvailable(WaypointFindNearest(entity_origin, 80, -1),UTIL_GetTeam(pBot->pEdict)))
						continue;
					can_pickup = TRUE;
					//ALERT(at_console,"a");
					// check if close enough and facing it directly...
					if (((vecEnd - vecStart).Length() <= PLAYER_SEARCH_RADIUS) &&
						(angle_to_entity <= 30))
					{
						//ALERT(at_console,"p");
						if((pent->v.spawnflags & 256)!=256) 
						{
							pBot->f_pause_time = gpGlobals->time+0.5;
							pBot->f_use_button_time = gpGlobals->time;
							//ALERT(at_console,"!w");
							pEdict->v.button = IN_USE;
						}
						else
							pBot->f_use_button_time = gpGlobals->time+1;
						pBot->b_use_button = TRUE;
						pBot->b_lift_moving = FALSE;
						//can_pickup = FALSE;
						pBot->f_dont_avoid_wall_time = gpGlobals->time+1;
						pBot->f_sg_find_time=gpGlobals->time+1;
					}

					// if close to button...
					if ((vecEnd - vecStart).Length() < 150)
					{
						//ALERT(at_console,"n");
						// don't avoid walls for a while
						if(pBot->f_dont_avoid_wall_time+1 < gpGlobals->time &&
							pBot->f_sg_find_time+1 < gpGlobals->time)
						{
							pBot->f_dont_avoid_wall_time = gpGlobals->time + 2;
							pBot->f_sg_find_time=gpGlobals->time+2;
						}
						if((pent->v.spawnflags & 256)!=256) 
						{
							pBot->f_move_speed=pBot->f_max_speed/1.5;
						}
					}
				}
				//ALERT(at_console,"b");
			}

			// check if entity is a ladder (ladders are a special case)
			// DON'T search for ladders if there are waypoints in this level...
			if ((strcmp("func_ladder", item_name) == 0) && (num_waypoints == 0))
			{
				// force ladder origin to same z coordinate as bot since
				// the VecBModelOrigin is the center of the ladder.  For
				// LONG ladders, the center MAY be hundreds of units above
				// the bot.  Fake an origin at the same level as the bot...

				entity_origin.z = pEdict->v.origin.z;
				vecEnd = entity_origin;

				// trace a line from bot's eyes to func_ladder entity...
				UTIL_TraceLine( vecStart, vecEnd, dont_ignore_monsters,
					pEdict->v.pContainingEntity, &tr);

				// check if traced all the way up to the entity (didn't hit wall)
				if (tr.flFraction >= 1.0)
				{
					// find distance to item for later use...
					float distance = (vecEnd - vecStart).Length( );

					// use the ladder about 100% of the time, if haven't
					// used a ladder in at least 5 seconds...
					if ((RANDOM_LONG(1, 100) <= 100) &&
						((pBot->f_end_use_ladder_time + 5.0) < gpGlobals->time))
					{
						// if close to ladder...
						if (distance < 100)
						{
							// don't avoid walls for a while
							pBot->f_dont_avoid_wall_time = gpGlobals->time + 5.0;
						}

						can_pickup = TRUE;
					}
				}
			}
			else
			{
				// trace a line from bot's eyes to func_ entity...
				UTIL_TraceLine( vecStart, vecEnd, dont_ignore_monsters,
					pEdict->v.pContainingEntity, &tr);

				// check if traced all the way up to the entity (didn't hit wall)
				if (strcmp(item_name, STRING(tr.pHit->v.classname)) == 0)
				{
					// find distance to item for later use...
					float distance = (vecEnd - vecStart).Length( );

					// check if entity is wall mounted health charger...
					if (strcmp("func_healthcharger", item_name) == 0)
					{
						// check if the bot can use this item and
						// check if the recharger is ready to use (has power left)...
						if ((pEdict->v.health < 100) && (pent->v.frame == 0))
						{
							// check if flag not set...
							if (!pBot->b_use_health_station)
							{
								// check if close enough and facing it directly...
								if ((distance < PLAYER_SEARCH_RADIUS) &&
									(angle_to_entity <= 10))
								{
									pBot->b_use_health_station = TRUE;
									pBot->f_use_health_time = gpGlobals->time;
								}

								// if close to health station...
								if (distance < 100)
								{
									// don't avoid walls for a while
									pBot->f_dont_avoid_wall_time = gpGlobals->time + 5.0;
								}

								can_pickup = TRUE;
							}
						}
						else
						{
							// don't need or can't use this item...
							pBot->b_use_health_station = FALSE;
						}
					}

					// check if entity is wall mounted HEV charger...
					else if (strcmp("func_recharge", item_name) == 0)
					{
						// check if the bot can use this item and
						// check if the recharger is ready to use (has power left)...
						if ((pEdict->v.armorvalue < VALVE_MAX_NORMAL_BATTERY) &&
							(pent->v.frame == 0))
						{
							// check if flag not set and facing it...
							if (!pBot->b_use_HEV_station)
							{
								// check if close enough and facing it directly...
								if ((distance < PLAYER_SEARCH_RADIUS) &&
									(angle_to_entity <= 10))
								{
									pBot->b_use_HEV_station = TRUE;
									pBot->f_use_HEV_time = gpGlobals->time;
								}

								// if close to HEV recharger...
								if (distance < 100)
								{
									// don't avoid walls for a while
									pBot->f_dont_avoid_wall_time = gpGlobals->time + 5.0;
								}

								can_pickup = TRUE;
							}
						}
						else
						{
							// don't need or can't use this item...
							pBot->b_use_HEV_station = FALSE;
						}
					}

					else if (strcmp("func_breakable", item_name) == 0)
					{
						// check if the item is not visible (i.e. has not respawned)
						if ((pent->v.effects & EF_NODRAW)==EF_NODRAW)
							continue;
						//UTIL_SelectItem(pEdict, "weapon_crowbar");

						//pEdict->v.button |= IN_ATTACK;   // charge the weapon
						//can_pickup = TRUE;
					}

				}
			}
		}
		else  // everything else...
		{
			entity_origin = pent->v.origin;

			vecStart = pEdict->v.origin + pEdict->v.view_ofs;
			vecEnd = entity_origin;         

			// find angles from bot origin to entity...
			angle_to_entity = BotInFieldOfView( pBot, vecEnd - vecStart );

			// check if entity is outside field of view (+/- 45 degrees)
			// && strcmp("building_sentrygun", item_name) != 0
			if (angle_to_entity > 45)
				continue;  // skip this item if bot can't "see" it

			// check if line of sight to object is not blocked (i.e. visible)
			if (BotEntityIsVisible( pBot, vecEnd ))
			{

				// check if entity is a flag etc
				if (strcmp("item_tfgoal", item_name) == 0 &&
					pBot->bot_has_flag==false && (mod_id == TFC_DLL) &&
					pent->v.owner == NULL)
				{
					// check if the item is not visible (i.e. has not respawned)
					if ((pent->v.effects & EF_NODRAW)==EF_NODRAW)
						continue;

					char mdlname[255];
					char temp[255];
					for(int i=0;i<255;i++)
					{
						mdlname[i]=NULL;
						temp[i]=NULL;
					}
					if(pent->v.model!=0) strcpy(temp,STRING(pent->v.model));
					if((strlen(temp))-8 >= 0) strncpy(mdlname,(temp)+(strlen(temp))-8,4);
					if(strcmp(mdlname,"pack")==0)
					{
						if(pEdict->v.playerclass == TFC_CLASS_CIVILIAN)
							continue;
						if(pEdict->v.playerclass == TFC_CLASS_SCOUT)
						{
							if(pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SHOTGUN].iAmmo1]>=PC_SCOUT_MAXAMMO_SHOT/2 &&
								pBot->m_rgAmmo[weapon_defs[TF_WEAPON_NAILGUN].iAmmo1]>=PC_SCOUT_MAXAMMO_NAIL/2)
								continue;
						}
						if(pEdict->v.playerclass == TFC_CLASS_SNIPER)
						{
							if(pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SHOTGUN].iAmmo1]>=PC_SNIPER_MAXAMMO_SHOT/2 &&
								pBot->m_rgAmmo[weapon_defs[TF_WEAPON_NAILGUN].iAmmo1]>=PC_SNIPER_MAXAMMO_NAIL/2)
								continue;
						}
						if(pEdict->v.playerclass == TFC_CLASS_SOLDIER)
						{
							if(pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SHOTGUN].iAmmo1]>=PC_SOLDIER_MAXAMMO_SHOT/2 &&
								pBot->m_rgAmmo[weapon_defs[TF_WEAPON_NAILGUN].iAmmo1]>=PC_SOLDIER_MAXAMMO_NAIL/2 &&
								pBot->m_rgAmmo[weapon_defs[TF_WEAPON_RPG].iAmmo1]>=PC_SOLDIER_MAXAMMO_ROCKET/2)
								continue;
						}
						if(pEdict->v.playerclass == TFC_CLASS_DEMOMAN)
						{
							if(pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SHOTGUN].iAmmo1]>=PC_DEMOMAN_MAXAMMO_SHOT/2 &&
								pBot->m_rgAmmo[weapon_defs[TF_WEAPON_NAILGUN].iAmmo1]>=PC_DEMOMAN_MAXAMMO_NAIL/2 &&
								pBot->m_rgAmmo[weapon_defs[TF_WEAPON_RPG].iAmmo1]>=PC_DEMOMAN_MAXAMMO_ROCKET/2)
								continue;
						}
						if(pEdict->v.playerclass == TFC_CLASS_MEDIC)
						{
							if(pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SHOTGUN].iAmmo1]>=PC_MEDIC_MAXAMMO_SHOT/2 &&
								pBot->m_rgAmmo[weapon_defs[TF_WEAPON_NAILGUN].iAmmo1]>=PC_MEDIC_MAXAMMO_NAIL/2)
								continue;
						}
						if(pEdict->v.playerclass == TFC_CLASS_HWGUY)
						{
							if(pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SHOTGUN].iAmmo1]>=PC_HVYWEAP_MAXAMMO_SHOT/2 &&
								pBot->m_rgAmmo[weapon_defs[TF_WEAPON_NAILGUN].iAmmo1]>=PC_HVYWEAP_MAXAMMO_NAIL/2)
								continue;
						}
						if(pEdict->v.playerclass == TFC_CLASS_PYRO)
						{
							if(pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SHOTGUN].iAmmo1]>=PC_PYRO_MAXAMMO_SHOT/2 &&
								pBot->m_rgAmmo[weapon_defs[TF_WEAPON_NAILGUN].iAmmo1]>=PC_PYRO_MAXAMMO_NAIL/2 &&
								pBot->m_rgAmmo[weapon_defs[TF_WEAPON_RPG].iAmmo1]>=PC_PYRO_MAXAMMO_ROCKET/2)
								continue;
						}
						if(pEdict->v.playerclass == TFC_CLASS_SPY)
						{
							if(pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SHOTGUN].iAmmo1]>=PC_SPY_MAXAMMO_SHOT/2 &&
								pBot->m_rgAmmo[weapon_defs[TF_WEAPON_NAILGUN].iAmmo1]>=PC_SPY_MAXAMMO_NAIL/2)
								continue;
						}
						if(pEdict->v.playerclass == TFC_CLASS_ENGINEER)
						{
							if(pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SPANNER].iAmmo1]==PC_ENGINEER_MAXAMMO_CELL &&
								pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SHOTGUN].iAmmo1]==PC_ENGINEER_MAXAMMO_SHOT &&
								pBot->m_rgAmmo[weapon_defs[TF_WEAPON_NAILGUN].iAmmo1]==PC_ENGINEER_MAXAMMO_NAIL/2 &&
								pBot->m_rgAmmo[weapon_defs[TF_WEAPON_RPG].iAmmo1]==PC_ENGINEER_MAXAMMO_ROCKET)
								continue;
						}
					}
					if(!WaypointAvailable(WaypointFindNearest(pent->v.origin, 80, -1),UTIL_GetTeam(pBot->pEdict)))
						continue;
					can_pickup = TRUE;
				}

				// check if entity is a flag etc
				if (strcmp("info_tfgoal", item_name) == 0 &&
					pBot->bot_has_flag==false && (mod_id == TFC_DLL) &&
					pent->v.owner == NULL && pent->v.model!=NULL)
				{
					// check if the item is not visible (i.e. has not respawned)
					if ((pent->v.effects & EF_NODRAW)==EF_NODRAW)
						continue;

					char mdlname[255];
					char temp[255];
					for(int i=0;i<255;i++)
					{
						mdlname[i]=NULL;
						temp[i]=NULL;
					}
					if(pent->v.model!=0) 
						strcpy(temp,STRING(pent->v.model));
					if((strlen(temp))-8 >= 0) 
						strncpy(mdlname,(temp)+(strlen(temp))-8,4);
					//UTIL_HostSay(pEdict,0,mdlname);

					if(strcmp(mdlname,"pack")==0)
					{
						if(pEdict->v.playerclass == TFC_CLASS_CIVILIAN)
							continue;
						if(pEdict->v.playerclass == TFC_CLASS_SCOUT)
						{
							if(pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SHOTGUN].iAmmo1]>=PC_SCOUT_MAXAMMO_SHOT/2 &&
								pBot->m_rgAmmo[weapon_defs[TF_WEAPON_NAILGUN].iAmmo1]>=PC_SCOUT_MAXAMMO_NAIL/2)
								continue;
						}
						if(pEdict->v.playerclass == TFC_CLASS_SNIPER)
						{
							if(pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SHOTGUN].iAmmo1]>=PC_SNIPER_MAXAMMO_SHOT/2 &&
								pBot->m_rgAmmo[weapon_defs[TF_WEAPON_NAILGUN].iAmmo1]>=PC_SNIPER_MAXAMMO_NAIL/2)
								continue;
						}
						if(pEdict->v.playerclass == TFC_CLASS_SOLDIER)
						{
							if(pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SHOTGUN].iAmmo1]>=PC_SOLDIER_MAXAMMO_SHOT/2 &&
								pBot->m_rgAmmo[weapon_defs[TF_WEAPON_NAILGUN].iAmmo1]>=PC_SOLDIER_MAXAMMO_NAIL/2 &&
								pBot->m_rgAmmo[weapon_defs[TF_WEAPON_RPG].iAmmo1]>=PC_SOLDIER_MAXAMMO_ROCKET/2)
								continue;
						}
						if(pEdict->v.playerclass == TFC_CLASS_DEMOMAN)
						{
							if(pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SHOTGUN].iAmmo1]>=PC_DEMOMAN_MAXAMMO_SHOT/2 &&
								pBot->m_rgAmmo[weapon_defs[TF_WEAPON_NAILGUN].iAmmo1]>=PC_DEMOMAN_MAXAMMO_NAIL/2 &&
								pBot->m_rgAmmo[weapon_defs[TF_WEAPON_RPG].iAmmo1]>=PC_DEMOMAN_MAXAMMO_ROCKET/2)
								continue;
						}
						if(pEdict->v.playerclass == TFC_CLASS_MEDIC)
						{
							if(pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SHOTGUN].iAmmo1]>=PC_MEDIC_MAXAMMO_SHOT/2 &&
								pBot->m_rgAmmo[weapon_defs[TF_WEAPON_NAILGUN].iAmmo1]>=PC_MEDIC_MAXAMMO_NAIL/2)
								continue;
						}
						if(pEdict->v.playerclass == TFC_CLASS_HWGUY)
						{
							if(pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SHOTGUN].iAmmo1]>=PC_HVYWEAP_MAXAMMO_SHOT/2 &&
								pBot->m_rgAmmo[weapon_defs[TF_WEAPON_NAILGUN].iAmmo1]>=PC_HVYWEAP_MAXAMMO_NAIL/2)
								continue;
						}
						if(pEdict->v.playerclass == TFC_CLASS_PYRO)
						{
							if(pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SHOTGUN].iAmmo1]>=PC_PYRO_MAXAMMO_SHOT/2 &&
								pBot->m_rgAmmo[weapon_defs[TF_WEAPON_NAILGUN].iAmmo1]>=PC_PYRO_MAXAMMO_NAIL/2 &&
								pBot->m_rgAmmo[weapon_defs[TF_WEAPON_RPG].iAmmo1]>=PC_PYRO_MAXAMMO_ROCKET/2)
								continue;
						}
						if(pEdict->v.playerclass == TFC_CLASS_SPY)
						{
							if(pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SHOTGUN].iAmmo1]>=PC_SPY_MAXAMMO_SHOT/2 &&
								pBot->m_rgAmmo[weapon_defs[TF_WEAPON_NAILGUN].iAmmo1]>=PC_SPY_MAXAMMO_NAIL/2)
								continue;
						}
						if(pEdict->v.playerclass == TFC_CLASS_ENGINEER)
						{
							if(pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SPANNER].iAmmo1]==PC_ENGINEER_MAXAMMO_CELL &&
								pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SHOTGUN].iAmmo1]==PC_ENGINEER_MAXAMMO_SHOT &&
								pBot->m_rgAmmo[weapon_defs[TF_WEAPON_NAILGUN].iAmmo1]==PC_ENGINEER_MAXAMMO_NAIL/2 &&
								pBot->m_rgAmmo[weapon_defs[TF_WEAPON_RPG].iAmmo1]==PC_ENGINEER_MAXAMMO_ROCKET)
								continue;
						}
					}
					if(!WaypointAvailable(WaypointFindNearest(pent->v.origin, 80, -1),UTIL_GetTeam(pBot->pEdict)))
						continue;
					can_pickup = TRUE;
				}

				// check if entity is a flag etc
				if (strcmp("building_dispenser", item_name) == 0 &&
					pBot->bot_has_flag==false && (mod_id == TFC_DLL))
				{
					// check if the item is not visible (i.e. has not respawned)
					if ((pent->v.effects & EF_NODRAW)==EF_NODRAW)
						continue;
					if(pEdict->v.playerclass == TFC_CLASS_CIVILIAN)
						continue;
					if(pEdict->v.playerclass == TFC_CLASS_SCOUT)
					{
						if(pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SHOTGUN].iAmmo1]>=PC_SCOUT_MAXAMMO_SHOT/2 &&
							pBot->m_rgAmmo[weapon_defs[TF_WEAPON_NAILGUN].iAmmo1]>=PC_SCOUT_MAXAMMO_NAIL/2)
							continue;
					}
					if(pEdict->v.playerclass == TFC_CLASS_SNIPER)
					{
						if(pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SHOTGUN].iAmmo1]>=PC_SNIPER_MAXAMMO_SHOT/2 &&
							pBot->m_rgAmmo[weapon_defs[TF_WEAPON_NAILGUN].iAmmo1]>=PC_SNIPER_MAXAMMO_NAIL/2)
							continue;
					}
					if(pEdict->v.playerclass == TFC_CLASS_SOLDIER)
					{
						if(pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SHOTGUN].iAmmo1]>=PC_SOLDIER_MAXAMMO_SHOT/2 &&
							pBot->m_rgAmmo[weapon_defs[TF_WEAPON_NAILGUN].iAmmo1]>=PC_SOLDIER_MAXAMMO_NAIL/2 &&
							pBot->m_rgAmmo[weapon_defs[TF_WEAPON_RPG].iAmmo1]>=PC_SOLDIER_MAXAMMO_ROCKET/2)
							continue;
					}
					if(pEdict->v.playerclass == TFC_CLASS_DEMOMAN)
					{
						if(pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SHOTGUN].iAmmo1]>=PC_DEMOMAN_MAXAMMO_SHOT/2 &&
							pBot->m_rgAmmo[weapon_defs[TF_WEAPON_NAILGUN].iAmmo1]>=PC_DEMOMAN_MAXAMMO_NAIL/2 &&
							pBot->m_rgAmmo[weapon_defs[TF_WEAPON_RPG].iAmmo1]>=PC_DEMOMAN_MAXAMMO_ROCKET/2)
							continue;
					}
					if(pEdict->v.playerclass == TFC_CLASS_MEDIC)
					{
						if(pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SHOTGUN].iAmmo1]>=PC_MEDIC_MAXAMMO_SHOT/2 &&
							pBot->m_rgAmmo[weapon_defs[TF_WEAPON_NAILGUN].iAmmo1]>=PC_MEDIC_MAXAMMO_NAIL/2)
							continue;
					}
					if(pEdict->v.playerclass == TFC_CLASS_HWGUY)
					{
						if(pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SHOTGUN].iAmmo1]>=PC_HVYWEAP_MAXAMMO_SHOT/2 &&
							pBot->m_rgAmmo[weapon_defs[TF_WEAPON_NAILGUN].iAmmo1]>=PC_HVYWEAP_MAXAMMO_NAIL/2)
							continue;
					}
					if(pEdict->v.playerclass == TFC_CLASS_PYRO)
					{
						if(pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SHOTGUN].iAmmo1]>=PC_PYRO_MAXAMMO_SHOT/2 &&
							pBot->m_rgAmmo[weapon_defs[TF_WEAPON_NAILGUN].iAmmo1]>=PC_PYRO_MAXAMMO_NAIL/2 &&
							pBot->m_rgAmmo[weapon_defs[TF_WEAPON_RPG].iAmmo1]>=PC_PYRO_MAXAMMO_ROCKET/2)
							continue;
					}
					if(pEdict->v.playerclass == TFC_CLASS_SPY)
					{
						if(pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SHOTGUN].iAmmo1]>=PC_SPY_MAXAMMO_SHOT/2 &&
							pBot->m_rgAmmo[weapon_defs[TF_WEAPON_NAILGUN].iAmmo1]>=PC_SPY_MAXAMMO_NAIL/2)
							continue;
					}
					if(pEdict->v.playerclass == TFC_CLASS_ENGINEER)
					{
						if(pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SPANNER].iAmmo1]==PC_ENGINEER_MAXAMMO_CELL &&
							pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SHOTGUN].iAmmo1]==PC_ENGINEER_MAXAMMO_SHOT &&
							pBot->m_rgAmmo[weapon_defs[TF_WEAPON_NAILGUN].iAmmo1]>=PC_ENGINEER_MAXAMMO_NAIL/2 &&
							pBot->m_rgAmmo[weapon_defs[TF_WEAPON_RPG].iAmmo1]==PC_ENGINEER_MAXAMMO_ROCKET)
						{
							if(pBot->dispensor_edict!=pent)
							{
								continue;
							}
							else
							{
								UTIL_SelectItem(pEdict, "tf_weapon_spanner");
								int dis=(pent->v.origin - pEdict->v.origin).Length();
								if(dis<140) 
								{
									pEdict->v.button |= IN_ATTACK;   // charge the weapon
									pBot->f_duck_time=gpGlobals->time+1;
								}
								can_pickup = TRUE;
							}
							
					}
					}
					if(!WaypointAvailable(WaypointFindNearest(pent->v.origin, 80, -1),UTIL_GetTeam(pBot->pEdict)))
						continue;
					can_pickup = TRUE;
				}
				// check if entity is a sg
				//only hit sg's if this bots got one
				//otherwise we waste the cells needed to build
				//unless its hurt
				if (strcmp("building_sentrygun", item_name) == 0 && (mod_id == TFC_DLL) && pEdict->v.playerclass == TFC_CLASS_ENGINEER
					&& ((pBot->sg && !pBot->bot_has_flag) || pent->v.health<50))
				{
					// check if the item is not visible (i.e. has not respawned)
					if ((pent->v.effects & EF_NODRAW)==EF_NODRAW)
						continue;

					//check if your near your sg..
					//if so, if this isn't it, ignore it
					//...unless! our sg is lev 3
					if(pBot->sg_edict!=NULL)
					{
						int dis=(pent->v.origin - pEdict->v.origin).Length();
						bool done=false;
						//if our sg, and distance <300
						if(dis<300 && pent==pBot->sg_edict)
						{
							//if sg not injured, and less than 140cells dont bother..
							//could be injured...but we have 0 cells left
							//lev 3, (no rpg OR no shells), and max health = Ignore
							//not lev3, no shells, max health = Ignore
							//lev 3, max health, max ammo = Ignore
							if((pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SPANNER].iAmmo1]<140 && (pent->v.health==pent->v.max_health) && pBot->sg_ammo==100)
								|| pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SPANNER].iAmmo1]==0
								|| (strcmp(STRING(pBot->sg_edict->v.model),"models/sentry3.mdl")==0 && pent->v.health==pent->v.max_health && (pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SHOTGUN].iAmmo1]==0 || pBot->m_rgAmmo[weapon_defs[TF_WEAPON_RPG].iAmmo1]==0))
								|| (strcmp(STRING(pBot->sg_edict->v.model),"models/sentry3.mdl")!=0 && pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SHOTGUN].iAmmo1]==0 && pent->v.health==pent->v.max_health)
								|| (strcmp(STRING(pBot->sg_edict->v.model),"models/sentry3.mdl")==0 && pent->v.health==pent->v.max_health && pBot->sg_ammo==100)) 
								continue;
							UTIL_SelectItem(pEdict, "tf_weapon_spanner");

							if(dis<140) pEdict->v.button |= IN_ATTACK;   // charge the weapon
							can_pickup = TRUE;
							if(pBot->f_sg_find_time<gpGlobals->time-1) 
								pBot->f_sg_find_time=gpGlobals->time+8;
							//skip other handling if its our sg
							done=true;
						}
						//ignore sgs that aern't ours
						//and ours isn't level 3
						//or its level 3 and low on ammo (<50%)
						if(dis<300 && pent!=pBot->sg_edict
							&& (strcmp(STRING(pBot->sg_edict->v.model),"models/sentry3.mdl")!=0 || pBot->sg_ammo<50))
							continue;
						//other sg handling

						if(!done)
						{
							//if sg not injured, and less than 140cells dont bother..
							//could be injured...but we have 0 cells left
							//no shells, max health = Ignore
							//lev 3 = Ignore
							if((pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SPANNER].iAmmo1]<140 && pent->v.health==pent->v.max_health)
								|| pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SPANNER].iAmmo1]==0
								|| (pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SHOTGUN].iAmmo1]==0 && pent->v.health==pent->v.max_health)
								|| strcmp(STRING(pent->v.model),"models/sentry3.mdl")==0) 
								continue;
							UTIL_SelectItem(pEdict, "tf_weapon_spanner");

							if(dis<140) pEdict->v.button |= IN_ATTACK;   // charge the weapon
							can_pickup = TRUE;
							if(pBot->f_sg_find_time<gpGlobals->time-1) 
								pBot->f_sg_find_time=gpGlobals->time+5;
						}
					}
					else
						//just in case...if summit stupids happend
						//and the bot don't have a pointer to its sg..grr
					{
						//if sg not injured, and less than 140cells dont bother..
						//could be injured...but we have 0 cells left
						if((pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SPANNER].iAmmo1]<140 && pent->v.health==pent->v.max_health)
							|| pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SPANNER].iAmmo1]==0
							|| (pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SHOTGUN].iAmmo1]==0 && pent->v.health==pent->v.max_health)
							|| strcmp(STRING(pent->v.model),"models/sentry3.mdl")==0) 
							continue;
						UTIL_SelectItem(pEdict, "tf_weapon_spanner");

						pEdict->v.button |= IN_ATTACK;   // charge the weapon
						can_pickup = TRUE;
						if(pBot->f_sg_find_time<gpGlobals->time-1) 
							pBot->f_sg_find_time=gpGlobals->time+5;
					}
				}
				//teleporter ent
				if ((strcmp("building_teleporter", item_name) == 0) && 
					(pent->v.iuser1 == W_FL_TFC_TELEPORTER_ENTRANCE) &&
					!pBot->pBotEnemy)
				{
					// Teleporter use.
					if(pBot->teleportInfo.bIsUsed)// && (pBot->curr_waypoint_index == pBot->teleportInfo.iEntranceWaypointIndex))
					{
						// Look for the teleporter here.
						can_pickup = TRUE;
						if(pBot->f_tp_find_time<gpGlobals->time-1) 
								pBot->f_tp_find_time=gpGlobals->time+5;			
					}
				}
				// check if entity is armor...
				if (strncmp("item_armor", item_name, 10) == 0)
				{
					if ((pent->v.effects & EF_NODRAW)==EF_NODRAW)
					{
						// someone owns this weapon or it hasn't respawned yet
						continue;
					}
					if (BotArmorValue(pEdict) == 100)
						continue;			   
					can_pickup = TRUE;
				}
				// check if entity is a weapon...
				if (strncmp("weapon_", item_name, 7) == 0)
				{
					if ((pent->v.effects & EF_NODRAW)==EF_NODRAW)
					{
						// someone owns this weapon or it hasn't respawned yet
						continue;
					}
					can_pickup = TRUE;
				}

				// check if entity is ammo...
				else if (strncmp("ammo_", item_name, 5) == 0)
				{
					// check if the item is not visible (i.e. has not respawned)
					if ((pent->v.effects & EF_NODRAW)==EF_NODRAW)
						continue;
					if(pEdict->v.playerclass == TFC_CLASS_CIVILIAN)
						continue;
					if(pEdict->v.playerclass == TFC_CLASS_SCOUT)
					{
						if(pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SHOTGUN].iAmmo1]>=PC_SCOUT_MAXAMMO_SHOT/2 &&
							pBot->m_rgAmmo[weapon_defs[TF_WEAPON_NAILGUN].iAmmo1]>=PC_SCOUT_MAXAMMO_NAIL/2)
							continue;
					}
					if(pEdict->v.playerclass == TFC_CLASS_SNIPER)
					{
						if(pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SHOTGUN].iAmmo1]>=PC_SNIPER_MAXAMMO_SHOT/2 &&
							pBot->m_rgAmmo[weapon_defs[TF_WEAPON_NAILGUN].iAmmo1]>=PC_SNIPER_MAXAMMO_NAIL/2)
							continue;
					}
					if(pEdict->v.playerclass == TFC_CLASS_SOLDIER)
					{
						if(pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SHOTGUN].iAmmo1]>=PC_SOLDIER_MAXAMMO_SHOT/2 &&
							pBot->m_rgAmmo[weapon_defs[TF_WEAPON_NAILGUN].iAmmo1]>=PC_SOLDIER_MAXAMMO_NAIL/2 &&
							pBot->m_rgAmmo[weapon_defs[TF_WEAPON_RPG].iAmmo1]>=PC_SOLDIER_MAXAMMO_ROCKET/2)
							continue;
					}
					if(pEdict->v.playerclass == TFC_CLASS_DEMOMAN)
					{
						if(pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SHOTGUN].iAmmo1]>=PC_DEMOMAN_MAXAMMO_SHOT/2 &&
							pBot->m_rgAmmo[weapon_defs[TF_WEAPON_NAILGUN].iAmmo1]>=PC_DEMOMAN_MAXAMMO_NAIL/2 &&
							pBot->m_rgAmmo[weapon_defs[TF_WEAPON_RPG].iAmmo1]>=PC_DEMOMAN_MAXAMMO_ROCKET/2)
							continue;
					}
					if(pEdict->v.playerclass == TFC_CLASS_MEDIC)
					{
						if(pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SHOTGUN].iAmmo1]>=PC_MEDIC_MAXAMMO_SHOT/2 &&
							pBot->m_rgAmmo[weapon_defs[TF_WEAPON_NAILGUN].iAmmo1]>=PC_MEDIC_MAXAMMO_NAIL/2)
							continue;
					}
					if(pEdict->v.playerclass == TFC_CLASS_HWGUY)
					{
						if(pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SHOTGUN].iAmmo1]>=PC_HVYWEAP_MAXAMMO_SHOT/2 &&
							pBot->m_rgAmmo[weapon_defs[TF_WEAPON_NAILGUN].iAmmo1]>=PC_HVYWEAP_MAXAMMO_NAIL/2)
							continue;
					}
					if(pEdict->v.playerclass == TFC_CLASS_PYRO)
					{
						if(pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SHOTGUN].iAmmo1]>=PC_PYRO_MAXAMMO_SHOT/2 &&
							pBot->m_rgAmmo[weapon_defs[TF_WEAPON_NAILGUN].iAmmo1]>=PC_PYRO_MAXAMMO_NAIL/2 &&
							pBot->m_rgAmmo[weapon_defs[TF_WEAPON_RPG].iAmmo1]>=PC_PYRO_MAXAMMO_ROCKET/2)
							continue;
					}
					if(pEdict->v.playerclass == TFC_CLASS_SPY)
					{
						if(pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SHOTGUN].iAmmo1]>=PC_SPY_MAXAMMO_SHOT/2 &&
							pBot->m_rgAmmo[weapon_defs[TF_WEAPON_NAILGUN].iAmmo1]>=PC_SPY_MAXAMMO_NAIL/2)
							continue;
					}
					if(pEdict->v.playerclass == TFC_CLASS_ENGINEER)
					{
						if(pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SPANNER].iAmmo1]==PC_ENGINEER_MAXAMMO_CELL &&
							pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SHOTGUN].iAmmo1]==PC_ENGINEER_MAXAMMO_SHOT &&
							pBot->m_rgAmmo[weapon_defs[TF_WEAPON_NAILGUN].iAmmo1]>=PC_ENGINEER_MAXAMMO_NAIL/2 &&
							pBot->m_rgAmmo[weapon_defs[TF_WEAPON_RPG].iAmmo1]==PC_ENGINEER_MAXAMMO_ROCKET)
							continue;
					}
					if(!WaypointAvailable(WaypointFindNearest(pent->v.origin, 80, -1),UTIL_GetTeam(pBot->pEdict)))
						continue;	
					can_pickup = TRUE;
				}

				// check if entity is a battery...
				else if (strcmp("item_battery", item_name) == 0)
				{
					// check if the item is not visible (i.e. has not respawned)
					if ((pent->v.effects & EF_NODRAW)==EF_NODRAW)
						continue;
					if(!WaypointAvailable(WaypointFindNearest(pent->v.origin, 80, -1),UTIL_GetTeam(pBot->pEdict)))
						continue;
					// check if the bot can use this item...
					if (pEdict->v.armorvalue < VALVE_MAX_NORMAL_BATTERY)
					{
						can_pickup = TRUE;
					}
				}

				// check if entity is a healthkit...
				else if (strcmp("item_healthkit", item_name) == 0 &&
					pEdict->v.health < pEdict->v.max_health)
				{
					// check if the item is not visible (i.e. has not respawned)
					if ((pent->v.effects & EF_NODRAW)==EF_NODRAW)
						continue;
					if(!WaypointAvailable(WaypointFindNearest(pent->v.origin, 80, -1),UTIL_GetTeam(pBot->pEdict)))
						continue;
					// check if the bot can use this item...
					if (pEdict->v.health < 100)
					{
						can_pickup = TRUE;
					}
				}
				// check if entity is a packed up weapons box...
				else if (strcmp("weaponbox", item_name) == 0)
				{
					//if mod=tfc
					// check if the item is not visible (i.e. has not respawned)
					if ((pent->v.effects & EF_NODRAW)==EF_NODRAW)
						continue;
					if(pEdict->v.playerclass == TFC_CLASS_CIVILIAN)
						continue;
					if(pEdict->v.playerclass == TFC_CLASS_SCOUT)
					{
						if(pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SHOTGUN].iAmmo1]>=PC_SCOUT_MAXAMMO_SHOT/2 &&
							pBot->m_rgAmmo[weapon_defs[TF_WEAPON_NAILGUN].iAmmo1]>=PC_SCOUT_MAXAMMO_NAIL/2)
							continue;
					}
					if(pEdict->v.playerclass == TFC_CLASS_SNIPER)
					{
						if(pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SHOTGUN].iAmmo1]>=PC_SNIPER_MAXAMMO_SHOT/2 &&
							pBot->m_rgAmmo[weapon_defs[TF_WEAPON_NAILGUN].iAmmo1]>=PC_SNIPER_MAXAMMO_NAIL/2)
							continue;
					}
					if(pEdict->v.playerclass == TFC_CLASS_SOLDIER)
					{
						if(pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SHOTGUN].iAmmo1]>=PC_SOLDIER_MAXAMMO_SHOT/2 &&
							pBot->m_rgAmmo[weapon_defs[TF_WEAPON_NAILGUN].iAmmo1]>=PC_SOLDIER_MAXAMMO_NAIL/2 &&
							pBot->m_rgAmmo[weapon_defs[TF_WEAPON_RPG].iAmmo1]>=PC_SOLDIER_MAXAMMO_ROCKET/2)
							continue;
					}
					if(pEdict->v.playerclass == TFC_CLASS_DEMOMAN)
					{
						if(pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SHOTGUN].iAmmo1]>=PC_DEMOMAN_MAXAMMO_SHOT/2 &&
							pBot->m_rgAmmo[weapon_defs[TF_WEAPON_NAILGUN].iAmmo1]>=PC_DEMOMAN_MAXAMMO_NAIL/2 &&
							pBot->m_rgAmmo[weapon_defs[TF_WEAPON_RPG].iAmmo1]>=PC_DEMOMAN_MAXAMMO_ROCKET/2)
							continue;
					}
					if(pEdict->v.playerclass == TFC_CLASS_MEDIC)
					{
						if(pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SHOTGUN].iAmmo1]>=PC_MEDIC_MAXAMMO_SHOT/2 &&
							pBot->m_rgAmmo[weapon_defs[TF_WEAPON_NAILGUN].iAmmo1]>=PC_MEDIC_MAXAMMO_NAIL/2)
							continue;
					}
					if(pEdict->v.playerclass == TFC_CLASS_HWGUY)
					{
						if(pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SHOTGUN].iAmmo1]>=PC_HVYWEAP_MAXAMMO_SHOT/2 &&
							pBot->m_rgAmmo[weapon_defs[TF_WEAPON_NAILGUN].iAmmo1]>=PC_HVYWEAP_MAXAMMO_NAIL/2)
							continue;
					}
					if(pEdict->v.playerclass == TFC_CLASS_PYRO)
					{
						if(pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SHOTGUN].iAmmo1]>=PC_PYRO_MAXAMMO_SHOT/2 &&
							pBot->m_rgAmmo[weapon_defs[TF_WEAPON_NAILGUN].iAmmo1]>=PC_PYRO_MAXAMMO_NAIL/2 &&
							pBot->m_rgAmmo[weapon_defs[TF_WEAPON_RPG].iAmmo1]>=PC_PYRO_MAXAMMO_ROCKET/2)
							continue;
					}
					if(pEdict->v.playerclass == TFC_CLASS_SPY)
					{
						if(pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SHOTGUN].iAmmo1]>=PC_SPY_MAXAMMO_SHOT/2 &&
							pBot->m_rgAmmo[weapon_defs[TF_WEAPON_NAILGUN].iAmmo1]>=PC_SPY_MAXAMMO_NAIL/2)
							continue;
					}
					if(pEdict->v.playerclass == TFC_CLASS_ENGINEER)
					{
						if(pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SPANNER].iAmmo1]==PC_ENGINEER_MAXAMMO_CELL &&
							pBot->m_rgAmmo[weapon_defs[TF_WEAPON_SHOTGUN].iAmmo1]==PC_ENGINEER_MAXAMMO_SHOT &&
							pBot->m_rgAmmo[weapon_defs[TF_WEAPON_NAILGUN].iAmmo1]>=PC_ENGINEER_MAXAMMO_NAIL/2 &&
							pBot->m_rgAmmo[weapon_defs[TF_WEAPON_RPG].iAmmo1]==PC_ENGINEER_MAXAMMO_ROCKET)
							continue;
					}
					if(!WaypointAvailable(WaypointFindNearest(pent->v.origin, 80, -1),UTIL_GetTeam(pBot->pEdict)))
						continue;			   
					can_pickup = TRUE;
				}

				// check if entity is the spot from RPG laser
				else if (strcmp("laser_spot", item_name) == 0)
				{
				}

				// check if entity is an armed tripmine
				else if (strcmp("monster_tripmine", item_name) == 0)
				{
					float distance = (pent->v.origin - pEdict->v.origin).Length( );

					if (pBot->b_see_tripmine)
					{
						// see if this tripmine is closer to bot...
						if (distance < (pBot->v_tripmine - pEdict->v.origin).Length())
						{
							pBot->v_tripmine = pent->v.origin;
							pBot->b_shoot_tripmine = FALSE;

							// see if bot is far enough to shoot the tripmine...
							if (distance >= 375)
							{
								pBot->b_shoot_tripmine = TRUE;
							}
						}
					}
					else
					{
						pBot->b_see_tripmine = TRUE;
						pBot->v_tripmine = pent->v.origin;
						pBot->b_shoot_tripmine = FALSE;

						// see if bot is far enough to shoot the tripmine...
						if (distance >= 375)  // 375 is damage radius
						{
							pBot->b_shoot_tripmine = TRUE;
						}
					}
				}

				// check if entity is an armed satchel charge
				else if (strcmp("monster_satchel", item_name) == 0)
				{
				}

				// check if entity is a snark (squeak grenade)
				else if (strcmp("monster_snark", item_name) == 0)
				{
				}

				else if ((mod_id == FRONTLINE_DLL) && (!pBot->defender) &&
					(strcmp("capture_point", item_name) == 0))
				{
					int team = UTIL_GetTeam(pEdict);  // skin and team must match

					if (flf_bug_fix)
						team = 1 - team;  // BACKWARDS bug!

					// check if flag not set and point not captured...
					if ((!pBot->b_use_capture) && (pent->v.skin == team))
					{
						float distance = (pent->v.origin - pEdict->v.origin).Length( );

						// check if close enough and facing it directly...
						if ((distance < FLF_PLAYER_SEARCH_RADIUS) &&
							(angle_to_entity <= 20))
						{
							pBot->b_use_capture = TRUE;
							pBot->f_use_capture_time = gpGlobals->time + 8.0;
							pBot->pCaptureEdict = pent;
						}

						// if close to capture point...
						if (distance < 160)
						{
							// don't avoid walls for a while
							pBot->f_dont_avoid_wall_time = gpGlobals->time + 5.0;
						}
						can_pickup = TRUE;
					}
				}

				//some neotf stuff here
				// check if entity is a weapon...
				if (strcmp("ntf_multigun", item_name) == 0)
				{
					if ((pent->v.effects & EF_NODRAW)==EF_NODRAW)					
						continue;
					if ((pent->v.flags & FL_KILLME)==FL_KILLME)				
						continue;
					if(pent->v.team==(UTIL_GetTeam(pEdict)+1))
						can_pickup = TRUE;
					else
					{
						char *cvar_ntf_capture_mg = (char *)CVAR_GET_STRING( "ntf_capture_mg" );
						if(strcmp(cvar_ntf_capture_mg,"1")==0)
							can_pickup = TRUE;
					}
				}

			}  // end if object is visible
		}  // end else not "func_" entity


		if (can_pickup) // if the bot found something it can pickup...
		{
			float distance = (entity_origin - pEdict->v.origin).Length( );

			// see if it's the closest item so far...
			if (distance < min_distance && (entity_origin.z>pEdict->v.origin.z-80)
				&& (entity_origin.z<pEdict->v.origin.z+80))
			{
				min_distance = distance;        // update the minimum distance
				pPickupEntity = pent;        // remember this entity
				pickup_origin = entity_origin;  // remember location of entity
			}
		}
	}  // end while loop

	if (pPickupEntity)
	{
		// let's head off toward that item...
		Vector v_item = pickup_origin - pEdict->v.origin;
		Vector bot_angles = UTIL_VecToAngles( v_item );
		pEdict->v.ideal_yaw = bot_angles.y;
		pEdict->v.idealpitch = bot_angles.x;
		BotFixIdealYaw(pEdict);
		pBot->pBotPickupItem = pPickupEntity;  // save the item bot is trying to get
	}
}

void BotThink( bot_t *pBot )
{
	//{ fp=fopen("bot.txt","w"); fprintf(fp, "1\n"); fclose(fp); }
	int index = 0;
	Vector v_diff;             // vector from previous to current location
	//float pitch_degrees, yaw_degrees;
	float moved_distance;      // length of v_diff vector (distance bot moved)
	TraceResult tr;
	bool found_waypoint, is_idle;   

	if(pBot->pBotEnemy && pBot->f_strafe!=3) pBot->f_strafe=1;
	pBot->f_side_speed = 0;
	edict_t *pEdict = pBot->pEdict;

	// Bots cant use the teleporters if they have the flag
	if((pBot->teleportInfo.pEntrance) && 
		(pBot->bot_has_flag || (pBot->teleportInfo.pEntrance->v.health <=0) || (pBot->teleportInfo.pExit->v.health <=0)))
	{
		memset(&(pBot->teleportInfo), 0, sizeof(pBot->teleportInfo));
		pBot->teleportInfo.pEntrance = NULL;
		pBot->goto_wp = -1;
	}

//update by yuraj - if is bot_can_use_teleporter false
	if((pBot->teleportInfo.pEntrance) && 
		(bot_can_use_teleporter==false || (pBot->teleportInfo.pEntrance->v.health <=0) || (pBot->teleportInfo.pExit->v.health <=0)))
	{
		memset(&(pBot->teleportInfo), 0, sizeof(pBot->teleportInfo));
		pBot->teleportInfo.pEntrance = NULL;
		pBot->goto_wp = -1;
	}

	// DrEvil Nade update, or toss a nade if threatlevel high enuff.
	if (BotAssessThreatLevel(pBot) > 50)
		BotNadeHandler(pBot, true, bot_t::Random);
	else
		BotNadeHandler(pBot, true, NULL);

	//////////////////////////
	// Engineer SG Rotation //
	//////////////////////////
	// check if I need to rotate it.
	if (!pBot->SGRotated && pBot->sg_edict && ((waypoints[pBot->sg_wp].flags & W_FL_TFC_DEFEND180)==W_FL_TFC_DEFEND180))
	{
		//UTIL_HostSay(pBot->pEdict, 0, "need to rotate");
		float sgDist = (pBot->sg_edict->v.origin - pBot->pEdict->v.origin).Length2D();
		if ((sgDist < 200) && (sgDist > 100))
		{			
			FakeClientCommand(pBot->pEdict, "rotatesentry180", NULL, NULL);
			pBot->SGRotated = true;
		}
	}	
	/////////////
	// ANTI FF //
	/////////////
	if (pBot->pBotEnemy && ((BotTeamColorCheck(pBot->pBotEnemy) == UTIL_GetTeam(pBot->pEdict)) || (pBot->pEdict->v.team == pBot->pBotEnemy->v.team)) && 
		(pBot->pEdict->v.playerclass != TFC_CLASS_MEDIC) && (pBot->pEdict->v.playerclass != TFC_CLASS_ENGINEER))
	{
		if (pBot->pBotEnemy->v.playerclass != TFC_CLASS_MEDIC)
			pBot->pBotEnemy = NULL;
	}
	/////////////
	// RJ SHIT //
	/////////////
	if (pBot->RJ_checkTime < gpGlobals->time && (pBot->pEdict->v.playerclass == TFC_CLASS_SOLDIER) || 
		(pBot->pEdict->v.playerclass == TFC_CLASS_PYRO) || (pBot->pEdict->v.playerclass == TFC_CLASS_SPY))
		BotCheckForJump(pBot);      

	/////////////
	// CJ SHIT //
	/////////////
	if (pBot->RJ_checkTime < gpGlobals->time && (pBot->pEdict->v.playerclass == TFC_CLASS_MEDIC) || (pBot->pEdict->v.playerclass == TFC_CLASS_SCOUT))
		BotCheckForConcJump(pBot);   

	pEdict->v.flags |= FL_FAKECLIENT;

	if (pBot->name[0] == 0)  // name filled in yet?
		strcpy(pBot->name, STRING(pBot->pEdict->v.netname));

	//////////////////
	// DETPIPE SHIT //
	//////////////////	
	edict_t *pPlayer, *theDemo = 0;
	enum TrapType { NoType, Pipebombs, Mine, Proximity };
	if (pipeCheckFrame == 0)
	{		
		for (int i = 1; i <= 32; i++)
		{		
			// Break if we have a det scheduled
			if (bots[i].detting)
				continue;			

			pPlayer = INDEXENT(i);
			if(!pPlayer)
				continue;

			// Check for pipes around this player.
			edict_t *pent = NULL;
			int closePipes = 0;
			int TType = NoType;
			while ((pent = FIND_ENTITY_IN_SPHERE(pent, pPlayer->v.origin, 120 )) != NULL && (!FNullEnt(pent)))
			{
				// Look for pipebombs
				if (strcmp(STRING(pent->v.classname),"tf_gl_pipebomb")==0)
				{			
					// skip everything if its us near the pipes
					if (pPlayer == pent->v.owner)
						continue;
					
					if ((UTIL_GetTeamColor(pent->v.owner)==UTIL_GetTeam(pPlayer)) ||
						team_allies[UTIL_GetTeam(pent->v.owner)] & (1<<UTIL_GetTeam(pPlayer)))
						continue;

					if (UTIL_GetTeam(pent->v.owner)==UTIL_GetTeam(pPlayer) ||
						(team_allies[UTIL_GetTeam(pent->v.owner)] & (1<<UTIL_GetTeam(pPlayer))))
						continue;

					TType = Pipebombs;
					closePipes++;
					if (closePipes > 1)
					{
						theDemo = pent->v.owner;
						break;
					}
				}		
			} 
			if (theDemo && TType==Pipebombs)
			{			
				bot_t *demoBot = 0;
				// Try to match the demoBot with a bot
				for (int z = 0; z < 32; z++)
				{
					if (bots[z].is_used && (bots[z].pEdict == theDemo))
						demoBot = &bots[z];
				}
				// Wasn't a bot, so break from the loop
				if (!demoBot)
					continue;
				// Teammates dont set off.
				if (UTIL_GetTeam(theDemo) == UTIL_GetTeam(pPlayer))
					continue;
				// Nor do spies, unless we have them as enemy.
				if (pPlayer->v.playerclass == TFC_CLASS_SPY && (demoBot->pBotEnemy != pPlayer))
					continue;	
				// Check for visibility
				if (!demoBot->detting && IsAlive(pPlayer) && FInViewCone(&pPlayer->v.origin, demoBot->pEdict) && FVisible(pPlayer->v.origin, demoBot->pEdict))
				{
					demoBot->detTime = gpGlobals->time + (demoBot->bot_skill * 0.75f) + RANDOM_LONG(0.5, 0.65);
					demoBot->detting = true;
					/*char msg[80];
					sprintf(msg, "someone near %d of my pipes : det time %f", closePipes, demoBot->detTime);
					UTIL_HostSay(theDemo, 0, msg);*/
				}
			}
		} 
	}
	pipeCheckFrame--;
	// test for detting
	if (pBot->detting && ((gpGlobals->time > pBot->detTime) || (pBot->pEdict->v.origin - waypoints[pBot->defendPoint].origin).Length() > 2000))
	{
		// Detpipe and reset states so he will be ready to lay another.
		FakeClientCommand(pEdict,"detpipe",NULL,NULL);
		pBot->detting = false;	
		pBot->pipeTime = gpGlobals->time + 9999;
		pBot->piped = false;
		pBot->piping = false;
	}

	///////////////////////////////////
	// Move if friendly sniper close //
	///////////////////////////////////
	if ((pBot->pEdict->v.playerclass == TFC_CLASS_SNIPER) && (pBot->goto_wp == pBot->snipePoint) && (pBot->curr_waypoint_index == pBot->snipePoint))
	{
		if (BotDefenderAtPoint(pBot, waypoints[pBot->goto_wp].origin, 70))
		{
			UTIL_HostSay(pEdict, 0, "moving close sniper");
			pBot->goto_wp = pBot->snipePoint = -1;
		}        
	}


	int j,k; //loop counters
	char buffa[255];
	char buffb[255];
	char cmd[255];

	//RedFox bot coms
	if(pBot->newmsg && (pBot->f_sound_update_time <= gpGlobals->time))
	{
		pBot->newmsg=false;
		strcpy(buffa,pBot->message);
		k=1;
		while(k!=0)
		{
			// remove start spaces
			j=0;
			while(buffa[j]==' ' || buffa[j]=='/n')
			{
				j++;
			}
			k=0;
			while(buffa[j]!=' ' && buffa[j]!=NULL && buffa[j]!='\n')
			{
				cmd[k]=buffa[j];
				buffa[j]=' ';
				j++;
				k++;
			}
			cmd[k]=NULL;
			strcpy(buffb,cmd);			
			if((stricmp("changeclass",cmd)==0) || (stricmp("changeclassnow",cmd)==0))
			{				
				// Check if this message is from another player on our team.
				char fromName[255] = { 0 };
                if(_strnicmp("(TEAM)",pBot->message+1,6)==0)
					strcpy(fromName, (pBot->message+8));
				else
					strcpy(fromName, pBot->message);

				int counter = 0;
				// Pull the name out of the message.
				while (true)
				{
					if (fromName[counter] == ':' && fromName[counter+1] == ' ')
					{
						fromName[counter] = NULL;
						break;
					}
					counter++;
				}				

				// Get the class from the command line.
				char theClass = pBot->message[strlen(pBot->message)-2];
				if (theClass != NULL && strchr("123456789", theClass))
				{
					int iClass = atoi(&theClass);
					if (BotChangeClass(pBot, iClass, fromName))
					{
						UTIL_HostSay(pBot->pEdict, 1, "Roger");
						if (stricmp("changeclassnow",cmd)==0)
							FakeClientCommand(pBot->pEdict, "kill", NULL, NULL);
					}
				}
			}
			if((stricmp("changerole",cmd)==0) || (stricmp("changerolenow",cmd)==0))
			{
				// Check if this message is from another player on our team.
				char fromName[255] = { 0 };
				if(_strnicmp("(TEAM)",pBot->message+1,6)==0)
					strcpy(fromName, (pBot->message+8));
				else
					strcpy(fromName, pBot->message);

				int counter = 0;
				// Pull the name out of the message.
				while (true)
				{
					if (fromName[counter] == ':' && fromName[counter+1] == ' ')
					{
						fromName[counter] = NULL;
						break;
					}
					counter++;
				}		
				BotChangeRole(pBot, pBot->message, fromName);
			}
			if(stricmp("follow",cmd)==0)
			{
				//UTIL_HostSay(pEdict, 0, "Follow mode");
				//pBot->follow=true;
				//pBot->ras=true;
				//pBot->track_player=NULL;
				//pBot->track_ttime=gpGlobals->time;
			}
			if(stricmp("die",cmd)==0)
			{
				EMIT_SOUND_DYN2(pBot->pEdict, CHAN_VOICE, "barney/c1a4_ba_octo4.wav", 0, 0, SND_STOP, PITCH_NORM);
				EMIT_SOUND_DYN2(pBot->pEdict, CHAN_VOICE, "barney/c1a4_ba_octo4.wav", 1.0,ATTN_NORM, 0, PITCH_NORM);
			}
			if(stricmp("roam",cmd)==0)
			{
				//UTIL_HostSay(pEdict, 0, "Roam mode");
				//pBot->follow=false;
				//pBot->track_player=NULL;
				//pBot->pBotEnemy=NULL;
			}
			if(stricmp("xmas",cmd)==0 && bot_xmas)
			{
				//TraceResult tr;
				short model;

				UTIL_MakeVectors( pEdict->v.v_angle );
				Vector vecDir = gpGlobals->v_forward;

				//UTIL_TraceLine( pEdict->v.origin, pEdict->v.origin+vecDir*256, dont_ignore_monsters, NULL, &tr);
				if(RANDOM_LONG(0,10)<5) model = PRECACHE_MODEL("models/presentlg.mdl");
				else model = PRECACHE_MODEL("models/presentsm.mdl");
				MESSAGE_BEGIN(MSG_PAS, SVC_TEMPENTITY, pEdict->v.origin);
				WRITE_BYTE(TE_EXPLODEMODEL);
				WRITE_COORD(pEdict->v.origin.x);
				WRITE_COORD(pEdict->v.origin.y);
				WRITE_COORD(pEdict->v.origin.z);
				WRITE_COORD(RANDOM_LONG(100,1000));
				WRITE_SHORT(model);
				WRITE_SHORT(RANDOM_LONG(2,6)); 
				WRITE_BYTE(RANDOM_LONG(20,60));
				MESSAGE_END();
				if(RANDOM_LONG(0,100)<=50)
				{
					EMIT_SOUND_DYN2(pBot->pEdict, CHAN_VOICE, "misc/b2.wav", 1.0, ATTN_NORM, 0, 100);
				}
				else if(RANDOM_LONG(0,100)<=50)
				{
					EMIT_SOUND_DYN2(pBot->pEdict, CHAN_VOICE, "misc/party2.wav", 1.0, ATTN_NORM, 0, 100);
				}
				else if(RANDOM_LONG(0,100)<=50)
				{
					EMIT_SOUND_DYN2(pBot->pEdict, CHAN_VOICE, "misc/party1.wav", 1.0, ATTN_NORM, 0, 100);
				}
			}

		}


	} // end of bot message handling   

	// TheFatal - START from Advanced Bot Framework (Thanks Rich!)

	// adjust the millisecond delay based on the frame rate interval...
	if (pBot->msecdel <= gpGlobals->time)
	{
		pBot->msecdel = gpGlobals->time + 0.5; //default 0.5
		if (pBot->msecnum > 0)
			pBot->msecval = 450.0/pBot->msecnum; 
		pBot->msecnum = 0;
	}
	else
		pBot->msecnum++;

	if (pBot->msecval < 1)    // don't allow msec to be less than 1...
		pBot->msecval = 1;

	if (pBot->msecval > 100)  // ...or greater than 100
		pBot->msecval = 100;

	// TheFatal - END

	pEdict->v.button = 0;
	pBot->f_move_speed = 0.0;

	// if the bot hasn't selected stuff to start the game yet, go do that...
	if (pBot->not_started==1)
	{
		pBot->f_duck_time=gpGlobals->time;
		pBot->backwards=false;
		pBot->f_strafe=1;
		pBot->sg_edict=NULL;
		pBot->SGRotated = false;
		//random start time for backwards check
		pBot->backwards_time=(gpGlobals->time)-RANDOM_FLOAT(0,30);
		BotStartGame( pBot );
		g_engfuncs.pfnRunPlayerMove( pEdict, pEdict->v.v_angle, 0.0,
			0, 0, pEdict->v.button, 0, pBot->msecval);

		return;
	}

	//my chat, bot has died
	//good idea to check for null...urg!
	// CHAT
	if (((RANDOM_LONG(1,100) <= 8)) &&
		pBot->killer_edict!=NULL && b_botchat)
	{
		int whine_index;
		bool used;
		int i, recent_count;
		char msg[255];
		pBot->b_bot_say_killed = FALSE;            
		recent_count = 0;
		if(pBot->killer_edict->v.frags>pEdict->v.frags)
		{
			while (recent_count < 5)
			{
				whine_index = RANDOM_LONG(0, die_lo_count-1);
				used = FALSE;
				for (i=0; i < 5; i++)
				{
					if (recent_bot_die_lo[i] == whine_index)
						used = TRUE;
				}

				if (used)
					recent_count++;
				else
					break;
			}

			for (i=4; i > 0; i--)
				recent_bot_die_lo[i] = recent_bot_die_lo[i-1];
			recent_bot_die_lo[0] = whine_index;
			if (strstr(bot_die_lo[whine_index], "%s") != NULL)  // is "%s" in whine text?
				snprintf(msg,250, bot_die_lo[whine_index], STRING(pBot->killer_edict->v.netname));
			else
				snprintf(msg,250, bot_die_lo[whine_index]);
		}
		else
		{
			while (recent_count < 5)
			{
				whine_index = RANDOM_LONG(0, die_hi_count-1);
				used = FALSE;
				for (i=0; i < 5; i++)
				{
					if (recent_bot_die_hi[i] == whine_index)
						used = TRUE;
				}

				if (used)
					recent_count++;
				else
					break;
			}

			for (i=4; i > 0; i--)
				recent_bot_die_hi[i] = recent_bot_die_hi[i-1];
			recent_bot_die_hi[0] = whine_index;
			if (strstr(bot_die_hi[whine_index], "%s") != NULL)  // is "%s" in whine text?
				snprintf(msg,250, bot_die_hi[whine_index], STRING(pBot->killer_edict->v.netname));
			else
				snprintf(msg,250, bot_die_hi[whine_index]);
		}
		UTIL_HostSay(pEdict, 0, msg);
		if(bot_xmas && RANDOM_LONG(1,100) <= 30 && pBot->killer_edict!=NULL) 
		{
			strcpy(pBot->message,"xmas");
			pBot->newmsg=true;
		}
		pBot->killer_edict=NULL;
	}
	else if(RANDOM_LONG(1,100) <= 30) 
	{
		if(bot_xmas && RANDOM_LONG(1,100) <= 30 && pBot->killer_edict!=NULL) 
		{
			strcpy(pBot->message,"xmas");
			pBot->newmsg=true;
		}
		pBot->killer_edict=NULL;
	}

	// haha I killed you messages

	if (((RANDOM_LONG(1,100) <= 9)) && pBot->killed_edict!=NULL  && b_botchat)
	{
		int whine_index;
		bool used;
		int i, recent_count;
		char msg[255];
		recent_count = 0;
		if(pBot->killed_edict->v.frags>pEdict->v.frags)
		{
			while (recent_count < 5)
			{
				whine_index = RANDOM_LONG(0, kill_lo_count-1);
				used = FALSE;
				for (i=0; i < 5; i++)
				{
					if (recent_bot_kill_lo[i] == whine_index)
						used = TRUE;
				}

				if (used)
					recent_count++;
				else
					break;
			}

			for (i=4; i > 0; i--)
				recent_bot_kill_lo[i] = recent_bot_kill_lo[i-1];
			recent_bot_kill_lo[0] = whine_index;
			if (strstr(bot_kill_lo[whine_index], "%s") != NULL)  // is "%s" in whine text?
				snprintf(msg,250, bot_kill_lo[whine_index], STRING(pBot->killed_edict->v.netname));
			else
				snprintf(msg,250, bot_kill_lo[whine_index]);
		}
		else
		{
			while (recent_count < 5)
			{
				whine_index = RANDOM_LONG(0, kill_hi_count-1);
				used = FALSE;
				for (i=0; i < 5; i++)
				{
					if (recent_bot_kill_hi[i] == whine_index)
						used = TRUE;
				}

				if (used)
					recent_count++;
				else
					break;
			}

			for (i=4; i > 0; i--)
				recent_bot_kill_hi[i] = recent_bot_kill_hi[i-1];
			recent_bot_kill_hi[0] = whine_index;
			if (strstr(bot_kill_hi[whine_index], "%s") != NULL)  // is "%s" in whine text?
				snprintf(msg,250, bot_kill_hi[whine_index], STRING(pBot->killed_edict->v.netname));
			else
				snprintf(msg,250, bot_kill_hi[whine_index]);
		}
		UTIL_HostSay(pEdict, 0, msg);
		if(bot_xmas && RANDOM_LONG(1,100) <= 30 && pBot->killed_edict!=NULL) 
		{
			strcpy(pBot->message,"xmas");
			pBot->newmsg=true;
		}
		pBot->killed_edict=NULL;
	}
	else if(RANDOM_LONG(1,100) <= 30) 
	{
		if(bot_xmas && RANDOM_LONG(1,100) <= 30 && pBot->killed_edict!=NULL) 
		{
			strcpy(pBot->message,"xmas");
			pBot->newmsg=true;
		}
		pBot->killed_edict=NULL;
	}
	// if the bot is dead, randomly press fire to respawn...
	//FILE *fp;
	//{ fp=fopen("bot.txt","a"); fprintf(fp,"name %s, flags %x, health %f\n",STRING(pEdict->v.netname),pEdict->v.deadflag,pEdict->v.health); fclose(fp); }
	//{ fp=fopen("bot.txt","a"); fprintf(fp,"%d\n",pEdict->v.flags); fclose(fp); }
	if ((pEdict->v.health < 1) || (pEdict->v.deadflag != DEAD_NO) || pEdict->v.playerclass==0)
	{
		if(pBot->bot_start2>0 && pBot->bot_start3==0) pBot->bot_start3=gpGlobals->time;
		if(pBot->bot_start3<gpGlobals->time-6 && pBot->bot_start3!=0) 
		{
			//char msg[255];
			//sprintf(msg," problem wif join, changing team..class t= %d c= %d",pBot->bot_team,pBot->bot_class);
			//UTIL_HostSay(pEdict, 0, msg);
			if(pBot->bot_start2>1)
			{
				pBot->bot_team = 5;
				pBot->bot_class = -1;
			}
			pBot->not_started=1; 
			pBot->bot_start2++;
			pBot->bot_start3=0;
			if (mod_id == TFC_DLL)
				pBot->start_action = MSG_TFC_IDLE;
			else if (mod_id == CSTRIKE_DLL)
				pBot->start_action = MSG_CS_IDLE;
			else if ((mod_id == GEARBOX_DLL) && (pent_info_ctfdetect != NULL))
				pBot->start_action = MSG_OPFOR_IDLE;
			else if (mod_id == FRONTLINE_DLL)
				pBot->start_action = MSG_FLF_IDLE;
			else
				pBot->start_action = 0;  // not needed for non-team MODs
			pBot->create_time = gpGlobals->time;
		}
		if (pBot->need_to_initialize)
		{
			//ok, flag dropped code here?
			//dropped flag code (is dead, not capped)
			//also, did the flag drop to the ground?!
			// && !IsAlive(pEdict)
			//goal_activation(choices) : "Goal Activation bitfields" : 1 =
			//8 : "8 - return upon death-drop"
			//TFGI_RETURN_DROP
			//slight problem, what if we kicked the bot (and it had the flag)
			//gets an overflow cus of sending the message
			///*
			if(pBot->bot_has_flag)
			{
				bool f=false;
				edict_t *pent;
				pent = NULL; 
				while ((pent = FIND_ENTITY_BY_CLASSNAME( pent, "item_tfgoal" )) != NULL &&
					(!FNullEnt(pent))) 
				{  
					//char ss[255];
					//sprintf(ss,"item_tfgoal- %f %d %d",(pent->v.origin - pEdict->v.origin).Length(),pBot->flag_impulse,pent->v.impulse);
					//UTIL_HostSay(pBot->pEdict, 0, ss);
					float ll = (pent->v.origin - pEdict->v.origin).Length();
					if(ll>0 && ll<64 && pBot->flag_impulse==pent->v.impulse)
					{
						f=true;
						break;
					}
				}
				if(!f)
				{
					pent=NULL;
					while ((pent = FIND_ENTITY_BY_CLASSNAME( pent, "info_tfgoal" )) != NULL &&
						(!FNullEnt(pent))) 
					{  
						//char ss[255];
						//sprintf(ss,"info_tfgoal- %f %d %d",(pent->v.origin - pEdict->v.origin).Length(),pBot->flag_impulse,pent->v.impulse);
						//UTIL_HostSay(pBot->pEdict, 0, ss);
						float ll=(pent->v.origin - pEdict->v.origin).Length();
						if(ll>0 && ll<64 && pBot->flag_impulse==pent->v.impulse)
						{
							f=true;
							break;
						}
					}
				}
				if(f)
				{
					//moved from flag check code.
					//record where the bot currently is!
					//this is better than checking when they die or somthing
					//cus they may be between areas

					///*
					for (int i=0; i < num_areas; i++)
					{
						//checks only for whole area delete.....
						if ((areas[i].flags & W_FL_DELETED) == W_FL_DELETED)
							continue;
						if(AreaInsideClosest(pBot->pEdict)==i) 
							pBot->curr_area=i;
					}//*/
					int a=pBot->curr_area;
					if((a != -1) && offensive_chatter)
					{
						char ss[255];
						int t=UTIL_GetTeam(pBot->pEdict);
						if(t==0) sprintf(ss,"Flag dropped %s",areas[a].namea);
						if(t==1) sprintf(ss,"Flag dropped %s",areas[a].nameb);
						if(t==2) sprintf(ss,"Flag dropped %s",areas[a].namec);
						if(t==3) sprintf(ss,"Flag dropped %s",areas[a].named);
						UTIL_HostSay(pBot->pEdict,1, ss);
						//ok, now we have to let other bots know that theirs a new location for da flag..
						//remeber their may be more than 1 flag
						int i;
						int tm;
						tm=UTIL_GetTeam(pEdict);
						i=0;
						//check t, just in case!
						if(tm!=-1)
						{
							while(i<32)
							{
								if(drop_flag[i][tm]==-1)
								{
									drop_flag[i][tm]=WaypointFindNearest(pEdict,200,tm);
									drop_flage[i][tm]=pent;
									i=32; //exit the loop
								}
								i++;
							}
						}
					}
					else
					{
						//UTIL_HostSay(pBot->pEdict, 0, "Drop, no area");
						//get bots to go for flag
						//no zone defs, so no notify
						//is this a problem?
						int i = 0;
						int tm = UTIL_GetTeam(pEdict);
						//check t, just in case!
						if(tm != -1)
						{
							while(i<32)
							{
								if(drop_flag[i][tm]==-1)
								{
									drop_flag[i][tm]=WaypointFindNearest(pEdict,200,tm);
									drop_flage[i][tm]=pent;
									//char ss[255];
									//sprintf(ss,"%d %d %d\n",drop_flag[i][tm],i,tm);
									//UTIL_HostSay(pBot->pEdict, 0, ss);
									i=32; //exit the loop
								}
								i++;
							}
						}
					}
				}
			}//*/
			BotSpawnInit(pBot);

			pBot->need_to_initialize = FALSE;
		}
		pBot->f_duck_time=gpGlobals->time;
		pBot->backwards=false;
		pBot->f_strafe=1;
		//bool crsh=false;
		//{ fp=fopen("bot.txt","a"); fprintf(fp,"pEdict %x\nx %f y %f z %f\nspeed %f\nbutton %d\nmsec %f\n name %s\n",pEdict,pEdict->v.v_angle.x,pEdict->v.v_angle.y,pEdict->v.v_angle.z,pBot->f_move_speed,pEdict->v.button,pBot->msecval,pBot->name); fclose(fp); }
		//wait 1 second before trying to respawn..
		pBot->f_move_speed=0;
		if (RANDOM_LONG(1, 100) > 50 && (pBot->kill_time + 1) < gpGlobals->time)
		{
			//{ fp=fopen("bot.txt","a"); fprintf(fp,"(1)pEdict %x\nx %f y %f z %f\nspeed %f\nbutton %d\nmsec %f\n name %s\n",pEdict,pEdict->v.v_angle.x,pEdict->v.v_angle.y,pEdict->v.v_angle.z,pBot->f_move_speed,pEdict->v.button,pBot->msecval,pBot->name); fclose(fp); }
			pEdict->v.button = IN_ATTACK;
			pBot->kill_time = gpGlobals->time;
			//crsh=true;
		}
		g_engfuncs.pfnRunPlayerMove( pEdict, pEdict->v.v_angle, pBot->f_move_speed,
			0, 0, pEdict->v.button, 0, pBot->msecval);

		//if(crsh)
		//{ fp=fopen("bot.txt","a"); fprintf(fp,"returned ok(1)..\n"); fclose(fp); }
		//{ fp=fopen("bot.txt","a"); fprintf(fp,"returned ok..\n"); fclose(fp); }
		return;
	}
	//save the bots team/class, so next time it spawns (new lev, lev change etc)
	//its the same..
	if(pBot->bot_start2>0)
	{
		for (int index = 0; index < 32; index++)
		{
			if (bots[index].pEdict==pBot->pEdict) 
			{
				b_team[index]=bots[index].bot_team;
				b_class[index]=bots[index].bot_class;
			}
		}
	}
	pBot->bot_start2=0;
	pBot->bot_start3=0;

	// set this for the next time the bot dies so it will initialize stuff
	if (pBot->need_to_initialize == FALSE)
	{
		pBot->need_to_initialize = TRUE;
		pBot->f_bot_spawn_time = gpGlobals->time;
	}

	is_idle = FALSE;

	if ((mod_id == FRONTLINE_DLL) && (pBot->round_end))
	{
		if (pBot->warmup)  // has warmup started (i.e. start of round?)
		{
			pBot->round_end = 0;

			BotSpawnInit(pBot);
		}

		is_idle = TRUE;

		flf_bug_fix = 0;  // BACKWARDS bug off now!
	}

	if ((mod_id == FRONTLINE_DLL) && (pBot->warmup) && (!pBot->defender))
	{
		if (pBot->curr_waypoint_index == -1)
		{
			// find the nearest visible waypoint
			int i = WaypointFindNearest(pEdict, REACHABLE_RANGE, pBot->defender);

			if (i != -1)
			{
				Vector v_direction = waypoints[i].origin - pEdict->v.origin;

				Vector bot_angles = UTIL_VecToAngles( v_direction );

				pBot->idle_angle = bot_angles.y;
			}
			else
				pBot->idle_angle = pEdict->v.v_angle.y;
		}

		is_idle = TRUE;
	}

	if (pBot->blinded_time > (gpGlobals->time+60))
		pBot->blinded_time = gpGlobals->time-1;
	if (pBot->blinded_time > gpGlobals->time)
	{
		is_idle = TRUE;  // don't do anything while blinded
	}

	if (is_idle)
	{
		if (pBot->idle_angle_time <= gpGlobals->time)
		{
			pBot->idle_angle_time = gpGlobals->time + RANDOM_FLOAT(0.5, 2.0);

			pEdict->v.ideal_yaw = pBot->idle_angle + RANDOM_FLOAT(0.0, 40.0) - 20.0;

			BotFixIdealYaw(pEdict);
		}

		// turn towards ideal_yaw by yaw_speed degrees (slower than normal)
		BotChangeYaw( pBot, pEdict->v.yaw_speed / 2 );
		//UTIL_HostSay(pBot->pEdict,0,"a");

		g_engfuncs.pfnRunPlayerMove( pEdict, pEdict->v.v_angle, pBot->f_move_speed,
			0, 0, pEdict->v.button, 0, pBot->msecval);

		return;
	}
	else
	{
		//pBot->idle_angle = pEdict->v.v_angle.y;
	}
	//clear sg bool
	if(mod_id==TFC_DLL && pEdict->v.playerclass != TFC_CLASS_ENGINEER)   
		pBot->sg=false;

	//{ fp=fopen("bot.txt","a"); fprintf(fp, "a\n"); fclose(fp); }
	//greetings from your bot!
	if(pBot->greeting==false &&
		pBot->f_bot_spawn_time <= gpGlobals->time-1)
	{	
		if(b_botchat)
		{
			char msg[255];
			int greet_index;
			greet_index = RANDOM_LONG(0, greet_count-1);
			snprintf(msg,250, bot_greet[greet_index]);
			//sprintf(msg,"c %d h %d f %d",pEdict->v.playerclass,pEdict->v.health,pEdict->v.spawnflags);
			UTIL_HostSay(pEdict, 0, msg);
		}
		pBot->greeting=true;
		if(bot_xmas) 
		{
			strcpy(pBot->message,"xmas");
			pBot->newmsg=true;
		}
	}

	//tracking of player setup.
	//must ras if tracking
	if(pBot->track_player!=NULL && pBot->pBotEnemy==NULL)
		pBot->ras=true;

	//flag detect code thanks to botman :)
	//dropped flag in area
	// and sg check code here aswell!
	edict_t *pent = NULL; 
	if(pBot->f_flag_check_time<=gpGlobals->time && mod_id==TFC_DLL)
	{
		bool f;
		if(pBot->bot_has_flag==false) f=true;
		else f=false;
		pBot->bot_has_flag = FALSE;    //clear it unless we know we have it
		pBot->flag_impulse=-1;
		while ((pent = FIND_ENTITY_BY_CLASSNAME( pent, "item_tfgoal" )) != NULL &&
			(!FNullEnt(pent))) 
		{  
			if (pent->v.owner == pEdict)  // is this bot carrying the item? 
			{ 
				// we are carrying the flag/card/ball 

				if(f) 
				{
					if(bot_xmas) 
					{
						pBot->newmsg=true;
						strcpy(pBot->message,"xmas");
					}
					if (RANDOM_LONG(1, 100) <= 20)
						BotSprayLogo(pEdict);
					pBot->goto_wp=-1;
					pBot->pBotEnemy=NULL;
					pBot->pBotPickupItem=NULL;
				}
				pBot->flag_impulse=pent->v.impulse;
				pBot->bot_has_flag = true; 
				pBot->follow=false;
				pBot->ras=true;

				break;  // break out of while loop 
			} 
		}
		//reset the check for flag time
		pBot->f_flag_check_time=gpGlobals->time+0.5;
	}

	if(pBot->clearenemy==true && (pEdict->v.health > 30)) 
	{
		//stop following the medic! (or any one else)
		pBot->pBotEnemy=NULL;
		pBot->clearenemy=false;
	}

	//put it here so we can do duck jumps :D
	if (pBot->f_duck_time > gpGlobals->time) pEdict->v.button |= IN_DUCK;  // duck down while moving forward

	// check if time to check for player sounds (if don't already have enemy)
	if ((pBot->f_sound_update_time <= gpGlobals->time) &&
		(pBot->pBotEnemy == NULL))
	{
		//int ind;
		//edict_t *pPlayer;

		pBot->f_sound_update_time = gpGlobals->time + 1.0;

		//could shout for medic here
		if (((mod_id == TFC_DLL) && (pEdict->v.playerclass != TFC_CLASS_MEDIC) && 
			(pEdict->v.health < 50) && (RANDOM_LONG(1,100) <= 30)))
		{
			FakeClientCommand(pEdict, "saveme", NULL, NULL);			
			pBot->ras=true;
			//now find nearest medic....and make them enemy
			if(!pBot->pBotEnemy)
			{
				// search the world for players...
				for (int i = 1; i <= gpGlobals->maxClients; i++)
				{
					edict_t *pPlayer = INDEXENT(i);

					// skip invalid players and skip self (i.e. this bot)
					if ((pPlayer) && (!pPlayer->free) && (pPlayer != pEdict))
					{
						// skip this player if not alive (i.e. dead or dying)
						if (!IsAlive(pPlayer))
							continue;

						if ((b_observer_mode) && !((pPlayer->v.flags & FL_FAKECLIENT)==FL_FAKECLIENT))
							continue;

						if (pPlayer->v.playerclass!=TFC_CLASS_MEDIC)
							continue;

						int player_team = UTIL_GetTeam(pPlayer);
						int bot_team = UTIL_GetTeam(pEdict);

						// don't target your enemies...
						if ((bot_team != player_team) && !(team_allies[bot_team] & (1<<player_team)))
							continue;

						Vector vecEnd = pPlayer->v.origin + pPlayer->v.view_ofs;

						// see if bot can see the player...
						//and it is/looks like a medic
						if (FInViewCone( &vecEnd, pEdict ) && FVisible( vecEnd, pEdict ))
						{
							float distance = (pPlayer->v.origin - pEdict->v.origin).Length();
							if (distance < 600)
							{
								pBot->pBotEnemy=pPlayer;
								pBot->ras=false;
								pBot->clearenemy=true;
								continue;
							}
						}
					}
				}
			}
		}
	}

	pBot->f_move_speed = pBot->f_max_speed;  // set to max speed

	if (pBot->prev_time <= gpGlobals->time)
	{
		// see how far bot has moved since the previous position...
		v_diff = pBot->v_prev_origin - pEdict->v.origin;
		moved_distance = ((int)v_diff.Length()); //convert to int, to get rid of tiny distances

		// save current position as previous
		pBot->v_prev_origin = pEdict->v.origin;
		pBot->prev_time = gpGlobals->time + 0.4; //normally 0.2
	}
	else
	{
		moved_distance = 2.0;
	}
	if (b_botdontshoot == 0)
	{
		if ((mod_id == TFC_DLL) && (pBot->bot_has_flag == TRUE) &&
			pBot->pBotEnemy==NULL)
		{
			// is it time to check whether bot should look for enemies yet?
			if (pBot->f_bot_find_enemy_time <= gpGlobals->time || pBot->f_take_damage)
			{
				pBot->f_bot_find_enemy_time = gpGlobals->time + 1.0;
				pBot->pBotEnemy = BotFindEnemy( pBot );

				edict_t *pNewEnemy = NULL;
				pent=NULL;

				float nearestdistance;
				Vector vecEnd;
				nearestdistance=9999;
				while ((pent = FIND_ENTITY_BY_CLASSNAME( pent, "building_sentrygun" )) != NULL && (!FNullEnt(pent)))
				{
					int sentry_team = BotTeamColorCheck(pent);
					int bot_team = UTIL_GetTeam(pEdict);

					// don't target your own team's sentry guns...
					if (bot_team == sentry_team)				   
						continue;

					// don't target your allie's sentry guns either...
					if (team_allies[bot_team] & (1<<sentry_team))
						continue;

					vecEnd = pent->v.origin + pent->v.view_ofs;

					// is this sentry gun visible?
					if (FInViewCone( &vecEnd, pEdict ) && FVisible( vecEnd, pEdict ))
					{
						float distance = (pent->v.origin - pEdict->v.origin).Length();
						// is this the closest sentry gun?
						if (distance < nearestdistance)
						{
							nearestdistance = distance;
							pNewEnemy = pent;
							pBot->pBotUser = NULL;  // don't follow user when enemy found
							BotSGSpotted(pBot, pent);
						}
					}
				}
				if(pNewEnemy!=NULL) 
				{
					pBot->pBotEnemy=pNewEnemy;
					pBot->pBotEnemy = BotFindEnemy( pBot );
				}
			}
		}
		else
		{			  
			pBot->pBotEnemy = BotFindEnemy( pBot );
		}
	}
	else
		pBot->pBotEnemy = NULL;  // clear enemy pointer (no ememy for you!)
	//working here 

	if (pBot->pBotEnemy != NULL)  // does an enemy exist?
	{
		BotShootAtEnemy( pBot );  // shoot at the enemy

		// strafing??
		//can we get the bot to strafe whilest fighting?
		if ( BotCheckWallOnRight (pBot))
			pBot->f_side_direction = false;
		if ( BotCheckWallOnLeft (pBot))
			pBot->f_side_direction = true;
		if (RANDOM_LONG(1, 1000) <= 50)
		{
			if(pBot->f_side_direction)
				pBot->f_side_direction = false;
			else
				pBot->f_side_direction = true;
		}
		if(pBot->f_strafe==1)
		{
			if(pBot->f_side_direction)
				pBot->f_side_speed = pBot->f_max_speed;
			else
				pBot->f_side_speed = -(pBot->f_max_speed);
		}
		if(pBot->f_strafe==2)
		{
			if(pBot->f_side_direction)
				pBot->f_side_speed = pBot->f_max_speed/4;
			else
				pBot->f_side_speed = -(pBot->f_max_speed/4);
		}
		if(pEdict->v.playerclass == TFC_CLASS_SNIPER && pBot->current_weapon.iId == TF_WEAPON_SNIPERRIFLE &&
			pBot->pBotEnemy!=NULL && !pBot->bot_has_flag) // && !pBot->ras
		{
			//if were not in attack, strafe a bit slower
			if(!(pEdict->v.button & IN_ATTACK)==IN_ATTACK && !pBot->ras)
			{
				if(pBot->f_side_direction)
					pBot->f_side_speed = pBot->f_max_speed/4;
				else
					pBot->f_side_speed = -(pBot->f_max_speed/4);
				//go half speed forwards..asuming we've already set the forward speed
				//nope..stop moving forward..we don't if we're sniping
				pBot->f_move_speed=0;
			}
			if (pBot->f_pause_time > gpGlobals->time &&
				pBot->f_snipe_time > gpGlobals->time)  // is bot "paused"?
			{
				// you could make the bot look left then right, or look up
				// and down, to make it appear that the bot is hunting for
				// something (don't do anything right now)
				pBot->f_side_speed=0;
				pBot->f_move_speed=0;
				//just in case....dam timer vars
				if(pBot->f_pause_time>(gpGlobals->time)+100) pBot->f_pause_time=0;
			}
		}
		else
			pBot->f_pause_time = 0;  // dont't pause if enemy exists
	}

	else if (pBot->f_pause_time > gpGlobals->time)  // is bot "paused"?
	{
		// you could make the bot look left then right, or look up
		// and down, to make it appear that the bot is hunting for
		// something (don't do anything right now)
		pBot->f_side_speed=0;
		pBot->f_move_speed=0;
		//just in case....dam timer vars
		if(pBot->f_pause_time>(gpGlobals->time)+100) pBot->f_pause_time=0;
	}

	// is bot being "used" and can still follow "user"?
	else if ((pBot->pBotUser != NULL) && BotFollowUser( pBot ))
	{
		// do nothing here!

	}

	//will bot now turn and face attacker?
	else
	{

		// check if bot should look for items now or not...
		//don't pickup stuff if doing something special
		if (pBot->f_find_item < gpGlobals->time && pBot->inact==0)
		{
			BotFindItem( pBot );  // see if there are any visible items
		}

		// check if should use wall mounted health station...
		if (pBot->b_use_health_station)
		{
			if ((pBot->f_use_health_time + 10.0) > gpGlobals->time)
			{
				pBot->f_move_speed = 0;  // don't move while using health station

				pEdict->v.button = IN_USE;
			}
			else
			{
				// bot is stuck trying to "use" a health station...
				pBot->b_use_health_station = FALSE;
				// don't look for items for a while since the bot
				// could be stuck trying to get to an item
				pBot->f_find_item = gpGlobals->time + 1;
			}
		}

		// check if should use wall mounted HEV station...
		else if (pBot->b_use_HEV_station)
		{
			if ((pBot->f_use_HEV_time + 10.0) > gpGlobals->time)
			{
				pBot->f_move_speed = 0;  // don't move while using HEV station
				pEdict->v.button = IN_USE;
			}
			else
			{
				// bot is stuck trying to "use" a HEV station...
				pBot->b_use_HEV_station = FALSE;
				// don't look for items for a while since the bot
				// could be stuck trying to get to an item
				pBot->f_find_item = gpGlobals->time + 1;
			}
		}

		// check if should capture a point by using it...
		else if (pBot->b_use_capture)
		{
			int team = UTIL_GetTeam(pEdict);  // skin and team must match

			if (flf_bug_fix)
				team = 1 - team;  // BACKWARDS bug fix!

			// still capturing and hasn't captured yet...
			if ((pBot->f_use_capture_time > gpGlobals->time) &&
				(pBot->pCaptureEdict->v.skin == team))
			{
				pBot->f_move_speed = 0;  // don't move while capturing

				pEdict->v.button = IN_USE;
			}
			else
			{
				// bot is stuck trying to "use" a capture point...

				pBot->b_use_capture = FALSE;

				// don't look for items for a while since the bot
				// could be stuck trying to get to an item
				pBot->f_find_item = gpGlobals->time + 1;
			}
		}

		else if (pBot->b_use_button)
		{
			//deal with push/shoot buttons
			if(pBot->pBotPickupItem!=NULL)
			{
				if((pBot->pBotPickupItem->v.spawnflags & 256)!=256) pBot->f_move_speed = 0;  // don't move while using elevator
			}
			else
				pBot->f_move_speed = 0;  // don't move while using elevator

			BotUseLift( pBot, moved_distance );
		}

		else
		{
			if (pEdict->v.waterlevel == 3)  // check if the bot is underwater...
			{
				BotUnderWater( pBot );
				pBot->backwards=false;
			}

			//waypoint stuff
			found_waypoint = FALSE;

			// if the bot is not trying to get to something AND
			// it is time to look for a waypoint AND
			// there are waypoints in this level...

			if ((pBot->pBotPickupItem == NULL) && (pBot->f_look_for_waypoint_time <= gpGlobals->time) &&
				(num_waypoints != 0) && pBot->inact==0)
			{
				found_waypoint = BotHeadTowardWaypoint(pBot);
			}

			// check if the bot is on a ladder...
			if (pEdict->v.movetype == MOVETYPE_FLY)
			{
				pBot->backwards=false;
				// check if bot JUST got on the ladder...
				if ((pBot->f_end_use_ladder_time + 1.0) < gpGlobals->time)
					pBot->f_start_use_ladder_time = gpGlobals->time;

				// go handle the ladder movement
				BotOnLadder( pBot, moved_distance );

				pBot->f_dont_avoid_wall_time = gpGlobals->time + 2.0;
				pBot->f_end_use_ladder_time = gpGlobals->time;
			}
			else
			{
				// check if the bot JUST got off the ladder...
				if ((pBot->f_end_use_ladder_time + 1.0) > gpGlobals->time)
				{
					pBot->ladder_dir = LADDER_UNKNOWN;
				}
			}

			// if the bot isn't headed toward a waypoint...
			if (found_waypoint == FALSE)
			{
				TraceResult tr;

				// check if we should be avoiding walls
				if (pBot->f_dont_avoid_wall_time <= gpGlobals->time)
				{
					// let's just randomly wander around
					if (BotStuckInCorner( pBot ))
					{
						pEdict->v.ideal_yaw += 180;  // turn 180 degrees

						BotFixIdealYaw(pEdict);

						pBot->f_move_speed = 0;  // don't move while turning
						pBot->f_dont_avoid_wall_time = gpGlobals->time + 1.0;

						moved_distance = 2.0;  // dont use bot stuck code
					}
					else
					{
						// check if there is a wall on the left...
						if (!BotCheckWallOnLeft( pBot ))
						{
							// if there was a wall on the left over 1/2 a second ago then
							// 20% of the time randomly turn between 45 and 60 degrees

							if ((pBot->f_wall_on_left != 0) &&
								(pBot->f_wall_on_left <= gpGlobals->time - 0.5) &&
								(RANDOM_LONG(1, 100) <= 20))
							{
								pEdict->v.ideal_yaw += RANDOM_LONG(45, 60);

								BotFixIdealYaw(pEdict);

								pBot->f_move_speed = 0;  // don't move while turning
								pBot->f_dont_avoid_wall_time = gpGlobals->time + 1.0;
							}

							pBot->f_wall_on_left = 0;  // reset wall detect time
						}
						else if (!BotCheckWallOnRight( pBot ))
						{
							// if there was a wall on the right over 1/2 a second ago then
							// 20% of the time randomly turn between 45 and 60 degrees

							if ((pBot->f_wall_on_right != 0) &&
								(pBot->f_wall_on_right <= gpGlobals->time - 0.5) &&
								(RANDOM_LONG(1, 100) <= 20))
							{
								pEdict->v.ideal_yaw -= RANDOM_LONG(45, 60);

								BotFixIdealYaw(pEdict);

								pBot->f_move_speed = 0;  // don't move while turning
								pBot->f_dont_avoid_wall_time = gpGlobals->time + 1.0;
							}

							pBot->f_wall_on_right = 0;  // reset wall detect time
						}
					}
				}

				// check if bot is about to hit a wall.  TraceResult gets returned
				if ((pBot->f_dont_avoid_wall_time <= gpGlobals->time) &&
					BotCantMoveForward( pBot, &tr ))
				{
					// ADD LATER
					// need to check if bot can jump up or duck under here...
					// ADD LATER
					pBot->backwards=false;
					if (pBot->f_sg_find_time<=gpGlobals->time+1)
					{
						if ( BotCheckWallOnRight (pBot))
							pBot->f_side_direction = false;
						if ( BotCheckWallOnLeft (pBot))
							pBot->f_side_direction = true;
						if (RANDOM_LONG(1, 1000) <= 50)
						{
							if(pBot->f_side_direction)
								pBot->f_side_direction = false;
							else
								pBot->f_side_direction = true;
						}
						if(pBot->f_side_direction)
							pBot->f_side_speed = pBot->f_max_speed/2;
						else
							pBot->f_side_speed = -(pBot->f_max_speed)/2;
						if (BotCanJumpUp( pBot ))  // can the bot jump onto something?
						{
							if ((pBot->f_jump_time + 1.0) <= gpGlobals->time)
							{
								pBot->f_jump_time = gpGlobals->time;
								pEdict->v.button |= IN_JUMP;  // jump up and move forward
								pBot->f_duck_time = gpGlobals->time+1;
							}
							else
							{
								// bot already tried jumping less than two seconds ago, just turn
								BotRandomTurn(pBot);
							}
						}
						else if (BotCanDuckUnder( pBot ))  // can the bot duck under something?
						{
							pEdict->v.button |= IN_DUCK;  // duck down and move forward
						}
					}

					BotTurnAtWall( pBot, &tr );
				}
			}

			// check if bot is on a ladder and has been on a ladder for
			// more than 5 seconds...
			if ((pEdict->v.movetype == MOVETYPE_FLY) &&
				(pBot->f_start_use_ladder_time > 0.0) &&
				((pBot->f_start_use_ladder_time + 5.0) <= gpGlobals->time))
			{
				// bot is stuck on a ladder...

				BotRandomTurn(pBot);

				// don't look for items for 2 seconds
				pBot->f_find_item = gpGlobals->time + 2.0;

				pBot->f_start_use_ladder_time = 0.0;  // reset start ladder time
			}

			// check if the bot hasn't moved much since the last location
			// (and NOT on a ladder since ladder stuck handled elsewhere)
			// (don't check for stuck if f_dont_check_stuck in the future)
			if ((moved_distance <= 1.0) && (pBot->prev_speed >= 1.0) &&
				(pEdict->v.movetype != MOVETYPE_FLY) &&
				(pBot->f_dont_check_stuck < gpGlobals->time))
			{
				// the bot must be stuck!
				pBot->backwards=false;
				if ( BotCheckWallOnRight (pBot))
					pBot->f_side_direction = false;
				if ( BotCheckWallOnLeft (pBot))
					pBot->f_side_direction = true;
				if (RANDOM_LONG(1, 1000) <= 50)
				{
					if(pBot->f_side_direction)
						pBot->f_side_direction = false;
					else
						pBot->f_side_direction = true;
				}
				if(pBot->f_side_direction)
					pBot->f_side_speed = pBot->f_max_speed/2;
				else
					pBot->f_side_speed = -(pBot->f_max_speed)/2;
				pBot->f_dont_avoid_wall_time = gpGlobals->time + 0.2;
				pBot->f_look_for_waypoint_time = gpGlobals->time + 1.0;

				if (BotCanJumpUp( pBot ))  // can the bot jump onto something?
				{
					if ((pBot->f_jump_time + 1.0) <= gpGlobals->time)
					{
						pBot->f_jump_time = gpGlobals->time;
						pEdict->v.button |= IN_JUMP;  // jump up and move forward
						pBot->f_duck_time = gpGlobals->time+1;
					}
					else
					{
						// bot already tried jumping less than two seconds ago, just turn
						BotRandomTurn(pBot);
					}
				}
				else if (BotCanDuckUnder( pBot ))  // can the bot duck under something?
				{
					pEdict->v.button |= IN_DUCK;  // duck down and move forward
				}
				else
				{
					//dont avoid or tp sg's
					if(pBot->f_sg_find_time<gpGlobals->time || pBot->f_tp_find_time<gpGlobals->time)
					{
						BotRandomTurn(pBot);

						// is the bot trying to get to an item?...
						if (pBot->pBotPickupItem != NULL)
						{
							// don't look for items for a while since the bot
							// could be stuck trying to get to an item
							pBot->f_find_item = gpGlobals->time + 1;
						}
					}
				}
				/*if(pBot->f_pause_time < gpGlobals->time &&
				moved_distance==0)
				FakeClientCommand(pEdict,"kill\n",NULL,NULL);*/
			}

			// should the bot pause for a while here?
			// (don't pause on ladders or while being "used"...
			if ((RANDOM_LONG(1, 1000) <= pause_frequency[pBot->bot_skill]) &&
				(pEdict->v.movetype != MOVETYPE_FLY) &&
				(pBot->pBotUser == NULL) && pBot->bot_has_flag==false
				&& pBot->bot_skill>1)
			{
				// set the time that the bot will stop "pausing"
				pBot->f_pause_time = gpGlobals->time +
					RANDOM_FLOAT(pause_time[pBot->bot_skill][0],
					pause_time[pBot->bot_skill][1]);
			}
		}
	}
	//} remeber to uncomment this if u uncomment the degree check


	if (pBot->curr_waypoint_index != -1)  // does the bot have a waypoint?
	{
		//lifts
		if ((waypoints[pBot->curr_waypoint_index].flags & W_FL_LIFT)==W_FL_LIFT)
		{
			pBot->backwards=false;
			edict_t *pent = NULL;
			double pz,cz,pzb;
			Vector pv;
			pBot->f_side_speed=0;
			//pEdict->v.origin.z=pEdict->v.origin.z-70;
			//pBot->f_move_speed =-(pBot->f_max_speed / 10);
			//pBot->f_move_speed =-(pBot->f_max_speed / 3);
			while ((pent = FIND_ENTITY_IN_SPHERE( pent, pEdict->v.origin, 220 )) != NULL &&
				(!FNullEnt(pent)))
			{
				if(strncmp(STRING(pent->v.classname),"func_door",9)==0)
				{
					//pv=VecBModelOrigin(pent);
					pz=pent->v.absmin.z + pent->v.size.z;
					pzb=pent->v.absmin.z;
					//if (pz<0) pz=-pz;
					cz=pEdict->v.origin.z;
					//if (cz<0) cz=-cz;
					//{ fp=fopen("bot.txt","a"); fprintf(fp,"pz%d cz%d \n",pz,cz); fclose(fp); }
					if((pz<cz) || (pzb<cz && pzb>cz-100))
					{
						pBot->f_move_speed = pBot->f_max_speed / 2;  // don't move while using elevator
						if(pBot->lastliftvector!=pent->v.origin)
						{
							pBot->f_pause_time=gpGlobals->time+0.5;
							int i=WaypointFindNearest(pEdict, REACHABLE_RANGE, UTIL_GetTeam(pEdict));
							if((waypoints[i].flags & W_FL_LIFT)==W_FL_LIFT)
								pBot->curr_waypoint_index=i;
							pBot->f_waypoint_time=gpGlobals->time + 6;
						}
						pBot->lastliftvector=pent->v.origin;
						break;
					}
					else
					{
						pBot->f_move_speed =-(pBot->f_max_speed / 3);
					}
				}
				if(strncmp(STRING(pent->v.classname),"func_plat",9)==0)
				{
					//pv=VecBModelOrigin(pent);
					pz=pz=pent->v.absmin.z + pent->v.size.z;
					pzb=pent->v.absmin.z;
					//if (pz<0) pz=-pz;
					cz=pEdict->v.origin.z;
					//if (cz<0) cz=-cz;
					//{ fp=fopen("bot.txt","a"); fprintf(fp,"pz%d cz%d \n",pz,cz); fclose(fp); }
					if((pz<cz) || (pzb<cz && pzb>cz-100))
					{
						pBot->f_move_speed = pBot->f_max_speed / 2;  // don't move while using elevator
						if(pBot->lastliftvector!=pent->v.origin)
						{
							int i=WaypointFindNearest(pEdict, REACHABLE_RANGE, UTIL_GetTeam(pEdict));
							if((waypoints[i].flags & W_FL_LIFT)==W_FL_LIFT)
								pBot->curr_waypoint_index=i;
							pBot->f_waypoint_time=gpGlobals->time + 6;
							pBot->f_pause_time=gpGlobals->time+0.5;
						}
						pBot->lastliftvector=pent->v.origin;
						break;
					}
					else
					{
						pBot->f_move_speed =-(pBot->f_max_speed / 3);
					}
				}
			}
			pent=NULL;
			while ((pent = FIND_ENTITY_IN_SPHERE( pent, waypoints[pBot->curr_waypoint_index].origin, 220 )) != NULL &&
				(!FNullEnt(pent)))
			{
				if(strncmp(STRING(pent->v.classname),"func_door",9)==0)
				{
					//pv=VecBModelOrigin(pent);
					pz=pent->v.absmin.z + pent->v.size.z;
					pzb=pent->v.absmin.z;
					//if (pz<0) pz=-pz;
					cz=pEdict->v.origin.z;
					//if (cz<0) cz=-cz;
					//{ fp=fopen("bot.txt","a"); fprintf(fp,"pz%d cz%d \n",pz,cz); fclose(fp); }
					if((pz<cz) || ((pzb<cz && pzb>cz-100) && pz>waypoints[pBot->curr_waypoint_index].origin.z))
					{
						pBot->f_move_speed = pBot->f_max_speed / 2;  // don't move while using elevator
						break;
					}
					else
					{
						pBot->f_move_speed =-(pBot->f_max_speed / 3);
					}
				}
				if(strncmp(STRING(pent->v.classname),"func_plat",9)==0)
				{
					//pv=VecBModelOrigin(pent);
					pz=pent->v.absmin.z + pent->v.size.z;
					pzb=pent->v.absmin.z;
					//if (pz<0) pz=-pz;
					cz=pEdict->v.origin.z;
					//if (cz<0) cz=-cz;
					//{ fp=fopen("bot.txt","a"); fprintf(fp,"pz%d cz%d \n",pz,cz); fclose(fp); }
					if((pz<cz) || ((pzb<cz && pzb>cz-100) && pz>waypoints[pBot->curr_waypoint_index].origin.z))
					{
						pBot->f_move_speed = pBot->f_max_speed / 2;  // don't move while using elevator
						break;
					}
					else
					{
						pBot->f_move_speed =-(pBot->f_max_speed / 3);
					}
				}
			}
			//pEdict->v.origin.z=pEdict->v.origin.z+70;
			BotUseLift( pBot, moved_distance );
		}

		// check if the next waypoint is a door waypoint...
		if ((waypoints[pBot->curr_waypoint_index].flags & W_FL_DOOR)==W_FL_DOOR)
		{
			pBot->f_move_speed = pBot->f_max_speed / 3;  // slow down for doors
		}

		// check if the next waypoint is a ladder waypoint...
		if ((waypoints[pBot->curr_waypoint_index].flags & W_FL_LADDER)==W_FL_LADDER)
		{
			pBot->backwards=false;
			//if(pEdict->v.v_angle.x<0) pEdict->v.button |= IN_FORWARD;
			if(waypoints[pBot->curr_waypoint_index].origin.z < waypoints[pBot->prev_waypoint_index[0]].origin.z)
				pBot->ladder_dir = LADDER_DOWN;		  
		}

		// check if the next waypoint is a jump waypoint...
		if ((waypoints[pBot->curr_waypoint_index].flags & W_FL_JUMP)==W_FL_JUMP &&
			(waypoints[pBot->curr_waypoint_index].origin - pEdict->v.origin).Length() <= 100)
		{
			pBot->backwards=false;
			pEdict->v.button |= IN_JUMP;
		}

		// check if the next waypoint is a crouch waypoint...
		if ((waypoints[pBot->curr_waypoint_index].flags & W_FL_CROUCH)==W_FL_CROUCH &&
			(waypoints[pBot->curr_waypoint_index].origin - pEdict->v.origin).Length() <= 100)
		{
			pBot->backwards=false;
			pBot->f_duck_time = gpGlobals->time+2;
		}

		// check if the next waypoint is a det pack
		if ((waypoints[pBot->curr_waypoint_index].flags & W_FL_TFC_DEMO)==W_FL_TFC_DEMO &&
			(waypoints[pBot->curr_waypoint_index].origin - pEdict->v.origin).Length() <= 100
			&& mod_id==TFC_DLL && pBot->detpack==2 && pBot->curr_waypoint_index==pBot->goto_wp)
		{
			pBot->backwards=false;
			if((waypoints[pBot->curr_waypoint_index].origin - pEdict->v.origin).Length()<75)
			{
				if(pBot->f_pause_time <= gpGlobals->time)
				{
					pBot->f_pause_time = gpGlobals->time+1.5;
					FakeClientCommand(pEdict,"+det5",NULL,NULL);					
				}
			}
		}

		// check if the next waypoint is a teleporter entrance waypoint...
		if ((waypoints[pBot->curr_waypoint_index].flags & W_FL_TFC_TELEPORTER_ENTRANCE)==W_FL_TFC_TELEPORTER_ENTRANCE 
			&& pBot->curr_waypoint_index == pBot->goto_wp)
		{
			pBot->backwards=false;
			float distance = (waypoints[pBot->curr_waypoint_index].origin - pEdict->v.origin).Length();
			
			if(distance < 100)
				pBot->f_move_speed = pBot->f_max_speed / 3;
			else if(distance < 32)
			{
				// Close enough? Stop.
				pBot->f_move_speed = 0;
			}
		}

		BotEngineerThink(pBot);

		//current engineer stuff
		//   if (((waypoints[pBot->curr_waypoint_index].flags & W_FL_TFC_DEFEND)==W_FL_TFC_DEFEND) && 
		// mod_id==TFC_DLL && pEdict->v.playerclass == TFC_CLASS_ENGINEER && 
		// (UTIL_GetTeam(pEdict)==(waypoints[pBot->curr_waypoint_index].flags & W_FL_TEAM) || (waypoints[pBot->curr_waypoint_index].flags & W_FL_TEAM_SPECIFIC)!=W_FL_TEAM_SPECIFIC) &&
		// (waypoints[pBot->curr_waypoint_index].origin - pEdict->v.origin).Length() <= 400 && !pBot->pBotEnemy)
		//{
		// // DrEvil: Lets try a check to pick a new sg spot if theres an sg here.
		// if (!pBot->sg && BotSGAtPoint(waypoints[pBot->curr_waypoint_index].origin, 300))
		// {
		//  pBot->curr_waypoint_index = -1; // clear it
		//  pBot->goto_wp = -1;
		// }
		// pBot->backwards=false;
		// if(!pBot->sg && (pBot->f_build_time<=gpGlobals->time) && (pBot->curr_waypoint_index == pBot->goto_wp) && !pBot->pBotEnemy)
		// {
		//  //don't use this...to many probs
		//  if(pBot->bot_skill > 5)
		//	{
		//		pBot->f_build_time = gpGlobals->time + 8;
		//		FakeClientCommand(pEdict, "build", "2", NULL);
		//		pBot->sg_wp=pBot->curr_waypoint_index;
		//	}
		//  else
		//  {
		//	  edict_t *pent = NULL;
		//	  if(pBot->inact==0 && !pBot->sg) 
		//	  {
		//		  bool bb = true;					  
		//		  //check this waypoint doesn't have a sg on it! use search
		//		  while ((pent = FIND_ENTITY_IN_SPHERE( pent, pEdict->v.origin, 100 )) != NULL && (!FNullEnt(pent)))
		//		  {
		//			  // Can I see an sg here?
		//			  if (strcmp("building_sentrygun_base", STRING(pent->v.classname)) == 0)
		//			  {
		//				  TraceResult tr;
		//				  UTIL_TraceLine( pEdict->v.origin + pEdict->v.view_ofs, pent->v.origin, ignore_monsters, pEdict->v.pContainingEntity, &tr );
		//				  if (tr.flFraction >= 1.0) 
		//					  bb=false;
		//			  }
		//		  }
		//		  if(bb) //if their isn't a sg already here!!
		//		  {
		//			  pBot->inact=1;
		//			  pBot->backwards=false;
		//			  pBot->f_pause_time=gpGlobals->time;
		//		  }
		//	  }
		//	  if(pBot->inact == 1)
		//	  {
		//		  pBot->backwards=false;
		//		  pBot->sg_building=false;
		//		  //aim at waypoint...			
		//		  Vector v_direction = waypoints[pBot->curr_waypoint_index].origin - pEdict->v.origin;

		//		  Vector bot_angles = UTIL_VecToAngles( v_direction );
		//		  if(pBot->pBotEnemy==NULL) 
		//		  {						 
		//			  pBot->idle_angle = bot_angles.y;
		//			  pEdict->v.ideal_yaw = pBot->idle_angle;
		//			  if(pBot->backwards)
		//				  pEdict->v.ideal_yaw=pEdict->v.ideal_yaw+180;
		//			  pEdict->v.idealpitch = bot_angles.x;
		//		  }
		//		  //walk towards it
		//		  if((waypoints[pBot->curr_waypoint_index].origin-pEdict->v.origin).Length()>80) 
		//			  pBot->f_move_speed = pBot->f_max_speed/2;
		//		  else 
		//			  pBot->f_move_speed = pBot->f_max_speed/5;
		//		  //what if theirs an obstuction?!
		//		  int dis=8;
		//		  //ok..increase distance after a few seconds of trying
		//		  if(pBot->f_pause_time<(gpGlobals->time-3)) 
		//		  {
		//			  dis=200;
		//		  }
		//		  if((waypoints[pBot->curr_waypoint_index].origin-pEdict->v.origin).Length()<dis)
		//		  {
		//			  pBot->f_pause_time=gpGlobals->time+1;
		//			  pBot->inact=2;
		//		  }
		//		  //do nothing if we can't reach it after 6 seconds
		//		  if(pBot->f_pause_time<(gpGlobals->time-6)) pBot->inact=0;
		//	  }
		//	  if(pBot->inact==2)
		//	  {
		//		  pBot->backwards=false;
		//		  //aim at waypoint...
		//		  Vector v_direction;
		//		  Vector bot_angles;
		//		  if(pBot->f_pause_time>gpGlobals->time)
		//		  {
		//			  int i = WaypointFindNearestAiming(pEdict->v.origin);
		//			  if(i==-1) 
		//				  i=0;
		//			  v_direction = waypoints[i].origin - pEdict->v.origin;
		//			  bot_angles = UTIL_VecToAngles( v_direction );
		//			  pBot->inact_veca=bot_angles;
		//			  pBot->inact_vecb=v_direction;
		//		  }
		//		  else
		//		  {
		//			  bot_angles = pBot->inact_veca;
		//			  v_direction = pBot->inact_vecb;
		//		  }
		//		 
		//		 if(!pBot->pBotEnemy) 
		//		 {
		//			 pBot->idle_angle = bot_angles.y;
		//			 pEdict->v.ideal_yaw = pBot->idle_angle;
		//			 if(pBot->backwards)
		//				pEdict->v.ideal_yaw=pEdict->v.ideal_yaw+180;
		//			 pEdict->v.idealpitch = bot_angles.x;				
		//		 }
		//		  //walk away from it
		//		  pBot->f_move_speed=-(pBot->f_max_speed/3);
		//		  if(pBot->f_pause_time<gpGlobals->time)
		//		  {
		//			  //UTIL_HostSay(pEdict, 1, "Building sentry gun");
		//			  //use search for object to see if u just built a sg... 
		//			  bool sg=false;
		//			  if(pBot->f_build_time < gpGlobals->time)
		//			  {
		//				  pent=NULL;
		//				  Vector vecStart;
		//				  Vector vecEnd;
		//				  while ((pent = FIND_ENTITY_IN_SPHERE( pent, pEdict->v.origin, 400 )) != NULL && (!FNullEnt(pent)))
		//				  {
		//					  int l = (pEdict->v.origin - pent->v.origin).Length2D();
		//					  if ((strcmp("building_sentrygun_base", STRING(pent->v.classname))==0) && l>=16 && l<=96 && pBot->sg_building)
		//					  {
		//						  pBot->f_build_time = gpGlobals->time + 1;
		//						  pBot->f_pause_time=gpGlobals->time+1;
		//						  sg=true;
		//						  pBot->sg_edict=pent;
		//						  for (int i=0; i < num_areas; i++)
		//						  {
		//							  //checks only for whole area delete.....
		//							  if ((areas[i].flags & W_FL_DELETED) == W_FL_DELETED)
		//								  continue;
		//							  if(AreaInsideClosest(pBot->pEdict)==i) 
		//								  pBot->curr_area=i;
		//						  }
		//						  if(pBot->curr_area!=-1)
		//						  {
		//							  char ss[255];
		//							  int t=UTIL_GetTeam(pBot->pEdict);
		//							  if(t==0) sprintf(ss,"Building Sentrygun %s",areas[pBot->curr_area].namea);
		//							  if(t==1) sprintf(ss,"Building Sentrygun %s",areas[pBot->curr_area].nameb);
		//							  if(t==2) sprintf(ss,"Building Sentrygun %s",areas[pBot->curr_area].namec);
		//							  if(t==3) sprintf(ss,"Building Sentrygun %s",areas[pBot->curr_area].named);
		//							  if(strcmp(pBot->lastmessage,ss)!=0)
		//								  UTIL_HostSay(pBot->pEdict,1, ss);
		//							  strcpy(pBot->lastmessage,ss);
		//						  }
		//					  }
		//				  }
		//			  }
		//			  if(pBot->f_build_time < (gpGlobals->time-0.5) && !sg)
		//			  {
		//				  FakeClientCommand(pEdict, "build", "2", NULL);
		//				  pBot->f_build_time = gpGlobals->time;
		//			  }
		//		  }
		//	  }
		//  }
		// }
		//}

		//current engineer stuff
		//dispensors!
		//   if (waypoints[pBot->curr_waypoint_index].flags==0 && mod_id==TFC_DLL && pEdict->v.playerclass == TFC_CLASS_ENGINEER && 
		// (waypoints[pBot->curr_waypoint_index].origin - pEdict->v.origin).Length() <= 400 && pBot->curr_waypoint_index == pBot->goto_wp &&
		// pBot->sg && pBot->sg_edict && !pBot->dispensor && !pBot->track_player)
		//{
		// // Is it level 3?
		// if(strcmp(STRING(pBot->sg_edict->v.model),"models/sentry3.mdl")==0 && pBot->f_build_time<=gpGlobals->time
		//  && (pBot->sg_edict->v.origin - pEdict->v.origin).Length() <= 400 && !pBot->pBotEnemy)
		// {
		//  pBot->backwards=false;
		//  {
		//	  edict_t *pent;
		//	  char item_name[40];
		//	  if(pBot->inact==0 && pBot->sg) 
		//	  {
		//		  bool bb = true;
		//		  if(bb) //if their isn't a sg already here!!
		//		  {
		//			  pBot->inact=1;
		//			  pBot->backwards=false;
		//			  pBot->f_pause_time=gpGlobals->time;
		//		  }
		//	  }
		//	  if(pBot->inact==1)
		//	  {
		//		  pBot->backwards=false;
		//		  pBot->sg_building=false;
		//		  //aim at waypoint...
		//		  Vector v_direction = waypoints[pBot->curr_waypoint_index].origin - pEdict->v.origin;
		//		  Vector bot_angles = UTIL_VecToAngles( v_direction );
		//		  if(!pBot->pBotEnemy) 
		//		  {
		//			  pBot->idle_angle = bot_angles.y;
		//			  pEdict->v.ideal_yaw = pBot->idle_angle;
		//			  if(pBot->backwards)
		//				  pEdict->v.ideal_yaw=pEdict->v.ideal_yaw+180;
		//			  pEdict->v.idealpitch = bot_angles.x;
		//		  }
		//		  //walk towards it
		//		  if((waypoints[pBot->curr_waypoint_index].origin-pEdict->v.origin).Length()>80) 
		//			  pBot->f_move_speed=pBot->f_max_speed/2;
		//		  else 
		//			  pBot->f_move_speed=pBot->f_max_speed/5;
		//		  //what if theirs an obstuction?!
		//		  int dis=100;
		//		  //ok..increase distance after a few seconds of trying
		//		  if(pBot->f_pause_time<(gpGlobals->time-3)) 
		//		  {
		//			  dis=200;
		//		  }
		//		  if((waypoints[pBot->curr_waypoint_index].origin-pEdict->v.origin).Length()<dis)
		//		  {
		//			  pBot->f_pause_time=gpGlobals->time+1;
		//			  pBot->inact=2;
		//		  }
		//		  //do nothing if we can't reach it after 6 seconds
		//		  if(pBot->f_pause_time<(gpGlobals->time-6)) pBot->inact=0;
		//	  }
		//	  if(pBot->inact==2)
		//	  {
		//		  pBot->backwards=false;
		//		  //aim at waypoint...
		//		  Vector v_direction;
		//		  Vector bot_angles;
		//		  if(pBot->f_pause_time>gpGlobals->time)
		//		  {
		//			  int i;
		//			  i=pBot->curr_waypoint_index;
		//			  if(i==-1) i=0;
		//			  v_direction = waypoints[i].origin - pEdict->v.origin;
		//			  bot_angles = UTIL_VecToAngles( v_direction );
		//			  pBot->inact_veca=bot_angles;
		//			  pBot->inact_vecb=v_direction;
		//		  }
		//		  else
		//		  {
		//			  bot_angles = pBot->inact_veca;
		//			  v_direction = pBot->inact_vecb;
		//		  }
		//		 
		//		 if(pBot->pBotEnemy==NULL) 
		//		 {						  
		//			 pBot->idle_angle = bot_angles.y;
		//			 pEdict->v.ideal_yaw = pBot->idle_angle;
		//			 if(pBot->backwards)
		//				pEdict->v.ideal_yaw=pEdict->v.ideal_yaw+180;
		//			 pEdict->v.idealpitch = bot_angles.x;			
		//		 }
		//		  //walk away from it
		//		  pBot->f_move_speed=-(pBot->f_max_speed/3);
		//		  if(pBot->f_pause_time<gpGlobals->time)
		//		  {
		//			  bool sg=false;
		//			  if(pBot->f_build_time < gpGlobals->time)
		//			  {
		//				  pent=NULL;
		//				  Vector vecStart;
		//				  Vector vecEnd;
		//				  while ((pent = FIND_ENTITY_IN_SPHERE( pent, pEdict->v.origin, 400 )) != NULL && (!FNullEnt(pent)))
		//				  {
		//					  strcpy(item_name, STRING(pent->v.classname));
		//					  int l = (pEdict->v.origin - pent->v.origin).Length2D();
		//					  if ((strcmp("building_dispenser", item_name)==0) && l>=16 && l<=96 && pBot->sg_building)
		//					  {
		//						  pBot->f_build_time = gpGlobals->time + 1;
		//						  pBot->f_pause_time=gpGlobals->time+1;
		//						  sg=true;
		//						  pBot->dispensor_edict=pent;
		//						  pBot->dispensor=true;
		//					  }
		//					  if (pBot->dispensor)
		//					  {
		//						  pBot->f_build_time = gpGlobals->time + 4;
		//						  pBot->inact=0;
		//						  pBot->f_pause_time=gpGlobals->time+3;
		//						  sg=true;
		//						  //UTIL_HostSay(pEdict, 0, "dispenser built");										
		//						  Vector v_enemy = pBot->dispensor_edict->v.origin - pEdict->v.origin;
		//						  Vector bot_angles = UTIL_VecToAngles( v_enemy );
		//						  pEdict->v.ideal_yaw = bot_angles.y+50;
		//						  if(pEdict->v.ideal_yaw>360)
		//							  pEdict->v.ideal_yaw=pEdict->v.ideal_yaw-360;
		//						  BotFixIdealYaw(pEdict);	
		//					  }
		//				  }
		//			  }
		//			  if(pBot->f_build_time < (gpGlobals->time-0.5) && !sg)
		//			  {
		//					FakeClientCommand(pEdict, "build", "1", NULL);
		//					pBot->f_build_time = gpGlobals->time;
		//			  }
		//		  }
		//	  }
		//  }
		// }
		//}
		/*if(pBot->dispensor && pBot->f_build_time < gpGlobals->time + 3 && pBot->f_build_time > gpGlobals->time + 1
		&& pBot->inact==0 && pBot->dispensor_edict!=NULL)
		{
		char *cvar_ntf_feature_multigun = (char *)CVAR_GET_STRING( "ntf_feature_multigun" );
		if(strcmp(cvar_ntf_feature_multigun,"1")==0)
		{
		pEdict->v.ideal_yaw = pEdict->v.ideal_yaw+25;
		if(pEdict->v.ideal_yaw>360)
		pEdict->v.ideal_yaw=pEdict->v.ideal_yaw-360;
		BotFixIdealYaw(pEdict);	
		FakeClientCommand(pEdict,"buildspecial",NULL,NULL);
		}
		}*/
		////det dispensor..cus someones using it
		//if(pBot->dispensor && pBot->dispensor_edict==NULL)
		//{		  
		// // Set up the det dispenser timer.
		// if (!pBot->detTime)
		//  pBot->detTime = gpGlobals->time + RANDOM_LONG(0.0, pBot->bot_skill);
		// // Det the dispenser if the timer is out.
		// if (pBot->detTime < gpGlobals->time)
		// {
		//  FakeClientCommand(pEdict,"detdispenser",NULL,NULL);
		//  pBot->dispensor=false;
		//  pBot->detTime = NULL;			  

		// }
		//}
		//stop building/reset if we have spotted an enemy
		/*if(pBot->inact!=0 && (pBot->pBotEnemy || pBot->f_take_damage))
		{
		if(pBot->inact==2)
		FakeClientCommand(pEdict,"build",NULL,NULL);
		pBot->inact=0;
		pBot->f_pause_time=0;
		pBot->f_build_time=0;
		}*/

		//stop trying if nothing happens..
		if(pBot->f_pause_time<(gpGlobals->time-10) && pBot->inact!=0) pBot->inact=0;

		// check if the waypoint is a sniper waypoint AND
		// bot isn't currently aiming at an ememy...
		if (((waypoints[pBot->curr_waypoint_index].flags & W_FL_SNIPER)==W_FL_SNIPER) &&
			(!pBot->pBotEnemy) && ((mod_id == TFC_DLL) && (pEdict->v.playerclass == TFC_CLASS_SNIPER)))
		{
			pBot->backwards = false;
			int dist = (waypoints[pBot->curr_waypoint_index].origin - pEdict->v.origin).Length();
			if(dist <= 60)
			{
				pBot->ras=false;
				pBot->backwards=false;
				// select this weapon if it isn't already selected
				if (pBot->current_weapon.iId != TF_WEAPON_SNIPERRIFLE)
					UTIL_SelectItem(pEdict, "tf_weapon_sniperrifle");
				pEdict->v.button |= IN_ATTACK;   // charge the weapon

				if (pBot->f_sniper_aim_time <= gpGlobals->time)
				{
					int aim_index = WaypointFindNearestAiming(waypoints[pBot->curr_waypoint_index].origin);
					if (aim_index != -1)
					{
						Vector v_aim = waypoints[aim_index].origin - waypoints[pBot->curr_waypoint_index].origin;
						Vector aim_angles = UTIL_VecToAngles( v_aim );
						aim_angles.y += RANDOM_LONG(0, 30) - 15;
						pEdict->v.ideal_yaw = aim_angles.y;
					}
					// don't adjust aim again until after a few seconds...
					if(pBot->f_move_speed==0) pBot->f_sniper_aim_time = gpGlobals->time + RANDOM_FLOAT(1.0, 4.0);
				}
			}
		}
	}
	if (pEdict->v.waterlevel >= 2) 
	{
		pBot->f_move_speed = pBot->f_max_speed;
		pBot->backwards=false;
	}
	//randomly check behind ya
	if (((pBot->backwards_time+15) <= gpGlobals->time) && (RANDOM_FLOAT(0, 1000)<100) &&
		pBot->pBotEnemy==NULL && !pBot->bot_has_flag && !pBot->ras && pBot->inact==0) 
	{
		pBot->backwards=true;
		pBot->backwards_time=gpGlobals->time+RANDOM_FLOAT(1,3);
	}
	else if((pBot->backwards_time <= gpGlobals->time)) 
		pBot->backwards=false;
	if(pBot->backwards && !pBot->pBotEnemy && !pBot->pBotPickupItem)
	{
		if(pBot->f_move_speed>=0) pBot->f_move_speed=-(pBot->f_move_speed);
	}

	//if(pBot->concuss)
	//{
	//	pEdict->v.ideal_yaw += RANDOM_FLOAT(-45,45);
	//	pEdict->v.idealpitch += RANDOM_FLOAT(-45,45);
	//	BotFixIdealYaw(pEdict);
	//	BotFixIdealPitch(pEdict);
	//	//UTIL_HostSay(pEdict, 0, "concussed");
	//}

	if(g_bot_debug && pBot->f_look_for_waypoint_time <= gpGlobals->time)
	{
		if(pBot->curr_waypoint_index!=-1) 
			WaypointDrawBeam(INDEXENT(1), pEdict->v.origin,waypoints[pBot->curr_waypoint_index].origin, 10, 2, 0, 250, 0, 200, 10);
		if(pBot->goto_wp!=-1) 
			WaypointDrawBeam(INDEXENT(1), pEdict->v.origin,waypoints[pBot->goto_wp].origin, 10, 2, 0, 0, 250, 200, 10);
	}
	if(g_bot_debug && pBot->pBotPickupItem!=NULL) 
	{
		if(pBot->pBotPickupItem->v.origin!=Vector(0,0,0))
			WaypointDrawBeam(INDEXENT(1), pEdict->v.origin,pBot->pBotPickupItem->v.origin, 10, 2, 0, 250, 250, 200, 10);
		else
			WaypointDrawBeam(INDEXENT(1), pEdict->v.origin,pBot->pBotPickupItem->v.absmin, 10, 2, 0, 250, 250, 200, 10);
	}
	if(g_bot_debug && pBot->pBotEnemy!=NULL) 
		WaypointDrawBeam(INDEXENT(1), pEdict->v.origin,pBot->pBotEnemy->v.origin, 10, 2, 250, 0, 0, 200, 10);
	//v7 smooth turning, beta
	int speed = 12;
	float diff = -pEdict->v.v_angle.x;
	//up down
	BotFixIdealPitch(pEdict);
	if(diff<-180)
		diff=diff+360;
	if(diff>180)
		diff=diff-360;
	diff=diff-pEdict->v.idealpitch;
	if(diff<-180)
		diff=diff+360;
	if(diff>180)
		diff=diff-360;
	if(diff>-10 && diff<10)
		speed=2;
	else if(diff>-20 && diff<20)
		speed=3;
	else if(diff>-40 && diff<40)
		speed=4;
	else if(diff>-60 && diff<60)
		speed=5;
	else if(diff>-90 && diff<90)
		speed=7;	 
	else if(diff>-110 && diff<110)
		speed=10;
	if(!pBot->pBotEnemy)
		speed=speed*1.5;
	speed=speed*((5-pBot->bot_skill)+(pBot->bot_skill/5));
	if(speed!=0)
		BotChangePitch( pBot, speed);
	BotFixIdealYaw(pEdict);
	speed=12;
	diff=pEdict->v.v_angle.y;
	if(diff<-180)
		diff=diff+360;
	if(diff>180)
		diff=diff-360;
	diff=diff-pEdict->v.ideal_yaw;
	if(diff<-180)
		diff=diff+360;
	if(diff>180)
		diff=diff-360;
	if(diff>-10 && diff<10)
		speed=3;
	else if(diff>-20 && diff<20)
		speed=4;
	else if(diff>-40 && diff<40)
		speed=4;
	else if(diff>-60 && diff<60)
		speed=5;
	else if(diff>-90 && diff<90)
		speed=7;	 
	else if(diff>-110 && diff<110)
		speed=10;	
	if(pBot->pBotEnemy==NULL)
		speed=speed*2.5;
	speed=speed*((5-pBot->bot_skill)+(pBot->bot_skill/5));
	if(speed!=0)
		BotChangeYaw( pBot, speed);

	if(pBot->pBotEnemy && (pBot->bot_has_flag || pBot->ras) &&
		pBot->f_disguise_state!=2)
	{
		pBot->backwards=false;

		if ((num_waypoints != 0) && pBot->curr_waypoint_index!=-1)
		{
			if(pBot->f_look_for_waypoint_time <= gpGlobals->time)
			{
				found_waypoint = BotHeadTowardWaypoint(pBot);
			}
			if(g_bot_debug) WaypointDrawBeam(INDEXENT(1), pEdict->v.origin,waypoints[pBot->curr_waypoint_index].origin, 10, 2, 250, 250, 0, 200, 10);
			double dgrad;
			Vector v;
			v=UTIL_VecToAngles(waypoints[pBot->curr_waypoint_index].origin - pEdict->v.origin);
			v.y=v.y+180;
			if (v.y > 180)
				v.y -= 360;
			if (v.y < -180)
				v.y += 360;
			dgrad=(double)(v.y);
			//doh, need to add players view angle aswell
			dgrad=dgrad-(double)(pEdict->v.v_angle.y);
			dgrad=dgrad+180;
			if (dgrad > 180)
				dgrad -= 360;
			if (dgrad < -180)
				dgrad += 360;
			dgrad=dgrad*pi;
			dgrad=dgrad/180;
			pBot->f_move_speed=(pBot->f_max_speed)*(cos(dgrad));
			pBot->f_side_speed=-(pBot->f_max_speed)*(sin(dgrad));
		}	   
	}   
	//my close contact avoid code
	if(!pBot->pBotPickupItem && !pBot->bot_has_flag && pBot->inact==0 &&
		pBot->f_snipe_time<=gpGlobals->time)
	{
		// search the world for players...
		int i;
		bool avoid,infov;
		float nearestdistance = 150;
		Vector vang;
		avoid = infov = false;
		edict_t *pPl = NULL;
		for (i = 1; i <= gpGlobals->maxClients; i++)
		{
			edict_t *pPlayer = INDEXENT(i);
			// skip invalid players and skip self (i.e. this bot)
			if ((pPlayer) && (!pPlayer->free) && (pPlayer != pEdict))
			{
				// skip this player if not alive (i.e. dead or dying)
				if (!IsAlive(pPlayer))
					continue;
				if ((b_observer_mode) && !!((pPlayer->v.flags & FL_FAKECLIENT)==FL_FAKECLIENT))
					continue;
				//don't back off if going for player wif one of these weapons
				if(pPlayer==pBot->pBotEnemy && 
					(pBot->current_weapon.iId == TF_WEAPON_KNIFE ||
					pBot->current_weapon.iId == TF_WEAPON_MEDIKIT ||
					pBot->current_weapon.iId == TF_WEAPON_SPANNER ||
					pBot->current_weapon.iId == TF_WEAPON_AXE))
					continue;

				vang = pPlayer->v.origin - pEdict->v.origin;
				float distance = vang.Length();
				vang = UTIL_VecToAngles(vang);
				float pv = pEdict->v.v_angle.y;
				pv+=180;
				vang.y -= pv;
				if(vang.y<0) vang.y += 360;

				if (distance < nearestdistance && !((UTIL_GetTeamColor(pEdict)==UTIL_GetTeamColor(pPlayer)
					|| team_allies[UTIL_GetTeam(pEdict)] & (1<<UTIL_GetTeam(pPlayer))) && pPlayer==pBot->pBotEnemy))
				{
					Vector vecEnd;
					vecEnd = pPlayer->v.origin + pPlayer->v.view_ofs;
					if (FInViewCone( &vecEnd, pEdict ) &&
						FVisible( vecEnd, pEdict ))
						infov=true;
					else
						infov=false;
					nearestdistance = distance;
					avoid=true;
					pPl=pPlayer;
				}
			}
		}

		if(avoid && infov)
		{
			//is this avoid stuff ok??
			//vang is ang to avoid person
			if(pPl!=NULL && ((pPl->v.button & IN_DUCK)==IN_DUCK))
			{
				if(nearestdistance<=70 && infov)
				{
					pEdict->v.button |= IN_JUMP;
					pBot->f_duck_time=gpGlobals->time+0.5;
				}
			}
			else
			{
				if(vang.y<=180)
					pBot->f_side_direction = false;
				if(vang.y>180)
					pBot->f_side_direction = true;
				if(pBot->f_side_direction)
					pBot->f_side_speed = pBot->f_max_speed;
				else
					pBot->f_side_speed = -(pBot->f_max_speed);
				if(nearestdistance<=70 && infov) pBot->f_move_speed=-(pBot->f_max_speed);
			}
		}
	}
	//my close avoid code
	if (pBot->f_pause_time > gpGlobals->time && (pBot->pBotEnemy==NULL || pBot->f_snipe_time>gpGlobals->time))  // is the bot "paused"?
	{
		pBot->f_move_speed = 0;  // don't move while pausing
		pBot->f_side_speed=0;
	}
	// make the body face the same way the bot is looking
	pEdict->v.angles.y = pEdict->v.v_angle.y;
	// save the previous speed (for checking if stuck)
	pBot->prev_speed = pBot->f_move_speed;

	///////////////
	// DEFENDERS //
	///////////////
	// Check our defense point for someone else there, move on if theres someone there.
	if ((pBot->mission == pBot->Defender) && (pBot->goto_wp == pBot->defendPoint) && 
		BotDefenderAtPoint(pBot, waypoints[pBot->defendPoint].origin, 100))
	{
		pBot->defendPoint = -1;
		pBot->goto_wp = -1;
	}
	// Retain our pipe point
	if (pBot->pipePoint != -1)
		pBot->defendPoint = pBot->goto_wp = pBot->pipePoint;

    // We are there, get into position.
	if ((pBot->mission == pBot->Defender) && (pBot->curr_waypoint_index == pBot->defendPoint) && 
		(pBot->goto_wp == pBot->defendPoint) && (waypoints[pBot->curr_waypoint_index].origin - pBot->pEdict->v.origin).Length() < 50)
	{		
		bool override = false;
		// Try to respond to incoming fire.
		if (!pBot->pBotEnemy && BotHealthValue(pBot->pEdict) < pBot->lastFrameHealth)
		{
			//UTIL_HostSay(pBot->pEdict, 0, "I got hurt");
			int closestDist = 9999;
			edict_t *closestPlayer = NULL;
			int closestWp = -1;
			for (int i = 1; i <= 32; i++)
			{		
				pPlayer = INDEXENT(i);				
				if (!pPlayer)
					continue;
				// Skip myself
				if (pPlayer == pBot->pEdict)
					continue;
				// Skip teammates
				if (UTIL_GetTeam(pPlayer) == UTIL_GetTeam(pBot->pEdict))
					continue;
				int WP = WaypointFindNearest(pPlayer->v.origin, 500, -1);
				// crash check
				if ((WP == -1) || (pBot->curr_waypoint_index == -1))
					continue;
				float distance = WaypointDistanceFromTo(WP, pBot->curr_waypoint_index, -1);
				// Is he closer?
				if (distance < closestDist)
				{
					closestDist = distance;
					closestPlayer = pPlayer;
					closestWp = WP;
				}
			}
			// Is he close enough to respond to?
			if (closestDist < 2000)
			{
				pBot->goto_wp = closestWp;  
				pBot->defendPoint = -1;
				override = true;
			}
		}
		// If we are idle.
		if (!pBot->pBotEnemy && !override) 
		{
			// crouch if its a crouch point.
			if ((pBot->f_move_speed==0) && (waypoints[pBot->curr_waypoint_index].flags & W_FL_CROUCH) == W_FL_CROUCH) 	
				pEdict->v.button |= IN_DUCK;

			// Make sure the proper weapon is selected and we are reloading.
			if (pBot->pEdict->v.playerclass == TFC_CLASS_SOLDIER && pBot->current_weapon.iId != TF_WEAPON_RPG)
				UTIL_SelectItem(pEdict, "tf_weapon_rpg");			
			else if (pBot->pEdict->v.playerclass == TFC_CLASS_HWGUY && pBot->current_weapon.iId != TF_WEAPON_AC)
				UTIL_SelectItem(pEdict, "tf_weapon_ac");
			else if (pBot->pEdict->v.playerclass == TFC_CLASS_PYRO && pBot->current_weapon.iId != TF_WEAPON_IC)
				UTIL_SelectItem(pEdict, "tf_weapon_ic");
			else if (pBot->pEdict->v.playerclass == TFC_CLASS_DEMOMAN)
			{
				if (!pBot->piped || !pBot->piping)
					// We are idle, select the pipe launcher if we aren't piping and havent piped yet.
					if(pBot->current_weapon.iId != TF_WEAPON_PL)
						UTIL_SelectItem(pEdict, "tf_weapon_pl");
				if (pBot->piping && pBot->piped)
					if(pBot->current_weapon.iId != TF_WEAPON_GL)
					{
						UTIL_SelectItem(pEdict, "tf_weapon_gl");
						pEdict->v.button |= IN_RELOAD;
					}
			}				
			
			// remain paused and aimed.
            pBot->f_pause_time = gpGlobals->time + 0.5f;
			int aim_index = WaypointFindNearestAiming(waypoints[pBot->curr_waypoint_index].origin);
			if (aim_index != -1)
			{
				Vector v_aim = waypoints[aim_index].origin - waypoints[pBot->curr_waypoint_index].origin;
				Vector aim_angles = UTIL_VecToAngles( v_aim );			
				pEdict->v.ideal_yaw = aim_angles.y;
				pEdict->v.idealpitch = 0;
			}

			////////////////////
			// DEMOMAN PIPING //
			////////////////////
			if (pBot->pEdict->v.playerclass == TFC_CLASS_DEMOMAN)
			{
				if(!pBot->piping && (pBot->current_weapon.iId == TF_WEAPON_PL) && (pBot->current_weapon.iClip < 6))	
					pEdict->v.button |= IN_RELOAD;  // press reload button

				if((pBot->current_weapon.iId == TF_WEAPON_PL) && (pBot->current_weapon.iClip == 6))
					pBot->piping = true;	
				
				if(pBot->piping && (pBot->current_weapon.iId == TF_WEAPON_PL) && (pBot->current_weapon.iClip == 0))	
				{
					pBot->piped = true;
					pBot->pipeTime = gpGlobals->time;
					pBot->pipePoint = pBot->defendPoint;
				}

				// Reset if idle too long.
				if (pBot->pipeTime+55 < gpGlobals->time)
				{
					FakeClientCommand(pEdict,"detpipe",NULL,NULL);
					pBot->pipePoint = -1;
					pBot->pipeTime = gpGlobals->time + 9999;
					pBot->piped = false;
					pBot->piping = false;
				}
					
				// Lay the pipes.
				if (pBot->piping)
				{
					if (!pBot->piped)
						pEdict->v.button |= IN_ATTACK;					
					else
						pEdict->v.button |= IN_RELOAD;  // press reload button
				} else
					pEdict->v.button |= IN_RELOAD;  // press reload button
			}
			if (defensive_chatter && (pBot->defenseSayDelay < gpGlobals->time))
			{
				pBot->defenseSayDelay = gpGlobals->time + 30;
				// Announce my defensive position
				char ss[255];
				char myClass[20];
				int team = UTIL_GetTeam(pBot->pEdict);
				int area = AreaInsideClosest(pBot->pEdict);
				if(area != -1)
				{
					switch(pBot->pEdict->v.playerclass)
					{
						case TFC_CLASS_CIVILIAN:
							strcpy(myClass,"Civilian:");
							break;
						case TFC_CLASS_SCOUT:
							strcpy(myClass,"Scout:");
							break;
						case TFC_CLASS_SOLDIER:
							strcpy(myClass,"Soldier:");
							break;
						case TFC_CLASS_DEMOMAN:
							strcpy(myClass,"Demo-man:");
							break;
						case TFC_CLASS_MEDIC:
							strcpy(myClass,"Medic:");
							break;
						case TFC_CLASS_HWGUY:
							strcpy(myClass,"HW-Guy:");
							break;
						case TFC_CLASS_PYRO:
							strcpy(myClass,"Pyro:");
							break;
						case TFC_CLASS_SPY:
							strcpy(myClass,"Spy:");
							break;
						case TFC_CLASS_ENGINEER:
							strcpy(myClass,"Engineer:");
							break;
					}
					if(team==0) sprintf(ss,"%s Defending %s",myClass, areas[area].namea);
					if(team==1) sprintf(ss,"%s Defending %s",myClass, areas[area].nameb);
					if(team==2) sprintf(ss,"%s Defending %s",myClass, areas[area].namec);
					if(team==3) sprintf(ss,"%s Defending %s",myClass, areas[area].named);
					if(strcmp(pBot->lastmessage,ss)!=0)
						UTIL_HostSay(pBot->pEdict,1, ss);
					strcpy(pBot->lastmessage,ss);
				}
			}
		}
		else 
		{
			// Cancel pause if we take damage or have an enemy.
			pBot->f_pause_time = gpGlobals->time;
			pBot->f_duck_time = gpGlobals->time;							
		}
		// Defensive overrides

		if (pBot->m_rgAmmo[weapon_defs[TF_WEAPON_RPG].iAmmo1] < 15)
		{
			BotGoForAmmo(pBot);
		}
		// go for some health.
		if (BotHealthValue(pBot->pEdict) < 50 || BotArmorValue(pBot->pEdict) < 50)
		{
			pBot->goto_wp = -1;
		}	
	}
	
	////////////////
	// ROCKETJUMP //
	////////////////
	if (pBot->RocketJumping)
	{
		pBot->curr_waypoint_index = pBot->RJwp;	
		float distance = (waypoints[pBot->RJwp].origin - pEdict->v.origin).Length();
		float dist2d = (waypoints[pBot->curr_waypoint_index].origin - pBot->pEdict->v.origin).Length2D();
		float zDiff = (waypoints[pBot->RJwp].origin.z - pEdict->v.origin.z);

		// Fire the rocket, a frame after the jump
		if (pBot->RJDelaying)//(gpGlobals->time > pBot->RJJumpDelay) && 
		{
			UTIL_SelectItem(pEdict, "tf_weapon_rpg");
			if (pBot->current_weapon.iClip)
			{
				if (pBot->pEdict->v.playerclass == TFC_CLASS_SOLDIER)
				{
					//UTIL_HostSay(pEdict,0,"weee");
					pEdict->v.idealpitch = -90;
					BotChangePitch(pBot, 99999);	
					pEdict->v.button |= IN_ATTACK;
					pBot->RJDelaying = false;			  
				} else if (pBot->pEdict->v.playerclass == TFC_CLASS_PYRO)
				{
					char *cvar_ntf_boostreq = (char *)CVAR_GET_STRING( "ntf_jetpack_armor" );
					int armorReq = atoi(cvar_ntf_boostreq);				   
					if (BotArmorValue(pEdict) < armorReq)
					{
						pBot->RocketJumping = false;
						pBot->RJDelaying = false;
					}
					pEdict->v.idealpitch = 50;
					BotChangePitch(pBot, 99999);	
					FakeClientCommand(pEdict,"_special2", "102",NULL);
					FakeClientCommand(pEdict,"_special2", "102",NULL);
					pBot->RJDelaying = false;
				}
			} else
			{
				// Abort
				pBot->RocketJumping = false;
				pBot->curr_waypoint_index = -1;
			}
		}
		// Check for within range of jumping, and meet requirements for jump.
		// Then jump
		if ((pBot->RJClosingDistance >= distance) && (pBot->RJHeadingTime < gpGlobals->time) && 
			pEdict->v.velocity.Length() > 200 && BotHealthValue(pEdict) > 30 && BotArmorValue(pEdict) > 30)
		{
			// TODO: check if we have a loaded rocket, if not, abort the RJ
			if (pBot->pEdict->v.playerclass == TFC_CLASS_SOLDIER)
				UTIL_SelectItem(pEdict, "tf_weapon_rpg");
			if (pBot->current_weapon.iClip && !pBot->RJDelaying)
			{								
				pEdict->v.button |= IN_JUMP;
				pBot->f_move_speed=pBot->f_max_speed;
				pBot->RJDelaying = true;
			}								
		}	
		// Lets try to detect whether we are under it and its inaccessible, so we can abort.
		if (zDiff > 50 && dist2d < 100 && (pBot->curr_waypoint_index == pBot->RJwp))
		{
			//UTIL_HostSay(pEdict,0,"damit");
			pBot->RocketJumping = false;
			pBot->curr_waypoint_index = -1;
		}
	}

	////////////////////////
	// CONC JUMPING STUFF //
	////////////////////////
	if (pBot->ConcJumping)
	{	   	   
		float timeToDet = 4.0f - (gpGlobals->time - pBot->primeTime);
		if (timeToDet <= 0.35f)
		{
			pBot->backwards = false;		   
			pBot->curr_waypoint_index = pBot->RJwp;
		}
		if (timeToDet <= 0.2f)
		{
			pBot->curr_waypoint_index = pBot->RJwp;	
			pEdict->v.button |= IN_JUMP;
			pBot->f_side_speed = 0;
			pBot->ConcCruise = gpGlobals->time + 4.0f;	
			pBot->ConcJumping = false;

			Vector v_conc = waypoints[pBot->curr_waypoint_index].origin - pEdict->v.origin;
			pBot->ConcAngle = UTIL_VecToAngles( v_conc ); 
			pBot->pEdict->v.angles.x = pBot->ConcAngle.x; 
			pBot->pEdict->v.angles.y = pBot->ConcAngle.y;
			pBot->pEdict->v.angles.z = pBot->ConcAngle.z; 
		}	      
	}
	if (pBot->ConcCruise > gpGlobals->time)
	{
		float speed = pBot->pEdict->v.velocity.Length2D();
		float zDiff = (waypoints[pBot->curr_waypoint_index].origin.z - pBot->pEdict->v.origin.z);

		// Align to our conc vector.
		pBot->pEdict->v.angles.x = pBot->ConcAngle.x; 
		pBot->pEdict->v.angles.y = pBot->ConcAngle.y;
		pBot->pEdict->v.angles.z = pBot->ConcAngle.z; 
		pEdict->v.button |= IN_FORWARD;
		pBot->f_move_speed = pBot->f_max_speed;
		pBot->backwards = false;
		pBot->f_duck_time = 0;

		// Abort this routine once we are decending.
		if (pBot->pEdict->v.velocity.z < 0)
			pBot->ConcCruise = gpGlobals->time;
		else
			if (speed > 600)
				pEdict->v.button |= IN_DUCK;

		pBot->ConcJumping = false;	   
	}	

	//////////////////////////////////////////////////
	// THIS FUNCTION ACTUALLY MOVES THE CHAR INGAME //
	//////////////////////////////////////////////////
	g_engfuncs.pfnRunPlayerMove( pEdict, pEdict->v.v_angle, pBot->f_move_speed,
		pBot->f_side_speed ,0, pEdict->v.button, 0, pBot->msecval);
	//////////////////////////////////////////////////

	if(pBot->concuss_time<=gpGlobals->time) pBot->concuss=FALSE;
	pBot->f_take_damage=false; //clear it for next check

	// RJ Abort conditions.
	if (pBot->RocketJumping && ((pEdict->v.waterlevel == 3) || (pBot->RJTime < gpGlobals->time)))
	{	
		pBot->RocketJumping = false;
		pBot->curr_waypoint_index = -1;	   
	}

	/////////////
	// More RJ //
	/////////////   
	if (pBot->RocketJumping && (pEdict->v.velocity.z>350))
	{	
		//UTIL_HostSay(pEdict,0,"done");
		pBot->RocketJumping = false;
		pBot->backwards = false;
		pBot->curr_waypoint_index = pBot->RJwp;	
		//BotHeadTowardWaypoint(pBot);
	}
	pBot->lastFrameHealth = BotHealthValue(pBot->pEdict);
}


void script(const char* sz)
{
	//return;
	int i,j,current_msg;
	msg_com_struct *curr;
	bool execif;

	if(g_bot_debug)
	{
		char msg[255];
		snprintf(msg,250,"msg (%s)\n",sz);
		ALERT( at_console, msg);
		{ fp=fopen("bot.txt","a"); fprintf(fp,"msg (%s)\n",sz); fclose(fp); }
	}

	for(current_msg=0;current_msg<MSG_MAX;current_msg++)
	{
		if(sz!=NULL && (msg_msg[current_msg])!=NULL &&
			sz[0]!=0 && (msg_msg[current_msg])[0]!=0)
		{
			//ALERT( at_console, msg_msg[current_msg]);
			//ALERT( at_console, "-\n");
			//some meassages have line returns, so check
			char msg2[255];
			snprintf(msg2,250,"%s\n",msg_msg[current_msg]);
			if(strcmp(sz,msg_msg[current_msg])==0 ||
				strcmp(sz,msg2)==0)
			{
				//{ fp=fopen("bot.txt","a"); fprintf(fp,"a %d\n",current_msg); fclose(fp); }
				if(msg_com[current_msg].ifs[0]==NULL)
				{
					if(g_bot_debug)
					{
						char msg[255];
						snprintf(msg,250,"no if : %s +++ %s %d\n",msg_msg[current_msg],sz,current_msg);
						ALERT( at_console, msg);
						//{ fp=fopen("bot.txt","a"); fprintf(fp,msg,sz); fclose(fp); }
					}
					for(i=0;i<8;i++)
					{
						j=msg_com[current_msg].blue_av[i];
						if(j==1) blue_av[i]=true;
						else if(j==0) blue_av[i]=false;
						j=msg_com[current_msg].red_av[i];
						if(j==1) red_av[i]=true;
						else if(j==0) red_av[i]=false;
						j=msg_com[current_msg].yellow_av[i];
						if(j==1) yellow_av[i]=true;
						else if(j==0) yellow_av[i]=false;
						j=msg_com[current_msg].green_av[i];
						if(j==1) green_av[i]=true;
						else if(j==0) green_av[i]=false;
					}
				}
				//now deal with ifs... on message may start with an if (no default behaviour)
				//{ fp=fopen("bot.txt","a"); fprintf(fp,"b %d\n",current_msg); fclose(fp); }

				curr=&msg_com[current_msg];
				while(curr!=NULL && curr!=0 && (int)curr!=-1)
				{
					//{ fp=fopen("bot.txt","a"); fprintf(fp,"Started while %s %d\n",sz,current_msg); fclose(fp); }
					if(curr->ifs[0]!=NULL)
					{
						execif=false;

						//{ fp=fopen("bot.txt","a"); fprintf(fp, "%s\n",curr->ifs); fclose(fp); }
						//problem with 0 being returned by atoi??
						if(strncmp(curr->ifs,"b_p_",4)==0)
							if(atoi(&curr->ifs[4])>0 && atoi(&curr->ifs[4])<9)
								if(blue_av[atoi(&curr->ifs[4])-1]) execif=true;
						if(strncmp(curr->ifs,"r_p_",4)==0)
							if(atoi(&curr->ifs[4])>0 && atoi(&curr->ifs[4])<9)
								if(red_av[atoi(&curr->ifs[4])-1]) execif=true;
						if(strncmp(curr->ifs,"g_p_",4)==0)
							if(atoi(&curr->ifs[4])>0 && atoi(&curr->ifs[4])<9)
								if(green_av[atoi(&curr->ifs[4])-1]) execif=true;
						if(strncmp(curr->ifs,"y_p_",4)==0)
							if(atoi(&curr->ifs[4])>0 && atoi(&curr->ifs[4])<9)
								if(yellow_av[atoi(&curr->ifs[4])-1]) execif=true;
						//points not available
						if(strncmp(curr->ifs,"b_pn_",5)==0)
							if(atoi(&curr->ifs[5])>0 && atoi(&curr->ifs[5])<9)
								if(!blue_av[atoi(&curr->ifs[5])-1]) execif=true;
						if(strncmp(curr->ifs,"r_pn_",5)==0)
							if(atoi(&curr->ifs[5])>0 && atoi(&curr->ifs[5])<9)
								if(!red_av[atoi(&curr->ifs[5])-1]) execif=true;
						if(strncmp(curr->ifs,"g_pn_",5)==0)
							if(atoi(&curr->ifs[5])>0 && atoi(&curr->ifs[5])<9)
								if(!green_av[atoi(&curr->ifs[5])-1]) execif=true;
						if(strncmp(curr->ifs,"y_pn_",5)==0)
							if(atoi(&curr->ifs[5])>0 && atoi(&curr->ifs[5])<9)
								if(!yellow_av[atoi(&curr->ifs[5])-1]) execif=true;
						//multi ifs
						if(strncmp(curr->ifs,"b_mp_",5)==0)
						{
							bool con=true;
							for(int k=0;k<8;k++)
							{
								if((curr->ifs[k+5]=='0' || curr->ifs[k+5]=='1') && con)
								{
									//set to false
									//only set to true if we can continue and exec if
									con=false;
									if(curr->ifs[k+5]=='1')
									{
										if(blue_av[k]) 
										{
											con=true;
										}
									}
									else
									{
										if(!blue_av[k]) 
										{
											con=true;
										}
									}
								}
							}
							if(con) execif=true;
						}
						if(strncmp(curr->ifs,"r_mp_",5)==0)
						{
							bool con=true;
							for(int k=0;k<8;k++)
							{
								if((curr->ifs[k+5]=='0' || curr->ifs[k+5]=='1') && con)
								{
									//set to false
									//only set to true if we can continue and exec if
									con=false;
									if(curr->ifs[k+5]=='1')
									{
										if(red_av[k]) 
										{
											con=true;
										}
									}
									else
									{
										if(!red_av[k]) 
										{
											con=true;
										}
									}
								}
							}
							if(con) execif=true;
						}
						if(strncmp(curr->ifs,"g_mp_",5)==0)
						{
							bool con=true;
							for(int k=0;k<8;k++)
							{
								if((curr->ifs[k+5]=='0' || curr->ifs[k+5]=='1') && con)
								{
									//set to false
									//only set to true if we can continue and exec if
									con=false;
									if(curr->ifs[k+5]=='1')
									{
										if(green_av[k]) 
										{
											con=true;
										}
									}
									else
									{
										if(!green_av[k]) 
										{
											con=true;
										}
									}
								}
							}
							if(con) execif=true;
						}
						if(strncmp(curr->ifs,"y_mp_",5)==0)
						{
							bool con=true;
							for(int k=0;k<8;k++)
							{
								if((curr->ifs[k+5]=='0' || curr->ifs[k+5]=='1') && con)
								{
									//set to false
									//only set to true if we can continue and exec if
									con=false;
									if(curr->ifs[k+5]=='1')
									{
										if(yellow_av[k]) 
										{
											con=true;
										}
									}
									else
									{
										if(!yellow_av[k]) 
										{
											con=true;
										}
									}
								}
							}
							if(con) execif=true;
						}

						//{ fp=fopen("bot.txt","a"); fprintf(fp, "-pass\n"); fclose(fp); }
						if(g_bot_debug)
						{
							char msg[255];
							snprintf(msg,250,"if : %s +++ %s %d \nComparing point %s\n",msg_msg[current_msg],sz,current_msg,(curr->ifs)+4);
							ALERT( at_console, msg);
							//{ fp=fopen("bot.txt","a"); fprintf(fp,msg,sz); fclose(fp); }
						}
						if(execif)
						{
							if(g_bot_debug)
							{
								char msg[255];
								sprintf(msg,"Executing if\n");
								ALERT( at_console, msg);
								//{ fp=fopen("bot.txt","a"); fprintf(fp,msg,sz); fclose(fp); }
							}
							for(i=0;i<8;i++)
							{
								j=curr->blue_av[i];
								if(j==1) blue_av[i]=true;
								else if(j==0) blue_av[i]=false;
								j=curr->red_av[i];
								if(j==1) red_av[i]=true;
								else if(j==0) red_av[i]=false;
								j=curr->yellow_av[i];
								if(j==1) yellow_av[i]=true;
								else if(j==0) yellow_av[i]=false;
								j=curr->green_av[i];
								if(j==1) green_av[i]=true;
								else if(j==0) green_av[i]=false;
							}
						}
					}
					curr=curr->next;
				}
			}
		}
	}
	for(j=0;j<32;j++)
	{
		if(bots[j].is_used)
		{
			int ii,ij,index;
			ij=-1;
			index=bots[j].goto_wp;
			ii=UTIL_GetTeam(bots[j].pEdict);
			if(index!=-1 && index<num_waypoints && ii!=-1)
			{
				bool fc=true;
				bool fcc=false;
				if((waypoints[index].flags & W_FL_POINT1) == W_FL_POINT1) 
				{
					fcc=true;
					ij=0;
					switch(ii)
					{
					case 0: if(blue_av[ij]==true) fc=false;
						break;
					case 1: if(red_av[ij]==true) fc=false;
						break;
					case 2: if(yellow_av[ij]==true) fc=false;
						break;
					case 3: if(green_av[ij]==true) fc=false;
						break;
					}
				}
				if((waypoints[index].flags & W_FL_POINT2) == W_FL_POINT2) 
				{
					ij=1;
					fcc=true;
					switch(ii)
					{
					case 0: if(blue_av[ij]==true) fc=false;
						break;
					case 1: if(red_av[ij]==true) fc=false;
						break;
					case 2: if(yellow_av[ij]==true) fc=false;
						break;
					case 3: if(green_av[ij]==true) fc=false;
						break;
					}
				}
				if((waypoints[index].flags & W_FL_POINT3) == W_FL_POINT3) 
				{
					ij=2;
					fcc=true;
					switch(ii)
					{
					case 0: if(blue_av[ij]==true) fc=false;
						break;
					case 1: if(red_av[ij]==true) fc=false;
						break;
					case 2: if(yellow_av[ij]==true) fc=false;
						break;
					case 3: if(green_av[ij]==true) fc=false;
						break;
					}
				}
				if((waypoints[index].flags & W_FL_POINT4) == W_FL_POINT4) 
				{
					ij=3;
					fcc=true;
					switch(ii)
					{
					case 0: if(blue_av[ij]==true) fc=false;
						break;
					case 1: if(red_av[ij]==true) fc=false;
						break;
					case 2: if(yellow_av[ij]==true) fc=false;
						break;
					case 3: if(green_av[ij]==true) fc=false;
						break;
					}
				}
				if((waypoints[index].flags & W_FL_POINT5) == W_FL_POINT5) 
				{
					ij=4;
					fcc=true;
					switch(ii)
					{
					case 0: if(blue_av[ij]==true) fc=false;
						break;
					case 1: if(red_av[ij]==true) fc=false;
						break;
					case 2: if(yellow_av[ij]==true) fc=false;
						break;
					case 3: if(green_av[ij]==true) fc=false;
						break;
					}
				}
				if((waypoints[index].flags & W_FL_POINT6) == W_FL_POINT6) 
				{
					ij=5;
					fcc=true;
					switch(ii)
					{
					case 0: if(blue_av[ij]==true) fc=false;
						break;
					case 1: if(red_av[ij]==true) fc=false;
						break;
					case 2: if(yellow_av[ij]==true) fc=false;
						break;
					case 3: if(green_av[ij]==true) fc=false;
						break;
					}
				}
				if((waypoints[index].flags & W_FL_POINT7) == W_FL_POINT7) 
				{
					ij=6;
					fcc=true;
					switch(ii)
					{
					case 0: if(blue_av[ij]==true) fc=false;
						break;
					case 1: if(red_av[ij]==true) fc=false;
						break;
					case 2: if(yellow_av[ij]==true) fc=false;
						break;
					case 3: if(green_av[ij]==true) fc=false;
						break;
					}
				}
				if((waypoints[index].flags & W_FL_POINT8) == W_FL_POINT8) 
				{
					ij=7;
					fcc=true;
					switch(ii)
					{
					case 0: if(blue_av[ij]==true) fc=false;
						break;
					case 1: if(red_av[ij]==true) fc=false;
						break;
					case 2: if(yellow_av[ij]==true) fc=false;
						break;
					case 3: if(green_av[ij]==true) fc=false;
						break;
					}
				}
				if(fc && fcc) bots[j].goto_wp=-1;
			}
		}
	}
}

int BotArmorValue(edict_t *pEdict)
{	
	// BotArmorValue - returns the percentage of armor a bot has.
	int tfc_max_armor[10] = {0, 50, 50, 200, 120, 100, 300, 150, 100, 50};
	if(mod_id==TFC_DLL && pEdict->v.playerclass >= 0 && pEdict->v.playerclass <=9)
		return (pEdict->v.armorvalue / tfc_max_armor[pEdict->v.playerclass] * 100);
	// Unknown mod, return 100%
	return 100;
}

int BotHealthValue(edict_t *pEdict)
{	
	// BotHealthValue - returns the percentage of health a bot has.
	if(mod_id==TFC_DLL)
		return (pEdict->v.health/pEdict->v.max_health)*100;

	// Unknown mod, return 100%
	return 100;
}

void BotSprayLogo(edict_t *pEntity) 
{ 
	int index=-1; 
	TraceResult pTrace; 
	Vector v_src, v_dest; 
	UTIL_MakeVectors(pEntity->v.v_angle); 
	v_src = pEntity->v.origin;// + pEntity->v.view_ofs; 
	//v_dest = v_src + gpGlobals->v_forward * 80; 
	v_dest = pEntity->v.origin - Vector(0,0,80); 
	UTIL_TraceLine( v_src, v_dest, ignore_monsters, pEntity->v.pContainingEntity, &pTrace ); 

	int count=0;
	while(index<0 && count<10)
	{
		switch(RANDOM_LONG(0,10))
		{
		case 0:   index = DECAL_INDEX("{FOXBOT"); 
			break;
		case 1:   index = DECAL_INDEX("{FOXBOT0"); 
			break;
		case 2:   index = DECAL_INDEX("{FOXBOT1"); 
			break;
		case 3:   index = DECAL_INDEX("{FOXBOT2"); 
			break;
		case 4:   index = DECAL_INDEX("{FOXBOT3"); 
			break;
		case 5:   index = DECAL_INDEX("{FOXBOT4"); 
			break;
		case 6:   index = DECAL_INDEX("{FOXBOT5"); 
			break;
		case 7:   index = DECAL_INDEX("{FOXBOT6"); 
			break;
		case 8:   index = DECAL_INDEX("{FOXBOT7"); 
			break;
		case 9:   index = DECAL_INDEX("{FOXBOT8"); 
			break;
		case 10:   index = DECAL_INDEX("{FOXBOT9"); 
			break;
		}
		count++;
	}

	if (index < 0) index = DECAL_INDEX("{FOXBOT"); 
	if (index < 0) 
		//return; 
		//index=0;
	{
		switch(RANDOM_LONG(1,4))
		{
		case 1:   index = DECAL_INDEX("{BIOHAZ"); 
			break;
		case 2:   index = DECAL_INDEX("{TARGET"); 
			break;
		case 3:   index = DECAL_INDEX("{LAMBDA06"); 
			break;
		case 4:   index = DECAL_INDEX("{GRAF004"); 
			break;
		}
	}
	if (index < 0) 
		//return; 
		index=0;

	if ((pTrace.pHit) && (pTrace.flFraction < 1.0)) 
	{ 
		if (pTrace.pHit->v.solid != SOLID_BSP) 
			return; 

		MESSAGE_BEGIN( MSG_BROADCAST, SVC_TEMPENTITY ); 

		if (index > 255) 
		{ 
			WRITE_BYTE( TE_WORLDDECALHIGH); 
			index -= 256; 
		} 
		else 
			WRITE_BYTE( TE_WORLDDECAL ); 

		WRITE_COORD( pTrace.vecEndPos.x ); 
		WRITE_COORD( pTrace.vecEndPos.y ); 
		WRITE_COORD( pTrace.vecEndPos.z ); 
		WRITE_BYTE( index ); 

		MESSAGE_END(); 

		EMIT_SOUND_DYN2(pEntity, CHAN_VOICE, "player/sprayer.wav", 1.0, ATTN_NORM, 0, 100); 
	} 
}


void BotSGSpotted(bot_t *pBot, edict_t *sg)
{		
	// BotSGSpotted - This function handles the storing, and communicating of sentry/mg positions to teammates.
	// When a bot see's a sentry, this function is called. It will be up to this function to determine if he
	// already knows about it. If none of the bots on the team know about it, he will communicate it to the team
	// using area names if available. Either way, the location is transferred to other bots memory if 
	// a) They dont have a sg in memory b) They are better than skill 5

	// Double check this isnt our own teams.
	int team=UTIL_GetTeam(pBot->pEdict);
	int sentry_team = BotTeamColorCheck(sg);	
	if (sentry_team == team)
		return;

	// Always set our last SG
	pBot->pBotLastSgEnemy = sg;

	// Check other bots if they know about this sg. If so, we wont announce it.
	int i;
	for(i = 0; i < 32; i++)	
	{		
		if(bots[i].is_used)
		{
			if((bots[i].pBotLastSgEnemy == sg)&& (&bots[i] != pBot))				
				return;						
		}									 
	}	

	// Skill 5's are too dumb to communicate
	if (pBot->bot_skill == 5)
		return;

	// Communicate!
	int area = AreaInsideClosest(sg);
	if(area != -1)
	{
		char ss[255];		
		if(team==0) sprintf(ss,"Sentry Spotted %s",areas[area].namea);
		if(team==1) sprintf(ss,"Sentry Spotted %s",areas[area].nameb);
		if(team==2) sprintf(ss,"Sentry Spotted %s",areas[area].namec);
		if(team==3) sprintf(ss,"Sentry Spotted %s",areas[area].named);
		if(strcmp(pBot->lastmessage,ss)!=0)
			UTIL_HostSay(pBot->pEdict,1, ss);
		strcpy(pBot->lastmessage,ss);
	}
	// Tells the other bots about this sg if they dont know of one already.
	for(i = 0; i < 32; i++)	
	{		
		if(bots[i].is_used)
		{
			if(!bots[i].pBotLastSgEnemy)
			{
				// skill 5's are too dumb, everyone else has 1 in 10 chance of not "getting it"
				if (bots[i].bot_skill==5 || RANDOM_LONG(1,10)>1)
					continue;
				bots[i].pBotLastSgEnemy = pBot->pBotLastSgEnemy;	
			}
		}									 
	}	
}

// We check for visible and in-range jump points in this function
void BotCheckForJump(bot_t *pBot)
{
	// BotCheckForJump - Here, we look through the list of RJ/CJ waypoints in the map to find the closest one.
	// Once we find the closest we check to see if we can see it, and if it would save us distance to our current
	// goal. If so, we initiate a Rocket Jump for that waypoint. There are numerous checks for abort conditions in here.
	// TODO : This needs to be modified to consider the closest, say.. 2-5 RJ waypoints. Otherwise points set somewhat
	// close will be ignored and the closest will get favored every time, often resulting in the same point.
	// AVOID TRACELINES TILL NECESSARY. Prioritize the top 3-5 points by distance saved to the bots goal before 
	// checking for visibility.

	// Get out if we already have a RJ
	if (pBot->RocketJumping)
		return;

	char *cvar_ntf = (char *)CVAR_GET_STRING("neotf");
	char *cvar_ntfexclusive = (char *)CVAR_GET_STRING("ntf_feature_exclusive");

	// Get out if we are a pyro or spy, but no Neotf
	if (pBot->pEdict->v.playerclass == TFC_CLASS_PYRO)
	{		
		char *cvar_jetpack = (char *)CVAR_GET_STRING("ntf_feature_jetpack");
		if((strcmp(cvar_ntf,"1")==0) && (strcmp(cvar_jetpack,"1")==0)) // No neotf or jetpack
		{
			// Jetpack enabled
		} else
            return;		
	} 
	else if (pBot->pEdict->v.playerclass == TFC_CLASS_SPY)
	{
		// TODO : KICK SPIES OUT FOR NOW, UNTIL HOVERBOARD.
		return;  

		char *cvar_hoverboard = (char *)CVAR_GET_STRING("ntf_feature_hoverboard");
		if((strcmp(cvar_ntf,"1")==0) && (strcmp(cvar_hoverboard,"1")==0)) // No neotf or jetpack
		{
			// Hoverboard enabled
		} else
			return;
	}


	// Set the next check time
	pBot->RJ_checkTime = gpGlobals->time + 1.0;
	int closestIndex = -1;
	float closest = 9999.0f;
	float distance;
	int bot_team = UTIL_GetTeam(pBot->pEdict);

	for (int i = 0; i < bot_t::MAXRJWAYPOINTS; i++)
	{
		// -1 means we are at the end of the list.
		if (RJPoints[i][0] == -1)
			break;

		// If its our team or not team specific.
		if (((RJPoints[i][1] == -1) || (RJPoints[i][1] == bot_team)) && RJPoints[i][0] != -1)
		{
			// Get the distance.
			distance = (pBot->pEdict->v.origin - waypoints[RJPoints[i][0]].origin).Length();
			if (distance < closest)
			{
				closest = distance;
				closestIndex = RJPoints[i][0];
			}
		}		
	}
	/*char msg[80];
	sprintf(msg, "Closest Jump Index: %d Distance: %f ", closestIndex, closest);
	UTIL_HostSay(pBot->pEdict, 0, msg);*/

	// If theres no RJ point get out.
	if (closestIndex == -1)
		return;

	// Check if its a good time to jump
	// 1) Resulting waypoint closer to goal than we are now (> 1000 distance savings for now)
	// 2) Enough Health Enough Armor
	float distanceSaved = 0.0f;
	if (pBot->curr_waypoint_index != -1)
		distanceSaved = (WaypointDistanceFromTo(pBot->curr_waypoint_index, pBot->goto_wp, bot_team) - WaypointDistanceFromTo(closestIndex, pBot->goto_wp, bot_team));

	// Don't bother if the distance it saves us is less than this.
	if (distanceSaved < 1000)
		return;

	// TODO: maybe put some shit in here that "weighs" whether we should or not
	if (BotHealthValue(pBot->pEdict) < 30 || BotArmorValue(pBot->pEdict) < 30)
		return;

	// If closest point is within range... pick a #
	if (closest < 1000)
	{		
		// Check visibility
		TraceResult result;
		UTIL_TraceLine(waypoints[closestIndex].origin+Vector(0,0,35), pBot->pEdict->v.origin, ignore_monsters, pBot->pEdict->v.pContainingEntity, &result);
		if (!(result.flFraction >= 1.0))
			return;		
		else
		{
			pBot->RJwp = closestIndex;
			pBot->curr_waypoint_index = pBot->RJwp;	
			pBot->RJTime = gpGlobals->time + 8;
			pBot->RocketJumping = true;		
			pBot->ras = true;
			pBot->RJHeadingTime = gpGlobals->time + 0.12f;
			float zDiff = waypoints[pBot->curr_waypoint_index].origin.z - pBot->pEdict->v.origin.z;
			float distance = (waypoints[pBot->curr_waypoint_index].origin - pBot->pEdict->v.origin).Length();
			// Get some closing distances based on zdiff & distance.
			if (zDiff > 400)
				pBot->RJClosingDistance = 200;
			else if (zDiff < 200 && distance < 325)
			{
				pBot->RJClosingDistance = 175;
				pBot->RJHeadingTime = 0;
			}
			else
				pBot->RJClosingDistance = 500;

			/*char msg[80];
			sprintf(msg, "CloseDist: %f Distance: %f zDiff %f ", pBot->RJClosingDistance, distance, zDiff);
			UTIL_HostSay(pBot->pEdict, 0, msg);*/

		}		
	} else 
		pBot->RocketJumping = false;	
}

void BotCheckForConcJump(bot_t *pBot)
{
	// BotCheckForConcJump - Here, we look through the list of RJ/CJ waypoints in the map to find the closest one.
	// Once we find the closest we check to see if we can see it, and if it would save us distance to our current
	// goal. If so, we initiate a Conc Jump for that waypoint. There are numerous checks for abort conditions in here.
	// TODO : This needs to be modified to consider the closest, say.. 2-5 Conc waypoints. Otherwise points set somewhat
	// close will be ignored and the closest will get favored every time, often resulting in the same point.
	// AVOID TRACELINES TILL NECESSARY. Prioritize the top 3-5 points by distance saved to the bots goal before 
	// checking for visibility.

	// Get out if we already have a RJ
	if (pBot->ConcJumping || (pBot->curr_waypoint_index == -1) || (pBot->goto_wp == -1))
		return;
	// Set the next check time
	pBot->RJ_checkTime = gpGlobals->time + 1.0f;	

	// Lets not check for concs if we are close to our goal.
	if (WaypointDistanceFromTo(pBot->curr_waypoint_index, pBot->goto_wp, UTIL_GetTeam(pBot->pEdict)) < 2000)
		return;

	// We need to look ahead based on this speed, to try and estimate where we will be in 4 seconds
	// If we can see a conc point from there, prime now.

	// Need to get my velocity, my current waypoint
	float mySpeed = pBot->pEdict->v.velocity.Length2D();
	int currentWP = pBot->curr_waypoint_index;
	int endWP;
	float distAhead = 0;
	float distanceSaved = 0;

	// Lets try enforcing a minimum speed for considering jumps.
	if (mySpeed < 180)
		return;

	int safetyCounter = 0;
	while (distAhead < (mySpeed*3) && (safetyCounter < 30))
	{
		// Get the waypoint after next in our route.
		endWP = WaypointRouteFromTo(currentWP, pBot->goto_wp, UTIL_GetTeam(pBot->pEdict));
		// Add the distance
		distAhead += WaypointDistanceFromTo(currentWP, endWP, UTIL_GetTeam(pBot->pEdict));
		// Set current wp to the next one. This should keep checking ahead with each loop iteration.
		currentWP = endWP;
		safetyCounter++;
	}

	// Get out if for some reason we hit out safely counters limit.
	if (safetyCounter == 30)
	{
		//UTIL_HostSay(pBot->pEdict, 0, "Safety counter hit");
		return;
	}

	// Find the closest RJ point from there
	int closestIndex = -1;
	float closest = 9999.0f;
	float distance;
	int bot_team = UTIL_GetTeam(pBot->pEdict);
	for (int i = 0; i < bot_t::MAXRJWAYPOINTS; i++)
	{
		// -1 means we are at the end of the list.
		if (RJPoints[i][0] == -1)
			break;

		// If its our team or not team specific.
		if (((RJPoints[i][1] == -1) || (RJPoints[i][1] == bot_team)) && RJPoints[i][0] != -1)
		{
			// Get the distance.
			distance = (waypoints[endWP].origin - waypoints[RJPoints[i][0]].origin).Length();
			if (distance < closest)
			{
				closest = distance;
				closestIndex = RJPoints[i][0];
			}
		}
	}
	// If theres no RJ point get out.
	if (closestIndex == -1)
		return;

	if (pBot->curr_waypoint_index != -1)
		distanceSaved = (WaypointDistanceFromTo(endWP, pBot->goto_wp, bot_team) - WaypointDistanceFromTo(closestIndex, pBot->goto_wp, bot_team));    
	// Don't bother if the distance it saves us is less than this.
	if (distanceSaved < 1000)
		return;

	// Got the waypoint out near our reach.
	//if (g_bot_debug)
	//WaypointDrawBeam(INDEXENT(1), pBot->pEdict->v.origin, waypoints[endWP].origin, 30, 0, 125, 125, 125, 250, 5);

	if (closest < 1000)
	{		
		// Check visibility
		TraceResult result;
		UTIL_TraceLine(waypoints[closestIndex].origin+Vector(0,0,35), waypoints[endWP].origin, ignore_monsters, pBot->pEdict->v.pContainingEntity, &result);
		if (!(result.flFraction >= 1.0))
			return;		
		else
		{
			pBot->ConcJumping = true;
			pBot->RJwp = closestIndex;	
			pBot->ras = true;
			FakeClientCommand(pBot->pEdict,"+gren2", "101",NULL);
			pBot->primeTime = gpGlobals->time;
		}		
	} else 
		pBot->ConcJumping = false;    
}

// Called by the Sound Hooking Code (in EMIT_SOUND)
void BotSoundSense(edict_t *pEdict,const char *pszSample,float fVolume)
{
	// This function is going to handle all the sounds that bots will be responding to
	// We are going to loop through all the bots when we recieve a sound, and push them onto
	// a stack of sounds for the bot.

	/*if (bots[0].pEdict && UTIL_GetTeam(pEdict) != -1)
	{
		char msg[80];
		strcpy(msg, pszSample);
		UTIL_HostSay(bots[0].pEdict, 0, msg);
		if (pEdict)
		{
			sprintf(msg, "pedict team %d", UTIL_GetTeam(pEdict));
			UTIL_HostSay(bots[0].pEdict, 0, msg);
		}
	}*/

	if(!pEdict || UTIL_GetTeam(pEdict) == -1)
		return;

	Vector vecPosition;	
	float hearingDistance = 9999;
	float botDistance;
	int botTeam, threatTeam;
	threatTeam = UTIL_GetTeam(pEdict);   
	// Grenade primer
	if(strncmp("weapons/ax1", pszSample, 11) == 0 || strncmp("player/pain", pszSample, 11) == 0 || 
		strncmp("items/armoron_1", pszSample, 15) == 0 || strncmp("items/smallmedkit", pszSample, 17) == 0 || 
		strncmp("items/ammopickup", pszSample, 16) == 0)
	{
		hearingDistance = 1500 * fVolume;
		for (int i = 0; i < 32; i++)
		{
			if(bots[i].is_used) // Is this a bot?
			{
				botTeam = UTIL_GetTeam(bots[i].pEdict);
				botDistance = (bots[i].pEdict->v.origin - pEdict->v.origin).Length();
				if (botDistance < hearingDistance)
				{
					int closestWPToThreat = WaypointFindNearest(pEdict->v.origin, 500, botTeam);

					// This bot can hear it. Try going to it if we have no enemy.
					if (!bots[i].pBotEnemy && (bots[i].mission == bot_t::Defender) && (botTeam != threatTeam) && 
						RANDOM_LONG(1, 100) < (100 - bots[i].bot_skill*10) && (bots[i].pEdict->v.playerclass != TFC_CLASS_ENGINEER))
					{						
						// Crash prevention
						if (bots[i].curr_waypoint_index == -1)
							return;

						int respondDist = defendMaxRespondDist[bots[i].pEdict->v.playerclass];
						// reduce respond range for piped demos
						if (bots[i].pEdict->v.playerclass == TFC_CLASS_DEMOMAN && bots[i].piped || bots[i].piping)
							respondDist *= 0.70;

						// Respond if we are within range
						if (WaypointDistanceFromTo(bots[i].curr_waypoint_index, closestWPToThreat, botTeam) < respondDist)
						{
							// If it's a spy, and we can see it, attack the mofo
							if (pEdict->v.playerclass == TFC_CLASS_SPY)							
								if (FInViewCone(&pEdict->v.origin, bots[i].pEdict) && FVisible(pEdict->v.origin, bots[i].pEdict))
									bots[i].pBotEnemy = pEdict;
							
							bots[i].goto_wp = closestWPToThreat;
							bots[i].f_pause_time = gpGlobals->time;
							bots[i].defendPoint = -1;
							//UTIL_HostSay(bots[i].pEdict, 0, "Heard something.");
						}
					}
				}
			}
		}
	}	
	
	// Detpack charge
	//else if( strncmp("weapons/mine_activate", pszSample, 21) == 0) 
	//{
	//	hearingDistance = 1000 * fVolume;
	//	// Lets find the closest scout to the source.
	//	int closestScoutIndex = -1;
	//	int closestScoutDistance = 9999;
	//	int distance;
	//	for (int i = 0; i < 32; i++)
	//	{
	//		if(bots[i].is_used && (bots[i].pEdict->v.playerclass == TFC_CLASS_SCOUT)) // Is this a bot?
	//		{
	//			distance = (bots[i].pEdict->v.origin-pEdict->v.origin).Length();
	//			if (distance < closestScoutDistance)
	//			{
	//				closestScoutDistance = distance;
	//				closestScoutIndex = i;
	//			}
	//		}
	//	}
	//	// Didn't find one? Get out.
	//	if (closestScoutIndex == -1)
	//		return;
	//	int closestWPToDetpack = WaypointFindNearest(pEdict->v.origin, 500, UTIL_GetTeam(bots[i].pEdict));
	//	if (closestWPToDetpack != -1)
	//	{
	//		bots[closestScoutIndex].goto_wp = closestWPToDetpack;
	//		bots[closestScoutIndex].goalType = bots[closestScoutIndex].Detpack;
	//		bots[closestScoutIndex].curr_waypoint_index = WaypointFindNearest(bots[closestScoutIndex].pEdict->v.origin, 500, UTIL_GetTeam(bots[closestScoutIndex].pEdict));
	//		UTIL_HostSay(bots[closestScoutIndex].pEdict, 0, "Heard a detpack, goin for it");
	//	}
	//}
	//// building sentry
	//else if( strncmp("weapons/building", pszSample, 16) == 0) 
	//{
	//	hearingDistance = 1000 * fVolume;
	//}
	//// Sentry Idle
	//else if( strncmp("weapons/turridle", pszSample, 16) == 0) 
	//{
	//	hearingDistance = 1000 * fVolume;
	//}
	//// Sentry building
	//else if( strncmp("weapons/turrset", pszSample, 15) == 0) 
	//{
	//	hearingDistance = 1000 * fVolume;
	//}
	//// Sentry targetting
	//else if( strncmp("weapons/turrspot", pszSample, 16) == 0) 
	//{
	//	hearingDistance = 1000 * fVolume;
	//}	
	//// Medic call ?
	//else if ( strncmp("speech/saveme1", pszSample, 14) == 0 || strncmp("speech/saveme2", pszSample, 14) == 0)
	//{		
	//	hearingDistance = 1000 * fVolume;
	//}		 		
}

edict_t *BotSGAtPoint(const Vector &location, const float range)
{
	// BotSGAtPoint - By giving this function a vector to check and a range to check, it will return the first SG it finds
	// at the location passed, or NULL if none. This should be useful for eliminating engineers building guns at the 
	// same defense points. 
	edict_t *pent = NULL;	
	while ((pent = FIND_ENTITY_IN_SPHERE( pent, location, range )) != NULL && (!FNullEnt(pent)))
	{
		//strcpy(item_name, STRING(pent->v.classname));
		if (strcmp("building_sentrygun", STRING(pent->v.classname)) == 0)
			return pent;
	}
	return NULL;
}

edict_t *BotTeleporterAtPoint(const Vector &location, const float range)
{
	// BotSGAtPoint - By giving this function a vector to check and a range to check, it will return the first teleporter it finds
	// at the location passed, or NULL if none. This should be useful for eliminating engineers building tps at the 
	// same points. 
	edict_t *pent = NULL;	
	while ((pent = FIND_ENTITY_IN_SPHERE( pent, location, range )) != NULL && (!FNullEnt(pent)))
	{
		//strcpy(item_name, STRING(pent->v.classname));
		if (strcmp("building_teleporter", STRING(pent->v.classname)) == 0)
			if(pent->v.health > 0)
				return pent;
	}
	return NULL;
}

bot_t *BotDefenderAtPoint(const bot_t *pBot, const Vector &location, const float range)
{
	// BotDefenderAtPoint - By giving this function a vector to check, and a range to check, it will return the first
	// bot that is also on defense within the range, or NULL if none. This is used to try to prevent defenders from choosing
	// the same defend points. We ignore engineer defenders, so normal defenders have a chance of taking up positions with
	// the engys.
	for (int i = 0; i < 32; i++)
	{
		// Is this a bot, not myself, and is it a defender also?
		if(bots[i].is_used && (&bots[i] != pBot) && (bots[i].mission == pBot->Defender))
		{			
			if (bots[i].defendPoint != -1)
			{
				if ((waypoints[bots[i].curr_waypoint_index].origin - location).Length() <= range)
					if ((pBot->pEdict->v.playerclass == TFC_CLASS_ENGINEER) && (bots[i].pEdict->v.playerclass == TFC_CLASS_ENGINEER))
						continue;
					else
					{
						// Dont trigger it if I'm a sniper unless the other guy is also a sniper. 
						// Dont need snipers choosing new spots if an engy runs by or something.
						if ((pBot->pEdict->v.playerclass == TFC_CLASS_SNIPER) && (bots[i].pEdict->v.playerclass != TFC_CLASS_SNIPER))
							continue;
						return &bots[i];                    
					}
			}			
		}
	}
	return NULL;
}

void BotEngineerThink(bot_t *pBot)
{
	// BotEngineerThink - This function handles an engineers building of sg's, dispensers, and mg's Code moved from BotThink

	// Make sure we are the right class & mod.
	if (pBot->pEdict->v.playerclass != TFC_CLASS_ENGINEER || mod_id != TFC_DLL)
		return;
	edict_t *pEdict = pBot->pEdict;
	edict_t *pent = NULL;

	//////////////////
	// Detdispenser //
	//////////////////	
	if(pBot->dispensor && pBot->dispensor_edict==NULL)
	{		  
		// Set up the det dispenser timer.
		if (!pBot->detTime)
			pBot->detTime = gpGlobals->time + RANDOM_LONG(0.0, pBot->bot_skill);
		// Det the dispenser if the timer is out.
		if (pBot->detTime < gpGlobals->time)
		{
			FakeClientCommand(pEdict,"detdispenser",NULL,NULL);
			pBot->dispensor=false;
			pBot->detTime = NULL;
		}
	}
	///////////////////////////////
	// Stop building if attacked //
	///////////////////////////////
	if((pBot->inact!=0 || pBot->sg_building) && (pBot->pBotEnemy || pBot->f_take_damage))
	{
		if(pBot->inact==2)
			FakeClientCommand(pEdict,"build",NULL,NULL);
		pBot->inact=0;
		pBot->f_pause_time=0;
		pBot->f_build_time=0;
	}

	///////////////////////////////
	// TELEPORTER ENTRANCE BUILD //
	///////////////////////////////
	//updated by yuraj
	if(bot_can_build_teleporter==true)
	if (((waypoints[pBot->curr_waypoint_index].flags & W_FL_TFC_TELEPORTER_ENTRANCE)==W_FL_TFC_TELEPORTER_ENTRANCE) && 
		mod_id==TFC_DLL && pEdict->v.playerclass == TFC_CLASS_ENGINEER && 
		(UTIL_GetTeam(pEdict)==(waypoints[pBot->curr_waypoint_index].flags & W_FL_TEAM) || (waypoints[pBot->curr_waypoint_index].flags & W_FL_TEAM_SPECIFIC)!=W_FL_TEAM_SPECIFIC) &&
		(waypoints[pBot->curr_waypoint_index].origin - pEdict->v.origin).Length() <= 400 && !pBot->pBotEnemy)
	{
		if (!pBot->hasTPEntrance && BotTeleporterAtPoint(waypoints[pBot->curr_waypoint_index].origin, 300))
		{
			pBot->curr_waypoint_index = -1; // clear it
			pBot->goto_wp = -1;
			pBot->sg_wp = -1;
			return;
		}
		pBot->backwards=false;

		// If i dont have a tp entrance
		if (!pBot->hasTPEntrance && (pBot->f_build_time<=gpGlobals->time) && (pBot->curr_waypoint_index == pBot->goto_wp) && !pBot->pBotEnemy)
		{
			if(pBot->inact==0 && !pBot->hasTPEntrance)
			{
				pBot->inact=1;
			}

			if(pBot->inact == 1)
			{
				pBot->backwards=false;				
				//aim at waypoint...			
				Vector v_direction = waypoints[pBot->curr_waypoint_index].origin - pEdict->v.origin;
				Vector bot_angles = UTIL_VecToAngles( v_direction );
				if(pBot->pBotEnemy==NULL) 
				{						 
					pBot->idle_angle = bot_angles.y;
					pEdict->v.ideal_yaw = pBot->idle_angle;
					if(pBot->backwards)
						pEdict->v.ideal_yaw=pEdict->v.ideal_yaw+180;
					pEdict->v.idealpitch = bot_angles.x;
				}
				//walk towards it
				if((waypoints[pBot->curr_waypoint_index].origin-pEdict->v.origin).Length()>80) 
					pBot->f_move_speed = pBot->f_max_speed/2;
				else 
					pBot->f_move_speed = pBot->f_max_speed/5;
				//what if theirs an obstuction?!
				int dis=8;
				//ok..increase distance after a few seconds of trying
				if(pBot->f_pause_time<(gpGlobals->time-3)) 
				{
					dis=200;
				}
				if((waypoints[pBot->curr_waypoint_index].origin-pEdict->v.origin).Length()<dis)
				{
					pBot->f_pause_time=gpGlobals->time+1;
					pBot->inact=2;
				}
				//do nothing if we can't reach it after 6 seconds
				if(pBot->f_pause_time<(gpGlobals->time-6)) pBot->inact=0;
			}
			if(pBot->inact==2)
			{
				pBot->backwards=false;
				//aim at waypoint...
				Vector v_direction;
				Vector bot_angles;
				if(pBot->f_pause_time>gpGlobals->time)
				{
					int i = WaypointFindNearestAiming(pEdict->v.origin);
					if(i==-1) 
						i=0;
					v_direction = waypoints[i].origin - pEdict->v.origin;
					bot_angles = UTIL_VecToAngles( v_direction );
					pBot->inact_veca=bot_angles;
					pBot->inact_vecb=v_direction;
				}
				else
				{
					bot_angles = pBot->inact_veca;
					v_direction = pBot->inact_vecb;
				}
				if(!pBot->pBotEnemy) 
				{
					pBot->idle_angle = bot_angles.y;
					pEdict->v.ideal_yaw = pBot->idle_angle;
					if(pBot->backwards)
						pEdict->v.ideal_yaw=pEdict->v.ideal_yaw+180;
					pEdict->v.idealpitch = bot_angles.x;				
				}
				//walk away from it
				pBot->f_move_speed=-(pBot->f_max_speed/3);
				if(pBot->f_pause_time<gpGlobals->time)
				{
					if(pBot->f_build_time < gpGlobals->time && pBot->sg_building)
					{
						// Announce the build
						for (int i=0; i < num_areas; i++)
						{
							//checks only for whole area delete.....
							if ((areas[i].flags & W_FL_DELETED) == W_FL_DELETED)
								continue;
							if(AreaInsideClosest(pBot->pEdict)==i) 
								pBot->curr_area=i;
						}
						if((pBot->curr_area!=-1) && defensive_chatter)
						{
							char ss[255];
							int t=UTIL_GetTeam(pBot->pEdict);
							if(t==0) sprintf(ss,"Building Teleporter Entrance %s",areas[pBot->curr_area].namea);
							if(t==1) sprintf(ss,"Building Teleporter Entrance %s",areas[pBot->curr_area].nameb);
							if(t==2) sprintf(ss,"Building Teleporter Entrance %s",areas[pBot->curr_area].namec);
							if(t==3) sprintf(ss,"Building Teleporter Entrance %s",areas[pBot->curr_area].named);
							if(strcmp(pBot->lastmessage,ss)!=0)
								UTIL_HostSay(pBot->pEdict,1, ss);
							strcpy(pBot->lastmessage,ss);
						}
					}
					if(pBot->f_build_time < (gpGlobals->time-0.5) && !pBot->sg_building)
					{
						FakeClientCommand(pEdict, "build", "4", NULL);
						pBot->f_build_time = gpGlobals->time;
					}
				}
			}
		}
	}
	///////////////////////////
	// TELEPORTER EXIT BUILD //
	///////////////////////////
		//updated by yuraj
	if(bot_can_build_teleporter==true)
	if (((waypoints[pBot->curr_waypoint_index].flags & W_FL_TFC_TELEPORTER_EXIT)==W_FL_TFC_TELEPORTER_EXIT) && 
		mod_id==TFC_DLL && pEdict->v.playerclass == TFC_CLASS_ENGINEER && 
		(UTIL_GetTeam(pEdict)==(waypoints[pBot->curr_waypoint_index].flags & W_FL_TEAM) || (waypoints[pBot->curr_waypoint_index].flags & W_FL_TEAM_SPECIFIC)!=W_FL_TEAM_SPECIFIC) &&
		(waypoints[pBot->curr_waypoint_index].origin - pEdict->v.origin).Length() <= 400 && !pBot->pBotEnemy)
	{
		// Check to see if a teleporter already exists here.
		if (!pBot->hasTPExit && BotTeleporterAtPoint(waypoints[pBot->curr_waypoint_index].origin, 300))
		{
			pBot->curr_waypoint_index = -1; // clear it
			pBot->goto_wp = -1;
			pBot->sg_wp = -1;
			return;
		}
		pBot->backwards=false;

		// If I dont have a tp exit
		if (!pBot->hasTPExit && (pBot->f_build_time<=gpGlobals->time) && (pBot->curr_waypoint_index == pBot->goto_wp) && !pBot->pBotEnemy)
		{
			if(pBot->inact==0 && !pBot->hasTPExit)
			{
				pBot->inact=1;
			}
			if(pBot->inact == 1)
			{
				pBot->backwards=false;				
				//aim at waypoint...			
				Vector v_direction = waypoints[pBot->curr_waypoint_index].origin - pEdict->v.origin;
				Vector bot_angles = UTIL_VecToAngles( v_direction );
				if(pBot->pBotEnemy==NULL) 
				{						 
					pBot->idle_angle = bot_angles.y;
					pEdict->v.ideal_yaw = pBot->idle_angle;
					if(pBot->backwards)
						pEdict->v.ideal_yaw=pEdict->v.ideal_yaw+180;
					pEdict->v.idealpitch = bot_angles.x;
				}
				//walk towards it
				if((waypoints[pBot->curr_waypoint_index].origin-pEdict->v.origin).Length()>80) 
					pBot->f_move_speed = pBot->f_max_speed/2;
				else 
					pBot->f_move_speed = pBot->f_max_speed/5;
				//what if theirs an obstuction?!
				int dis=8;
				//ok..increase distance after a few seconds of trying
				if(pBot->f_pause_time<(gpGlobals->time-3)) 
				{
					dis=200;
				}
				if((waypoints[pBot->curr_waypoint_index].origin-pEdict->v.origin).Length()<dis)
				{
					pBot->f_pause_time=gpGlobals->time+1;
					pBot->inact=2;
				}
				//do nothing if we can't reach it after 6 seconds
				if(pBot->f_pause_time<(gpGlobals->time-6)) pBot->inact=0;
			}
			if(pBot->inact==2)
			{
				pBot->backwards=false;
				//aim at waypoint...
				Vector v_direction;
				Vector bot_angles;
				if(pBot->f_pause_time>gpGlobals->time)
				{
					int i = WaypointFindNearestAiming(pEdict->v.origin);
					if(i==-1) 
						i=0;
					v_direction = waypoints[i].origin - pEdict->v.origin;
					bot_angles = UTIL_VecToAngles( v_direction );
					pBot->inact_veca=bot_angles;
					pBot->inact_vecb=v_direction;
				}
				else
				{
					bot_angles = pBot->inact_veca;
					v_direction = pBot->inact_vecb;
				}
				if(!pBot->pBotEnemy) 
				{
					pBot->idle_angle = bot_angles.y;
					pEdict->v.ideal_yaw = pBot->idle_angle;
					if(pBot->backwards)
						pEdict->v.ideal_yaw=pEdict->v.ideal_yaw+180;
					pEdict->v.idealpitch = bot_angles.x;				
				}
				//walk away from it
				pBot->f_move_speed=-(pBot->f_max_speed/3);
				if(pBot->f_pause_time<gpGlobals->time)
				{
					if(pBot->f_build_time < gpGlobals->time && pBot->sg_building)
					{
						// Announce the build.
						for	(int i=0; i	< num_areas; i++)
						{
							//checks only for whole	area delete.....
							if ((areas[i].flags	& W_FL_DELETED)	== W_FL_DELETED)
								continue;
							if(AreaInsideClosest(pBot->pEdict)==i) 
								pBot->curr_area=i;
						}
						if((pBot->curr_area!=-1) &&	defensive_chatter)
						{
							char ss[255];
							int	t=UTIL_GetTeam(pBot->pEdict);
							if(t==0) sprintf(ss,"Building Teleporter Exit %s",areas[pBot->curr_area].namea);
							if(t==1) sprintf(ss,"Building Teleporter Exit %s",areas[pBot->curr_area].nameb);
							if(t==2) sprintf(ss,"Building Teleporter Exit %s",areas[pBot->curr_area].namec);
							if(t==3) sprintf(ss,"Building Teleporter Exit %s",areas[pBot->curr_area].named);
							if(strcmp(pBot->lastmessage,ss)!=0)
								UTIL_HostSay(pBot->pEdict,1, ss);
							strcpy(pBot->lastmessage,ss);
						}

					}
					if(pBot->f_build_time < (gpGlobals->time-0.5) && !pBot->sg_building)
					{
						FakeClientCommand(pEdict, "build", "5", NULL);
						pBot->f_build_time = gpGlobals->time;
					}
				}
			}

		}
	}

	//////////////////////
	// Sentry gun build //
	//////////////////////
	if (((waypoints[pBot->curr_waypoint_index].flags & W_FL_TFC_DEFEND)==W_FL_TFC_DEFEND) && 
		mod_id==TFC_DLL && pEdict->v.playerclass == TFC_CLASS_ENGINEER && 
		(UTIL_GetTeam(pEdict)==(waypoints[pBot->curr_waypoint_index].flags & W_FL_TEAM) || (waypoints[pBot->curr_waypoint_index].flags & W_FL_TEAM_SPECIFIC)!=W_FL_TEAM_SPECIFIC) &&
		(waypoints[pBot->curr_waypoint_index].origin - pEdict->v.origin).Length() <= 400 && !pBot->pBotEnemy)
	{
		// DrEvil: Lets try a check to pick a new sg spot if theres an sg here.
		if (!pBot->sg && BotSGAtPoint(waypoints[pBot->curr_waypoint_index].origin, 300))
		{
			pBot->curr_waypoint_index = -1; // clear it
			pBot->goto_wp = -1;
			pBot->sg_wp = -1;
			return;
		}
		pBot->backwards=false;
		if(!pBot->sg && (pBot->f_build_time<=gpGlobals->time) && (pBot->curr_waypoint_index == pBot->goto_wp) && !pBot->pBotEnemy)
		{
			//don't use this...to many probs
			if(pBot->bot_skill > 5)
			{
				pBot->f_build_time = gpGlobals->time + 8;
				FakeClientCommand(pEdict, "build", "2", NULL);
				pBot->sg_wp=pBot->curr_waypoint_index;
			}
			else
			{
				edict_t *pent = NULL;
				if(pBot->inact==0 && !pBot->sg) 
				{
					bool bb = true;					  
					//check this waypoint doesn't have a sg on it! use search
					while ((pent = FIND_ENTITY_IN_SPHERE( pent, pEdict->v.origin, 100 )) != NULL && (!FNullEnt(pent)))
					{
						// Can I see an sg here?
						if (strcmp("building_sentrygun_base", STRING(pent->v.classname)) == 0)
						{
							TraceResult tr;
							UTIL_TraceLine( pEdict->v.origin + pEdict->v.view_ofs, pent->v.origin, ignore_monsters, pEdict->v.pContainingEntity, &tr );
							if (tr.flFraction >= 1.0) 
								bb=false;
						}
					}
					if(bb) //if their isn't a sg already here!!
					{
						pBot->inact=1;
						pBot->backwards=false;
						pBot->f_pause_time=gpGlobals->time;
					}
				}
				if(pBot->inact == 1)
				{
					pBot->backwards=false;
					pBot->sg_building=false;
					//aim at waypoint...			
					Vector v_direction = waypoints[pBot->curr_waypoint_index].origin - pEdict->v.origin;
					Vector bot_angles = UTIL_VecToAngles( v_direction );
					if(pBot->pBotEnemy==NULL) 
					{						 
						pBot->idle_angle = bot_angles.y;
						pEdict->v.ideal_yaw = pBot->idle_angle;
						if(pBot->backwards)
							pEdict->v.ideal_yaw=pEdict->v.ideal_yaw+180;
						pEdict->v.idealpitch = bot_angles.x;
					}
					//walk towards it
					if((waypoints[pBot->curr_waypoint_index].origin-pEdict->v.origin).Length()>80) 
						pBot->f_move_speed = pBot->f_max_speed/2;
					else 
						pBot->f_move_speed = pBot->f_max_speed/5;
					//what if theirs an obstuction?!
					int dis=8;
					//ok..increase distance after a few seconds of trying
					if(pBot->f_pause_time<(gpGlobals->time-3)) 
					{
						dis=200;
					}
					if((waypoints[pBot->curr_waypoint_index].origin-pEdict->v.origin).Length()<dis)
					{
						pBot->f_pause_time=gpGlobals->time+1;
						pBot->inact=2;
					}
					//do nothing if we can't reach it after 6 seconds
					if(pBot->f_pause_time<(gpGlobals->time-6)) pBot->inact=0;
				}
				if(pBot->inact==2)
				{
					pBot->backwards=false;
					//aim at waypoint...
					Vector v_direction;
					Vector bot_angles;
					if(pBot->f_pause_time>gpGlobals->time)
					{
						int i = WaypointFindNearestAiming(pEdict->v.origin);
						if(i==-1) 
							i=0;
						v_direction = waypoints[i].origin - pEdict->v.origin;
						bot_angles = UTIL_VecToAngles( v_direction );
						pBot->inact_veca=bot_angles;
						pBot->inact_vecb=v_direction;
					}
					else
					{
						bot_angles = pBot->inact_veca;
						v_direction = pBot->inact_vecb;
					}
					if(!pBot->pBotEnemy) 
					{
						pBot->idle_angle = bot_angles.y;
						pEdict->v.ideal_yaw = pBot->idle_angle;
						if(pBot->backwards)
							pEdict->v.ideal_yaw=pEdict->v.ideal_yaw+180;
						pEdict->v.idealpitch = bot_angles.x;				
					}
					//walk away from it
					pBot->f_move_speed=-(pBot->f_max_speed/3);
					if(pBot->f_pause_time<gpGlobals->time)
					{
						//UTIL_HostSay(pEdict, 1, "Building sentry gun");
						//use search for object to see if u just built a sg... 
						bool sg=false;
						if(pBot->f_build_time < gpGlobals->time)
						{
							pent=NULL;
							Vector vecStart;
							Vector vecEnd;
							while ((pent = FIND_ENTITY_IN_SPHERE( pent, pEdict->v.origin, 400 )) != NULL && (!FNullEnt(pent)))
							{
								int l = (pEdict->v.origin - pent->v.origin).Length2D();
								if ((strcmp("building_sentrygun_base", STRING(pent->v.classname))==0) && l>=16 && l<=96 && pBot->sg_building)
								{
									pBot->f_build_time = gpGlobals->time + 1;
									pBot->f_pause_time=gpGlobals->time+1;
									sg=true;
									pBot->sg_edict=pent;									
									
									for (int i=0; i < num_areas; i++)
									{
										//checks only for whole area delete.....
										if ((areas[i].flags & W_FL_DELETED) == W_FL_DELETED)
											continue;
										if(AreaInsideClosest(pBot->pEdict)==i) 
											pBot->curr_area=i;
									}
									if((pBot->curr_area!=-1) && defensive_chatter)
									{
										char ss[255];
										int t=UTIL_GetTeam(pBot->pEdict);
										if(t==0) sprintf(ss,"Building Sentrygun %s",areas[pBot->curr_area].namea);
										if(t==1) sprintf(ss,"Building Sentrygun %s",areas[pBot->curr_area].nameb);
										if(t==2) sprintf(ss,"Building Sentrygun %s",areas[pBot->curr_area].namec);
										if(t==3) sprintf(ss,"Building Sentrygun %s",areas[pBot->curr_area].named);
										if(strcmp(pBot->lastmessage,ss)!=0)
											UTIL_HostSay(pBot->pEdict,1, ss);
										strcpy(pBot->lastmessage,ss);
									}
								}
							}
						}
						if(pBot->f_build_time < (gpGlobals->time-0.5) && !sg)
						{
							FakeClientCommand(pEdict, "build", "2", NULL);
							pBot->f_build_time = gpGlobals->time;
						}
					}
				}
			}
		}
	}
	/////////////////////
	// Dispenser stuff //
	/////////////////////
	if (waypoints[pBot->curr_waypoint_index].flags==0 && mod_id==TFC_DLL && pEdict->v.playerclass == TFC_CLASS_ENGINEER && 
		(waypoints[pBot->curr_waypoint_index].origin - pEdict->v.origin).Length() <= 400 && pBot->curr_waypoint_index == pBot->goto_wp &&
		pBot->sg && pBot->sg_edict && !pBot->dispensor && !pBot->track_player)
	{
		// Is it level 3?
		if(strcmp(STRING(pBot->sg_edict->v.model),"models/sentry3.mdl")==0 && pBot->f_build_time<=gpGlobals->time
			&& (pBot->sg_edict->v.origin - pEdict->v.origin).Length() <= 400 && !pBot->pBotEnemy)
		{
			pBot->backwards=false;
			{
				edict_t *pent;
				char item_name[40];
				if(pBot->inact==0 && pBot->sg) 
				{
					bool bb = true;
					if(bb) //if their isn't a sg already here!!
					{
						pBot->inact=1;
						pBot->backwards=false;
						pBot->f_pause_time=gpGlobals->time;
					}
				}
				if(pBot->inact==1)
				{
					pBot->backwards=false;
					pBot->sg_building=false;
					//aim at waypoint...
					Vector v_direction = waypoints[pBot->curr_waypoint_index].origin - pEdict->v.origin;
					Vector bot_angles = UTIL_VecToAngles( v_direction );
					if(!pBot->pBotEnemy) 
					{
						pBot->idle_angle = bot_angles.y;
						pEdict->v.ideal_yaw = pBot->idle_angle;
						if(pBot->backwards)
							pEdict->v.ideal_yaw=pEdict->v.ideal_yaw+180;
						pEdict->v.idealpitch = bot_angles.x;
					}
					//walk towards it
					if((waypoints[pBot->curr_waypoint_index].origin-pEdict->v.origin).Length()>80) 
						pBot->f_move_speed=pBot->f_max_speed/2;
					else 
						pBot->f_move_speed=pBot->f_max_speed/5;
					//what if theirs an obstuction?!
					int dis=100;
					//ok..increase distance after a few seconds of trying
					if(pBot->f_pause_time<(gpGlobals->time-3)) 
					{
						dis=200;
					}
					if((waypoints[pBot->curr_waypoint_index].origin-pEdict->v.origin).Length()<dis)
					{
						pBot->f_pause_time=gpGlobals->time+1;
						pBot->inact=2;
					}
					//do nothing if we can't reach it after 6 seconds
					if(pBot->f_pause_time<(gpGlobals->time-6)) pBot->inact=0;
				}
				if(pBot->inact==2)
				{
					pBot->backwards=false;
					//aim at waypoint...
					Vector v_direction;
					Vector bot_angles;
					if(pBot->f_pause_time>gpGlobals->time)
					{
						int i;
						i=pBot->curr_waypoint_index;
						if(i==-1) i=0;
						v_direction = waypoints[i].origin - pEdict->v.origin;
						bot_angles = UTIL_VecToAngles( v_direction );
						pBot->inact_veca=bot_angles;
						pBot->inact_vecb=v_direction;
					}
					else
					{
						bot_angles = pBot->inact_veca;
						v_direction = pBot->inact_vecb;
					}
					if(pBot->pBotEnemy==NULL) 
					{						  
						pBot->idle_angle = bot_angles.y;
						pEdict->v.ideal_yaw = pBot->idle_angle;
						if(pBot->backwards)
							pEdict->v.ideal_yaw=pEdict->v.ideal_yaw+180;
						pEdict->v.idealpitch = bot_angles.x;			
					}
					//walk away from it
					pBot->f_move_speed=-(pBot->f_max_speed/3);
					if(pBot->f_pause_time<gpGlobals->time)
					{
						bool sg=false;
						if(pBot->f_build_time < gpGlobals->time)
						{
							pent = NULL;
							Vector vecStart;
							Vector vecEnd;
							while ((pent = FIND_ENTITY_IN_SPHERE( pent, pEdict->v.origin, 400 )) != NULL && (!FNullEnt(pent)))
							{
								strcpy(item_name, STRING(pent->v.classname));
								int l = (pEdict->v.origin - pent->v.origin).Length2D();
								if ((strcmp("building_dispenser", item_name)==0) && l>=16 && l<=96 && pBot->sg_building)
								{
									pBot->f_build_time = gpGlobals->time + 1;
									pBot->f_pause_time=gpGlobals->time+1;
									sg=true;
									pBot->dispensor_edict=pent;
									pBot->dispensor=true;
								}
								if (pBot->dispensor)
								{
									pBot->f_build_time = gpGlobals->time + 4;
									pBot->inact=0;
									pBot->f_pause_time=gpGlobals->time+3;
									sg=true;										
									Vector v_enemy = pBot->dispensor_edict->v.origin - pEdict->v.origin;
									Vector bot_angles = UTIL_VecToAngles( v_enemy );
									pEdict->v.ideal_yaw = bot_angles.y+50;
									if(pEdict->v.ideal_yaw>360)
										pEdict->v.ideal_yaw=pEdict->v.ideal_yaw-360;
									BotFixIdealYaw(pEdict);	
								}
							}
						}
						if(pBot->f_build_time < (gpGlobals->time-0.5) && !sg)
						{
							FakeClientCommand(pEdict, "build", "1", NULL);
							pBot->f_build_time = gpGlobals->time;
						}
					}
				}
			}
		}
	}
	////////////////////
	// Multigun stuff //
	////////////////////
	if(pBot->dispensor && pBot->f_build_time < gpGlobals->time + 3 && pBot->f_build_time > gpGlobals->time + 1
		&& pBot->inact==0 && pBot->dispensor_edict)
	{
		char *cvar_ntf_feature_multigun = (char *)CVAR_GET_STRING( "ntf_feature_multigun" );
		if(strcmp(cvar_ntf_feature_multigun,"1")==0)
		{
			pEdict->v.ideal_yaw = pEdict->v.ideal_yaw+25;
			if(pEdict->v.ideal_yaw>360)
				pEdict->v.ideal_yaw=pEdict->v.ideal_yaw-360;
			BotFixIdealYaw(pEdict);	
			FakeClientCommand(pEdict,"buildspecial",NULL,NULL);
		}
	}
}

void BotRoleCheck(bot_t *pBot)
{
	/////////////////////////////////////
	// Get the roles of the teams bots //
	/////////////////////////////////////
	static TeamLayout teams;

	if (roleCheckTimer < gpGlobals->time)
	{		
		roleCheckTimer = gpGlobals->time + 10;
		//UTIL_HostSay(pBot->pEdict, 0, "role check");

		// Zero out everything.
		int i;
		for (i = 0; i < 4; i++)
		{
			teams.attackers[i].clear();
			teams.defenders[i].clear();
			teams.humanAttackers[i].clear();
			teams.humanDefenders[i].clear();
			teams.total[i] = 0;
		}

		// Loop through everyone
		for (i = 0; i < 32; i++)
		{
			// Is this a bot?
			if(bots[i].is_used && bots[i].pEdict->v.playerclass)
			{
				teams.total[bots[i].pEdict->v.team-1]++;
				if (bots[i].mission == pBot->Defender)
					teams.defenders[bots[i].pEdict->v.team-1].addTail(&bots[i]);				
				else if (bots[i].mission == pBot->Attacker) 				
					teams.attackers[bots[i].pEdict->v.team-1].addTail(&bots[i]);
				else if (bots[i].mission == pBot->None) 
					bots[i].mission = pBot->Attacker;
			}
		}
		// Do what we can for humans
		for (i = 0; i < 32; i++)
		{
			if (clients[i])		
			{
				teams.total[clients[i]->v.team-1]++;
				if (clients[i]->v.playerclass == TFC_CLASS_MEDIC || clients[i]->v.playerclass == TFC_CLASS_SPY || clients[i]->v.playerclass == TFC_CLASS_SCOUT || clients[i]->v.playerclass == TFC_CLASS_PYRO)
					teams.humanAttackers[clients[i]->v.team-1].addTail(clients[i]);
				else if (clients[i]->v.playerclass == TFC_CLASS_ENGINEER || clients[i]->v.playerclass == TFC_CLASS_SNIPER)
					teams.humanDefenders[clients[i]->v.team-1].addTail(clients[i]);
			}	
		}
		/*char msg[255];
		sprintf(msg, "Blue: %d Attack, %d Defend, %d Total", teams.attackers[0].size(), teams.defenders[0].size(), teams.total[0]);
		UTIL_HostSay(pBot->pEdict, 0, msg);
		sprintf(msg, "Red: %d Attack, %d Defend, %d Total", teams.attackers[1].size(), teams.defenders[1].size(), teams.total[1]);
		UTIL_HostSay(pBot->pEdict, 0, msg);*/

		// need to make some adjustments to the roles based on the above figures.
		// Only do this 1 bot at a time. Don't want mass role changes.
		for (i = 0; i < 4; i++)
		{
			// Crash prevention //
			if (teams.total[i] == 0)
				continue;
			// end crash prevention //

			int totalAttackers = teams.attackers[i].size() + teams.humanAttackers[i].size();
			// Check the offense/defense roles for lopsidedness. 
			float percentOffense = (totalAttackers*100.0f) / (teams.total[i]*100.0f)*100;
			// Only do something if the numbers are really off.		

			/*char msg[80];
			sprintf(msg, "RoleStatus %d PercentOffense %f", RoleStatus[i], percentOffense);
			UTIL_HostSay(pBot->pEdict, 0, msg);*/

			if (percentOffense < RoleStatus[i])
				continue;

			// Keep track of the first indexes of a few classes suitable for defense. Use these to assign bots to offense.
			bot_t *soldier = 0; bot_t *hwguy = 0; bot_t *demo = 0;
			int soldTotal = 0, hwTotal = 0, demoTotal = 0;

			LIter<bot_t * > iter(&teams.attackers[i]);
			for (iter.begin(); !iter.end(); ++iter)
			{
				// Skip em if they have mission locked.
				if ((*iter.current())->lockMission)
					continue;

				if ((*iter.current())->pEdict->v.playerclass == TFC_CLASS_SOLDIER)
				{
					soldTotal++;
					if (!soldier) soldier = (*iter.current());
				}
				else if ((*iter.current())->pEdict->v.playerclass == TFC_CLASS_HWGUY)
				{
					hwTotal++;
					if (!hwguy) hwguy = (*iter.current());
				}
				else if ((*iter.current())->pEdict->v.playerclass == TFC_CLASS_DEMOMAN)
				{
					demoTotal++;
					if (!demo) demo = (*iter.current());
				}
			}

			//sprintf(msg, "Team: %d HW:%d SOL:%d DEMO:%d", i, hwTotal, soldTotal, demoTotal);
			//UTIL_HostSay(pBot->pEdict, 0, msg);

			// Ok we got the totals of suitable defense classes, and the first index of each. 
			// Lets try to decide who to put on defense.
			if(hwTotal > 2 && !hwguy->lockMission)
			{
				// make the hwguy defend
				hwguy->mission = pBot->Defender;
				//UTIL_HostSay(hwguy->pEdict, 0, "hwguy on defense");
				hwguy->curr_waypoint_index = WaypointFindNearest(pBot->pEdict, REACHABLE_RANGE, UTIL_GetTeam(pBot->pEdict));
				hwguy->goto_wp = -1;
			} else if (demoTotal > 2 && !demo->lockMission)
			{
				// make the demo defend
				demo->mission = pBot->Defender;
				//UTIL_HostSay(demo->pEdict, 0, "demo on defense");
				demo->curr_waypoint_index = WaypointFindNearest(pBot->pEdict, REACHABLE_RANGE, UTIL_GetTeam(pBot->pEdict));
				demo->goto_wp = -1;
			} else if (soldTotal > 2 && !soldier->lockMission)
			{
				// make the sold defend
				soldier->mission = pBot->Defender;
				//UTIL_HostSay(soldier->pEdict, 0, "soldier on defense");
				soldier->curr_waypoint_index = WaypointFindNearest(pBot->pEdict, REACHABLE_RANGE, UTIL_GetTeam(pBot->pEdict));
				soldier->goto_wp = -1;
			} else
			{
				// No extra guys to move, I guess just pick one.
				if (hwguy) 
				{
					hwguy->mission = pBot->Defender;
					//UTIL_HostSay(hwguy->pEdict, 0, "hwguy on defense");
					hwguy->curr_waypoint_index = WaypointFindNearest(pBot->pEdict, REACHABLE_RANGE, UTIL_GetTeam(pBot->pEdict));
					hwguy->goto_wp = -1;
				}				
				else if (demo && (WaypointFindRandomGoal(pBot->pEdict,-1,W_FL_TFC_DEMO) == -1)) 
				{
					demo->mission = pBot->Defender;					
					//UTIL_HostSay(demo->pEdict, 0, "demo on defense");
					demo->curr_waypoint_index = WaypointFindNearest(pBot->pEdict, REACHABLE_RANGE, UTIL_GetTeam(pBot->pEdict));
					demo->goto_wp = -1;
				}
				else if (soldier) 
				{
					soldier->mission = pBot->Defender;
					//UTIL_HostSay(soldier->pEdict, 0, "soldier on defense");
					soldier->curr_waypoint_index = WaypointFindNearest(pBot->pEdict, REACHABLE_RANGE, UTIL_GetTeam(pBot->pEdict));
					soldier->goto_wp = -1;
				}
			}
		}
	}
}

bool BotChangeClass(bot_t *pBot, int iClass, const char *from)
{
	// BotChangeClass - Given a bot and a class #, this function should make the bot change to that class.
	// Returns true if successful.

	// Check for invalid input
	if(iClass > 10 && iClass < 1)
		return false;

	// Check if the class supplied is already at the limit.
	int class_not_allowed;
	int team = UTIL_GetTeam(pBot->pEdict);
	if (iClass <= 7) class_not_allowed = team_class_limits[team] & (1<<(iClass-1));
	else class_not_allowed = team_class_limits[team] & (1<<(iClass));
	if (class_not_allowed)
		return false;

	// Make sure its from a teammate
	for (int i = 1; i <= gpGlobals->maxClients; i++ )
	{
		edict_t *pPlayer = INDEXENT(i);
		if (!pPlayer)
			continue;

		// Is this the guys name that sent the command?
		if(strcmp(STRING(pPlayer->v.netname),from)==0)
		{
			// Make sure he is on our team to accept the message.
			if (UTIL_GetTeam(pBot->pEdict) != UTIL_GetTeam(pPlayer))
				return false;

			// Check the pPlayer for access to this command.
			
			if(!botVerifyAccess(pPlayer))
			{
				UTIL_HostSay(pBot->pEdict, 1, "You don't have access.");
				return false;
			}
			/*char msg[80];
			sprintf(msg, "wonid: %d", wonId);
			UTIL_HostSay(pBot->pEdict, 0, msg);*/
			// A-OK Do it.
			pBot->bot_class = iClass;
			char c_class[255];
			if (pBot->bot_class == 0)
				strcpy(c_class, "civilian");
			else if (pBot->bot_class == 1)
				strcpy(c_class, "scout");
			else if (pBot->bot_class == 2)
				strcpy(c_class, "sniper");
			else if (pBot->bot_class == 3)
				strcpy(c_class, "soldier");
			else if (pBot->bot_class == 4)
				strcpy(c_class, "demoman");
			else if (pBot->bot_class == 5)
				strcpy(c_class, "medic");
			else if (pBot->bot_class == 6)
				strcpy(c_class, "hwguy");
			else if (pBot->bot_class == 7)
				strcpy(c_class, "pyro");
			else if (pBot->bot_class == 8)
				strcpy(c_class, "spy");
			else if (pBot->bot_class == 9)
				strcpy(c_class, "engineer");
			FakeClientCommand(pBot->pEdict, c_class, NULL, NULL);
		}
	}	
	return true;
}

bool BotChangeRole(bot_t *pBot, const char *cmdLine, const char *from)
{
	// BotChangeClass - Given a bot and a role, this function should make the bot change to that role.
	// Returns true if successful.
	
	// Crash check.
	if (!pBot || !cmdLine || !from)
		return false;

	// Check if the class supplied is already at the limit.
	int team = UTIL_GetTeam(pBot->pEdict);
	
	// Make sure its from a teammate
	for (int i = 1; i <= gpGlobals->maxClients; i++ )
	{
		edict_t *pPlayer = INDEXENT(i);
		if (!pPlayer)
			continue;

		// Is this the guys name that sent the command?
		if(strcmp(STRING(pPlayer->v.netname),from)==0)
		{
			// Make sure he is on our team to accept the message.
			if (UTIL_GetTeam(pBot->pEdict) != UTIL_GetTeam(pPlayer))
				return false;

			// Check the pPlayer for access to this command.
			if(!botVerifyAccess(pPlayer))
			{
				UTIL_HostSay(pBot->pEdict, 1, "You don't have access.");
				return false;
			} 

			// Get the role to change to first from the cmdLine line
			int changeTo = 0;
			if (strstr(cmdLine, "attack"))
			{
				pBot->mission = pBot->Attacker;
				pBot->goalType = pBot->Flag;
				pBot->lockMission = true;
				UTIL_HostSay(pBot->pEdict, 1, "Roger, attacking.");
				pBot->goto_wp = pBot->pipePoint = pBot->defendPoint = -1;				
			}
			else if (strstr(cmdLine, "defend"))
			{
				pBot->mission = pBot->Defender;
				pBot->lockMission = true;
				UTIL_HostSay(pBot->pEdict, 1, "Roger, defending.");
				pBot->goto_wp = -1;
			}
			else if (strstr(cmdLine, "roam"))	
			{
				pBot->lockMission = false;
				UTIL_HostSay(pBot->pEdict, 1, "Roger, I'm on my own.");
				pBot->goto_wp = -1;
			}	
			else
				UTIL_HostSay(pBot->pEdict, 1, "Invalid Role.");
		}
	}	
	return true;
}

bool botVerifyAccess(edict_t *pPlayer)
{
	// This function checks if the specified user has access through the foxbot_commanders.txt
	char authId[255];
	strcpy(authId,GETPLAYERAUTHID(pPlayer));
	char szBuffer[64];
	sprintf(szBuffer,"%s Does not have access.",authId);
	ALERT( at_console, szBuffer);
	// example steam ID: STEAM_0:1245
	bool found = false;
	LIter<char *> iter(&commanders);
	for (iter.begin(); !iter.end(); ++iter)
	{		
		if (stricmp(authId, (*iter.current())) == 0)
			found = true;
	}
	if(found)
		return true;
	else 
		return false;
}