const { contextBridge, ipcRenderer } = require("electron");

contextBridge.exposeInMainWorld("electronAPI", {
  getPrinters: () => ipcRenderer.invoke("get-printers"),
  saveSelectedPrinters: (selectedPrinters) =>
    ipcRenderer.invoke("save-selected-printers", selectedPrinters),
  createPrinterShortcut: (printerName) =>
    ipcRenderer.invoke("create-printer-shortcut", printerName),
  removePrinterShortcut: (printerName) =>
    ipcRenderer.invoke("remove-printer-shortcut", printerName),
  setDefaultPrinter: (printerName) =>
    ipcRenderer.invoke("set-default-printer", printerName),
  getDefaultPrinter: () => ipcRenderer.invoke("get-default-printer"),
  saveSettings: (settings) => ipcRenderer.invoke("save-settings", settings),
  getSettings: () => ipcRenderer.invoke("get-settings"),
  resetAll: () => ipcRenderer.invoke("reset-all"),
  showResetConfirmation: () => ipcRenderer.invoke("show-reset-confirmation"),
  exportSettings: () => ipcRenderer.invoke("export-settings"),
  importSettings: () => ipcRenderer.invoke("import-settings"),
  showMessage: (message) => ipcRenderer.invoke("show-message", message),
  showBulkCreateConfirmation: (count) =>
    ipcRenderer.invoke("show-bulk-create-confirmation", count),
  showBulkRemoveConfirmation: (count) =>
    ipcRenderer.invoke("show-bulk-remove-confirmation", count),
  logError: (error, context) => ipcRenderer.invoke("log-error", error, context),
  checkForUpdates: () => ipcRenderer.invoke("check-for-updates"),
  runCompleteCleanup: () => ipcRenderer.invoke("run-complete-cleanup"),
  onUpdateProgress: (callback) =>
    ipcRenderer.on("update-progress", (_, percent) => callback(percent)),
});
