# DHL Printer Manager

A desktop application for managing DHL printer shortcuts with automatic taskbar pinning.

## Features

### 🖨️ Printer Management

- Create desktop shortcuts and pin to taskbar with a single click
- Automatically assign printer-specific icons (Labels/Color/Black)
- Bulk select/deselect printers
- Smart shortcut creation with error handling

### 📋 Organization & Filtering

- Search functionality for quick printer lookup
- Filter by printer type (Labels, Color, Black & White)
- Sort printers alphabetically or by type
- Smart suggestions while typing

### ⚙️ Settings & Configuration

- Dark/Light theme toggle
- Auto-sort options
- Settings import/export functionality
- Machine-specific configuration persistence
- **Shortcut creation preferences** - Configure desktop and/or taskbar shortcuts

### 🎯 Taskbar Integration (NEW in v1.3.0)

- Automatic taskbar pinning when creating shortcuts
- Automatic unpinning when removing shortcuts
- Uses reliable Windows shell integration
- Background error handling for seamless operation
- **Configurable shortcut options** - Choose between desktop shortcuts, taskbar shortcuts, or both

### 🚀 First Run Experience (NEW)

- **Automatic Application Pinning** - The printer manager automatically pins itself to the taskbar on first launch
- **One-time Setup** - Smart detection ensures the application only pins itself once
- **User Notification** - Friendly welcome message informing users about the taskbar shortcut

## Installation

1. Download the latest release from the releases page
2. Extract the ZIP file to your desired location
3. Run `DHLPrinterManager.exe`
4. On first run, the application will automatically pin itself to your taskbar for easy access

## Development

### Prerequisites

- Node.js (v14 or later)
- npm

### Setup

```bash
npm install
```

### Run in development mode

```bash
npm start
```

### Build for production

```bash
npm run package
```

## Technical Details

### Taskbar Pinning

The application uses the `pttb.exe` tool (Pin To TaskBar) for reliable taskbar integration:

- Repository: https://github.com/0x546F6D/pttb_-_Pin_To_TaskBar
- Supports Windows 10/11
- Automatic fallback if pinning fails

### Printer Detection

- Automatically detects available printers
- Categorizes printers by type based on naming conventions
- Assigns appropriate icons for each printer type

### Data Persistence

- Settings and selected printers are saved locally
- Machine-specific configuration prevents conflicts
- Automatic validation of existing shortcuts

## Supported Printer Types

### Labels Printers

NLWRTNP02003, NLWRTNP02004, NLWRTNP02005, NLWRTNP02006, NLWRTNP02007, NLWRTNP02008, NLWRTNP02009, NLWRTNP02010, NLWRTNP02023, NLWRTNP02024, NLWRTNP02025, NLWRTNP02026, NLWRTNP02027, NLWRTNP02028, NLWRTNP03018, NLWRTNP03019, NLWRTNP03020, NLWRTNP04023-NLWRTNP04052, NLWRTNP04057, NLWRTNP09015, NLWRTNP09040

### Color Printers

NLWRTNP02000, NLWRTNP02001, NLWRTNP02002, NLWRTNP03013-NLWRTNP03017, NLWRTNP03022, NLWRTNP04016-NLWRTNP04022, NLWRTNP04050

### Black & White Printers

NLWRTNP02012, NLWRTNP02020-NLWRTNP02022, NLWRTNP03001-NLWRTNP03012, NLWRTNP03021, NLWRTNP04001-NLWRTNP04015, NLWRTNP04049, NLWRTNP04053-NLWRTNP04056, NLWRTNP09001-NLWRTNP09014, NLWRTNP09016-NLWRTNP09039

## Version History

### v1.3.0 (Current)

- Added automatic taskbar pinning functionality
- Integrated pttb.exe for reliable Windows taskbar integration
- Enhanced error handling for taskbar operations
- Updated UI text to reflect new functionality
- **Added configurable shortcut settings** - Users can choose between desktop shortcuts, taskbar shortcuts, or both
- Added settings modal for shortcut preferences

### v1.2.0

- Previous version with desktop shortcut functionality

## Author

Dário Pascoal  
Email: dario@pascoal.org  
Company: DHL

## License

Private/Internal use for DHL

## Requirements

- Windows 10 or later
- .NET Framework (for Electron runtime)
- Administrative privileges may be required for printer access

## Support

For issues or feature requests, please contact the development team.
