#!/bin/bash

##################################################################################
##################################################################################
#                                                                                #
#  Q3-Engine-GetStatus-Flood-Fixer - ConfigServerFirewall                        #
#  Version 1.0                                                                   #
#  !USE THIS ONLY IF YOU ALSO USE CSF (http://www.configserver.com/cp/csf.html)! #
#                                                                                #
# Versioncontrol:                                                                #
# 1.0 - rework to fit csf                                                        #
#                                                                                #
#                                                                                #
#                                                                                #
# Thanks to benny from Hirntot for the regexp                                    #
##################################################################################
########################       DESCRIPTION     ###################################
#                                                                                #
# This script try to get rid of the Q3-Engine getstatus-Abuse-Exploit            #
#                                                                                #
# About the exploit                                                              #
#                                                                                #
# This exploit use the getstatus udp query command with a spoofed sender         #
# adress. This 14 byte long command enganges the gameserver engine to            #
# respond the whole status of the gameserver ( > ~600 bytes on empty server)     #
# This amplification is visible if you use a tool like vnstat (vnstat -l)        #
# The outgoint traffic exceeds the incoming traffic with a faktor > 3            #
#                                                                                #
#                                                                                #
# About the script                                                               #
# This script capture the count of tcp packets set in config and search for      #
# answered getstatus queries. For any requesting IP adress the count of          #
# those packets is compared to the defind limit.                                 #
# If the limit is broken by an IP adress, the access for this IP will ne denied  #
# with iptables by adding a ConfigServerFirewall deny entry.                     #
#                                                                                #
# Configuration                                                                  #
#                                                                                #
# By default, the script don`t need any configuration                            #
# The default values                                                             #
# CSFBIN=/usr/sbin/csf                                                           #
# TCPDUMPBIN=/usr/sbin/tcpdump                                                   #
# CAPTURETIME=3                                                                  #
# MAXPERSECONDS=4                                                                #
#                                                                                #
#                                                                                #
#                                                                                #
# will enforces drops in the case that:                                          #
#                                                                                #
# Each IP which requests more than 2 getstatus respones per second,              #
# averaged over 3 seconds                                                        #
#                                                                                #
# Requirements                                                                   #
#                                                                                #
# This script use a few open source tools to offence against this attacks        #
# csf - ConfigServerFirewall http://www.configserver.com/cp/csf.html             #
# tcpdump - capture incoming packets: http://www.tcpdump.org/                    #
# iptables - the most used linux firewall (packet filter)                        #
# GNU-tools - grep, cat                                                          #
#                                                                                #
# THIS SCRIPT COMES WITH NO WARRANTY! USE IT AT YOUR OWN RISK ONLY!              #
#                                                                                #
##################################################################################
######################       CONFIGURATION      ##################################
##################################################################################

CAPTURETIME=3
MAXPERSECONDS=4
CSFBIN=/usr/sbin/csf
TCPDUMPBIN=/usr/sbin/tcpdump


##################################################################################
##################################################################################
##################################################################################
mygoto=`dirname $0`
cd $mygoto
captsec=$CAPTURETIME
mylimit=$MAXPERSECONDS
cntout=file_cntout
tmpout=file_tmpout
tmpout2=file_tmpout2
tmpout3=file_tmpout3
banlist=file_bans

#fix: 31.01.2011 21:45
touch $banlist
#

MYIFS=$IFS
IFS="
"


rm $cntout 2>/dev/null
rm $tmpout 2>/dev/null
rm $tmpout2 2>/dev/null
rm $tmpout3 2>/dev/null

touch $cntout
touch $tmpout
touch $tmpout2
touch $tmpout3

$TCPDUMPBIN -f -c 100000 -A >$tmpout 2>$cntout &
pid=$!
sleep $captsec
kill $pid
sleep 1

maxcnt=$((mylimit*captsec))
grep -B2 Respon $tmpout | grep UDP | awk '{print $5}' | cut -d '.' -f 1,2,3,4 > $tmpout3

allIPs=`grep -B2 Respon $tmpout | grep UDP | awk '{print $5}' | cut -d '.' -f 1,2,3,4 | sort -u`
for ip in $allIPs
do

IPCNT=`grep "$ip" $tmpout3 | wc -l`
#PORTS=`grep -B2 Respon $tmpout | grep UDP | cut -d "." -f 4 | cut -d " " -f 1 | sort -u`
PORTS=`grep -B2 Respon file_tmpout | grep UDP |awk '{print $3}' | perl -e 'while (<STDIN>) {print "$1\n" if ($_ =~ /\.(\d+)$/)}' | sort -u`
if [ $IPCNT -gt $maxcnt ]
then
for PORT in $PORTS
do
ts=`date --utc +%s`
rps=$((IPCNT/captsec))
tshr=`date --utc --date "1970-01-01 $ts sec" "+%Y-%m-%d %T"`
out="$ts $ip $PORT $IPCNT = $rps ReqPerSec banned $tshr"
$CSFBIN -d $ip
echo $out >>$banlist
done
else
DEBUGOUT="no ban"
fi
done


####AUTO-UNBAN


LINES=`cat $banlist | sort -u`
for LINE in $LINES
do
LIP=`echo $LINE | awk '{print $2}'`
LPORT=`echo $LINE | awk '{print $3}'`

LCNT=`grep "$LIP" $tmpout | wc -l`
if [ "$LCNT" != "0" ]
then
DEBUGOUT="No release $LIP $LPORT"
else
#RELEASE
#IPTBLN=`$CSFBIN -L -v --line-numbers | grep "$LIP" | grep "$LPORT" | awk '{print $1}'`
#CHECK=`$CSFBIN -L -v --line-numbers | grep "$LIP" | grep "$LPORT" | wc -l`
#DEBUGOUT="RELEASE $LIP $LPORT BUG"

$CSFBIN -dr $LIP
DEBUGOUT="RELEASE $LIP $LPORT"
grep -v "$LIP" $banlist > tmp001
mv tmp001 $banlist

#echo $DEBUGOUT
fi
done




rm $tmpout3 2>/dev/null
rm $cntout 2>/dev/null
rm $tmpout 2>/dev/null
rm $tmpout2 2>/dev/null
IFS=$MYIFS