#!/bin/bash

##################################################################################
##################################################################################
#                                                                                #
#  Variante of GetStatus AntiFlood Script by OldMan                              #
#  My Version 1.5                                                                #
#                                                                                #
#  based on Q3-Engine-GetStatus-Flood-Fixer  Version 1.4                         #
#  by schnoog (schnoog@wolffiles.de)                                             #
#  Thanks schnoog!                                                               #
#                                                                                #
# Thanks to benny from Hirntot for the regexp                                    #
##################################################################################
########################       DESCRIPTION     ###################################
#                                                                                #
# This script try to get rid of the Q3-Engine getstatus-Abuse-Exploit            #
#                                                                                #
# About the exploit                                                              #
#                                                                                #
# This exploit use the getstatus udp query command with a spoofed sender         #
# adress. This 14 byte long command enganges the gameserver engine to            #
# respond the whole status of the gameserver ( > ~600 bytes on empty server)     #
# This amplification is visible if you use a tool like vnstat (vnstat -l)        #
# The outgoint traffic exceeds the incoming traffic with a faktor > 3            #
#                                                                                #
#                                                                                #
# About the script                                                               #
# This script capture the count of tcp packets set in config and search for      #
# answered getstatus queries. For any requesting IP adress the count of          #
# those packets is compared to the defind limit.                                 #
# If the limit is broken by an IP adress, the access for this IP will ne denied  #
# with iptables by adding a drop rule.                                           #
#                                                                                #
# Configuration                                                                  #
#                                                                                #
# By default, the script don`t need any configuration                            #
# The default values                                                             #
#                                                                                #
# Disable auto unban with the option RunPart   1= Ban only, 2= Ban & Unban       #
#                                                                                #
# CAPTURETIME=10      # <- captured time                                         #
# MAXPERSECONDS=4     # <- search patter max per second                          #
# UNBCNT=10           # <- amount of cycles before running Unban                 #
# RunPart=2           # <- 1= Ban only, 2= Ban & Unban                           #
#                                                                                #
# will enforces drops in the case that:                                          #
#                                                                                #
# Each IP which requests more than 4 getstatus respones per second,              #
# averaged over 5 seconds                                                        #
#                                                                                #
# Requirements                                                                   #
#                                                                                #
# This script use a few open source tools to offence against this attacks        #
# tcpdump - capture incoming packets: http://www.tcpdump.org/                    #
# iptables - the most used linux firewall (packet filter)                        #
# GNU-tools - grep, cat , awk                                                    #
#                                                                                #
# THIS SCRIPT COMES WITH NO WARRANTY! USE IT AT YOUR OWN RISK ONLY!              #
#                                                                                #
##################################################################################
##################################################################################
##################################################################################
#                                                                                #
#                                SETUP                                           #
#                                                                                #
##################################################################################
##################################################################################
#                                                                                #
#      1. Ensure you installed iptables and tcpdump                              #
#                                                                                #
#      2. Place this script on your server, and allow execution for it           #
#           #chmod +x getstatus_*                                                #
#                                                                                #
#      3. Change the configuration below to your system requirements             #
#         Hint: which iptables  and  which tcpdump  and which logger             #
#               will return the values needed to insert below                    #
#                                                                                #
#      4. Run the script once to see any errors occour                           #
#           #./getstatus_ban.sh                                                  #
#                                                                                #
#      5. If all went well, configure a cronjob -Fto run the script periodically #
#                                                                                #
#      6. Optional create a Logfile-Rotation for the banfile-List                #
#                                                                                #
#      7. When the script runs without any problem disable the debug option      #
#                                                                                #
#                                                                                #
##################################################################################

################################  CONFIGURATION  #################################
CAPTURETIME=10      
MAXPERSECONDS=4     
UNBCNT=10            
RunPart=2      

###############################  DETERMINE PATHS   ############################### 
PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin
TCPDUMPBIN=`which  tcpdump`
LOGGERBIN=`which logger`
IPTABLESBIN=`which iptables`

####################################  Debug  #####################################
MYDEBUGBAN=5  # <- 1=show allips | 2=show noBan | 3=show Ban | 4=unban | 5=showAll
MYDEBUGUNBAN=3  # <- 1=show unban IP's | 2=show no unban IP's | 3=show all
IPTABLEDEBUG=1   # <- 1=show iptable entrys

##################################################################################
##################################################################################
##################################################################################
##################################################################################
#############################      Initialisation     ############################
##################################################################################
thisscript=$(readlink -f $0)
mygoto=`dirname $thisscript`
mygoto="$mygoto"
cd $mygoto
MYIFS=$IFS
IFS="
"
##################################################################################
##################################################################################
###################### set some variables and files ##############################
##################################################################################
# All bans where stored in the file defined on next line
banfile="$mygoto/banlist"
captured_data="$mygoto/tmp_captured"
touch $captured_data
captured_data_num="$mygoto/tmp_captured_mypidnum"
touch $captured_data_num
calclimit=$((MAXPERSECONDS*CAPTURETIME))
export calclimit
export MYDEBUGBAN
export MYDEBUGUNBAN
export IPTABLEDEBUG
export IPTABLESBIN
export TCPDUMPBIN
export CAPTURETIME
export MAXPERSECONDS
export LOGGERBIN

export captured_data
export captured_data_num
export banfile
export CHK
export COUNT
export UNBCNT


if  [ -f $mygoto/unbancnt ] ; then
COUNT=`grep unbancounter  $mygoto/unbancnt  | awk ' {print $2} '`
let "COUNT += 1"

if [ $MYDEBUGBAN == "5" ] ; then
echo Unban Counter: $COUNT
fi
echo unbancounter $COUNT >  $mygoto/unbancnt 
else
echo unbancounter "0" >  $mygoto/unbancnt 
fi

##################################################################################
################## Add new Chain and Rules for getstatus - Bans ##################

$IPTABLESBIN -nL > $mygoto/iptab.tmp 
 
myChain=`grep "Chain getstatus" $mygoto/iptab.tmp | awk '{print $2}'`

if [ $myChain ] ; then
if [ $IPTABLEDEBUG == "1" ] ; then 
echo "
getstatus Chain exists "
fi
else
$IPTABLESBIN -N getstatus
if [ $IPTABLEDEBUG == "1" ] ; then
echo "
Chain getstatus created"
fi
fi
#$IPTABLESBIN > $mygoto/iptab.tmp

myRules=`grep "getstatus  udp  --  0.0.0.0/0" $mygoto/iptab.tmp | awk '{print $1}'`

if [ "$myRules" ] ; then
if [ $IPTABLEDEBUG == "1" ] ; then 
echo "
getstatus Rules exists
"
fi
else
$IPTABLESBIN -A INPUT -p udp -m udp -j getstatus
if [ $IPTABLEDEBUG == "1" ] ; then 
echo "
Rules getstatus created
"
fi 
fi

$IPTABLESBIN -nL > $mygoto/iptab.tmp
iptab="$mygoto/iptab.tmp"
if [ $IPTABLEDEBUG == "1" ] ; then 
cat $mygoto/iptab.tmp
fi
##################################################################################
##################################################################################
##################################################################################
################################  functions ######################################
##################################################################################
##################################################################################
#######   catpure data - captures all tcp packets for the defined time   #########
#######                  output is saved to predefined file              #########
##################################################################################
function capture_data {
$TCPDUMPBIN -f -c 100000 -A >$captured_data 2>$captured_data_num & pid=$!
sleep $CAPTURETIME

mypid=`ps aux | awk '/tcpdump/ && !/awk/ { print $2 }'`
if [ $mypid <> "0" ]
then
kill $pid
fi
}
##################################################################################
#######   ban          - Ban the given IP ($1) - Port ($2) combination,  #########
#######                  and log data together with request frequence    #########
#######                  to "banlist"                                    #########
##################################################################################
function ban {
IP=$1

reqps=$((cnt/CAPTURETIME))
$IPTABLESBIN -I getstatus 1 -s $IP -p UDP -j DROP
$LOGGERBIN -t "GetStatusBan Reason: $reason -- $IP  -- $cnt Requests -- $reqps Requests per second"
ts=`date --utc +%s`
rpsipcnt=$((IPCNT/CAPTURETIME))
tshr=`date --utc --date "1970-01-01 $ts sec" "+%Y-%m-%d %T"`

out="$ts $IP $IPCNT = banned Reason: $reason $tshr for $cnt Requests in $CAPTURETIME seconds / $reqps  Requests per second "
echo $out >> $banfile
}

##################################################################################
#######   autoban      - starts the ban routine: calls capture_data      #########
#######                  greps the IPs to which getStatusRepsonsed where #########
#######                  delivered. If more then defined responses       #########
#######                  sent to a single IP, the ban routine is called  #########
##################################################################################
function autoban1 {
capture_data

reason="(search pattern: getstatus and UDP)"

echo $allips
allips1=$(grep -B2 getsta $captured_data | grep UDP  | awk '{print $3}' | cut -d '.' -f 1,2,3,4 | sort -u)
 
if [ $MYDEBUGBAN == "1" -o $MYDEBUGBAN == "5" ] ; then
echo "
allips1 $reason:
 
$allips1"
fi

for newip in $allips1
do

cnt=$(grep -B2 getsta $captured_data | grep UDP | grep $newip | wc -l)

rps=$((cnt/CAPTURETIME))

#check for already banned IP's 

checkiptables

if [ $CHK == "0" ]
then
if [ $rps -ge $MAXPERSECONDS ] ; then
if [ $MYDEBUGBAN == "3" -o $MYDEBUGBAN == "5" ] ; then
echo "
ban $newip reason: $reason - for $cnt Requests in $CAPTURETIME seconds / $rps Requests per second"
fi
ban "$newip" "$rps"
fi
else

if [ $MYDEBUGBAN == "3" -o $MYDEBUGBAN == "5" ] ;then
echo "
$newip already banned !"
fi
fi

done
}

########################################################################

function autoban2 {


reason="(search pattern: getstatus and zoneRef)"

allips2=$(grep -B2 getsta $captured_data | grep zoneRef $captured_data | awk '{print $3}' | cut -d '.' -f 1,2,3,4 | sort -u)

if [ $MYDEBUGBAN == "1" -o $MYDEBUGBAN == "5" ] 
then
echo "
allips2 $reason:

$allips2"
fi

for newip in $allips2
do

cnt=$(grep -B2 getsta $captured_data | grep zoneRef $captured_data | grep $newip\.[domain] | wc -l)
 
rps=$((cnt/CAPTURETIME))

# check for already banned IP's
 
checkiptables

if [ $CHK == "0" ]
then
if [ $rps -ge $MAXPERSECONDS ] ; then
if [ $MYDEBUGBAN == "3" -o $MYDEBUGBAN == "5" ] ; then
echo "
ban $newip  reason: $reason - for $cnt Requests in $CAPTURETIME seconds / $rps Requests per second"
fi
ban "$newip" "$rps"
fi
else

if [ $MYDEBUGBAN == "3" -o $MYDEBUGBAN == "5" ] ;then
echo "
$newip already banned !"
fi
fi
done
}

######################  check for already banned IP's  ############################

function checkiptables {
$IPTABLESBIN -nL getstatus > $mygoto/chain   
banIP=$(grep ^DROP $mygoto/chain  | awk '{print $4}' ) 
CHK=0

for chkipt in $banIP ; do
if [ $newip == $chkipt ] ; then
let "CHK += 1"
fi
done
}

###################### Unban iptables getstatus  #################################

function unban {

# read banned IP from iptables chain

$IPTABLESBIN -nL getstatus > $mygoto/chain   
banIP=$(grep ^DROP  $mygoto/chain | awk '{print $4}' ) 

# read all IP's request, the getstatus

ips=$(grep -B2 getsta $captured_data | grep IP $captured_data | awk '{print $3}' | cut -d '.' -f 1,2,3,4 | sort -u) 

# Seeking IP's not to be unbanned

for oldip in $banIP
do

for banip in $ips
do

if [ $oldip == $banip ] ; then
echo oldip $oldip banip $banip >> $mygoto/unb
fi
done
done

if  [ -f $mygoto/unb ] ; then
for noDel in $(cat $mygoto/unb | awk '{print $2 " " $4}')
do
if [ "$noDel awk '{print $1}'"  ==   "$noDel awk '{print $2}'" ] ; then
echo $noDel | awk '{print $1}' >> $mygoto/noDel.tmp
fi
 
done
rm $mygoto/unb
fi

# remove duplicate IP's

if  [ -f $mygoto/noDel.tmp ] ; then
grep . $mygoto/noDel.tmp | awk '{print $1}' | sort -u > $mygoto/noDel
rm $mygoto/noDel.tmp
fi

# remove all clean IP's from iptables chain GetStatus

for oldip in $banIP
do

if  [ -f $mygoto/noDel ] ; then
unban=$(grep $oldip -F $mygoto/noDel)
fi

if  [ -z $unban ] ; then
ts=`date --utc +%s`
tshr=`date --utc --date "1970-01-01 $ts sec" "+%Y-%m-%d %T"`
ubout="$ts $oldip = unbanned $tshr"
echo $ubout >> $banfile
$LOGGERBIN -t "GetStatusUnban" -- "$oldip clean IP"
if [ $oldip != '0.0.0.0/0' ] ; then 
$IPTABLESBIN -D getstatus -p UDP -s $oldip -j DROP
if [ $MYDEBUGUNBAN == "1" -o $MYDEBUGUNBAN == "3" ] ; then
echo remove banned IP $oldip
fi
fi
else
if [ $MYDEBUGUNBAN == "2" -o $MYDEBUGUNBAN == "3" ] ; then
if [ $oldip != '0.0.0.0/0' ] ; then 
echo no remove banned IP $oldip
fi
fi
fi
done

if [ $IPTABLEDEBUG == "1" ] ; then 
$IPTABLESBIN -nL getstatus > $mygoto/chain
fi

if  [ -f $mygoto/noDel ] ; then
rm $mygoto/noDel
fi

}


##################################################################################
##################################################################################
###################            Script routine startup             ################
##################################################################################
autoban1
autoban2

if [ $RunPart == "2" ] ; then
if [ $COUNT -ge $UNBCNT ] ; then 
unban
echo unbancounter "0" >  $mygoto/unbancnt 
fi
else
echo "Script section "Unban" disabled !!!"
fi
##################################################################################
##################################################################################
###################                 Cleanup               ########################
##################################################################################
IFS=$MYIFS
rm $captured_data 2>/dev/null
rm $captured_data_num 2>/dev/null
rm $mygoto/iptab.tmp 2>/dev/null
rm $mygoto/chain 2>/dev/null
rm $mygoto/0 2>/dev/null
################################################################################
##################################################################################
##################################################################################

