#!/bin/bash

##################################################################################
##################################################################################
#                                                                                #
#  Q3-Engine-GetStatus-Flood-Fixer                                               #
#  Version 1.4                                                                   #
#  by schnoog (schnoog@wolffiles.de)                                             #
#                                                                                #
# Versioncontrol:                                                                #
# 1.4 - changed to function based design                                         #
#       iptables usage minimized                                                 #
#       fixed not matching DNS entries                                           #
#       added syslog functionality (bans and unbans are reported to syslog)      #
# 1.3 - added vars for iptables and tcpdump paths, also fixed no-file-error      # 
#       export path for file_* set to script directory                           #
# 1.2 - fixed RegExp                                                             #
# 1.0 + 1.1 internal testing                                                     #
#                                                                                #
#                                                                                #
#                                                                                #
# Thanks to benny from Hirntot for the regexp                                    #
##################################################################################
########################       DESCRIPTION     ###################################
#                                                                                #
# This script try to get rid of the Q3-Engine getstatus-Abuse-Exploit            #
#                                                                                #
# About the exploit                                                              #
#                                                                                #
# This exploit use the getstatus udp query command with a spoofed sender         #
# adress. This 14 byte long command enganges the gameserver engine to            #
# respond the whole status of the gameserver ( > ~600 bytes on empty server)     #
# This amplification is visible if you use a tool like vnstat (vnstat -l)        #
# The outgoint traffic exceeds the incoming traffic with a faktor > 3            #
#                                                                                #
#                                                                                #
# About the script                                                               #
# This script capture the count of tcp packets set in config and search for      #
# answered getstatus queries. For any requesting IP adress the count of          #
# those packets is compared to the defind limit.                                 #
# If the limit is broken by an IP adress, the access for this IP will ne denied  #
# with iptables by adding a drop rule.                                           #
#                                                                                #
# Configuration                                                                  #
#                                                                                #
# By default, the script don`t need any configuration                            #
# The default values                                                             #
# IPTABLESBIN=/usr/sbin/iptables                                                 #
# TCPDUMPBIN=/usr/sbin/tcpdump                                                   #
# LOGGERBIN=/bin/logger                                                          #
# CAPTURETIME=3                                                                  #
# MAXPERSECONDS=2                                                                #
#                                                                                #
#                                                                                #
#                                                                                #
# will enforces drops in the case that:                                          #
#                                                                                #
# Each IP which requests more than 2 getstatus respones per second,              #
# averaged over 3 seconds                                                        #
#                                                                                #
# Requirements                                                                   #
#                                                                                #
# This script use a few open source tools to offence against this attacks        #
# tcpdump - capture incoming packets: http://www.tcpdump.org/                    #
# iptables - the most used linux firewall (packet filter)                        #
# GNU-tools - grep, cat                                                          #
#                                                                                #
# THIS SCRIPT COMES WITH NO WARRANTY! USE IT AT YOUR OWN RISK ONLY!              #
#                                                                                #
##################################################################################
##################################################################################
##################################################################################
#                                                                                #
#                                SETUP                                           #
#                                                                                #
##################################################################################
##################################################################################
#                                                                                #
#      1. Ensure you installed iptables and tcpdump                              #
#                                                                                #
#      2. Place this script on your server, and allow execution for it           #
#           #chmod +x getstatus_*                                                #
#                                                                                #
#      3. Change the configuration below to your system requirements             #
#         Hint: which iptables  and  which tcpdump  and which logger             #
#               will return the values needed to insert below                    #
#                                                                                #
#      4. Run the script once to see any errors occour                           #
#           #./getstatus_ban1_4.sh                                               #
#                                                                                #
#      5. If all went well, configure a cronjob to run the script periodically   #
#                                                                                #
#                                                                                #
######################       CONFIGURATION      ##################################
##################################################################################
CAPTURETIME=20
MAXPERSECONDS=3
IPTABLESBIN=/usr/sbin/iptables
TCPDUMPBIN=/usr/sbin/tcpdump
LOGGERBIN=/bin/logger
##################################################################################
MYDEBUG=0
DEBUGOUT=0
##################################################################################
##################################################################################
##################################################################################
##################################################################################
#######################      initialisation     ##################################
##################################################################################
thisscript=$(readlink -f $0)
mygoto=`dirname $thisscript`
mygoto="$mygoto/"
cd $mygoto
MYIFS=$IFS
IFS="
"
##################################################################################
##################################################################################
###################### set some variables and files ##############################
##################################################################################
# All bans where stored in the file defined on next line
banfile="$mygoto/banlist"
iptablesoutputlist=iptables_content
export iptablesoutputlist
rm $iptablesoutputlist 2>/dev/null
captured_data="$mygoto/tmp_captured"
touch $captured_data
captured_data_num="$mygoto/tmp_captured_num"
touch $captured_data_num
calclimit=$((MAXPERSECONDS*CAPTURETIME))
export calclimit
export MYDEBUG
export DEBUGOUT
export captured_data
export captured_data_num
export IPTABLESBIN
export TCPDUMPBIN
export CAPTURETIME
export MAXPERSECONDS
export LOGGERBIN
##################################################################################
##################################################################################
##################################################################################
################################  functions ######################################
##################################################################################
##################################################################################
#######   catpure data - captures all tcp packets for the defined time   #########
#######                  output is saved to predefined file              #########
##################################################################################
function capture_data {
$TCPDUMPBIN -f -c 100000 -A >$captured_data 2>$captured_data_num &
pid=$!
sleep $CAPTURETIME
kill $pid
}
##################################################################################
#######   ban          - Ban the given IP ($1) - Port ($2) combination,  #########
#######                  and log data together with request frequence    #########
#######                  to "banlist"                                    #########
##################################################################################
function ban {
IP=$1
PORT=$2
RPS=$3    #### Requests per second
$IPTABLESBIN -A INPUT -p udp -s $IP --dport $PORT -j DROP
$LOGGERBIN -t "GetStatusBan" -- "$IP : $PORT banned -- $RPS Requests per second"
if [ $DEBUGOUT == "1" ]
then
echo "$IPTABLESBIN -A INPUT -p udp -s $IP --dport $PORT -j DROP" >> debug.out
fi
ts=`date --utc +%s`
rps=$((IPCNT/CAPTURETIME))
tshr=`date --utc --date "1970-01-01 $ts sec" "+%Y-%m-%d %T"`
out="$ts $IP $PORT $IPCNT = $RPS ReqPerSec banned $tshr"
echo $out >> $banfile
}
##################################################################################
#######   unban        - Unban the given IP ($1) - Port ($2) combination  ########
#######                  (delete drop rule, erease entry from banfile     ########
##################################################################################
function unban {
IP=$1
PORT=$2
IPTBLN=`grep "$IP" $iptablesoutputlist | grep "$PORT" | awk '{print $1}'`
$LOGGERBIN -t "GetStatusBan" -- "$IP : $PORT unbanned"
$IPTABLESBIN -D INPUT $IPTBLN
if [ $DEBUGOUT == "1" ]
then
echo "$IPTABLESBIN -D INPUT $IPTBLN" >> debug.out
fi
grep -v "$IP" $banfile > tmp001
mv tmp001 $banfile
}
##################################################################################
#######  autounban     - walks through banfile and check each entry for   ########
#######                  corresponding captured tcp date. If no match is  ########
#######                  found, unban is called to release drop rule      ########
##################################################################################
function autounban {
if [ -f $banfile ]
then
if [ ! -f $iptablesoutputlist ]
then
$IPTABLESBIN -L -v -n --line-numbers > $iptablesoutputlist
fi
bancont=$(cat $banfile | sort -u)
for banline in $bancont
do
LIP=`echo $banline | awk '{print $2}'`
LPORT=`echo $banline | awk '{print $3}'`
indump=$(grep "$LIP" $captured_data | wc -l)
if [ $indump == "0" ]
then
if [ $DEBUGOUT == "1" ]
then
echo "unban $LIP $LPORT"
fi
unban "$LIP" "$LPORT"
sleep 1
fi
done
fi
}
##################################################################################
#######   autoban      - starts the ban routine: calls capture_data      #########
#######                  greps the IPs to which getStatusRepsonsed where #########
#######                  delivered. If more then defined responses       #########
#######                  sent to a single IP, the ban routine is called  #########
##################################################################################
function autoban {
capture_data
allips=$(grep -B2 Respon $captured_data | grep UDP | awk '{print $5}' | cut -d '.' -f 1,2,3,4 | sort -u)
for newip in $allips
do
cnt=$(grep -B2 Respon $captured_data | grep UDP | grep $newip | wc -l)
ports=$(grep -B2 Respon $captured_data | grep UDP | grep $newip | awk '{print $3}' | perl -e 'while (<STDIN>) {print "$1\n" if ($_ =~ /\.(\d+)$/)}' | sort -u)
rps=$((cnt/CAPTURETIME))
for port in $ports
do
if [ $MYDEBUG == "1" ]
then
calclimit=8
echo "--No ban: $newip $port $cnt $rps"
fi
if [ $cnt -gt $calclimit ]
then
ban "$newip" "$port" "$rps"
fi
done
done
}
##################################################################################
##################################################################################
###################            Script routine startup             ################
##################################################################################
autoban
autounban
##################################################################################
##################################################################################
###################                 Cleanup               ########################
##################################################################################
IFS=$MYIFS
rm $captured_data 2>/dev/null
rm $captured_data_num 2>/dev/null
rm $iptablesoutputlist 2>/dev/null
##################################################################################
##################################################################################
##################################################################################
