#!/usr/bin/perl
#
# Pseudo Config:
$lock_file    = "var/shrubet.lock";
$pukas_file   = "etc/modified.cfg";

########################################

my %level;
my %ban;
my %admin;

sub LOCK_SH { 1 }    # In case you don't have
sub LOCK_EX { 2 }    # the standard Fcntl module.  You
sub LOCK_NB { 4 }    # should, but who can tell
sub LOCK_UN { 8 }    # how those chips fall?

sub shrub_ban {

	$shrubbot_cfg 	= shift;
	$mode    	= shift;
	$guid   	= shift;
	$expires 	= shift;
	$banner  	= shift;
	$ip      	= shift;
	$reason  	= shift;
	$name    	= shift;
	$eguid		= shift || "";
	$guid 		= uc($guid);
	
	&lock;
	
	&load_config($shrubbot_cfg);
	
	if ( $mode eq "add" )
	{
	
	    if ( !$guid || !$banner || !$reason || !$name || !$ip )
	    {
	        print "Usage: $0 add|remove <guid> <expires> <banner> <ip> <reason> <name>\n";
	        &unlock();
	        return 0;
	    }
	    if ( !$ip =~ /\d+\.\d+\.\d+\.\d+/ )
	    {
	        print "Ungueltige IP angegeben.\n";
	        &unlock();
	        return 0;
	    }
	
	    if ( $ban{$guid} )
	    {
	        print "This guid is already banned!\n";
	        &unlock();
	        return 0;
	    }
	
	    # DO THE BAN HERE ... (just append)
	    my $time = time2date(time);

	    open( SHRUB, ">>$shrubbot_cfg" );
	    print SHRUB <<ENDE;
[ban]
name\t= $name
guid\t= $guid
ENDE
print SHRUB "eguid\t= $eguid\n" if ($eguid);
	print SHRUB <<ENDE;
ip\t= $ip
reason\t= $reason
made\t= $time
expires\t= $expires
banner\t= $banner

ENDE
	    close(SHRUB);
	    
	    if ($pukas_file) {

		open( PUKAS, ">>$pukas_file" );
	    	print PUKAS <<ENDE;
[ban]
action\t= add
name\t= $name
guid\t= $guid
ENDE
		print PUKAS "eguid\t= $guid\n" if ($eguid);
		print PUKAS <<ENDE;
ip\t= $ip
reason\t= $reason
made\t= $time
expires\t= $expires
banner\t= $banner

ENDE
		close (PUKAS);
	    }

	    # DONE ...
	
	}
	elsif ( $mode eq "remove" )
	{
	
	    if ( !$guid )
	    {
	        print "Usage: $0 add|remove <guid>\n";
	        &unlock();
	        return 0;
	    }
	    else
	    {
	        if ( !$ban{$guid} && !$ban{ lc($guid) } )
	        {
	            print "This guid is not banned!\n";
	            &unlock();
	            return 0;
	        }
	
		delete $ban{$guid};
		
		&write_config($shrubbot_cfg);
		
	    	if ($pukas_file) {

			open( PUKAS, ">>$pukas_file" );
	    		print PUKAS <<ENDE;
[ban]
action\t= remove
guid\t= $guid

ENDE
			close (PUKAS);
	    	}
	
	    }
	}
	else
	{
	    print "Usage: $0 add|remove <guid> <expires> <banner> <ip> <reason> <name>\n";
      	    &unlock();
	    return 0;
	}
	
	return 1;
	
	&unlock;

}

sub shrub_admin
{

	my $shrubbot_cfg = shift;
	my $guid  = shift;
	my $level = shift;
	my $name  = shift;

	$guid = uc($guid);
	
	if ( !defined($level) || $level < 0 || !$guid || ( !$name && $level != 0 ) || length($guid) != 32 )
	{
	    print "Usage: $0 <guid> <level> [name]\n";
	    return 0;
	}

	&lock;
	&load_config($shrubbot_cfg);
	
	if ( defined( $admin{$guid} ) && $admin{$guid}{level} == $level )
	{

	    #print "unlock...\n";
	    # Already right level
            &unlock();
	    return 1;
	}
	else
	{
	
	    if ( $level == 0 && defined( $admin{$guid} ) )
	    {
	        delete $admin{$guid};
	        &write_config ($shrubbot_cfg);	
		if ($pukas_file) {

			open( PUKAS, ">>$pukas_file" );
	    		print PUKAS <<ENDE;
[admin]
action\t= remove
guid\t= $guid

ENDE
			close (PUKAS);
	    	}

	    }
	    else
	    {

	    	my $action = defined($admin{$guid}) ? "modify" : "add";
	        $admin{$guid}{'name'}  = $name;
	        $admin{$guid}{'flags'} = "";
	        $admin{$guid}{'level'} = $level;
	        &write_config ($shrubbot_cfg);	


		if ($pukas_file) {

			open( PUKAS, ">>$pukas_file" );
	    		print PUKAS <<ENDE;
[admin]
action\t= $action
name\t= $name
guid\t= $guid
level\t= $level
flags\t= 

ENDE
			close (PUKAS);
	    	}

	    }
	}
	&unlock();
	return 1;
	
}

sub write_config 
{
	    my $filename = shift;
	    return if (!$filename);
	    
	    open( SHRUB, ">$filename" );
	    foreach $lvl ( sort keys %level )
	    {
	        print SHRUB <<LEVEL
[level]
level\t= $lvl
name\t= $level{$lvl}{'name'}
flags\t= $level{$lvl}{'flags'}

LEVEL
    	    }

	    foreach $guid ( keys %admin )
	    {
	        print SHRUB <<ADMIN
[admin]
name\t= $admin{$guid}{'name'}
guid\t= $guid
level\t= $admin{$guid}{'level'}
flags\t= $admin{$guid}{'flags'}

ADMIN
	    }
	    foreach $guid ( keys %ban )
	    {

		if (defined($ban{$guid}{'eguid'})) {

	        	print SHRUB <<BAN
[ban]
name\t= $ban{$guid}{'name'}
guid\t= $guid
eguid\t= $ban{$guid}{'eguid'}
ip\t= $ban{$guid}{'ip'}
reason\t= $ban{$guid}{'reason'}
made\t= $ban{$guid}{'made'}
expires\t= $ban{$guid}{'expires'}
banner\t= $ban{$guid}{'banner'}

BAN
		}
		else {
	        	print SHRUB <<BAN
[ban]
name\t= $ban{$guid}{'name'}
guid\t= $guid
ip\t= $ban{$guid}{'ip'}
reason\t= $ban{$guid}{'reason'}
made\t= $ban{$guid}{'made'}
expires\t= $ban{$guid}{'expires'}
banner\t= $ban{$guid}{'banner'}

BAN

		}

	    }

	close (SHRUB);
	%level 	= ();
	%ban 	= ();
	%admin 	= ();

}

sub time2date
{
    my $time = shift;
    my ( $sec, $min, $std, $mtag, $mon, $jahr, $wochentag, $jahrestag ) = localtime($time);

    $mon++;
    $jahr += 1900;
    $jahr =~ s/^..//;

    $sec  = "0$sec"  if ( $sec < 10 );
    $min  = "0$min"  if ( $min < 10 );
    $std  = "0$std"  if ( $std < 10 );
    $mtag = "0$mtag" if ( $mtag < 10 );
    $mon  = "0$mon"  if ( $mon < 10 );

    return "$mon/$mtag/$jahr $std:$min:$sec";

}

################
# Subroutinen: #
################

sub lock
{

    open( DB_FH, ">$lock_file" );
    flock( DB_FH, LOCK_ );

    unless ( flock( DB_FH, LOCK_EX | LOCK_NB ) )
    {
        unless ( flock( DB_FH, LOCK_EX ) ) { die "flock: $!" }
    }

}

sub unlock
{
    flock( DB_FH, LOCK_UN );
    close(DB_FH);
}

#
# New shrub loading sub
#
sub load_config
{

    my $file = shift;

    my %tmp_admin;
    my %tmp_level;
    my %tmp_ban;
    my $abschnitt = "";
    my $unfinished = 1;
    %admins = ();
    %level  = ();
    %ban   = () if ( $config{'manage_bans'} );

    open( IN, $file ) || &log("Error opening file $file: $!");

    my $zeile = "";
    while ( ($zeile = <IN>) or $unfinished)
    {
        chomp $zeile ;
        $zeile =~ s/(^\s*|\s*\r*$)//g;

        #next unless ( $zeile || $zeile =~ /\s*\#/ );
        $abschnitt = $1 if ($zeile =~ /^\[(.*)\]$/);
        $unfinished = ( $zeile ? 1 : 0 );

        #print "$zeile -> UF: $unfinished, $abschnitt\n";

        if ( $abschnitt eq "level" )
        {

            # level   = 1
            # name    = ^fI am Protected
            $tmp_level{$1} = $2 if ($zeile =~ /^(.*?)\s*=\s*(.*)/);


            if ( !$zeile && $tmp_level{'name'}
                 && defined( $tmp_level{'level'} )
                 && $tmp_level{'flags'} )
            {
                $level{ $tmp_level{'level'} }{'name'}  = $tmp_level{'name'};
                $level{ $tmp_level{'level'} }{'flags'} = $tmp_level{'flags'};
                $level{ $tmp_level{'level'} }{'level'} = $tmp_level{'level'};

                %tmp_level = ();
                $unfinished = 0;
            }
            elsif (!$zeile) {
                %tmp_level = ();
                $unfinished = 0;
            }
        }
        elsif ( $abschnitt eq "ban" )
        {
            $tmp_ban{$1} = $2 if ($zeile =~ /^(.*?)\s*=\s*(.*)/);


            if (    !$zeile && $tmp_ban{'name'}
                 && $tmp_ban{'reason'}
                 && defined( $tmp_ban{'expires'} )
                 && $tmp_ban{'banner'}
                 && $tmp_ban{'made'}
                 && $tmp_ban{'guid'} )
            {
	
		$tmp_ban{'guid'} = uc($tmp_ban{'guid'});
                $ban{ $tmp_ban{'guid'} }{'name'}    = $tmp_ban{'name'};
                $ban{ $tmp_ban{'guid'} }{'reason'}  = $tmp_ban{'reason'};
                $ban{ $tmp_ban{'guid'} }{'ip'}      = $tmp_ban{'ip'};
                $ban{ $tmp_ban{'guid'} }{'made'}    = $tmp_ban{'made'};
                $ban{ $tmp_ban{'guid'} }{'expires'} = $tmp_ban{'expires'};
                $ban{ $tmp_ban{'guid'} }{'banner'}  = $tmp_ban{'banner'};
                $ban{ $tmp_ban{'guid'} }{'eguid'}   = $tmp_ban{'eguid'} if (defined($tmp_ban{'eguid'}));
                %tmp_ban = ();
                $unfinished = 0;
            }
            elsif (!$zeile) {
                %tmp_ban = ();
                $unfinished = 0;
            }
        }
        elsif ( $abschnitt eq "admin" )
        {
            $tmp_admin{$1} = $2 if ($zeile =~ /^(.*?)\s*=\s*(.*)/);

	    if (!$zeile && defined( $tmp_admin{'flags'} )
                 && $tmp_admin{'name'}
                 && $tmp_admin{'level'}
                 && $tmp_admin{'guid'} )
            {
		$tmp_admin{'guid'} = uc($tmp_admin{'guid'});
                $admin{ $tmp_admin{'guid'} }{'name'}  = $tmp_admin{'name'};
                $admin{ $tmp_admin{'guid'} }{'flags'} = $tmp_admin{'flags'};
                $admin{ $tmp_admin{'guid'} }{'level'} = $tmp_admin{'level'};
                %tmp_admin = ();
                $unfinished = 0;
            }
            elsif (!$zeile) {
                %tmp_admin = ();
                $unfinished = 0;
            }
        }
    }
    close(IN);


}


1;
