#!/usr/bin/perl
# 
# Functions:
#

$seen_db_file = "var/seen.db";

use DB_File;

sub LOCK_SH { 1 }                   # In case you don't have
sub LOCK_EX { 2 }                   # the standard Fcntl module.  You
sub LOCK_NB { 4 }                   # should, but who can tell
sub LOCK_UN { 8 }                   # how those chips fall?

################
# Subroutinen: #
################

sub open_seen
{

	$seen_obj = tie(%seen, 'DB_File', $seen_db_file, O_CREAT|O_RDWR, 0666)
        	or die die "dbcreat $seen_db_file} $!";

	$fd = $seen_obj->fd;
	open(DB_FH, "+<&=$fd") 
		or die "dup $!";
}


sub close_seen
{
	flock(DB_FH, LOCK_UN);
	undef $seen;
	untie %seen;
	close(DB_FH);
}


sub read_lock_seen
{
	unless (flock (DB_FH, LOCK_SH | LOCK_NB)) {
    		print "$$: CONTENTION; can't read during write update!
               	Waiting for read lock ($!) ....";
    		unless (flock (DB_FH, LOCK_SH)) { die "flock: $!" }
	}
}

sub unlock_seen
{
	flock(DB_FH, LOCK_UN);
	$seen->sync;
}

sub write_lock_seen
{
	unless (flock (DB_FH, LOCK_EX | LOCK_NB)) {
    		print "$$: CONTENTION; must have exclusive lock! Waiting for write lock ($!) ....";
		unless (flock (DB_FH, LOCK_EX)) { die "flock: $!" }
	}
}

sub set_seen
{

	my $index = shift;
	my $value = shift;

	if ($index && $value) {
	#	print "Writing: $index, $value\n";
		#&write_lock_seen();
		$seen{$index} = $value;
		$seen_obj->sync	
		#&unlock_seen();
	}
}

sub get_seen
{

        my $index = shift;

        #&read_lock_seen();
	my $tmp = $seen{$index};
	#&unlock_seen();

        return $tmp ;

}

1;
