#!/usr/bin/perl
#
# Konfig:
$shrubbot_cfg = "etc/shrubbot.cfg";
$lock_file    = "var/shrubet.lock";

########################################

my %level;
my %ban;
my %admin;

sub LOCK_SH { 1 }    # In case you don't have
sub LOCK_EX { 2 }    # the standard Fcntl module.  You
sub LOCK_NB { 4 }    # should, but who can tell
sub LOCK_UN { 8 }    # how those chips fall?

$mode    = shift;
$guid    = shift;
$expires = shift;
$banner  = shift;
$ip      = shift;
$reason  = shift;
$name    = shift;

$guid = uc($guid);

&lock;

&load_config;

if ( $mode eq "add" )
{

    if ( !$guid || !$banner || !$reason || !$name || !$ip )
    {
        print "Usage: $0 add|remove <guid> <expires> <banner> <ip> <reason> <name>\n";
        exit;
    }
    if ( !$ip =~ /\d+\.\d+\.\d+\.\d+/ )
    {
        print "Ungueltige IP angegeben.\n";
        exit;
    }

    if ( $ban{$guid} )
    {
        print "This guid is already banned!\n";
        exit;
    }

    # DO THE BAN HERE ...
    my $time = time2date(time);

    open( SHRUB, ">>$shrubbot_cfg" );
    print SHRUB <<ENDE;
[ban]
name\t= $name
guid\t= $guid
ip\t= $ip
reason\t= $reason
made\t= $time
expires\t= $expires
banner\t= $banner

ENDE

    close(SHRUB);

    # DONE ...

}
elsif ( $mode eq "remove" )
{

    if ( !$guid )
    {
        print "Usage: $0 add|remove <guid>\n";
        exit;
    }
    else
    {
        if ( !$ban{$guid} && !$ban{ lc($guid) } )
        {
            print "This guid is not banned!\n";
            exit;
        }

        # HERE DO THE UNBAN ...
        open( SHRUB, "$shrubbot_cfg" );
        @file = <SHRUB>;
        close(SHRUB);

        my $tmp;
        my $delete    = 0;
        my $last_line = "";
        my $spare     = 0;

        open( OUT, ">$shrubbot_cfg" );
        for $line (@file)
        {

            chomp $line;

            $abschnitt = $1 if ( $line =~ /^\[(.*)\]$/ );
            if ( !$line )
            {
                if ($tmp)
                {
                    print OUT $tmp;
                    $tmp = "";
                }
                if ($delete)
                {
                    $spare  = 1;
                    $delete = 0;
                }
            }

            if ( $abschnitt eq "ban" )
            {
                if ( !$spare )
                {

                    # solange daten sammeln, bis ich ne guid hab...
                    if ( !$delete && $line =~ /guid\s+=\s+(.*)/ )
                    {
                        if ( uc($1) eq $guid )
                        {
                            $delete = 1;
                            $tmp    = "";
                        }
                    }
                    $tmp .= $line . "\n" if ( !$delete );
                }
                else
                {
                    $spare = 0;
                }
            }
            else
            {

                # einfach schreiben...
                print OUT $line . "\n";
            }

        }
        print OUT $tmp;
        close(OUT);

    }
}
else
{
    print "Usage: $0 add|remove <guid> <expires> <banner> <ip> <reason> <name>\n";
    exit;
}

&unlock;

exit;

sub load_config
{

    # Files auslesen
    my $abschnitt = "";
    my $tmp_level;
    my $tmp_ban;
    my $tmp_admin;

    open( IN, $shrubbot_cfg );

    while (<IN>)
    {
        chomp;
        s/(^\s*|\s*\r*$)//g;
        next unless ( $_ || /\s*\#/ );

        $abschnitt = $1 if (/^\[(.*)\]$/);

        if ( $abschnitt eq "level" )
        {

            # level   = 1
            # name    = ^fI am Protected
            $tmp_level{$1} = $2 if (/^(.*?)\s+=\s+(.*)/);

            if ( $tmp_level{'name'} && $tmp_level{'level'} )
            {
                $level{ $tmp_level{'level'} } = $tmp_level{'name'};
                %tmp_level = ();
            }
        }
        elsif ( $abschnitt eq "ban" )
        {
            $tmp_ban{$1} = $2 if (/^(.*?)\s+=\s+(.*)/);

            if (    $tmp_ban{'name'}
                 && $tmp_ban{'reason'}
                 && defined( $tmp_ban{'expires'} )
                 && $tmp_ban{'made'}
                 && $tmp_ban{'guid'} )
            {

                $ban{ $tmp_ban{'guid'} }{'name'}    = $tmp_ban{'name'};
                $ban{ $tmp_ban{'guid'} }{'reason'}  = $tmp_ban{'reason'};
                $ban{ $tmp_ban{'guid'} }{'made'}    = $tmp_ban{'made'};
                $ban{ $tmp_ban{'guid'} }{'expires'} = $tmp_ban{'expires'};
                %tmp_ban                            = ();
            }
        }
        elsif ( $abschnitt eq "admin" )
        {
            $tmp_admin{$1} = $2 if (/^(.*?)\s+=\s+(.*)/);
            if ( $tmp_admin{'name'} && $tmp_admin{'level'} && $tmp_admin{'guid'} )
            {
                $admin{ $tmp_admin{'guid'} } = $tmp_admin{'level'};
                %tmp_admin = ();
            }
        }
        else
        {

            # ???
        }

    }

}

sub time2date
{
    my $time = shift;
    my ( $sec, $min, $std, $mtag, $mon, $jahr, $wochentag, $jahrestag ) = localtime($time);

    $mon++;
    $jahr += 1900;
    $jahr =~ s/^..//;

    $sec  = "0$sec"  if ( $sec < 10 );
    $min  = "0$min"  if ( $min < 10 );
    $std  = "0$std"  if ( $std < 10 );
    $mtag = "0$mtag" if ( $mtag < 10 );
    $mon  = "0$mon"  if ( $mon < 10 );

    return "$mon/$mtag/$jahr $std:$min:$sec";

}

################
# Subroutinen: #
################

sub lock
{

    open( DB_FH, ">$lock_file" );
    flock( DB_FH, LOCK_ );

    unless ( flock( DB_FH, LOCK_EX | LOCK_NB ) )
    {
        unless ( flock( DB_FH, LOCK_EX ) ) { die "flock: $!" }
    }

}

sub unlock
{
    flock( DB_FH, LOCK_UN );
    close(DB_FH);
}

