#!/usr/bin/perl
#
# Konfig:
$shrubbot_cfg = "etc/shrubbot.cfg";
$lock_file    = "var/shrubet.lock";

########################################

my %level;
my %ban;
my %admin;

sub LOCK_SH { 1 }    # In case you don't have
sub LOCK_EX { 2 }    # the standard Fcntl module.  You
sub LOCK_NB { 4 }    # should, but who can tell
sub LOCK_UN { 8 }    # how those chips fall?

my $guid  = shift;
my $level = shift;
my $name  = shift;

$guid = uc($guid);

if ( !defined($level) || $level < 0 || !$guid || ( !$name && $level != 0 ) || length($guid) != 32 )
{
    print "Usage: $0 <guid> <level> [name]\n";
    exit;
}

&lock;
&load_config;

if ( defined( $admin{$guid} ) && $admin{$guid}{level} == $level )
{

    # Already right level
    &unlock;
    exit;
}
else
{

    if ( $level == 0 )
    {
        delete $admin{$guid};
    }
    else
    {
        $admin{$guid}{'name'}  = $name;
        $admin{$guid}{'flags'} = "";
        $admin{$guid}{'level'} = $level;
    }

    open( SHRUB, ">${shrubbot_cfg}" );
    foreach $lvl ( sort keys %level )
    {
        print SHRUB <<LEVEL
[level]
level\t= $lvl
name\t= $level{$lvl}{'name'}
flags\t= $level{$lvl}{'flags'}

LEVEL
    }

    foreach $guid ( keys %admin )
    {
        print SHRUB <<ADMIN
[admin]
name\t= $admin{$guid}{'name'}
guid\t= $guid
level\t= $admin{$guid}{'level'}
flags\t= $admin{$guid}{'flags'}

ADMIN
    }
    foreach $guid ( keys %ban )
    {
        print SHRUB <<BAN
[ban]
name\t= $ban{$guid}{'name'}
guid\t= $guid
ip\t= $ban{$guid}{'ip'}
reason\t= $ban{$guid}{'reason'}
made\t= $ban{$guid}{'made'}
expires\t= $ban{$guid}{'expires'}
banner\t= $ban{$guid}{'banner'}

BAN
    }
}

&unlock;

exit;

sub load_config
{

    # Files auslesen
    my $abschnitt = "";
    my $tmp_level;
    my $tmp_ban;
    my $tmp_admin;

    open( IN, $shrubbot_cfg );

    while (<IN>)
    {
        chomp;
        s/(^\s*|\s*\r*$)//g;
        next unless ( $_ || /\s*\#/ );
        $abschnitt = $1 if (/^\[(.*)\]$/);

        if ( $abschnitt eq "level" )
        {

            # level   = 1
            # name    = ^fI am Protected
            $tmp_level{$1} = $2 if (/^(.*?)\s+=\s+(.*)/);

            if (    $tmp_level{'name'}
                 && defined( $tmp_level{'level'} )
                 && $tmp_level{'flags'} )
            {
                $level{ $tmp_level{'level'} }{'name'}  = $tmp_level{'name'};
                $level{ $tmp_level{'level'} }{'flags'} = $tmp_level{'flags'};
                $level{ $tmp_level{'level'} }{'level'} = $tmp_level{'name'};
                %tmp_level                             = ();
            }
        }
        elsif ( $abschnitt eq "ban" )
        {
            $tmp_ban{$1} = $2 if (/^(.*?)\s+=\s+(.*)$/);

            if (    $tmp_ban{'name'}
                 && $tmp_ban{'reason'}
                 && defined( $tmp_ban{'expires'} )
                 && $tmp_ban{'banner'}
                 && $tmp_ban{'made'}
                 && $tmp_ban{'guid'} )
            {

                $ban{ $tmp_ban{'guid'} }{'name'}    = $tmp_ban{'name'};
                $ban{ $tmp_ban{'guid'} }{'reason'}  = $tmp_ban{'reason'};
                $ban{ $tmp_ban{'guid'} }{'ip'}      = $tmp_ban{'ip'};
                $ban{ $tmp_ban{'guid'} }{'made'}    = $tmp_ban{'made'};
                $ban{ $tmp_ban{'guid'} }{'expires'} = $tmp_ban{'expires'};
                $ban{ $tmp_ban{'guid'} }{'banner'}  = $tmp_ban{'banner'};
                %tmp_ban                            = ();
            }
        }
        elsif ( $abschnitt eq "admin" )
        {
            $tmp_admin{$1} = $2 if (/^(.*?)\s+=\s*(.*)/);
            if (    defined( $tmp_admin{'flags'} )
                 && $tmp_admin{'name'}
                 && $tmp_admin{'level'}
                 && $tmp_admin{'guid'} )
            {
                $admin{ $tmp_admin{'guid'} }{'name'}  = $tmp_admin{'name'};
                $admin{ $tmp_admin{'guid'} }{'flags'} = $tmp_admin{'flags'};
                $admin{ $tmp_admin{'guid'} }{'level'} = $tmp_admin{'level'};
                %tmp_admin                            = ();
            }
        }
        else
        {

            # ???
        }

    }

}

sub time2date
{
    my $time = shift;
    my ( $sec, $min, $std, $mtag, $mon, $jahr, $wochentag, $jahrestag ) = localtime($time);

    $mon++;
    $jahr += 1900;
    $jahr =~ s/^..//;

    $sec  = "0$sec"  if ( $sec < 10 );
    $min  = "0$min"  if ( $min < 10 );
    $std  = "0$std"  if ( $std < 10 );
    $mtag = "0$mtag" if ( $mtag < 10 );
    $mon  = "0$mon"  if ( $mon < 10 );

    return "$mon/$mtag/$jahr $std:$min:$sec";

}

################
# Subroutinen: #
################

sub lock
{

    open( DB_FH, ">$lock_file" );
    flock( DB_FH, LOCK_ );

    unless ( flock( DB_FH, LOCK_EX | LOCK_NB ) )
    {
        unless ( flock( DB_FH, LOCK_EX ) ) { die "flock: $!" }
    }

}

sub unlock
{
    flock( DB_FH, LOCK_UN );
    close(DB_FH);
}

