#!/usr/bin/perl

# TO USE THIS, You have to patch the ets.pl with my mysql-patch !

my $mysql_hostname = "localhost";
my $mysql_username = "username";
my $mysql_password = "password";
my $mysql_database = "database";
my $mysql_table	= "et";

my $name = shift or die("Kein Name angegeben.");


use DBI;

# Connect to the database.
my $dbh = DBI->connect(	"DBI:mysql:database=$mysql_database;host=$mysql_hostname" , 
			"$mysql_username", "$mysql_password", {'RaiseError' => 1});

$statement = "	select 	uptime, weapon, kills, deaths, hits, headshots, headshots_acc, hits_acc
			from $mysql_table where name=".$dbh->quote(&convert_name($name));

# Now retrieve data from the table.
my $sth = $dbh->prepare($statement);
$sth->execute();
my $ref = $sth->fetchrow_arrayref;

if ($sth->rows == 0) {
	print "No stats for $name ^7available ...\n";
	exit;
}

my %stats;
$stats{'playtime'} 	= $$ref[0];
$stats{'weapon'} 	= $$ref[1];
$stats{'kills'} 	= $$ref[2];
$stats{'deaths'} 	= $$ref[3];
$stats{'hits'} 		= $$ref[4];
$stats{'headshots'} 	= $$ref[5];
$stats{'headshots_acc'} = $$ref[6];
$stats{'hits_acc'} 	= $$ref[7];

$sth->finish();

if ($stats{'deaths'} == 0){
	$kratio = "N/A";
}
else {
	$kratio = &round($stats{'kills'}/$stats{'deaths'});	
}
# Bildschirmausgabe...

$timeplayed = int($stats{playtime}/60);

if ($timeplayed > 300) 
{
	my $mins = $timeplayed % 60;
	my $hours = int($timeplayed / 60);
	$timeplayed = $hours."h $mins"."m";
}
else {
	$timeplayed .= " min.";
}

print "Stats for: $name ^7(Playtime: $timeplayed), PW: $stats{'weapon'}\n";
print "K: $stats{'kills'}/D: $stats{'deaths'}/R: ".$kratio.
   ", Acc: ".&round($stats{'hits_acc'})."%, HS-Acc: ".&round($stats{'headshots_acc'})."%\n";

exit;

sub round
{
	my $date = shift;
	return (int($date*100))/100;
}

sub convert_name
{
    my $name = shift;

    $name =~ s/\^.//g;

    # This is the client-side code, but the server side code works different *sigh*
    #$name =~ s/\^[^\^]//g;
    #$name =~ s/\^\^/\^/g;
    $name = lc($name);
    return $name;

}

