#!/usr/bin/perl

# Josh Menke (Zaedyn): http://www.bpark3.com
# Adapted from one of the other stats scripts
#
# etpub stats script for etadmin_mod
# Add these to the [externals] section of etadmin.cfg
# 
# The first one gets a player's own stats. Usage in-game: !stats
# stats			= addons/etpub_stats.pl "<GUID>" "<COLOR_PLAYER>"
# The second gets another player's stats. Usage in-game: !pstats Potter
# pstats			= addons/etpub_stats.pl "<PART2GUID>" "<PART2CNAME>"

use strict;

# Make this the path to your xpsave.cfg
my $xpsave_cfg = "/path/to/.etwolf/etpub/xpsave.cfg";

my $entry_type = "";
my %tmp_xpsave = ();
my $entry_type = "";
my %xpsave = ();
my $killrating = 1600;
my $playerrating = 1600;

my $guid = shift or die("No GUID.");
my $name = shift or die("No name.");

open( IN, $xpsave_cfg ) || die("Error opening file $xpsave_cfg: $!");
while (<IN>) {
    chomp;
    s/(^\s*|\s*\r*$)//g;

    next unless ( $_ || /\s*\#/ );
		if (/^\[(.*)\]$/) {
			$entry_type = $1;
			%tmp_xpsave = ();
		}

    if ( $entry_type eq "xpsave" ) {
        $tmp_xpsave{$1} = $2 if (/^(.*?)\s+=\s+(.*)/);

        if ( $tmp_xpsave{'name'} && $tmp_xpsave{'guid'} && $tmp_xpsave{'playerrating'} && $tmp_xpsave{'killrating'} ) {
					$tmp_xpsave{'name'} =~ s/\^.//g;
					%{$xpsave{ $tmp_xpsave{'guid'} }} = %tmp_xpsave;
					if ($tmp_xpsave{'guid'} eq $guid) {
						$killrating = $tmp_xpsave{'killrating'};
						$playerrating = $tmp_xpsave{'playerrating'};
					}
					%tmp_xpsave = ();
        }
    }
}
close(IN);

my $prank = 1;
for my $player (sort( {$b->{playerrating} <=> $a->{playerrating};} values %xpsave)) {
	my $pguid = $$player{'guid'};
	last if ($pguid eq $guid);
	$prank++;
}

my $krank = 1;
for my $player (sort( {$b->{killrating} <=> $a->{killrating};} values %xpsave)) {
	my $pguid = $$player{'guid'};
	last if ($pguid eq $guid);
	$krank++;
}

if ($krank == 1) {
	$krank = "^1Top KILLA";
}

if ($prank == 1) {
	$prank = "^1Top PLAYA";
}

print "^f[ ^7$name^f ] [Rank:^3$prank^f] [Kill Rank:^3$krank^f]\n^f[Rating:^3$playerrating^f] [^fKill Rating:^3$killrating^f]";
