-- Dynamic Cvar Changer
-- LUA by N!trox*
-- June 3rd 2010
-- Called everytime ClientUserinfoChanged is called by the server
-- This script can be useful if admins want to modify weapon restrictions 
-- depending on how many players are playing (spectators are ignored).
-- It was first created to allow admins to dynamically change g_TDMScore 
-- on N!tmod server running TeamDeathMatch gametype.
-- This script should be compatible with ANY mod that supports LUA.

MODNAME = "Dynamic Cvar Changer"
MODVERSION = "1.0"

numconn = 0
function et_InitGame(leveltime, randomseed, restart)
	et.RegisterModname(string.format("%s %s", MODNAME, MODVERSION))
end

function et_ClientUserinfoChanged(clientNum)
	local numconn = 0

	for i=0,et.trap_Cvar_Get("sv_maxclients") - 1 do
			if (tonumber(et.gentity_get(i, "sess.sessionTeam")) == 1) or (tonumber(et.gentity_get(i, "sess.sessionTeam")) == 2) then
			numconn = numconn + 1
		end
	end
	
	if (numconn < 16) then
		et.trap_Cvar_Set("g_TDMScore", "1500")
	elseif (numconn >= 16 and numconn <= 22) then
		et.trap_Cvar_Set("g_TDMScore", "2500")
	elseif (numconn > 22) then
		et.trap_Cvar_Set("g_TDMScore", "3500")
	end
end