#!/bin/bash

# ONLY THIS IS FOR EDIT
FS_GAME="etsw"
COM_ZONEMEGS="32"
COM_HUNKMEGS="96"

##################################################################################
# Do not edit the following lines
FS_HOMEPATH=$(pwd)
FS_BASEPATH=$FS_HOMEPATH
VM_GAME="2"
VM_CGAME="2"
VM_UI="2"
DEDICATED="2"
NET_PORT="27960"

function run {
	while true;
	do
		./etded.x86 +set fs_homepath $FS_HOMEPATH +set fs_basepath $FS_BASEPATH +set fs_game $FS_GAME +set com_zoneMegs $COM_ZONEMEGS +set com_hunkMegs $COM_HUNKMEGS +set vm_game $VM_GAME +set vm_cgame $VM_CGAME +set vm_ui $VM_UI +set dedicated $DEDICATED +set net_port $NET_PORT +exec server.cfg 1>&2 2>server.log
	done
}

function startupcall {
	SCREENINFO=`screen -v 2>/dev/null`
	if [ ! -z "$SCREENINFO" ]; then
		screen -dmS "Gameserver" $1 run
	else
		$1 run&
	fi
}

function startup  {
	RUNNING=`ps aux | grep "etded.x86" | grep -v grep | grep $1`
	if [ ! -z "$RUNNING" ]; then
		echo -en "[failed]\nGameserver is already running\n"
	else
		startupcall $2
		echo "ok"
	fi
}

function stop {
	PIDS=`ps aux | grep "$1" | grep "run" | grep -v grep | awk {'print \$2'}`
	while [ ! -z "$PIDS" ]; do
		kill -9 $PIDS
		PIDS=`ps aux | grep "$1" | grep "run" | grep -v grep | awk {'print \$2'}`
	done

	PIDS=`ps aux | grep "etded.x86" | grep -v grep | grep $FS_HOMEPATH | awk {'print \$2'}`
	while [ ! -z "$PIDS" ]; do
		kill -9 $PIDS
		PIDS=`ps aux | grep "etded.x86" | grep -v grep | grep $FS_HOMEPATH | awk {'print \$2'}`
	done

	echo "ok"
}

if [ -z "$1" ]; then
	echo -n "Gameserver is starting ... "
	startup $FS_HOMEPATH $0
else
	if [ "$1" == "stop" ]; then
		echo -n "Gameserver is stopping ... "
		stop $0
	else
		if [ "$1" == "run" ]; then
			run
		else
			echo "usage: $0 [stop]"
		fi
	fi
fi
