#! /bin/sh

#######################################################################
# CONFIG:

# General note: If you specify more then one parameter or config files: 
# 		use brackets. e.g. "-r -e" or "1.cfg 2.cfg"

# Choose your config file(s) (space seperated):
# Remember: The last can overwrite parameters of the prior configs. 
#           Useful for hoster to deactivate or fix parameters 
#	    Also see ADMIN_CONFIG for overwriting.
CONFIGS="etc/etadmin.cfg"

# This config is ALWAYS loaded after the CONFIGS have been loaded
# (even after a !loadconfig or map configs). 
ADMIN_CONFIG=""
#ADMIN_CONFIG="etc/admin.cfg"


# Further Options (space seperated):
# -e to deactivate the including of a "external" section in map specific configs
# -r to reset the external section on every new section block.
# -d to completly deactivate the use of external programs (
#    -> ignores the [external] section in the config.
#
# Note: for game hosters: 
# - To completly disable external commands, use -d and fix the tail binary in a second config.
# - To define a preset of external commands to use for the user, use 2 configs 
#   (one for the user and one for you) and define the [external] section in your config, 
#   as well as the tail binary. Then use -r -e, so the user can't reset, add or modify the commands.
OPTIONS=""

# CHANGE THIS to the location of the extracted mod:
BASEDIR=/var/games/enemy_territory/test/etadmin_mod

# Set this to a unique string for every instanz of etadmin_mod
# running on your server.
INSTANZ_NAME=base

#######################################################################
#        You don't need to change anything below this line            #
#######################################################################

cd $BASEDIR
PERL=`type -p perl`
PID=`ps axw|grep etadmin_mod.pl |grep "instanz_$INSTANZ_NAME" |grep -v grep | awk '{print $1}'`

case "$1" in
    start)
        echo -n "Starting etadmin_mod: "
        
        # Adding admin config to the options
        if (test -n "$ADMIN_CONFIG") then
        	OPTIONS="$OPTIONS --admin-config=$ADMIN_CONFIG"
        fi 
        
	if (test -z "$PID") then
		$PERL bin/etadmin_mod.pl $OPTIONS instanz_$INSTANZ_NAME $CONFIGS >>log/etadmin.log 2>&1 &
		sleep 1

		STATUS=`ps axw|grep "etadmin_mod.pl" | grep "instanz_$INSTANZ_NAME" |grep -v grep `

		if (test -n "$STATUS") then	
			echo "OK! [$STATUS]"
		else
			echo "FAILED! [$STATUS] (See logfile log/etadmin.log for details!)"
		fi
	else
		echo "FAILED! (etadmin_mod is already running)"
	fi
        ;;
    stop)
        echo -n "Stopping etadmin_mod: "
	if (test -n "$PID") then
	
		# First determine tail pid
		PID_TAIL=`ps axw|grep tail |grep etconsole.log |grep " $PID " |awk '{print $2}'`
	
		# killing etadmin_mod
		kill $PID
	
		# Killing tail:
		if (test -n "$PID_TAIL") then
			kill $PID_TAIL
		fi
		echo "OK!"
	else
		echo "FAILED! (etadmin_mod isn't running)"
	fi
        ;;
    reload)
        echo -n "Reloading etadmin_mod: "
	if (test -n "$PID") then
		kill -HUP $PID	
		echo "OK! ($PID)"
	else
		echo "FAILED! (etadmin_mod isn't running)"

	fi
	;;
    status)
	if (test -n "$PID") then
		echo "Status: running"
	else
		echo "Status: not running"
	fi
	;;
    restart)
        $0 stop
	# Need to sleep here, because etadmin_mod needs some seconds to shutdown
	sleep 2
        $0 start
        ;;
    *)
        echo "Usage: $0 {start|stop|restart|reload|status}"
        exit 1
esac

# Inform the caller not only verbosely and set an exit status.
exit 0
