#!/usr/bin/perl
#
#---------------------------------
#---    ET Admin Mod v0.29     ---
#---------------------------------
#(c) Mark Davis <gaming@d1p.de> 2004-2005
#    etadmin_mod.pl: ([d1p])H. Potter
#
# Some of the features:
#- (killing / death ) spree counter (now fully customisable)
#- multi-/monsterkill detection (new)
#- vote deactivation, restriction (canceling)
#- nickname / clantag protection
#- admin functions (e.g. like a enhanced shrubbot for etpro)
#- seen database
#- birthday announcments
#- gib protector
#- first blood message
#- (custom) greetings
#- name fake/stealing detection
#- class restrictions (amount and player dependent, e.g. min 8 players for panzer )
#- min GUID age restriction
#- teamkill restriction
#- /kill limit
#- uneven team detection and also reaction
#- enhanced security for hoster companies.
#- tcp interface to support remote access. (new)
#- automute on badwords (new)
#- intermission mapvoting (new)
#- simple stats(new)
#- sound_mappings, knife kill sounds, spree sounds, ... (new)
#- ban with etpro guid (new)
#- Support for: etmain, etpro, shrub/etpub and headshot_mod
#
#
# v0.29 by mark davis (05-12-2005)
#
# Changes (since 0.28) :
#	0.29	- changed version to 0.29 -> release			(05-12-2005)
#		- removed some more debug output (mark)			
#		- changed the color of the admin chat to green,
#		  wish of josh! (mark)
#		- fixed use_advanced_kick kick 0 bug.
#	0.29t31	- changed another location of the tcp-username(mark)	(04-12-2005)
#               - added positions for multi/monsterkill (mark)
#	0.29t30	- added tcp_chat_appearance (mark)			(03-12-2005)
#	0.29t29	- added saybuddy to automute, thx jump3r (mark)	
#		- added new default path to shrubbot.cfg 		
#		  now defaults to etc/shrubbot.cfg (mark)
#		- fixed ingame !listcmds cmd (josh)			(01-12-2005)
#	0.29t28	- fixed "say:" client tcp-output bug (mark)		(30-11-2005)
#		- added spree_sound / knife_kill_sound / sound_mappings
#		  dependency, if sound_mappings = 1, others have to be 0.
#		- removed display of "old" empty map/alltime sprees (mark)
#	0.29t27	- removed debugging output (mark)
#		- fixed tcp:/game: bug (mark)
#		- repositioned death spree message code (mark)		(29-11-2005)
#		- added weapon to the KILL-Messages (mark)
#	0.29t26 - added rcon:/clog: prefix for sound_mappings (mark)	(28-11-2005)
#		- added cancel_standardmap_votes (mark)
#		- changed "time: Xmin" to "time: X min" ;) (Pella)	(27-11-2005)
#		- fixed spree_reset not fully reseting records (mark)
#		- changed display of spree_record / new spree messages (mark)
#	0.29t25 - added sound_mappings to play sounds on special 	(26-11-2005)
#		  logfile lines or rcon commands (hammer)
#		- reset kills on teamkill / selfkill, thx skooli (mark)
#		- added !listcmds, handle with care. Only etpub / shrub
#		  are supported! (josh)
#		- removed the possibility to kick admins themselves
#		  to prevent missusage of other players and ids. (mark)
#		- added Higher Level Protection Option for
#		  Aliases / Substitutions (Josh)
#		- added another persistent_map_spree_record option (mark)
#		- added parsing of !admin commands in buddy chat (Josh) (14-11-2005)
#	0.29t24 - fixed handling of tk_except_admins (nappy/mark)	(12-11-2005)
#	0.29t23 - changed handling of spree / knife sounds to play them
#		  together instead of after another (mark)
#		- fixed selfkill spree reset, thx for hint skooli (mark)
#	0.29t22 - added etpro guid for automute / persistent_mute (mark)
#		- changed a lot of debugging log output for release (mark)
#		- changed order of spree / kill display (mark)
#		- added knife_kill_sound support (mark)
#		- added etpub playsound "-1" fix (mark)
#		- added right "etconsole_log" for looking at the direct
#		  etconsole.log output. (mark)
#		- fixed badword loading (stripping spaces) (mark)
#	0.29t21 - added chat "display-fix" for remote applications(mark)(08-11-2005)
#	0.29t20 - changed order of kill recognition to prevent a bug /  (06-11-2005)
#		  wrong display. Thx tintifax. (mark)
#		- fixed bug in loading badwords. Thx Tomas. (mark)	(04-11-2005)
#		- fixed bug in spree_record changes of t19 (tomas)
#		- changed color codes of ETM-* messages to ";^" (mark)  (21-10-2005)
#		  for clients to individually colorize those messages.
#	0.29t19 - fixed pmute save bug, thx for hint, harry (mark)	(12-10-2005)
#		- fixed too "many lowercase names" bug (mark)		(08-10-2005)
#		- added spree_minimum_players option (mark)
#		- added /playerstats command for simple_stats (mark)
#	0.29t18	- fixed pmute -> autounmute bug (mark)			(03-10-2005)
#		- fixed cancel mapvote bug (mark)
#		- enhanced persisent_mute (bit option)
#		- added tommes sub say linewrap code (tommes)		(18-09-2005)
#		- fixed say length check (mark)				(17-09-2005)
#	0.29t17 - added loading the intermission mapvoting maplist
#		  from a file (tommes/mark)
#		- enhanced /debug command for tcp-admin (mark)		(16-09-2005)
#		- catching SIGTERM/SIGQUIT now to clean up and
#		  for debugging (mark)
#  		  NOTE: This breaks the "etadmin_mod.sh restart", because
# 		        a clean shutdown takes longer, then a fast "kill".
#		- added !pmute command for "semi" permanent mute (mark)
#		- command_prefix is no regular expression anymore (mark)(15-09-2005)
# 		- fixed splitted tcp-messages (mark)			(02-09-2005)
#	0.29t16 - fixed "kick" bug (did not send error on missing	(01-09-2005)
#		  target) (mark)
#		- fixed the !stats online time bug (mark)
#		- tcp-connections now can't use simple_stats, even if
#		  they have the permission to do so. (mark)
#	0.29t15	- fixed players in /serverinfo (mark)			(31-08-2005)
#		- fixed ETM-CHAT (missing say) (mark)
#		- added "simple_stats" (!stats) (mark)
#		- !spree_reset now resets all sprees(map spree's also) (mark)
#		- multiple voting for the same map doesn't result in more
#		  then one answer message.
#		- added server_addr(&port) to /serverinfo (mark)
#	0.29t14 - ETM-KILL - Number behind the target, is now the amount(27-08-2005)
#		  of deaths without kill (mark).
#		- map sprees can now also be persistent 		(26-08-2005)
#		  (persistent_map_spree_record option) (mark)
#		- now filtering permissions, that have been configured	(25-08-2005)
#		  more then once. (mark)
#		- tcp_interface now defaults to 0 (mark)
#		- changed way of calling shuffles without restart
#		  in the uneven_team_escalation(mark)
#		- added all uberadmin commands to the /listcmds and
#		  now most tcp-commands are permission based (mark)
#	0.29t13 - added a basic startup syncronisation (mark)		(24-08-2005)
#		- added a /serverinfo command for tcp (mark)
#		- added disconnected by message on tcp-disconnect (mark)
#		- prefixed tcp-only commands with / in the command  	(23-08-2005)
#		  list (mark)
#		- added "persistent_mute" for muting across
#		  connection sessions, guid based (mark)
#	0.29t12 - added /disconnect <slot> (mark)			(19-08-2005)
#		- limited say messages to around 300 chars, depending   (18-08-2005)
#		  of the game state (mark)
#		- fixed small bug with intermission_mapvoting (mark)	(17-08-2005)
#	0.29t11 - fixed tcp_max_connections (mark)			(15-08-2005)
#		- added right: prefix in front of permissions in the
#		  /listcmds output (mark)
#		- added regexp check while loading for automute (mark)
#		- changed intermission_mapvoting a little (mark)
#		- added automute_override_lvl option (mark)		(14-08-2005)
#	0.29t10	- badword list exported into a seperated file		(13-08-2005)
#		  and added prefix "regexp:" for allowing regular
#		  expressions (mark)
#		- added freebsd tail options (mark)
#		- changed all occurences of tcp_socket_addr to
#		  tcp_bind_addr (mark)
#		- added tcp:/game: prefix for permission section (mark)
#		  without prefix allows commands to be executed on tcp-
#		  interface, as well as ingame, else are restricted to the
#		  prefixed session (game or tcp).
#	0.29t9	- added map_configs_options (default 0) and
#		  map_configs_order (default 0) (mark)
#		- fixed include bug, thx Oli for the hint (mark)	(11-08-2005)
#		- added /etm_chat and /etm_kills (mark)			(10-08-2005)
#		  this allows people to reduce the seen kills or chat.
#		  I also added private messages, team and buddy chat to the
#		  ETM-CHAT output.
#		  during this, i also made the following changes:
#		  - qsay/chat/say will be displayed as ETM-CHAT:GLOBAL (mark)
#		  - and optimized global tcp output function (mark)
#	0.29t8  - added (ext:|rcon:) prefix for rcon_cmds_* (mark)
#		- changed specall again (mark)				(09-08-2005)
#		  this won't be the last change, but it will work for now.
#	0.29t7	- changed etpro private message handling (mark)
#	0.29t6	- fixed putclan cmd (mark)				(08-08-2005)
#		- added specall cmd (mark)
#		- fixed /banlist parameters (mark)
#		- fixed welcome message (timeout was wrong) (mark)	(03-08-2005)
#	0.29t5	- added auto XP reset (hammer)				(03-08-2005)
#		- changed the output for ingame and tcp-output
#		  again (mark)
#	0.29t4	- fixed stupied error, which made the etadmin_mod	(02-08-2005)
#		  only send to every second socket (mark)
#		- set maxlength of messages to 512 chars and filtered
#		  some etpro rcon featback. (mark)
#	0.29t3	- fixed automute (mark)					(26-07-2005)
#		- fixed /who (you) (mark)
#	0.29t2	- added !spec999 for etpro / etmain (mark)		(24-07-2005)
#		- fixed the multi connection information loss bug (mark)
#		- fixed admin abuse prevention code (mark).
#		- fixed wrong output channel for hidden tcp-messages (mark)
#		- added /whoami command for tcp-users (mark)
#		- fixed <PART2NAME>, was a more a <PART2CNAME> (mark)	(20-07-2005)
#	0.29t1	- improved socket handling and added max. 		(11-07-2005)
#		  connections / ip (mark)
#		- reworked admin checks and added crypt function 	(10-07-2005)
#		  for storing the passwords crypted. (mark)
#		- added usermanagement (useradd, userdel, userlevel,
#		  userpassword, userlist) (mark)
#		- added /listcmds & /help for the tcp-interface (mark)	(28-06-2005)
#		- added <ARANDOM_COLOR_PLAYER> Tag for the alias 	(22-06-2005)
#		  section. Always picks a random user, even if
#		  multiple times used in one command. (mark)
#		- added <RANDOM_*> Tags for the alias section (mark)    (16-06-2005)
#		- added rcon password check to the cmd function(mark)	(08-06-2005)
#		- added special timed banner messages (JK/mark)
#		- added bad word temp mute feature for etpro (mark/arni)(30-05-2005)
#		- first release with TCP interface to the etadmin_mod 	(24-05-2005)
#		  for a real remote console (mark)
#		- intermission mapvoting feature (mark)			(30-04-2005)
#	0.28    - official release of the long tested 0.27p1		(22-05-2005)
#		- fix of "m" etpro warnings
#
# for the complete Changelog see:
# http://et.d1p.de/etadmin_mod/wiki/index.php/ETAdmin_mod_Changelog

########################################################
# YOU DON'T NEED TO CHANGE ANYTHING BELOW THIS LINE... #
########################################################

my $version = "0.29";

# default settings (override with config):
my %config                 = ();
my %postition              = ();
my %greetings              = ();
my %warnings               = ();
my %warnings_bn            = ();
my %spree                  = ();
my %spree_messages         = ();
my %class_restriction      = ();
my %alias                  = ();
my %help                   = ();
my %rule                   = ();    # mh, i should change one of the names
my %rules                  = ();
my %best_spree             = ();
my %tk_hash                = ();
my %warn_hash              = ();
my %userinfo               = ();
my %clans                  = ();
my %external               = ();
my %position               = ();
my @bad_names              = ();
my @bad_words              = ();
my @banners                = ();
my @admin_func             = ();
my @rcon_cmds_endround     = ();
my @rcon_cmds_startround   = ();
my @rcon_cmds_intermission = ();
my @rcon_cmds_exitlevel    = ();
my %gb_data                = ();
my %rcon_jobs              = ();
my %server_status          = ();
my %sound_mappings         = ();    # Hammer
my $jobcounter             = 0;

my $gamestart = 0;
my $timelimit;
my $tail_options;
my @maps = ();

for (qw (alltime currmap map ))
{
    $best_spree{$_}{'name'}      = "Nobody";
    $best_spree{$_}{'timestamp'} = time;
    $best_spree{$_}{'value'}     = 0;
}

my %rights = (
               "silentcommands" => 1,
               "etconsole_log"  => 1,
               "logincmd"       => 1
             );

use Getopt::Std;
use Getopt::Long;
use IO::Socket;
use IO::Handle;
use POSIX qw(:signal_h);
use POSIX qw(:termios_h);
use Socket;

# For shrubbot admin stuff:
my %admins     = ();
my %level      = ();
my %bans       = ();
my %etpro_bans = ();

my %ready           = ();
my %tmphash         = ();
my %admins_name     = ();
my %birthdays       = ();
my $last            = 0;
my $running         = 0;
my %protected       = ();
my %tmp_warn        = ();    # for protected names
my %tmp_warn2       = ();    # for bad words in names
my %vote_times      = ();
my $first_blood     = 1;
my $last_blood      = "";
my $cancel_time     = 0;
my $intermission    = 0;
my $lines           = 0;
my $spree_delay     = 0.3;
my $alarm           = 5;
my $disabled_voting = 1;
my $banner_position = 0;
my $banner_time     = 0;     # JF - added
my $uneven_teams    = 0;
my $highest_level   = 0;
my $mapname         = "";
my $time;
my $kick;
my $over_ip;
my $over_name;
my $over_guid;
my %last_notify;
my $last_init;

#use strict;

#use File::Tail;
# TEST:
#$SIG{CHLD} = sub { wait };

my $basedir = ".";
$config{'logfile'}        = "etconsole.log";
$config{'input_file'}     = "server.in";
$config{'shrubbot_cfg'}   = "etc/shrubbot.cfg";
$config{'protected_file'} = "etc/protected.cfg";

# crazy gravity:
my $crazy_gravity          = 0;
my $crazy_gravity_time     = 0;
my $crazy_gravity_notify   = 0;
my $crazy_gravity_min      = 10;
my $crazy_gravity_max      = 1200;
my $crazy_gravity_duration = 30;

my $curr_players = 0;

# Detect multi kills and killing sprees
$config{'spree_detector'} = 1;

# Protect names
$config{'name_protector'} = 1;

# Gib Protector
$config{'body_protector'} = 1;

# Admin functions
$config{'admin_functions'} = 0;
$config{'manage_bans'}     = 0;

# Activate Seen database:
$config{'seen_db'} = 1;

# Seen-DB File:
$config{'seen_db_file'} = "$basedir/block_seen.db";

# Path to the tail binary
$config{'tail'} = "/usr/bin/tail";

$config{'cancel_votes'}       = 1;
$config{'allow_vote_minutes'} = 5;

$config{'use_punkbuster'}                 = 1;
$config{'default_kick_duration'}          = 5;
$config{'use_advanced_kick'}              = 0;
$config{'detect_uneven_teams_difference'} = 3;

# 1 == X mins before end of map,
# 2 == after X% of map time,
# 3 == X minutes after mapstart
$config{'cancel_mode'}  = 2;
$config{'cancel_time'}  = 66;
$config{'spree_sounds'} = 0;    ## TESTING

# Amount of Kill for the different types of killing sprees
#$spree{'spree'}       = 5;
#$spree{'rampage'}     = 10;
#$spree{'dominating'}  = 15;
#$spree{'unstoppable'} = 20;
#$spree{'godlike'}     = 25;
#$spree{'wicked'}      = 30;

# Output position of the killing spree messages (cp or chat)
$position{'spree'}       = 'cp';
$position{'rampage'}     = 'cp';
$position{'dominating'}  = 'cp';
$position{'unstoppable'} = 'cp';
$position{'godlike'}     = 'cp';
$position{'wicked'}      = 'cp';

$position{'first_blood'} = 'cp';
$position{'last_blood'}  = 'qsay';

$position{'multikill'}    = 'qsay';
$position{'monsterkill'}  = 'cp';

# default position for all text output
$position{'default'} = 'chat';

$config{'use_advanced_warn'} = 0;

# Max amounts of warnings:
# If limit is reached, player gets kicked / banned
# 1 == immidiate kick on first warning
$config{'warn_limit'} = 4;

# When shall warnings decay (in days):
$config{'warn_timeout'} = 2;

# kick length in minutes.
# > 5 -> temp ban, else normal kick
$config{'warn_kicklength'} = 5;

$config{'name_stealing_detection'} = 1;
$config{'forceclass_balance'}      = 0;
$config{'etadmin_serverlist'}      = 1;
$config{'kick_badnames'}           = 0;

# bad names grace time
$config{'bad_name_grace_period'} = 30;

$config{'automute'}              = 0;
$config{'automute_override_lvl'} = 1;

# class restrictions:
$class_restriction{0} = -1;
$class_restriction{1} = -1;
$class_restriction{2} = -1;
$class_restriction{3} = -1;
$class_restriction{4} = -1;

# Debug:
$config{'debug'}   = 0;
$config{'dry_run'} = 0;

$config{'first_blood'} = 0;
$config{'last_blood'}  = 0;

$config{'spree_color'}    = "^8";
$config{'command_prefix'} = "!";
$config{'admin_greeting'} = 1;

$config{'minguidage'} = 0;

$config{'tcp_crypt_passwords'} = 1;

# Clans... deprecated, now in etadmin.cfg
#$clans{'^\[tB\]'} 		= "PL12dd";

###################
# New TCP options:
$config{'tcp_bind_addr'}      = "0.0.0.0";
$config{'tcp_socket_port'}    = $config{'server_port'};
$config{'tcp_interface'}      = 0;
$config{'tcp_admin_username'} = "admin";
$config{'tcp_admin_password'} = "CHANGETHIS";
$config{'tcp_max_conn_ip'}    = 3;
$config{'tcp_ident_timeout'}  = 15;
$config{'tcp_chat_appearance'}= "^3etadmin_mod(^7<TCP_USERNAME>^3)";

# 0 = load only one map config, 1 = load both configs after another.
$config{'map_configs_options'} = 0;
$config{'map_configs_order'}   = 0;

$config{'badwords_file'} = "etc/badwords.lst";

my %listcmds = ();
$listcmds{'bc'}          = 1;
$listcmds{'who'}         = 1;
$listcmds{'banlist'}     = 1;
$listcmds{'listplayers'} = 1;
$listcmds{'serverinfo'}  = 1;
$listcmds{'listcmds'}    = 1;
$listcmds{'disconnect'}  = 1;
$listcmds{'playerstats'} = 1;

# Weapon hashes:
my %mod_weapon = (
                   0  => "UNKNOWN",
                   1  => "MACHINEGUN",
                   2  => "BROWNING",
                   3  => "MG42",
                   6  => "KNIFE",
                   7  => "LUGER",
                   8  => "COLT",
                   9  => "MP40",
                   10 => "THOMPSON",
                   11 => "STEN",
                   12 => "GARAND",
                   14 => "SILENCER",
                   15 => "FG42",
                   17 => "PANZERFAUST",
                   16 => "SCOPED FG42",
                   18 => "GRENADE",
                   19 => "FLAMETHROWER",
                   23 => "MAPMORTAR_SPLASH",
                   24 => "KICKED",
                   26 => "DYNAMITE",
                   30 => "ARTILLERY",
                   27 => "AIRSTRIKE",
                   31 => "WATER",
                   34 => "CRASH",
                   36 => "FALLING",
                   37 => "SUICIDE",
                   39 => "TRIGGER_HURT",
                   41 => "CARBINE",
                   42 => "KAR98",
                   43 => "GPG40",
                   44 => "M7",
                   45 => "LANDMINE",
                   46 => "SATCHEL",
                   49 => "MOBILE MG42",
                   50 => "SILENCED COLT",
                   51 => "SCOPED GARAND",
                   52 => "CRUSH_CONSTRUCTION",
                   53 => "CRUSH_CONSTRUCTIONDEATH",
                   54 => "CRUSH_CONSTRUCTIONDEATH_NOATTACKER",
                   55 => "K43",
                   56 => "SCOPED K43",
                   57 => "MORTAR",
                   58 => "AKIMBO COLTS",
                   59 => "AKIMBO LUGER",
                   60 => "AKIMBO SILENCEDCOLT",
                   61 => "AKIMBO SILENCEDLUGER",
                   62 => "SMOKEGRENADE",
                   64 => "SWITCH TEAM",
                   67 => "GOOMBA"
                 );

my %CLASS = (
              0 => 'SOLDIER',
              1 => 'MEDIC',
              2 => 'ENGINEER',
              3 => 'FIELD_OPS',
              4 => 'COVERT_OPS',
            );

my %CLASS2 = (
               0 => 'S',
               1 => 'M',
               2 => 'E',
               3 => 'F',
               4 => 'C',
             );

my %CLASS_REV = reverse %CLASS;    # cade: to be able to use names, see 'rules' below

my %SIDE = (
             0 => 'UNKNOWN',
             1 => 'AXIS',
             2 => 'ALLIES',
             3 => 'SPECTATORS',
           );

my %SIDE2 = (
              0 => '-',
              1 => 'r',
              2 => 'b',
              3 => 's'
            );

my %SIDE3 = (
              '-' => 0,
              'r' => 1,
              'b' => 2,
              's' => 3
            );

my %SIDE4 = (
              'unknown' => 0,
              'axis'    => 1,
              'allies'  => 2,
              'remove'  => 3
            );

my %gib_weapon = (
                   17 => 1,    # PANZERFAUST
                   18 => 1,    # GRENADE LAUNCHER
                   19 => 1,    # FLAMETHROWER
                   25 => 1,    # GRENADE_LAUNCHER
                   26 => 1,    # DYNAMITE
                   27 => 1,    # AIRSTRIKE
                   30 => 1,    # ARTY
                   43 => 1,    # GPG40 (Grenade Launcher)
                   44 => 1,    # M7 (Grenade Launcher)
                   45 => 1,    # LANDMINE
                   46 => 1,    # SATCHEL
                   49 => 1,    # MOBILE_MG42
                   52 => 1,    # CONSTRUCTION
                   57 => 1     # MORTAR
                 );

# wepaons: mg 8, flamer 6, mortar 35, panzer 5, mg42 31
my %r_weap = (
               3  => "MP40",
               5  => "PANZERFAUST",
               6  => "FLAMETHROWER",
               8  => "THOMPSON",
               10 => "STEN",
               23 => "K43-RIFLE",
               24 => "GARAND-RIFLE",
               25 => "GARAND",
               31 => "MG42",
               32 => "K43",
               33 => "FG42",
               35 => "MORTAR"
             );

my %r_weap_rev = reverse %r_weap;    # cade: to be able to use names, see 'rules' below

my %rules = (
    player_minimum_heavyweapons => {
                                     'class'       => 0,
                                     'weapon'      => [ 5, 6, 31, 35 ],
                                     'description' => 'HEAVYWEAPON SOLDAT'
                                   },
    player_minimum_mortar => {
        'class'  => 0,
        'weapon' => [35],

        #                               'command_on' => "team_maxmortar 1",
        #                               'command_off' => "team_maxmortar 0"
                             },
    player_minimum_covert => {
                               'class'  => 4,
                               'weapon' => [-1],    # -1 == dont care / egal
                             },
    player_minimum_panzer => {
                               'class'       => 0,
                               'weapon'      => [5],
                               'description' => 'PANZERPUSSY',
                               'command_on'  => "exec panzer_on.cfg",
                               'command_off' => "exec panzer_off.cfg"
                             },
    player_minimum_rifleengi => {
                                  'class'       => 2,
                                  'weapon'      => [ 23, 24 ],
                                  'description' => 'RIFLE ENGINEER'
                                },
    player_minimum_sniper => {
                               'class'       => 4,
                               'weapon'      => [ 32, 33, 25 ],
                               'description' => 'SNIPER'
                             }
            );

# 0 = deactivate, >0 time in seconds between status messages.
$config{'rule_announce_time'} = 90;

####################################
# Admin Functions (Note: this part is deprecated.):

# Available rcon_commands:
# start_match, reset_match, swap_teams, shuffle_teams, makeReferee,
# removeReferee, ban, cancelvote, cp, kick

# to set:
# $admin_func[level] = ["command", "command2"]; (commands get inherited)

#$admin_func[0] = [ "seen", "time", "admintest",
#		   "beer", "pizza", "bye",
#		   "coke", "pfstinkt" ];
#$admin_func[2] = [ "pub", "comp",
#                   "pause", "unpause",
#                   "lock", "unlock",
#                   "kick", "clientkick",
#                   "mute", "unmute",
#                   "match_reset", "reset", "maprestart", "restart",
#                   "start_match", "start", "allready",
#                   "speclock", "specunlock",
#                   "mutespecs", "unmutespecs",
#                   "putaxis", "putallies", "putspec",
#                   "swap_teams", "swap",
#                   "makeShoutcaster", "removeShoutcaster"];
#$admin_func[3] = [ "ban", "cancelvote", "passvote",
#                   "shuffle_teams", "shuffle",
#                   "cp", "qsay", "chat", "godmode",
#                   "nextmap", "ref", "unref"];
#$admin_func[4] = [ "makeReferee", "removeReferee" ,
#                   "setlevel", ];
#
#
#$admin_func[0] = [ "seen" ];
#$admin_func[1] = [ "beer", "pizza" ]
#$admin_func[3] = [ "clientkick", "chat", "shuffle_teams", "cp", "cpm", "echo", "godmode" ];
#$admin_func[4] = [ "makeReferee", "removeReferee" , "ref", "unref" ];

##############################################################
# ------------------------------------------------------------
# ----------- Don't change anything below this line ----------
# --------------- unless you know what you do! ---------------
# ------------------------------------------------------------

&log("Starting up... etadmin_mod v$version");

# Security options:
my %sec_opts = ();
getopts( 'edr', \%sec_opts );    # options as above. Values in %opts

if ( $sec_opts{'d'} )
{
    &log("Disabling [external] section completly.");
}
elsif ( $sec_opts{'e'} )
{
    &log("Disabling [external] section in the map specific configs");
}
if ( $sec_opts{'r'} )
{
    &log("Always reseting [external] section, if defined more then once. ");
}

my $admin_config = "";
GetOptions( "admin_config=s" => \$admin_config );

#### LOADING CONFIGS ####

my @config_files = ();
while ( my $config_file = shift )
{
    if ( $config_file && -e "$config_file" )
    {
        push( @config_files, $config_file );
    }
    else
    {
        if ( !( $config_file =~ /^instanz_/ ) )
        {
            &log("ERROR: Couldn't find configfile $config_file");
            exit 1;
        }
    }
}

if ( $#config_files == -1 )
{
    &log("ERROR: Please specity at least one valid config file");
    exit 1;
}

my $counter = 0;
for my $config_file (@config_files)
{

    # Loading config file
    &load_config_file( $config_file, "fh00", $counter );
    &log("Loading: $config_file\n");
    $counter++;
}

# ADMIN CONFIG OVERRIDE
&load_config_file( $admin_config, "ac00", $counter ) if ( $admin_confi ne "" );
&post_config_checks();

my $system = $^O;

my $tail_binary = $config{'tail'} || "/usr/bin/tail";

if ( lc($system) eq "freebsd" )
{
    $tail_options = "-F -n 1";
}
else
{

    # linux
    $tail_options = "--follow=name --retry -n 1";
}

#### LOADER CONFIGS ####

$SIG{HUP}  = \&sig_hup;
$SIG{TERM} = \&sig_term;
$SIG{QUIT} = \&sig_term;

# Check for logfile,
if ( !-s $config{'logfile'} )
{
    &log("ERROR: Couldn't open logfile: $config{'logfile'}. Check your configuration.");
    if ($debug)
    {

        # See if it works, else go ahead and display a error.
        open( IN, $config{'logfile'} ) or die($!);
        close(IN);
    }
    else
    {
        exit 1;
    }
}

# Check for shrubbot.cfg
if ( !-e $config{'shrubbot_cfg'} )
{
    &log("ERROR: Couldn't find shrubbot.cfg $config{'shrubbot_cfg'}");
    exit 1;
}

if ( $config{'seen_db'} )
{
    require 'bin/seen.pl';
    &open_seen( $config{'seen_db_file'} );
}

my $output =
  &cmd(   "sets etadmin_mod \"ver=$version,spree=$config{'spree_detector'},mga=$config{'minguidage'},"
        . "list=$config{'etadmin_serverlist'}\"" );

if ( $output eq "Bad rconpassword." )
{
    &log( $output . " Check your server_addr / server_password." );
    exit(1);
}

# OK, then start the real stuff and try to sync for the first time:
my ( undef, $data ) = &cmd("serverinfo");

my %tmpdata = ();

for ( split( /\n/, $data ) )
{
    next if ( !$_ );
    $tmpdata{$1} = $2 if (/^([^\s]+)\s+(.*)$/);
}

&say( "^7et_admin_mod v" . $version . " ^8initialising... ", "cp" );

for (
    qw(sv_hostname gamename modversion g_gametype g_needpass sv_maxclients
    sv_privateClients mapname protocol version timelimit sv_punkbuster etadmin_mod)
  )
{
    $server_status{$_} = $tmpdata{$_} if ( defined( $tmpdata{$_} ) );
}

$mapname = $tmpdata{'mapname'} if ( $tmpdata{'mapname'} );
&load_map_spree() if ($mapname);

undef %tmpdata;

# Sync players:

my ( undef, $data ) = &cmd("status");

for ( split( /\n/, $data ) )
{

    #5     0   85 <3_alfik              0 81.190.191.70:27960    3222 25000

    if (/^\s*(\d+)\s+\d+\s+\d+\s(.*?)\s+\d+\s+(\d+\.\d+\.\d+\.\d+):\d+\s+\d+\s\d+$/)
    {
        my $slot = $1;
        my $name = $2;
        my $ip   = $3;
        $tmphash{$slot}{'name'}   = $name;
        $tmphash{$slot}{'ip'}     = $ip;
        $tmphash{$slot}{'guid'}   = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        $tmphash{$slot}{'class'}  = 0;
        $tmphash{$slot}{'team'}   = 3;
        $tmphash{$slot}{'joined'} = time;

        #&log("Found player: $slot -> $name -> $ip");
    }
}

#my $uneven_teams_map = 0;
# This is not the version of this mod. It's for detecting the server mod version, if necessary.
my $mod_version = "";

# load functions / vars for banning
my %bans = ();
require 'bin/shrub_management.pl' if ( $config{'manage_bans'} || $config{'admin_functions'} );

$| = 1;

&load_shrubbot_cfg if ( $config{'shrubbot_cfg'} );
&load_protected    if ( $config{'name_protector'} );
&load_birthdays();
&load_badwords();
@maps = &load_intermission_mapvoting_maps() if ( $config{'intermission_mapvoting'} );

&log("Started... (Passed all config / logfile checks).");

if ( $config{'persistent_spree_record'} )
{
    if ( -s "var/spree_record.dat" )
    {
        open( IN, "var/spree_record.dat" );
        my $counter = 0;

        while (<IN>)
        {
            chomp;
            if ( $counter == 0 )
            {
                $best_spree{'alltime'}{'name'} = $_;
            }
            elsif ( $counter == 1 )
            {
                $best_spree{'alltime'}{'value'} = $_;
            }
            elsif ( $counter == 2 )
            {
                $best_spree{'alltime'}{'timestamp'} = $_;
            }
            elsif ( $counter > 2 )
            {
                last;
            }
            $counter++;
        }
        close(IN);
        &log(   "Loaded old spree_record ($best_spree{'alltime'}{'name'}, "
              . "$best_spree{'alltime'}{'value'}, "
              . &time2date( $best_spree{'alltime'}{'timestamp'} )
              . ")..." );
    }
    else
    {
        &log("No previous spree record found.");
    }
}

###################
###### NEW ########

# BIND only at startup.
my $tcp_interface = $config{'tcp_interface'};
$config{'tcp_max_connections'} = $config{'tcp_max_connections'} > 0 ? $config{'tcp_max_connections'} : 10;

my %remote         = ();
my %security       = ();
my $default_filter = 1;    # Must be greater 0 !!!
my %remote_guids   = ();
my $con            = 0;
my @sockets        = ();
my $rin            = '';
my $rout           = '';
my $buffer         = '';
use constant BUFFSIZE => 2**16;

use constant ETM_INFO  => 1;
use constant ETM_WARN  => 2;
use constant ETM_CHAT  => 4;
use constant ETM_KICK  => 8;
use constant ETM_VOTE  => 16;
use constant ETM_ETPRO => 32;
use constant ETM_KILL  => 64;
use constant ETM_RCON  => 128;
use constant ETM_CLOG  => 256;

# Mute constants
use constant PERSISTENT_AMUTE => 1;
use constant PERSISTENT_PMUTE => 2;
use constant PERSISTENT_GMUTE => 4;

use constant ETM_COLORS_NONE => 0;
use constant ETM_COLORS_NAME => 1;
use constant ETM_COLORS_TEXT => 2;

#use constant ETM_COLORS_NONE   => 0;

if ($tcp_interface)
{

    my $port = $config{'tcp_bind_port'} ? $config{'tcp_bind_port'} : $config{'server_port'};

    if ( $port <= 0 || $port > 65535 )
    {
        &log("Assigned illegal value to tcp_socket_port: $config{'tcp_socket_port'}");
        exit;
    }

    socket( SOCK, AF_INET, SOCK_STREAM, getprotobyname('tcp') ) || die "socket: $!";
    setsockopt( SOCK, SOL_SOCKET, SO_REUSEADDR, 1 );

    my $this = "";
    if ( $config{'tcp_bind_addr'} eq "0.0.0.0" )
    {
        $this = sockaddr_in( $port, INADDR_ANY );
    }
    else
    {
        $this = sockaddr_in( $port, inet_aton( $config{'tcp_bind_addr'} ) );
    }

    my $count = 0;

    while ( $count <= 5 )
    {

        eval {
            bind( SOCK, $this ) || die "bind : $!";
            listen( SOCK, SOMAXCONN ) || die "listen: $!";
        };

        if ($@)
        {
            &log("Error: $! (retry in 5 seconds)");
            sleep 5;
            $count++;
            if ( $count >= 5 )
            {
                &log("Giving up.");
                exit(0);
            }

        }
        else
        {
            &log("Bind success.") if ( $count > 0 );
            $count = 16;
        }
    }
    &log( "Listing on " . $config{'tcp_bind_addr'} . ":" . $port );

    # Unbuffer socket
    select(SOCK);
    $| = 1;
    select(STDOUT);

    &load_security();

}

##########################################################################################################

&say(
      "^7et_admin_mod v" . $version
        . " ^8started... "
        . "^8If ^8you ^8encounter problems, contact ^2H.^3Potter ^7(www.gamesunited.de)",
      "cp"
    );

# my $ref; (unused, see 1==1)
if ( 1 == 1 )
{
    open( FH, "$tail_binary $tail_options $config{'logfile'} |" );
}
else
{

    # unused. Never worked very well
    #$ref = tie *FH, "File::Tail", ( name => $logfile, interval => 1, maxinterval => 300, adjustafter => 7 );
}
$rin = &fhbits();

# loop ...
for ( ; ; )
{

    eval {

        for ( ; ; )
        {

            $sigset     = POSIX::SigSet->new(SIGHUP);
            $old_sigset = POSIX::SigSet->new;

            die("Couldn't install new sigset") unless ( defined sigprocmask( SIG_BLOCK, $sigset, $old_sigset ) );

            # did something change?
            select( $rout = $rin, undef, undef, $alarm );

            die("Couldn't uninstall sigset!") unless ( defined sigprocmask( SIG_UNBLOCK, $old_sigset ) );

            # External Connection
            if ( vec( $rout, fileno(SOCK), 1 ) == 1 )
            {

                # Make a new file handle (yuck).  "." concats strings.
                $con++;
                &log("Connections: $con") if ( $config{'debug'} > 1 );

                my $sock_id = 0;

                #my $sock_id = $#sockets + 1;

                while ( $sockets[$sock_id] ne "" )
                {
                    $sock_id++;
                }
                $sockets[$sock_id] = "NS" . $sock_id;

                ( $addr = accept( $sockets[$sock_id], SOCK ) ) || die $!;

                select( $sockets[$sock_id] );
                $| = 1;
                select(STDOUT);

                ( $port, $iaddr ) = unpack_sockaddr_in($addr);
                $actual_ip = inet_ntoa($iaddr);

                delete $remote{$sock_id};
                $remote{$sock_id}{'status'}    = 0;
                $remote{$sock_id}{'ip'}        = $actual_ip;
                $remote{$sock_id}{'timestamp'} = time;
                $rin                           = &fhbits();

                # Count current connections.
                my $connections = 0;
                my $overall_con = 0;
                foreach my $sock ( keys %remote )
                {
                    $overall_con++;
                    $connections++ if ( $remote{$sock}{'ip'} eq $actual_ip );
                }

                # If client already has max connections open -> disconnect immidiatly.
                if ( $connections > $config{'tcp_max_conn_ip'} )
                {
                    &remote_send( "No more connections allowed from your ip ($actual_ip).", $sock_id, "" );
                    &log(
                        "Connection refused: $sock_id ($actual_ip). Max allowed connections for ip $actual_ip exceeded."
                    );
                    &remote_disconnect($sock_id);
                }
                elsif ( $overall_con > $config{'tcp_max_connections'} )
                {
                    &remote_send( "No more connections allowed.", $sock_id, "" );
                    &log("Connection refused: $sock_id ($actual_ip). Max allowed global tcp connections exceeded.");
                    &remote_disconnect($sock_id);
                }
                else
                {
                    &remote_send(
                               "Welcome $actual_ip. You have " . $config{'tcp_ident_timeout'} . " seconds to identify.",
                               $sock_id, "" );
                    &log("Connection established: $sock_id ($actual_ip), Current connections: $con");
                }

            }
            elsif ( vec( $rout, fileno(FH), 1 ) == 1 )
            {

                # Logfile changed.
                my $read = sysread( FH, $buffer, BUFFSIZE - length $buffer, length $buffer );
                my @lines = split /\n/, $buffer;

                if ( !$buffer )
                {
                    &log("tail seems to have gone away... Reopening tail.");
                    close(FH);
                    open( FH, "$tail_binary $tail_options $config{'logfile'} |" );
                    $rin = &fhbits();
                }

                for my $line (@lines)
                {

                    # workaround:
                    delete $tmphash{1022} if ( defined( $tmphash{1022} ) );

                    &log("Processing: $line") if ( $config{'debug'} > 3 );

                    &global_remote_send( $line, "ETM-CLOG" ) if ( $con > 0 );
                    &process_line($line);
                    &sound_mapping($line, "clog") if ( $config{'sound_mappings'} );    # Hammer

                }    # end for

            }    #end if FH
            else
            {

                # CHECK SOCKETS:
                my $found = 0;
                my $data  = "";

                for ( my $sockcount = 0 ; $sockcount <= $#sockets ; $sockcount++ )
                {

                    # skip unused sockets
                    next if ( !defined( $sockets[$sockcount] ) or $sockets[$sockcount] eq "" );

                    my $thesocket = $sockets[$sockcount];
                    if ( vec( $rout, fileno($thesocket), 1 ) )
                    {

                        $found = 1;
                        sysread( $thesocket, $data, BUFFSIZE );

                        if ( !length($data) )
                        {

                            # 0 length message means "goodbye"
                            &log("Bye to client on socket $thesocket.") if ( $config{'debug'} );
                            &remote_disconnect($sockcount);
                            last;

                        }
                        else
                        {

                            # Only allow certain characters (for security)
                            #$data =~ s/[^\/\w\s'\."\[\]\(\)\+\?\^\$\\\|\*:;,\*\#&%=!\<\>-]//g;
                            $data =~ s/(.)/&ord_check($1)/egi;

                            $remote{$sockcount}{'buffer'} .= $data;
                            $data = "";

                            if ( length( $remote{$sockcount}{'buffer'} ) > BUFFSIZE )
                            {
                                &log( "Buffer overflow. Dropping buffer for socket " . ($sockcount) );
                                $remote{$sockcount}{'buffer'} = "";
                            }

                            # is the buffer filled with enough informations?
                            while ( $remote{$sockcount}{'buffer'} =~ s/^(.*?)\r?\n// )
                            {

                                $data = $1;
                                next unless ($data);
                                my $query_id = &process_remote_line( $data, $sockcount, $thesocket );
                                &remote_send( $query_id . "-END", $sockcount, "" ) if ($query_id);

                            }

                            last;
                        }
                    }
                }

                if ( !$found )
                {
                    &log("Timeout ($alarm) waiting for input (log)...") if ( $config{'debug'} > 1 );
                    &timebased_functions();
                }
            }
            $buffer = '';

        }    # end for

    };

    my $error = $@;
    chomp $error;

    if ( $error && ( $error ne "alarm" && $error ne "QUIT" ) )    # propagate errors
    {

        # some other error occured
        close(FH);
        &log("ERROR: $error");

        #die($error);
    }
    if ( $error eq "QUIT" )
    {

        # got sigterm
        #print FH->stat.":".FH->error."\n";
        FH->clearerr();
        close(FH);

        &die( &time2date(time) . " Normal shutdown..." );
    }

    if ( $error eq "alarm" )
    {

        # timed out
        &log("Timeout ($alarm) waiting for log...") if ( $config{'debug'} );
        &timebased_functions();
    }
    else
    {

        # problem with tail ? Then reopen.
        &log("tail seems to have gone away... Reopening tail.");
        close(FH);
        open( FH, "$tail_binary $tail_options $config{'logfile'} |" );
    }

    # "Ende" der Datei loeschen
    FH->clearerr();

}    # end for (;;)

# Process incoming tcp command.
sub process_remote_line
{

    my $data      = shift;
    my $sockcount = shift;
    my $thesocket = shift;
    my $query_id  = "";

    return unless ($data);    # twice is better then once =)

    &log( "Received from client " . ($sockcount) . ": " . $data ) if ( $config{'debug'} );

    if ( $data =~ /^\s*\/quit$/ )
    {
        print $thesocket "Bye, bye\r\n";
        &remote_disconnect($sockcount);
        return;

    }
    elsif ( $data =~ /^\s*\/identify (\w+)\s+(.*)$/ )
    {
        my $username = $1;
        my $password = &crypt($2);
        $remote{$sockcount}{'timestamp'} = time;

        if ( defined( $security{$username} ) && $security{$username}{'password'} eq $password )
        {
            $remote{$sockcount}{'status'}   = 1;
            $remote{$sockcount}{'level'}    = $security{$username}{'level'};
            $remote{$sockcount}{'username'} = $username;
            my $id = sprintf( "REMOTE_%d_%d", ($sockcount), int( rand(9999) ) );

            &log("TCP-Connection: $username logged in. (Slot: $sockcount)");
            &log( "Generated ID: $id for slot: " . ($sockcount) )
              if ( $config{'debug'} );
            $remote_guids{$id} = $sockcount;
            $remote{$sockcount}{'guid'} = $id;

            print $thesocket "You have authorized yourself as $username\r\n";
            &global_remote_send( "User $username logged in.", "ETM-INFO" );

            $remote{$sockcount}{'filter'}     = $default_filter;
            $remote{$sockcount}{'etm'}        = 191;
            $remote{$sockcount}{'etm_chat'}   = 7;
            $remote{$sockcount}{'etm_kills'}  = 7;
            $remote{$sockcount}{'etm_colors'} = 3;
            return;

        }
        else
        {
            print $thesocket "Permission denied (Your IP has been logged)\r\n";
            return;
        }
    }

    if ( $sockets[$sockcount] ne "" )
    {
        if ( $remote{$sockcount}{'status'} == 1 )
        {

            # Strip of spaces. I don't like spaces ^^.
            $data =~ s/^\s+//;

            #&log("Processing remote call: $data");
            if ( $data =~ s/^ETM-([^:]+):// )
            {
                $query_id = "ETM-ANSWER-$1";
            }

            my @cmds = split( /\s+/, $data );

            $cmds[0] = lc( $cmds[0] );

            # First, do only the internal remote connection commands.
            if ( $cmds[0] eq "/who" )
            {
                foreach my $rem ( sort keys %remote )
                {
                    if ( $remote{$rem}{'status'} == 1 && defined( $sockets[$rem] ) )
                    {
                        &remote_send(
                                      "Slot $rem: $remote{$rem}{'username'} ($remote{$rem}{'level'})"
                                        . (
                                            $config{'tcp_admin_username'} eq $remote{$sockcount}{'username'}
                                            ? " - $remote{$rem}{'guid'} - IP: $remote{$rem}{'ip'}"
                                            : ""
                                          )
                                        . ( $rem == $sockcount ? " (you)" : "" ),
                                      $sockcount,
                                      $query_id
                                    );
                    }
                    elsif ( $sockets[$rem] ne "" )
                    {
                        &remote_send( "Slot $rem: Awaiting authorisation", $sockcount, $query_id );
                    }

                    #else
                    #{
                    #    &remote_send( "Slot $rem: Old entry. Should be deleted.", $sockcount, $query_id );
                    #}

                }
            }
            elsif ( $cmds[0] eq "/whoami" )
            {
                &remote_send(
                              "whoami: "
                                . $remote{$sockcount}{'username'}
                                . " (Slot: $sockcount, Level: "
                                . $remote{$sockcount}{'level'} . ") ",
                              $sockcount,
                              $query_id
                            );
            }
            elsif ( $cmds[0] eq "/bc" )
            {

                if ( !&admin_check( $remote{$sockcount}{'guid'}, "bc", "tcp" ) )
                {
                    &remote_send( "You don't have permission to use /bc.", $sockcount, $query_id );
                    return $query_id;
                }

                if ( $data =~ /^\/bc\s+(.*)/i )
                {
                    &log( "Sending broadcast for slot " . ($sockcount) . ": $1" );
                    my $message = $1;
                    my $user    = $remote{$sockcount}{'username'};
                    &global_remote_send( "$user(bc): $message", "ETM-BC" );
                }
                else
                {
                    &remote_send( "Usage: /bc <msg>", $sockcount, $query_id );
                }
                return $query_id;
            }
            elsif ( $cmds[0] eq "/filter" )
            {
                if ( $data =~ /^\/filter\s+(\d+)/i )
                {
                    if ( $1 == 0 && !( &admin_check( $remote{$sockcount}{'guid'}, "etconsole_log", "tcp" ) ) )
                    {
                        &remote_send(
                                      "You don't have permission to see the etconsole.log output. "
                                        . "Current filter-value: $remote{$sockcount}{'filter'}",
                                      $sockcount,
                                      $query_id
                                    );
                    }
                    else
                    {
                        $remote{$sockcount}{'filter'} = $1;
                        &remote_send( "Set filter to $1.", $sockcount, $query_id );
                    }

                }
                else
                {
                    &remote_send( "Current filter-value: " . $remote{$sockcount}{'filter'}, $sockcount, $query_id );
                }
                return $query_id;
            }
            elsif ( $cmds[0] eq "/etm_chat" )
            {
                if ( $data =~ /^\/etm_chat\s+(\d+)/i )
                {
                    $remote{$sockcount}{'etm_chat'} = $1;
                    &remote_send( "Set etm_chat to $1.", $sockcount, $query_id );
                }
                else
                {
                    &remote_send( "Current etm_chat-value: " . $remote{$sockcount}{'etm_chat'}, $sockcount, $query_id );
                }
                return $query_id;
            }
            elsif ( $cmds[0] eq "/etm_kills" )
            {
                if ( $data =~ /^\/etm_kills\s+(\d+)/i )
                {
                    $remote{$sockcount}{'etm_kills'} = $1;
                    &remote_send( "Set etm_kills to $1.", $sockcount, $query_id );
                }
                else
                {
                    &remote_send( "Current etm_kills-value: " . $remote{$sockcount}{'etm_kills'},
                                  $sockcount, $query_id );
                }
                return $query_id;
            }
            elsif ( $cmds[0] eq "/useradd" )
            {
                my $username = lc( $cmds[1] );
                my $lvl      = $cmds[2];
                my $password = $cmds[3];

                if ( $config{'tcp_admin_username'} ne $remote{$sockcount}{'username'} )
                {
                    &remote_send( "Insufficient rights.", $sockcount, $query_id );
                }
                elsif ( !$username || !$lvl || !$password )
                {
                    &remote_send( "Usage: /useradd <username> <level> <password>", $sockcount, $query_id );
                }
                elsif ( !defined( $level{$lvl} ) )
                {
                    &remote_send( "useradd: Invalid level specified.", $sockcount, $query_id );
                }
                elsif ( !defined( $security{$username} ) )
                {

                    my $return = &etm_useradd( $username, $lvl, $password );
                    if ( !$return )
                    {
                        &remote_send( "useradd succeeded ($username/$lvl).", $sockcount, $query_id );
                    }
                    else
                    {
                        &remote_send( "useradd failed.", $sockcount, $query_id );
                    }

                }
                else
                {
                    &remote_send( "useradd failed (user already exists).", $sockcount, $query_id );
                }

            }
            elsif ( $cmds[0] eq "/userdel" )
            {
                my $username = lc( $cmds[1] );

                if ( $config{'tcp_admin_username'} ne $remote{$sockcount}{'username'} )
                {
                    &remote_send( "Insufficient rights.", $sockcount, $query_id );
                }
                elsif ( !$username )
                {
                    &remote_send( "Usage: /userdel <username>", $sockcount, $query_id );
                }
                elsif ( $username eq $config{'tcp_admin_username'} )
                {
                    &remote_send( "userdel: You can't delete this user.", $sockcount, $query_id );
                }
                elsif ( defined( $security{$username} ) )
                {

                    # ok, user exists.
                    my $return = &etm_userdel( $username, $level, $password );

                    if ( !$return )
                    {
                        &remote_send( "userdel succeeded.", $sockcount, $query_id );
                    }
                    else
                    {
                        &remote_send( "userdel failed.", $sockcount, $query_id );
                    }

                }
                else
                {
                    &remote_send( "userdel failed (No such user).", $sockcount, $query_id );
                }

            }
            elsif ( $cmds[0] eq "/userlist" )
            {
                if ( $config{'tcp_admin_username'} ne $remote{$sockcount}{'username'} )
                {
                    &remote_send( "Insufficient rights.", $sockcount, $query_id );
                }
                else
                {
                    &remote_send( sprintf( "%-16s %s", "Username", "Level" ), $sockcount, $query_id );
                    foreach my $username ( sort keys %security )
                    {
                        &remote_send( sprintf( "%-16s %2d", $username, $security{$username}{'level'} ),
                                      $sockcount, $query_id );
                    }
                }
            }
            elsif ( $cmds[0] eq "/userpassword" )
            {
                my $username = lc( $cmds[1] );
                my $password = $cmds[2];

                if ( $config{'tcp_admin_username'} ne $remote{$sockcount}{'username'} )
                {
                    &remote_send( "Insufficient rights.", $sockcount, $query_id );
                }
                elsif ( !$username || !$password )
                {
                    &remote_send( "Usage: /userpassword <username> <password>", $sockcount, $query_id );
                }
                elsif ( $username eq $config{'tcp_admin_username'} )
                {
                    &remote_send( "userpassword: You can't change the password of this user.", $sockcount, $query_id );
                }
                elsif ( defined( $security{$username} ) )
                {

                    # ok, user exists.
                    my $return = &etm_userpwd( $username, $password );

                    if ( !$return )
                    {
                        &remote_send( "userpassword succeeded.", $sockcount, $query_id );
                    }
                    else
                    {
                        &remote_send( "userpassword failed.", $sockcount, $query_id );
                    }

                }
                else
                {
                    &remote_send( "userpassword failed (No such user).", $sockcount, $query_id );
                }

            }
            elsif ( $cmds[0] eq "/debug" )
            {

                if ( $config{'tcp_admin_username'} ne $remote{$sockcount}{'username'} )
                {
                    &remote_send( "Insufficient rights.", $sockcount, $query_id );
                }
                else
                {
                    if ( !$cmds[1] || $cmds[1] eq "misc" )
                    {
                        &remote_send( "Connections: $con", $sockcount, $query_id );
                    }

                    if ( !$cmds[1] || $cmds[1] eq "config" )
                    {
                        &remote_send( "Running Config:", $sockcount, $query_id ) if ( !$cmds[1] );
                        foreach my $key ( sort keys %config )
                        {
                            &remote_send( "$key = $config{$key}", $sockcount, $query_id );
                        }
                        &remote_send( "", $sockcount, $query_id ) if ( !$cmds[1] );
                    }
                    if ( !$cmds[1] || $cmds[1] eq "clans" )
                    {
                        &remote_send( "Clantag protections:", $sockcount, $query_id ) if ( !$cmds[1] );
                        foreach my $key ( keys %clans )
                        {
                            &remote_send( "$key = $clans{$key}", $sockcount, $query_id );
                        }
                        &remote_send( "", $sockcount, $query_id ) if ( !$cmds[1] );
                    }
                    if ( !$cmds[1] || $cmds[1] eq "banners" )
                    {

                        &remote_send( "Banners:", $sockcount, $query_id ) if ( !$cmds[1] );
                        for (@banners)
                        {
                            &remote_send( $_, $sockcount, $query_id );
                        }
                        &remote_send( "", $sockcount, $query_id ) if ( !$cmds[1] );
                    }
                    if ( !$cmds[1] || $cmds[1] eq "external" )
                    {

                        &remote_send( "External programs:", $sockcount, $query_id ) if ( !$cmds[1] );
                        foreach my $key ( keys %external )
                        {
                            &remote_send( "$key = $external{$key}", $sockcount, $query_id );
                        }
                        &remote_send( "", $sockcount, $query_id ) if ( !$cmds[1] );
                    }
                    if ( !$cmds[1] || $cmds[1] eq "positions" )
                    {

                        &remote_send( "Positions:", $sockcount, $query_id ) if ( !$cmds[1] );
                        foreach my $key ( keys %position )
                        {
                            &remote_send( "$key = $position{$key}", $sockcount, $query_id );
                        }
                        &remote_send( "", $sockcount, $query_id ) if ( !$cmds[1] );
                    }
                    if ( !$cmds[1] || $cmds[1] eq "alias" )
                    {

                        &remote_send( "Aliases:", $sockcount, $query_id ) if ( !$cmds[1] );
                        foreach my $key ( keys %alias )
                        {
                            &remote_send( "$key = $alias{$key}", $sockcount, $query_id );
                        }
                        &remote_send( "", $sockcount, $query_id ) if ( !$cmds[1] );
                    }
                    if ( !$cmds[1] || $cmds[1] eq "greetings" )
                    {

                        &remote_send( "Greetings:", $sockcount, $query_id ) if ( !$cmds[1] );
                        foreach my $key ( sort keys %greetings )
                        {
                            &remote_send( "$key = $greetings{$key}", $sockcount, $query_id );
                        }
                        &remote_send( "", $sockcount, $query_id ) if ( !$cmds[1] );
                    }
                    if ( !$cmds[1] || $cmds[1] eq "help" )
                    {

                        &remote_send( "Help:", $sockcount, $query_id ) if ( !$cmds[1] );
                        foreach my $key ( sort keys %help )
                        {
                            &remote_send( "$key = $help{$key}", $sockcount, $query_id );
                        }
                        &remote_send( "", $sockcount, $query_id ) if ( !$cmds[1] );
                    }
                    if ( !$cmds[1] || $cmds[1] eq "rules" )
                    {

                        &remote_send( "Rules:", $sockcount, $query_id ) if ( !$cmds[1] );
                        foreach my $key ( sort keys %rule )
                        {
                            &remote_send( "$key = $rule{$key}", $sockcount, $query_id );
                        }
                        &remote_send( "", $sockcount, $query_id ) if ( !$cmds[1] );
                    }
                    if ( !$cmds[1] || $cmds[1] eq "class_restrictions" )
                    {

                        &remote_send( "Class restrictions:", $sockcount, $query_id ) if ( !$cmds[1] );
                        foreach my $key ( sort keys %class_restriction )
                        {
                            &remote_send( "$key = $class_restriction{$key}", $sockcount, $query_id );
                        }
                        &remote_send( "", $sockcount, $query_id ) if ( !$cmds[1] );
                    }
                    if ( !$cmds[1] || $cmds[1] eq "spree_messages" )
                    {

                        &remote_send( "Spree messages:", $sockcount, $query_id ) if ( !$cmds[1] );
                        foreach my $key ( keys %spree_messages )
                        {
                            &remote_send( "$key = $spree_messages{$key}", $sockcount, $query_id );
                        }
                        &remote_send( "", $sockcount, $query_id ) if ( !$cmds[1] );
                    }
                    if ( !$cmds[1] || $cmds[1] eq "spree" )
                    {

                        &remote_send( "Spree:", $sockcount, $query_id ) if ( !$cmds[1] );
                        foreach my $key ( keys %spree )
                        {
                            &remote_send( "$key = $spree{$key}", $sockcount, $query_id );
                        }
                        &remote_send( "", $sockcount, $query_id ) if ( !$cmds[1] );
                    }
                    if ( !$cmds[1] || $cmds[1] eq "maplist" )
                    {

                        &remote_send( "Votable Maps in Intermission:", $sockcount, $query_id ) if ( !$cmds[1] );
                        foreach (@maps)
                        {
                            &remote_send( $_, $sockcount, $query_id );
                        }
                        &remote_send( "", $sockcount, $query_id ) if ( !$cmds[1] );
                    }
                    if ( !$cmds[1] || $cmds[1] eq "sound_mappings" )
                    {

                        &remote_send( "Sound mappings:", $sockcount, $query_id ) if ( !$cmds[1] );
                        foreach my $key ( keys %sound_mappings)
                        {
                            &remote_send( "$key = $sound_mapping{$key}", $sockcount, $query_id );
                        }
                        &remote_send( "", $sockcount, $query_id ) if ( !$cmds[1] );
                        
                    }
                   
                    if ( !$cmds[1] || $cmds[1] eq "rcon_cmds" )
                    {

                        &remote_send( "Rcon cmds startround:", $sockcount, $query_id );
                        for (@rcon_cmds_startround)
                        {
                            &remote_send( $_, $sockcount, $query_id );
                        }
                        &remote_send( "", $sockcount, $query_id );

                        &remote_send( "Rcon cmds endround:", $sockcount, $query_id );
                        for (@rcon_cmds_endround)
                        {
                            &remote_send( $_, $sockcount, $query_id );
                        }
                        &remote_send( "", $sockcount, $query_id );

                        &remote_send( "Rcon cmds intermission:", $sockcount, $query_id );
                        for (@rcon_cmds_intermission)
                        {
                            &remote_send( $_, $sockcount, $query_id );
                        }
                        &remote_send( "", $sockcount, $query_id );

                        &remote_send( "Rcon cmds exitlevel:", $sockcount, $query_id );
                        for (@rcon_cmds_exitlevel)
                        {
                            &remote_send( $_, $sockcount, $query_id );
                        }
                    }

                    #&remote_send("", $sockcount, $query_id);
                }
            }
            elsif ( $cmds[0] eq "/serverinfo" )
            {

                if ( !&admin_check( $remote{$sockcount}{'guid'}, "serverinfo", "tcp" ) )
                {
                    &remote_send( "You don't have permission to use /serverinfo.", $sockcount, $query_id );
                    return $query_id;
                }
                &remote_send( "Serverinfo:", $sockcount, $query_id );
                &remote_send( "-----------", $sockcount, $query_id );

                foreach my $key ( keys %server_status )
                {
                    &remote_send( $key . "\t" . $server_status{$key}, $sockcount, $query_id );
                }

                my @tmp     = keys %tmphash;
                my $counter = 0;

                if ( $#tmp > -1 )
                {

                    # Build my own "P".
                    my $st = "";

                    for ( 0 .. ( $server_status{'sv_maxclients'} - 1 ) )
                    {

                        if ( defined( $tmphash{$_} ) && defined( $tmphash{$_}{'guid'} ) )
                        {
                            $st .= $tmphash{$_}{'team'};
                            $counter++;
                        }
                        else
                        {
                            $st .= "-";
                        }
                    }

                    # Strip of - at the end. This is what etpro does.
                    $st =~ s/\-+$//;
                    &remote_send( "P\t$st", $sockcount, $query_id ) if ($st);

                }
                &remote_send( "players\t" . ($counter), $sockcount, $query_id );
                &remote_send( "server_addr\t$config{'server_addr'}:$config{'server_port'}", $sockcount, $query_id );

            }
            elsif ( $cmds[0] eq "/userlevel" )
            {

                my $username = lc( $cmds[1] );
                my $lvl      = $cmds[2];

                if ( $config{'tcp_admin_username'} ne $remote{$sockcount}{'username'} )
                {
                    &remote_send( "Insufficient rights.", $sockcount, $query_id );
                }
                elsif ( !$username || !$lvl )
                {
                    &remote_send( "Usage: /userlevel <username> <level>", $sockcount, $query_id );
                }
                elsif ( !defined( $level{$lvl} ) )
                {
                    &remote_send( "useradd: Invalid level specified.", $sockcount, $query_id );
                }
                elsif ( defined( $security{$username} ) )
                {

                    # ok, user exists.
                    my $return = &etm_userlevel( $username, $lvl );

                    if ( !$return )
                    {
                        &remote_send( "userlevel succeeded.", $sockcount, $query_id );
                    }
                    else
                    {
                        &remote_send( "userlevel failed.", $sockcount, $query_id );
                    }

                }
                else
                {
                    &remote_send( "userlevel failed (No such user).", $sockcount, $query_id );
                }

            }
            elsif ( $cmds[0] eq "/disconnect" )
            {

                if ( !&admin_check( $remote{$sockcount}{'guid'}, "disconnect", "tcp" ) )
                {
                    &remote_send( "You don't have permission to use /disconnect.", $sockcount, $query_id );
                    return $query_id;
                }

                my $slot = -1;
                if ( defined( $cmds[1] ) )
                {
                    $slot = $& if ( $cmds[1] =~ /^\d+$/ );
                }

                if ( $slot == -1 )
                {
                    &remote_send( "Usage: /disconnect <slot_id>", $sockcount, $query_id );
                    return $query_id;
                }
                else
                {

                    if ( defined( $remote{$slot}{'status'} )
                         && $remote{$slot}{'status'} == 1 )
                    {
                        &remote_send( "disconnect: You have been disconnected by $remote{$sockcount}{'username'}.",
                                      $slot, $query_id );
                        &log(
"Disconnected slot $slot ($remote{$slot}{'username'} (requested by: $remote{$sockcount}{'name'})." );
                        &remote_disconnect($slot);
                        &remote_send( "disconnect: Connection on slot $slot closed.", $sockcount, $query_id );
                    }
                    else
                    {
                        &remote_send( "disconnect: No connection on slot $slot.", $sockcount, $query_id );
                    }
                }

            }
            elsif ( $cmds[0] eq "/banlist" )
            {

                if ( !&admin_check( $remote{$sockcount}{'guid'}, "banlist", "tcp" ) )
                {
                    &remote_send( "You don't have permission to use /banlist.", $sockcount, $query_id );
                    return $query_id;
                }

                my @banlist = sort keys %bans;
                my $start   = int( $cmds[1] ) || 0;
                my $amount  = int( $cmds[2] ) || 10;

                # Some sanity checks
                #$start = $1 if ( $data =~ /^\/banlist\s+(\d+)/i );
                $start = ( $start > $#banlist + 1 ) ? ( $start - $amount ) : $start;
                $start  = 0                          if ( $start < 0 );
                $amount = ( $#banlist + 1 )          if ( $#banlist < 10 );
                $amount = ( $#banlist - $start + 1 ) if ( $start + $amount > $#banlist );

                &remote_send(
                           "Showing bans from $start to " . ( $start + $amount ) . " (Bans: " . ( $#banlist + 1 ) . ")",
                           $sockcount, $query_id );
                &remote_send(
                              sprintf(
                                       "%-32s %-16s %-20s %-17s %-10s %-10s",
                                       "GUID", "Name", "Reason", "Made", "Banned by", "Expires"
                                     ),
                              $sockcount,
                              $query_id
                            );

                for my $count ( 0 .. $amount )
                {
                    next if ( !defined( $banlist[ $start + $count ] ) );    # Oops, workaround.
                    my $guid = $banlist[ $start + $count ];
                    &remote_send(
                                  sprintf(
                                           "%-32s %-16s %-20s %-17s %-10s %-10s",
                                           $guid,
                                           '"' . $bans{$guid}{'name'} . '"',
                                           '"' . $bans{$guid}{'reason'} . '"',
                                           '"' . $bans{$guid}{'made'} . '"',
                                           '"' . $bans{$guid}{'banner'} . '"',
                                           '"' . &getExpireTime( $bans{$guid}{'expires'} ) . '"'
                                         ),
                                  $sockcount,
                                  $query_id
                                );
                }
                &remote_send( "Note: use !unban <guid> to permanently remove the ban.", $sockcount, $query_id );

                return $query_id;
            }
            elsif ( $cmds[0] eq "/listcmds" )
            {

                if ( !&admin_check( $remote{$sockcount}{'guid'}, "listcmds", "tcp" ) )
                {
                    &remote_send( "You don't have permission to use listcmds.", $sockcount, $query_id );
                    return $query_id;
                }

                &remote_send( "Available admin commands:", $sockcount, $query_id );
                &remote_send( "------------------------:", $sockcount, $query_id );

                my $start =
                  ( defined( $cmds[1] ) && int( $cmds[1] ) >= 0 && int( $cmds[1] ) <= $remote{$sockcount}{'level'} )
                  ? int( $cmds[1] )
                  : 0;
                my $stop = $start > 0
                  && $start < $remote{$sockcount}{'level'} ? $start : $remote{$sockcount}{'level'};

                for my $lvl ( $start .. $stop )
                {
                    my @out = ();
                    &remote_send( "Level $lvl:", $sockcount, $query_id );
                    my $ref = $admin_func[$lvl];

                    for my $cmd2 ( sort @$ref )
                    {
                   	
			my $cmd = $cmd2;
                        next if ( index( $cmd, "game:" ) == 0 || !$cmd );
			
                        $cmd =~ s/^tcp://;
                        
                        #&log("$lvl -> $cmd");
                        if ( $cmd && defined( $rights{$cmd} ) )
                        {
                            push( @out, "right:$cmd" );
                        }
                        elsif ( defined( $listcmds{$cmd} ) && $listcmds{$cmd} == 1 )
                        {
                            push( @out, "/" . $cmd );
                        }
                        else
                        {
                            push( @out, "$config{'command_prefix'}" . $cmd );
                        }

                        # send the list, if there are 4 in a row.
                        if ( $#out == 3 )
                        {
                            &remote_send( sprintf( "%-19s %-19s %-19s %-19s", @out ), $sockcount, $query_id );
                            @out = ();
                        }
                    }
                    &remote_send( sprintf( "%-19s %-19s %-19s %-19s", @out ), $sockcount, $query_id )
                      if ( $#out > -1 );
                }

                if ( $config{'tcp_admin_username'} eq $remote{$sockcount}{'username'} )
                {

                    # show uberadmin commands:
                    &remote_send( "Level Uberadmin:", $sockcount, $query_id );
                    &remote_send( sprintf( "%-19s %-19s %-19s %-19s", "/debug", "/useradd", "/userdel", "/userlevel" ),
                                  $sockcount, $query_id );
                    &remote_send( sprintf( "%-19s %-19s %-19s %-19s", "/userlist", "/userpassword", "", "" ),
                                  $sockcount, $query_id );
                }

            }
            elsif ( $cmds[0] eq "/help" )
            {

                if ( defined( $cmds[1] ) )
                {

                    # Parameter found
                    if ( $cmds[1] eq "etm" )
                    {
                        &remote_send(
                                      "Usage: /etm <bitmask> - "
                                        . "sets the amount of informations, which are send to the client.",
                                      $sockcount,
                                      $query_id
                                    );
                        &remote_send( "This setting overrides the /filter settings, if greater then zero.",
                                      $sockcount, $query_id );
                        &remote_send( "Explanation:", $sockcount, $query_id );
                        &remote_send( "1   = ETM-INFO  - Connects, Disconnects, General informations",
                                      $sockcount, $query_id );
                        &remote_send( "2   = ETM-WARN  - Warnings by etadmin_mod",            $sockcount, $query_id );
                        &remote_send( "4   = ETM-CHAT  - Global chat",                        $sockcount, $query_id );
                        &remote_send( "8   = ETM-KICK  - kicks made by etadmin_mod",          $sockcount, $query_id );
                        &remote_send( "16  = ETM-VOTE  - all votings and results",            $sockcount, $query_id );
                        &remote_send( "32  = ETM-ETPRO - etpro map announcements and popups", $sockcount, $query_id );
                        &remote_send( "64  = ETM-KILL  - kills (note: lot of messages on busy servers)",
                                      $sockcount, $query_id );
                        &remote_send( "128 = ETM-RCON  - all rcon commands send by etadmin_mod", $sockcount,
                                      $query_id );
                        &remote_send( "256 = ETM-CLOG  - all console.log output. Includes output of rcon commands.",
                                      $sockcount, $query_id );
                        &remote_send( "Example: /etm 63 shows INFO, WARN, CHAT, KICK, VOTE and ETPRO messages.",
                                      $sockcount, $query_id );
                    }
                    elsif ( $cmds[1] eq "etm_kills" )
                    {
                        &remote_send(
                                 "Usage: /etm_kills <bitmask> - " . "sets type of kills, which are send to the client.",
                                 $sockcount, $query_id );
                        &remote_send(
"You still need the ETM-KILL (64) flag set with /etm, but can control, what kills to display..",
                            $sockcount, $query_id
                        );
                        &remote_send( "Explanation:", $sockcount, $query_id );
                        &remote_send( "1   = ETM-KILL:KILL     - standard kills (player kills opponent)",
                                      $sockcount, $query_id );
                        &remote_send( "2   = ETM-KILL:TKS      - team kills. (player kills one of his own team)",
                                      $sockcount, $query_id );
                        &remote_send( "4   = ETM-KILL:SUICIDE  - suicide (player kills himself)",
                                      $sockcount, $query_id );
                        &remote_send( "Example: /etm_kills 7 shows all kill messages (default).",
                                      $sockcount, $query_id );
                    }
                    elsif ( $cmds[1] eq "etm_chat" )
                    {
                        &remote_send(
                                      "Usage: /etm_chat <bitmask> - "
                                        . "sets type chat messages, which are send to the client.",
                                      $sockcount,
                                      $query_id
                                    );
                        &remote_send(
"You still need the ETM-CHAT (4) flag set with /etm, but you can control, what chat messages to display..",
                            $sockcount, $query_id
                        );
                        &remote_send( "Explanation:",                                       $sockcount, $query_id );
                        &remote_send( "1   = ETM-CHAT:GLOBAL    - global chat.",            $sockcount, $query_id );
                        &remote_send( "2   = ETM-CHAT:TEAM      - team and fireteam chat.", $sockcount, $query_id );
                        &remote_send( "4   = ETM-CHAT:PMS       - private messages (between players).",
                                      $sockcount, $query_id );
                        &remote_send( "Example: /etm_chats 7 shows all chat messages (default).",
                                      $sockcount, $query_id );
                    }
                    elsif ( $cmds[1] eq "filter" )
                    {
                        &remote_send(
                                      "Usage: /filter <0/1/2> - "
                                        . "0 shows everything, 2 shows chat & kills., 2 shows only chat messages.",
                                      $sockcount,
                                      $query_id
                                    );
                        &remote_send( "Default (on connect) is /filter 1, /etm 0. This is configured serverside.",
                                      $sockcount, $query_id );
                        &remote_send( "Note: Does only work, if /etm 0. ", $sockcount, $query_id );
                    }
                    else
                    {
                        &remote_send( "help: No help for $arr[1] available.", $sockcount, $query_id );
                    }
                }
                else
                {

                    # Generell help
                    &remote_send( "Available commands:",  $sockcount, $query_id );
                    &remote_send( "-------------------:", $sockcount, $query_id );
                    &remote_send( "/bc <msg>         - broadcast. Sends a message to all connected tcp-users.",
                                  $sockcount, $query_id )
                      if ( &admin_check( $remote{$sockcount}{'guid'}, "bc", "tcp" ) );
                    &remote_send( "/banlist [start]  - Shows a list of the etadmin_mod bans. Use !unban to remove.",
                                  $sockcount, $query_id )
                      if ( &admin_check( $remote{$sockcount}{'guid'}, "banlist", "tcp" ) );
                    &remote_send( "/debug            - Shows the current running config.", $sockcount, $query_id )
                      if ( $remote{$sockcount}{'username'} eq $config{'tcp_admin_username'} );
                    &remote_send( "/disconnect <id>  - Disconnects a tcp-connection.", $sockcount, $query_id )
                      if ( &admin_check( $remote{$sockcount}{'guid'}, "disconnect", "tcp" ) );
                    &remote_send(
                                  "/etm <value>      - "
                                    . "set the information of etadmin_mod to be displayed. See /help etm for details.",
                                  $sockcount,
                                  $query_id
                                );
                    &remote_send(
                             "/filter <value>   - " . "easy filter for use without /etm. See /help filter for details.",
                             $sockcount, $query_id );
                    &remote_send(
                                  "/help             - "
                                    . "this command. /help <command> for detailed help for a specific command.",
                                  $sockcount,
                                  $query_id
                                );
                    &remote_send( "/listcmds [lvl]   - shows a list of available etadmin_mod commands.",
                                  $sockcount, $query_id )
                      if ( &admin_check( $remote{$sockcount}{'guid'}, "listcmds", "tcp" ) );

                    &remote_send( "/listplayers      - shows a list of connected players with detailed informations.",
                                  $sockcount, $query_id )
                      if ( &admin_check( $remote{$sockcount}{'guid'}, "listplayers", "tcp" ) );

                    &remote_send( "/playerstats [id] - Shows stats of one or all players. Needs simple_stats = 1.",
                                  $sockcount, $query_id )
                      if ( &admin_check( $remote{$sockcount}{'guid'}, "playerstats", "tcp" ) );
                    &remote_send( "/serverinfo       - Shows some informations about the server.",
                                  $sockcount, $query_id )
                      if ( &admin_check( $remote{$sockcount}{'guid'}, "serverinfo", "tcp" ) );
                    if ( $remote{$sockcount}{'username'} eq $config{'tcp_admin_username'} )
                    {
                        &remote_send( "/useradd          - adds a new tcp user.",          $sockcount, $query_id );
                        &remote_send( "/userdel          - deletes a existing tcp user .", $sockcount, $query_id );
                        &remote_send( "/userlevel        - changes the level of a existing tcp user.",
                                      $sockcount, $query_id );
                        &remote_send( "/userlist         - lists all existing tcp users (including admin account).",
                                      $sockcount, $query_id );
                        &remote_send( "/userpassword     - changes the password of a existing tcp user.",
                                      $sockcount, $query_id );
                    }

                    &remote_send( "/who              - shows all connected tcp-users.", $sockcount, $query_id )
                      if ( &admin_check( $remote{$sockcount}{'guid'}, "who", "tcp" ) );
                    &remote_send( "/whoami           - shows some informations about your own tcp-session.",
                                  $sockcount, $query_id );
                    &remote_send( "/quit             - Terminates your current tcp-connection.", $sockcount,
                                  $query_id );

                    #&remote_send(  "$config{'command_prefix'}<command>     ".
                    # 		" - run a etadmin_mod command. See /listcmds for avail. cmds.",
                    #    	  	$sockcount, $query_id );

                }

            }
            elsif ( $cmds[0] eq "/playerstats" )
            {

                if ( !&admin_check( $remote{$sockcount}{'guid'}, "playerstats", "tcp" ) )
                {
                    &remote_send( "You don't have permission to use playerstats.", $sockcount, $query_id );
                    return $query_id;
                }

                if ( !$config{'simple_stats'} )
                {
                    &remote_send( "Stats are deactivated. Use \"simple_stats = 1\" to activate.",
                                  $sockcount, $query_id );
                    return $query_id;
                }

                if ( defined( $cmds[1] ) )
                {

                    # Single player stats.

                    my ( $client_id, $found ) = &part2complete( $cmds[1], 1 );
                    return $query_id if ( !&check_result( $cmds[0], $found, "tcp", $sockcount, 0, $query_id ) );

                    my $kills      = $tmphash{$client_id}{'overall'}{'kills'}      || 0;
                    my $deaths     = $tmphash{$client_id}{'overall'}{'deaths'}     || 0;
                    my $teamkills  = $tmphash{$client_id}{'overall'}{'teamkills'}  || 0;
                    my $teamdeaths = $tmphash{$client_id}{'overall'}{'teamdeaths'} || 0;
                    my $suicides   = $tmphash{$client_id}{'overall'}{'suicides'}   || 0;
                    $deaths += $suicides;

                    # Workarround, for dirty starts with rconmode file:
                    $tmphash{$client_id}{'joined'} = time if ( !$tmphash{$client_id}{'joined'} );

                    my $online_time = int( ( time - $tmphash{$client_id}{'joined'} ) / 60 );
                    my $killratio     = $deaths > 0      ? sprintf( "%.2f", $kills / $deaths )         : "N/A";
                    my $teamkillratio = $teamdeaths > 0  ? sprintf( "%.2f", $teamkills / $teamdeaths ) : "N/A";
                    my $kpm           = $online_time > 0 ? sprintf( "%.2f", $kills / $online_time )    : "N/A";

                    &remote_send( "Stats for $tmphash{$client_id}{'name'}", $sockcount, $query_id );
                    &remote_send( "Kills:      $kills",                     $sockcount, $query_id );
                    &remote_send( "Deaths:     $deaths",                    $sockcount, $query_id );
                    &remote_send( "Ratio:      $killratio",                 $sockcount, $query_id );
                    &remote_send( "Teamkills:  $teamkills",                 $sockcount, $query_id );
                    &remote_send( "Teamdeaths: $teamdeaths",                $sockcount, $query_id );
                    &remote_send( "TK-Ratio:   $teamkillratio",             $sockcount, $query_id );
                    &remote_send( "KPM:        $kpm kills/minute",          $sockcount, $query_id );
                    &remote_send( "Time:       $online_time minutes",       $sockcount, $query_id );

                }
                else
                {

                    # stats overview.
                    &remote_send( "Statsoverview:",                                 $sockcount, $query_id );
                    &remote_send( " S   K   D    KR  TK  TD   TKR   KPM   T  Name", $sockcount, $query_id );

                    #[16:39:48]  S   K   D    KR  TK  TD   TKR   KPM   T  Name
                    #[16:39:48] 28   0   0   N/A   0   0   N/A   N/A   0
                    foreach my $client_id ( sort { $a <=> $b } keys %tmphash )
                    {

                        next if ( $client_id < 0 );

                        if ( !defined( $tmphash{$client_id}{'team'} ) && !defined( $tmphash{$client_id}{'class'} ) )
                        {

                            # broken entry? Delete it and go to the next one...
                            delete $tmphash{$client_id}{'team'};
                            next;
                        }

                        my $kills      = $tmphash{$client_id}{'overall'}{'kills'}      || 0;
                        my $deaths     = $tmphash{$client_id}{'overall'}{'deaths'}     || 0;
                        my $teamkills  = $tmphash{$client_id}{'overall'}{'teamkills'}  || 0;
                        my $teamdeaths = $tmphash{$client_id}{'overall'}{'teamdeaths'} || 0;
                        my $suicides   = $tmphash{$client_id}{'overall'}{'suicides'}   || 0;
                        $deaths += $suicides;

                        # Workarround, for dirty starts with rconmode file:
                        $tmphash{$client_id}{'joined'} = time if ( !$tmphash{$client_id}{'joined'} );

                        my $online_time = int( ( time - $tmphash{$client_id}{'joined'} ) / 60 );
                        my $killratio     = $deaths > 0      ? sprintf( "%.2f", $kills / $deaths )         : "N/A";
                        my $teamkillratio = $teamdeaths > 0  ? sprintf( "%.2f", $teamkills / $teamdeaths ) : "N/A";
                        my $kpm           = $online_time > 0 ? sprintf( "%.2f", $kills / $online_time )    : "N/A";

                        &remote_send(
                            sprintf(

                                # S   K   D     KR  TK  TD   TKR KPM  T  Name
                                "%2d %3d %3d %5s %3d %3d %5s %5s %3d  %s",
                                $client_id,
                                $kills,
                                $deaths,
                                $killratio,
                                $teamkills,
                                $teamdeaths,
                                $teamkillratio,
                                $kpm,
                                $online_time,
                                &convert_name( $tmphash{$client_id}{'name'}, 0, 0 )
                            ),
                            $sockcount,
                            $query_id
                                    );
                    }
                }

            }
            elsif ( $cmds[0] eq "/listplayers" )
            {

                if ( !&admin_check( $remote{$sockcount}{'guid'}, "listplayers", "tcp" ) )
                {
                    &remote_send( "You don't have permission to use listplayers.", $sockcount, $query_id );
                    return $query_id;
                }

                &remote_send( "Slot - Lvl - GUID - IP - SIDE - TKindex - Class - Playername", $sockcount, $query_id );
                &remote_send( "------------------------------------------------------------", $sockcount, $query_id );
                foreach my $player ( sort { $a <=> $b } keys %tmphash )
                {
                    next if ( $player < 0 );

                    if ( !defined( $tmphash{$player}{'team'} ) && !defined( $tmphash{$player}{'class'} ) )
                    {

                        # broken entry? Delete it and go to the next one...
                        delete $tmphash{$player}{'team'};
                        next;
                    }

                    my $index =
                      defined( $tk_hash{ $tmphash{$player}{'guid'} } )
                      ? $tk_hash{ $tmphash{$player}{'guid'} }{'value'}
                      : 0;

                    my $admin_level = &get_admin_level( $tmphash{$player}{'guid'} );

                    $tmphash{$player}{'ip'} = "0.0.0.0" if ( !defined( $tmphash{$player}{'ip'} ) );

                    &remote_send(
                                  sprintf(
                                           "%2d %2d %s %s %s %.2f %s %s",
                                           $player,
                                           $admin_level,
                                           $tmphash{$player}{'guid'},
                                           $tmphash{$player}{'ip'},
                                           $SIDE2{ $tmphash{$player}{'team'} },
                                           $index,
                                           $CLASS2{ $tmphash{$player}{'class'} },
                                           &convert_name( $tmphash{$player}{'name'} )
                                         ),
                                  $sockcount,
                                  $query_id
                                );

                }
                return $query_id;
            }
            elsif ( $cmds[0] eq "/etm" )
            {
                if ( $data =~ /^\s*\/etm\s+(\d+)/i )
                {
                    if ( $1 & ETM_CLOG && !( &admin_check( $remote{$sockcount}{'guid'}, "etconsole_log", "tcp" ) ) )
                    {
                        &remote_send(
                                      "You don't have permission to see the etconsole.log output. "
                                        . "Current etm-value: $remote{$sockcount}{'etm'}",
                                      $sockcount,
                                      $query_id
                                    );
                    }
                    else
                    {
                        $remote{$sockcount}{'etm'} = $1;
                        &remote_send( "Set etm to $1.", $sockcount, $query_id );
                    }
                }
                else
                {
                    &remote_send( "Current etm-value: " . $remote{$sockcount}{'etm'}, $sockcount, $query_id );
                }
                return $query_id;
            }
            else
            {

                my $supress = 0;

                # Then do the normal etadmin_mod stuff
                if ( $data =~ s/^\s*\/// )
                {
                    $supress = 1;

                    # Say nothing.
                    if ( &admin_check( $remote{$sockcount}{'guid'}, "silentcommands", "tcp" ) )
                    {
                        $supress = 2;
                    }
                }
                else
                {
                    my $chat_prefix = $config{'tcp_chat_appearance'};
                    $chat_prefix =~ s/<TCP_USERNAME>/$remote{$sockcount}{'username'}/g;
                    &say( $chat_prefix.": ^2".$data );

                    #&global_remote_send("^3etadmin_mod(^7" .
                    #	$remote{$sockcount}{'username'} . "^3): ^7$data", "ETM-CHAT:GLOBAL");
                }

                &log( "Supress: $supress / $data / " . $remote{$sockcount}{'guid'} . " / " . $query_id )
                  if ( $config{'debug'} > 1 );

                if ( $supress != 1 && $data =~ /^\Q$config{'command_prefix'}\E(.*)/ )
                {
                    &log( "Executing: $data (" . ($sockcount) . ")" ) if ( $config{'debug'} );
                    my $cmd = $1;

                    my $chat_name = $config{'tcp_chat_appearance'};
                    if (!($chat_name =~ s/<TCP_USERNAME>/$remote{$sockcount}{'username'}/g)) {
                    	$chat_name = "^3etadmin_mod(^7" . ( $remote{$sockcount}{'username'} ) . "^3)";
                    }
                    
                    # try to execute.
                    &admin_command(
                                    $data,
                                    $chat_name,
                                    $cmd,
                                    "tcp",
                                    $remote{$sockcount}{'guid'},
                                    ( $supress == 2 ? 1 : 0 ),
                                    ( $sockcount + 1 ),
                                    $query_id
                                  );
                }
                elsif ( $supress > 1 )
                {
                    &remote_send( "Unknown command.", $sockcount, $query_id );
                }

            }
        }
        else
        {
            &remote_send( "You are not authorized. " . "Please identify yourself with /identify <username> <password>",
                          $sockcount );
            $remote{$sockcount}{'retry'}++;

            if ( $remote{$sockcount}{'retry'} > 3 )
            {
                &log("Retry count reached 3, closed connection.");
                &remote_disconnect($sockcount);
            }
        }
    }
    return $query_id;
}

sub process_line
{
    my $line = shift;
    chomp $line;
    next unless ($line);

    # Chop timestamp. Note: Not really necessary, only if game.log is used,
    # which is not really supported
    $line =~ s/^\d*:?\d*\s*//;
    $lines++;

    if ( $line =~ /^InitGame: / )
    {

        # Intermission ended.
        $intermission = 0;

        # Better wait until Start of Round...
        $running = 1;
        $time    = time();

        my $rhash = &parse_userinfo($line);

        $timelimit = $$rhash{'timelimit'} if ( defined( $$rhash{'timelimit'} ) );
        $mapname   = $$rhash{'mapname'}   if ( defined( $$rhash{'mapname'} ) );
        $mod_version = $$rhash{'mod_version'}
          if ( $config{'et_mod'} == 2 && defined( $$rhash{'mapname'} ) );

        for (
            qw(sv_hostname gamename modversion g_gametype g_needpass sv_maxclients
            sv_privateClients mapname protocol version timelimit sv_punkbuster etadmin_mod)
          )
        {
            $server_status{$_} = $$rhash{$_} if ( defined( $$rhash{$_} ) );
        }

        &log("Timelimit: $timelimit");
        if ( !$timelimit && $config{'cancel_mode'} != 3 )
        {
            &log("No map-timelimit found, assuming 20 minute map time.");
            $timelimit = 20;
        }

        if ($crazy_gravity)
        {
            $crazy_gravity_time   = time + $crazy_gravity_duration;
            $crazy_gravity_notify = 0;
        }

        # cancel_modes
        # 1 == X mins before end of map,
        # 2 == after X% of map time,
        # 3 == X minutes after mapstart

        if ( $config{'cancel_mode'} == 1 )
        {
            $cancel_time = $timelimit - $config{'cancel_time'};
        }
        elsif ( $config{'cancel_mode'} == 3 )
        {
            $cancel_time = $config{'cancel_time'};
        }
        else
        {
            $cancel_time = int( $timelimit * ( $config{'cancel_time'} / 100 ) );
        }

        my $stamp = time - 1;

        # Shrub has 2 InitGames after another...
        # the +5 prevents unnessesary checking and deleting
        # and loading of config files
        if ( !$last_init )
        {

            &global_remote_send( "Map: $mapname (Timelimit: $timelimit minutes)", "ETM-INFO" );

            &log("setting timestamp: $stamp") if ( $config{'debug'} );

            # Clear old slots (kicked or
            # other dropped out players without Disconnect in the log);
            foreach my $p ( keys %tmphash )
            {

                $tmphash{$p}{'deaths'}   = 0;
                $tmphash{$p}{'kills'}    = 0;
                $tmphash{$p}{'suicides'} = 0;
                delete $tmphash{$p}{'warnings'};
                delete $tmphash{$p}{'mapvote'} if ( $config{'intermission_mapvoting'} );
                &log( "Player: $p ($tmphash{$p}{'name'}) " . "TK index: $tk_hash{$tmphash{$p}{'guid'}}{'value'}" )
                  if ( $config{'teamkill_restriction'} && $config{'debug'} );

            }

            # After 5 seconds, i check ALL timestamps of the players again, to make sure, i removed
            # all old data
            # Reload protected and shrub config
            %protected = ();
            &load_shrubbot_cfg;
            &load_protected;
            &load_map_configs();
            &load_birthdays();
            &load_config_file($admin_config) if ( $admin_config ne "" );

            sleep 1 if ( $#rcon_cmds_startround > -1 );
            for (@rcon_cmds_startround)
            {
                &log("Executing $_");
                if (/^(rcon|ext)\s*:\s*(.*)$/)
                {
                    my $type = $1;
                    my $comm = $2;
                    &log("Executing: ($type) -> $comm");
                    if ( $type eq "rcon" )
                    {
                        &cmd($comm);
                    }
                    elsif ( $type eq "ext" )
                    {
                        if ( !$sec_opts{'d'} && !( $sec_opts{'e'} && $postload ) )
                        {
                            my $rc = 0xffff & system($comm);
                            if ( $rc != 0 )
                            {
                                &log( sprintf "system(%s) failed. Return code: %#04x: ", $comm, $rc );
                            }
                            else
                            {
                                &log( sprintf "system(%s) succeeded. Return code: %#04x: ", $comm, $rc )
                                  if ( $config{'debug'} > 0 );
                            }
                        }
                    }
                }
                else
                {
                    &cmd($_);
                }
            }
            if ( $config{'deactivate_voting'} && $disabled_voting == 1 )
            {
                &cmd(   "set etadmin \"set vote_allow_nextmap 1 ; "
                      . "set vote_allow_shuffleteamsxp 1 ; "
                      . "set vote_allow_swapteams 1 ; "
                      . "set vote_allow_matchreset 1\"" );
                &cmd("vstr etadmin");

                $disabled_voting = 0;
            }

            if ( $config{'teamkill_restriction'} || $config{'persistent_mute'} )
            {

                # Delete old tk_hash entries (older then 24 hours)
                foreach my $fe_key ( keys %tk_hash )
                {
                    delete $tk_hash{$fe_key}
                      if ( $tk_hash{$fe_key}{'timestamp'} + 86400 < time );
                }

            }

            &log("warning level check.");
            foreach my $fe_key ( keys %warn_hash )
            {
                if ( $warn_hash{$fe_key}{'timestamp'} + $config{'warn_timeout'} * 86400 < time )
                {
                    if ( $warn_hash{$fe_key}{'value'} > 1 )
                    {
                        $warn_hash{$fe_key}{'value'}--;
                        $warn_hash{$fe_key}{'timestamp'} = time;
                    }
                    else
                    {
                        delete $warn_hash{$fe_key};
                    }
                }
            }

            if ( $mapvote{'state'} == 1 )
            {

                ## Display result and change map
                &display_mapvoting("Final result");

                # State 4 == Change map on next trigger
                $mapvote{'state'} = 4;
                $mapvote{'time'}  = time;

                my $winner = &getmapwinner();

                if ($winner)
                {

                    $mapvote{'winner'} = $winner;
                    &say( "^3mapvote: ^7The winning map is ^3$winner^7. "
                          . ( $mapname ne $mapvote{'winner'} ? "Changing map in approx. 2 seconds!" : "" ) );

                    &global_remote_send( "Mapvote winner " . $mapvote{'winner'}, "ETM-VOTE" );

                    $mapvote{'state'} = 0 if ( $mapname eq $mapvote{'winner'} );

                }
                else
                {
                    &global_remote_send( "No mapvote winner (no votes).", "ETM-VOTE" );
                    $mapvote{'state'} = 0;
                }

                foreach my $player ( keys %tmphash )
                {
                    delete $tmphash{$p}{'mapvote'} if ( $config{'intermission_mapvoting'} );
                }
            }

        }
        $last_init = $stamp;

        &log("Setting Timer to $cancel_time minutes.");
        my $rcon_set = $1 if ( $line =~ /etadmin_mod\\(.*?)\\/ );
        my $sets =
            "ver=$version,spree=$config{'spree_detector'},"
          . "mga=$config{'minguidage'},"
          . "list=$config{'etadmin_serverlist'}";
        if ( $rcon_set ne $sets )
        {
            &cmd("sets etadmin_mod \"$sets\"");
            sleep 1;    # wait another sec after the sets (just to make sure)
        }
        my $timed = time;

        if ( $config{'rule_announce_time'} > 0 )
        {

            # Annoucement of rules...
            foreach my $r ( keys %rule )
            {

                # I want the announcements at round start (resetting time),
                # but only ONCE (therefore a delay of 2 seconds)
                $last_notify{$r} = $timed + 1 - $config{'rule_announce_time'} if ( $rule{$r} > 0 );
                my $timed += $config{'rule_announce_offset'};
            }
        }

        # try to load previous map spree or just reset to 0.
        &load_map_spree($mapname) if ( $config{'persistent_map_spree_record'} );

        # Reset internal vars
        %ready       = ();
        %vote_times  = ();
        $first_blood = "";
        $last_blood  = "";
        $gamestart   = 0;

    }
    elsif ( index( $line, "Userinfo" ) == 0 )
    {

        #$line =~ /cl_guid\\([^\\]*)\\.*name\\([^\\]*)\\.*\\/; #ip\\(\d+\.\d+\.\d+\.\d+):\+\\/;
        my $rhash           = &parse_userinfo($line);
        my $guid            = $$rhash{'cl_guid'};
        my $name            = &strip_name( $$rhash{'name'} );
        my $ip              = $$rhash{'ip'};
        my $custom_password = $$rhash{'hp_password'};
        my $custom_exec     = $$rhash{'hp_logincmd'};
        my $greeting        = $$rhash{'hp_greeting'};

        $kick = "";
        $ip =~ s/:.*$//;

        $over_ip      = $ip;
        $over_guid    = $guid;
        $over_name    = $name;
        $ready{$guid} = time;

        if ( $config{'admin_greeting'}
             && !$gb_data{$guid}{'greeting'}{'status'} )
        {
            if ( $$rhash{'hp_nogreeting'} )
            {

                # THE GREETING MUST BE DISABLED.
                &log("Someone entered, but deactivated the greeting ... ($name)");
                $gb_data{$guid}{'greeting'}{'status'} = 1;
            }
            elsif ($greeting)
            {
                &log("Found custom greeting for $name: $greeting");
                $gb_data{$guid}{'greeting'}{'custom'} = $greeting;
            }
        }

        # exec command on startup, if set.
        if ( $custom_exec && !$gb_data{$guid}{'commands'}{'status'} )
        {
            $gb_data{$guid}{'commands'}{'status'}  = 0;
            $gb_data{$guid}{'commands'}{'command'} = $custom_exec;
            &log("Found $custom_exec") if ( $config{'debug'} > 1 );
        }

        if ( $config{'use_advanced_warn'} )
        {
            if ( $warn_hash{$guid}{'timestamp'} + $config{'warn_timeout'} * 86400 < time )
            {
                if ( $warn_hash{$guid}{'value'} > 1 )
                {
                    $warn_hash{$guid}{'value'}--;
                    $warn_hash{$guid}{'timestamp'} = time;
                }
                else
                {
                    delete $warn_hash{$guid};
                }
            }

        }

        if ( $config{'clantag_protector'}
             && !&check_clantag( &convert_name($name), $custom_password ) )
        {

            if (    $config{'admin_ctp_override'}
                 && &get_admin_level($guid) >= $config{'admin_ctp_override'} )
            {

                # Its a admin, ignore that
            }
            else
            {
                &log("Kicked $name. Used registered Clantag with wrong pass: $custom_password");
                $kick = "Used registered clantag with wrong password!";
                next;
            }
        }

        &log("UserInfo: $name (guid: $guid)") if ( $config{'debug'} );
        $userinfo{$name} = $guid;

        if ( $config{'manage_bans'} && defined( $bans{$guid} ) )
        {

            # shrub counts from the 1.1.2000, not from 1.1.1970 ?!?!
            my $timestamp = $config{'ban_timestamp_format'} eq "shrub" ? ( time - 946767600 ) : time;

            if ( ( $bans{$guid}{'expires'} == 0 || $bans{$guid}{'expires'} > $timestamp ) )
            {

                # BANNED USER
                $kick = "Banned.($bans{$guid}{'reason'}) ";

                #&say( "^3banned user: $name ^3kicked. (Reason: " . $bans{$guid}{'reason'} . ")" );
                &log(   "Kicking banned user: "
                      . &convert_name( $name, 0, 0 )
                      . "(GUID: $guid, Reason: $bans{$guid}{'reason'}" );
                next;

            }
            else
            {

                # BAN expired, removing
                &log("Ban for $guid ($name) expired.");
                &shrub_ban( $config{'shrubbot_cfg'}, "remove", $guid );
                delete $bans{$guid};
            }
        }
        else
        {
            if ( defined( $tmp_warn{$guid} )
                 && ( &strip_spaces( &convert_name( $tmp_warn{$guid}{'name'} ) ) ne &convert_name($name) ) )
            {

                # Name change ...
                if ( $guid eq $protected{ &strip_spaces( &convert_name($name) ) }
                     || !defined( $protected{ &strip_spaces( &convert_name($name) ) } ) )
                {

                    # the new name isn't registered
                    delete $warnings{$guid};
                    delete $tmp_warn{$guid};

                    #XXX <---
                    &say("$name^3 -> OK. Countdown stopped");
                    &log("Countdown stopped for $name ($guid)");
                }
                else
                {

                    # time goes on...
                }
            }

            if (
                 $config{'name_protector'}
                 && (    defined( $protected{ &strip_spaces( &convert_name($name) ) } )
                      || defined( $warnings{$guid} ) )
               )
            {

                &log("Protected name found: $name") if ( $config{'debug'} );

                # Test , if reserved
                if ( $guid ne $protected{ &strip_spaces( &convert_name($name) ) } )
                {

                    # ERROR
                    if ( !defined( $warnings{$guid} ) )
                    {
                        &say( "$name ^1 -> This name is registered... " . "You have 90 seconds to change your name." );
                        $warnings{$guid} = time;
                        &log(   "Found protected name: $name -> "
                              . $protected{ &convert_name($name) }
                              . "( wrong: $guid)" );
                        $tmp_warn{$guid}{'name'}   = $name;
                        $tmp_warn{$guid}{'status'} = 1;
                    }
                }

            }
        }

# Userinfo: \cg_etVersion\Enemy Territory, ET 2.56\cg_uinfo\13 0 30\g_password\none\cl_guid\57D276DD0C8EAA494F257E893D8D1A91\cl_punkbuster\1\cl_anonymous\0\snaps\20\rate\25000\name\^4Gipsy ^0[^7S^4L^1O^0]^7\cl_wwwDownload\1\ip\193.77.152.136:37036

    }
    elsif ( index( $line, "ClientUserinfoChanged" ) == 0 )
    {

        # old (etmain/etpro):
        # ClientUserinfoChanged: 2 n\cdub S.A.S\t\3\c\0\r\0\m\0000000\s\0000000\dn\\dr\0\w\3\lw\3\sw\0\mu\0\ref\0

# Shrub (g_logoptions 192):
# ClientUserinfoChangedGUID: 2 F589AE08B25A248D57611DAC77AF90B3 n\^7[^4d1p^7]^1H. ^3Potter\t\1\c\1\r\0\m\0000000\s\0000000\dn\\dr\0\w\3\lw\3\sw\2\mu\0\ref\0

        $line =~ /^ClientUserinfoChangedG?U?I?D?: (\d+) (.*?)n\\(.*?)(\\.*)$/;
        my $client_id = $1;
        my $guid      = $2;
        my $name      = &strip_name($3);
        my $rhash     = &parse_userinfo($4);
        my $class     = $$rhash{'c'};
        my $team      = $$rhash{'t'};
        my $weapon    = $$rhash{'w'};
        my $disguise  = $$rhash{'dn'};
        my $muted     = $$rhash{'mu'};

        $guid =~ s/ $//g;
        $guid = $over_guid if ( !$guid );
        $userinfo{$name} = $guid if ( !defined( $userinfo{$name} ) && $guid );
        
        $tmp_warn{$guid}{'client_id'} = $client_id
          if ( defined( $tmp_warn{$guid} ) && !defined( $tmp_warn{$guid}{'client_id'} ) );

        if ( !defined( $tmphash{$client_id} ) )
        {
            &global_remote_send( "$name ^;connected on slot $client_id.", "ETM-INFO" );
            $tmphash{$client_id}{'joined'} = time;

            if ( $config{'persistent_mute'} && $config{'et_mod'} == 2 )
            {
                &check_mute_state( $client_id, $guid );

            }
        }

        &global_remote_send( "Namechange: $tmphash{$client_id}{'name'} ^;-> $name", "ETM-INFO" )
          if ( defined( $tmphash{$client_id}{'name'} ) && $name ne $tmphash{$client_id}{'name'} );

        #$guid = $userinfo{$name} if (!$guid);
        $tmphash{$client_id}{'name'}     = $name;
        $tmphash{$client_id}{'guid'}     = $guid || $userinfo{$name};
        $tmphash{$client_id}{'weapon'}   = $weapon;
        $tmphash{$client_id}{'disguise'} = $disguise;
        $tmphash{$client_id}{'muted'}    = $muted;

        if ( $config{'name_minlength'} > 0 )
        {
            my $test_name = &convert_name( &strip_spaces($name) );
            if ( length($test_name) < $config{'name_minlength'} )
            {
                &log("Name too short: $guid ($name)");
                $kick = "Name too short (" . length($test_name) . "). Must be >= $config{'name_minlength'}";
            }
        }

        if (    !$kick
             && $name ne $tmphash{$client_id}{'checked_name'}
             && $config{'name_stealing_detection'} )
        {

            my $test_name = &convert_name( &strip_spaces($over_name) );

            if ( $test_name ne "" )
            {
                foreach my $id ( keys %tmphash )
                {
                    if ( $id ne $client_id && $tmphash{$id}{'name'} ne "" )
                    {
                        if (    $guid ne $tmphash{$id}{'guid'}
                             && $test_name eq &convert_name( &strip_spaces( $tmphash{$id}{'name'} ) ) )
                        {

                            # $GUID is a name faker
                            &log(   "$guid ($name) is a name faker. "
                                  . "Stole name of $tmphash{$id}{'name'} ($tmphash{$id}{'guid'})" );
                            $kick = "Name stealing / faking";
                            last;
                        }
                    }
                }
            }
        }

        if ( $config{'kick_badnames'} && !$kick && ( $name ne $tmphash{$client_id}{'checked_name'} ) )
        {
            my $test_name = &convert_name( &strip_spaces($name) );

            if ( !defined( $warnings_bn{$guid} ) )
            {
                for my $word (@bad_names)
                {

                    if ( index( $test_name, $word ) > -1 )
                    {
                        &log("Badname: $tmphash{$client_id}{'name'} ($_)");

                        if ( $config{'kick_badnames'} == 1 || !$config{'bad_name_grace_period'} > 0 )
                        {
                            $kick = "Badname: " . $tmphash{$client_id}{'name'};
                        }
                        else
                        {

                            # Warning and set timer.
                            if ( !defined( $warnings{$guid} ) )
                            {
                                &say(
                                      "^1Your name contains a bad word. "
                                        . "You have ^7"
                                        . $config{'bad_name_grace_period'}
                                        . "^1 seconds to change your name!",
                                      "chatclient",
                                      $client_id
                                    );

                                &log("Found bad name: $test_name (Guid: $guid)");
                                $warnings_bn{$guid}            = time;
                                $tmp_warn2{$guid}{'name'}      = $name;
                                $tmp_warn2{$guid}{'status'}    = 1;
                                $tmp_warn2{$guid}{'client_id'} = $client_id;
                            }
                        }
                        last;
                    }
                }
            }
            else
            {

                # test - namechange ?
                my $still_bad = 0;

                for my $word (@bad_names)
                {
                    if ( index( $test_name, $word ) > -1 )
                    {
                        $still_bad = 1;
                        last;
                    }
                }
                if ( !$still_bad )
                {
                    &say( "Name OK. Countdown stopped", "chatclient", $client_id );
                    delete $tmp_warn2{$guid};
                    delete $warnings_bn{$guid};
                }

            }
            $tmphash{$client_id}{'checked_name'} = $name;
        }

        if ($kick)
        {
            &log("Found kick entry: $kick");
            &kick( $client_id, $kick );
            $kick = "";

            next;
        }

        if ( !$gb_data{$guid}{'commands'}{'status'} )
        {
            if (    $gb_data{$guid}{'commands'}{'command'}
                 && $gb_data{$guid}{'commands'}{'command'} =~ s/^\Q$config{'command_prefix'}\E//
                 && &admin_check( $guid, "logincmd", "game" ) )
            {
                &log("Found hp_command: $gb_data{$guid}{'commands'}{'command'} for $name ($guid).");
                &admin_command( "-", $name, $gb_data{$guid}{'commands'}{'command'}, "game", $guid, 1 );
            }
            $gb_data{$guid}{'commands'}{'status'} = 1;
        }

        if ( $config{'use_advanced_warn'} && !$gb_data{$guid}{'warning'}{'status'} )
        {
            $gb_data{$guid}{'warning'}{'status'} = 1;
            if ( defined( $warn_hash{$guid}{'value'} ) && $warn_hash{$guid}{'value'} > 0 )
            {
                &say(   "^3warn: ^7Attention: $name^7 joins. (^1Warning: "
                      . $warn_hash{$guid}{'reason'} . "^7["
                      . $warn_hash{$guid}{'value'} . "/"
                      . ( $config{'warn_limit'} - 1 )
                      . "])" );
                &log("warn: player: $name, guid: $guid joined the server.");
            }
        }

        if ( $config{'forceclass_balance'} )
        {

            if (
                ( $team == 2 || $team == 1 ) &&    # active player? (0==conn, 3==spec)
                (
                  $tmphash{$client_id}{'class'} != $class ||    # class or team change?
                  $tmphash{$client_id}{'team'} != $team
                )
               )
            {

                my $classcount = 1;                              # start with one, count the player in.

                # I don't count admins > fcb_except_admins, if fcb_except_admins > 0...
                if (    $config{'fcb_except_admins'}
                     && &get_admin_level($guid) >= $config{'fcb_except_admins'} )
                {
                    $classcount = 0;
                }

                foreach my $id ( keys %tmphash )
                {
                    if ( $tmphash{$id}{'team'} eq $team && $tmphash{$id}{'class'} eq $class )
                    {

                        # I don't count admins > fcb_except_admins, if fcb_except_admins > 0...
                        if (
                             !( $config{'fcb_except_admins'} && &get_admin_level($guid) >= $config{'fcb_except_admins'}
                              )
                           )
                        {
                            $classcount++;
                        }
                    }
                }

                if (    $class_restriction{$class} > -1
                     && $classcount > $class_restriction{$class} )
                {

                    # Warn / put spec
                    &cmd("forceteam $client_id s");
                    sleep 1;
                    if ( $tmphash{$client_id}{'forceteam'} != $class )
                    {
                        &say(
                              "Please choose a different class. $CLASS{$class} is "
                                . ( $class_restriction{$class} ? "full." : "disabled." ),
                              "chatclient",
                              $client_id
                            );
                        $tmphash{$client_id}{'forceteam'} = $class;
                    }
                    $class = 0;
                    $team  = 3;
                }
                else
                {
                    if ( defined( $tmphash{$client_id}{'forceteam'} ) )
                    {

                        #&log("Putting $SIDE2{$team}");
                        &cmd("forceteam $client_id $SIDE2{$team}");
                        sleep 1;
                        &say( "Have fun as $CLASS{$class}. Please check your weapon choice.", "chatclient", $client_id )
                          if ( $config{'et_mod'} != 2
                               && ( $class == 0 || $class == 2 || $class == 4 ) );
                    }
                    delete $tmphash{$client_id}{'forceteam'};
                }

            }
        }

        if ( $tmphash{$client_id}{'team'} != $team )
        {
            $tmphash{$client_id}{'team'} = $team;
            &check_teams();
        }

        $tmphash{$client_id}{'class'} = $class;
        $tmphash{$client_id}{'team'}  = $team;
        $tmphash{$client_id}{'ip'}    = $over_ip;

        if ( $config{'manage_bans'} && defined( $bans{$guid} ) )
        {

            # BANNED USER !!!
            &kick( $client_id, "banned: $bans{$guid}{'reason'}", 0 );
            &say( "^3banned user: $name ^3kicked. ( Reason: " . $bans{$guid}{'reason'} . ")" );
            &log( "Kicked banned user: " . &convert_name($name) . "(GUID: $guid, Reason: $bans{$guid}{'reason'})" );
            &disconnect( $client_id, $guid );

        }
        elsif ( $config{'admin_greeting'} && !$gb_data{$guid}{'greeting'}{'status'} )
        {

            #&log ("Checking $name ($guid) - $admins{$guid} vs $config{'admin_greeting'}");
            if ( &get_admin_level($guid) >= $config{'admin_greeting'} )
            {

                # GREEETING ....

                my $greeting = $gb_data{$guid}{'greeting'}{'custom'}
                  || $greetings{ &get_admin_level($guid) }
                  || $greetings{'default'}
                  || "";
                if ($greeting)
                {
                    my $convert_name = &convert_name( $name, 0, 0 );
                    $greeting =~ s/<COLOR_PLAYER>/$name/g;
                    $greeting =~ s/<PLAYER>/$convert_name/g;
                    $greeting =~ s/<BR>/\n/g;
                    &say( $greeting, $position{'greetings'} );
                    &log( "Greeted: $convert_name" . ( $config{'debug'} > 0 ? "($greeting)" : "" ) );

                    #&log("Greeting: $greeting") if ( $config{'debug'} > 0 );
                }

            }

            #else {
            # NAAAA....
            #}
            $gb_data{$guid}{'greeting'}{'status'} = 1;
        }

        if ( $config{'forceclass_balance'} )
        {

            &restriction_checks();

            if ($running)
            {
                foreach my $r ( keys %rule )
                {

                    #&log("Status of $r $rules{$r}{'status'}");
                    if ( $rule{$r} && defined( $rules{$r} ) && !$rules{$r}{'status'} )
                    {

                        # Check the rule
                        if ( ( &in_array( $rules{$r}{'weapon'}, $weapon ) || &in_array( $rules{$r}{'weapon'}, -1 ) )
                             && $rules{$r}{'class'} == $class )
                        {

                            if ( !$tmphash{$client_id}{'set_spec'} )
                            {
                                &log("Setting $client_id spec (R: $r, $rules{$r}{'status'})...\n");

                                # Uuuhhh. Class && Weapon is not allowed atm.
                                $tmphash{$client_id}{'set_spec'} =
                                  time + 3 + int( rand(5) );    # +rand to prevent mass movement
                                &log( "Setting timer to $tmphash{$client_id}{'set_spec'} (atm: " . time . ")" )
                                  if ( $config{'debug'} );
                                last;
                            }

                        }
                        else
                        {
                            $tmphash{$client_id}{'set_spec'} = 0;
                        }
                    }
                }
            }
        }

        &log("ClientUserinfoChanged: Cid: $client_id, Name: $name, Guid: $userinfo{$name}")
          if ( $config{'debug'} > 2 );

        # 16 n\^4BlackHawk\t\2.....

        &log(   "Client: $client_id (Name: $tmphash{$client_id}{'name'}, "
              . "guid: $tmphash{$client_id}{'guid'}) is an ADMIN! " )
          if ( &get_admin_level( $userinfo{$name} ) and $config{'debug'} > 2 );

    }
    elsif ( $config{'detect_sound_exploit'} && index( $line, "voice: " ) == 0 )
    {
        if ( $line =~ /WARNING: bad command byte for client (\d+)$/ )
        {
            my $client = $1;
            &kick( $client, "Sound exploit" );

            if ( $config{'manage_bans'} || $config{'et_mod'} == 1 )
            {
                &log(   "Found overlength string in voice command exploit. "
                      . "Banning player $client ( $tmphash{$client}{'name'} )" );

                my $ip = $tmphash{$client}{'ip'};
                $ip = "0.0.0.0" if ( !$ip );

                #my $ban =
                #    "$config{'ban_script'} add "
                #  . $tmphash{$client}{'guid'} . " 0 "
                #  . "\"etadmin_mod\" "
                #  . "$ip \"Used sound overlength exploit\" \""
                #  . &convert_name( $tmphash{$client}{'name'}, 0, 1 ) . "\" &";
                #system("$ban");

                &shrub_ban( $config{'shrubbot_cfg'}, "add", $tmphash{$client}{'guid'},
                            0, "etadmin_mod", $ip,
                            "Used sound overlength exploit",
                            &convert_name( $tmphash{$client}{'name'}, 0, 1 ) );

                &say( "Banned: " . $tmphash{$client}{'name'} . "^7: Used sound overlength exploit." );

                # Ban in das ban-hash eintragen.
                #$bans{ $tmphash{$client}{'guid'} }{'name'}    = &convert_name( $tmphash{$client}{'name'}, 0, 1 );
                #$bans{ $tmphash{$client}{'guid'} }{'expires'} = 0;
                #$bans{ $tmphash{$client}{'guid'} }{'reason'}  = "Used sound overlength exploit";

                &load_shrubbot_cfg();
                &cmd("readconfig") if ( $config{'et_mod'} == 1 );

            }
            else
            {
                &log(   "Found overlength string in voice command exploit. "
                      . "Kicked player $client ( $tmphash{$client}{'name'} )" );
            }
            &disconnect($client);

        }
    }
    elsif ( index( $line, "ShutdownGame:" ) == 0 )
    {

        $running      = 0;
        $intermission = 1;
        $last_init    = 0;
        &log("Map ends.");
        for (@rcon_cmds_endround)
        {
            &log("Executing $_");
            if (/^(rcon|ext)\s*:\s*(.*)$/)
            {
                my $type = $1;
                my $comm = $2;
                &log("Executing: ($type) -> $comm");
                if ( $type eq "rcon" )
                {
                    &cmd($comm);
                }
                elsif ( $type eq "ext" )
                {
                    if ( !$sec_opts{'d'} && !( $sec_opts{'e'} && $postload ) )
                    {
                        my $rc = 0xffff & system($comm);
                        if ( $rc != 0 )
                        {
                            &log( sprintf "system(%s) failed. Return code: %#04x: ", $comm, $rc );
                        }
                        else
                        {
                            &log( sprintf "system(%s) succeeded. Return code: %#04x: ", $comm, $rc )
                              if ( $config{'debug'} > 0 );
                        }
                    }
                }
            }
            else
            {
                &cmd($_);
            }
        }

    }
    elsif ( index( $line, "ClientBegin:" ) == 0 )
    {

        $line =~ /ClientBegin: (\d+)/;
        my $client_id = $1;
        if ( defined( $tmphash{$client_id}{'tobegin'} ) && $tmphash{$client_id}{'tobegin'} )
        {
            &cmd( $tmphash{$client_id}{'tobegin'} );
            delete $tmphash{$client_id}{'tobegin'};
        }

    }

    #elsif ( index( $line, "Dynamite_Plant" ) == 0 )
    #{
    #
    #    $line =~ /^Dynamite_Plant: (\d+)/;
    #    my $client_id = $1;
    #    &global_remote_send( "Dynamite_Plant: ^7$tmphash{$client_id}{'name'}", "ETM-ETPRO" );
    #
    #}
    elsif ( index( $line, "ClientDisconnect:" ) == 0 )
    {

        $line =~ /ClientDisconnect: (\d+)/;
        my $client_id = $1;
        &log("Removing Cid: $client_id") if ( $config{'debug'} );
        &disconnect($client_id)          if ( defined( $tmphash{$client_id} ) );

    }
    elsif (    $running
            && $config{'body_protector'}
            && $line =~ /Gib: (\d+) (\d+) (\d+): (.+) gibbed (.+) by MOD_([A-Z_0-9]+)/i )
    {
        my $killer_id   = $1;
        my $killed_id   = $2;
        my $weapon_id   = $3;
        my $killer_name = $4;
        my $killed_name = $5;
        my $weapon_name = $6;

        # Workaround for shrub bug (gibs in warmup)
        next if ( !$gamestart );

        &log("Gib: $killer_id -> $killed_id ($killer_name ->  $killed_name) with $weapon_name")
          if ( $config{'debug'} );

        if (    !defined( $admins{ $tmphash{$killer_id}{'guid'} } )
             && $killer_id != 1022
             && $killer_id != $killed_id
             && $tmphash{$killer_id}{'team'} > 0
             && $tmphash{$killer_id}{'team'} < 3
             && $tmphash{$killer_id}{'team'} == $tmphash{$killed_id}{'team'}
             && !$gib_weapon{$weapon_id} )
        {

            # TEAM GIB (mit einer nicht destruktiven Waffe) !!!
            $tmphash{$killer_id}{'team_gib'}++;
            &log(   "Teamgib: $killer_id ($killer_name) -> $killed_name "
                  . "with $weapon_name ($tmphash{$killer_id}{team_gib} time)" );

            if ( $tmphash{$killer_id}{'team_gib'} < 3 )
            {
                &say( "You just gibbed a teammate! Don't do this again! ($tmphash{$killer_id}{team_gib} time)",
                      "chatclient", $killer_id );
                &log("Teamgib: Private Notice... (Info)");
            }
            elsif ( $tmphash{$killer_id}{'team_gib'} >= 3 )
            {
                &say(
                      "You are gibbing too much teammates! "
                        . "Don't do this again or you will be kicked! ($tmphash{$killer_id}{team_gib} time)",
                      "chatclient",
                      $killer_id
                    );
                &log("Teamgib: Private Notice... (Warning)");
            }
            elsif ( $tmphash{$killer_id}{'team_gib'} > 4 )
            {
                &say("$killer_name is gibbing teammates (to collect binoculars) ... 5 minute temp ban!");
                &kick( $killer_id, "you too many team gibs!", 0 );
                &log("Teamgib: Global Notice (Kick)");
            }
        }
        delete $tmphash{'1022'} if ( defined( $tmphash{'1022'} ) );

    }
    elsif ( $config{'minguidage'} && index( $line, "$config{'pb_sv_msgprefix'}: [From " ) == 0 )
    {

#ET PB Server: [From #6 e9a9(VALID:153) ^4[^jbd^4] S^1cow^4L] My gl G:\WINDOWS\System32\opengl32.dll size=685568 md5=11CC241BEE030FC2982413A59E6E32B7
#ET PB Server: [From #3 bb78(VALID:324) ^7[^4d1p^7]^1H. ^3Potter] My gl C:\WINNT\system32\opengl32.dll size=692496 md5=81BF9FD76F2D1EE684FFDA1CA1C666AE

        $line =~ /: \[From \#(\d+) .{4}\(VALID:(\d+)\)(.*) My gl /i;

        # The age is the (days +1)
        my $age = $2 - 1;
        my $id  = $1 - 1;
        next if ( $age < 0 || $id < 0 );

        my $pb_id = $1;
        my $name = &convert_name( $tmphash{$id}{'name'}, 0, 0 );
        &log("Checking KEY AGE: Slot: $id($name), KeyAge: $age");
        if ( $config{'minguidage'} > $age )
        {
            &say(   $tmphash{$id}{'name'}
                  . "^7 has a GUID, that is only ^3"
                  . $age
                  . "^7 days old. Server refused entry!" );
            &cmd(   "pb_sv_kick $pb_id 5 \"Your GUID is too new. Try again in "
                  . ( $config{'minguidage'} - $age )
                  . " days\"" );
            &disconnect( $pb_id - 1, $pb_id );
        }
    }
    elsif ( $line eq "ExitLevel: executed" )
    {

        # Leaving map.
        for (@rcon_cmds_exitlevel)
        {
            &log("Executing $_");
            if (/^(rcon|ext)\s*:\s*(.*)$/)
            {
                my $type = $1;
                my $comm = $2;
                &log("Executing: ($type) -> $comm");
                if ( $type eq "rcon" )
                {
                    &cmd($comm);
                }
                elsif ( $type eq "ext" )
                {
                    if ( !$sec_opts{'d'} && !( $sec_opts{'e'} && $postload ) )
                    {
                        my $rc = 0xffff & system($comm);
                        if ( $rc != 0 )
                        {
                            &log( sprintf "system(%s) failed. Return code: %#04x: ", $comm, $rc );
                        }
                        else
                        {
                            &log( sprintf "system(%s) succeeded. Return code: %#04x: ", $comm, $rc )
                              if ( $config{'debug'} > 0 );
                        }
                    }
                }
            }
            else
            {
                &cmd($_);
            }
        }
    }
    elsif ( $line eq "Exit: Wolf EndRound." || $line eq "Exit: Timelimit hit." )
    {

        # Round ends, intermission starts
        &log("Round ends.");
        $running      = 0;
        $intermission = 1;

        &global_remote_send( "Intermission starts", "ETM-INFO" );

        if ( $config{'spree_detector'} )
        {

            # find unfinished killing sprees.
            foreach my $player_id ( keys %tmphash )
            {
                &killing_spree_check( $player_id, -1 );
            }
        }

        if ( $config{'last_blood'} && $last_blood )
        {
            &say(
                  "$config{'spree_color'}And the final "
                    . "kill of this round goes to: ^7$last_blood$config{'spree_color'}!",
                  $position{'last_blood'}
                );
        }

        if ( $config{'longest_spree_display'}
             && ( $best_spree{'currmap'}{'value'} > 0 || $best_spree{'map'}{'value'} > 0 ) )
        {
            if ( !$config{'persistent_map_spree_record'} )    # Default
            {
                &say(   "$config{'spree_color'}Longest map spree: ^7$best_spree{'map'}{'name'} "
                      . "$config{'spree_color'}with ^7$best_spree{'map'}{'value'}$config{'spree_color'} "
                      . "kills [$config{'spree_color'}record: ^7$best_spree{'alltime'}{'name'} "
                      . "$config{'spree_color'}(^7$best_spree{'alltime'}{'value'}$config{'spree_color'})]" );
            }
            elsif ( $config{'persistent_map_spree_record'} == 2 )
            {
                &say(   "$config{'spree_color'}Longest map spree: ^7$best_spree{'currmap'}{'name'} "
                      . "$config{'spree_color'}with ^7$best_spree{'currmap'}{'value'}$config{'spree_color'} "
                      . "kills [maprecord: "
                      . "^7$best_spree{'map'}{'name'} "
                      . "$config{'spree_color'}(^7$best_spree{'map'}{'value'}$config{'spree_color'})@^7"
                      . &time2date( $best_spree{'map'}{'timestamp'} )
                      . "$config{'spree_color'}]" );
            }
            else
            {
                &say(   "$config{'spree_color'}Longest map spree: ^7$best_spree{'map'}{'name'} "
                      . "$config{'spree_color'}with ^7$best_spree{'map'}{'value'}$config{'spree_color'} "
                      . "kills @ ^7"
                      . &time2date( $best_spree{'map'}{'timestamp'} )
                      . $config{'spree_color'}."[record: "
                      . "^7".$best_spree{'alltime'}{'name'}
                      . " $config{'spree_color'}(^7$best_spree{'alltime'}{'value'}$config{'spree_color'})]" );
            }
        }

        for (@rcon_cmds_intermission)
        {
            &log("Executing $_");
            if (/^(rcon|ext)\s*:\s*(.*)$/)
            {
                my $type = $1;
                my $comm = $2;
                &log("Executing: ($type) -> $comm");
                if ( $type eq "rcon" )
                {
                    &cmd($comm);
                }
                elsif ( $type eq "ext" )
                {
                    if ( !$sec_opts{'d'} && !( $sec_opts{'e'} && $postload ) )
                    {
                        my $rc = 0xffff & system($comm);
                        if ( $rc != 0 )
                        {
                            &log( sprintf "system(%s) failed. Return code: %#04x: ", $comm, $rc );
                        }
                        else
                        {
                            &log( sprintf "system(%s) succeeded. Return code: %#04x: ", $comm, $rc )
                              if ( $config{'debug'} > 0 );
                        }
                    }
                }
            }
            else
            {
                &cmd($_);
            }
        }

        if ( $config{'intermission_mapvoting'} )
        {
            &say(   "^3mapvote: ^7You have now time to vote for the next map. Type "
                  . $config{'command_prefix'}
                  . "mapvote <mapname> to vote!" );
            &say( "^3mapvote: ^7Available maps: " . join( " ", @maps ) );

            # Reset vote and initialize hash
            %map = ();
            for (@maps) { $map{$_} = 0; }
            $mapvote{'time'}  = time;
            $mapvote{'state'} = 1;
            &log("Starting Intermission Map voting.");
        }
    }
    elsif ( $config{'teamkill_restriction'} && $running && $line =~ /^Medic_Revive: (\d+) (\d+)/ )
    {

        #if ( !( defined( $admins{ $tmphash{$1}{'guid'} } ) && $config{'tk_except_admins'} ) )    # except admins
        if ( &get_admin_level( $admins{ $tmphash{$1}{'guid'} } ) == 0 || !$config{'tk_except_admins'} )
        {
            if (    $tk_hash{ $tmphash{$1}{'guid'} }{'value'} < $config{'tk_upper_limit'}
                 && $tmphash{$1}{'team'} > 0 )
            {

                # Kill revive? Or normal revive ?
                if ( $tmphash{$1}{'last_victim'}{'id'} == $2 )
                {
                    $tk_hash{ $tmphash{$1}{'guid'} }{'value'} += 1;
                    &log( "TK: Revive: $1, -> +1 = " . " $tk_hash{$tmphash{$1}{'guid'}}{'value'}" )
                      if ( $config{'debug'} );
                }
                else
                {
                    $tk_hash{ $tmphash{$1}{'guid'} }{'value'} += $config{'tk_kill_bonus'};
                    &log(   "TK: Revive: $1, -> +"
                          . $config{'tk_kill_bonus'} . " = "
                          . " $tk_hash{$tmphash{$1}{'guid'}}{'value'}" )
                      if ( $config{'debug'} );
                }

                $tk_hash{ $tmphash{$1}{'guid'} }{'value'} = $config{'tk_upper_limit'}
                  if ( $tk_hash{ $tmphash{$1}{'guid'} }{'value'} > $config{'tk_upper_limit'} );
            }
        }

    }
    elsif ( $line =~ /Kill: (\d+) (\d+) (\d+): (.+) killed (.+) by MOD_([A-Z_0-9]+)/i )
    {

        my $killer_id   = $1;
        my $killed_id   = $2;
        my $weapon_id   = $3;
        my $killer_name = $4;
        my $killed_name = $5;
        my $weapon_name = $6;
	my $weapon_name_short = $weapon_name;
        my %soundhash   = ();
        my $target      = $config{'et_mod'} == 1 ? "" : -1;

	$weapon_name_short    =~ s/^MOD_//;
        $soundhash{'command'} = "";
        $soundhash{'amount'}  = 0;

        if ( !defined( $mod_weapon{$weapon_id} ) )
        {
            &log("Found new weapon: $weapon_id -> $weapon_name");
            $mod_weapon{$weapon_id} = $weapon_name;
        }

        # For replacements
        $tmphash{$killed_id}{'last_killer'}{'id'}        = $killer_id;
        $tmphash{$killed_id}{'last_killer'}{'weapon_id'} = $weapon_id;
        $tmphash{$killer_id}{'last_victim'}{'id'}        = $killed_id;
        $tmphash{$killer_id}{'last_victim'}{'weapon_id'} = $weapon_id;

        if ( $config{'suicide_limit'} )
        {

            # Suicides
            if ( $weapon_id == 37 )
            {

                # Suicide
                $tmphash{$killer_id}{'suicides'}++;
                if ( $config{'suicide_limit'} < $tmphash{$killer_id}{'suicides'} )
                {

                    # Limit reached
                    &log("Suicide limit reached: $killer_name ($tmphash{$killer_id}{'suicides'})");
                    if ( !$config{'suicide_nokick'} )
                    {
                        &say( "^1*ATTENTION*:^7 $killer_name ^7made more selfkills, then allowed -> ^1kick^7",
                              $position{'suicide_warnings'} );
                        &kick( $killer_id, "you made more selfkills then allowed." );
                    }
                    else
                    {
                        &say(
                              "^1*ATTENTION*:^7 $killer_name ^7made more selfkills, "
                                . "then allowed -> ^1Moving to spectator...^7",
                              $position{'suicide_warnings'}
                            );
                        &cmd("forceteam $killer_id s");
                    }
                }
                elsif (
                      $config{'suicide_limit'} * $config{'suicide_warn_percentage'} < $tmphash{$killer_id}{'suicides'} )
                {

                    # Limit nearly reached;
                    &log("Suicide limit nearly reached: $killer_name ($tmphash{$killer_id}{'suicides'})");
                    &say(
                          "^1*WARNING*^7: $killer_name^7, you have ^2"
                            . ( $config{'suicide_limit'} - $tmphash{$killer_id}{'suicides'} )
                            . "^7 suicides left!"
                            . (
                                $tmphash{$killer_id}{'suicides'} == $config{'suicide_limit'}
                                ? " ^7Next ^3/kill ^7= ^1kick^7."
                                : ""
                              ),
                          $position{'suicide_warnings'}
                        );
                    &global_remote_send( "Warned: $killer_name ^;(nearly reached suicide limit)", "ETM-WARN" );
                }
            }
        }

        $tmphash{$killed_id}{'disguise'} = '';

        # Death spree messages.
        if (
             $config{'death_spree_detector'}
             && (    $tmphash{$killer_id}{'team'} != $tmphash{$killed_id}{'team'}
                  || $killed_id == $killer_id )
           )
        {

            # I count suicides... ;)

            # death spree ends.
            # but i dont care
            $tmphash{$killed_id}{'deaths'}++;
            $tmphash{$killer_id}{'deaths'} = 0 if ( $killed_id ne $killer_id );
            &log("Killed: $killed_name ($tmphash{$killed_id}{'deaths'}) by $killer_name")
              if ( $config{'debug'} > 1 );

            foreach my $s ( keys %spree )
            {
                if ( $tmphash{$killed_id}{'deaths'} == ( -1 * $spree{$s} ) )
                {
                    my $message = $spree_messages{$s};
                    $message =~ s/<PLAYER>/$killed_name/g;
                    $message =~ s/<DEATHS>/$tmphash{$killed_id}{'deaths'}/g;

                    &log("$killed_name is on a deathspree - $tmphash{$killed_id}{'deaths'} deaths");
                    &say( $message, $position{ 's_' . $s } ) if ($message);
                    last;
                }
            }
        }

        # 1022 == <world>
        if ( $killer_id != 1022 && $tmphash{$killer_id}{'team'} != $tmphash{$killed_id}{'team'} )
        {

            if ( $config{'first_blood'} && !$first_blood )
            {
                &say( "$killer_name ^1drew ^1first ^1BLOOD ^1!", $position{'first_blood'} );
                if ( $config{'spree_sounds'} )
                {

                    #&cmd("playsound $killer_id ");
                    $soundhash{'command'} .= "playsound $killer_id sound/misc/firstblood.wav ;";
                    $soundhash{'amount'}++;
                }

                $first_blood = 1;
                &log("First blood: $killer_name\n");
            }
            $last_blood = $tmphash{$killer_id}{'name'};
            $gamestart  = 1;

            $tmphash{$killer_id}{'kills'}++;
            &log(   "Kill: $killer_name ($tmphash{$killer_id}{'kills'}) -> "
                  . "$killed_name ($tmphash{$killed_id}{'kills'})" )
              if ( $config{'debug'} );

            # It's a kill and a death, count it!
            if ( $config{'simple_stats'} )
            {
                $tmphash{$killer_id}{'overall'}{'kills'}++;
                $tmphash{$killed_id}{'overall'}{'deaths'}++;
            }

            &global_remote_send(
                                 "KILL: $killer_name ^;("
                                   . $tmphash{$killer_id}{'kills'}
                                   . ") -> $killed_name ^;($tmphash{$killed_id}{'deaths'}) ^;by $weapon_name_short",
                                 "ETM-KILL:KILL"
                               );

            if ( $config{'multikill_detector'} || $config{'monsterkill_detector'} )
            {

                if ( time - $tmphash{$killer_id}{'multikill'}{'timestamp'} <= 3 )
                {
                    $tmphash{$killer_id}{'multikill'}{'amount'}++;

                    # multi kill
                    if ( $tmphash{$killer_id}{'multikill'}{'amount'} == 3 && $config{'multikill_detector'} )
                    {

                        # MULTIKILL !!!!
                        &say("^7!!!! ^1Multikill ^7> ^7$killer_name ^7< ^1Multikill^7 !!!!", $position{'multikill'});

                        if ( $config{'spree_sounds'} )
                        {
                            #$soundhash{'command'} .= "playsound $target sound/misc/multikill.wav ;";
                            #$soundhash{'amount'}++;

                            &cmd("playsound $target sound/misc/multikill.wav");
                        }
                        &log("Multikill: $killer_id ($tmphash{$killer_id}{'multikill'}{'amount'})");
                    }
                    elsif (    $tmphash{$killer_id}{'multikill'}{'amount'} == 5
                            && $config{'monsterkill_detector'} )
                    {

                        # MONSTERKILL !!!!
                        if ( $config{'spree_sounds'} )
                        {
                            #$soundhash{'command'} .= "playsound $target sound/misc/monsterkill.wav ;";
                            #$soundhash{'amount'}++;

                            &cmd("playsound $target sound/misc/monsterkill.wav");
                        }
                        else
                        {
                            #&say( "^1MONSTERKILL ^7>>> ^7$killer_name ^7<<< ^1MONSTER KILL", "cp" );
                        }
                        &say("^1OMG, MONSTERKILL ^7>>> ^7$killer_name ^7<<< ^1MONSTER KILL^7 !!!!", $position{'monsterkill'} ? $position{'monsterkill'} : "cp");
                        &log("Monsterkill: $killer_id ($tmphash{$killer_id}{'multikill'}{'amount'})");
                    }
                }
                else
                {
                    $tmphash{$killer_id}{'multikill'}{'amount'} = 1;
                }

                $tmphash{$killer_id}{'multikill'}{'timestamp'} = time;

            }

            # Spree counter activ ?
            if ( $config{'spree_detector'} )
            {

                if ( $config{'spree_detector'} && $tmphash{$killed_id}{'kills'} > 0 )
                {
                    &killing_spree_check( $killed_id, $killer_id );
                }

                if ( $tmphash{$killer_id}{'kills'} >= $spree{'spree'} )
                {
                    foreach my $s ( keys %spree )
                    {
                        if ( $tmphash{$killer_id}{'kills'} eq $spree{$s} )
                        {

                            &log("Spree ($s) of $killer_name");
                            my $message = $spree_messages{$s};
                            $message =~ s/<PLAYER>/$killer_name/g;
                            $message =~ s/<KILLS>/$tmphash{$killer_id}{'kills'}/g;

                            #&log ("$message - ".$position{'s_'.$s});
                            if ( $config{'spree_sounds'} )
                            {

                                if ( $s eq "spree" )
                                {
                                    #$soundhash{'command'} .= "playsound $killer_id sound/misc/killingspree.wav ;";
                                    #$soundhash{'amount'}++;

                                    &cmd("playsound $killer_id sound/misc/killingspree.wav");
                                }
                                elsif ( $s eq "rampage" )
                                {
                                    #$soundhash{'command'} .= "playsound $killer_id sound/misc/rampage.wav ;";
                                    #$soundhash{'amount'}++;

                                    &cmd("playsound $killer_id sound/misc/rampage.wav");
                                }
                                elsif ( $s eq "dominating" )
                                {
                                    #$soundhash{'command'} .= "playsound $killer_id sound/misc/dominating.wav ;";
                                    #$soundhash{'amount'}++;

                                    &cmd("playsound $killer_id sound/misc/dominating.wav");
                                }
                                elsif ( $s eq "godlike" )
                                {
                                    #$soundhash{'command'} .= "playsound $killer_id sound/misc/godlike.wav ;";
                                    #$soundhash{'amount'}++;

                                    &cmd("playsound $killer_id sound/misc/godlike.wav");
                                }
                                elsif ( $s eq "unstoppable" )
                                {
                                    #$soundhash{'command'} .= "playsound $killer_id sound/misc/unstoppable.wav ;";
                                    #$soundhash{'amount'}++;

                                    &cmd("playsound $killer_id sound/misc/unstoppable.wav");
                                }
                                elsif ( $s eq "wicked" )
                                {
                                    #$soundhash{'command'} .= "playsound $killer_id sound/misc/wicked.wav ;";
                                    #$soundhash{'amount'}++;

                                    &cmd("playsound $killer_id sound/misc/wickedsick.wav");
                                }
                            }

                            # print out message (maybe short delay to overlay the kill message).
                            select( undef, undef, undef, $spree_delay )
                              if ( $config{'input_type'} eq "udp" && $position{ "s_" . $s } eq "cp" );
                            &say( $message, $position{ 's_' . $s } );
                            last;
                        }
                    }

                }

            }


            # Knifekill sound?
            if ( $weapon_id == 6 && $config{'knife_kill_sound'} )
            {

                #&log("Playing knife_kill_sound: playsound $target $config{'knife_kill_soundfile'}");
                if ( $config{'knife_kill_sound'} == 3 )
                {

                    #my $target = $config{'et_mod'} == 1 ? -1 : "";
                    $soundhash{'command'} .= "playsound $target $config{'knife_kill_soundfile'} ;";
                    $soundhash{'amount'}++;

                    #&cmd("playsound $target $config{'knife_kill_soundfile'}");
                }
                else
                {
                    if ( $config{'knife_kill_sound'} == 2 )
                    {

                        # == 2, victim + attacker
                        $soundhash{'command'} .=
                            "playsound $killer_id $config{'knife_kill_soundfile'} ;"
                          . "playsound $killed_id $config{'knife_kill_soundfile'} ;";
                        $soundhash{'amount'} += 2;

                    }
                    else
                    {

                        # == 1, victim only
                        $soundhash{'command'} .= "playsound $killed_id $config{'knife_kill_soundfile'} ;";
                        $soundhash{'amount'}++;
                    }
                }
            }

            # Play sound ...
            if ( $soundhash{'amount'} > 0 )
            {
                chop $soundhash{'command'};    # remove last ";"
                    #&log("Sound: Amount: $soundhash{'amount'}, Command: $soundhash{'command'}");

                if ( $soundhash{'amount'} == 1 )
                {
                    &cmd( $soundhash{'command'} );
                }
                else
                {
                    # more then one, so lets do it together.
                    &cmd("set etadmin \"$soundhash{'command'}\"");
                    &cmd("vstr etadmin");
                }
            }

        }
        else
        {
            if ( $killer_id == $killed_id || $killer_id == 1022 )
            {
                &log("Suicide: ($killed_name)")               if ( $config{'debug'} );
                $tmphash{$killed_id}{'overall'}{'suicides'}++ if ( $config{'simple_stats'} );

                #print $tmphash{$killed_id}{'overall'}{'suicides'} . "\n";
                &global_remote_send( "SUICIDE: $killed_name ^;($tmphash{$killed_id}{'deaths'})", "ETM-KILL:SUICIDE" );

            }
            elsif ( $tmphash{$killer_id}{team} > 0 && $tmphash{$killer_id}{team} < 3 && $killer_id ne 1022 )
            {
                if ( $config{'simple_stats'} )
                {
                    $tmphash{$killer_id}{'overall'}{'teamkills'}++;
                    $tmphash{$killed_id}{'overall'}{'teamdeaths'}++;
                }

                &log("TK ($killer_name -> $killed_name)") if ( $config{'debug'} );
                &global_remote_send(
                                     "TK: $killer_name ^;("
                                       . $tmphash{$killed_id}{'kills'}
                                       . ") -> $killed_name ^;($tmphash{$killed_id}{'deaths'}) ^;by $weapon_name_short",
                                     "ETM-KILL:TK"
                                   );
            }

            # Reset kills on selfkill.
            $tmphash{$killed_id}{'kills'} = 0;
        }

        # else TK

        # TEAMKILL RESTRICTION:
        if ( $config{'teamkill_restriction'}
             && ( &get_admin_level( $tmphash{$killer_id}{'guid'} ) == 0 || !( $config{'tk_except_admins'} ) ) )
        {
            my $old_value = $tk_hash{ $tmphash{$killer_id}{'guid'} }{'value'};

            # TEST START
            $tk_hash{ $tmphash{$killer_id}{'guid'} }{'timestamp'} = time;
            if (    ( $tmphash{$killer_id}{'team'} > 0 && $tmphash{$killer_id}{'team'} < 3 )
                 && $tmphash{$killer_id}{'team'} == $tmphash{$killed_id}{'team'}
                 && $killed_id != $killer_id )
            {

                # TK
                if (    $weapon_name eq "ARTY"
                     || $weapon_name eq "AIRSTRIKE"
                     || $tmphash{$killed_id}{'disguise'} )
                {
                    &log("TK: ARTI/AIRS/COV: -0.5") if ( $config{'debug'} > 1 );
                    $tk_hash{ $tmphash{$killer_id}{'guid'} }{'value'} -= 0.65;
                }
                elsif (    $weapon_name eq "PANZERFAUST"
                        || $weapon_name eq "MORTAR"
                        || $weapon_name eq "MAPMORTAR_SPLASH"
                        || $weapon_name eq "MG42"
                        || $weapon_name eq "GRENADE_LAUNCHER"
                        || $weapon_name eq "GPG40"
                        || $weapon_name eq "M7" )
                {
                    &log("TK: HW: -0.75") if ( $config{'debug'} > 1 );
                    $tk_hash{ $tmphash{$killer_id}{'guid'} }{'value'} -= 0.75;
                }
                elsif ( $weapon_name ne "LANDMINE" && $weapon_name ne "DYNAMITE" )
                {
                    &log("Tk: Normal: -1") if ( $config{'debug'} > 1 );
                    $tk_hash{ $tmphash{$killer_id}{'guid'} }{'value'} -= 1;
                }
                else
                {
                    &log("TK without index change.") if ( $config{'debug'} > 1 );
                }
                $tk_hash{ $tmphash{$killer_id}{'guid'} }{'value'} = $config{'tk_upper_limit'}
                  if ( $tk_hash{ $tmphash{$killer_id}{'guid'} }{'value'} > $config{'tk_upper_limit'} );

            }
            elsif (    $tmphash{$killer_id}{'team'} > 0
                    && $tmphash{$killed_id}{'team'} > 0
                    && $tmphash{$killer_id}{'team'} != $tmphash{$killed_id}{'team'} )
            {

                # Normal kill
                $tk_hash{ $tmphash{$killer_id}{'guid'} }{'value'} += $config{'tk_kill_bonus'}
                  if ( $tk_hash{ $tmphash{$killer_id}{'guid'} }{'value'} < $config{'tk_upper_limit'} );
                $tk_hash{ $tmphash{$killer_id}{'guid'} }{'value'} = $config{'tk_upper_limit'}
                  if ( $tk_hash{ $tmphash{$killer_id}{'guid'} }{'value'} > $config{'tk_upper_limit'} );
            }
            &log(   "TK Index ($killer_name, $killer_id): "
                  . "$tk_hash{$tmphash{$killer_id}{'guid'}}{'value'} (Old: $old_value) with $weapon_name" )
              if (    defined( $tk_hash{ $tmphash{$killer_id}{'guid'} }{'value'} )
                   && $config{'debug'}
                   && $tk_hash{ $tmphash{$killer_id}{'guid'} }{'value'} != $old_value );

            if ( $old_value > $tk_hash{ $tmphash{$killer_id}{'guid'} }{'value'} )
            {
                if ( $tk_hash{ $tmphash{$killer_id}{'guid'} }{'value'} < $config{'tk_lower_limit'} )
                {

                    # Second warning !
                    &log(   "TK. Kicked $killer_id ($killer_name). "
                          . "TK Index: $tk_hash{$tmphash{$killer_id}{'guid'}}{'value'}" );
                    if ( $config{'tk_warnonly'} )
                    {

                        &say( "^1STOP TEAMKILLING NOW^7, $killer_name^7! Play ^3fair or ^2leave^7!",
                              "chatclient", $killer_id );
                        &global_remote_send( "Warned: $killer_name ^;(made too many TK's)", "ETM-WARN" );
                        $tk_hash{ $tmphash{$killer_id}{'guid'} }{'value'} = $config{'tk_lower_limit'} + 1;
                    }
                    else
                    {
                        &say(
                              "^1That does it. I kick you ^1NOW^7, $killer_name^7! "
                                . "Your TK Index: $tk_hash{$tmphash{$killer_id}{'guid'}}{'value'}!",
                              "chatclient",
                              $killer_id
                            );
                        $tk_hash{ $tmphash{$killer_id}{'guid'} }{'value'} = 0;
                        &kick( $killer_id, "You made too many TKs", 1 );
                    }

                }
                elsif ( $tk_hash{ $tmphash{$killer_id}{'guid'} }{'value'} < ( $config{'tk_lower_limit'} + 1 ) )
                {

                    # First warning
                    &log(   "Issued warning to $killer_id($killer_name). "
                          . "TK Index: $tk_hash{$tmphash{$killer_id}{'guid'}}{'value'}" );
                    &say( "^1WARNING:^7Stop making ^1teamkills^7 or you will get yourself into trouble!",
                          "chatclient", $killer_id );
                    &global_remote_send(
                                         "Warned: $killer_name ^;(makes too many TK's (tk_index: "
                                           . $tk_hash{ $tmphash{$killer_id}{'guid'} }{'value'} . " ))",
                                         "ETM-WARN"
                                       );

                }
            }

            # TEST END
        }
    }
    elsif ( $config{'et_mod'} == 2 && index( $line, "etpro IAC:" ) == 0 )
    {

        # etpro IAC: 3 GUID [364C8851304B1738B01C3EA37A12C08BDC4FXXXX] [kils tor]
        # Win98 GUID: 52FF6283916A9467908E6A771CB70285FB41C5E7
        # etpro IAC: 2 GUID [9E0134C28093C01FE8B91508A2267FE2DEEC1872] [^8-=^d[^8VP^d]^lH.^oPo^nTT^3eR^8=-]
        if ( $line =~ /^etpro IAC: (\d+) GUID \[(\w+)?\] \[(.*?)\]$/ )
        {

            my $client_id   = $1;
            my $etpro_guid  = $2;
            my $client_name = $3;

            &log("Client: $client_name - etpro guid: $etpro_guid - slot: $client_id")
              if ( $config{'debug'} );
            $tmphash{$client_id}{'etpro_guid'} = $etpro_guid;

            if ( $config{'manage_bans'} && defined( $etpro_bans{$etpro_guid} ) )
            {

                my $guid = $etpro_bans{$etpro_guid};

                # shrub counts from the 1.1.2000, not from 1.1.1970 ?!?!
                my $timestamp = $config{'ban_timestamp_format'} eq "shrub" ? ( time - 946767600 ) : time;

                if ( ( $bans{$guid}{'expires'} == 0 || $bans{$guid}{'expires'} > $timestamp ) )
                {

                    # BANNED USER
                    &kick(
                           $client_id,
                           "You are "
                             . ( $bans{$guid}{'expires'} > 0 ? "temporarly " : "permanently " )
                             . "banned. Reason: $bans{$guid}{'reason'}",
                           1
                         );

                    #&say( "^3banned user: $name ^3kicked. (Reason: " . $bans{$guid}{'reason'} . ")" );
                    &log(   "Kicking banned user: "
                          . &convert_name( $client_name, 0, 0 )
                          . "(GUID: $guid($etpro_guid), Reason: $bans{$guid}{'reason'}" );

                }
                else
                {

                    # BAN expired, removing
                    &log("Ban for $etpro_guid( ($client_name) expired.");
                    &shrub_ban( $config{'shrubbot_cfg'}, "remove", $guid );
                    delete $bans{$guid};
                    delete $etpro_bans{$etpro_guid};
                }
            }
            else
            {

                # OK, check mute state if automute is activated.
                &check_mute_state( $client_id, $etpro_guid ) if ( $config{'automute'} );
            }
        }

        #else
        #{
        #    &log("Wrong IAC line. Changed format?");
        #}

    }
    elsif (
               $line =~ /^say: (.+): \Q$config{'command_prefix'}\E(.+)$/
            || ( $config{'et_mod'} == 1 && $line =~ /^sayc: \d+: (.+): \Q$config{'command_prefix'}\E(.+)/ )
            || ( $config{'et_mod'} == 1 && $line =~ /^saybuddy: (.+): \Q$config{'command_prefix'}\E(.+)$/ )
            || (    $config{'et_mod'} == 2
                 && $line =~ /^etpro privmsg: (.+)? to [^:]+: \Q$config{'command_prefix'}\E(.+)$/ )
          )
    {

        # shrub (g_logoptions 192):
        #sayc: 0: ^7[^4d1p^7]^1H. ^3Potter: test

        # etpro privmsg:
        #etpro privmsg: ^7[^4d1p^7]^1H. ^3Potter to pot: test

        # etpro / etmain / shrub:
        #say: ^0[^1U^4niteD^0]^2H.^3Potter: !seen someone
        #say: ^1wip^4e^2out: omg

        my $name           = $1;
        my $command_string = $2;
        my $guid           = $userinfo{$name};
        my $client_id      = &name2client_id($name);

        #next if ( index( $line, "etpro privmsg:" ) == 0 && !&admin_check( $guid, "silentcommands", "game" ) );
        next
          if ( ( index( $line, "etpro privmsg:" ) == 0 || index( $line, "saybuddy:" ) == 0 )
               && !&admin_check( $guid, "silentcommands", "game" ) );

        if ( !&mute_check( $command_string, $client_id ) )
        {
            &admin_command( $line, $name, $command_string, "game" );
        }

    }
    elsif (    $config{'automute'}
            && $config{'et_mod'} == 2
            && ( $line =~ /^say: (.+): (.+)$/ || $line =~ /^sayteam: (.+): (.+)$/ || $line =~ /^saybuddy: (.+): (.+)$/) )
    {

        my $name       = $1;
        my $chatstring = $2;
        my $client_id  = &name2client_id($name);

        &mute_check( $chatstring, $client_id );

    }

    # its time to cancel all "shuffle and restarts"
    elsif (    $line =~ /^Callvote: (\d+)/
            || $line =~ /^broadcast: print "(.*)\^7 called a vote.  Voting for: (.*?)\s*\\n"/ )
    {

        my $client_id;
        my $map_vote = 0;
        my $vote;
        my $name;

        if ( $1 && $2 )
        {

            #etpro:
            #broadcast: print "^4[^jbd^4] S^1cow^4L^7 called a vote.  Voting for: Swap Teams \n"

            # ETPRO
            $vote      = $2;
            $name      = &strip_name($1);
            $client_id = &name2client_id($name);
            &log("Vote: $vote, CID: $client_id, Name: $name") if ( $config{'debug'} );

        }
        else
        {

            #shrub:
            #Callvote: 2: ^1*^3MoD^1*^0KickAssChris called a vote: Map Restart

            # SHRUB / HEADSHOT
            $client_id = $1;
            $name      = $tmphash{$client_id}{'name'};
            $line =~ /called a vote: (.*?)\s*$/;
            $vote = $1;
        }

        &log("Vote called: $vote (by $name)");
        &global_remote_send( "$name ^;called a vote: $vote", "ETM-VOTE" );

        if (    $vote eq "Shuffle Teams by XP"
             || $vote eq "Load Next Map"
             || $vote eq "Swap Teams"
             || $vote eq "Match Reset"
             || $vote eq "Map Restart" )
        {
            $map_vote = 1;
        }
        else
        {
            if ( $vote =~ /^([a-zA-Z_-]+?)\s(.*)/ )
            {
                my $type   = $1;
                my $target = &name2client_id($2);
                if ( ( $type eq "KICK" || $type eq "MUTE" )
                     && &get_admin_level( $tmphash{$target}{'guid'} ) > 0 )
                {
                    &cancelvote( $line, 0,
                           "You can't ^1$type^7 a " . $level{ &get_admin_level( $tmphash{$target}{'guid'} ) } . "^7!" );
                    &log("Canceled vote to $vote");
                    next;
                }
                elsif ( $type eq "UN-MUTE" && $tmphash{$target}{'pmuted'} == 1 )
                {
                    &cancelvote( $line, 0, "^3pmute: ^7You can't ^1$type^7 a permanently muted user!" );
                    &log("Canceled vote to $vote");
                    next;
                }
                elsif ($config{'cancel_standardmap_votes'} && $vote  =~ /Change map to (radar|battery|railgun|goldrush|fueldump|oasis)/ ) {
                    
                    if (    $config{'cancel_adminlevel'}
                     	&& &get_admin_level( $tmphash{$client_id}{'guid'} ) >= $config{'cancel_adminlevel'} ){
                    	&log("Admin voted to $vote");
                    }
                    else {
                    	&cancelvote( $line, 0, "^3mute: ^7You are not allowed to vote for a map from the standard mappool." );
                    	&log("Canceled vote to $vote");
                    }
                    next;
               }
            }
        }

#&log("Running: $running, Mapvote: $map_vote, Vote: $vote, Admin Level: ". &get_admin_level( $tmphash{$client_id}{'guid'}) );

        if ( $running == 1 || ( $running == 2 && !$map_vote ) )
        {

            # If nicht allow_vote_minutes, dann einfach weiter...
            next unless ( $config{'allow_vote_minutes'} );

            # Count the votes
            if ( !$vote_times{$vote}
                 || ( $vote_times{$vote} < ( time - $config{'allow_vote_minutes'} * 60 ) ) )
            {
                $vote_times{$vote} = time;

                # und vote passieren lassen.
                &log("Updated timestamp for vote: $vote") if ( $config{'debug'} );
            }
            else
            {
                &log("Vote already cast in the last $config{'allow_vote_minutes'} minutes.");
                if (    $config{'cancel_adminlevel'}
                     && &get_admin_level( $tmphash{$client_id}{'guid'} ) >= $config{'cancel_adminlevel'} )
                {

                    # Admin Vote ... Die duerfen das.
                    $vote_times{$vote} = time;
                    &log( "Admin started vote: " . &get_admin_level( $tmphash{$client_id}{'guid'} ) )
                      if ( &get_admin_level( $tmphash{$client_id}{'guid'} ) && $config{'debug'} );
                }
                else
                {

                    # Cancel vote !
                    &cancelvote(
                                 $line,
                                 0,
                                 "^7This vote didn't pass the last time! "
                                   . "Please wait at least ^1$config{'allow_vote_minutes'} ^7minutes before trying again!"
                               );

                }
            }
        }
        elsif (    $running == 2
                && $map_vote
                && &get_admin_level( $tmphash{$client_id}{'guid'} ) == 0 )
        {

            &cancelvote($line);

        }
        else
        {

            if ( $config{'debug'} )
            {
                &log( "Admin started vote: $vote - (" . &get_admin_level( $tmphash{$client_id}{'guid'} ) . ")" )
                  if ( &get_admin_level( $tmphash{$client_id}{'guid'} ) > 0 );
                &log( "Vote from: $tmphash{$client_id}{name} " . "($tmphash{$client_id}{guid})" )
                  if ( defined( $tmphash{$client_id} ) );
            }
            &log("Good Vote: $line");

        }

    }
    elsif ( $line =~ /^SBLoadConfig: Loaded \d+ admins/ || $line eq "!readconfig" )
    {
        &reload_config_file();
    }

    # Hammer - Begin XP reset code
    elsif (    $config{'et_mod'} == 1
            && $config{'xp_limit'} > 0
            && $line =~ /^score:\s+(\d+)\s+ping:\s+\d+\s+client:\s+(\d+)\s+(.+)/ )
    {
        if ( $1 >= $config{'xp_limit'} )
        {
            sleep 1;
            &say( "^3Server XP Limit ($config{'xp_limit'}) reached.", "chatclient", $2 );
            &cmd("!resetxp $2 Server XP Limit Reached");
            &log("XP Limit Reset: Player: $2 ($3)  XP: $1");
        }
        elsif ( $config{'xp_warn_limit'} && $1 >= $config{'xp_warn_limit'} )
        {
            sleep 1;
            &say(
                  "^3Warning: ^8You are approaching the server limit of $config{'xp_limit'} XP.   "
                    . "Your XP will be reset when the limit of "
                    . $config{'xp_limit'}
                    . " is reached.",
                  "chatclient",
                  $2
                );
            &log("XP Limit Warning: Player: $2 ($3)  XP: $1");
        }
    }

    # Hammer - END XP reset code

    # Do display warnings, and everyting else.
    &timebased_functions();

    # DO NOT REMOVE THE FOLLOWING LINES, PLEASE !
    if ( $lines > 40000 )
    {
        $lines = 0;
        &say( "This server is running ^3etadmin_mod " . "v$version^7. Visit ^3et.d1p.de^7 for details." );
    }
}

sub load_map_spree
{

    $best_spree{'map'}{'name'}      = "Nobody";
    $best_spree{'map'}{'timestamp'} = time;
    $best_spree{'map'}{'value'}     = 0;

    $best_spree{'currmap'}{'name'}      = "Nobody";
    $best_spree{'currmap'}{'timestamp'} = time;
    $best_spree{'currmap'}{'value'}     = 0;

    if ( $config{'persistent_map_spree_record'} )
    {

        if ( -s "var/${mapname}_spree_record.dat" )
        {
            open( IN, "var/${mapname}_spree_record.dat" );
            my $counter = 0;

            while (<IN>)
            {
                chomp;
                if ( $counter == 0 )
                {
                    $best_spree{'map'}{'name'} = $_;
                }
                elsif ( $counter == 1 )
                {
                    $best_spree{'map'}{'value'} = $_;
                }
                elsif ( $counter == 2 )
                {
                    $best_spree{'map'}{'timestamp'} = $_;
                }
                elsif ( $counter > 2 )
                {
                    last;
                }
                $counter++;
            }
            close(IN);
            &log(   "Loaded old spree_record for map $mapname ($best_spree{'map'}{'name'}, "
                  . "$best_spree{'map'}{'value'}, "
                  . &time2date( $best_spree{'map'}{'timestamp'} )
                  . ")..." );
        }
        else
        {
            &log("No previous spree record found.");
        }

    }
}

sub save_map_spree
{
    if ( $config{'persistent_map_spree_record'} )
    {

        if ( ${mapname} )
        {    # This shouldn't happen, but is possible in my test environment. Check doesn't hurt!
                # saving result
            open( OUT, ">var/${mapname}_spree_record.dat" ) or &log("Error writing persistant spree_record: $!");
            print OUT $best_spree{'map'}{'name'} . "\n";
            print OUT $best_spree{'map'}{'value'} . "\n";
            print OUT $best_spree{'map'}{'timestamp'} . "\n";
            close(OUT);
        }
    }
}

sub mute_check
{

    my $chatstring = shift;
    my $client_id  = shift;

    if ( $client_id > -1 && !$tmphash{$client_id}{'muted'} == 1 )
    {

        unless ( &get_admin_level( $tmphash{$client_id}{'guid'} ) >= $config{'automute_override_lvl'} )
        {

            if ( &word_check($chatstring) )
            {

                # oO, $client_id used a bad word;
                if ( !defined( $tmphash{$client_id}{'bad_word'} ) )
                {

                    # First warning
                    &say( "^3automute: ^1This is your first and last warning. Don't use " . "bad words on this server.",
                          "chatclient", $client_id );
                    $tmphash{$client_id}{'bad_word'} = 1;
                    &log("Automute. First Warning for: $tmphash{$client_id}{'name'} (Slot: $client_id)");
                }
                else
                {

                    # Next warning
                    &say(   "^3automute: ^7"
                          . $tmphash{$client_id}{'name'}
                          . " ^7used abusive language. "
                          . "Temp mute for ^1"
                          . $tmphash{$client_id}{'bad_word'}
                          . " ^7minute(s)." );

                    &cmd("ref mute $client_id");
                    $tmphash{$client_id}{'bad_word_timestamp'} = time + $tmphash{$client_id}{'bad_word'} * 60;
                    $tmphash{$client_id}{'muted'}              = 1 if ( $tmphash{$client_id}{'muted'} == 0 );

                    # This is nice, but not needed and suited for this.
                    #&add_rcon_job("ref unmute $client_id",
                    #	(time+$tmphash{$client_id}{'bad_word'}*60), $client_id);
                    #&add_rcon_job("qsay ".$tmphash{$client_id}{'name'}.
                    #	"^7 has been unmuted. Respect the server rules!",
                    #	(time+$tmphash{$client_id}{'bad_word'}*60), $client_id);
                    &log(   "Automute. Tempmute for $tmphash{$client_id}{'name'} "
                          . "(Slot: $client_id) -> $tmphash{$client_id}{'bad_word'} minute(s)." );
                    $tmphash{$client_id}{'bad_word'} *= 2;

                }
                return 1;
            }
        }
    }
    return 0;

}

sub name2client_id
{

    my $name = shift;
    foreach my $player ( keys %tmphash )
    {
        if ( $tmphash{$player}{'name'} eq $name )
        {
            return $player;
        }
    }
    return -1;

}

sub mapvote_check
{

    my @keys  = keys %tmphash;
    my $votes = 0;

    foreach my $player ( keys %tmphash )
    {
        $votes++ if ( $tmphash{$player}{'mapvote'} );
    }

    if ( int( ( $votes / ( $#keys + 1 ) ) * 100 ) >= $config{'intermission_mapvoting'} )
    {

        &log( "Votes: $votes, Players: " . ( $#keys + 1 ) . " Percent: " . int( ( $votes / ( $#keys + 1 ) ) * 100 ) );

        # Limit reached. Voting is over
        $mapvote{'state'} = 3;
        $mapvote{'time'}  = time - 60;
        &timebased_functions();
    }

}

sub display_mapvoting
{
    my $message = shift || "Current standings";
    my @tosort  = ();

    foreach ( keys %map )
    {
        push( @tosort, $_ ) if ( $map{$_} > 0 );
    }

    # easy bubble sort:
    for ( $OL = 0 ; $OL <= $#tosort ; $OL++ )
    {
        for ( $IL = 0 ; $IL <= $#tosort ; $IL++ )
        {
            if ( $map{ $tosort[$IL] } > $map{ $tosort[$OL] } )
            {
                my $temp = $tosort[$IL];
                $tosort[$IL] = $tosort[$OL];
                $tosort[$OL] = $temp;
            }
        }
    }

    for ( my $i = 0 ; $i <= $#tosort ; $i++ )
    {
        $tosort[$i] = $tosort[$i] . "(^3" . int( $map{ $tosort[$i] } ) . "^7)";
    }

    if ( $#tosort > -1 )
    {
        &say( "^3mapvote: ^7$message: ^7" . join( " ", @tosort ) );
    }
    else
    {
        &say( "^3mapvote: ^7$message: No votes " . ( $intermission ? "yet" : "" ) . "!" );
    }
}

sub getmapwinner
{

    my @result = ();
    my @tosort = ();
    foreach ( keys %map )
    {
        push( @tosort, $_ ) if ( $map{$_} > 0 );
    }

    # easy bubble sort:
    for ( $OL = 0 ; $OL <= $#tosort ; $OL++ )
    {
        for ( $IL = $OL ; $IL <= $#tosort ; $IL++ )
        {
            if ( $map{ $tosort[$IL] } > $map{ $tosort[$OL] } )
            {
                my $temp = $tosort[$IL];
                $tosort[$IL] = $tosort[$OL];
                $tosort[$OL] = $temp;
            }
        }
    }
    return $tosort[0];

}

sub part2complete
{

    my $name         = shift;
    my $mode         = shift || 0;                        # 0 = name, 1 = id
    my $convert_name = lc( &convert_name( $name, 0 ) );

    # is the part a id ?
    if ( defined( $tmphash{$name} ) )
    {
        return $mode ? $name : &convert_name( $tmphash{$name}{'name'} ), 1;
    }

    if ( length($convert_name) > 1 )
    {
        my $found = 0;
        my $last_found;

        foreach my $player ( keys %tmphash )
        {

            my $conv = lc( &convert_name( $tmphash{$player}{'name'}, 0 ) );
            if ( index( $conv, $convert_name ) > -1 )
            {
                $last_found = $mode ? $player : &convert_name( $tmphash{$player}{'name'}, 1 );
                $found++;
            }
        }
        return $last_found, $found;
    }
    else
    {
        return "", -1;
    }
    return "", 0;
}

sub restriction_checks
{

    # Sometimes a "world" entry exists.... Delete that before checking
    delete $tmphash{'1022'} if ( defined( $tmphash{'1022'} ) );

    my @num     = keys %tmphash;
    my $players = $#num + 1;
    return if ( !( $players > 0 ) );    # Only do this checks, when the game is running

    foreach my $r ( keys %rule )
    {
        next if ( !defined( $rules{$r} ) || $rule{$r} <= 0 );

        if ( $rule{$r} <= $players && !$rules{$r}{'status'} )
        {

            # Activate
            $rules{$r}{'status'} = 1;

            &say(
                  "^1Note: "
                    . (
                        $rules{$r}{'description'}
                        ? "^7$rules{$r}{'description'}"
                        : "^3class ^7$CLASS{$rules{$r}{'class'}}"
                          . (
                              &in_array( $rules{$r}{'weapon'}, -1 ) ? ""
                              : "^3 with ^7$r_weap{$rules{$r}{'weapon'}[0]}"
                            )
                      )
                    . "^3 is now "
                    . (
                        $rules{$r}{'status'} ? "^2available"
                        : "^1unavailable" . " ^7($rule{$r} player" . ( $rule{$r} > 1 ? "s" : "" ) . " needed)."
                      ),
                  $position{'announcements'}
                )
              if ( $running && !$config{'rule_dont_show_change'} );
            &cmd( $rules{$r}{'command_on'} )
              if ( $running && defined( $rules{$r}{'command_on'} ) );

            &log("Activating: $r");
            $last_notify{$r} = time;

            # Remove set status of all players, that are not yet set into spec,
            # but that are affected by this rule.
            if ($running)
            {
                foreach my $p ( keys %tmphash )
                {

                    # Check the rule
                    if (
                         (
                              &in_array( $rules{$r}{'weapon'}, $tmphash{$p}{'weapon'} )
                           || &in_array( $rules{$r}{'weapon'}, -1 )
                         )
                         && $rules{$r}{'class'} == $tmphash{$p}{'class'}
                       )
                    {

                        if ( $tmphash{$p}{'set_spec'} )
                        {
                            $tmphash{$p}{'set_spec'} = 0;
                        }
                    }
                }
            }

        }
        elsif ( $rule{$r} > $players && $rules{$r}{'status'} )
        {

            # Deactivate
            $rules{$r}{'status'} = 0;
            &say(
                  "^1Note: "
                    . (
                        $rules{$r}{'description'}
                        ? "^7$rules{$r}{'description'}"
                        : "^3class ^7$CLASS{$rules{$r}{'class'}}"
                          . (
                              &in_array( $rules{$r}{'weapon'}, -1 ) ? ""
                              : "^3 with ^7$r_weap{$rules{$r}{'weapon'}[0]}"
                            )
                      )
                    . "^3 is now "
                    . (
                        $rules{$r}{'status'} ? "^2available"
                        : "^1unavailable" . " ^7($rule{$r} player" . ( $rule{$r} > 1 ? "s" : "" ) . " needed)."
                      ),
                  $position{'announcements'}
                )
              if ( $running && !$config{'rule_dont_show_change'} );
            &cmd( $rules{$r}{'command_off'} )
              if ( $running && defined( $rules{$r}{'command_off'} ) );

            &log("Disabling: $r");
            $last_notify{$r} = time;

            # Set all players (which are affected through this rule) into spec.
            if ($running)
            {
                foreach my $p ( keys %tmphash )
                {

                    # Check the rule
                    if (
                         (
                              &in_array( $rules{$r}{'weapon'}, $tmphash{$p}{'weapon'} )
                           || &in_array( $rules{$r}{'weapon'}, -1 )
                         )
                         && $rules{$r}{'class'} == $tmphash{$p}{'class'}
                       )
                    {

                        if ( !$tmphash{$p}{'set_spec'} )
                        {
                            &log("Setting $p spec (R: $r, $rules{$r}{'status'})...\n");

                            # Uuuhhh. Class && Weapon is not allowed atm.
                            $tmphash{$p}{'set_spec'} = time + 3 + int( rand(5) );    # +rand to prevent mass movement
                        }
                    }
                }
            }
        }
    }
}

sub load_shrubbot_cfg
{

    #[admin]
    #name    = SPEARS
    #guid    = 88B7DD1666A03CF2541615839F92B5E4
    #level   = 1
    #flags   =

    &log("Loading $config{'shrubbot_cfg'}");

    my %tmp_admin;
    my %tmp_level;
    my %tmp_ban;
    my $abschnitt  = "";
    my $unfinished = 1;
    %admins = ();
    %level  = ();
    %bans   = () if ( $config{'manage_bans'} );

    open( IN, $config{'shrubbot_cfg'} ) || &log("Error opening file $config{'shrubbot_cfg'}: $!");

    my $zeile = "";
    while ( ( $zeile = <IN> ) or $unfinished )
    {
        chomp $zeile;
        $zeile =~ s/(^\s*|\s*\r*$)//g;

        #next unless ( $zeile || $zeile =~ /\s*\#/ );
        $abschnitt = $1 if ( $zeile =~ /^\[(.*)\]$/ );
        $unfinished = ( $zeile ? 1 : 0 );

        #print "Content: $zeile -> UF: $unfinished, AB: $abschnitt\n";

        if ( $abschnitt eq "level" )
        {

            # level   = 1
            # name    = ^fI am Protected
            $tmp_level{$1} = $2 if ( $zeile =~ /^(.*?)\s*=\s*(.*)/ );
            if ( !$zeile && $tmp_level{'name'} && defined( $tmp_level{'level'} ) )
            {

                # End of data
                $level{ $tmp_level{'level'} } = $tmp_level{'name'};
                &log("Loaded level: $tmp_level{'level'} - $tmp_level{'name'}") if ( $config{'debug'} > 1 );
                $highest_level = $tmp_level{'level'} if ( $highest_level < $tmp_level{'level'} );
                %tmp_level     = ();
                $unfinished    = 0;
            }
            elsif ( !$zeile )
            {
                %tmp_level  = ();
                $unfinished = 0;
            }
        }
        elsif ( $config{'manage_bans'} && $abschnitt eq "ban" )
        {
            $tmp_ban{$1} = $2 if ( $zeile =~ /^(.*?)\s*=\s*(.*)/ );

            if (    !$zeile
                 && $tmp_ban{'name'}
                 && $tmp_ban{'guid'}
                 && defined( $tmp_ban{'expires'} )
                 && $tmp_ban{'reason'}
                 && $tmp_ban{'made'} )
            {

                $tmp_ban{'guid'}                     = uc( $tmp_ban{'guid'} );
                $bans{ $tmp_ban{'guid'} }{'reason'}  = $tmp_ban{'reason'};
                $bans{ $tmp_ban{'guid'} }{'name'}    = $tmp_ban{'name'};
                $bans{ $tmp_ban{'guid'} }{'made'}    = $tmp_ban{'made'};
                $bans{ $tmp_ban{'guid'} }{'expires'} = $tmp_ban{'expires'};
                $bans{ $tmp_ban{'guid'} }{'banner'} = $tmp_ban{'banner'} if ( defined( $tmp_ban{'banner'} ) );
                $bans{ $tmp_ban{'guid'} }{'ip'}     = $tmp_ban{'ip'}     if ( defined( $tmp_ban{'ip'} ) );
                $bans{ $tmp_ban{'guid'} }{'eguid'}  = $tmp_ban{'eguid'}  if ( defined( $tmp_ban{'eguid'} ) );

                # To enforce ETPRO bans:
                if ( $tmp_ban{'eguid'} )
                {
                    $etpro_bans{ $tmp_ban{'eguid'} } = $tmp_ban{'guid'};
                }

                &log(   "Loaded ban: $bans{$tmp_ban{'guid'}}{'name'}"
                      . " - $tmp_ban{'guid'}"
                      . ( $tmp_ban{'eguid'} ? "/$tmp_ban{'eguid'}" : "" ) )
                  if ( $config{'debug'} > 1 );

                %tmp_ban    = ();
                $unfinished = 0;
            }
            elsif ( !$zeile )
            {
                %tmp_ban    = ();
                $unfinished = 0;
            }
        }
        elsif ( $abschnitt eq "admin" )
        {
            $tmp_admin{$1} = $2 if ( $zeile =~ /^(.*?)\s*=\s*(.*)/ );

            if ( !$zeile && defined( $tmp_admin{'level'} ) && $tmp_admin{'guid'} && $tmp_admin{'name'} )
            {
                $tmp_admin{'guid'}                 = uc( $tmp_admin{'guid'} );
                $admins{ $tmp_admin{'guid'} }      = $tmp_admin{'level'};
                $admins_name{ $tmp_admin{'guid'} } = $tmp_admin{'name'};

                $protected{ &convert_name( $tmp_admin{'name'} ) } = $tmp_admin{'guid'};
                &log(   "Loaded protected: "
                      . &convert_name( $tmp_admin{'name'} ) . " - "
                      . $protected{ &convert_name( $tmp_admin{'name'} ) }
                      . "\n" )
                  if ( $config{'debug'} > 1 );
                &log("Loaded admin: $tmp_admin{'name'} - $tmp_admin{'guid'} - Level: $tmp_admin{'level'}")
                  if ( $config{'debug'} > 1 );
                %tmp_admin  = ();
                $unfinished = 0;
            }
            elsif ( !$zeile )
            {
                %tmp_admin  = ();
                $unfinished = 0;
            }
        }
    }
    close(IN);

    # shrub counts from the 1.1.2000, not from 1.1.1970 ?!?!
    my $timestamp = $config{'ban_timestamp_format'} eq "shrub" ? ( time - 946767600 ) : time;

    # 	shrub example:
    #	146483204  ban
    #	946767600  2000
    #	1092728531 current

    # check all bans ...
    foreach my $guid ( keys %bans )
    {
        if ( $bans{$guid}{'expires'} > 0 && $bans{$guid}{'expires'} < $timestamp )
        {

            # Ban expired.
            &log("Ban for $guid ($bans{$guid}{'name'}) expired!");
            &shrub_ban( $config{'shrubbot_cfg'}, "remove", $guid );
            delete $etpro_bans{ $bans{$guid}{'eguid'} } if ( defined( $bans{$guid}{'eguid'} ) );
            delete $bans{$guid};
        }
    }

    &load_security() if ($tcp_interface);

}

sub getExpireTime
{

    my $time = shift;

    return "never" if ( $time == 0 );

    # shrub counts from the 1.1.2000, not from 1.1.1970 ?!?!
    my $timestamp = $config{'ban_timestamp_format'} eq "shrub" ? ( $time + 946767600 ) : $time;

    $time = time2date($time);

    #$time = substr ($time, 0, length($time)-3);

    return $time;

}

sub timebased_functions
{
    my @num     = keys %tmphash;
    my $players = $#num + 1;

    # Update global setting.
    $curr_players = $players;

    if ( $con > 0 )
    {

        # Drop inactive and not logged in tcp sockets after a 15 second timeout
        foreach my $slot ( keys %remote )
        {

            if (    defined( $remote{$slot}{'status'} )
                 && $remote{$slot}{'status'} == 0
                 && $remote{$slot}{'timestamp'} + $config{'tcp_ident_timeout'} < time )
            {
                &log("Timeout waiting for identify on slot $remote{$slot}{'status'}.");
                &remote_disconnect($slot);
            }
        }
    }

    &check_rcon_jobs();

    if ( $players > 0 )
    {

        # Badword check
        if ( $config{'automute'} && $config{'et_mod'} == 2 )
        {

            # bad_name_mute check:
            foreach my $player ( keys %tmphash )
            {

                #&log("Checking $player: $tmphash{$player}{'bad_word_timestamp'} vs ".time);
                if ( defined( $tmphash{$player}{'bad_word_timestamp'} )
                     && $tmphash{$player}{'bad_word_timestamp'} <= time )
                {
                    &log("Checking $player: Mute status $tmphash{$player}{'muted'}...") if ($config{'debug'} > 1);
                    if ( $tmphash{$player}{'muted'} == 1 )
                    {
                        &cmd("ref unmute $player");

                        # Just to make sure (guess, this is not really needed due to the sub rcon enhancements);
                        $tmphash{player}{'muted'} = 0;

                        &cmd( "qsay " . $tmphash{$player}{'name'} . "^7 has been unmuted. Respect the server rules!" );
                        delete $tmphash{$player}{'bad_word_timestamp'};
                        delete $tk_hash{$guid}{'bad_word_timestamp'};
                    }
                }
            }

        }

        # Map voting.
        if ( $mapvote{'state'} > 0 )
        {

            #&log("check $intermission - $mapvote{'state'} $mapvote{'time'}...\n");
            if (    $mapvote{'state'} == 1 && $mapvote{'time'} + 14 < time
                 || $mapvote{'state'} == 2 && $mapvote{'time'} + 35 < time )
            {
                &display_mapvoting("Current result");

                #$mapvote{'state'} ++;
                $mapvote{'time'} = time;
            }
            elsif ( $mapvote{'state'} == 3 && $mapvote{'time'} + 5 < time )
            {

                ### UNUSED ###

                ## Display result
                &display_mapvoting("Final result");
                $mapvote{'state'} = 4;
                my $winner = &getmapwinner();
                &say( "^3mapvote: ^7The winning map is ^3$winner^7. "
                      . ( $mapname ne $mapvote{'winner'} ? "Changing map in approx. 5 seconds!" : "" ) );

            }
            elsif ( $mapvote{'state'} == 4 && $mapvote{'time'} + 2 < time )
            {

                &log( "Intermission mapvoting finished. Winner: " . $mapvote{'winner'} );
                $mapvote{'state'} = 0;
                $mapvote{'time'}  = 0;

                # get map, change.
                if ( $mapname ne $mapvote{'winner'} )
                {
                    &say( "^3mapvote: ^7Changing to winner map ^3" . $mapvote{'winner'} . " ^7now." );
                    &cmd("map $mapvote{'winner'}");
                }
                $mapvote{'winner'} = "";
            }
        }

        # Uneven team notifications.
        if ( $uneven_teams && ( time - $uneven_teams > 30 ) )
        {

            if ( $last_notify{'even_teams'} == 0 )
            {
                &say( $config{'uneven_warning1'}, $position{'uneven_teams'} );
                &log("Uneven teams: warning 1");
                $last_notify{'even_teams'} = 1;
            }
            elsif ( $last_notify{'even_teams'} == 1 )
            {
                $last_notify{'even_teams'} = 2;
                &log("Uneven teams: warning 2");
                &say( $config{'uneven_warning2'}, $position{'uneven_teams'} );
            }
            elsif ( $last_notify{'even_teams'} == 2 )
            {
                if ( $config{'uneven_teams_escalation_cmd'} )
                {

                    # Small workaround for shuffles.
                    if ( index( $config{'uneven_teams_escalation_cmd'}, "shuffleteamsxp_norestart" ) > -1 )
                    {
                        &cmd("set etadmin \"$config{'uneven_teams_escalation_cmd'}\"");
                        &cmd("vstr etadmin");
                    }
                    else
                    {
                        &cmd( $config{'uneven_teams_escalation_cmd'} );
                    }
                    &log( "Uneven teams: Executing: " . $config{'uneven_teams_escalation_cmd'} );

                    # Workarround for shuffleteamsxp_norestart
                    if ( $config{'uneven_teams_escalation_cmd'} =~ /ref\s+shuffleteamsxp_norestart/ )
                    {
                        $uneven_teams = 0;

                        #$uneven_teams_map = 0;
                    }

                }
                &say( $config{'uneven_warning3'}, $position{'uneven_teams'} );
                &log("Uneven teams: warning 3");
                $last_notify{'even_teams'} = 3;
            }
            elsif ( $last_notify{'even_teams'} == 3 )
            {
                &log("Uneven teams: warning 4");
                &say( $config{'uneven_warning4'}, $position{'uneven_teams'} );
            }
            $uneven_teams = time;    # Next notification in 30 seconds.
        }

        # Display birthday notifications
        if ( $config{'birthday_notifications'} && defined( $birthdays{'1'} ) && $last_notify{'birthday'} + 300 < time )
        {

            my $birthday = "^3Todays birthdays:^7 ";
            foreach my $count ( keys %birthdays )
            {
                $birthday .= "$birthdays{$count}{'name'} ($birthdays{$count}{'age'}),";

            }
            $birthday =~ s/,$/./;
            &say( "$birthday", $position{'birthdays'} );
            $last_notify{'birthday'} = time;
            &log("Birthday announcement: ($birthday)") if ( $config{'debug'} );
        }

        # Display banners.
        if ( $running && $config{'banners'} && $config{'bannertime'} > 0 && $#banners > -1 )
        {

            # JF - modified this "if" to check for $banner_time
            if (    ( $banner_time == 0 and $last_notify{'banners'} + $config{'bannertime'} < time )
                 or ( $banner_time > 0 and $last_notify{'banners'} + $banner_time < time ) )
            {

                my $num = $#banners;
                $banner_position >= $num ? $banner_position = 0 : $banner_position++;

                if ( $banners[$banner_position] =~ /^(\d+):(.*)/ )
                {

                    # time shifted banner
                    &log("Display of $banners[$banner_position] - Time: $banner_time") if ( $config{'debug'} );
                    &say( $2, $position{'banners'} );
                }
                else
                {

                    # normal banner
                    &log("Display of $banners[$banner_position]") if ( $config{'debug'} );
                    &say( $banners[$banner_position], $position{'banners'} );
                }

                # Calculating, next banner_time (JK/mark)
                my $next_banner_position = $banner_position + 1 <= $num ? ( $banner_position + 1 ) : 0;
                $banner_time = $banners[$next_banner_position] =~ /^(\d+):/ ? $1 : 0;

                $last_notify{'banners'} = time;

            }
        }

        if ( $config{'forceclass_balance'} )
        {
            my $found = 0;
            foreach my $player ( keys %tmphash )
            {

                #print "$tmphash{$player}{'set_spec'} ".time."\n" if ($tmphash{$player}{'set_spec'});
                if (    $tmphash{$player}{'set_spec'}
                     && $tmphash{$player}{'set_spec'} <= time )
                {
                    &say(
                          "^3This ^3class ^7/^3 weapon^7 is currently ^1unavailable^7. "
                            . "Please choose a different ^3class/weapon^7.",
                          "chatclient",
                          $player
                        );
                    &cmd("forceteam $player s");
                    $tmphash{$player}{'team'}     = 3;
                    $tmphash{$player}{'set_spec'} = 0;
                    &log("Forced $player ($tmphash{$player}{'name'}) into spec!") if ($config{'debug'});
                    sleep 1;
                }
            }

            # Display rules.
            if ( $running && $config{'rule_announce_time'} )
            {
                my @num     = keys %tmphash;
                my $players = $#num + 1;
                my $found   = 0;
                if ( $players > 0 )
                {
                    foreach my $r ( keys %rule )
                    {
                        next if ( !defined( $rules{$r} ) || $rule{$r} <= 0 );

                        if ( $last_notify{$r} + $config{'rule_announce_time'} < time )
                        {

                            &say(
                                  "^1Note: "
                                    . (
                                        $rules{$r}{'description'}
                                        ? "^7$rules{$r}{'description'}"
                                        : "^3class ^7$CLASS{$rules{$r}{'class'}}"
                                          . (
                                              &in_array( $rules{$r}{'weapon'}, -1 ) ? ""
                                              : "^3 with ^7$r_weap{$rules{$r}{'weapon'}[0]}"
                                            )
                                      )
                                    . "^3 is currently "
                                    . (
                                        $rules{$r}{'status'} ? "^2available"
                                        : "^1unavailable"
                                          . " ^7($rule{$r} player"
                                          . ( $rule{$r} > 1 ? "s" : "" )
                                          . " needed)."
                                      ),
                                  $position{'announcements'}
                                );
                            $last_notify{$r} = time;
                            $found = 1;

                        }
                    }
                    &log("Announced rules. (Players: $players)") if ( $found && $config{'debug'} );
                    if ( 1 == 2 && $found )    #  debugging output
                    {
                        foreach my $p ( sort keys %tmphash )
                        {
                            print sprintf( "%2d - %s - %s\n", $p, $tmphash{$p}{name}, $tmphash{$p}{guid} );
                        }
                        print "--------------------------------\n";
                    }
                }

            }
        }
    }

    # Timestamp checks... (7 seconds after game start)
    if ( $last_init && $last_init + 7 < time )
    {
        &log("PreInit check (last init: $last_init)") if ( $config{'debug'} );
        foreach my $p ( keys %tmphash )
        {

            #print "Testing:  $ready{$tmphash{$p}{'guid'}} <= $last_init\n";
            if ( !defined( $ready{ $tmphash{$p}{'guid'} } ) || $ready{ $tmphash{$p}{'guid'} } <= $last_init )
            {

                # OLD
                &log("Deleting: $p (Name: $tmphash{$p}{'name'}, time: $ready{$tmphash{$p}{'guid'}})")
                  if ( $config{'debug'} );
                delete $tmphash{$p};
            }
        }
        $last_init = 0;
    }

    if (    $config{'cancel_votes'}
         && $running == 1
         && ( $time + $cancel_time * 60 ) < time() )
    {

        &log("Voting disabled !");
        $running = 2;
        if ( $config{'deactivate_voting'} && $disabled_voting == 0 )
        {
            &cmd(
"set etadmin \"set vote_allow_nextmap 0 ; set vote_allow_shuffleteamsxp 0 ; set vote_allow_swapteams 0 ; set vote_allow_matchreset 0\""
            );
            &cmd("vstr etadmin");

            #&cmd("set vote_allow_nextmap \"0\"");
            #&cmd("set vote_allow_shuffleteamsxp \"0\"");
            #&cmd("set vote_allow_swapteams \"0\"");
            #&cmd("set vote_allow_matchreset \"0\"");
            $disabled_voting = 1;
        }
        my @players = keys %tmphash;
        &say(   "XP-Shuffle / Map Restart / Swap Teams  / Match Reset "
              . "and New Campaign votings are now DISABLED"
              . ( $disabled_voting ? "." : " (auto cancel)." ) )
          if ( $#players > -1 );
    }

    if ( $running > 0 && $crazy_gravity )
    {

        if ( $crazy_gravity_time - 5 + $crazy_gravity_duration < time
             && !$crazy_gravity_notify )
        {
            &say("^3crazygravity: ^7Next gravity change in ^15^7 seconds!");
            $crazy_gravity_notify = 1;
        }
        elsif ( $crazy_gravity_time + $crazy_gravity_duration < time )
        {
            my $random = int( rand( $crazy_gravity_max - $crazy_gravity_min ) + $crazy_gravity_min );
            &say("^3crazygravity: ^7Changing gravity to $random!");
            &cmd("g_gravity $random");
            $crazy_gravity_time   = time;
            $crazy_gravity_notify = 0;
        }

    }

    if ( $config{'kick_badnames'} == 2 )
    {

        my @warnings = keys %warnings_bn;

        if ( $#warnings > -1 )
        {
            foreach my $guid ( keys %warnings_bn )
            {
                my $wt = $config{'bad_name_grace_period'} > 0 ? int( $config{'bad_name_grace_period'} * 0.66 ) : 0;
                if ( $wt && time - $warnings_bn{$guid} >= 20 && $tmp_warn2{$guid}{'status'} < 2 )
                {
                    if ( &guid_check($guid) )
                    {
                        &say("$tmp_warn2{$guid}{'name'} ^1-> 10 seconds before kick. Please change your name!");
                        $tmp_warn2{$guid}{'status'} = 2;
                        &log("Warning 1 -> $tmp_warn2{$guid}{'name'}");
                    }
                    else
                    {
                        &disconnect_guid($guid);
                    }

                }
                elsif ( time - $warnings_bn{$guid} >= $config{'bad_name_grace_period'} )
                {

                    # NEVER KICK SOMEONE, that is on the slot and has a DIFFERENT GUID
                    if ( $tmphash{ $tmp_warn2{$guid}{'client_id'} }{'guid'} eq $guid )
                    {
                        &say("$tmp_warn2{$guid}{'name'} ^7kicked (Reason: ^3Bad name!^7)");

                        &kick( $tmp_warn2{$guid}{'client_id'}, "Bad name", 0 );
                        &log("Kicked: $tmp_warn2{$guid}{'name'}(Slot: $tmp_warn2{$guid}{'client_id'}) (BAD NAME)");
                        &disconnect( $tmp_warn2{$guid}{'client_id'}, $guid );
                    }
                    &disconnect_guid($guid);
                }
            }
        }
    }
    if ( $config{'name_protector'} )
    {

        my @warnings = keys %warnings;

        if ( $#warnings > -1 )
        {
            foreach my $guid ( keys %warnings )
            {
                if ( time - $warnings{$guid} >= 30 && $tmp_warn{$guid}{'status'} < 2 )
                {
                    if ( &guid_check($guid) )
                    {
                        &say(   "$tmp_warn{$guid}{'name'} ^1-> 1 minute before kick. "
                              . "This name is registered, please change!" );
                        $tmp_warn{$guid}{'status'} = 2;
                        &log("Warning 1 -> $tmp_warn{$guid}{'name'} (Slot: $tmp_warn{$guid}{'client_id'})");
                    }
                    else
                    {
                        &disconnect_guid($guid);
                    }
                }
                elsif ( time - $warnings{$guid} >= 60 && $tmp_warn{$guid}{'status'} < 3 )
                {
                    if ( &guid_check($guid) )
                    {
                        &say(   "$tmp_warn{$guid}{'name'} ^1 -> 30 seconds before kick. "
                              . "Register your own name at ^7$config{'website'}^7." );
                        $tmp_warn{$guid}{'status'} = 3;
                        &log("Warning 2 -> $tmp_warn{$guid}{'name'}(Slot: $tmp_warn{$guid}{'client_id'})");
                    }
                    else
                    {
                        &disconnect_guid($guid);
                    }
                }
                elsif ( time - $warnings{$guid} >= 90 )
                {
                    &say("$tmp_warn{$guid}{'name'} ^1-> Bye, bye. Register your own name at ^7$config{website}^7.");
                    select( undef, undef, undef, 0.5 );    # Make a small break

                    if ( defined( $tmp_warn{$guid}{'client_id'} ) && $tmp_warn{$guid}{'client_id'} >= 0 )
                    {

                        # check ,if player is still there...
                        if ( $tmphash{ $tmp_warn{$guid}{'client_id'} }{'guid'} eq $guid )
                        {
                            &kick( $tmp_warn{$guid}{'client_id'}, "This name is registered.(wrong guid)", 0 );
                            &log("Kicked: $tmp_warn{$guid}{'name'}(Slot: $tmp_warn{$guid}{'client_id'}) (wrong GUID)");
                            &disconnect( $tmp_warn{$guid}{'client_id'}, $guid );
                        }
                    }
                    else
                    {

                        # first try to get the slot number through guid
                        my $slot = -1;
                        foreach my $player ( keys %tmphash )
                        {
                            if ( $tmphash{$player}{'guid'} eq $guid )
                            {
                                $slot = $player;
                                last;
                            }
                        }
                        if ( $slot >= 0 )
                        {
                            &kick( $slot, "This name is registered.(wrong guid)", 0 );
                            &log("Kicked: $tmp_warn{$guid}{'name'}(Slot: $slot) (wrong GUID)");
                        }
                        else
                        {
                            my $name = &convert_name( $tmp_warn{$guid}{'name'} );

                            # try name
                            &cmd("kick \"$name\"");
                            &log("Kicked: $tmp_warn{$guid}{'name'}(Slot: unknown) (wrong GUID)");
                        }

                    }
                    &disconnect_guid($guid);
                }
            }
        }
    }

}

sub load_protected
{

    #$protected = ();
    &log("Loading protected-file");
    open( IN, $config{'protected_file'} );

    my $buff  = "";
    my $store = "";
    while ( sysread IN, $buff, 4096 )
    {
        $store .= $buff;
    }

    my @lines = split /\r?\n/, $store;

    for (@lines)
    {

        s/(^\s*|[\s\r\n]*$)//g;
        next if /^#/;    # comments

        my $guid;
        my $name;

        # xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx|cade
        ( $guid, $name ) = ( $1, $2 ) if s/^([0-9a-f]{32})\|(.+)$//i;

        # cade|xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
        ( $guid, $name ) = ( $2, $1 ) if s/^(.+)\|([0-9a-f]{32})$//i;
        next unless $guid;    # wrong lines are skipped
                              # hopefully noone will name as guid looks :)

        if ( !defined( $protected{ &convert_name($name) } ) && $name )
        {
            $protected{ &convert_name($name) } = $guid;
            &log("DEBUG: Loaded: [$guid] $name") if ( $config{'debug'} > 1 );
        }
        else
        {
            &log("DEBUG: Ignored: [$guid] $name") if ( $config{'debug'} > 2 );
        }
    }
    close(IN);

}

sub say
{

    my $message  = shift;
    my $position = shift || $position{'default'} || "chat";
    my $cmd      = "";

    if ( $position ne "tcp" )
    {

        #$message = substr( $message, 0, 512 ) if ( length($message) > 512 );
        # Restrict the length to a maxlength, if needed.
        my $len = 300;
        if ( $config{'et_mod'} == 2 )
        {
            $len = $intermission ? 291 : 310;
        }
        else
        {
            $len = 280;
        }

        if ( length($message) > $len )
        {

            if ( 1 == 1 )
            {

                # New code by Tommes:

                #add trailing space to $message
                $message .= " ";
                my $mindex    = 0;
                my $altmindex = 0;

                while ( ( $mindex + 1 ) < length($message) )
                {

                    #reverse search for space beginning at ($altmindex + $len)
                    $mindex = rindex( $message, " ", $altmindex + $len );

                    #&say at least 200 chars
                    if ( ( $altmindex + 200 ) < $mindex )
                    {
                        &say( substr( $message, $altmindex, ( $mindex - $altmindex ) ), $position, @_ );
                        $altmindex = $mindex + 1;
                    }

                    else
                    {
                        &say( substr( $message, $altmindex, $len ), $position, @_ );
                        $altmindex += $len;
                    }
                }
            }
            else
            {

                # old code (fixed length)
                for ( my $i = 0 ; $i <= int( length($message) / $len ) ; $i++ )
                {
                    &say( substr( $message, $len * $i, $len ), $position, @_ ) if ($message);
                }
            }
            return;
        }

    }

    if ( $position eq "tcp" )
    {

        my $sock_id  = shift;
        my $supress  = shift || 0;
        my $query_id = shift || "";
        my @data     = split /\n/, $message;

        #&log("supress : $supress, socket: $sock_id");
        for (@data)
        {
            &remote_send( $_, $sock_id, $query_id );
        }
        $last = time();
        return if ($supress);

        # we may also want public output.
        $position = "chat";

    }

    if ( $position eq "cp" )
    {
        $cmd = "cp";
    }
    elsif ( $position eq "cpmsay" )
    {
        $cmd = "cpmsay";
    }
    elsif ( $position eq "cpm" )
    {
        $cmd = "cpm";
    }
    elsif ( $position eq "chat" || $position eq "qsay" )
    {

        # running etpro ?
        if ( $config{'et_mod'} == 2 )
        {
            $cmd = "qsay";
        }
        elsif ( $config{'et_mod'} == 3 || $config{'et_mod'} == 1 )
        {

            # ok, then shrub or headshot
            $cmd = "chat";
        }
        else
        {

            # ok, last change, etmain
            $cmd = "say";
        }

        #&global_remote_send("$cmd: $message", "ETM-CHAT:GLOBAL");

    }
    elsif ( $position eq "bp" )
    {
        $cmd = "bp";
    }
    elsif ( $position eq "chatclient" )    # || $position eq "m" )
    {
        my $client = shift;
        if ( $config{'et_mod'} == 1 )
        {
            $cmd = "chatclient $client";
        }
        elsif ( $config{'et_mod'} == 3 )
        {
            $cmd = "chat $tmphash{$client}{'name'}^7:";
        }
        elsif ( $config{'et_mod'} == 2 && &etpro_pm_check($mod_version) )
        {
            $cmd = 'm "' . &convert_name( $tmphash{$client}{'name'} . '"', 0, 0 );
        }
        elsif ( $config{'et_mod'} == 2 )
        {
            $cmd = "qsay >$tmphash{$client}{'name'}^7:";
        }
        else
        {
            $cmd = "say";
        }

        #&global_remote_send("$cmd: $message", "ETM-CHAT:PM");

    }
    else
    {
        $cmd = "say";
    }

    if ( $config{'et_mod'} >= 2 )
    {

        # Running etpro / headshot. Has no linebreaks yet ...
        my @data = split( /\n/, $message );

        # More then one row ?
        if ( $#data > 0 )
        {

            # OK, every line need (except the last) need spaces at the end.
            for my $count ( 0 .. $#data - 1 )
            {
                my $line_length;
                if ( $config{'et_mod'} == 2 )
                {
                    $line_length = $intermission ? 97 : 62;
                }
                elsif ( $config{'et_mod'} == 3 )
                {
                    $line_length = $intermission ? 70 : 70;
                }
                my $length = length( &convert_line( $data[$count] ) );
                if ( $length < $line_length )
                {
                    $data[$count] .= "^0";
                    for ( 1 .. $line_length - $length )
                    {
                        $data[$count] .= $_ != $line_length - $length ? "_" : "^7 ";
                    }
                }
            }
        }
        $message = join( '', @data );
    }

    # $ schuetzen
    #$message =~ s/\$/\\\$/g if( $config{'input_type'} ne "udp");
    $message =~ s/\n/\\n/g;
    $message =~ s/"//g;

    &cmd("$cmd \"$message\"");
    $last = time();

}

sub etpro_pm_check
{
    my $version = shift || $mod_version;

    #print "Testing: $version\n";
    return 0 if ( !$version );

    my ( $main_version, $sub_version, $sub_sub_version ) = split( /\./, $version );
    if ( $main_version > 3
         || ( $main_version = 3 && ( $sub_version >= 1 && $sub_sub_version >= 6 ) || $sub_version > 1 ) )
    {
        return 1;
    }

    #&log("Return 0 ($main_version, $sub_version, $sub_sub_version)");

    # else:
    return 0;

}

sub cmd
{
    my $cmd = shift;

    if ( !$config{'dry_run'} )
    {

        #$cmd =~ s/\$/\\\$/g ;
        $cmd =~ s/\$/\\\$/g if ( $config{'input_type'} ne "udp" );

        my ( $output, $raw_data ) = &rcon($cmd);
        &log( "ERROR: " . $output . " Check your server_addr / server_password." )
          if ( $output eq "Bad rconpassword." );

        return $output, $raw_data;

    }
    else
    {
        &log("Rcon cmd: $cmd");
    }
    $last = time();
}

sub in_array
{

    my $ahash = shift;
    my $arg   = shift;

    for (@$ahash)
    {
        return 1 if ( $_ eq $arg );
    }
    return 0;
}

sub rcon
{
    my $command = shift;
    my $recv    = shift || 1;
    my $say     = "";
    my $data    = "";

    &global_remote_send( $command, "ETM-RCON" );

    &log("Rcon Command: $command") if ( $config{'debug'} );
    if ( $config{'input_type'} eq "udp" )
    {
        my $et = IO::Socket::INET->new(
                                        "PeerAddr" => $config{'server_addr'},
                                        "PeerPort" => $config{'server_port'},
                                        "Proto"    => "udp"
                                      )
          or die($!);
        if ($et)
        {
            print $et "\377\377\377\377rcon $config{'server_password'} $command";

            # DONT TRY THIS AT HOME.
            if ( $recv == 1 )
            {

                my $status = "";
                local $SIG{ALRM} = sub { die "alarm\n"; };    # NB \n required
                alarm(1);
                eval {

                    while ( recv( $et, $status, 1024, 0 ) )
                    {

                        my $size = length($status);
                        $status =~ s/^\377\377\377\377//;
                        $status =~ s/print\n//;
                        $status =~ s/"//g;

                        $data .= $status;

                    }
                };
                alarm(0);

                close $et;
                undef $et;

                chomp $data;

                &sound_mapping($command, "rcon") if ( $config{'sound_mappings'} );    # Hammer
                
                if ($data)
                {

                    #print "\"$data\"\n" if ($config{'debug'}> 1) ;
                    my @output = split( /\n/, $data );

                    for my $line (@output)
                    {

                        &global_remote_send( $line, "ETM-CLOG" );

                        next if ( !$line );

                        #print "Line: \"$line\"\n";

                        # I better process this also =).
                        # this is much better, then this half baked
                        # "if thing" below of the last version.
                        # Hope i don't get any recursions. XXX -> does somehow.
                        #&process_line($line);
                        #&sound_mapping($line, "rcon") if ( $config{'sound_mappings'} );    # Hammer

                        if ( $line =~ /ClientUserinfoChangedG?U?I?D?: (\d+) (.*?)n\\(.*?)(\\.*)$/ )
                        {

                            #next;
                            my $client_id = $1;
                            my $guid      = $2;
                            my $rhash     = &parse_userinfo($4);

                            $tmphash{$client_id}{'team'}   = $$rhash{'t'};
                            $tmphash{$client_id}{'class'}  = $$rhash{'c'};
                            $tmphash{$client_id}{'weapon'} = $$rhash{'w'};
                            $tmphash{$client_id}{'muted'}  = $$rhash{'mu'};

                            &log(
"Setting: $client_id t: $$rhash{'t'}, c: $$rhash{'c'}, w: $$rhash{'w'}, mu: $$rhash{'mu'}\n" )
                              if ( $config{'debug'} );
                        }
                        elsif ( $line =~ /^ClientDisconnect: (\d+)/ )
                        {

                            #next;
                            &log("Disconnect: $1") if ( $config{'debug'} );
                            &disconnect($1);
                        }
                        else
                        {
                            if (    index( $line, "broadcast:" ) != 0
                                 && index( $line, "Userinfo:" ) != 0
                                 && index( $line, "ClientBegin:" ) != 0
                                 && index( $line, "ClientConnect:" ) != 0
                                 && index( $line, "Kill:" ) != 0
                                 && index( $line, "chat(client):" ) != 0
                                 && index( $line, "SERVER^7:" ) != 0
                                 && index( $line, "etpro privmsg:" ) != 0
                                 && index( $line, "WeaponStats:" ) != 0
                                 && !( $line =~ /^cmd \d+:/ ) )
                            {
                                $line =~ s/^\s+//;
                                $say .= $line . "\n";
                            }
                        }
                    }

                    if ($say)
                    {
                        chomp $say;
                        if (    index( $say, "Sys_LoadDll" ) < 0
                             && index( $say, "==== ShutdownGame ====" ) < 0
                             && index( $say, "===== pending server commands =====" ) < 0 )
                        {

                            #&log("Say: $say\n");
                        }
                        else
                        {
                            $say = "";
                        }
                    }
                }

            }
            else
            {
                close $et;
            }

        }
        else
        {
            &log("Rcon failed: $command. No connection to server.");

        }
        sleep 1 if ( !$recv );    # if ( time() - $last < 2 );
    }
    else
    {
        open( OUT, ">>$config{'input_file'}" ) || die $!;
        print OUT $command . "\n";
        close(OUT);
        &sound_mapping($command, "rcon") if ( $config{'sound_mappings'} );    # Hammer
        sleep 1 if ( !$recv );    # if ( time() - $last < 2 );
    }
    return $say, $data;

}

sub time2date
{
    my $time = shift || time;
    my ( $sec, $min, $std, $mtag, $mon, $jahr, $wochentag, $jahrestag ) = localtime($time);

    $mon++;
    $jahr += 1900;
    $jahr =~ s/^..//;

    $sec  = "0$sec"  if ( $sec < 10 );
    $min  = "0$min"  if ( $min < 10 );
    $std  = "0$std"  if ( $std < 10 );
    $mtag = "0$mtag" if ( $mtag < 10 );
    $mon  = "0$mon"  if ( $mon < 10 );

    #return "$mtag/$mon/$jahr $std:$min:$sec";
    return "$mon/$mtag/$jahr $std:$min:$sec";
}

sub convert_line
{

    my $line = shift;
    $line =~ s/\^.//g;
    return $line;

}

sub convert_name
{
    my $name       = shift;
    my $strip      = shift || 0;    # shell names > 31 be stripped (server code)?
    my $lower_case = shift || 0;

    $name = substr( $name, 0, 31 ) if ( $strip && length($name) > 31 );
    $name =~ s/\^.//g;

    # This is the client-side code, but the server side code works different *sigh*
    #$name =~ s/\^[^\^]//g;
    #$name =~ s/\^\^/\^/g;
    $name = lc($name) if ($lower_case);
    return $name;

}

sub strip_spaces
{

    my $name = shift;
    $name =~ s/^\s*(.*?)\s*$/$1/;
    return $name;

}

sub admin_check
{
    my $guid  = shift;
    my $right = lc(shift);
    my $base  = shift || "game";
    my $to    = &get_admin_level($guid);

    # &log("Admincheck: Guid: $guid, Right: $right, Input: $base, Level: $to");

    for my $lvl ( 0 .. $to )
    {
        my $ref = $admin_func[$lvl];

        for my $cmd (@$ref)
        {
            if ( $cmd eq $right || $cmd eq $base . ":" . $right )
            {

                # OK
                return 1;
            }

        }
    }

    return 0;

}

sub get_admin_level
{
    my $guid = shift;

    if ( defined( $admins{$guid} ) )
    {
        return $admins{$guid};
    }
    elsif ( defined( $remote_guids{$guid} ) )
    {
        return $remote{ $remote_guids{$guid} }{'level'};
    }

    return 0;
}

sub guid2name
{

    my $guid = shift;

    if ( defined( $remote_guids{$guid} ) )
    {
        return $remote{ $remote_guids{$guid} }{'name'};
    }
    else
    {
        foreach my $p ( keys %tmphash )
        {
            return $tmphash{$p}{'name'} if ( $tmphash{$p}{'guid'} eq $guid );
        }
    }
    return "Unknown";
}

sub cancelvote
{

    my $line    = shift;
    my $kick    = shift || 1;
    my $message = shift;

    if ( !$message )
    {
        if ( $config{'cancel_mode'} == 3 )
        {
            $message = "This poll has been disabled for the rest of the map!";
        }
        else
        {
            $message = "Please DON'T start this vote in the last minutes of the round!";
        }
    }

    # Its a bad vote:
    &cmd("cancelvote");
    my $slot;
    my $user;
    my $vote;

    # Callvote: 4: ^2***^4JEDI^2*** called a vote: Shuffle Teams by XP
    # Callvote: 24: ^3Big^7-^5Boy called a vote: Shuffle Teams by XP
    if ( $line =~ /Callvote: (\d+): (.*) called a vote: (.*?)\s*$/ )
    {

        # SHRUB / HEADSHOT
        $slot = $1;
        $user = $2;
        $vote = $3;

    }
    elsif ( $line =~ /^broadcast: print "(.*)\^7 called a vote.  Voting for: (.*?)\s*\\n"/ )
    {

        # ETPRO
        $vote = $2;

        foreach my $player ( keys %tmphash )
        {
            if ( $tmphash{$player}{'name'} eq $1 )
            {
                $slot = $player;
                $user = $tmphash{$player}{'name'};
                last;
            }
        }

    }

    $tmphash{$slot}{'warnings'}{$vote}++ if ($kick);

    # Reaction
    if ( $tmphash{$slot}{'warnings'}{$vote} == 1 || !$kick )
    {

        &say($message);

    }
    elsif ( $tmphash{$slot}{'warnings'}{$vote} == 2 )
    {

        &say("^7Stop starting votes, $user^7. If you try again, you will be kicked!");
        &log("Warned User: $user");

    }
    elsif ( $tmphash{$slot}{'warnings'}{$vote} > 2 )
    {

        #&say("$user^7: You have been warned. Now face the consequences!");

        &kick( $slot, "Vote abuse." );
        &log("Kicked User: $user");

        #&disconnect($slot);

    }

    &log("Vote $vote canceled");

}

sub check_teams
{

    my @num = keys %tmphash;
    $curr_players = $#num + 1;

    return if ( !$config{'detect_uneven_teams'} );

    my $allies  = 0;
    my $axis    = 0;
    my $players = 0;
    my $specs   = 0;

    foreach my $player ( keys %tmphash )
    {
        if ( $tmphash{$player}{'team'} == 1 )
        {
            $axis++;
        }
        elsif ( $tmphash{$player}{'team'} == 2 )
        {
            $allies++;
        }
        elsif ( $tmphash{$player}{'team'} == 3 )
        {
            $specs++;
        }
        $players++;
    }

    # Do i have all required information from ALL players?
    if ( ( $axis + $allies + $specs ) == $players )
    {
        my $diff = $axis - $allies;
        if (    $diff >= $config{'detect_uneven_teams_difference'}
             || $diff <= -1 * $config{'detect_uneven_teams_difference'} )
        {

            # teams are uneven
            $uneven_teams = time - 27 if ( !$uneven_teams );
        }
        else
        {

            # Teams are even again.
            $uneven_teams = 0;
            $last_notify{'even_teams'} = 0;
        }
    }

    #&log("Current stats: Allies: $allies, Axis: $axis, Specs: $specs (players: $players)");

}

# Checks Username / Password.
sub check_clantag
{
    my $name     = shift;
    my $password = shift;

    foreach my $key ( keys %clans )
    {
        if ( $name =~ /$key/i )
        {

            # Clan tag matches.
            # Password correct ???
            ( $password eq $clans{$key} ) ? return 1 : return 0;
        }
    }

    return 1;

}

sub parse_userinfo
{

    my $line    = shift;
    my %data    = ();
    my $counter = 0;
    my $index   = "";

    # Cut the front...
    $line =~ s/^.*?\\//;

    my @data = split /\\/, $line;

    for (@data)
    {
        if ( $counter % 2 == 0 )
        {
            $index = $_;
        }
        else
        {
            chomp;
            $data{$index} = $_;
            $index = "";
        }
        $counter++;
    }
    return \%data;

}

sub log
{

    my $log = shift;
    chomp $log;
    $log =~ s/\n/::/g;

    # if not in debug mode and message says:
    # 'DEBUG: this is debug text'
    # message will be ignored
    # cade.
    return if $log =~ s/^DEBUG:\s*//i and !$config{'debug'};
    print STDOUT &time2date(time) . " $log\n";

}

# SIGNAL HANDLER FOR QUIT / TERM
sub sig_term
{
    $SIG{TERM} = 'DEFAULT';
    $SIG{QUIT} = 'DEFAULT';
    &log("Received SIGTERM/QUIT. Shutting down.");

    &global_remote_send( "etadmin_mod shutting down...", "ETM-BC" );
    if ( $#sockets > -1 )
    {
        &log("Closing all open connections");
        for (@sockets)
        {

            close($_) if ( $_ ne "" );
        }
    }
    close(SOCK);

    exit(0);
}

# SIGNAL HANDLER FOR HUP
sub sig_hup
{
    &log("Received SIGHUP, reloading config file");
    &reload_config_file;
    &log("Reloading config file done.");
}

# Function for reloading the config files.
sub reload_config_file
{

    # The counter is for the "section". I start with 0 for the first config
    # this triggers a reset of all sections. >0 acts like a include without
    # disabling externals.
    my $counter = 0;
    for my $config_file (@config_files)
    {

        # Recieved SIGHUP, reloading config file
        if ( $config_file && !-e $config_file )
        {
            &log("Couldn't find configfile $config_file\n");
        }
        elsif ($config_file)
        {

            # Loading config file
            &load_config_file( $config_file, 'fh00', $counter );
        }
        $counter++;
    }

    %protected = ();
    &load_shrubbot_cfg();
    &load_protected();
    &load_map_configs();
    &load_birthdays();
    &load_config_file( $admin_config, "ah00", $counter ) if ( $admin_config ne "" );

    &load_badwords();
    @maps = &load_intermission_mapvoting_maps() if ( $config{'intermission_mapvoting'} );

    &post_config_checks();
    &restriction_checks();

}

# All config checks, that have to be done
# after loading the config file come
# in here.
sub post_config_checks
{
    &log("Post config check...");

    if (    ( $config{'spree_detector'} || $config{'deathspree_detector'} )
         && ( !defined(%spree) || !defined(%spree_messages) ) )
    {

        &log(   "Killing Spree messages are missing in the config. Using defaults. "
              . "(See example config of etadmin_mod 0.26+)" );

        # End messages
        $spree_messages{'ends_kill'} =
          "<PLAYER>^8's ^8killing ^8spree ^8ended ^8(^7<KILLS> ^8kills). " . "^8He ^8was ^8killed ^8by ^7<KILLER>^8! ";
        $spree_messages{'ends_teamkill'} =
            "<PLAYER>^8's ^8killing ^8spree ^8ended ^8(^7<KILLS> ^8kills). "
          . "^8He ^8was ^8killed ^8by ^1TEAMMATE ^7<KILLER>^8!";
        $spree_messages{'ends_selfkill'} =
            "<PLAYER>^8's ^8killing ^8spree ^8ended ^8(^7<KILLS> ^8kills). "
          . "^8He ^8killed ^1himself, ^8what ^8a ^8pity!";

        # spree messages
        $spree_messages{'spree'}   = "<PLAYER> ^8is ^8on ^8a ^8killing ^8spree! ^8(^7<KILLS> ^8kills ^8in ^8a ^8row)";
        $spree_messages{'rampage'} = "<PLAYER> ^8is ^8on ^8a ^8rampage! ^8(<KILLS> ^8kills ^8in ^8a ^8row)";
        $spree_messages{'dominating'}  = "<PLAYER> ^8is ^8dominating! ^8(<KILLS> ^8kills ^8in ^8a ^8row)";
        $spree_messages{'unstoppable'} = "<PLAYER> ^8is ^8unstoppable! ^8(<KILLS> ^8kills ^8in ^8a ^8row)";
        $spree_messages{'godlike'}     = "<PLAYER> ^8is ^8godlike!! ^8(<KILLS> ^8kills ^8in ^8a ^8row)";
        $spree_messages{'wicked'}      = "<PLAYER> ^8is ^8wicked ^8sick!!! ^8(<KILLS> ^8kills ^8in ^8a ^8row)";
        $spree_messages{'potter'} = "<PLAYER> ^8is ^8real ^8Potter!!! ^8(Woohoo, ^7<KILLS> ^8kills ^8in ^8a ^8row!)";

        # deathsprees messages: (Replacements: <PLAYER>, <DEATHS>
        $spree_messages{'badday'} = "<PLAYER> ^7seems to have a bad day ... (^3<DEATHS>^7 deaths without a ^1kill^7)";
        $spree_messages{'victim'} =
          "<PLAYER> ^7is on the best way to get ^3victim^7 of the day... (^3<DEATHS> ^7deaths w/o kill)";
        $spree_messages{'asskicked'} =
          "<PLAYER> ^7really gets his ass kicked! Oh well, ^3<DEATHS> ^7deaths w/o ^1kill^7...";

    }

    if ($config{'tcp_interface'} && !$config{'tcp_chat_appearance'}) {
    	$config{'tcp_chat_appearance'}= "^3etadmin_mod(^7<TCP_USERNAME>^3)";
    	&log("Missing tcp_chat_appearance empty, setting default.");
    }

    if ( !$config{'spree_minimum_players'} )
    {
        $config{'spree_minimum_players'} = 0;
    }
    elsif ( $config{'spree_minimum_players'} < 0 || $config{'spree_minimum_players'} > 64 )
    {
        &log("Illegal value for spree_minimum_players. Setting to 0.");
        $config{'spree_minimum_players'} = 0;
    }
    
        
    if ($config{'sound_mappings'} && ($config{'spree_sounds'} || $config{'knife_kill_sound'})) {
    	&log("You can't use sound_mappings combined with spree_sounds or knife_kill_sound. ".
    	      "Deactivating spree_sounds & knife_kill_sound");	
    	$config{'spree_sounds'} = 0;
    	$config{'knife_kill_sound'} = 0;
    }

    # Knifekill sound.
    if ( !$config{'knife_kill_soundfile'} )
    {
        $config{'knife_kill_soundfile'} = "sound/etpro/osp_goat.wav";
    }

    if (    !$config{'cancel_adminlevel'}
         || $config{'cancel_adminlevel'} < 0
         || int( $config{'cancel_adminlevel'} ) != $config{'cancel_adminlevel'} )
    {
        $config{'cancel_adminlevel'} = 1;
    }

    if ( $config{'admin_functions'} )
    {

        # Check the admin commands are only inserted once and are valid.
        for ( my $lvl = 0 ; $lvl < $#admin_func + 1 ; $lvl++ )
        {
            my $ref  = $admin_func[$lvl];
            my %test = ();
            for my $cmd ( sort @$ref )
            {
                if ( $cmd ne "tcp:" and $cmd ne "game:" )
                {
                    $test{$cmd} = 1;
                }
            }

            @$ref = ();
            foreach my $cmd ( sort keys %test )
            {
                push( @$ref, $cmd );
            }
        }

    }

    foreach my $s ( keys %spree )
    {
        if ( !defined( $spree_messages{$s} ) )
        {
            &log("Error: No spree-message defined for $s. Ignoring entry!");
        }
        elsif ( !defined( $position{ "s_" . $s } ) )
        {
            &log("Warning: No position defined for $s. Using default ($position{'default'})");
        }

    }

    if ( $config{'automute_override_lvl'} <= 0 )
    {
        &log("Illegal value for automute_override_lvl. Setting to default = 1");
        $config{'automute_override_lvl'} = 1;
    }

    if ( $config{'suicide_limit'} )
    {
        if ( $config{'suicide_warn_percentage'} > 1 || $config{'suicide_warn_percentage'} < 0 )
        {
            &log("Warning: suicide_warn_percentage out of range. Setting default: 0.66");
            $config{'suicide_warn_percentage'} = 0.66;
        }
    }

    if ( $config{'detect_uneven_teams'} )
    {

        if (    !$config{'uneven_warning1'}
             || !$config{'uneven_warning2'}
             || !$config{'uneven_warning3'}
             || !$config{'uneven_warning4'} )
        {
            &log("uneven_warnings are missing. Added default");
        }
        $config{'uneven_warning1'} = "^1Mhhh. Teams look pretty uneven... ^1Better ^1have ^1a ^1look!"
          if ( !$config{'uneven_warning1'} );
        $config{'uneven_warning2'} = "^1Teams still look pretty uneven... ^1Better ^1have ^1a ^1look!"
          if ( !$config{'uneven_warning2'} );
        $config{'uneven_warning3'} = "^1 Teams look pretty uneven... ^1Please ^1even ^1up ^1teams!"
          if ( !$config{'uneven_warning3'} );
        $config{'uneven_warning4'} = "^1Teams still look pretty uneven... ^1Please ^1someone ^1even ^1teams!"
          if ( !$config{'uneven_warning4'} );
    }

    # Checking punkbuster message prefix
    if ( !$config{'pb_sv_msgprefix'} )
    {
        &log("Setting pb_sv_msgprefix to ^3PunkBuster Server");
        $config{'pb_sv_msgprefix'} = "^3PunkBuster Server";
    }

    if ( !$config{'detect_uneven_teams_difference'}
         || $config{'detect_uneven_teams_difference'} <= 1 )
    {
        $config{'detect_uneven_teams_difference'} = 3;
        &log("detect_uneven_teams_difference: Invalid or missing value. Setting default of 3.");
    }

    $config{'default_kick_duration'} = 5 if ( !$config{'default_kick_duration'} );

    &log("Post config check done.");

}

sub strip_name
{
    my $name = shift;
    return length($name) > 35 ? substr( $name, 0, 35 ) : $name;
}

## loads a config on map start ##
sub load_map_configs
{

    if ( $config{'map_configs'} )
    {

        # first strip of /, if present
        #$config{'map_configs'} =~ s/\/$//;
        &log("Mapname: $mapname");
        my @map   = ();
        my $found = 0;

        if ( $config{'map_configs_order'} == 1 )
        {
            $map[0] = $mapname . ".cfg";
            $map[1] = "default.cfg";
        }
        else
        {
            $map[0] = "default.cfg";
            $map[1] = $mapname . ".cfg";
        }

        # try "mapname".cfg, else "default.cfg" (to reset or something)
        if ( -s $config{'map_configs'} . "/" . $map[0] )
        {
            &load_config_file( $config{'map_configs'} . "/" . $map[0], 'fh00', "empty", 1 );
            $found = 1;
        }

        if ( ( $found == 0 || $config{'map_configs_options'} & 1 ) && -s $config{'map_configs'} . "/" . $map[1] )
        {
            &load_config_file( $config{'map_configs'} . "/" . $map[1], 'fh00', "empty", 1 );
        }

    }

}

sub load_config_file
{

    local ( $file, $fh, $abschnitt, $postload ) = @_;

    $fh = 'fh00' if ( !$fh );
    $fh++;

    if ( !$abschnitt )
    {

        # Reset Hash (not config or spree)
        %clans          = ();
        %external       = ();
        %greetings      = ();
        %alias          = ();
        @admin_func     = ();
        %help           = ();
        %rule           = ();
        %spree_messages = ();
        @banners        = ();
        @bad_names      = ();
        @bad_words      = ();
        %spree          = ();
        %position       = ();
        %sound_mappings = ();

        #%class_restriction = ();
        @rcon_cmds_startround   = ();
        @rcon_cmds_endround     = ();
        @rcon_cmds_intermission = ();
        @rcon_cmds_exitlevel    = ();
    }

    &log("Loading config_file $file");
    open( $fh, $file ) || &log("Error opening file $file: $!");

    my $store = "";
    my $buff  = "";
    while ( sysread $fh, $buff, 4096 )
    {
        $store .= $buff;
    }

    my @lines = split /\r?\n/, $store;

    for (@lines)
    {

        s/\s*\/\/.*//;          # strip of comments with // (even in lines) (used by some people)
        s/(^\s+|\s*\r*$)//g;    # strip off whitespaces and windows breaks

        next if ( !$_ || /^\s*\#/ );

        if (/^\[(.*)\]$/)
        {
            $abschnitt              = lc($1);
            @rcon_cmds_startround   = () if ( $abschnitt eq "rcon_cmds_startround" );
            @rcon_cmds_endround     = () if ( $abschnitt eq "rcon_cmds_endround" );
            @rcon_cmds_intermission = () if ( $abschnitt eq "rcon_cmds_intermission" );
            @rcon_cmds_exitlevel    = () if ( $abschnitt eq "rcon_cmds_exitlevel" );
            @banners                = () if ( $abschnitt eq "banners" );

            # Reset for maximum security
            %external = () if ( $abschnitt eq "externals" && $sec_opts{'r'} );
            next;
        }

        if (/^include [\"\']?(.*?)[\"\']?$/)
        {
            &load_config_file( $1, $fh, $abschnitt, $postload );
        }
        elsif ( $abschnitt eq "config" )
        {
            $config{$1} = $2 if (/^(.*?)\s*=\s*(.*)$/);
            &log("Config: $1 - $2\n") if ( $config{'debug'} > 1 );
        }
        elsif ( $abschnitt eq "positions" )
        {
            $position{$1} = $2 if (/^(.*?)\s*=\s*(.*)$/);
            &log("Position: $1 - $2\n") if ( $config{'debug'} > 1 );
        }
        elsif ( $abschnitt eq "spree" )
        {
            $spree{$1} = $2 if (/^(.*?)\s*=\s*(.*)$/);
            &log("Spree: $1 - $2\n") if ( $config{'debug'} > 1 );
        }
        elsif ( $abschnitt eq "clans" )
        {
            $clans{$1} = $2 if (/^(.*?)\s+=\s+(.*)$/);
            &log("Clantag: $1 - $2\n") if ( $config{'debug'} > 1 );
        }
        elsif ( $abschnitt eq "externals"
                && ( !$sec_opts{'d'} && !( $sec_opts{'e'} && $postload ) ) )
        {
            $external{$1} = $2 if (/^(.*?)\s*=\s*(.*)$/);
            &log("External: $1 - $2\n") if ( $config{'debug'} > 1 );
        }
        elsif ( $abschnitt eq "greetings" )
        {
            $greetings{$1} = $2 if (/^(.*?)\s*=\s*(.*)$/);
            &log("Greeting: $1 - $2\n") if ( $config{'debug'} > 1 );
        }
        elsif ( $abschnitt eq "alias" )
        {
            $alias{ lc($1) } = $2 if (/^(.*?)\s*=\s*(.*)$/);
            &log("Alias: $1 - $2\n") if ( $config{'debug'} > 1 );
        }
        elsif ( $abschnitt eq "help" )
        {
            $help{$1} = $2 if (/^(.*?)\s*=\s*(.*)$/);
            &log("Helptext: $1 - $2\n") if ( $config{'debug'} > 1 );
        }
        elsif ( $abschnitt eq "rules" )
        {
            $rule{$1} = $2 if (/^(.*?)\s*=\s*(.*)$/);
            &log("Rule: $1 - $2\n") if ( $config{'debug'} > 1 );
        }
        elsif ( $abschnitt eq "spree_messages" )
        {
            $spree_messages{$1} = $2 if (/^(.*?)\s*=\s*(.*)$/);
            &log("Spree_message: $1 - $2\n") if ( $config{'debug'} > 1 );
        }
        elsif ( $abschnitt eq "class_restrictions" )
        {
            $class_restriction{$1} = $2 if (/^(.*?)\s*=\s*(.*)$/);
            &log("Classrestricion: $CLASS{$1} - $2\n") if ( $config{'debug'} > 1 );
        }
        elsif ( $abschnitt eq "sound_mappings" )    # Hammer
        {
            $sound_mappings{$1} = $2 if (/^(.*?)\s*=\s*(.*)$/);
            &log("Sound_Mappings: $1 - $2\n") if ( $config{'debug'} > 1 );
        }
        elsif ( $abschnitt eq "on_load" )
        {
            if (/^(rcon|ext)\s*:\s*(.*)$/)
            {
                my $type = $1;
                my $comm = $2;
                &log("Executing: ($type) -> $comm");
                if ( $type eq "rcon" )
                {
                    &cmd($comm);
                }
                elsif ( $type eq "ext" )
                {
                    if ( !$sec_opts{'d'} && !( $sec_opts{'e'} && $postload ) )
                    {
                        my $rc = 0xffff & system($comm);
                        if ( $rc != 0 )
                        {
                            &log( sprintf "system(%s) failed. Return code: %#04x: ", $comm, $rc );
                        }
                        else
                        {
                            &log( sprintf "system(%s) succeeded. Return code: %#04x: ", $comm, $rc )
                              if ( $config{'debug'} > 0 );
                        }
                    }
                }
            }
            &log("Onload: $1 - $2 (executed)\n") if ( $config{'debug'} > 1 );
        }
        elsif ( $abschnitt eq "rcon_cmds_startround" )
        {
            push( @rcon_cmds_startround, $_ );
        }
        elsif ( $abschnitt eq "rcon_cmds_endround" )
        {
            push( @rcon_cmds_endround, $_ );
        }
        elsif ( $abschnitt eq "rcon_cmds_intermission" )
        {
            push( @rcon_cmds_intermission, $_ );
        }
        elsif ( $abschnitt eq "rcon_cmds_exitlevel" )
        {
            push( @rcon_cmds_exitlevel, $_ );
        }
        elsif ( $abschnitt eq "bad_names" )
        {
            push( @bad_names, lc($_) );
            &log("Bad name: $_\n") if ( $config{'debug'} > 1 );
        }

        #elsif ( $abschnitt eq "bad_words" )
        #{
        #    push( @bad_words, lc($_) );
        #    &log("Bad word: $_\n") if ( $config{'debug'} > 1 );
        #}
        elsif ( $abschnitt eq "permissions" )
        {
            if (/^(\d+)\s*=\s*(.*)$/)
            {

                my $level     = $1;
                my $functions = $2;
                $functions =~ s/[,;]/ /g;
                $functions = lc($functions);
                my @func = split( /\s+/, $functions );
                for (@func)
                {
                    push( @{ $admin_func[$level] }, $_ ) if ($_);
                }
            }
        }
        elsif ( $abschnitt eq "banners" )
        {
            push( @banners, $_ );
        }
    }

}

sub check_result
{
    my $command = shift;
    my $found   = shift;
    my @params  = @_;
    if ( $found == 0 )
    {
        &say( "^3$command:^7 Can't find a matching target", @params );
        &log("Command: $command failed, no matching target.")
          if ( $config{'debug'} );
        return 0;
    }
    elsif ( $found < 0 )
    {
        &say( "^3$command:^7 Not enough chars for partial match", @params );
        &log("Command: $command failed, not enough chars for part match")
          if ( $config{'debug'} );
        return 0;
    }
    elsif ( $found > 1 )
    {
        &say( "^3$command:^7 Found more then one target.", @params );
        &log("Command: $command failed, more then one target matches")
          if ( $config{'debug'} );
        return 0;
    }

    return 1;
}

sub load_badwords
{

    return if ( !$config{'automute'} );

    @bad_words = ();

    open( IN, $config{'badwords_file'} ) || &log("Error opening file $config{'badwords_file'}: $!");

    my $store = "";
    my $buff  = "";

    while ( sysread IN, $buff, 4096 )
    {
        $store .= $buff;
    }

    my @lines = split /\r?\n/, $store;

    for my $line (@lines)
    {

        # remove all comments
        $line =~ s/\s*\#(.*)$//;
        $line =~ s/\s*\/\/.*//;    # strip of comments with // (even in lines) (used by some people)
                                   #$line =~ s/(^\s+|\s*\r*$)//g;  # strip off whitespaces and windows breaks
        $line =~ s/\r$//g;         # strip off windows breaks

        # remove lines with just spaces.
        $line =~ s/^\s+$//;

        # remove double spaces
        #$line =~ s/\s+/ /;

        # if there is a rest, push it into the bad words, if it is long enough
        if ( $line && length($line) > 3 )
        {

            # check, if its a regexp, that is at least 2 chars long
            next if ( index( $line, "regexp:" ) == 0 && length($line) < 9 );

            my $good = 1;
            if ( $line =~ /^regexp:(.*)$/ )
            {

                # check the regexp:
                my $test = "quickbrownfox";
                eval { $test =~ /$1/i; };

                if ($@)
                {
                    &log("Badword regular expression \"$line\" contains a error. Loading skipped.");
                    $good = 0;
                }
            }

            if ( $good == 1 )
            {

                &log("Loaded badword: \"$line\"") if ( $config{'debug'} > 1 );
                push( @bad_words, lc($line) );
            }
        }
    }
    close(IN);

}

sub load_birthdays
{

    return if ( !$config{'birthday_notifications'} );

    %birthdays = ();
    &log("Loading birthdays...");
    open( IN, $config{'birthdays_file'} ) || &log("Error opening file $config{'birthdays_file'}: $!");

    my ( $sec, $min, $std, $mtag, $mon, $year, $wochentag, $jahrestag ) = localtime(time);
    $mon++;
    $year += 1900;

    my $counter = 1;
    my $store   = "";
    my $buff    = "";
    while ( sysread IN, $buff, 4096 )
    {
        $store .= $buff;
    }

    my @lines = split /\r?\n/, $store;

    for (@lines)
    {

        s/(^\s*|\s*\r*$)//g;

        if ( $_ && !/\s*\#/ )
        {

            s/\|([^\|]*)\|([^\|]+)$//;
            my $guid     = $1;
            my $birthday = $2;
            my $name     = $_;

            if ( $birthday && $name )
            {
                my ( $d, $m, $y ) = split( '-', $birthday );
                $d =~ s/^0+//;
                $m =~ s/^0+//;
                if ( $d == $mtag && $m == $mon )
                {
                    &log( "Loaded: $name ($guid:$birthday) has a birthday today (Age: " . ( $year - $y ) . ")!" )
                      if ( $config{'debug'} > 1 );
                    $birthdays{$counter}{'name'} = $name;
                    $birthdays{$counter}{'guid'} = $guid;
                    $birthdays{$counter}{'age'}  = ( $year - $y );
                    $counter++;

                }
                else
                {
                    &log("Ignored: $name ($guid:$birthday) has no birthday today.")
                      if ( $config{'debug'} > 2 );
                }

            }
            else
            {
                &log("Ignored: $name - $guid") if ( $config{'debug'} > 2 );
            }

        }
    }

    close(IN);

}

sub disconnect
{
    my $client_id = shift;
    my $guid      = shift || $tmphash{$client_id}{'guid'};

    # remote jobs queued for that player:
    my $href = $tmphash{$client_id}{'jobs'};

    foreach my $jobid ( keys %$href )
    {
        &log("Deleting job: $jobid ($rcon_jobs{$jobid})");
        delete $rcon_jobs{$jobid};
    }

    if ( defined( $tmphash{$client_id} && $tmphash{$client_id}{'name'} ) )
    {

        #&global_remote_send( $tmphash{$client_id}{'name'} . " ^;disconnected on slot $client_id.", "ETM-INFO" );
        &global_remote_send( $tmphash{$client_id}{'name'} . " ^;on slot $client_id disconnected.", "ETM-INFO" );
    }

    &log("Removing: $client_id ($tmphash{$client_id}{'name'}, $guid)")
      if ( $config{'debug'} );

    &set_seen( &convert_name( $tmphash{$client_id}{'name'} ), &time2date(time) )
      if ( $config{'seen_db'} );

    # Save the mute status to the guidbased hash, if wanted.
    if ( $config{'persistent_mute'} && $config{'et_mod'} == 2 )
    {
        if ( $tmphash{$client_id}{'muted'} == 1 )
        {

            my $save       = 0;
            my $etpro_guid = "";

            $etpro_guid = &get_etpro_guid($client_id) if ( $config{'et_mod'} == 2 );

            #PERSISTENT_PMUTE
            #PERSISTENT_GMUTE
            #PERSISTENT_AMUTE

            &log("Testing, if to save mute state of ($guid).") if ( $config{'debug'} );

            if (    ( $config{'persistent_mute'} & PERSISTENT_PMUTE && $tmphash{$client_id}{'pmuted'} )
                 || ( $config{'persistent_mute'} & PERSISTENT_AMUTE && $tmphash{$client_id}{'bad_word_timestamp'} > 0 )
                 || ( $config{'persistent_mute'} & PERSISTENT_GMUTE ) )
            {
                &log("Saving mute state.") if ( $config{'debug'} );
                $save = 1;
            }

            if ($save)
            {

                $tk_hash{$guid}{'muted'}  = 1;
                $tk_hash{$guid}{'pmuted'} = 1 if ( $tmphash{$target}{'pmuted'} == 1 );

                #etpro:
                if ($etpro_guid)
                {
                    $tk_hash{$etpro_guid}{'muted'} = 1;
                    $tk_hash{$etpro_guid}{'pmuted'} = 1 if ( $tmphash{$target}{'pmuted'} == 1 );
                }

                if ( defined( $tmphash{$client_id}{'bad_word_timestamp'} )
                     && $tmphash{$client_id}{'bad_word_timestamp'} > 0 )
                {
                    &log("Saving badwordtimestamp $tmphash{$client_id}{'bad_word_timestamp'}") if ( $config{'debug'} );
                    $tk_hash{$guid}{'bad_word_timestamp'}       = $tmphash{$client_id}{'bad_word_timestamp'} - time;
                    $tk_hash{$etpro_guid}{'bad_word_timestamp'} = $tmphash{$client_id}{'bad_word_timestamp'} - time
                      if ($etpro_guid);
                }
                else
                {
                    delete $tk_hash{$etpro_guid}{'bad_word_timestamp'} if ($etpro_guid);
                    delete $tk_hash{$guid}{'bad_word_timestamp'};
                }
            }
        }
        else
        {

            if ( $config{'et_mod'} == 2 )
            {
                my $etpro_guid = &get_etpro_guid($client_id);
                if ($etpro_guid)
                {
                    delete $tk_hash{$etpro_guid}{'bad_word_timestamp'};
                    delete $tk_hash{$etpro_guid}{'pmuted'};
                    delete $tk_hash{$etpro_guid}{'muted'};
                }
            }

            # Punkbuster guids:
            # delete, if existent.
            delete $tk_hash{$guid}{'bad_word_timestamp'};
            delete $tk_hash{$guid}{'pmuted'};
            delete $tk_hash{$guid}{'muted'};
        }
    }

    &disconnect_guid($guid);

    # Remove Slot informations
    delete $tmphash{$client_id};

    &restriction_checks();
    &check_teams();

}

# return the etpro_guid, if he has a valid one. Else better return nothing.
sub get_etpro_guid
{

    my $client_id = shift;

    #52FF6283916A9467908E6A771CB70285FB41C5E7 (example, win98 guid)

    # Just return it, if its valid (length 40byte)
    if (    $tmphash{$client_id}{'etpro_guid'}
         && $tmphash{$client_id}{'etpro_guid'} =~ /^[a-zA-Z0-9]{40}$/
         && $tmphash{$client_id}{'etpro_guid'} ne "52FF6283916A9467908E6A771CB70285FB41C5E7" )
    {    # I don't want the win98 etpro guid.
        return $tmphash{$client_id}{'etpro_guid'};
    }
    else
    {
        return;
    }

}

sub disconnect_guid
{

    my $guid = shift;
    if ($guid)
    {

        # Update TK Hash Timestamp
        $tk_hash{$guid}{'timestamp'} = time
          if ( $config{'automute'} || $config{'teamkill_restriction'} );

        # Remove GUID / Name / Warnings / etc...
        delete $warnings{$guid};
        delete $warnings_bn{$guid};
        delete $userinfo{$guid};
        delete $tmp_warn{$guid};
        delete $tmp_warn2{$guid};
        delete $gb_data{$guid};
    }

}

# check for guid on the server
# returns 1, if on the server.
# else 0
sub guid_check
{

    my $guid = shift || return 0;

    # check, if guid is still on the server:
    foreach my $player ( keys %tmphash )
    {
        return 1 if ( $tmphash{$player}{'guid'} eq $guid );
    }
    return 0;

}

sub resync
{

    if ( $config{'input_type'} eq "udp" && $config{'et_mod'} == 2 )
    {

        my ( undef, $data ) = &rcon("serverinfo");

        if ( $data =~ /P\s+(.*)\n/ )
        {
            my $teams = $1;

            for ( my $I = 0 ; $I < length($teams) ; $I++ )
            {
                my $team = substr( $teams, $I, 1 );

                print "$I - " . substr( $teams, $I, 1 ) . "\n";
                if ( $team eq "-" )
                {
                    print "Disconneting: $I\n";
                    &disconnect( $tmphash{$I} ) if ( defined( $tmphash{$I} ) );
                }
                else
                {
                    print "Setting $I -> $team\n";
                    $tmphash{$I}{'team'} = $team;
                }
            }
        }

    }
    else
    {
        if ( $config{'et_mod'} == 2 )
        {
            &log("Resync with file isn't possible. Switch to udp for all rcon functions.");
        }
        else
        {
            &log("Resync with shrub isn't possible yet.");
        }
    }
}

sub kick
{
    my $client_id     = shift;
    my $reason        = shift || "Kicked by admin.";
    my $public_output = shift || 1;
    my $timeout       = shift || $config{'default_kick_duration'} || 5;

    &global_remote_send( "Kick: $tmphash{$client_id}{'name'}^;. Reason: $reason.", "ETM-KICK" );
    if ( $config{'use_punkbuster'} )
    {
        my $pb_id = $client_id + 1;
        &cmd("pb_sv_kick $pb_id $timeout \"$reason\"");
    }
    else
    {
        &say( $tmphash{$client_id}{'name'} . "^7 kicked. Reason: ^3" . $reason . "^7." ) if ($public_output);
        &cmd("clientkick $client_id $timeout");
    }
    &log("Removing Cid: $client_id (kicked for $timeout min.)") if ( $config{'debug'} );
    &disconnect($client_id);

}

sub killing_spree_check
{

    my $killed_id   = shift;
    my $killer_id   = shift;
    my $killer_name =
      (    $killer_id > -1
        && $killer_id != 1022 ? $tmphash{$killer_id}{'name'} : $config{'spree_color'} . "End of round." );
    my $killed_name = $tmphash{$killed_id}{'name'};

    if ( $tmphash{$killed_id}{'kills'} >= $spree{'spree'} )
    {

        my $pos = "";
        foreach my $s ( keys %spree )
        {
            $pos = $position{ "s_" . $s }
              if ( $spree{$s} <= $tmphash{$killed_id}{'kills'} && $spree{$s} > 0 );
        }

        select( undef, undef, undef, $spree_delay )
          if ( $config{'input_type'} eq "udp" && pos eq "cp" );

        my $message = "";
        if ( $killer_id == $killed_id || $killer_id == 1022 )
        {
            $message = $spree_messages{'ends_selfkill'};
        }
        elsif (    $tmphash{$killer_id}{'team'} == $tmphash{$killed_id}{'team'}
                && $tmphash{$killer_id}{'team'} > 0 )
        {
            $message = $spree_messages{'ends_teamkill'};
        }
        else
        {
            $message = $spree_messages{'ends_kill'};
        }

        $message =~ s/<PLAYER>/$killed_name/g;
        $message =~ s/<KILLS>/$tmphash{$killed_id}{'kills'}/g;
        $message =~ s/<KILLER>/$killer_name/g;

        #&log ("$message - $pos");
        &say( $message, $pos );

        &log("Killing spree ended: $killed_name (by $killer_name)");

        # Best spree:
        if ( $config{'longest_spree_display'} )
        {

            if (    $best_spree{'alltime'}{'value'} < $tmphash{$killed_id}{'kills'}
                 && $config{'spree_minimum_players'} <= $curr_players )
            {

                my $alltime_record = $best_spree{'alltime'}{'value'} > 0 ? 
			"^3[old: ^7$best_spree{'alltime'}{'name'}^3(^7$best_spree{'alltime'}{'value'}^3) @ ^7"
                     . &time2date( $best_spree{'alltime'}{'timestamp'} )
                     . "^3]" : "";
                     
                # New alltime record.
                say(   "^1New spree record: ^7$killed_name ^3(^7$tmphash{$killed_id}{'kills'}^3 kills) "
                     . $alltime_record );
                &log("spree_record: ^7$killed_name ($tmphash{$killed_id}{'kills'})");

                $best_spree{'alltime'}{'name'}      = $killed_name;
                $best_spree{'alltime'}{'value'}     = $tmphash{$killed_id}{'kills'};
                $best_spree{'alltime'}{'timestamp'} = time;

                # Save record, if wanted.
                if ( $config{'persistent_spree_record'} )
                {

                    # saving result
                    open( OUT, ">var/spree_record.dat" ) or &log("Error writing persistant spree_record: $!");
                    print OUT $best_spree{'alltime'}{'name'} . "\n";
                    print OUT $best_spree{'alltime'}{'value'} . "\n";
                    print OUT $best_spree{'alltime'}{'timestamp'} . "\n";
                    close(OUT);
                }

                # Save map record, if wanted.
                if ( $config{'persistent_map_spree_record'} )
                {

                    $best_spree{'map'}{'name'}      = $killed_name;
                    $best_spree{'map'}{'value'}     = $tmphash{$killed_id}{'kills'};
                    $best_spree{'map'}{'timestamp'} = time;

                    &save_map_spree();
                }

            }

            if (    $config{'persistent_map_spree_record'}
                 && $best_spree{'map'}{'value'} < $tmphash{$killed_id}{'kills'}
                 && $config{'spree_minimum_players'} <= $curr_players )
            {

                my $map_record = $best_spree{'map'}{'value'} > 0 ? 
                       "[old: ^7$best_spree{'map'}{'name'}^3(^7$best_spree{'map'}{'value'}^3) @ ^7"
                     . &time2date( $best_spree{'map'}{'timestamp'} )
                     . "^3]" : "";

                # New map record.
                say(   "^1New mapspree record: ^7$killed_name ^3(^7$tmphash{$killed_id}{'kills'}^3 kills) ".
                	$map_record );

                $best_spree{'map'}{'name'}      = $killed_name;
                $best_spree{'map'}{'value'}     = $tmphash{$killed_id}{'kills'};
                $best_spree{'map'}{'timestamp'} = time;

                &save_map_spree();

            }

            if (    $config{'persistent_map_spree_record'}
                 && $best_spree{'currmap'}{'value'} < $tmphash{$killed_id}{'kills'} )
            {

                $best_spree{'currmap'}{'name'}      = $killed_name;
                $best_spree{'currmap'}{'value'}     = $tmphash{$killed_id}{'kills'};
                $best_spree{'currmap'}{'timestamp'} = time;

            }

        }

    }
    $tmphash{$killed_id}{'kills'} = 0;

}

sub admin_command
{

    my $line            = shift;
    my $name            = shift;
    my $command_string  = shift;
    my $base            = shift || "game";
    my $guid            = shift || $userinfo{$name};
    my $silent          = shift || 0;
    my $remote_call     = shift || -1;
    my $remote_query_id = shift || "";

    $remote_call--;

    my @say_params = ();
    if (
        $config{'silent_private_messages'}

        && ( index( $line, "etpro privmsg:" ) == 0 || index( $line, "saybuddy:" ) == 0 )
       )

      #&& index( $line, "etpro privmsg:" ) == 0
      #  && &etpro_pm_check($mod_version) )
    {
        if ( &etpro_pm_check($mod_version) )
        {
            &log("Sending private reply.") if ( $config{'debug'} );
            @say_params = ( "chatclient", &name2client_id($name) );
        }
        elsif ( $config{'et_mod'} == 1 )
        {
            @say_params = ( "chatclient", &name2client_id($name) );
        }

    }
    elsif ( $remote_call >= 0 )
    {
        @say_params = ( "tcp", $remote_call, $silent, $remote_query_id );

        #&log("Setting params to: ".join (" ", @say_params));
    }

    my @data = split /\s+/, $command_string;
    $data[0] = lc( $data[0] );

    if ( $data[0] eq "whos_ya_daddy" )
    {
        &say(
              "^3My ^Fdaddy ^3and ^Fmaker ^3of the ^2etadmin_mod ^3is "
                . "^8H. Potter ^3from ^Fwww.gamesunited.de ^3!!!",
              @say_params
            );
        return;
    }

    if ( defined( $external{ $data[0] } ) && $external{ $data[0] } )
    {
        next if ( $config{'permission_based_external_commands'} && !&admin_check( $guid, $data[0], $base ) );

        my $convert_name = &convert_name( $name, 0, 0 );
        my $client_id    = &name2client_id($name);
        my $command      = $external{ $data[0] };
        my $command_name = $data[0];
        my $client_id    = &name2client_id($name);
        my $pb_id        = $data[1] + 1;
        my $admin_level  = &get_admin_level($guid);
        my $parameter    = $command_string;
        $parameter =~ s/^$command_name\s*//;
        $parameter =~ s/([\$\`\"\'])/\\$1/g;

        # Escape "bad" characters
        $convert_name =~ s/([\$\`\"])/\\$1/g;
        $name         =~ s/([\$\`\"])/\\$1/g;

        my ( $new_id, $found ) = ( -1, 0 );
        if ( index( $command, "<PART2" ) > -1 )
        {
            ( $new_id, $found ) = &part2complete( $parameter, 1 );
            return if ( !&check_result( $data[0], $found, @say_params ) );

            my $new_name = $tmphash{$new_id}{'name'};
            my $cname = &convert_name( $new_name, 0, 0 );
            $new_name =~ s/([\$\`\"])/\\$1/g;
            $cname    =~ s/([\$\`\"])/\\$1/g;

            $command =~ s/<PART2ID>/$new_id/g                      if ( index( $command, "<PART2ID>" ) > -1 );
            $command =~ s/[\"\']?<PART2CNAME>[\"\']?/"$new_name"/g if ( index( $command, "<PART2CNAME>" ) > -1 );
            $command =~ s/[\"\']?<PART2NAME>[\"\']?/"$cname"/g     if ( index( $command, "<PART2NAME>" ) > -1 );
            $command =~ s/<PART2IP>/$tmphash{$new_id}{'ip'}/g      if ( index( $command, "<PART2IP>" ) > -1 );
            $command =~ s/<PART2GUID>/$tmphash{$new_id}{'guid'}/g  if ( index( $command, "<PART2GUID>" ) > -1 );

            if ( index( $command, "<PART2PBID>" ) > -1 )
            {
                my $pb_id = $new_id + 1;
                $command =~ s/<PART2PBID>/$pb_id/g;
            }

            if ( index( $command, "<PART2ADMINLEVEL>" ) > -1 )
            {
                my $gu = &get_admin_level( $tmphash{$new_id}{'guid'} );
                $command =~ s/<PART2ADMINLEVEL>/$gu/g;
            }

        }

        $command =~ s/<CLIENT_ID>/$client_id/g;
        $command =~ s/<ID2PBID>/$pb_id/g;
        $command =~ s/<GUID>/$guid/g;
        $command =~ s/[\"\']?<PARAMETER>[\"\']?/"$parameter"/g;
        $command =~ s/[\"\']?<PLAYER>[\"\']?/"$convert_name"/g;
        $command =~ s/[\"\']?<COLOR_PLAYER>[\"\']?/"$name"/g;
        $command =~ s/<SERVER_ADDR>/$config{'server_addr'}/g;
        $command =~ s/<SERVER_PASSWORD>/$config{'server_password'}/g;
        $command =~ s/<SERVER_PORT>/$config{'server_port'}/g;
        $command =~ s/<PLAYER_CLASS>/$CLASS{$tmphash{$client_id}{'class'}}/g;
        $command =~ s/<PLAYER_TEAM>/$SIDE{$tmphash{$client_id}{'team'}}/g;
        $command =~ s/<ADMIN_?LEVEL>/$admin_level/g;

        #print "Name: $name ($convert_name)\n";
        #print $command."\n";

        &log("Calling: $command") if ( $config{'debug'} > 1 );
        my $data = qx<$command>;
        chomp $data;
        &say( $data, @say_params );
        return;
    }

    return unless ( $config{'admin_functions'} || $config{'seen_db'} );

    &log("Player: $name, Command: $command_string") if ( $config{'debug'} );

    if (    $config{'intermission_mapvoting'}
         && ( $data[0] eq "mapvote" || $data[0] eq "mv" )
         && &admin_check( $guid, "mapvote", $base ) )
    {

        if ( $intermission != 1 )
        {
            &say( "^3mapvote: ^7You can only vote in intermission.", @say_params );
        }
        elsif ( $mapvote{'state'} > 0 && $mapvote{'state'} < 4 )
        {

            if ( !$data[1] )
            {
                &display_mapvoting();
            }
            else
            {
                my $client_id = &name2client_id($name);
                if ( $tmphash{$client_id}{'mapvote'} ne $data[1] )
                {

                    my $target = $data[1];
                    if ( !defined( $map{ $data[1] } ) )
                    {
                        for (@maps)
                        {
                            if ( index( $_, $target ) > -1 )
                            {
                                $target = $_;
                                last;
                            }
                        }
                    }

                    # does this map exists in the map pool
                    if ( defined( $map{$target} ) )
                    {

                        # You already voted, so i remove your last vote.
                        if ( $map{ $tmphash{$client_id}{'mapvote'} } )
                        {
                            if ( &get_admin_level( $tmphash{$client_id}{'guid'} ) == 0 )
                            {
                                $map{ $tmphash{$client_id}{'mapvote'} }--;
                            }
                            else
                            {

                                # Admin votes count more then normal votes
                                $map{ $tmphash{$client_id}{'mapvote'} } -=
                                  ( 1 + ( &get_admin_level( $tmphash{$client_id}{'guid'} ) / 10 ) );
                            }
                        }

                        if ( &get_admin_level( $tmphash{$client_id}{'guid'} ) == 0 )
                        {
                            $map{$target}++;
                        }
                        else
                        {

                            # Admin votes count more then normal votes
                            $map{$target} += ( 1 + ( &get_admin_level( $tmphash{$client_id}{'guid'} ) / 10 ) );
                            &log( "Vote counts more then normal: "
                                  . ( 1 + ( &get_admin_level( $tmphash{$client_id}{'guid'} ) / 10 ) ) );
                        }

                        my $old_target = $tmphash{$client_id}{'mapvote'};
                        $tmphash{$client_id}{'mapvote'} = $target;

                        if ( $config{'et_mod'} == 2 || $config{'et_mod'} == 1 )
                        {

                            # Etpro / shrub
                            &say( "^3mapvote: ^7You voted for map ^3$target^7.", "chatclient", &name2client_id($name) )
                              if ( $target ne $old_target );
                        }
                        else
                        {

                            # shrub / other
                            &say( "^3mapvote: ^7$name^7 voted for map $target", "chatclient", $client_id )
                              if ( $target ne $old_target );
                        }

                        #&say("^3mapvote: ^7$name^7 voted for map $target", @say_params);

                    }
                    else
                    {

                        # You already voted for that map.
                        #&say("^3mapvote: ^7The map $target is not in the mappool.", @say_params);
                    }
                }
                else
                {

                    #&say("^3mapvote: ^7You already voted for the map $data[1]", @say_params);
                }

                #&mapvote_check();
            }
        }

    }
    elsif (    $config{'admin_functions'}
            && $data[0] eq "specall"
            && &admin_check( $guid, "specall", $base ) )
    {
        my @exec = ();

        foreach my $key ( keys %tmphash )
        {

            # Only push players in teams to spectator.
            push( @exec, "forceteam $key s" ) if ( $tmphash{$key}{'team'} == 1 || $tmphash{$key}{'team'} == 2 );
        }

        if ( $#exec > -1 )
        {
            my $exec = join( ';', @exec );
            &log("Executing: $exec");
            &cmd( "set etadmin \"$exec ; say ^3specall: ^7Moving " . ( $#exec + 1 ) . " players to spectator.\"" );
            &cmd("vstr etadmin");
        }
        else
        {
            &say( "^3specall: ^7Moving 0 players to spectator." . $warning, @say_params );
        }

    }
    elsif (    $config{'admin_functions'}
            && $data[0] eq "spec999"
            && &admin_check( $guid, "spec999", $base ) )
    {
        my ( $say, $data ) = &cmd("status");
        my @players = split( /\n/, $data );
        my @exec    = ();

        #my $counter = 0;

        for (@players)
        {
            if ( $_ =~ /^\s*(\d+)\s*\d+\s+999\s+/ )
            {

                # Only push players in teams to spectator.
                push( @exec, "forceteam $1 s" ) if ( $tmphash{$1}{'team'} == 1 || $tmphash{$1}{'team'} == 2 );

            #$counter ++;
            #if ($counter % 16 == 0) {
            #    my $exec = join( ' ; ', @exec );
            #    &log("Executing: $exec");
            #    &rcon( "set etadmin \"$exec ; say ^3spec999: ^7Moving " . ( $#exec + 1 ) . " players to spectator.\"");
            #    &rcon( "vstr etadmin" );
            #    @exec = ();
            #}
            }
        }
        if ( $#exec > -1 )
        {
            my $exec = join( ' ; ', @exec );
            &log("Executing: $exec") if ( $config{'debug'} );
            &cmd( "set etadmin \"$exec ; say ^3spec999: ^7Moving " . ( $#exec + 1 ) . " players to spectator.\"" );
            &cmd("vstr etadmin");
        }
        else
        {
            &say( "^3spec999: ^7Moving 0 players to spectator." . $warning, @say_params );
        }

    }
    elsif (    $config{'admin_functions'}
            && $data[0] eq "admintest"
            && &admin_check( $guid, "admintest", $base ) )
    {
        my $level   = 0;
        my $warning = "";
        $level = &get_admin_level($guid);

        if ( defined( $warn_hash{$guid}{'value'} ) && $warn_hash{$guid}{'value'} > 0 )
        {
            $warning =
                "^7(^1Warning: ^7"
              . $warn_hash{$guid}{'reason'} . "^7["
              . $warn_hash{$guid}{'value'} . "/"
              . ( $config{'warn_limit'} - 1 ) . "])";
        }

        &say( "^3admintest: ^7$name ^7is a level $level user ($level{$level}^7)" . $warning, @say_params );
    }
    elsif (    $config{'admin_functions'}
            && $config{'simple_stats'}
            && $data[0] eq "stats"
            && &admin_check( $guid, "stats", $base ) )
    {

        if ( $base eq "tcp" )
        {
            &say("^3stats: ^7TCP-Connections can't have stats.");
            return;
        }

        my $client_id  = &name2client_id($name);
        my $kills      = $tmphash{$client_id}{'overall'}{'kills'} || 0;
        my $deaths     = $tmphash{$client_id}{'overall'}{'deaths'} || 0;
        my $teamkills  = $tmphash{$client_id}{'overall'}{'teamkills'} || 0;
        my $teamdeaths = $tmphash{$client_id}{'overall'}{'teamdeaths'} || 0;
        my $suicides   = $tmphash{$client_id}{'overall'}{'suicides'} || 0;
        $deaths += $suicides;

        my $online_time = int( ( time - $tmphash{$client_id}{'joined'} ) / 60 );
        my $killratio     = $deaths > 0      ? sprintf( "%.2f", $kills / $deaths )         : "N/A";
        my $teamkillratio = $teamdeaths > 0  ? sprintf( "%.2f", $teamkills / $teamdeaths ) : "N/A";
        my $kpm           = $online_time > 0 ? sprintf( "%.2f", $kills / $online_time )    : "N/A";

        &say(   "^3stats: ^7$tmphash{$client_id}{'name'}^7: K:" . $kills . "/D:" . $deaths . "[R:"
              . $killratio . "] " . "TK:"
              . $teamkills . "/TD:"
              . $teamdeaths . "[R:"
              . $teamkillratio
              . "] KPM:"
              . $kpm
              . " time: ${online_time} min" );

    }

    elsif ( $config{'admin_functions'} && $data[0] eq "crazygravity" )
    {
        if ( &admin_check( $guid, "crazygravity", $base ) )
        {

            # Damn, i hate me for that bad if else block. I clean it up later.
            # FIX, FIX
            if ( $data[1] eq "" )
            {
                &say( "^3crazygravity:^7 usage crazygravity 0/1 (0 = off, 1 = on, now: $crazy_gravity)", @say_params );
            }
            elsif ( $data[1] == 1 )
            {
                $crazy_gravity        = 1;
                $crazy_gravity_time   = time;
                $crazy_gravity_notify = 0;
                &say( "^3crazygravity: ^7activated. Fasten your seatbelts!", @say_params );
                &log("Activating crazy gravity mode (by $name)");
            }
            elsif ( $data[1] == 0 )
            {
                $crazy_gravity      = 0;
                $crazy_gravity_time = 0;
                &say( "^3crazygravity: ^7deactivated. Reseting gravity.", @say_params );
                &log("Deactivating crazy gravity mode (by $name)");
                &cmd("g_gravity 800");
            }
            else
            {
                &say( "^3crazygravity:^7 usage crazygravity 0/1 (0 = off, 1 = on, now: $crazy_gravity)", @say_params );
            }
        }
    }
    elsif ( $config{'admin_functions'} && $data[0] eq "listcmds" )
    {
        return unless &admin_check( $guid, "listcmds", $base );
        $admin_level = &get_admin_level($guid);

         if ( $base eq "tcp" )
         {
             @say_params = ( "tcp", $remote_call, 1, $remote_query_id );
         } else {
             @say_params = ( "chatclient", &name2client_id($name) );
         }

        my $start =
          ( defined( $data[1] ) && int( $data[1] ) >= 0 && int( $data[1] ) <= $admin_level )
          ? int( $data[1] )
          : 0;
        my $stop = $start > 0
          && $start < $admin_level ? $start : $admin_level;

        my $outstring = "Admin commands:\n";
        for my $lvl ( $start .. $stop )
        {
            my @out = ();
            $outstring .= "Level $lvl: ";
            my $ref = $admin_func[$lvl];

            for my $cmd2 ( sort @$ref )
            {
            	my $cmd = $cmd2;
                next if ( index( $cmd, "tcp" ) == 0 || !$cmd );

                $cmd =~ s/^game://;
                if ( $cmd && defined( $rights{$cmd} ) )
                {
                    push( @out, "right:$cmd" );
                }
                elsif ( defined( $listcmds{$cmd} ) && $listcmds{$cmd} == 1 )
                {
                    next;
                }
                else
                {
                    push( @out, "$config{'command_prefix'}" . $cmd );
                }

            }
            if ( $#out > -1 )
            {
                for my $command (@out)
                {
                    $outstring .= "$command ";
                }
                $outstring .= "\n";
            }
        }
        if ( length($outstring) )
        {
            &say( $outstring, @say_params );
        }
    }
    elsif ( $config{'admin_functions'} && $data[0] eq "help" )
    {

        next if ( !&admin_check( $guid, "help", $base ) );

        if ( !defined( $data[1] ) )
        {
            &say( "^3help:^7 Usage: help <command>", @say_params );
        }
        else
        {
            if ( &admin_check( $guid, $data[1], $base ) )
            {
                if ( defined( $help{ $data[1] } ) )
                {
                    &say( $help{ $data[1] }, @say_params );
                }
                else
                {
                    &say( "^7No help available for ^3$data[1]", @say_params );
                }
            }
            else
            {
                if ( defined( $help{ $data[1] } ) )
                {
                    &say( "^3help: ^7You dont have permission to use ^3$data[1]^7!", @say_params );
                }
                else
                {
                    &say( "^7No help available for ^3$data[1]^7!", @say_params );
                }
            }
        }
    }
    elsif ( $config{'admin_functions'} && $data[0] eq "resync" )
    {
        if ( &admin_check( $guid, "resync", $base ) )
        {
            if ( $config{'et_mod'} == 2 )
            {
                &resync();
                &say( "^3resync: ^7Resync done.", @say_params );
            }
            else
            {
                &say( "^3resync: ^7Resync with shrub / etmain / other isn't possible yet.", @say_params );
            }
        }
    }
    elsif ( $config{'admin_functions'} && $data[0] eq "readconfig" )
    {
        if ( &admin_check( $guid, "readconfig", $base ) )
        {
            &reload_config_file();
            &say( "Reloading configfile done.", @say_params );
        }
    }
    elsif ( $config{'admin_functions'} && $data[0] eq "loadconfig" )
    {
        if ( &admin_check( $guid, "loadconfig", $base ) )
        {
            my $config = $data[1];
            if ( $config ne "" )
            {
                if ( !( $config =~ /[^\w\.]/ ) )
                {
                    my $load_file = "";
                    my $config_dir = $config{'loadable_configs'} || "etc/configs";
                    $config = "$config_dir/$config";
                    if (    ( -s "$config" && ( $load_file = $config ) )
                         || ( -s "$config.cfg" && ( $load_file = $config . ".cfg" ) ) )
                    {
                        &load_config_file( $load_file, "lc00", 1 );
                        &load_config_file( $admin_config, "ac00", 2 ) if ( $admin_config ne "" );
                        &say( "Loading configfile " . $data[1] . " done.", @say_params );
                    }
                    else
                    {
                        &say( "^3loadconfig: ^7loading configfile failed: Config not found.", @say_params );
                    }
                }
                else
                {
                    &say( "^3loadconfig: ^7loading configfile failed: Illegal name.", @say_params );
                }
            }
            else
            {
                &say( "^3loadconfig: ^7Usage: " . $config{'command_prefix'} . "loadconfig <configname>.", @say_params );
            }
        }
    }
    elsif ( $config{'admin_functions'} && $config{'longest_spree_display'} && $data[0] eq "spree_reset" )
    {
        if ( &admin_check( $guid, "spree_reset", $base ) )
        {
            $best_spree{'alltime'}{'name'}      = "Nobody";
            $best_spree{'alltime'}{'value'}     = 0;
            $best_spree{'alltime'}{'timestamp'} = time;
            $best_spree{'map'}{'name'}          = "Nobody";
            $best_spree{'map'}{'value'}         = 0;
            $best_spree{'map'}{'timestamp'}     = time;
            $best_spree{'currmap'}{'name'}      = "Nobody";
            $best_spree{'currmap'}{'value'}     = 0;
            $best_spree{'currmap'}{'timestamp'} = time;

            # remove overall spree_record
            if ( $config{'persistent_spree_record'} )
            {
                unlink "var/spree_record.dat";
            }

            # remote map spree's
            if ( $config{'persistent_map_spree_record'} )
            {
                &log("Deleting map spree records") if ( $config{'debug'} );
                unlink <var/*_spree_record.dat>;
            }

            &say( "^3spree_reset: ^7Spree record deleted.", @say_params );
        }
    }
    elsif ( $config{'admin_functions'} && $config{'longest_spree_display'} && $data[0] eq "spree_record" )
    {
        if ( &admin_check( $guid, "spree_record", $base ) )
        {
            if ( !$config{'persistent_map_spree_record'} )
            {

                my $overall_record =
                  !$best_spree{'alltime'}{'value'}
                  ? "none "
                  : "^7$best_spree{'alltime'}{'name'} "
                  . "(^7$best_spree{'alltime'}{'value'} ^3kills @ ^7"
                  . &time2date( $best_spree{'alltime'}{'timestamp'} ) . "^3)";

                # old (without persistent_map_spree_record)
                say( "^3spree_record: $overall_record", @say_params );

            }
            else
            {

                my $map_record =
                  !$best_spree{'map'}{'value'}
                  ? "none "
                  : "$best_spree{'map'}{'name'} ^3(^7$best_spree{'map'}{'value'}^3) @ ^7"
                  . &time2date( $best_spree{'map'}{'timestamp'} );

                my $overall_record =
                  !$best_spree{'alltime'}{'value'}
                  ? "none "
                  : "^7$best_spree{'alltime'}{'name'} "
                  . "^3(^7$best_spree{'alltime'}{'value'}^3) @ ^7"
                  . &time2date( $best_spree{'alltime'}{'timestamp'} );

                # new (with persistent_map_spree_record)
                say( "^3spree_record: ^3map ^7${mapname}^3: ^7${map_record}^3[^7overall: ${overall_record}^3]",
                     @say_params );
            }
        }
    }
    elsif ( $config{'admin_functions'} && $data[0] eq "pmute" )
    {
        if ( &admin_check( $guid, "pmute", $base ) )
        {

            my $command = $data[0];
            my $target  = $data[1];
            my $found   = 0;
            my $sub;
            ( $target, $found ) = &part2complete( $target, 1 );

            return if ( !&check_result( $command, $found, @say_params ) );

            # Try to pmute a fellow or higher admin?
            if ( &get_admin_level( $tmphash{$target}{'guid'} ) >= &get_admin_level($guid) )
            {
                &say( "^3pmute:^7 You can't pmute $tmphash{$target}{'name'}^7. ", @say_params );
                return;
            }

            # delete automute tag.
            delete $tmphash{$target}{'bad_word_timestamp'};

            if ( $tmphash{$target}{'pmuted'} == 1 )
            {
                &say( "^3pmute:^7 $tmphash{$target}{'name'}^7 already has been pmuted.", @say_params );
            }
            else
            {
                if ( $tmphash{$target}{'mute'} != 1 )
                {
                    &cmd("ref mute $target");
                    $tmphash{$target}{'mute'} = 1;
                }
                &say( "^3pmute:^7 $tmphash{$target}{'name'}^7 has been pmuted.", @say_params );
                $tmphash{$target}{'pmuted'} = 1;
            }
        }

    }
    elsif ( $config{'admin_functions'} && $data[0] eq "finger" )
    {
        if ( &admin_check( $guid, "finger", $base ) )
        {

            my $command = $data[0];
            my $target  = $data[1];
            my $found   = 0;
            my $sub;
            ( $target, $found ) = &part2complete( $target, 1 );

            return if ( !&check_result( $command, $found, @say_params ) );

            if ( &get_admin_level( $tmphash{$target}{'guid'} ) )
            {

                if ( &convert_name( $tmphash{$target}{'name'} ) ne
                     &convert_name( $admins_name{ $tmphash{$target}{'guid'} } ) )
                {
                    $sub = "^7(^5" . $admins_name{ $tmphash{$target}{'guid'} } . "^7) ";
                }

            }
            my $level = &get_admin_level( $tmphash{$target}{'guid'} );

            my $warning = "";
            if ( defined( $warn_hash{ $tmphash{$target}{'guid'} } )
                 && $warn_hash{ $tmphash{$target}{'guid'} }{'value'} > 0 )
            {
                $warning =
                    "^7(^1Warning: ^7"
                  . $warn_hash{ $tmphash{$target}{'guid'} }{'reason'} . "^7["
                  . $warn_hash{ $tmphash{$target}{'guid'} }{'value'} . "/"
                  . ( $config{'warn_limit'} - 1 ) . "])";
            }

            &say(
                  "^3$command: ^7$tmphash{$target}{'name'}^7 " . $sub
                    . "is a level ^3$level^7 user ($level{$level}^7)"
                    . $warning,
                  @say_params
                );

        }
    }
    elsif ( $config{'admin_functions'} && $data[0] eq "setlevel" )
    {
        if ( &admin_check( $guid, "setlevel", $base ) )
        {
            my $command = $data[0];
            my $target  = $data[1];
            my $lvl     = $data[2];
            my $found   = 0;

            ( $target, $found ) = &part2complete( $target, 1 );

            return if ( !&check_result( $command, $found, @say_params ) );

            my $tmplvl = &get_admin_level($guid);
            if ( $lvl > $tmplvl )
            {
                &say( "^3setlevel:^7 You can't set $tmphash{$target}{'name'}^7 to a level higher then you have. ",
                      @say_params );
                return;
            }

            # Workaround, if the GUID isn't known yet.
            if ( $tmphash{$target}{'guid'} eq "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX" )
            {
                &say( "^3setlevel:^7 It's not possible to setlevel $tmphash{$target}{'name'} ^7yet. GUID unknown. ",
                      @say_params );
                return;
            }

            if ( defined( $tmphash{$target} ) && defined( $level{$lvl} ) )
            {

                &log(   "Setlevel: $tmphash{$target}{'name'} ($tmphash{$target}{'guid'}) -> $lvl (by "
                      . &convert_name($name)
                      . ")\n" );

                # Looks all ok to me.
                &shrub_admin( $config{'shrubbot_cfg'}, $tmphash{$target}{'guid'},
                              $lvl, &convert_name( $tmphash{$target}{'name'}, 0, 0 ) );

                # Reload config files.
                %protected = ();
                &load_shrubbot_cfg;
                &load_protected;

                # Say the real new level (0 if something went completly wrong)
                &say( "^3setlevel:^7 $tmphash{$target}{'name'}^3 is now a level ^7$lvl " . "^3user ($level{$lvl}^3).",
                      @say_params );
            }
            else
            {
                &say( "^3setlevel:^7 Invalid user or level specified...", @say_params );
            }
        }

    }
    elsif ( $config{'admin_functions'} && $data[0] eq "putclan" )
    {
        if ( &admin_check( $guid, "putclan", $base ) )
        {
            my @exec = ();

            if ( $data[1] && $data[2] && length( $data[1] ) > 1 && $data[2] =~ /^[rbs]$/ )
            {
                &log("Moving all players with \"$data[1]\" in their name to $data[2]");
                my $moved = 0;
                foreach my $id ( keys %tmphash )
                {
                    if ( $tmphash{$id}{'team'} ne $SIDE3{ $data[2] } )
                    {
                        my $conv = lc( &convert_name( $tmphash{$id}{'name'} ) );
                        if ( index( $conv, lc( $data[1] ) ) > -1 )
                        {
                            push( @exec, "forceteam $id $data[2]" );

                            #$tmphash{$id}{'team'} = $SIDE3{ $data[2] };
                            &log("Moving: $id $data[2]") if ( $config{'debug'} > 0 );
                        }
                    }
                }

                if ( $#exec > -1 )
                {
                    my $exec = join( ";", @exec );
                    &cmd(   "set etadmin \"$exec; say ^3putclan: ^7Moving "
                          . ( $#exec + 1 )
                          . " to $SIDE{$SIDE3{$data[2]}}.\"" );
                    &cmd("vstr etadmin");
                }
                else
                {
                    &say( "^3putclan: ^7Moving 0 players to $SIDE{$SIDE3{$data[2]}}.", @say_params );
                }
            }
            else
            {
                &say( "^3putclan: ^7Usage: putclan <part of name> <b|r|s>", @say_params );
            }

        }
        else
        {

            # No permission
        }
    }
    elsif ( $config{'admin_functions'} && $config{'teamkill_restriction'} && $data[0] eq "tkindex" )
    {

        if ( $data[1] && &admin_check( $guid, "tkindex_admin", $base ) )
        {

            shift @data;

            #&log("Searching for $data[1]");
            my $target = join( ' ', @data );

            # admin tk_index
            my ( $new_id, $found ) = &part2complete( $target, 1 );
            if ( &check_result( "tkindex", $found, @say_params ) )
            {
                $tk_hash{$guid}{'value'} = 0
                  if ( !$tk_hash{ $tmphash{$new_id}{'guid'} }{'value'} );
                &say(
                      "^3tkindex:^7 $tmphash{$new_id}{'name'}^7 has a tk index of "
                        . "^3$tk_hash{$tmphash{$new_id}{'guid'}}{'value'}^7. ("
                        . ( $tk_hash{ $tmphash{$new_id}{'guid'} }{'value'} > -1 ? "^2OK" : "^1NOT OK" ) . "^7)",
                      @say_params
                    );
            }

        }
        elsif ( &admin_check( $guid, "tkindex", $base ) )
        {

            # user tk_index
            $tk_hash{$guid}{'value'} = 0 if ( !$tk_hash{$guid}{'value'} );
            &say(
                  "^3tkindex:^7 $name^7 has a tk index of ^3$tk_hash{$guid}{'value'}^7. ("
                    . ( $tk_hash{$guid}{'value'} > -1 ? "^2OK" : "^1NOT OK" ) . "^7)",
                  @say_params
                );
        }
    }
    elsif ( $data[0] eq "dewarn" && $config{'use_advanced_warn'} )
    {

        return unless &admin_check( $guid, "dewarn", $base );

        my $command = shift @data;
        if ( $data[0] )
        {

            ( $target, my $found ) = &part2complete( $data[0], 1 );
            return if ( !&check_result( $command, $found, @say_params ) );

            if ( $warn_hash{ $tmphash{$target}{'guid'} }{'value'} )
            {

                $data[1] = int( $data[1] );

                if ( $data[1] > 0 && $warn_hash{ $tmphash{$target}{'guid'} }{'value'} > $data[1] )
                {
                    $warn_hash{ $tmphash{$target}{'guid'} }{'value'} -= $data[1];
                    &say( "^3dewarn: ^7Warninglevel has been decreased.", @say_params );
                }
                else
                {
                    delete $warn_hash{ $tmphash{$target}{'guid'} };
                    &say( "^3dewarn: ^7Warning has been deleted.", @say_params );
                }
            }
            else
            {
                &say( "^3dewarn: ^7$tmphash{$target}{'name'} ^7has no warning set.", @say_params );
            }

        }
        else
        {
            &say("^3dewarn: ^7Usage: $config{'command_prefix'}dewarn <id|name>");
        }

    }
    elsif ( $data[0] eq "warn" && $config{'use_advanced_warn'} )
    {

        return unless &admin_check( $guid, "warn", $base );

        # Remove command
        my $command = shift @data;

        if ( $data[0] && $data[1] )
        {

            my $target = shift @data;
            my $reason = join( ' ', @data );

            ( $target, my $found ) = &part2complete( $target, 1 );
            return if ( !&check_result( $command, $found, @say_params ) );

            if ( &get_admin_level( $tmphash{$target}{'guid'} ) >= &get_admin_level($guid) )
            {
                &say( "^3warn: ^7You can't warn a fellow admin!", @say_params );
                return;
            }

            $warn_hash{ $tmphash{$target}{'guid'} }{'value'}++;
            $warn_hash{ $tmphash{$target}{'guid'} }{'timestamp'} = time;
            $warn_hash{ $tmphash{$target}{'guid'} }{'reason'}    = $reason;

            &log(   "warn: "
                  . &convert_name( $name, 0, 1 ) . "("
                  . &get_admin_level($guid)
                  . ") warned "
                  . &convert_name( $tmphash{$target}{'name'}, 0, 1 ) . "("
                  . $tmphash{$target}{'guid'}
                  . "): $reason (Count: "
                  . "$warn_hash{ $tmphash{$target}{'guid'} }{'value'})" );

            if ( $warn_hash{ $tmphash{$target}{'guid'} }{'value'} >= $config{'warn_limit'} )
            {

                # kick / temp ban (limit reached)
                &log(   "warn: Warning limit reached. Kicking "
                      . &convert_name( $tmphash{$target}{'name'}, 0, 1 ) . "("
                      . $tmphash{$target}{'guid'}
                      . ")" );

                if ( $config{'warn_kicklength'} >= 5 )
                {

                    my $timestamp = $config{'ban_timestamp_format'} eq "shrub" ? ( time - 946767600 ) : time;
                    $timestamp = $timestamp + $config{'warn_kicklength'};

                    my $ip = defined( $tmphash{$target}{'ip'} ) ? $tmphash{$target}{'ip'} : "0.0.0.0";
                    &shrub_ban( $config{'shrubbot_cfg'}, "add", $tmphash{$target}{'guid'},
                                $timestamp, &convert_name( $name,                       0, 1 ),
                                $ip, $reason, &convert_name( $tmphash{$target}{'name'}, 0, 1 ) );
                }

                if (    $config{'warn_kicklength'} > 0
                     && $config{'warn_kicklength'} < 5 )
                {

                    # The kick might be longer then the ban ...
                    my $temp_dur = int( $config{'warn_kicklength'} / 60 ) + 1;
                    &kick( $target, "$reason", 0, $temp_dur );
                }
                else
                {
                    &kick( $target, "tmpban: $reason(" . $config{'warn_kicklength'} . "min)", 0 );
                }

                # Decrease Counter
                $warn_hash{ $tmphash{$target}{'guid'} }{'value'}--;

            }
            else
            {

                # Display warning

                # etpro ?
                if ( $config{'et_mod'} == 2 )
                {
                    &cmd( "ref warn \"" . &convert_name( $tmphash{$target}{'name'} ) . "\" \"$reason\"" );
                }
                else
                {
                    &say( "^3warn: ^7You have been warned: ^1$reason", "chatclient", $target );
                }
            }

        }
        else
        {
            &say( "^3warn: ^7Usage: $config{'command_prefix'}warn <id|name> <reason>", @say_params );
        }

    }
    elsif ( $config{'admin_functions'} && $data[0] eq "time" )
    {
        if ( &admin_check( $guid, "time", $base ) )
        {
            print "time....\n";
            &say( "^3time:^7 Local time is " . &time2date(time), @say_params );
        }
    }
    elsif (    $config{'admin_functions'}
            && $config{'use_advanced_kick'}
            && $data[0] eq "kick" )
    {

        # Use the better kick function with reason
        return unless ( &admin_check( $guid, "kick", $base ) );

        shift @data;    # Drop command off
        my $target = shift @data;
        my $reason = join( ' ', @data );
        $reason = $reason || "Kicked by Admin";

        if ( $target eq "" )
        {
            &say( "^3kick:^7 usage: !kick <client_id|part of name> [reason]", @say_params );
            return;
        }

        $reason =~ s/!//g;
        ( $target, my $found ) = &part2complete( $target, 1 );

        return if ( !&check_result( "kick", $found, @say_params ) );

        if ( &get_admin_level( $tmphash{$target}{'guid'} ) >= &get_admin_level($guid) )
        {

            # You can't kick a higher or equal admin.
            if ( $tmphash{$target}{'guid'} eq $guid )
            {
                &log("$name tried to ban himself!");
                &say( "^3kick:^7 You can't ^3kick^7 yourself!", @say_params );
            }
            else
            {
                &log("$name tried to ban a fellow admin !");
                &say( "^3kick:^7 You can't ^3kick^7 a fellow admin!", @say_params );
            }
        }
        else
        {
            &kick( $target, ":^7$reason", 1 );
        }

        return;

    }
    elsif ( $config{'admin_functions'} && ( $data[0] =~ /^(un)?bani?$/ ) )
    {

        if ( $1 && &admin_check( $guid, "unban", $base ) )
        {

            # unban
            if ( $data[1] )
            {
                my $tguid = $data[1];
                if ( defined( $bans{$tguid} ) )
                {
                    &log("Ban for $tguid ($bans{$tguid}{'name'}) deleted ($name)!");
                    &shrub_ban( $config{'shrubbot_cfg'}, "remove", $tguid );
                    &say( "^3unban:^7 ban for " . $bans{$tguid}{'name'} . "^7 ($tguid) removed!", @say_params );
                    delete $etpro_bans{ $bans{$tguid}{'eguid'} } if ( defined( $bans{$tguid}{'eguid'} ) );
                    delete $bans{$tguid};
                }
                else
                {
                    &say( "^3unban:^7 This guid isn't banned!", @say_params );
                }
            }
            else
            {
                &say( "^3unban:^7 Usage: " . $config{'command_prefix'} . "unban <guid>", @say_params );
            }

        }
        elsif (    ( $data[0] eq "ban" && &admin_check( $guid, "ban", $base ) )
                || ( $data[0] eq "bani" && &admin_check( $guid, "bani", $base ) ) )
        {

            # ban
            if ( defined( $data[1] ) )
            {

                my $cmd      = shift @data;
                my $target   = shift @data;
                my $duration = shift @data || 0;
                my $reason   = join( ' ', @data );
                $reason = $reason || $config{'ban_default_reason'} || "Banned by Admin";
                my $timestamp;
                my $command = "ban";
                my $found   = 0;
                my $spare   = 0;

                $reason =~ s/!//g;
                ( $target, $found ) = &part2complete( $target, 1 );

                return if ( !&check_result( $command, $found, @say_params ) );

                # Workaround, if the GUID isn't known yet.
                if ( $tmphash{$target}{'guid'} eq "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX" )
                {
                    &say( "^3setlevel:^7 It's not possible to ban $tmphash{$target}{'name'} ^7yet. GUID unknown. ",
                          @say_params );
                    return;
                }

                # Check duration
                if ( $duration ne int($duration) )
                {
                    if ( $duration =~ /(\d+w)?(\d+d)?(\d+h)?(\d+m)?(\d+s)?/ )
                    {
                        my $weeks   = $1 || 0;
                        my $days    = $2 || 0;
                        my $hours   = $3 || 0;
                        my $minutes = $4 || 0;
                        my $seconds = $5 || 0;
                        $duration = $weeks * ( 86400 * 7 ) + $days * 86400 + $hours * 3600 + $minutes * 60 + $seconds;
                    }
                }

                if ( $cmd eq "bani" )
                {

                    if ( !$tmphash{$target}{'etpro_guid'} )
                    {
                        &say( "^3bani:^7 Sorry, no etpro guid found!", @say_params );
                        return;
                    }

                    # Win98 workaround:
                    if ( $tmphash{$target}{'etpro_guid'} eq "52FF6283916A9467908E6A771CB70285FB41C5E7" )
                    {
                        &say( "^3bani:^7 Sorry, you ^1can't ^7ban this client (win98 etpro guid bug)!", @say_params );
                        return;
                    }
                }

                # admin check:
                if ( &get_admin_level( $tmphash{$target}{'guid'} ) >= &get_admin_level($guid) )
                {

                    if ( $tmphash{$target}{'guid'} eq $guid )
                    {
                        &log("$name tried to ban himself!");
                        &say( "^3ban:^7 You can't ^3ban^7 yourself!", @say_params );
                    }
                    else
                    {
                        &log("$name tried to ban a fellow admin !");
                        &say( "^3ban:^7 You can't ^3ban^7 a fellow admin!", @say_params );
                    }
                    return;
                }

                if ( !$duration || $duration < 0 )
                {
                    $timestamp = 0;
                }
                else
                {
                    $timestamp = $config{'ban_timestamp_format'} eq "shrub" ? ( time - 946767600 ) : time;
                    $timestamp = $timestamp + $duration;
                }

                my $ip = $tmphash{$target}{'ip'};
                $ip = "0.0.0.0" if ( !$ip );

                if ( $tmphash{$target}{'guid'} eq "NO_GUID" )
                {
                    &kick( $target, "banned: $reason", 0 );
                    &say(
                          "^3ban:^7 Kicked, but ^1NOT^7 banned (NO_GUID): "
                            . $tmphash{$target}{'name'}
                            . "^7(Reason: ^3$reason^7).",
                          @say_params
                        );
                    &log(   "Kicked (instead of ban, NO_GUID): "
                          . &convert_name( $tmphash{$target}{'name'} )
                          . "Duration: "
                          . $config{'default_kick_duration'} );
                }
                else
                {
                    if ( $cmd eq "bani" )
                    {
                        &shrub_ban(
                                    $config{'shrubbot_cfg'},   "add",
                                    $tmphash{$target}{'guid'}, $timestamp,
                                    &convert_name( $name, 0, 0 ), $ip,
                                    $reason, &convert_name( $tmphash{$target}{'name'}, 0, 0 ),
                                    $tmphash{$target}{'etpro_guid'}
                                  );
                    }
                    else
                    {
                        &shrub_ban(
                                    $config{'shrubbot_cfg'},   "add",
                                    $tmphash{$target}{'guid'}, $timestamp,
                                    &convert_name( $name, 0, 0 ), $ip,
                                    $reason, &convert_name( $tmphash{$target}{'name'}, 0, 0 )
                                  );
                    }

                    &log(   "Banned: $target ("
                          . &convert_name( $tmphash{$target}{'name'} )
                          . ", Duration: ${duration}s, Reason: $reason)" );

                    # reload bans
                    &load_shrubbot_cfg();

                    # save name for say after kick.
                    my $tmp = $tmphash{$target}{'name'};

                    if ( $duration > 0 && $duration < ( 60 * $config{'default_kick_duration'} ) )
                    {

                        # The kick might be longer then the ban ...
                        my $temp_dur = int( $duration / 60 ) + 1;
                        &kick( $target, "banned: $reason", 0, $temp_dur );
                    }
                    else
                    {
                        &kick( $target, "banned: $reason", 0 );
                    }
                    &say( "^3$cmd:^7 Banned $tmp ^7(Reason: ^3$reason^7).", @say_params );

                }

                &disconnect( $target, $tmphash{$target}{'guid'} );

            }
            else
            {
                &say( "^3ban:^7 usage: !ban <client_id|part of name> [duration] [reason]", @say_params );
            }
        }
    }
    elsif (
               $config{'seen_db'}
            && $data[0] eq "seen"
            && ( $config{'admin_functions'} && &admin_check( $guid, "seen", $base )
                 || !$config{'admin_functions'} )
          )
    {

        $command_string =~ s/seen\s*//;

        if ($command_string)
        {
            my $seen;
            foreach my $user ( keys %tmphash )
            {
                if ( lc( &convert_name( $tmphash{$user}{'name'} ) ) eq lc($command_string) )
                {
                    $seen = "next to you!";
                    return;
                }
            }

            $seen = &get_seen( lc($command_string) ) if ( !$seen );
            if ($seen)
            {
                &say( "^3seen: ^7$command_string^7 was last seen: $seen", @say_params );
            }
            else
            {
                &say( "^3seen: ^7$command_string^7 is not in the database.", @say_params );
            }
        }
        else
        {
            &say( "^3seen:^7 Usage: !seen <client> (case insensitive)", @say_params );
        }
    }
    elsif ( $config{'admin_functions'} )
    {

        #my ( $command, $parameter ) = split( /\s+/, $command_string );

        my $command = $data[0];
        my $found   = 0;

        # To speed up (less for cycles)
        my $counter = &get_admin_level($guid);

        #$counter = $remote{ $remote_guids{$guid} }{'level'} if ( $counter == 0 && defined( $remote_guids{$guid} ) );

        for my $lvl ( 0 .. $counter )
        {
            my $ref = $admin_func[$lvl];

            for my $cmd (@$ref)
            {

                if ( $command eq lc($cmd) || "$base:$command" eq lc($cmd) )
                {

                    # HIT !
                    &log("Command: $command recognized!") if ( $config{'debug'} );

                    $found = 1;
                    my $spare = 0;

                    my $parameter = $command_string;
                    $parameter =~ s/$data[0]\s*//i;

                    # Substitution / Aliases
                    if ( defined( $alias{ $data[0] } ) )
                    {

                        my $subst        = $alias{ $data[0] };
                        my $convert_name = &convert_name( $name, 0, 0 );
                        my $client_id    = &name2client_id($name);
                        my $pb_id        = $client_id + 1;

                        $subst =~ s/<ARANDOM_COLOR_PLAYER>/$tmphash{&get_random_player()}{'name'}/ge;

                        if ( index( $subst, "<RANDOM" ) > -1 )
                        {

                            # pick a random player:
                            my $slot = &get_random_player();

                            # Slot picked, now replace
                            $subst =~ s/<RANDOM_CLIENT_ID>/$slot/g;
                            $subst =~ s/<RANDOM_COLOR_PLAYER>/$tmphash{$slot}{'name'}/g;
                            $subst =~ s/<RANDOM_PLAYER>/&convert_name($tmphash{$slot}{'name'},0,0)/ge;
                            $subst =~ s/<RANDOM_PLAYER_CLASS>/$CLASS{$tmphash{$slot}{'class'}}/g;
                            $subst =~ s/<RANDOM_PLAYER_TEAM>/$SIDE{$tmphash{$slot}{'team'}}/g;

                        }

                        $subst =~ s/<COLOR_PLAYER>/$name/g;
                        $subst =~ s/<PLAYER>/$convert_name/g;
                        $subst =~ s/<GUID>/$guid/g;
                        $subst =~ s/<CLIENT_ID>/$client_id/g;
                        $subst =~ s/<ID2PBID>/$pb_id/g;
                        $subst =~ s/<PARAMETER>/$parameter/g;
                        $subst =~ s/<PLAYER_CLASS>/$CLASS{$tmphash{$client_id}{'class'}}/g;
                        $subst =~ s/<PLAYER_TEAM>/$SIDE{$tmphash{$client_id}{'team'}}/g;

                        # New replacements:

                        # Killer replacements:
                        if ( index( $subst, "<PLAYER_LAST_VICTIM" ) > -1 )
                        {
                            my $victim = "";

                            #<PLAYER_LAST_KILLED_CNAME>
                            $victim = $tmphash{$client_id}{'last_victim'}{'id'};
                            $subst =~ s/<PLAYER_LAST_VICTIM_ID>/$victim/g;
                            $victim = $tmphash{$victim}{'name'};
                            $subst =~ s/<PLAYER_LAST_VICTIM_CNAME>/$victim/g;
                            $victim = &convert_name( $victim, 0, 0 );
                            $subst =~ s/<PLAYER_LAST_VICTIM_NAME>/$victim/g;

                            my $weapon_id = $tmphash{$client_id}{'last_victim'}{'weapon_id'};
                            $subst =~ s/<PLAYER_LAST_VICTIM_WEAPON>/$mod_weapon{$weapon_id}/g;

                        }

                        # Killed replacements:
                        if ( index( $subst, "<PLAYER_LAST_KILLER" ) > -1 )
                        {

                            #<PLAYER_LAST_KILLED_CNAME>
                            my $killer = $tmphash{$client_id}{'last_killer'}{'id'};
                            $subst =~ s/<PLAYER_LAST_KILLER_ID>/$killer/g;
                            $killer = $tmphash{$killer}{'name'};
                            $subst =~ s/<PLAYER_LAST_KILLER_CNAME>/$killer/g;
                            $killer = &convert_name( $killer, 0, 0 );
                            $subst =~ s/<PLAYER_LAST_KILLER_NAME>/$killer/g;

                            my $weapon_id = $tmphash{$client_id}{'last_killer'}{'weapon_id'};
                            $subst =~ s/<PLAYER_LAST_KILLER_WEAPON>/$mod_weapon{$weapon_id}/g;

                        }

                        if ( index( $subst, "<PART2" ) > -1 )
                        {

                            my ( $new_id, $found ) = &part2complete( $parameter, 1 );
                            return if ( !&check_result( $command, $found, @say_params ) );

                            if (    $subst =~ s/<HIGHER_LEVEL_PROTECTED>//g
                                 && &get_admin_level( $tmphash{$new_id}{'guid'} ) >= &get_admin_level($guid)
                                 && $tmphash{$new_id}{'guid'} ne $guid )
                            {
                                &log("$name tried affect an equal or higher admin");
                                &say( "^3$command: ^7You can't use this command on an admin of equal or higher level.",
                                      @say_params );
                                return;
                            }

                            my $new_cname = &convert_name( $tmphash{$new_id}{'name'} );

                            $subst =~ s/<PART2ID>/$new_id/g if ( index( $subst, "<PART2ID>" ) > -1 );
                            $subst =~ s/<PART2CNAME>/$tmphash{$new_id}{'name'}/g
                              if ( index( $subst, "<PART2CNAME>" ) > -1 );
                            $subst =~ s/<PART2NAME>/$new_cname/g            if ( index( $subst, "<PART2NAME>" ) > -1 );
                            $subst =~ s/<PART2IP>/$tmphash{$new_id}{'ip'}/g if ( index( $subst, "<PART2IP>" ) > -1 );
                            $subst =~ s/<PART2GUID>/$tmphash{$new_id}{'guid'}/g
                              if ( index( $subst, "<PART2GUID>" ) > -1 );

                            if ( index( $subst, "<PART2PBID>" ) > -1 )
                            {
                                my $pb_id = $new_id + 1;
                                $subst =~ s/<PART2PBID>/$pb_id/g;
                            }

                            if ( index( $command, "<PART2ADMINLEVEL>" ) > -1 )
                            {
                                my $gu = &get_admin_level( $tmphash{$new_id}{'guid'} );
                                $subst =~ s/<PART2ADMINLEVEL>/$gu/g;
                            }

                        }

                        &log("Substitution: $command_string -> $subst\n")
                          if ( $config{'debug'} );
                        $command_string = $subst;

                    }

                    my $disconnect = -1;
                    if ( $command_string =~ /^kick\s+\"?(.*)\"?$/ )
                    {

                        # Found a normal kick.
                        # User check...

                        foreach my $user ( keys %tmphash )
                        {
                            if ( lc( &convert_name( $tmphash{$user}{'name'} ) ) eq lc($parameter) )
                            {
                                if ( &get_admin_level( $tmphash{$user}{'guid'} ) >= &get_admin_level($guid) )

                                  #&& $tmphash{$user}{'guid'} ne $guid ) -> removed the self check.
                                {
                                    &log("$name tried to kick a fellow admin!");
                                    &say( "You can't ^3kick^7 a fellow admin!", @say_params );
                                    $spare = 1;

                                }
                                else
                                {
                                    &log("Found a admin, kicked himself.");
                                    $disconnect = $user;
                                }
                                $found = 1;
                                last;
                            }
                        }
                    }
                    elsif (
                        $command_string =~ /^pb_sv_(kick)\s+\"?(\d+)\s*/ ||    # all (punkbuster)
                        $command_string =~ /^client(kick)\s+\"?(\d+)/    ||    # all
                        $command_string =~ /^ref (kick)\s+\"?(\d+)/      ||    # etpro
                        $command_string =~ /^ref (mute)\s+\"?(\d+)/      ||    # etpro
                        $command_string =~ /^(mute)\s+\"?(\d+)/                # Headshotmod
                          )
                    {

                        # Found numeric kick
                        my $command   = $1;
                        my $target_id = $2;

                        # If its a punkbuster ID, then reduce the id
                        $target_id-- if ( $command_string =~ /^pb_sv_kick/ );

                        if ( &get_admin_level( $tmphash{$target_id}{'guid'} ) >= &get_admin_level($guid)
                             && ( $tmphash{$target_id}{'guid'} ne $guid ) )
                        {
                            &log("$name tried to $command a fellow admin ($command_string)!");
                            &say( "^3$command: ^7You can't $command a fellow admin!", @say_params );
                            $spare = 1;
                        }
                        if ( $command eq "kick" )
                        {
                            $disconnect = $target_id;
                        }
                    }

                    if ( !$spare )
                    {

                        &log("Executing: $command_string! (by $name)") if ( $config{'debug'} );
                        my ( $output, $raw_data ) = &cmd($command_string);

                        #&say ($raw_data, @say_params) if ($remote_call >= 0);
                        &say( $output, "tcp", $remote_call, 1, $remote_query_id )
                          if ( $remote_call >= 0 && $silent == 1 );

                        $output =~ s/\n/^3\/\/^7/g;
                        $output =~ s/\s+/ /g;

                        &say( "^3$data[0]: ^7" . $output, @say_params )
                          if (
                                  $output
                               && $config{'rcon_featback'} > -1
                               && ( ( &get_admin_level($guid) >= $config{'rcon_featback'} )
                                    || $config{ rcon_featback == 0 } )
                               && $silent != 1
                             );

                        &log( "Target: " . &get_admin_level( $tmphash{$parameter} ) )
                          if ( $config{'debug'} && $parameter );

                        &disconnect($disconnect) if ( $disconnect > -1 );
                    }
                    else
                    {
                        &log("Ignoring: $command_string!");

                        # Don't execute....
                        # I don't ban higher or equal admins
                    }

                }
                last if ($found);
            }
            last if ($found);
        }
    }
    else
    {

        # Ignore !
        &log("Ignoring Command: $name: $command_string");
    }

}

sub fhbits
{

    my $rin = '';
    for (@sockets)
    {
        vec( $rin, fileno($_), 1 ) = 1 if ( $_ ne "" );
    }
    vec( $rin, fileno(FH), 1 ) = 1;
    if ($tcp_interface)
    {
        vec( $rin, fileno(SOCK), 1 ) = 1;
    }
    return $rin;

}

# unused
# because of "hanging", if no \n is send by the client.
# -> buffer is more efficient
sub readline
{

    # 'select'-compatible function for reading one line of input from
    #    a filehandle.
    #
    #    readline() expects one argument -- filehandle S
    #
    #    sample call:       $mystring = readline('S')
    #

    my $filehandle = $_[0];
    my $c          = '';
    my $retstr     = '';
    my $endoffile  = 0;

    while ( $c ne "\n" && !$endoffile )
    {

        if ( sysread( $filehandle, $c, 1 ) > 0 )
        {
            $retstr = $retstr . $c;
        }
        else
        {
            $endoffile = 1;
        }

    }

    return $retstr;
}

sub remote_send
{

    my $message  = shift;
    my $sock_id  = shift;
    my $query_id = shift;
    $query_id =~ s/:(.*)$//;
    $message  =~ s/\r?\n?$//;

    &log("Sending $message to $sock_id (Query id: $query_id)") if ( $config{'debug'} > 2 );

    if ( defined( $sockets[$sock_id] ) && $sockets[$sock_id] ne "" )
    {

        my $socket = $sockets[$sock_id];

        #if ( $remote{$sock_id}{'etm'} == 0 )
        #{
        #    print $socket $message . "\r\n";
        #}
        #else
        #{
        print $socket ( $query_id ne "" ? $query_id . ":" : "" ) . $message . "\r\n";

        #}
    }
}

sub global_remote_send
{

    my $message  = shift;
    my $query_id = shift || "";

    if ( $con > 0 && $tcp_interface )
    {

        #$message =~ s/\r?\n?$//;
        for ( my $sockcount = 0 ; $sockcount <= $#sockets ; $sockcount++ )
        {

            # skip unused sockets
            next
              if (    !defined( $sockets[$sockcount] )
                   or $sockets[$sockcount] eq ""
                   or $remote{$sockcount}{'status'} == 0 );

            if ( $remote{$sockcount}{'etm'} != 0 && $query_id )
            {

                if ( $query_id eq "ETM-INFO" )
                {
                    &remote_send( $message, $sockcount, $query_id ) if ( $remote{$sockcount}{'etm'} & ETM_INFO );
                }
                elsif ( $query_id eq "ETM-WARN" )
                {
                    &remote_send( $message, $sockcount, $query_id ) if ( $remote{$sockcount}{'etm'} & ETM_WARN );
                }
                elsif ( $query_id eq "ETM-KICK" )
                {
                    &remote_send( $message, $sockcount, $query_id ) if ( $remote{$sockcount}{'etm'} & ETM_KICK );
                }
                elsif ( $query_id eq "ETM-VOTE" )
                {
                    &remote_send( $message, $sockcount, $query_id ) if ( $remote{$sockcount}{'etm'} & ETM_VOTE );
                }
                elsif ( index( $query_id, "ETM-KILL" ) == 0 )
                {

                    if ( $remote{$sockcount}{'etm'} & ETM_KILL )
                    {

                        if ( $remote{$sockcount}{'etm_kills'} & 1 && $query_id eq "ETM-KILL:KILL" )
                        {
                            &remote_send( $message, $sockcount, $query_id );
                        }
                        elsif ( $remote{$sockcount}{'etm_kills'} & 2 && $query_id eq "ETM-KILL:TK" )
                        {
                            &remote_send( $message, $sockcount, $query_id );
                        }
                        elsif ( $remote{$sockcount}{'etm_kills'} & 4 && $query_id eq "ETM-KILL:SUICIDE" )
                        {
                            &remote_send( $message, $sockcount, $query_id );
                        }
                    }
                }
                elsif ( index( $message, "etpro announce: " ) == 0 || index( $message, "etpro popup: " ) == 0 )
                {
                    &remote_send( $message, $sockcount, "ETM-ETPRO" ) if ( $remote{$sockcount}{'etm'} & ETM_ETPRO );
                }
                elsif (
                      $remote{$sockcount}{'etm'} & ETM_CHAT
                      && ( index( $query_id, "ETM-CHAT" ) == 0
                          || $message =~
                          /^(sayteamnl:|sayc?:|saybuddyc?:|sayteamc?:|privmsg:|etpro privmsg:|qsay\s+|chat\s+|say\s+)/ )
                      )
                {

                    my $test = $1;
                    $test =~ s/^(.*)c?[:\s\"]+/$1/ if ($test);

                    my $text = $message;

                    # Most general case (everything)
                    if ( $remote{$sockcount}{'etm_chat'} == 7 )
                    {
                        $text =~ s/^(say\w*?: .*?): /$1^;: /;
                        &remote_send( $text, $sockcount, "ETM-CHAT" );
                    }
                    elsif ( $remote{$sockcount}{'etm_chat'} & 1
                         && ( $test eq "say" || $test eq "chat" || $test eq "qsay" || $query_id eq "ETM-CHAT:GLOBAL" ) )
                    {
                        $text =~ s/^(say\w*?: .*?): /$1^;: /;
                        &remote_send( $text, $sockcount, "ETM-CHAT:GLOBAL" );
                    }
                    elsif ( $remote{$sockcount}{'etm_chat'} & 2
                            && ( $test eq "sayteam" || $test eq "saybuddy" ) )
                    {
                        $text =~ s/^(say\w*?: .*?): /$1^;: /;
                        &remote_send( $text, $sockcount, "ETM-CHAT:TEAM" );
                    }
                    elsif ( $remote{$sockcount}{'etm_chat'} & 4
                            && ( $test eq "etpro privmsg" || $test eq "privmsg" ) )
                    {
                        &remote_send( $text, $sockcount, "ETM-CHAT:PM" );
                    }

                }
                elsif ( $query_id eq "ETM-RCON" )
                {
                    &remote_send( $message, $sockcount, $query_id ) if ( $remote{$sockcount}{'etm'} & ETM_RCON );
                }
                elsif ( index( $message, "Vote Failed: " ) == 0 || index( $message, "Vote Passed: " ) == 0 )
                {
                    &remote_send( $message, $sockcount, "ETM-VOTE" ) if ( $remote{$sockcount}{'etm'} & ETM_VOTE );
                }
                elsif ( $query_id eq "ETM-CLOG" )
                {
                    &remote_send( $message, $sockcount, $query_id ) if ( $remote{$sockcount}{'etm'} & ETM_CLOG );
                }
                elsif ( $query_id eq "ETM-BC" )    #&& $remote{$sockcount}{'etm'} & ETM_BC )
                {
                    &remote_send( $message, $sockcount, $query_id );
                }

            }
            elsif ( ( $query_id eq "ETM-RCON" || $query_id eq "ETM-CLOG" ) && $remote{$sockcount}{'filter'} == 0 )
            {

                # ALL console.log && rcon messages.
                &remote_send( $message, $sockcount, $remote{$sockcount}{'etm'} > 0 ? $query_id : "" ) if ( $_ ne "" );
            }
            else
            {

                # filter == 1, just says and kills
                # filter == 2, just says
                if (    ( $remote{$sockcount}{'filter'} > 0 && $message =~ /^say: / )
                     || ( $remote{$sockcount}{'filter'} == 1 && $message =~ /^Kill: / ) )
                {
                    &remote_send( $message, $sockcount, "" ) if ( $_ ne "" );
                }
            }

        }
    }
}

sub remote_disconnect
{

    my $sock_id  = shift;
    my $username = $remote{$sock_id}{'username'};

    &log("TCP-Connection: $username disconnected (Slot: $sock_id)");
    close( $sockets[$sock_id] );

    # clear socket array, but leave it there.
    $sockets[$sock_id] = "";

    # Count remaining connections
    $con = 0;
    foreach my $rem ( keys %remote )
    {
        $con++ if ( $remote{$rem}{'status'} == 1 && $sockets[$rem] ne "" );
    }
    &log("Remaining connections: $con") if ( $config{'debug'} );
    $rin = &fhbits();
    delete $remote_guids{ $remote{$sock_id}{'guid'} };
    delete $remote{$sock_id};

    &global_remote_send( "User $username logged out.", "ETM-INFO" ) if ($username);

}

sub check_rcon_jobs
{

    foreach my $jobid ( sort keys %rcon_jobs )
    {

        my ( $date, $id ) = split( '-', $jobid );
        if ( $date <= time )
        {
            &cmd( $rcon_jobs{$jobid} );
            delete $rcon_jobs{$jobid};
            foreach my $cid ( keys %tmphash )
            {
                if ( defined( $tmphash{$cid}{'jobs'}{$jobid} ) )
                {
                    delete $tmphash{$cid}{'jobs'}{$jobid};
                    last;
                }
            }
        }
        else
        {

            # the timestamps are sorted, so i can stop
            # if the entry is smaller time. Saves some cpu cycles.
            last;
        }

    }

}

sub add_rcon_job
{

    my $job       = shift;
    my $date      = shift;
    my $client_id = shift;

    $jobcounter++;
    $rcon_jobs{ $date . "-" . $jobcounter } = $job;

    # Remember the job id for deleting, if someone leaves the server.
    $tmphash{$client_id}{'jobs'}{ $date . "-" . $jobcounter } = 1;

    $jobcounter %= 256;

}

sub word_check
{

    my $chatstring = lc(shift);
    $chatstring = " " . &convert_line($chatstring) . " ";

    # remote ... and !!!
    $chatstring =~ s/\!\.//g;

    for my $word (@bad_words)
    {
        if ( index( $word, "regexp:" ) == 0 )
        {
            $word =~ /^regexp:(.*)/;
            return 1 if ( $chatstring =~ /$1/i );

        }
        else
        {
            return 1 if ( index( $chatstring, $word ) > -1 );
        }
    }

    return 0;

}

sub get_random_player
{

    # Some random stuff.
    my @ray = keys %tmphash;

    # pick a random player:
    return $ray[ int( rand( $#ray + 1 ) ) ];
}

#
# returns the char, if the char is a valid one, else a empty string.
# Purpose: Filters all unwanted string (like control chars and stuff)
#
sub ord_check
{
    my $char = shift;
    return $char if ( ord($char) >= 32 );
    return "";
}

sub etm_useradd
{

    my $username = shift;
    my $level    = shift;
    my $password = shift;

    &load_security();

    $security{$username}{'password'} = &crypt($password);
    $security{$username}{'level'}    = $level;
    $security{$username}{'name'}     = $username;

    &save_security();
    return 0;

}

sub etm_userdel
{

    my $username = shift;

    &load_security();
    delete $security{$username};
    &save_security();

    return 0;

}

sub etm_userpwd
{

    my $username = shift;
    my $password = shift;
    &load_security();
    $security{$username}{'password'} = &crypt($password);
    &save_security();

    return 0;
}

sub etm_userlevel
{

    my $username = shift;
    my $level    = shift;

    &load_security();
    $security{$username}{'level'} = $level;
    &save_security();

    return 0;
}

sub save_security
{

    my $file = shift || $config{'tcp_user_database'} || "etc/tcp_userdatabase.cfg";

    open( OUT, ">$file" );

    foreach my $name ( sort keys %security )
    {

        next if ( $name eq $config{'tcp_admin_username'} );
        syswrite( OUT, "[admin]\n" );
        my $ref = $security{$name};
        foreach my $key ( sort keys %$ref )
        {
            syswrite( OUT, "$key\t= $security{$name}{$key}\n" );
        }
        syswrite( OUT, "\n" );

    }

    close(OUT);

}

sub load_security
{

    my $file = shift || $config{'tcp_user_database'} || "etc/tcp_userdatabase.cfg";

    my %tmp_admin  = ();
    my $unfinished = 1;
    my $store      = "";
    my $abschnitt  = "";
    my $zeile      = "";
    %security = ();

    open( IN, $file ) || &log("Error opening file $file: $!");

    while ( sysread IN, $buff, 4096 )
    {
        $store .= $buff;
    }

    my @lines = split /\r?\n/, $store;

    while ( ( $zeile = shift @lines ) or $unfinished )
    {
        chomp $zeile;
        $zeile =~ s/(^\s*|\s*\r*$)//g;

        $abschnitt = $1 if ( $zeile =~ /^\[(.*)\]$/ );
        $unfinished = ( $zeile ? 1 : 0 );

        # print "DEBUG: $zeile -> UF: $unfinished, $abschnitt\n";

        if ( $abschnitt eq "admin" )
        {
            $tmp_admin{$1} = $2 if ( $zeile =~ /^(.*?)\s*=\s*(.*)/ );

            if (    !$zeile
                 && defined( $tmp_admin{'name'} )
                 && $tmp_admin{'password'}
                 && $tmp_admin{'level'} )
            {
                foreach my $key ( keys %tmp_admin )
                {
                    $security{ $tmp_admin{'name'} }{$key} = $tmp_admin{$key};
                }
                %tmp_admin  = ();
                $unfinished = 0;
            }
            elsif ( !$zeile )
            {
                %tmp_admin  = ();
                $unfinished = 0;
            }
        }
    }
    close(IN);

    if ( $config{'tcp_admin_username'} )
    {

        # XXX Check for default pass!
        if ( lc( $config{'tcp_admin_password'} ) ne "changethis" )
        {
            $security{ $config{'tcp_admin_username'} }{'password'} = &crypt( $config{'tcp_admin_password'} );
            $security{ $config{'tcp_admin_username'} }{'level'}    = $highest_level;
        }
        else
        {
            &log("You haven't changed the default password. Disabling the tcp admin account.");
        }
    }

}

# returns a crypted or none crypted password.
# depends on the config setting.
sub crypt
{
    my $pass = shift;

    if ( $config{'tcp_crypt_passwords'} )
    {

        #return crypt($pass, substr($pass, 0, 2));
        return crypt( $pass, "etm" );
    }
    else
    {
        return $pass;
    }

}

sub load_intermission_mapvoting_maps
{

    my $buff;
    my $temp;
    my @maplist = ();
    my %tmpmaps = ();

    &log("Loading intermission mapvoting maplist...");

    my $mapfile = $config{'intermission_mapfile'} || 'etc/maps.lst';
    open( MAPS, $mapfile ) || &log("Loading maplist failed: Couldn't open $mapfile");

    #read chunks of 4k and stuff them in $temp
    while ( sysread MAPS, $buff, 4096 )
    {
        $temp .= $buff;
    }

    #now split $temp after each \r?\n (support windows :/)
    my @lines = split /\r?\n/, $temp;

    #strip comments, empty lines, paths. keep mapnames
    foreach my $line (@lines)
    {

        #remove comments and strip of whitespaces and stuff.
        $line =~ s/\#.*//;            # strip of comments with #
        $line =~ s/(^\s+|\s*$)//g;    # strip off whitespaces at start and end.

        #strip paths and .bsp (if exists)
        if ( $line =~ /.*?([^\/]+?)(\.bsp)?$/ )
        {

            #ignores double entries
            $tmpmaps{$1} = "m";
        }

    }

    close(MAPS);

    # create the final maplist
    foreach my $map ( sort keys %tmpmaps )
    {
        &log("Loading map: $map") if ( $config{'debug'} > 1 );
        push( @maplist, $map );
    }

    return @maplist;
}

sub check_mute_state
{

    my $client_id  = shift;
    my $guid       = shift;
    my $etpro_guid = 0;

    if ( length($guid) == 40 )
    {
        $etpro_guid = 1;
    }

    &log("Checking mute state of $guid. ($tk_hash{$guid}{'muted'})") if ( $config{'debug'} );

    if ( defined( $tk_hash{$guid}{'muted'} )
         && ( $tk_hash{$guid}{'muted'} == 1 || $tk_hash{$guid}{'pmuted'} == 1 ) )
    {
        &log("Restoring mute state to 1") if ( $config{'debug'} );

        # Found pre muted player.
        if (    $config{'automute'}
             && defined( $tk_hash{$guid}{'bad_word_timestamp'} )
             && $tk_hash{$guid}{'bad_word_timestamp'} > 0 )
        {

            # set mute timeout, if there is one.
            $tmphash{$client_id}{'bad_word_timestamp'} = time + $tk_hash{$guid}{'bad_word_timestamp'};
            $tmphash{$client_id}{'bad_word'}           = 1;

            #$tmphash{$client_id}{'muted'}              = 1 if ( $tmphash{$client_id}{'muted'} == 0 );
            &log("Setting timestamp to: $tmphash{$client_id}{'bad_word_timestamp'}")
              if ( $config{'debug'} );
        }

        if ( !$etpro_guid )
        {

            # Mute later ^^.
            # Mute as soon, as the client is ready.
            $tmphash{$client_id}{'tobegin'} = "ref mute $client_id";
        }
        else
        {

            # Mute now!
            &cmd("ref mute $client_id");
        }
        $tmphash{$client_id}{'pmuted'} = 1 if ( $tk_hash{$guid}{'pmuted'} );

        # delete temporary data (not the pmuted flag, if exists).
        delete $tk_hash{$guid};

    }
}

# checks, if a name is a valid player
sub check_name
{

    my $name = shift;
    $name = &convert_name( $name, 1, 1 );

    foreach my $key ( keys %tmphash )
    {
	#&log("SMC: '$name' vs '". &convert_name( $tmphash{$key}{'name'},1,1)."'");
        return $key if ( &convert_name( $tmphash{$key}{'name'}, 1, 1 ) eq $name );
    }
    return -1;

}

# Hammer - BEGIN sound_mappings code
sub sound_mapping
{
    my $line = shift;
    my $base = shift || "clog";
    my $restr;

    &log("SM-TEST: Line: $line") if ( $config{'debug'} > 1);
    foreach my $searchstr ( keys %sound_mappings )
    {

        $restr = $searchstr;
        
        # Filter unneeded tests.
        if (index($restr, "rcon:") == 0)
        {
        	next if ($base ne "rcon");
        	$restr =~ s/^rcon://;
        }
        elsif (index($restr, "clog:") == 0){
        	next if ($base ne "clog");
        	$restr =~ s/^clog://;
        }
        $restr =~ s/[+-]PLAYERNAME[+-]/\(\.\+\?\)/;

        #$restr =~ s/([+-])PLAYERNAME[+-]/\\E\(\\\S\+\)\\Q/; # would like to escape surrounding strings but didnt work
        my $soundenv = "";
        $soundenv = $1 if ( $searchstr =~ /([+-])PLAYERNAME[+-]/ );

        &log("SM-TEST-SEARCH: $restr, ENV: $soundenv") if ( $config{'debug'} >1 );

        #$restr = "\\Q$restr\\E"; # would like to escape surrouning strings
        if ( $line =~ /$restr/ )
        {
        
            &log("SM-TEST-SEARCH: $restr, ENV: $soundenv") if ( $config{'debug'} >1 );

            if ($soundenv)
            {
                my $name = $1;
                my $slot = &check_name($1);

                &log("SM-TEST-Name: $name, found slot: $slot") if ( $config{'debug'} );

                next unless ( $slot >= 0 );    # skip, if slot not found

                if ( $soundenv eq "+" )
                {

                    # Note: Works in Jaymod. Still waiting on TJW to implement in etpub
                    &cmd("playsound_env $slot $sound_mappings{$searchstr}");
                }
                else
                {
                    &cmd("playsound $slot $sound_mappings{$searchstr}");
                }
            }
            else
            {
            	my $target = $config{'et_mod'} == 2 ? "-1" : "";
                &cmd("playsound $target $sound_mappings{$searchstr}");
            }
            &log("Found $searchstr, played sound: $sound_mappings{$searchstr} (Env: $soundenv)")
              if ( $config{'debug'} );
        }
    }
}

# Hammer - END sound_mappings code
