#!/usr/bin/perl

#  Author: Lukey
#  Email: lukey@houseofpaingameservers.net
#  Description: This addon pulls game stats from the VSP stats processor database.
#  Get VSP @ http://www.clanavl.com/vsp

#  Required Modules: DBI

# INSTALLATION:
# You need to change the hostname, username, password, and database.
# In most cases using "localhost" for the hostname should suffice.
# If you have changed the table prefix in your VSP config, you will
# need to change the "vsp_" prefix for $mysql_table and $mysql_table2.
# The table names, "playerprofile" and "eventdata2d" should stay the
# same in that case though.

# In etadmin.cfg:
# Add the following to your [externals] section:
# stats = addons/vsp_stats.pl "<GUID>" "<COLOR_PLAYER>"

# If you want a in-game "!help stats" command, add the following (all on one line) to [help]:
# stats = ^3Stats: ^7K = kills, D = deaths, K/D = kill / death ratio, 
# ACC = accuracy (percentage),HS-ACC = head shot accuracy (percentage),
# KS = Kill streak, DS = death streak

my $mysql_hostname = "localhost";
my $mysql_username = "CHANGE ME";
my $mysql_password = "CHANGE ME";
my $mysql_database = "CHANGE ME";
my $mysql_table	= "vsp_playerprofile";
my $mysql_table2 = "vsp_eventdata2d";
my $guid = shift or die("No GUID.");
my $name = shift or die("No name.");

use DBI;

# Connect to the database.
my $dbh = DBI->connect(	"DBI:mysql:database=$mysql_database;host=$mysql_hostname" , 
	    "$mysql_username", "$mysql_password", {'RaiseError' => 1})
          or die("Unable to retrieve stats for $name");

$statement =  "select skill, kills, deaths, kill_streak, death_streak, games
		   from $mysql_table where playerID=\"".$guid."\"";


# Now retrieve data from the table.
my $sth = $dbh->prepare( "$statement");
$sth->execute();
my $ref = $sth->fetchrow_arrayref();

if ($sth->rows == 0) {
	print "No stats for $name ^7available ...\n";
	exit;
}

my %stats;
$stats{'skill'} 	= $$ref[0];
$stats{'kills'} 	= $$ref[1];
$stats{'deaths'} 	= $$ref[2];
$stats{'kill_streak'} 	= $$ref[3];
$stats{'death_streak'} 		= $$ref[4];
$stats{'games'}	= $$ref[5];

$sth->finish();

# Get the players current player rank (based on skill).
$statement = "select count(*) as playerRank from $mysql_table
		     where skill > ".$stats{'skill'};
$sth = $dbh->prepare( "$statement" );
$sth->execute();
$ref = $sth->fetchrow_arrayref();
my $rank = ++$$ref[0];
$sth->finish();

$statement = "SELECT SUM(CAST(eventValue AS UNSIGNED)) AS hits from $mysql_table2
              WHERE eventName LIKE '\%hits' AND
              eventCategory=\"accuracy\" AND playerID=\"$guid\"";
$sth = $dbh->prepare( "$statement" );
$sth->execute();
$ref = $sth->fetchrow_arrayref();
my $hits = $$ref[0];
$sth->finish();

$statement = "SELECT SUM(CAST(eventValue AS UNSIGNED)) AS headshots from $mysql_table2
              WHERE eventName LIKE '\%lochead' AND 
              eventCategory=\"accuracy\" AND playerID=\"$guid\"";
$sth = $dbh->prepare( "$statement" );
$sth->execute();
$ref = $sth->fetchrow_arrayref();
my $lochead = $$ref[0];
$sth->finish();

$statement = "SELECT SUM(CAST(eventValue AS UNSIGNED)) AS shots from $mysql_table2
              WHERE eventName LIKE '\%shots' AND 
              eventCategory=\"accuracy\" AND playerID=\"$guid\"";
$sth = $dbh->prepare( "$statement" );
$sth->execute();
$ref = $sth->fetchrow_arrayref();
my $shots = $$ref[0];
$sth->finish();

$dbh->disconnect;

if ( $stats{'deaths'} == 0 ) {
  $kratio = "N/A";
}
else {
  $kratio = int( $stats{'kills'}/$stats{'deaths'} *100 ) / 100;
}

if ( $lochead == 0 ) {
  $hspercent = "N/A";
}
else {
  $hspercent = int( $lochead / $hits * 100 );
} 

if ( $shots == 0 ) {
  $shotpercent = "N/A";
}
else {
  $shotpercent = int( $hits / $shots * 100 );
} 

print "^7Stats for: ".$name."^7: ";
print "^3Rank: ^7".$rank." ";
print "^3Skill: ^7".$stats{'skill'}." ";
print "^3K: ^7".$stats{'kills'}." ";
print "^3D: ^7".$stats{'deaths'}." ";
print "^3K/D: ^7".$kratio." ";
print "^3ACC: ^7".$shotpercent." ";
print "^3HS-ACC: ^7".$hspercent." ";
print "^3KS: ^7".$stats{'kill_streak'}." ";
print "^3DS: ^7".$stats{'death_streak'}." ";
print "^3Games: ^7".$stats{'games'}."\n";

exit;
