#!/usr/bin/perl
#
# vote.pl
# v0.1 by mark davis (20-11-2004)
#
# usage: 
# in etadmin.cfg:
# vote = addons/vote.pl <GUID> <ADMIN_LEVEL> "<PARAMETER>"
# 
# ingame:
# !vote <show|start|end|yes|no>


# who has right to set the level...
my $admin_level = "3";
my $voting_file = "var/voting.dat";
my $votes_file  = "var/votes.dat";


##################################################

#use strict;

my $guid = shift;
my $level = shift;
my $args = shift;
my @data = split (/\s+/,$args);
my $cmd   = lc(shift @data);
my $result = "";

if ($guid) {

	if ($cmd eq "yes") {
		$cmd = "vote"; 
		@data = ("yes");
	}
	if ($cmd eq "no"){
		$cmd = "vote";
		@data = ("no");
	}
	$cmd = "end"      if ($cmd eq "stop");
	$cmd = "start"    if ($cmd eq "new");

	if ($cmd eq "show") {
		if (-s $voting_file) {
			open(IN, $voting_file);
			my $vote = <IN>;
			chomp $vote;
			close(IN);
			
			$result = "Current poll: $vote\n";
		
			my %votes = ();	
			if (-s $votes_file) {
				open(IN, $votes_file);
				while (<IN>) {
					chomp;
					my ($pbid, $vote) = split (':');
					$votes{$vote} ++;
				}
				close(IN);
				$result .= "^3Current result: ^7";
				#foreach $vote (keys %votes) {
				for my $vote (qw (yes no)) {	
					#$result .= "$vote: $votes{$vote}, ";
					$result .= "$vote: ".(defined($votes{$vote})?$votes{$vote}:0).", ";
				}
				$result =~ s/,\s$/. Vote with !vote <yes|no>/;
			}
			else {
				$result .= "^3Current result: ^7Yes: 0, No: 0. Vote with !vote <yes|no>";
			}
		}
		else {
			$result = "There is currently no poll active.";
		}
		
	}
	elsif($cmd eq "end"){
		if ($level >= $admin_level) {
			if (-s $voting_file || -s $votes_file) {
				
				open(IN, $voting_file);
				my $vote = <IN>;
				chomp $vote;
				close(IN);

				$result = "Poll: ^3$vote ^7has ended.\n";
				my %votes = ();
				if ( -s $votes_file) {
					$result .= "Result: ";
					open(IN, $votes_file);
					while (<IN>) {
						chomp;
						my ($pbid, $vote) = split (':');
						$votes{$vote} ++;
					}
					close(IN);

					#foreach $vote (keys %votes) {
					for my $vote (qw (yes no)) {	
						$result .= "$vote: ".(defined($votes{$vote})?$votes{$vote}:0).", ";
					}
					$result =~ s/,\s$/./;
				}
				unlink $voting_file;
				unlink $votes_file;
			}
			else {
				$result = "There is currently no poll active.";
			}
		}
		else {
			$result = "You don't have the permission to delete the poll.";
		}

	}
	elsif($cmd eq "vote"){
		if (!-s $voting_file ) {
			$result = "There is currently no poll active.";
		}
		else {
			my $new_vote = lc(shift @data);
			if ($new_vote eq "no" || $new_vote eq "yes") {
					
				my %votes = ();
				my $found = 0;	
				open(IN, $votes_file);
				while (<IN>) {
					chomp;
					my ($pbid, $vote) = split (':');
					$votes{$vote} ++;
					$found = 1 if ($pbid eq $guid) ;
				}
				close(IN);
	
				if (!$found) {
					open (OUT, ">>$votes_file");
					print OUT "$guid:$new_vote\n";
					close (OUT);
					$votes{$new_vote} ++;

					$result = "You voted: ^3$new_vote ^7on the current poll. ";
					$result .= "^3Current result:^7 ";
					#foreach $vote (keys %votes) {
					for my $vote (qw (yes no)) {	
						$result .= "$vote: ".(defined($votes{$vote})?$votes{$vote}:0).", ";
					}
					$result =~ s/,\s$/./;
					
				}
				else {	
					$result .= "You already voted on the current poll.";
				}
	
			}
			else {
				$result = "Usage: !vote vote <yes|no>";
			}
		}
	}
	elsif($cmd eq "start"){
		if ($level >= $admin_level) {

			my $poll = join (" ", @data);	
			
			if ($poll) {

				$result = "New poll created: ^3$poll^7. Now vote with: !vote <yes|no>";		
	
				unlink $votes_file;

				open(OUT, ">$voting_file");
				print OUT $poll."\n";
				close (OUT);
			}
			else {
				$result = "Usage: !vote start <question>";
			}
		}
		else {
			$result = "You don't have the permission to create a poll.";
		}
	}
	else {
		$result = "Usage: !vote show|vote|start|end|yes|no";
	}

}	
else {
	$result = "Usage: vote.pl <GUID> <ADMIN_LEVEL> \"<start|end|yes|no|vote|show>\"";
}

print "^3vote: ^7".$result."\n";

