#!/usr/bin/perl


# Configuration:
my $mysql_hostname = "servername";
my $mysql_username = "username";
my $mysql_password = "password";
my $mysql_database = "systats_db";

############################################

my $name = shift or die("Kein Name angegeben.");

use DBI;
use strict;

# Connect to the database.
my $dbh = DBI->connect(	"DBI:mysql:database=$mysql_database;host=$mysql_hostname" , 
			"$mysql_username", "$mysql_password", {'RaiseError' => 1});

my $dbhname = $dbh->quote($name);

my $statement = "	select 	t1.PNF_NB_LAST_SCORE, 
			t1.PNF_NB_DAMAGE_RECEIVED, 
			t1.PNF_NB_DAMAGE_GIVEN,
			t2.STA_NB_PLAYTIME, 
			t2.STA_NB_KILLS,
			t2.STA_NB_DEATHS,
			t2.STA_NB_TKILLS,
			t2.STA_NB_TDEATHS  
		from 	SYSTATS_PLAYER_INFOS as t1, 
			SYSTATS_PLAYER_STATS as t2
		where   t1.PNF_ST_NAME = $dbhname and 
			t2.STA_NB_EXTERNAL_TYPE = 0 and
			t1.PNF_REF_NBR = t2.STA_PNF_REF_NBR"; 
			


# Now retrieve data from the table.
my $sth = $dbh->prepare($statement);
$sth->execute();
my $ref = $sth->fetchrow_arrayref;

my %stats;
$stats{'score'} 	= $$ref[0];
$stats{'dmg_rcvd'} 	= $$ref[1];
$stats{'dmg_given'} 	= $$ref[2];
$stats{'playtime'} 	= $$ref[3];
$stats{'kills'} 	= $$ref[4];
$stats{'deaths'} 	= $$ref[5];
$stats{'tkills'} 	= $$ref[6];
$stats{'tdeaths'} 	= $$ref[7];

$sth->finish();
$dbh->disconnect;

my $timeplayed = int($stats{playtime}/60);

my $tkratio;
if ($stats{'tdeaths'} == 0){
        $tkratio = "N/A";
}
else {
        $tkratio = &round($stats{'tkills'}/$stats{'tdeaths'});
}

my $kratio;
if ($stats{'deaths'} == 0){
        $kratio = "N/A";
}
else {
        $kratio = &round($stats{'kills'}/$stats{'deaths'});
}

if ($timeplayed > 300)
{
        my $mins = $timeplayed % 60;
        my $hours = int($timeplayed / 60);
        $timeplayed = $hours."h $mins"."m";
}
else {
        $timeplayed .= " min.";
}

# Bildschirmausgabe...

print "Stats for: $name ^7(Playtime: $timeplayed)\n";
print "K:$stats{'kills'}/D:$stats{'deaths'}/R:$kratio, TK:$stats{'tkills'}/D:$stats{'tdeaths'}/R:$tkratio\n";

#print "K:$stats{'kills'}/D:$stats{'deaths'}/R:".&round($stats{'kills'}/$stats{'death'}).
#   ", TK:$stats{'tkills'}/D:$stats{'tdeaths'}/R:".&round($stats{'tkills'}/$stats{'tdeath'})."\n";


exit;

sub round
{
	my $date = shift;
	return (int($date*100))/100;
}
