#!/usr/bin/perl

use Socket;
use FileHandle;
use POSIX qw(:termios_h);

my $remote_host = shift ||  die("Usage: $0 <server> <port> <username> <password>");
my $remote_port = shift ||  die("Usage: $0 <server> <port> <username> <password>");

my $username = shift || die("Usage: $0 <server> <port> <username> <password>");
my $password = shift || die("Usage: $0 <server> <port> <username> <password>");

my $rin    = '';
my $rout   = '';
my $buffer = '';

my ( $term, $oterm, $echo, $noecho, $fd_stdin );
$fd_stdin = fileno(STDIN);

select STDOUT;
$| = 1;

my $tail_options;
use constant BUFFSIZE => 2**20;

$term = POSIX::Termios->new();
$term->getattr($fd_stdin);
$oterm = $term->getlflag();

$echo   = ECHO | ECHOK | ICANON;
$noecho = $oterm & ~$echo;

socket(TO_SERVER, PF_INET, SOCK_STREAM, getprotobyname('tcp'));
$internet_addr = inet_aton ($remote_host)
	or die ("Konnte $remote_host nicht in eine Internetaddresse umwandeln: $!\n");
$paddr = sockaddr_in($remote_port, $internet_addr);

connect (TO_SERVER, $paddr) or die ("Konnte keine Verbindung zu $remote_host:$remote_port aufbauen\n");
select (TO_SERVER); $| = 1; select (STDOUT);

&cbreak();
$rin = &fhbits('TO_SERVER STDIN');

print TO_SERVER "/identify $username $password\r\n";
print TO_SERVER "/etm 191\r\n";

for ( ;; )
{

    select( $rout = $rin, undef, undef, 1);

    if ( vec( $rout, fileno(STDIN), 1 ) == 1 )
    {
        my $read = sysread( STDIN, $buffer, 1 );
        chomp $buffer;

        #print "STDIN: $buffer - $read\n";
        if ( $buffer ne "" )
        {
	    #print ord($buffer)."\n";
	    if (ord($buffer) == 127 || ord($buffer) == 8) {
		chop $input;
               	print "$buffer" ;
	    }
	    else {
		if (!($buffer =~ s/[^\.\/\w\s'"\[\]\(\)\+\?\^\$\\\|\*:;,\*\#&%=!\<\>-]//g)){
                	print $buffer ;
        		$input .= $buffer;
		}
	    }
        }
        else
        {
	    $input =~ s/[\r\n]//g;
	    print TO_SERVER "$input\r\n";
            print "\n";
            $input = "";
        }
    }
    elsif ( vec( $rout, fileno(TO_SERVER), 1 ) == 1 )
    {
        my $read = sysread( TO_SERVER, $buffer, BUFFSIZE - length $buffer, length $buffer );

	if (!$buffer) {
		close (TO_SERVER);
		die ("Connection gone away");
		#$rin = &fhbits('TO_SERVER STDIN');		
	}
	else {
		#$buffer =~ s/\r?\n?$//;
		$buffer =~ s/\^[^\^]//g;
		my @data = split (/\r?\n/, $buffer);
		for (@data) {
			s/=([\dA-Fa-f][\dA-Fa-f])/pack ("C", hex($1))/eg;
			if (length ($_) > length($input)) {
	        		print "\r$_\n";
			}
			else {
	        		print "\r$_" . ' ' x (length($input) - length($_) ) . "\n";
			}
		}
	        print $input;
	}
    }
    else {
    }
    $buffer = '';
}

close(FH);

exit;

##############
# SUBS

sub fhbits
{

    my (@fhlist) = split( ' ', $_[0] );
    my ($bits);
    for (@fhlist)
    {
        vec( $bits, fileno($_), 1 ) = 1;
    }
    return $bits;
}

sub cbreak
{
    $term->setlflag($noecho);
    $term->setcc( VTIME, 1 );
    $term->setattr( $fd_stdin, TCSANOW );
}

sub cooked
{
    $term->setlflag($oterm);
    $term->setcc( VTIME, 0 );
    $term->setattr( $fd_stdin, TCSANOW );
}

sub getone
{
    my $key = '';
    cbreak();
    sysread( STDIN, $key, 1 );
    cooked();
    return $key;
}

END { cooked() }

